# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SloCorrectionArgs', 'SloCorrection']

@pulumi.input_type
class SloCorrectionArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[_builtins.str],
                 slo_id: pulumi.Input[_builtins.str],
                 start: pulumi.Input[_builtins.int],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 end: Optional[pulumi.Input[_builtins.int]] = None,
                 rrule: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SloCorrection resource.
        :param pulumi.Input[_builtins.str] category: Category the SLO correction belongs to. Valid values are `Scheduled Maintenance`, `Outside Business Hours`, `Deployment`, `Other`.
        :param pulumi.Input[_builtins.str] slo_id: ID of the SLO that this correction will be applied to.
        :param pulumi.Input[_builtins.int] start: Starting time of the correction in epoch seconds.
        :param pulumi.Input[_builtins.str] description: Description of the correction being made.
        :param pulumi.Input[_builtins.int] duration: Length of time in seconds for a specified `rrule` recurring SLO correction (required if specifying `rrule`)
        :param pulumi.Input[_builtins.int] end: Ending time of the correction in epoch seconds. Required for one time corrections, but optional if `rrule` is specified
        :param pulumi.Input[_builtins.str] rrule: Recurrence rules as defined in the iCalendar RFC 5545. Supported rules for SLO corrections are `FREQ`, `INTERVAL`, `COUNT` and `UNTIL`.
        :param pulumi.Input[_builtins.str] timezone: The timezone to display in the UI for the correction times (defaults to "UTC")
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "slo_id", slo_id)
        pulumi.set(__self__, "start", start)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if rrule is not None:
            pulumi.set(__self__, "rrule", rrule)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Input[_builtins.str]:
        """
        Category the SLO correction belongs to. Valid values are `Scheduled Maintenance`, `Outside Business Hours`, `Deployment`, `Other`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="sloId")
    def slo_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the SLO that this correction will be applied to.
        """
        return pulumi.get(self, "slo_id")

    @slo_id.setter
    def slo_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "slo_id", value)

    @_builtins.property
    @pulumi.getter
    def start(self) -> pulumi.Input[_builtins.int]:
        """
        Starting time of the correction in epoch seconds.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "start", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the correction being made.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Length of time in seconds for a specified `rrule` recurring SLO correction (required if specifying `rrule`)
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Ending time of the correction in epoch seconds. Required for one time corrections, but optional if `rrule` is specified
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "end", value)

    @_builtins.property
    @pulumi.getter
    def rrule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Recurrence rules as defined in the iCalendar RFC 5545. Supported rules for SLO corrections are `FREQ`, `INTERVAL`, `COUNT` and `UNTIL`.
        """
        return pulumi.get(self, "rrule")

    @rrule.setter
    def rrule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rrule", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timezone to display in the UI for the correction times (defaults to "UTC")
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)


@pulumi.input_type
class _SloCorrectionState:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 end: Optional[pulumi.Input[_builtins.int]] = None,
                 rrule: Optional[pulumi.Input[_builtins.str]] = None,
                 slo_id: Optional[pulumi.Input[_builtins.str]] = None,
                 start: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SloCorrection resources.
        :param pulumi.Input[_builtins.str] category: Category the SLO correction belongs to. Valid values are `Scheduled Maintenance`, `Outside Business Hours`, `Deployment`, `Other`.
        :param pulumi.Input[_builtins.str] description: Description of the correction being made.
        :param pulumi.Input[_builtins.int] duration: Length of time in seconds for a specified `rrule` recurring SLO correction (required if specifying `rrule`)
        :param pulumi.Input[_builtins.int] end: Ending time of the correction in epoch seconds. Required for one time corrections, but optional if `rrule` is specified
        :param pulumi.Input[_builtins.str] rrule: Recurrence rules as defined in the iCalendar RFC 5545. Supported rules for SLO corrections are `FREQ`, `INTERVAL`, `COUNT` and `UNTIL`.
        :param pulumi.Input[_builtins.str] slo_id: ID of the SLO that this correction will be applied to.
        :param pulumi.Input[_builtins.int] start: Starting time of the correction in epoch seconds.
        :param pulumi.Input[_builtins.str] timezone: The timezone to display in the UI for the correction times (defaults to "UTC")
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if rrule is not None:
            pulumi.set(__self__, "rrule", rrule)
        if slo_id is not None:
            pulumi.set(__self__, "slo_id", slo_id)
        if start is not None:
            pulumi.set(__self__, "start", start)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Category the SLO correction belongs to. Valid values are `Scheduled Maintenance`, `Outside Business Hours`, `Deployment`, `Other`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the correction being made.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Length of time in seconds for a specified `rrule` recurring SLO correction (required if specifying `rrule`)
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Ending time of the correction in epoch seconds. Required for one time corrections, but optional if `rrule` is specified
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "end", value)

    @_builtins.property
    @pulumi.getter
    def rrule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Recurrence rules as defined in the iCalendar RFC 5545. Supported rules for SLO corrections are `FREQ`, `INTERVAL`, `COUNT` and `UNTIL`.
        """
        return pulumi.get(self, "rrule")

    @rrule.setter
    def rrule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rrule", value)

    @_builtins.property
    @pulumi.getter(name="sloId")
    def slo_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the SLO that this correction will be applied to.
        """
        return pulumi.get(self, "slo_id")

    @slo_id.setter
    def slo_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slo_id", value)

    @_builtins.property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Starting time of the correction in epoch seconds.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timezone to display in the UI for the correction times (defaults to "UTC")
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)


@pulumi.type_token("datadog:index/sloCorrection:SloCorrection")
class SloCorrection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 end: Optional[pulumi.Input[_builtins.int]] = None,
                 rrule: Optional[pulumi.Input[_builtins.str]] = None,
                 slo_id: Optional[pulumi.Input[_builtins.str]] = None,
                 start: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for interacting with the slo_correction API.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create a new Datadog SLO correction. slo_id can be derived from slo resource or specify an slo id of an existing SLO.
        example_slo = datadog.ServiceLevelObjective("example_slo",
            name="example slo",
            type="metric",
            description="some updated description about example_slo SLO",
            query={
                "numerator": "sum:my.metric{type:good}.as_count()",
                "denominator": "sum:my.metric{type:good}.as_count() + sum:my.metric{type:bad}.as_count()",
            },
            thresholds=[{
                "timeframe": "7d",
                "target": 99.5,
                "warning": 99.8,
            }],
            tags=["foo:bar"])
        example_slo_correction = datadog.SloCorrection("example_slo_correction",
            category="Scheduled Maintenance",
            description="correction example",
            start=1735707000,
            end=1735718600,
            slo_id=example_slo.id,
            timezone="UTC")
        example_slo_correction_with_recurrence = datadog.SloCorrection("example_slo_correction_with_recurrence",
            category="Scheduled Maintenance",
            description="correction example with recurrence",
            start=1735707000,
            rrule="FREQ=DAILY;INTERVAL=3;COUNT=3",
            duration=3600,
            slo_id=example_slo.id,
            timezone="UTC")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/sloCorrection:SloCorrection testing_slo_correction 11111111-3fee-11eb-8a13-77cd9f15119e
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category: Category the SLO correction belongs to. Valid values are `Scheduled Maintenance`, `Outside Business Hours`, `Deployment`, `Other`.
        :param pulumi.Input[_builtins.str] description: Description of the correction being made.
        :param pulumi.Input[_builtins.int] duration: Length of time in seconds for a specified `rrule` recurring SLO correction (required if specifying `rrule`)
        :param pulumi.Input[_builtins.int] end: Ending time of the correction in epoch seconds. Required for one time corrections, but optional if `rrule` is specified
        :param pulumi.Input[_builtins.str] rrule: Recurrence rules as defined in the iCalendar RFC 5545. Supported rules for SLO corrections are `FREQ`, `INTERVAL`, `COUNT` and `UNTIL`.
        :param pulumi.Input[_builtins.str] slo_id: ID of the SLO that this correction will be applied to.
        :param pulumi.Input[_builtins.int] start: Starting time of the correction in epoch seconds.
        :param pulumi.Input[_builtins.str] timezone: The timezone to display in the UI for the correction times (defaults to "UTC")
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SloCorrectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for interacting with the slo_correction API.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create a new Datadog SLO correction. slo_id can be derived from slo resource or specify an slo id of an existing SLO.
        example_slo = datadog.ServiceLevelObjective("example_slo",
            name="example slo",
            type="metric",
            description="some updated description about example_slo SLO",
            query={
                "numerator": "sum:my.metric{type:good}.as_count()",
                "denominator": "sum:my.metric{type:good}.as_count() + sum:my.metric{type:bad}.as_count()",
            },
            thresholds=[{
                "timeframe": "7d",
                "target": 99.5,
                "warning": 99.8,
            }],
            tags=["foo:bar"])
        example_slo_correction = datadog.SloCorrection("example_slo_correction",
            category="Scheduled Maintenance",
            description="correction example",
            start=1735707000,
            end=1735718600,
            slo_id=example_slo.id,
            timezone="UTC")
        example_slo_correction_with_recurrence = datadog.SloCorrection("example_slo_correction_with_recurrence",
            category="Scheduled Maintenance",
            description="correction example with recurrence",
            start=1735707000,
            rrule="FREQ=DAILY;INTERVAL=3;COUNT=3",
            duration=3600,
            slo_id=example_slo.id,
            timezone="UTC")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/sloCorrection:SloCorrection testing_slo_correction 11111111-3fee-11eb-8a13-77cd9f15119e
        ```

        :param str resource_name: The name of the resource.
        :param SloCorrectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SloCorrectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 end: Optional[pulumi.Input[_builtins.int]] = None,
                 rrule: Optional[pulumi.Input[_builtins.str]] = None,
                 slo_id: Optional[pulumi.Input[_builtins.str]] = None,
                 start: Optional[pulumi.Input[_builtins.int]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SloCorrectionArgs.__new__(SloCorrectionArgs)

            if category is None and not opts.urn:
                raise TypeError("Missing required property 'category'")
            __props__.__dict__["category"] = category
            __props__.__dict__["description"] = description
            __props__.__dict__["duration"] = duration
            __props__.__dict__["end"] = end
            __props__.__dict__["rrule"] = rrule
            if slo_id is None and not opts.urn:
                raise TypeError("Missing required property 'slo_id'")
            __props__.__dict__["slo_id"] = slo_id
            if start is None and not opts.urn:
                raise TypeError("Missing required property 'start'")
            __props__.__dict__["start"] = start
            __props__.__dict__["timezone"] = timezone
        super(SloCorrection, __self__).__init__(
            'datadog:index/sloCorrection:SloCorrection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            duration: Optional[pulumi.Input[_builtins.int]] = None,
            end: Optional[pulumi.Input[_builtins.int]] = None,
            rrule: Optional[pulumi.Input[_builtins.str]] = None,
            slo_id: Optional[pulumi.Input[_builtins.str]] = None,
            start: Optional[pulumi.Input[_builtins.int]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None) -> 'SloCorrection':
        """
        Get an existing SloCorrection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category: Category the SLO correction belongs to. Valid values are `Scheduled Maintenance`, `Outside Business Hours`, `Deployment`, `Other`.
        :param pulumi.Input[_builtins.str] description: Description of the correction being made.
        :param pulumi.Input[_builtins.int] duration: Length of time in seconds for a specified `rrule` recurring SLO correction (required if specifying `rrule`)
        :param pulumi.Input[_builtins.int] end: Ending time of the correction in epoch seconds. Required for one time corrections, but optional if `rrule` is specified
        :param pulumi.Input[_builtins.str] rrule: Recurrence rules as defined in the iCalendar RFC 5545. Supported rules for SLO corrections are `FREQ`, `INTERVAL`, `COUNT` and `UNTIL`.
        :param pulumi.Input[_builtins.str] slo_id: ID of the SLO that this correction will be applied to.
        :param pulumi.Input[_builtins.int] start: Starting time of the correction in epoch seconds.
        :param pulumi.Input[_builtins.str] timezone: The timezone to display in the UI for the correction times (defaults to "UTC")
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SloCorrectionState.__new__(_SloCorrectionState)

        __props__.__dict__["category"] = category
        __props__.__dict__["description"] = description
        __props__.__dict__["duration"] = duration
        __props__.__dict__["end"] = end
        __props__.__dict__["rrule"] = rrule
        __props__.__dict__["slo_id"] = slo_id
        __props__.__dict__["start"] = start
        __props__.__dict__["timezone"] = timezone
        return SloCorrection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        Category the SLO correction belongs to. Valid values are `Scheduled Maintenance`, `Outside Business Hours`, `Deployment`, `Other`.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the correction being made.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Length of time in seconds for a specified `rrule` recurring SLO correction (required if specifying `rrule`)
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def end(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Ending time of the correction in epoch seconds. Required for one time corrections, but optional if `rrule` is specified
        """
        return pulumi.get(self, "end")

    @_builtins.property
    @pulumi.getter
    def rrule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Recurrence rules as defined in the iCalendar RFC 5545. Supported rules for SLO corrections are `FREQ`, `INTERVAL`, `COUNT` and `UNTIL`.
        """
        return pulumi.get(self, "rrule")

    @_builtins.property
    @pulumi.getter(name="sloId")
    def slo_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the SLO that this correction will be applied to.
        """
        return pulumi.get(self, "slo_id")

    @_builtins.property
    @pulumi.getter
    def start(self) -> pulumi.Output[_builtins.int]:
        """
        Starting time of the correction in epoch seconds.
        """
        return pulumi.get(self, "start")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The timezone to display in the UI for the correction times (defaults to "UTC")
        """
        return pulumi.get(self, "timezone")

