# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpansMetricArgs', 'SpansMetric']

@pulumi.input_type
class SpansMetricArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 compute: Optional[pulumi.Input['SpansMetricComputeArgs']] = None,
                 filter: Optional[pulumi.Input['SpansMetricFilterArgs']] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input['SpansMetricGroupByArgs']]]] = None):
        """
        The set of arguments for constructing a SpansMetric resource.
        :param pulumi.Input[_builtins.str] name: The name of the span-based metric. This field can't be updated after creation.
        """
        pulumi.set(__self__, "name", name)
        if compute is not None:
            pulumi.set(__self__, "compute", compute)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the span-based metric. This field can't be updated after creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def compute(self) -> Optional[pulumi.Input['SpansMetricComputeArgs']]:
        return pulumi.get(self, "compute")

    @compute.setter
    def compute(self, value: Optional[pulumi.Input['SpansMetricComputeArgs']]):
        pulumi.set(self, "compute", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['SpansMetricFilterArgs']]:
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['SpansMetricFilterArgs']]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpansMetricGroupByArgs']]]]:
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpansMetricGroupByArgs']]]]):
        pulumi.set(self, "group_bies", value)


@pulumi.input_type
class _SpansMetricState:
    def __init__(__self__, *,
                 compute: Optional[pulumi.Input['SpansMetricComputeArgs']] = None,
                 filter: Optional[pulumi.Input['SpansMetricFilterArgs']] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input['SpansMetricGroupByArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpansMetric resources.
        :param pulumi.Input[_builtins.str] name: The name of the span-based metric. This field can't be updated after creation.
        """
        if compute is not None:
            pulumi.set(__self__, "compute", compute)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def compute(self) -> Optional[pulumi.Input['SpansMetricComputeArgs']]:
        return pulumi.get(self, "compute")

    @compute.setter
    def compute(self, value: Optional[pulumi.Input['SpansMetricComputeArgs']]):
        pulumi.set(self, "compute", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['SpansMetricFilterArgs']]:
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['SpansMetricFilterArgs']]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpansMetricGroupByArgs']]]]:
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpansMetricGroupByArgs']]]]):
        pulumi.set(self, "group_bies", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the span-based metric. This field can't be updated after creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("datadog:index/spansMetric:SpansMetric")
class SpansMetric(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute: Optional[pulumi.Input[Union['SpansMetricComputeArgs', 'SpansMetricComputeArgsDict']]] = None,
                 filter: Optional[pulumi.Input[Union['SpansMetricFilterArgs', 'SpansMetricFilterArgsDict']]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpansMetricGroupByArgs', 'SpansMetricGroupByArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog SpansMetric resource. This can be used to create and manage Datadog spans_metric.

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/spansMetric:SpansMetric testing_spans_metric testing.span.metric
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the span-based metric. This field can't be updated after creation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpansMetricArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog SpansMetric resource. This can be used to create and manage Datadog spans_metric.

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/spansMetric:SpansMetric testing_spans_metric testing.span.metric
        ```

        :param str resource_name: The name of the resource.
        :param SpansMetricArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpansMetricArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute: Optional[pulumi.Input[Union['SpansMetricComputeArgs', 'SpansMetricComputeArgsDict']]] = None,
                 filter: Optional[pulumi.Input[Union['SpansMetricFilterArgs', 'SpansMetricFilterArgsDict']]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpansMetricGroupByArgs', 'SpansMetricGroupByArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpansMetricArgs.__new__(SpansMetricArgs)

            __props__.__dict__["compute"] = compute
            __props__.__dict__["filter"] = filter
            __props__.__dict__["group_bies"] = group_bies
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
        super(SpansMetric, __self__).__init__(
            'datadog:index/spansMetric:SpansMetric',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compute: Optional[pulumi.Input[Union['SpansMetricComputeArgs', 'SpansMetricComputeArgsDict']]] = None,
            filter: Optional[pulumi.Input[Union['SpansMetricFilterArgs', 'SpansMetricFilterArgsDict']]] = None,
            group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpansMetricGroupByArgs', 'SpansMetricGroupByArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'SpansMetric':
        """
        Get an existing SpansMetric resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the span-based metric. This field can't be updated after creation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpansMetricState.__new__(_SpansMetricState)

        __props__.__dict__["compute"] = compute
        __props__.__dict__["filter"] = filter
        __props__.__dict__["group_bies"] = group_bies
        __props__.__dict__["name"] = name
        return SpansMetric(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def compute(self) -> pulumi.Output[Optional['outputs.SpansMetricCompute']]:
        return pulumi.get(self, "compute")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional['outputs.SpansMetricFilter']]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> pulumi.Output[Optional[Sequence['outputs.SpansMetricGroupBy']]]:
        return pulumi.get(self, "group_bies")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the span-based metric. This field can't be updated after creation.
        """
        return pulumi.get(self, "name")

