"""OpenTelemetry instrumented wrapper for Gemini Python SDK.

This file was auto-generated by the AI SDK Wrapper Code Generator:
https://github.com/paid-ai/sdk-wrapper-codegen
"""

from typing import Union

from opentelemetry import trace
from opentelemetry.trace import Status, StatusCode

from paid.tracing.tracing import (
    get_paid_tracer,
    logger,
    paid_external_agent_id_var,
    paid_external_customer_id_var,
    paid_token_var,
)

try:
    from google import genai
    from google.genai.types import GenerateContentResponse
except ImportError:
    raise ImportError(
        "google-genai package is a peer-dependency. To use the Paid wrapper around google-genai "
        "you're assumed to already have google-genai package installed."
    )


class PaidGemini:
    """OpenTelemetry instrumented wrapper for Gemini Python SDK SDK."""

    def __init__(self, original_client: genai.Client, optional_tracing: bool = False):
        self._client = original_client
        self.tracer = get_paid_tracer()
        self.optional_tracing = optional_tracing

    @property
    def models(self):
        """Access models with OTEL instrumentation."""
        return ModelsWrapper(self._client, self.tracer, self.optional_tracing)


class ModelsWrapper:
    """Wrapper for models with OTEL instrumentation."""

    def __init__(self, original_client: genai.Client, tracer: trace.Tracer, optional_tracing: bool):
        self._client = original_client
        self.tracer = tracer
        self.optional_tracing = optional_tracing

    def generate_content(self, **kwargs) -> GenerateContentResponse:
        """GenerateContentResponse method with OTEL instrumentation."""
        # Check if tracing is active (optional tracing mode)
        current_span = trace.get_current_span()
        if current_span == trace.INVALID_SPAN:
            if self.optional_tracing:
                logger.info(f"{self.__class__.__name__} No tracing wasn't enabled, only calling the client.")
                return self._client.models.generate_content(**kwargs)
            raise RuntimeError("No OTEL span found. Make sure to call this method from Paid.trace().")

        external_customer_id = paid_external_customer_id_var.get()
        external_agent_id = paid_external_agent_id_var.get()
        token = paid_token_var.get()

        if not (external_customer_id and token):
            if self.optional_tracing:
                logger.info(
                    f"{self.__class__.__name__} No external_customer_id or token, so no tracing, only calling the client."
                )
                return self._client.models.generate_content(**kwargs)
            raise RuntimeError(
                "Missing required tracing information: external_customer_id or token."
                " Make sure to call this method from Paid.trace()."
            )

        with self.tracer.start_as_current_span("gemini.models.generate_content") as span:
            try:
                # Execute the original method
                response = self._client.models.generate_content(**kwargs)
                if response.usage_metadata is None:
                    # unnecessary but need this for type checker
                    raise ValueError("Response usage metadata is None. Ensure the response contains usage metadata.")

                # Set OTEL attributes (best-effort)
                attributes: dict[str, Union[str, int]] = {}
                attributes["external_customer_id"] = external_customer_id
                attributes["token"] = token
                if external_agent_id:
                    attributes["external_agent_id"] = external_agent_id

                attributes["gen_ai.system"] = "gemini"
                attributes["gen_ai.operation.name"] = "generate_content"
                try:
                    value: Union[str, int, None] = response.model_version
                    if value is not None:
                        attributes["gen_ai.response.model"] = value
                except (AttributeError, KeyError, TypeError):
                    pass
                try:
                    value = response.usage_metadata.prompt_token_count
                    if value is not None:
                        attributes["gen_ai.usage.input_tokens"] = value
                except (AttributeError, KeyError, TypeError):
                    pass
                try:
                    value = response.usage_metadata.candidates_token_count
                    if value is not None:
                        attributes["gen_ai.usage.output_tokens"] = value
                except (AttributeError, KeyError, TypeError):
                    pass
                try:
                    value = response.usage_metadata.cached_content_token_count
                    if value is not None:
                        attributes["gen_ai.usage.cached_input_tokens"] = value
                except (AttributeError, KeyError, TypeError):
                    pass
                try:
                    value = response.usage_metadata.thoughts_token_count
                    if value is not None:
                        attributes["gen_ai.usage.reasoning_output_tokens"] = value
                except (AttributeError, KeyError, TypeError):
                    pass

                span.set_attributes(attributes)
                span.set_status(Status(StatusCode.OK))
                return response

            except Exception as e:
                # Record exception in span
                span.record_exception(e)
                span.set_status(Status(StatusCode.ERROR, str(e)))
                raise
