# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class EntitlementUsage(UniversalBaseModel):
    """
    Tracks the usage of an entitlement for a customer
    """

    id: str
    created_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="createdAt")] = None
    updated_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="updatedAt")] = None
    organization_id: typing_extensions.Annotated[str, FieldMetadata(alias="organizationId")]
    product_id: typing_extensions.Annotated[str, FieldMetadata(alias="productId")]
    entitlement_id: typing_extensions.Annotated[str, FieldMetadata(alias="entitlementId")]
    customer_id: typing_extensions.Annotated[str, FieldMetadata(alias="customerId")]
    start_date: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="startDate")]
    end_date: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="endDate")] = None
    total: int = pydantic.Field()
    """
    Total entitlement amount
    """

    available: int = pydantic.Field()
    """
    Available entitlement amount
    """

    used: int = pydantic.Field()
    """
    Used entitlement amount
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
