# coding: utf-8

"""
    Infrahub-API

    Leverage the Infrahub API and Hyperstack platform to easily create, manage, and scale powerful GPU virtual machines and their associated resources.   Access this SDK to automate the deployment of your workloads and streamline your infrastructure management.  To contribute, please raise an issue with a bug report, feature request, feedback, or general inquiry.

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from ..models.create_cluster_node_group_payload import CreateClusterNodeGroupPayload
from typing import Optional, Set
from typing_extensions import Self

class CreateClusterPayload(BaseModel):
    """
    CreateClusterPayload
    """ # noqa: E501
    deployment_mode: Optional[StrictStr] = 'full'
    environment_name: StrictStr
    keypair_name: StrictStr
    kubernetes_version: StrictStr
    master_count: Optional[Annotated[int, Field(le=3, strict=True, ge=2)]] = None
    master_flavor_name: StrictStr
    name: StrictStr
    node_count: Optional[StrictInt] = None
    node_flavor_name: Optional[StrictStr] = None
    node_groups: Optional[List[CreateClusterNodeGroupPayload]] = None
    __properties: ClassVar[List[str]] = ["deployment_mode", "environment_name", "keypair_name", "kubernetes_version", "master_count", "master_flavor_name", "name", "node_count", "node_flavor_name", "node_groups"]

    @field_validator('deployment_mode')
    def deployment_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['full', 'standard']):
            raise ValueError("must be one of enum values ('full', 'standard')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateClusterPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in node_groups (list)
        _items = []
        if self.node_groups:
            for _item_node_groups in self.node_groups:
                if _item_node_groups:
                    _items.append(_item_node_groups.to_dict())
            _dict['node_groups'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateClusterPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "deployment_mode": obj.get("deployment_mode") if obj.get("deployment_mode") is not None else 'full',
            "environment_name": obj.get("environment_name"),
            "keypair_name": obj.get("keypair_name"),
            "kubernetes_version": obj.get("kubernetes_version"),
            "master_count": obj.get("master_count"),
            "master_flavor_name": obj.get("master_flavor_name"),
            "name": obj.get("name"),
            "node_count": obj.get("node_count"),
            "node_flavor_name": obj.get("node_flavor_name"),
            "node_groups": [CreateClusterNodeGroupPayload.from_dict(_item) for _item in obj["node_groups"]] if obj.get("node_groups") is not None else None
        })
        return _obj


