# coding: utf-8

"""
    Infrahub-API

    Leverage the Infrahub API and Hyperstack platform to easily create, manage, and scale powerful GPU virtual machines and their associated resources.   Access this SDK to automate the deployment of your workloads and streamline your infrastructure management.  To contribute, please raise an issue with a bug report, feature request, feedback, or general inquiry.

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SnapshotRetrieveFields(BaseModel):
    """
    SnapshotRetrieveFields
    """ # noqa: E501
    created_at: datetime = Field(description="Creation timestamp")
    custom_image: Optional[StrictStr] = None
    description: StrictStr = Field(description="Description of the snapshot")
    has_floating_ip: Optional[StrictBool] = Field(default=None, description="Indicates if the VM had a floating IP assigned")
    id: StrictInt = Field(description="Snapshot ID")
    is_image: StrictBool = Field(description="Indicates if the snapshot is an image")
    labels: Optional[StrictStr] = None
    name: StrictStr = Field(description="Snapshot name")
    region: Optional[StrictStr] = None
    region_id: StrictInt = Field(description="Region where the snapshot will be available")
    size: StrictInt = Field(description="Size in GB of the snapshot")
    status: StrictStr = Field(description="Status of the snapshot")
    updated_at: datetime = Field(description="Last update timestamp")
    vm_environment: Optional[StrictStr] = None
    vm_flavor: Optional[StrictStr] = None
    vm_id: StrictInt = Field(description="ID of the VM from which the snapshot is created")
    vm_image: Optional[StrictStr] = None
    vm_keypair: Optional[StrictStr] = None
    vm_name: Optional[StrictStr] = None
    vm_status: Optional[StrictStr] = None
    volume_id: Optional[StrictStr] = None
    volume_name: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["created_at", "custom_image", "description", "has_floating_ip", "id", "is_image", "labels", "name", "region", "region_id", "size", "status", "updated_at", "vm_environment", "vm_flavor", "vm_id", "vm_image", "vm_keypair", "vm_name", "vm_status", "volume_id", "volume_name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SnapshotRetrieveFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SnapshotRetrieveFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "custom_image": obj.get("custom_image"),
            "description": obj.get("description"),
            "has_floating_ip": obj.get("has_floating_ip"),
            "id": obj.get("id"),
            "is_image": obj.get("is_image"),
            "labels": obj.get("labels"),
            "name": obj.get("name"),
            "region": obj.get("region"),
            "region_id": obj.get("region_id"),
            "size": obj.get("size"),
            "status": obj.get("status"),
            "updated_at": obj.get("updated_at"),
            "vm_environment": obj.get("vm_environment"),
            "vm_flavor": obj.get("vm_flavor"),
            "vm_id": obj.get("vm_id"),
            "vm_image": obj.get("vm_image"),
            "vm_keypair": obj.get("vm_keypair"),
            "vm_name": obj.get("vm_name"),
            "vm_status": obj.get("vm_status"),
            "volume_id": obj.get("volume_id"),
            "volume_name": obj.get("volume_name")
        })
        return _obj


