# coding: utf-8

"""
    Infrahub-API

    Leverage the Infrahub API and Hyperstack platform to easily create, manage, and scale powerful GPU virtual machines and their associated resources.   Access this SDK to automate the deployment of your workloads and streamline your infrastructure management.  To contribute, please raise an issue with a bug report, feature request, feedback, or general inquiry.

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ..models.attachments_fields_for_volume import AttachmentsFieldsForVolume
from ..models.environment_fields_for_volume import EnvironmentFieldsForVolume
from typing import Optional, Set
from typing_extensions import Self

class VolumeFields(BaseModel):
    """
    VolumeFields
    """ # noqa: E501
    attachments: Optional[List[AttachmentsFieldsForVolume]] = None
    bootable: Optional[StrictBool] = None
    callback_url: Optional[StrictStr] = None
    created_at: Optional[datetime] = None
    description: Optional[StrictStr] = None
    environment: Optional[EnvironmentFieldsForVolume] = None
    id: Optional[StrictInt] = None
    image_id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    os_image: Optional[StrictStr] = None
    size: Optional[StrictInt] = None
    status: Optional[StrictStr] = None
    updated_at: Optional[datetime] = None
    volume_type: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["attachments", "bootable", "callback_url", "created_at", "description", "environment", "id", "image_id", "name", "os_image", "size", "status", "updated_at", "volume_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VolumeFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item_attachments in self.attachments:
                if _item_attachments:
                    _items.append(_item_attachments.to_dict())
            _dict['attachments'] = _items
        # override the default output from pydantic by calling `to_dict()` of environment
        if self.environment:
            _dict['environment'] = self.environment.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VolumeFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attachments": [AttachmentsFieldsForVolume.from_dict(_item) for _item in obj["attachments"]] if obj.get("attachments") is not None else None,
            "bootable": obj.get("bootable"),
            "callback_url": obj.get("callback_url"),
            "created_at": obj.get("created_at"),
            "description": obj.get("description"),
            "environment": EnvironmentFieldsForVolume.from_dict(obj["environment"]) if obj.get("environment") is not None else None,
            "id": obj.get("id"),
            "image_id": obj.get("image_id"),
            "name": obj.get("name"),
            "os_image": obj.get("os_image"),
            "size": obj.get("size"),
            "status": obj.get("status"),
            "updated_at": obj.get("updated_at"),
            "volume_type": obj.get("volume_type")
        })
        return _obj


