# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.client_facing_profile import ClientFacingProfile
from ..types.raw_profile import RawProfile
from .raw_client import AsyncRawProfileClient, RawProfileClient


class ProfileClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawProfileClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawProfileClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawProfileClient
        """
        return self._raw_client

    def get(
        self,
        user_id: str,
        *,
        provider: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingProfile:
        """
        Get profile for user_id

        Parameters
        ----------
        user_id : str

        provider : typing.Optional[str]
            Provider oura/strava etc

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingProfile
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.profile.get(user_id='user_id', )
        """
        _response = self._raw_client.get(user_id, provider=provider, request_options=request_options)
        return _response.data

    def get_raw(
        self,
        user_id: str,
        *,
        provider: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RawProfile:
        """
        Get raw profile for user_id

        Parameters
        ----------
        user_id : str

        provider : typing.Optional[str]
            Provider oura/strava etc

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RawProfile
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.profile.get_raw(user_id='user_id', )
        """
        _response = self._raw_client.get_raw(user_id, provider=provider, request_options=request_options)
        return _response.data


class AsyncProfileClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawProfileClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawProfileClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawProfileClient
        """
        return self._raw_client

    async def get(
        self,
        user_id: str,
        *,
        provider: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingProfile:
        """
        Get profile for user_id

        Parameters
        ----------
        user_id : str

        provider : typing.Optional[str]
            Provider oura/strava etc

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingProfile
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.profile.get(user_id='user_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(user_id, provider=provider, request_options=request_options)
        return _response.data

    async def get_raw(
        self,
        user_id: str,
        *,
        provider: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RawProfile:
        """
        Get raw profile for user_id

        Parameters
        ----------
        user_id : str

        provider : typing.Optional[str]
            Provider oura/strava etc

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RawProfile
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.profile.get_raw(user_id='user_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_raw(user_id, provider=provider, request_options=request_options)
        return _response.data
