# SVR_TTS

Библиотека для нейросетевого синтеза речи с использованием нескольких ONNX-моделей. С её помощью можно генерировать озвучку текста, учитывая тембр и просодию. Все модели автоматически скачиваются с Hugging Face, а токенизация происходит через REST-сервис.

---

## Что умеет библиотека

- **Мульти-модельный синтез:** базовая, семантическая, кодировочная, оценочная и вокодерная модели работают вместе для получения качественной озвучки.
- **Плавное соединение сегментов:** используется кроссфейд для гладкого склеивания аудиофрагментов.
- **Поддержка кастомизации:** можно задавать длительность или скорость речи.
- **Автоматическая загрузка моделей:** модели скачиваются из репозитория Hugging Face при первом запуске.

---

## Требования и установка

### Зависимости

Для работы библиотеки требуется:
- Python 3.6+
- onnxruntime-gpu – для инференса ONNX-моделей
- numpy – для числовых операций
- huggingface_hub – для скачивания моделей
- appdirs – для работы с кэшированием
- tqdm – для отображения прогресс-баров

Также в примере используется:
- resampy и soundfile – для ресемплинга и записи аудио.

### Установка

Установка через pip (после упаковки библиотеки):

pip install git+https://github.com/Selectorrr/svr_tts.git

Смотри setup.py для подробностей по пакету.

---

## Быстрый старт

1. Импортируй класс и подготовь данные

   from svr_tts import SVR_TTS  
   from svr_tts.core import SynthesisInput

2. Создай объект синтеза с API-ключом [можно получить тут](https://t.me/SynthVoiceRuBot)

   tts = SVR_TTS(api_key="твой_api_ключ")

3. Подготовь аудио для тембра и просодии

   Чаще всего используются одни и те же аудиоданные, но можно задать разные:

   import soundfile, resampy

   wave, sr = soundfile.read('tmp/example.ogg')  
   wave_24k = resampy.resample(wave, sr, 24000)

4. Запусти синтез

   inputs = [
       SynthesisInput(text="Привет, это SVR_TTS!", stress=True, timbre_wave_24k=wave_24k, prosody_wave_24k=wave_24k)
   ]  
   audios = tts.synthesize_batch(inputs)

5. Сохрани результат

   soundfile.write('tmp/example.wav', audios[0], 22050)

   Полный пример можно найти в example.py.

---

## Детали реализации

### Основной класс: SVR_TTS

- Инициализация:  
  Скачивает модели из репозитория "selectorrrr/svr-tts-large-v1" и создаёт инференс-сессии через onnxruntime.  
  Смотри реализацию в core.py.

- Метод synthesize_batch:  
  Принимает список объектов SynthesisInput (который включает текст, флаг ударений и аудиоданные для тембра/просодии). Метод выполняет:
  - Запрос к REST-сервису токенизации.
  - Вычисление базовых признаков с помощью базовой модели.
  - Получение семантических признаков через отдельную модель.
  - Кодирование и генерацию аудио сегментов с использованием кодировщика и оценочной модели.
  - Склейку сегментов с помощью функции кроссфейда для плавного перехода.

- Подробности:
  - SynthesisInput:  
    Структура, содержащая:
    • text – исходный текст  
    • stress – использование ударений  
    • timbre_wave_24k и prosody_wave_24k – numpy-массивы аудиоданных с частотой 24 кГц.
  - Кроссфейд:  
    Функция _crossfade отвечает за плавное соединение аудиофрагментов с перекрытием в 4096 сэмплов.
  - Токенизация:  
    Выполняется запросом к сервису по адресу "https://synthvoice.ru/tokenize_batch" (можно переопределить).

---

## Конфигурация и параметры

При вызове synthesize_batch можно задать:
- duration_or_speed:  
  Если не указан is_speed, рассчитывается длительность на основе длины аудио для просодии.
- scaling_min / scaling_max:  
  Коэффициенты масштабирования для регулировки параметров синтеза.

---

## Лицензия

Проект распространяется под Apache License 2.0 (http://www.apache.org/licenses/LICENSE-2.0).  
Подробнее смотри в файлах заголовков каждого модуля, например __init__.py и setup.py.

---

## Что дальше?

Если что-то не понятно или возникают проблемы:
- Проверь, что модели скачиваются корректно (имеется кэширование в user_cache_dir).
- Убедись, что REST-сервис токенизации доступен.
- Пиши свои идеи и коммиты – всегда рады фидбэку!

---

Удачного синтеза, экспериментируй!
