# Asterix specifications

# This file is generated, DO NOT EDIT!
# For more details, see:
#     - https://github.com/zoranbosnjak/asterix-specs

from asterix.base import *

asterix_specs_ref = "git:bd9a2d1a7af0f03c4f61e2409486c4a305b80a3c"
asterix_specs_date = "2025-01-10T13:49:47+01:00"
code_generator_version = "0.4.1"

# Asterix types

class Content_0(ContentRaw):
    cv_arg: TypeAlias = int

class RuleContent_0(RuleContentContextFree):
    cv_arg: TypeAlias = Content_0.cv_arg
    cv_content: TypeAlias = Content_0

    @property
    def content(self) -> Content_0:
        return self._get_content() # type: ignore

class Variation_165(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_165.cv_arg") -> "Variation_165":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_159(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_165.cv_arg
    cv_variation: TypeAlias = Variation_165

    @classmethod
    def create(cls, arg : "RuleVariation_159.cv_arg") -> "RuleVariation_159":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_165:
        return self.arg # type: ignore

class NonSpare_1655(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "SAC"
    cv_title = "System Area Code"
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_1655.cv_arg") -> "NonSpare_1655":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class Item_856(Item):
    cv_arg: TypeAlias = NonSpare_1655.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1655

    @classmethod
    def create(cls, arg : "Item_856.cv_arg") -> "Item_856":
        return cls._create(arg) # type: ignore

class NonSpare_1710(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "SIC"
    cv_title = "System Identification Code"
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_1710.cv_arg") -> "NonSpare_1710":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class Item_887(Item):
    cv_arg: TypeAlias = NonSpare_1710.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1710

    @classmethod
    def create(cls, arg : "Item_887.cv_arg") -> "Item_887":
        return cls._create(arg) # type: ignore

class Variation_1192(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_159.cv_arg, Tuple[Literal["SAC"], RuleVariation_159.cv_arg]], Union[RuleVariation_159.cv_arg, Tuple[Literal["SIC"], RuleVariation_159.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1192.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_856, 8), (Item_887, 8)]
    cv_items_dict = {"SAC": RuleVariation_159, "SIC": RuleVariation_159}

    @overload
    @classmethod
    def spec(cls, key : Literal["SAC"]) -> RuleVariation_159:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SIC"]) -> RuleVariation_159:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["SAC"], Literal["SIC"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["SAC"]) -> RuleVariation_159:
        ...
    @overload
    def get_item(self, key : Literal["SIC"]) -> RuleVariation_159:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1192.cv_arg") -> 'Variation_1192':
        return cls._create(arg) # type: ignore

class RuleVariation_1140(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1192.cv_arg
    cv_variation: TypeAlias = Variation_1192

    @classmethod
    def create(cls, arg : "RuleVariation_1140.cv_arg") -> "RuleVariation_1140":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1192:
        return self.arg # type: ignore

class NonSpare_36(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1140.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1140

    @classmethod
    def create(cls, arg : "NonSpare_36.cv_arg") -> "NonSpare_36":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1140:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1192:
        return self.rule.variation

class UapItem_36(UapItem):
    cv_non_spare: TypeAlias = NonSpare_36

class Content_428(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Plot", 1: "Track"}

class RuleContent_428(RuleContentContextFree):
    cv_arg: TypeAlias = Content_428.cv_arg
    cv_content: TypeAlias = Content_428

    @property
    def content(self) -> Content_428:
        return self._get_content() # type: ignore

class Variation_72(Element):
    cv_arg: TypeAlias = RuleContent_428.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_428

    @classmethod
    def create(cls, arg: "Variation_72.cv_arg") -> "Variation_72":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_428:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_428:
        return self.rule.content

class RuleVariation_72(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_72.cv_arg
    cv_variation: TypeAlias = Variation_72

    @classmethod
    def create(cls, arg : "RuleVariation_72.cv_arg") -> "RuleVariation_72":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_72:
        return self.arg # type: ignore

class Content_18(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Actual plot or track", 1: "Simulated plot or track"}

class RuleContent_18(RuleContentContextFree):
    cv_arg: TypeAlias = Content_18.cv_arg
    cv_content: TypeAlias = Content_18

    @property
    def content(self) -> Content_18:
        return self._get_content() # type: ignore

class Variation_403(Element):
    cv_arg: TypeAlias = RuleContent_18.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_18

    @classmethod
    def create(cls, arg: "Variation_403.cv_arg") -> "Variation_403":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_18:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_18:
        return self.rule.content

class RuleVariation_392(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_403.cv_arg
    cv_variation: TypeAlias = Variation_403

    @classmethod
    def create(cls, arg : "RuleVariation_392.cv_arg") -> "RuleVariation_392":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_403:
        return self.arg # type: ignore

class Content_348(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No detection", 1: "Sole primary detection", 2: "Sole secondary detection", 3: "Combined primary and secondary detection"}

class RuleContent_348(RuleContentContextFree):
    cv_arg: TypeAlias = Content_348.cv_arg
    cv_content: TypeAlias = Content_348

    @property
    def content(self) -> Content_348:
        return self._get_content() # type: ignore

class Variation_593(Element):
    cv_arg: TypeAlias = RuleContent_348.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 2
    cv_rule = RuleContent_348

    @classmethod
    def create(cls, arg: "Variation_593.cv_arg") -> "Variation_593":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_348:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_348:
        return self.rule.content

class RuleVariation_582(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_593.cv_arg
    cv_variation: TypeAlias = Variation_593

    @classmethod
    def create(cls, arg : "RuleVariation_582.cv_arg") -> "RuleVariation_582":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_593:
        return self.arg # type: ignore

class Content_484(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Target report from antenna 1", 1: "Target report from antenna 2"}

class RuleContent_484(RuleContentContextFree):
    cv_arg: TypeAlias = Content_484.cv_arg
    cv_content: TypeAlias = Content_484

    @property
    def content(self) -> Content_484:
        return self._get_content() # type: ignore

class Variation_754(Element):
    cv_arg: TypeAlias = RuleContent_484.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_484

    @classmethod
    def create(cls, arg: "Variation_754.cv_arg") -> "Variation_754":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_484:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_484:
        return self.rule.content

class RuleVariation_743(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_754.cv_arg
    cv_variation: TypeAlias = Variation_754

    @classmethod
    def create(cls, arg : "RuleVariation_743.cv_arg") -> "RuleVariation_743":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_754:
        return self.arg # type: ignore

class Content_152(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Special Position Identification"}

class RuleContent_152(RuleContentContextFree):
    cv_arg: TypeAlias = Content_152.cv_arg
    cv_content: TypeAlias = Content_152

    @property
    def content(self) -> Content_152:
        return self._get_content() # type: ignore

class Variation_838(Element):
    cv_arg: TypeAlias = RuleContent_152.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_152

    @classmethod
    def create(cls, arg: "Variation_838.cv_arg") -> "Variation_838":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_152:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_152:
        return self.rule.content

class RuleVariation_808(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_838.cv_arg
    cv_variation: TypeAlias = Variation_838

    @classmethod
    def create(cls, arg : "RuleVariation_808.cv_arg") -> "RuleVariation_808":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_838:
        return self.arg # type: ignore

class Content_140(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Plot or track from a fixed transponder"}

class RuleContent_140(RuleContentContextFree):
    cv_arg: TypeAlias = Content_140.cv_arg
    cv_content: TypeAlias = Content_140

    @property
    def content(self) -> Content_140:
        return self._get_content() # type: ignore

class Variation_917(Element):
    cv_arg: TypeAlias = RuleContent_140.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_140

    @classmethod
    def create(cls, arg: "Variation_917.cv_arg") -> "Variation_917":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_140:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_140:
        return self.rule.content

class RuleVariation_887(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_917.cv_arg
    cv_variation: TypeAlias = Variation_917

    @classmethod
    def create(cls, arg : "RuleVariation_887.cv_arg") -> "RuleVariation_887":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_917:
        return self.arg # type: ignore

class Content_156(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Test target indicator"}

class RuleContent_156(RuleContentContextFree):
    cv_arg: TypeAlias = Content_156.cv_arg
    cv_content: TypeAlias = Content_156

    @property
    def content(self) -> Content_156:
        return self._get_content() # type: ignore

class Variation_36(Element):
    cv_arg: TypeAlias = RuleContent_156.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_156

    @classmethod
    def create(cls, arg: "Variation_36.cv_arg") -> "Variation_36":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_156:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_156:
        return self.rule.content

class RuleVariation_36(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_36.cv_arg
    cv_variation: TypeAlias = Variation_36

    @classmethod
    def create(cls, arg : "RuleVariation_36.cv_arg") -> "RuleVariation_36":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_36:
        return self.arg # type: ignore

class Content_159(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Unlawful interference (code 7500)", 2: "Radio-communication failure (code 7600)", 3: "Emergency (code 7700)"}

class RuleContent_159(RuleContentContextFree):
    cv_arg: TypeAlias = Content_159.cv_arg
    cv_content: TypeAlias = Content_159

    @property
    def content(self) -> Content_159:
        return self._get_content() # type: ignore

class Variation_467(Element):
    cv_arg: TypeAlias = RuleContent_159.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 2
    cv_rule = RuleContent_159

    @classmethod
    def create(cls, arg: "Variation_467.cv_arg") -> "Variation_467":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_159:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_159:
        return self.rule.content

class RuleVariation_456(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_467.cv_arg
    cv_variation: TypeAlias = Variation_467

    @classmethod
    def create(cls, arg : "RuleVariation_456.cv_arg") -> "RuleVariation_456":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_467:
        return self.arg # type: ignore

class Content_116(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Military emergency"}

class RuleContent_116(RuleContentContextFree):
    cv_arg: TypeAlias = Content_116.cv_arg
    cv_content: TypeAlias = Content_116

    @property
    def content(self) -> Content_116:
        return self._get_content() # type: ignore

class Variation_627(Element):
    cv_arg: TypeAlias = RuleContent_116.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_116

    @classmethod
    def create(cls, arg: "Variation_627.cv_arg") -> "Variation_627":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_116:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_116:
        return self.rule.content

class RuleVariation_616(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_627.cv_arg
    cv_variation: TypeAlias = Variation_627

    @classmethod
    def create(cls, arg : "RuleVariation_616.cv_arg") -> "RuleVariation_616":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_627:
        return self.arg # type: ignore

class Content_117(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Military identification"}

class RuleContent_117(RuleContentContextFree):
    cv_arg: TypeAlias = Content_117.cv_arg
    cv_content: TypeAlias = Content_117

    @property
    def content(self) -> Content_117:
        return self._get_content() # type: ignore

class Variation_708(Element):
    cv_arg: TypeAlias = RuleContent_117.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_117

    @classmethod
    def create(cls, arg: "Variation_708.cv_arg") -> "Variation_708":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_117:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_117:
        return self.rule.content

class RuleVariation_697(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_708.cv_arg
    cv_variation: TypeAlias = Variation_708

    @classmethod
    def create(cls, arg : "RuleVariation_697.cv_arg") -> "RuleVariation_697":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_708:
        return self.arg # type: ignore

class NonSpare_1957(NonSpare):
    cv_arg: TypeAlias = RuleVariation_72.cv_arg
    cv_name = "TYP"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_72

    @classmethod
    def create(cls, arg : "NonSpare_1957.cv_arg") -> "NonSpare_1957":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_72:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_72:
        return self.rule.variation

class Item_1071(Item):
    cv_arg: TypeAlias = NonSpare_1957.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1957

    @classmethod
    def create(cls, arg : "Item_1071.cv_arg") -> "Item_1071":
        return cls._create(arg) # type: ignore

class NonSpare_1725(NonSpare):
    cv_arg: TypeAlias = RuleVariation_392.cv_arg
    cv_name = "SIM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_392

    @classmethod
    def create(cls, arg : "NonSpare_1725.cv_arg") -> "NonSpare_1725":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_392:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_403:
        return self.rule.variation

class Item_900(Item):
    cv_arg: TypeAlias = NonSpare_1725.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1725

    @classmethod
    def create(cls, arg : "Item_900.cv_arg") -> "Item_900":
        return cls._create(arg) # type: ignore

class NonSpare_1767(NonSpare):
    cv_arg: TypeAlias = RuleVariation_582.cv_arg
    cv_name = "SSRPSR"
    cv_title = "Radar Detection in Last Antenna Scan"
    cv_rule: TypeAlias = RuleVariation_582

    @classmethod
    def create(cls, arg : "NonSpare_1767.cv_arg") -> "NonSpare_1767":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_582:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_593:
        return self.rule.variation

class Item_932(Item):
    cv_arg: TypeAlias = NonSpare_1767.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1767

    @classmethod
    def create(cls, arg : "Item_932.cv_arg") -> "Item_932":
        return cls._create(arg) # type: ignore

class NonSpare_611(NonSpare):
    cv_arg: TypeAlias = RuleVariation_743.cv_arg
    cv_name = "ANT"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_743

    @classmethod
    def create(cls, arg : "NonSpare_611.cv_arg") -> "NonSpare_611":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_743:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_754:
        return self.rule.variation

class Item_74(Item):
    cv_arg: TypeAlias = NonSpare_611.cv_arg
    cv_non_spare: TypeAlias = NonSpare_611

    @classmethod
    def create(cls, arg : "Item_74.cv_arg") -> "Item_74":
        return cls._create(arg) # type: ignore

class NonSpare_1740(NonSpare):
    cv_arg: TypeAlias = RuleVariation_808.cv_arg
    cv_name = "SPI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_808

    @classmethod
    def create(cls, arg : "NonSpare_1740.cv_arg") -> "NonSpare_1740":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_808:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_838:
        return self.rule.variation

class Item_913(Item):
    cv_arg: TypeAlias = NonSpare_1740.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1740

    @classmethod
    def create(cls, arg : "Item_913.cv_arg") -> "Item_913":
        return cls._create(arg) # type: ignore

class NonSpare_1539(NonSpare):
    cv_arg: TypeAlias = RuleVariation_887.cv_arg
    cv_name = "RAB"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_887

    @classmethod
    def create(cls, arg : "NonSpare_1539.cv_arg") -> "NonSpare_1539":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_887:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_917:
        return self.rule.variation

class Item_769(Item):
    cv_arg: TypeAlias = NonSpare_1539.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1539

    @classmethod
    def create(cls, arg : "Item_769.cv_arg") -> "Item_769":
        return cls._create(arg) # type: ignore

class NonSpare_1933(NonSpare):
    cv_arg: TypeAlias = RuleVariation_36.cv_arg
    cv_name = "TST"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_36

    @classmethod
    def create(cls, arg : "NonSpare_1933.cv_arg") -> "NonSpare_1933":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_36:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_36:
        return self.rule.variation

class Item_1050(Item):
    cv_arg: TypeAlias = NonSpare_1933.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1933

    @classmethod
    def create(cls, arg : "Item_1050.cv_arg") -> "Item_1050":
        return cls._create(arg) # type: ignore

class NonSpare_902(NonSpare):
    cv_arg: TypeAlias = RuleVariation_456.cv_arg
    cv_name = "DS1DS2"
    cv_title = "Radar Detection in Last Antenna Scan"
    cv_rule: TypeAlias = RuleVariation_456

    @classmethod
    def create(cls, arg : "NonSpare_902.cv_arg") -> "NonSpare_902":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_456:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_467:
        return self.rule.variation

class Item_275(Item):
    cv_arg: TypeAlias = NonSpare_902.cv_arg
    cv_non_spare: TypeAlias = NonSpare_902

    @classmethod
    def create(cls, arg : "Item_275.cv_arg") -> "Item_275":
        return cls._create(arg) # type: ignore

class NonSpare_1265(NonSpare):
    cv_arg: TypeAlias = RuleVariation_616.cv_arg
    cv_name = "ME"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_616

    @classmethod
    def create(cls, arg : "NonSpare_1265.cv_arg") -> "NonSpare_1265":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_616:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_627:
        return self.rule.variation

class Item_543(Item):
    cv_arg: TypeAlias = NonSpare_1265.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1265

    @classmethod
    def create(cls, arg : "Item_543.cv_arg") -> "Item_543":
        return cls._create(arg) # type: ignore

class NonSpare_1283(NonSpare):
    cv_arg: TypeAlias = RuleVariation_697.cv_arg
    cv_name = "MI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_697

    @classmethod
    def create(cls, arg : "NonSpare_1283.cv_arg") -> "NonSpare_1283":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_697:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_708:
        return self.rule.variation

class Item_550(Item):
    cv_arg: TypeAlias = NonSpare_1283.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1283

    @classmethod
    def create(cls, arg : "Item_550.cv_arg") -> "Item_550":
        return cls._create(arg) # type: ignore

class Item_24(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 5
    cv_bit_size = 2

class Variation_1388(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_72.cv_arg, Tuple[Literal["TYP"], RuleVariation_72.cv_arg]], Union[RuleVariation_392.cv_arg, Tuple[Literal["SIM"], RuleVariation_392.cv_arg]], Union[RuleVariation_582.cv_arg, Tuple[Literal["SSRPSR"], RuleVariation_582.cv_arg]], Union[RuleVariation_743.cv_arg, Tuple[Literal["ANT"], RuleVariation_743.cv_arg]], Union[RuleVariation_808.cv_arg, Tuple[Literal["SPI"], RuleVariation_808.cv_arg]], Union[RuleVariation_887.cv_arg, Tuple[Literal["RAB"], RuleVariation_887.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_36.cv_arg, Tuple[Literal["TST"], RuleVariation_36.cv_arg]], Union[RuleVariation_456.cv_arg, Tuple[Literal["DS1DS2"], RuleVariation_456.cv_arg]], Union[RuleVariation_616.cv_arg, Tuple[Literal["ME"], RuleVariation_616.cv_arg]], Union[RuleVariation_697.cv_arg, Tuple[Literal["MI"], RuleVariation_697.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1388.cv_arg_group_1"],
        Tuple["Variation_1388.cv_arg_group_1", "Variation_1388.cv_arg_group_2"],
    ]
    cv_items_list = [[(Item_1071, 1), (Item_900, 1), (Item_932, 2), (Item_74, 1), (Item_913, 1), (Item_769, 1), None], [(Item_1050, 1), (Item_275, 2), (Item_543, 1), (Item_550, 1), (Item_24, 2), None]]

    @classmethod
    def create(cls, arg: "Variation_1388.cv_arg") -> 'Variation_1388':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["TYP"]) -> RuleVariation_72:
        ...
    @overload
    def get_item(self, key : Literal["SIM"]) -> RuleVariation_392:
        ...
    @overload
    def get_item(self, key : Literal["SSRPSR"]) -> RuleVariation_582:
        ...
    @overload
    def get_item(self, key : Literal["ANT"]) -> RuleVariation_743:
        ...
    @overload
    def get_item(self, key : Literal["SPI"]) -> RuleVariation_808:
        ...
    @overload
    def get_item(self, key : Literal["RAB"]) -> RuleVariation_887:
        ...
    @overload
    def get_item(self, key : Literal["TST"]) -> Optional[RuleVariation_36]:
        ...
    @overload
    def get_item(self, key : Literal["DS1DS2"]) -> Optional[RuleVariation_456]:
        ...
    @overload
    def get_item(self, key : Literal["ME"]) -> Optional[RuleVariation_616]:
        ...
    @overload
    def get_item(self, key : Literal["MI"]) -> Optional[RuleVariation_697]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1309(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1388.cv_arg
    cv_variation: TypeAlias = Variation_1388

    @classmethod
    def create(cls, arg : "RuleVariation_1309.cv_arg") -> "RuleVariation_1309":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1388:
        return self.arg # type: ignore

class NonSpare_87(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1309.cv_arg
    cv_name = "020"
    cv_title = "Target Report Descriptor"
    cv_rule: TypeAlias = RuleVariation_1309

    @classmethod
    def create(cls, arg : "NonSpare_87.cv_arg") -> "NonSpare_87":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1309:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1388:
        return self.rule.variation

class UapItem_87(UapItem):
    cv_non_spare: TypeAlias = NonSpare_87

class Content_768(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 7.8125e-3
    cv_unit = "NM"

    def as_quantity(self, cv_unit : Optional[Literal["NM"]] = None) -> float:
        return self._as_quantity()

class RuleContent_767(RuleContentContextFree):
    cv_arg: TypeAlias = Content_768.cv_arg
    cv_content: TypeAlias = Content_768

    @property
    def content(self) -> Content_768:
        return self._get_content() # type: ignore

class Variation_332(Element):
    cv_arg: TypeAlias = RuleContent_767.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_767

    @classmethod
    def create(cls, arg: "Variation_332.cv_arg") -> "Variation_332":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_767:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_768:
        return self.rule.content

class RuleVariation_325(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_332.cv_arg
    cv_variation: TypeAlias = Variation_332

    @classmethod
    def create(cls, arg : "RuleVariation_325.cv_arg") -> "RuleVariation_325":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_332:
        return self.arg # type: ignore

class NonSpare_1589(NonSpare):
    cv_arg: TypeAlias = RuleVariation_325.cv_arg
    cv_name = "RHO"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_325

    @classmethod
    def create(cls, arg : "NonSpare_1589.cv_arg") -> "NonSpare_1589":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_325:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_332:
        return self.rule.variation

class Item_814(Item):
    cv_arg: TypeAlias = NonSpare_1589.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1589

    @classmethod
    def create(cls, arg : "Item_814.cv_arg") -> "Item_814":
        return cls._create(arg) # type: ignore

class Content_793(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 5.4931640625e-3
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_792(RuleContentContextFree):
    cv_arg: TypeAlias = Content_793.cv_arg
    cv_content: TypeAlias = Content_793

    @property
    def content(self) -> Content_793:
        return self._get_content() # type: ignore

class Variation_343(Element):
    cv_arg: TypeAlias = RuleContent_792.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_792

    @classmethod
    def create(cls, arg: "Variation_343.cv_arg") -> "Variation_343":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_792:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_793:
        return self.rule.content

class RuleVariation_336(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_343.cv_arg
    cv_variation: TypeAlias = Variation_343

    @classmethod
    def create(cls, arg : "RuleVariation_336.cv_arg") -> "RuleVariation_336":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_343:
        return self.arg # type: ignore

class NonSpare_1855(NonSpare):
    cv_arg: TypeAlias = RuleVariation_336.cv_arg
    cv_name = "THETA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_336

    @classmethod
    def create(cls, arg : "NonSpare_1855.cv_arg") -> "NonSpare_1855":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_336:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_343:
        return self.rule.variation

class Item_993(Item):
    cv_arg: TypeAlias = NonSpare_1855.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1855

    @classmethod
    def create(cls, arg : "Item_993.cv_arg") -> "Item_993":
        return cls._create(arg) # type: ignore

class Variation_1178(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_325.cv_arg, Tuple[Literal["RHO"], RuleVariation_325.cv_arg]], Union[RuleVariation_336.cv_arg, Tuple[Literal["THETA"], RuleVariation_336.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1178.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_814, 16), (Item_993, 16)]
    cv_items_dict = {"RHO": RuleVariation_325, "THETA": RuleVariation_336}

    @overload
    @classmethod
    def spec(cls, key : Literal["RHO"]) -> RuleVariation_325:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["THETA"]) -> RuleVariation_336:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["RHO"], Literal["THETA"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["RHO"]) -> RuleVariation_325:
        ...
    @overload
    def get_item(self, key : Literal["THETA"]) -> RuleVariation_336:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1178.cv_arg") -> 'Variation_1178':
        return cls._create(arg) # type: ignore

class RuleVariation_1129(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1178.cv_arg
    cv_variation: TypeAlias = Variation_1178

    @classmethod
    def create(cls, arg : "RuleVariation_1129.cv_arg") -> "RuleVariation_1129":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1178:
        return self.arg # type: ignore

class NonSpare_138(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1129.cv_arg
    cv_name = "040"
    cv_title = "Measured Position in Polar Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1129

    @classmethod
    def create(cls, arg : "NonSpare_138.cv_arg") -> "NonSpare_138":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1129:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1178:
        return self.rule.variation

class UapItem_138(UapItem):
    cv_non_spare: TypeAlias = NonSpare_138

class Content_56(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Code validated", 1: "Code not validated"}

class RuleContent_56(RuleContentContextFree):
    cv_arg: TypeAlias = Content_56.cv_arg
    cv_content: TypeAlias = Content_56

    @property
    def content(self) -> Content_56:
        return self._get_content() # type: ignore

class Variation_15(Element):
    cv_arg: TypeAlias = RuleContent_56.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_56

    @classmethod
    def create(cls, arg: "Variation_15.cv_arg") -> "Variation_15":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_56:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_56:
        return self.rule.content

class RuleVariation_15(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_15.cv_arg
    cv_variation: TypeAlias = Variation_15

    @classmethod
    def create(cls, arg : "RuleVariation_15.cv_arg") -> "RuleVariation_15":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_15:
        return self.arg # type: ignore

class NonSpare_1990(NonSpare):
    cv_arg: TypeAlias = RuleVariation_15.cv_arg
    cv_name = "V"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_15

    @classmethod
    def create(cls, arg : "NonSpare_1990.cv_arg") -> "NonSpare_1990":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_15:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_15:
        return self.rule.variation

class Item_1102(Item):
    cv_arg: TypeAlias = NonSpare_1990.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1990

    @classmethod
    def create(cls, arg : "Item_1102.cv_arg") -> "Item_1102":
        return cls._create(arg) # type: ignore

class Content_97(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Garbled code"}

class RuleContent_97(RuleContentContextFree):
    cv_arg: TypeAlias = Content_97.cv_arg
    cv_content: TypeAlias = Content_97

    @property
    def content(self) -> Content_97:
        return self._get_content() # type: ignore

class Variation_407(Element):
    cv_arg: TypeAlias = RuleContent_97.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_97

    @classmethod
    def create(cls, arg: "Variation_407.cv_arg") -> "Variation_407":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_97:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_97:
        return self.rule.content

class RuleVariation_396(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_407.cv_arg
    cv_variation: TypeAlias = Variation_407

    @classmethod
    def create(cls, arg : "RuleVariation_396.cv_arg") -> "RuleVariation_396":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_407:
        return self.arg # type: ignore

class NonSpare_1009(NonSpare):
    cv_arg: TypeAlias = RuleVariation_396.cv_arg
    cv_name = "G"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_396

    @classmethod
    def create(cls, arg : "NonSpare_1009.cv_arg") -> "NonSpare_1009":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_396:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_407:
        return self.rule.variation

class Item_355(Item):
    cv_arg: TypeAlias = NonSpare_1009.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1009

    @classmethod
    def create(cls, arg : "Item_355.cv_arg") -> "Item_355":
        return cls._create(arg) # type: ignore

class Content_292(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Mode-3/A code derived from the reply of the transponder", 1: "Smoothed Mode-3/A code as provided by a local tracker"}

class RuleContent_292(RuleContentContextFree):
    cv_arg: TypeAlias = Content_292.cv_arg
    cv_content: TypeAlias = Content_292

    @property
    def content(self) -> Content_292:
        return self._get_content() # type: ignore

class Variation_555(Element):
    cv_arg: TypeAlias = RuleContent_292.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_292

    @classmethod
    def create(cls, arg: "Variation_555.cv_arg") -> "Variation_555":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_292:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_292:
        return self.rule.content

class RuleVariation_544(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_555.cv_arg
    cv_variation: TypeAlias = Variation_555

    @classmethod
    def create(cls, arg : "RuleVariation_544.cv_arg") -> "RuleVariation_544":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_555:
        return self.arg # type: ignore

class NonSpare_1143(NonSpare):
    cv_arg: TypeAlias = RuleVariation_544.cv_arg
    cv_name = "L"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_544

    @classmethod
    def create(cls, arg : "NonSpare_1143.cv_arg") -> "NonSpare_1143":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_544:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_555:
        return self.rule.variation

class Item_455(Item):
    cv_arg: TypeAlias = NonSpare_1143.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1143

    @classmethod
    def create(cls, arg : "Item_455.cv_arg") -> "Item_455":
        return cls._create(arg) # type: ignore

class Item_16(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 3
    cv_bit_size = 1

class Content_611(ContentString):
    cv_arg: TypeAlias = Union[int, str]
    cv_string_type: TypeAlias = StringOctal

class RuleContent_611(RuleContentContextFree):
    cv_arg: TypeAlias = Content_611.cv_arg
    cv_content: TypeAlias = Content_611

    @property
    def content(self) -> Content_611:
        return self._get_content() # type: ignore

class Variation_809(Element):
    cv_arg: TypeAlias = RuleContent_611.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 12
    cv_rule = RuleContent_611

    @classmethod
    def create(cls, arg: "Variation_809.cv_arg") -> "Variation_809":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_611:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_611:
        return self.rule.content

class RuleVariation_779(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_809.cv_arg
    cv_variation: TypeAlias = Variation_809

    @classmethod
    def create(cls, arg : "RuleVariation_779.cv_arg") -> "RuleVariation_779":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_809:
        return self.arg # type: ignore

class NonSpare_1309(NonSpare):
    cv_arg: TypeAlias = RuleVariation_779.cv_arg
    cv_name = "MODE3A"
    cv_title = "Mode-3/A Reply in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_779

    @classmethod
    def create(cls, arg : "NonSpare_1309.cv_arg") -> "NonSpare_1309":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_779:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_809:
        return self.rule.variation

class Item_575(Item):
    cv_arg: TypeAlias = NonSpare_1309.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1309

    @classmethod
    def create(cls, arg : "Item_575.cv_arg") -> "Item_575":
        return cls._create(arg) # type: ignore

class Variation_1266(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_15.cv_arg, Tuple[Literal["V"], RuleVariation_15.cv_arg]], Union[RuleVariation_396.cv_arg, Tuple[Literal["G"], RuleVariation_396.cv_arg]], Union[RuleVariation_544.cv_arg, Tuple[Literal["L"], RuleVariation_544.cv_arg]], int, Union[RuleVariation_779.cv_arg, Tuple[Literal["MODE3A"], RuleVariation_779.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1266.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_1102, 1), (Item_355, 1), (Item_455, 1), (Item_16, 1), (Item_575, 12)]
    cv_items_dict = {"V": RuleVariation_15, "G": RuleVariation_396, "L": RuleVariation_544, "MODE3A": RuleVariation_779}

    @overload
    @classmethod
    def spec(cls, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> RuleVariation_396:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["L"]) -> RuleVariation_544:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MODE3A"]) -> RuleVariation_779:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["V"], Literal["G"], Literal["L"], Literal["MODE3A"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> RuleVariation_396:
        ...
    @overload
    def get_item(self, key : Literal["L"]) -> RuleVariation_544:
        ...
    @overload
    def get_item(self, key : Literal["MODE3A"]) -> RuleVariation_779:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1266.cv_arg") -> 'Variation_1266':
        return cls._create(arg) # type: ignore

class RuleVariation_1195(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1266.cv_arg
    cv_variation: TypeAlias = Variation_1266

    @classmethod
    def create(cls, arg : "RuleVariation_1195.cv_arg") -> "RuleVariation_1195":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1266:
        return self.arg # type: ignore

class NonSpare_213(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1195.cv_arg
    cv_name = "070"
    cv_title = "Mode-3/A Code in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_1195

    @classmethod
    def create(cls, arg : "NonSpare_213.cv_arg") -> "NonSpare_213":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1195:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1266:
        return self.rule.variation

class UapItem_213(UapItem):
    cv_non_spare: TypeAlias = NonSpare_213

class Content_653(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["FL"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.25
    cv_unit = "FL"

    def as_quantity(self, cv_unit : Optional[Literal["FL"]] = None) -> float:
        return self._as_quantity()

class RuleContent_653(RuleContentContextFree):
    cv_arg: TypeAlias = Content_653.cv_arg
    cv_content: TypeAlias = Content_653

    @property
    def content(self) -> Content_653:
        return self._get_content() # type: ignore

class Variation_609(Element):
    cv_arg: TypeAlias = RuleContent_653.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 14
    cv_rule = RuleContent_653

    @classmethod
    def create(cls, arg: "Variation_609.cv_arg") -> "Variation_609":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_653:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_653:
        return self.rule.content

class RuleVariation_598(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_609.cv_arg
    cv_variation: TypeAlias = Variation_609

    @classmethod
    def create(cls, arg : "RuleVariation_598.cv_arg") -> "RuleVariation_598":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_609:
        return self.arg # type: ignore

class NonSpare_1069(NonSpare):
    cv_arg: TypeAlias = RuleVariation_598.cv_arg
    cv_name = "HGT"
    cv_title = "Mode-C HEIGHT"
    cv_rule: TypeAlias = RuleVariation_598

    @classmethod
    def create(cls, arg : "NonSpare_1069.cv_arg") -> "NonSpare_1069":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_598:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_609:
        return self.rule.variation

class Item_395(Item):
    cv_arg: TypeAlias = NonSpare_1069.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1069

    @classmethod
    def create(cls, arg : "Item_395.cv_arg") -> "Item_395":
        return cls._create(arg) # type: ignore

class Variation_1258(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_15.cv_arg, Tuple[Literal["V"], RuleVariation_15.cv_arg]], Union[RuleVariation_396.cv_arg, Tuple[Literal["G"], RuleVariation_396.cv_arg]], Union[RuleVariation_598.cv_arg, Tuple[Literal["HGT"], RuleVariation_598.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1258.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_1102, 1), (Item_355, 1), (Item_395, 14)]
    cv_items_dict = {"V": RuleVariation_15, "G": RuleVariation_396, "HGT": RuleVariation_598}

    @overload
    @classmethod
    def spec(cls, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> RuleVariation_396:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["HGT"]) -> RuleVariation_598:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["V"], Literal["G"], Literal["HGT"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> RuleVariation_396:
        ...
    @overload
    def get_item(self, key : Literal["HGT"]) -> RuleVariation_598:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1258.cv_arg") -> 'Variation_1258':
        return cls._create(arg) # type: ignore

class RuleVariation_1187(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1258.cv_arg
    cv_variation: TypeAlias = Variation_1258

    @classmethod
    def create(cls, arg : "RuleVariation_1187.cv_arg") -> "RuleVariation_1187":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1258:
        return self.arg # type: ignore

class NonSpare_253(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1187.cv_arg
    cv_name = "090"
    cv_title = "Mode-C Code in Binary Representation"
    cv_rule: TypeAlias = RuleVariation_1187

    @classmethod
    def create(cls, arg : "NonSpare_253.cv_arg") -> "NonSpare_253":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1187:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1258:
        return self.rule.variation

class UapItem_253(UapItem):
    cv_non_spare: TypeAlias = NonSpare_253

class Variation_150(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 7
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_150.cv_arg") -> "Variation_150":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class Variation_1454(Repetitive):
    cv_arg: TypeAlias = List[Variation_150.cv_arg]
    cv_rep_bytes = None
    cv_variation: TypeAlias = Variation_150

    @classmethod
    def create(cls, arg: "Variation_1454.cv_arg") -> 'Variation_1454':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_150]:
        return self._get_list() # type: ignore

class RuleVariation_1375(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1454.cv_arg
    cv_variation: TypeAlias = Variation_1454

    @classmethod
    def create(cls, arg : "RuleVariation_1375.cv_arg") -> "RuleVariation_1375":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1454:
        return self.arg # type: ignore

class NonSpare_312(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1375.cv_arg
    cv_name = "130"
    cv_title = "Radar Plot Characteristics"
    cv_rule: TypeAlias = RuleVariation_1375

    @classmethod
    def create(cls, arg : "NonSpare_312.cv_arg") -> "NonSpare_312":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1375:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1454:
        return self.rule.variation

class UapItem_312(UapItem):
    cv_non_spare: TypeAlias = NonSpare_312

class Content_770(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["s"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 7.8125e-3
    cv_unit = "s"

    def as_quantity(self, cv_unit : Optional[Literal["s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_769(RuleContentContextFree):
    cv_arg: TypeAlias = Content_770.cv_arg
    cv_content: TypeAlias = Content_770

    @property
    def content(self) -> Content_770:
        return self._get_content() # type: ignore

class Variation_334(Element):
    cv_arg: TypeAlias = RuleContent_769.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_769

    @classmethod
    def create(cls, arg: "Variation_334.cv_arg") -> "Variation_334":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_769:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_770:
        return self.rule.content

class RuleVariation_327(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_334.cv_arg
    cv_variation: TypeAlias = Variation_334

    @classmethod
    def create(cls, arg : "RuleVariation_327.cv_arg") -> "RuleVariation_327":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_334:
        return self.arg # type: ignore

class NonSpare_337(NonSpare):
    cv_arg: TypeAlias = RuleVariation_327.cv_arg
    cv_name = "141"
    cv_title = "Truncated Time of Day"
    cv_rule: TypeAlias = RuleVariation_327

    @classmethod
    def create(cls, arg : "NonSpare_337.cv_arg") -> "NonSpare_337":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_327:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_334:
        return self.rule.variation

class UapItem_337(UapItem):
    cv_non_spare: TypeAlias = NonSpare_337

class Content_286(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Mode-2 code as derived from the reply of the transponder", 1: "Smoothed Mode-2 code as provided by a local tracker"}

class RuleContent_286(RuleContentContextFree):
    cv_arg: TypeAlias = Content_286.cv_arg
    cv_content: TypeAlias = Content_286

    @property
    def content(self) -> Content_286:
        return self._get_content() # type: ignore

class Variation_549(Element):
    cv_arg: TypeAlias = RuleContent_286.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_286

    @classmethod
    def create(cls, arg: "Variation_549.cv_arg") -> "Variation_549":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_286:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_286:
        return self.rule.content

class RuleVariation_538(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_549.cv_arg
    cv_variation: TypeAlias = Variation_549

    @classmethod
    def create(cls, arg : "RuleVariation_538.cv_arg") -> "RuleVariation_538":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_549:
        return self.arg # type: ignore

class NonSpare_1137(NonSpare):
    cv_arg: TypeAlias = RuleVariation_538.cv_arg
    cv_name = "L"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_538

    @classmethod
    def create(cls, arg : "NonSpare_1137.cv_arg") -> "NonSpare_1137":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_538:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_549:
        return self.rule.variation

class Item_449(Item):
    cv_arg: TypeAlias = NonSpare_1137.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1137

    @classmethod
    def create(cls, arg : "Item_449.cv_arg") -> "Item_449":
        return cls._create(arg) # type: ignore

class NonSpare_1303(NonSpare):
    cv_arg: TypeAlias = RuleVariation_779.cv_arg
    cv_name = "MODE2"
    cv_title = "Mode-2 Code in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_779

    @classmethod
    def create(cls, arg : "NonSpare_1303.cv_arg") -> "NonSpare_1303":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_779:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_809:
        return self.rule.variation

class Item_569(Item):
    cv_arg: TypeAlias = NonSpare_1303.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1303

    @classmethod
    def create(cls, arg : "Item_569.cv_arg") -> "Item_569":
        return cls._create(arg) # type: ignore

class Variation_1261(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_15.cv_arg, Tuple[Literal["V"], RuleVariation_15.cv_arg]], Union[RuleVariation_396.cv_arg, Tuple[Literal["G"], RuleVariation_396.cv_arg]], Union[RuleVariation_538.cv_arg, Tuple[Literal["L"], RuleVariation_538.cv_arg]], int, Union[RuleVariation_779.cv_arg, Tuple[Literal["MODE2"], RuleVariation_779.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1261.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_1102, 1), (Item_355, 1), (Item_449, 1), (Item_16, 1), (Item_569, 12)]
    cv_items_dict = {"V": RuleVariation_15, "G": RuleVariation_396, "L": RuleVariation_538, "MODE2": RuleVariation_779}

    @overload
    @classmethod
    def spec(cls, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> RuleVariation_396:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["L"]) -> RuleVariation_538:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MODE2"]) -> RuleVariation_779:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["V"], Literal["G"], Literal["L"], Literal["MODE2"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> RuleVariation_396:
        ...
    @overload
    def get_item(self, key : Literal["L"]) -> RuleVariation_538:
        ...
    @overload
    def get_item(self, key : Literal["MODE2"]) -> RuleVariation_779:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1261.cv_arg") -> 'Variation_1261':
        return cls._create(arg) # type: ignore

class RuleVariation_1190(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1261.cv_arg
    cv_variation: TypeAlias = Variation_1261

    @classmethod
    def create(cls, arg : "RuleVariation_1190.cv_arg") -> "RuleVariation_1190":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1261:
        return self.arg # type: ignore

class NonSpare_174(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1190.cv_arg
    cv_name = "050"
    cv_title = "Mode-2 Code in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_1190

    @classmethod
    def create(cls, arg : "NonSpare_174.cv_arg") -> "NonSpare_174":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1190:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1261:
        return self.rule.variation

class UapItem_174(UapItem):
    cv_non_spare: TypeAlias = NonSpare_174

class Content_681(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM/s"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 3.90625e-3
    cv_unit = "NM/s"

    def as_quantity(self, cv_unit : Optional[Literal["NM/s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_681(RuleContentContextFree):
    cv_arg: TypeAlias = Content_681.cv_arg
    cv_content: TypeAlias = Content_681

    @property
    def content(self) -> Content_681:
        return self._get_content() # type: ignore

class Variation_218(Element):
    cv_arg: TypeAlias = RuleContent_681.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_681

    @classmethod
    def create(cls, arg: "Variation_218.cv_arg") -> "Variation_218":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_681:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_681:
        return self.rule.content

class RuleVariation_211(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_218.cv_arg
    cv_variation: TypeAlias = Variation_218

    @classmethod
    def create(cls, arg : "RuleVariation_211.cv_arg") -> "RuleVariation_211":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_218:
        return self.arg # type: ignore

class NonSpare_300(NonSpare):
    cv_arg: TypeAlias = RuleVariation_211.cv_arg
    cv_name = "120"
    cv_title = "Measured Radial Doppler Speed"
    cv_rule: TypeAlias = RuleVariation_211

    @classmethod
    def create(cls, arg : "NonSpare_300.cv_arg") -> "NonSpare_300":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_211:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_218:
        return self.rule.variation

class UapItem_300(UapItem):
    cv_non_spare: TypeAlias = NonSpare_300

class Content_625(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["dBm"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 1.0
    cv_unit = "dBm"

    def as_quantity(self, cv_unit : Optional[Literal["dBm"]] = None) -> float:
        return self._as_quantity()

class RuleContent_625(RuleContentContextFree):
    cv_arg: TypeAlias = Content_625.cv_arg
    cv_content: TypeAlias = Content_625

    @property
    def content(self) -> Content_625:
        return self._get_content() # type: ignore

class Variation_208(Element):
    cv_arg: TypeAlias = RuleContent_625.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_625

    @classmethod
    def create(cls, arg: "Variation_208.cv_arg") -> "Variation_208":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_625:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_625:
        return self.rule.content

class RuleVariation_201(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_208.cv_arg
    cv_variation: TypeAlias = Variation_208

    @classmethod
    def create(cls, arg : "RuleVariation_201.cv_arg") -> "RuleVariation_201":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_208:
        return self.arg # type: ignore

class NonSpare_316(NonSpare):
    cv_arg: TypeAlias = RuleVariation_201.cv_arg
    cv_name = "131"
    cv_title = "Received Power"
    cv_rule: TypeAlias = RuleVariation_201

    @classmethod
    def create(cls, arg : "NonSpare_316.cv_arg") -> "NonSpare_316":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_201:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_208:
        return self.rule.variation

class UapItem_316(UapItem):
    cv_non_spare: TypeAlias = NonSpare_316

class Item_3(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 0
    cv_bit_size = 4

class Content_227(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse A4", 1: "Low quality pulse A4"}

class RuleContent_227(RuleContentContextFree):
    cv_arg: TypeAlias = Content_227.cv_arg
    cv_content: TypeAlias = Content_227

    @property
    def content(self) -> Content_227:
        return self._get_content() # type: ignore

class Variation_726(Element):
    cv_arg: TypeAlias = RuleContent_227.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_227

    @classmethod
    def create(cls, arg: "Variation_726.cv_arg") -> "Variation_726":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_227:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_227:
        return self.rule.content

class RuleVariation_715(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_726.cv_arg
    cv_variation: TypeAlias = Variation_726

    @classmethod
    def create(cls, arg : "RuleVariation_715.cv_arg") -> "RuleVariation_715":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_726:
        return self.arg # type: ignore

class NonSpare_1497(NonSpare):
    cv_arg: TypeAlias = RuleVariation_715.cv_arg
    cv_name = "QA4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_715

    @classmethod
    def create(cls, arg : "NonSpare_1497.cv_arg") -> "NonSpare_1497":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_715:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_726:
        return self.rule.variation

class Item_730(Item):
    cv_arg: TypeAlias = NonSpare_1497.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1497

    @classmethod
    def create(cls, arg : "Item_730.cv_arg") -> "Item_730":
        return cls._create(arg) # type: ignore

class Content_226(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse A2", 1: "Low quality pulse A2"}

class RuleContent_226(RuleContentContextFree):
    cv_arg: TypeAlias = Content_226.cv_arg
    cv_content: TypeAlias = Content_226

    @property
    def content(self) -> Content_226:
        return self._get_content() # type: ignore

class Variation_853(Element):
    cv_arg: TypeAlias = RuleContent_226.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_226

    @classmethod
    def create(cls, arg: "Variation_853.cv_arg") -> "Variation_853":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_226:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_226:
        return self.rule.content

class RuleVariation_823(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_853.cv_arg
    cv_variation: TypeAlias = Variation_853

    @classmethod
    def create(cls, arg : "RuleVariation_823.cv_arg") -> "RuleVariation_823":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_853:
        return self.arg # type: ignore

class NonSpare_1492(NonSpare):
    cv_arg: TypeAlias = RuleVariation_823.cv_arg
    cv_name = "QA2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_823

    @classmethod
    def create(cls, arg : "NonSpare_1492.cv_arg") -> "NonSpare_1492":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_823:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_853:
        return self.rule.variation

class Item_725(Item):
    cv_arg: TypeAlias = NonSpare_1492.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1492

    @classmethod
    def create(cls, arg : "Item_725.cv_arg") -> "Item_725":
        return cls._create(arg) # type: ignore

class Content_225(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse A1", 1: "Low quality pulse A1"}

class RuleContent_225(RuleContentContextFree):
    cv_arg: TypeAlias = Content_225.cv_arg
    cv_content: TypeAlias = Content_225

    @property
    def content(self) -> Content_225:
        return self._get_content() # type: ignore

class Variation_929(Element):
    cv_arg: TypeAlias = RuleContent_225.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_225

    @classmethod
    def create(cls, arg: "Variation_929.cv_arg") -> "Variation_929":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_225:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_225:
        return self.rule.content

class RuleVariation_899(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_929.cv_arg
    cv_variation: TypeAlias = Variation_929

    @classmethod
    def create(cls, arg : "RuleVariation_899.cv_arg") -> "RuleVariation_899":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_929:
        return self.arg # type: ignore

class NonSpare_1489(NonSpare):
    cv_arg: TypeAlias = RuleVariation_899.cv_arg
    cv_name = "QA1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_899

    @classmethod
    def create(cls, arg : "NonSpare_1489.cv_arg") -> "NonSpare_1489":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_899:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_929:
        return self.rule.variation

class Item_722(Item):
    cv_arg: TypeAlias = NonSpare_1489.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1489

    @classmethod
    def create(cls, arg : "Item_722.cv_arg") -> "Item_722":
        return cls._create(arg) # type: ignore

class Content_230(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse B4", 1: "Low quality pulse B4"}

class RuleContent_230(RuleContentContextFree):
    cv_arg: TypeAlias = Content_230.cv_arg
    cv_content: TypeAlias = Content_230

    @property
    def content(self) -> Content_230:
        return self._get_content() # type: ignore

class Variation_978(Element):
    cv_arg: TypeAlias = RuleContent_230.cv_arg
    cv_bit_offset8 = 7
    cv_bit_size = 1
    cv_rule = RuleContent_230

    @classmethod
    def create(cls, arg: "Variation_978.cv_arg") -> "Variation_978":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_230:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_230:
        return self.rule.content

class RuleVariation_948(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_978.cv_arg
    cv_variation: TypeAlias = Variation_978

    @classmethod
    def create(cls, arg : "RuleVariation_948.cv_arg") -> "RuleVariation_948":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_978:
        return self.arg # type: ignore

class NonSpare_1508(NonSpare):
    cv_arg: TypeAlias = RuleVariation_948.cv_arg
    cv_name = "QB4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_948

    @classmethod
    def create(cls, arg : "NonSpare_1508.cv_arg") -> "NonSpare_1508":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_948:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_978:
        return self.rule.variation

class Item_741(Item):
    cv_arg: TypeAlias = NonSpare_1508.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1508

    @classmethod
    def create(cls, arg : "Item_741.cv_arg") -> "Item_741":
        return cls._create(arg) # type: ignore

class Content_229(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse B2", 1: "Low quality pulse B2"}

class RuleContent_229(RuleContentContextFree):
    cv_arg: TypeAlias = Content_229.cv_arg
    cv_content: TypeAlias = Content_229

    @property
    def content(self) -> Content_229:
        return self._get_content() # type: ignore

class Variation_46(Element):
    cv_arg: TypeAlias = RuleContent_229.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_229

    @classmethod
    def create(cls, arg: "Variation_46.cv_arg") -> "Variation_46":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_229:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_229:
        return self.rule.content

class RuleVariation_46(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_46.cv_arg
    cv_variation: TypeAlias = Variation_46

    @classmethod
    def create(cls, arg : "RuleVariation_46.cv_arg") -> "RuleVariation_46":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_46:
        return self.arg # type: ignore

class NonSpare_1503(NonSpare):
    cv_arg: TypeAlias = RuleVariation_46.cv_arg
    cv_name = "QB2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_46

    @classmethod
    def create(cls, arg : "NonSpare_1503.cv_arg") -> "NonSpare_1503":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_46:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_46:
        return self.rule.variation

class Item_736(Item):
    cv_arg: TypeAlias = NonSpare_1503.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1503

    @classmethod
    def create(cls, arg : "Item_736.cv_arg") -> "Item_736":
        return cls._create(arg) # type: ignore

class Content_228(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse B1", 1: "Low quality pulse B1"}

class RuleContent_228(RuleContentContextFree):
    cv_arg: TypeAlias = Content_228.cv_arg
    cv_content: TypeAlias = Content_228

    @property
    def content(self) -> Content_228:
        return self._get_content() # type: ignore

class Variation_432(Element):
    cv_arg: TypeAlias = RuleContent_228.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_228

    @classmethod
    def create(cls, arg: "Variation_432.cv_arg") -> "Variation_432":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_228:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_228:
        return self.rule.content

class RuleVariation_421(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_432.cv_arg
    cv_variation: TypeAlias = Variation_432

    @classmethod
    def create(cls, arg : "RuleVariation_421.cv_arg") -> "RuleVariation_421":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_432:
        return self.arg # type: ignore

class NonSpare_1499(NonSpare):
    cv_arg: TypeAlias = RuleVariation_421.cv_arg
    cv_name = "QB1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_421

    @classmethod
    def create(cls, arg : "NonSpare_1499.cv_arg") -> "NonSpare_1499":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_421:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_432:
        return self.rule.variation

class Item_732(Item):
    cv_arg: TypeAlias = NonSpare_1499.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1499

    @classmethod
    def create(cls, arg : "Item_732.cv_arg") -> "Item_732":
        return cls._create(arg) # type: ignore

class Content_233(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse C4", 1: "Low quality pulse C4"}

class RuleContent_233(RuleContentContextFree):
    cv_arg: TypeAlias = Content_233.cv_arg
    cv_content: TypeAlias = Content_233

    @property
    def content(self) -> Content_233:
        return self._get_content() # type: ignore

class Variation_538(Element):
    cv_arg: TypeAlias = RuleContent_233.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_233

    @classmethod
    def create(cls, arg: "Variation_538.cv_arg") -> "Variation_538":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_233:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_233:
        return self.rule.content

class RuleVariation_527(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_538.cv_arg
    cv_variation: TypeAlias = Variation_538

    @classmethod
    def create(cls, arg : "RuleVariation_527.cv_arg") -> "RuleVariation_527":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_538:
        return self.arg # type: ignore

class NonSpare_1516(NonSpare):
    cv_arg: TypeAlias = RuleVariation_527.cv_arg
    cv_name = "QC4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_527

    @classmethod
    def create(cls, arg : "NonSpare_1516.cv_arg") -> "NonSpare_1516":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_527:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_538:
        return self.rule.variation

class Item_749(Item):
    cv_arg: TypeAlias = NonSpare_1516.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1516

    @classmethod
    def create(cls, arg : "Item_749.cv_arg") -> "Item_749":
        return cls._create(arg) # type: ignore

class Content_232(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse C2", 1: "Low quality pulse C2"}

class RuleContent_232(RuleContentContextFree):
    cv_arg: TypeAlias = Content_232.cv_arg
    cv_content: TypeAlias = Content_232

    @property
    def content(self) -> Content_232:
        return self._get_content() # type: ignore

class Variation_642(Element):
    cv_arg: TypeAlias = RuleContent_232.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_232

    @classmethod
    def create(cls, arg: "Variation_642.cv_arg") -> "Variation_642":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_232:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_232:
        return self.rule.content

class RuleVariation_631(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_642.cv_arg
    cv_variation: TypeAlias = Variation_642

    @classmethod
    def create(cls, arg : "RuleVariation_631.cv_arg") -> "RuleVariation_631":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_642:
        return self.arg # type: ignore

class NonSpare_1512(NonSpare):
    cv_arg: TypeAlias = RuleVariation_631.cv_arg
    cv_name = "QC2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_631

    @classmethod
    def create(cls, arg : "NonSpare_1512.cv_arg") -> "NonSpare_1512":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_631:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_642:
        return self.rule.variation

class Item_745(Item):
    cv_arg: TypeAlias = NonSpare_1512.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1512

    @classmethod
    def create(cls, arg : "Item_745.cv_arg") -> "Item_745":
        return cls._create(arg) # type: ignore

class Content_231(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse C1", 1: "Low quality pulse C1"}

class RuleContent_231(RuleContentContextFree):
    cv_arg: TypeAlias = Content_231.cv_arg
    cv_content: TypeAlias = Content_231

    @property
    def content(self) -> Content_231:
        return self._get_content() # type: ignore

class Variation_728(Element):
    cv_arg: TypeAlias = RuleContent_231.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_231

    @classmethod
    def create(cls, arg: "Variation_728.cv_arg") -> "Variation_728":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_231:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_231:
        return self.rule.content

class RuleVariation_717(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_728.cv_arg
    cv_variation: TypeAlias = Variation_728

    @classmethod
    def create(cls, arg : "RuleVariation_717.cv_arg") -> "RuleVariation_717":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_728:
        return self.arg # type: ignore

class NonSpare_1510(NonSpare):
    cv_arg: TypeAlias = RuleVariation_717.cv_arg
    cv_name = "QC1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_717

    @classmethod
    def create(cls, arg : "NonSpare_1510.cv_arg") -> "NonSpare_1510":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_717:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_728:
        return self.rule.variation

class Item_743(Item):
    cv_arg: TypeAlias = NonSpare_1510.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1510

    @classmethod
    def create(cls, arg : "Item_743.cv_arg") -> "Item_743":
        return cls._create(arg) # type: ignore

class Content_236(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse D4", 1: "Low quality pulse D4"}

class RuleContent_236(RuleContentContextFree):
    cv_arg: TypeAlias = Content_236.cv_arg
    cv_content: TypeAlias = Content_236

    @property
    def content(self) -> Content_236:
        return self._get_content() # type: ignore

class Variation_856(Element):
    cv_arg: TypeAlias = RuleContent_236.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_236

    @classmethod
    def create(cls, arg: "Variation_856.cv_arg") -> "Variation_856":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_236:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_236:
        return self.rule.content

class RuleVariation_826(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_856.cv_arg
    cv_variation: TypeAlias = Variation_856

    @classmethod
    def create(cls, arg : "RuleVariation_826.cv_arg") -> "RuleVariation_826":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_856:
        return self.arg # type: ignore

class NonSpare_1524(NonSpare):
    cv_arg: TypeAlias = RuleVariation_826.cv_arg
    cv_name = "QD4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_826

    @classmethod
    def create(cls, arg : "NonSpare_1524.cv_arg") -> "NonSpare_1524":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_826:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_856:
        return self.rule.variation

class Item_757(Item):
    cv_arg: TypeAlias = NonSpare_1524.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1524

    @classmethod
    def create(cls, arg : "Item_757.cv_arg") -> "Item_757":
        return cls._create(arg) # type: ignore

class Content_235(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse D2", 1: "Low quality pulse D2"}

class RuleContent_235(RuleContentContextFree):
    cv_arg: TypeAlias = Content_235.cv_arg
    cv_content: TypeAlias = Content_235

    @property
    def content(self) -> Content_235:
        return self._get_content() # type: ignore

class Variation_933(Element):
    cv_arg: TypeAlias = RuleContent_235.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_235

    @classmethod
    def create(cls, arg: "Variation_933.cv_arg") -> "Variation_933":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_235:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_235:
        return self.rule.content

class RuleVariation_903(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_933.cv_arg
    cv_variation: TypeAlias = Variation_933

    @classmethod
    def create(cls, arg : "RuleVariation_903.cv_arg") -> "RuleVariation_903":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_933:
        return self.arg # type: ignore

class NonSpare_1522(NonSpare):
    cv_arg: TypeAlias = RuleVariation_903.cv_arg
    cv_name = "QD2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_903

    @classmethod
    def create(cls, arg : "NonSpare_1522.cv_arg") -> "NonSpare_1522":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_903:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_933:
        return self.rule.variation

class Item_755(Item):
    cv_arg: TypeAlias = NonSpare_1522.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1522

    @classmethod
    def create(cls, arg : "Item_755.cv_arg") -> "Item_755":
        return cls._create(arg) # type: ignore

class Content_234(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse D1", 1: "Low quality pulse D1"}

class RuleContent_234(RuleContentContextFree):
    cv_arg: TypeAlias = Content_234.cv_arg
    cv_content: TypeAlias = Content_234

    @property
    def content(self) -> Content_234:
        return self._get_content() # type: ignore

class Variation_979(Element):
    cv_arg: TypeAlias = RuleContent_234.cv_arg
    cv_bit_offset8 = 7
    cv_bit_size = 1
    cv_rule = RuleContent_234

    @classmethod
    def create(cls, arg: "Variation_979.cv_arg") -> "Variation_979":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_234:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_234:
        return self.rule.content

class RuleVariation_949(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_979.cv_arg
    cv_variation: TypeAlias = Variation_979

    @classmethod
    def create(cls, arg : "RuleVariation_949.cv_arg") -> "RuleVariation_949":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_979:
        return self.arg # type: ignore

class NonSpare_1519(NonSpare):
    cv_arg: TypeAlias = RuleVariation_949.cv_arg
    cv_name = "QD1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_949

    @classmethod
    def create(cls, arg : "NonSpare_1519.cv_arg") -> "NonSpare_1519":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_949:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_979:
        return self.rule.variation

class Item_752(Item):
    cv_arg: TypeAlias = NonSpare_1519.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1519

    @classmethod
    def create(cls, arg : "Item_752.cv_arg") -> "Item_752":
        return cls._create(arg) # type: ignore

class Variation_1032(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_715.cv_arg, Tuple[Literal["QA4"], RuleVariation_715.cv_arg]], Union[RuleVariation_823.cv_arg, Tuple[Literal["QA2"], RuleVariation_823.cv_arg]], Union[RuleVariation_899.cv_arg, Tuple[Literal["QA1"], RuleVariation_899.cv_arg]], Union[RuleVariation_948.cv_arg, Tuple[Literal["QB4"], RuleVariation_948.cv_arg]], Union[RuleVariation_46.cv_arg, Tuple[Literal["QB2"], RuleVariation_46.cv_arg]], Union[RuleVariation_421.cv_arg, Tuple[Literal["QB1"], RuleVariation_421.cv_arg]], Union[RuleVariation_527.cv_arg, Tuple[Literal["QC4"], RuleVariation_527.cv_arg]], Union[RuleVariation_631.cv_arg, Tuple[Literal["QC2"], RuleVariation_631.cv_arg]], Union[RuleVariation_717.cv_arg, Tuple[Literal["QC1"], RuleVariation_717.cv_arg]], Union[RuleVariation_826.cv_arg, Tuple[Literal["QD4"], RuleVariation_826.cv_arg]], Union[RuleVariation_903.cv_arg, Tuple[Literal["QD2"], RuleVariation_903.cv_arg]], Union[RuleVariation_949.cv_arg, Tuple[Literal["QD1"], RuleVariation_949.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1032.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_3, 4), (Item_730, 1), (Item_725, 1), (Item_722, 1), (Item_741, 1), (Item_736, 1), (Item_732, 1), (Item_749, 1), (Item_745, 1), (Item_743, 1), (Item_757, 1), (Item_755, 1), (Item_752, 1)]
    cv_items_dict = {"QA4": RuleVariation_715, "QA2": RuleVariation_823, "QA1": RuleVariation_899, "QB4": RuleVariation_948, "QB2": RuleVariation_46, "QB1": RuleVariation_421, "QC4": RuleVariation_527, "QC2": RuleVariation_631, "QC1": RuleVariation_717, "QD4": RuleVariation_826, "QD2": RuleVariation_903, "QD1": RuleVariation_949}

    @overload
    @classmethod
    def spec(cls, key : Literal["QA4"]) -> RuleVariation_715:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QA2"]) -> RuleVariation_823:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QA1"]) -> RuleVariation_899:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QB4"]) -> RuleVariation_948:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QB2"]) -> RuleVariation_46:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QB1"]) -> RuleVariation_421:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QC4"]) -> RuleVariation_527:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QC2"]) -> RuleVariation_631:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QC1"]) -> RuleVariation_717:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QD4"]) -> RuleVariation_826:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QD2"]) -> RuleVariation_903:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QD1"]) -> RuleVariation_949:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["QA4"], Literal["QA2"], Literal["QA1"], Literal["QB4"], Literal["QB2"], Literal["QB1"], Literal["QC4"], Literal["QC2"], Literal["QC1"], Literal["QD4"], Literal["QD2"], Literal["QD1"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["QA4"]) -> RuleVariation_715:
        ...
    @overload
    def get_item(self, key : Literal["QA2"]) -> RuleVariation_823:
        ...
    @overload
    def get_item(self, key : Literal["QA1"]) -> RuleVariation_899:
        ...
    @overload
    def get_item(self, key : Literal["QB4"]) -> RuleVariation_948:
        ...
    @overload
    def get_item(self, key : Literal["QB2"]) -> RuleVariation_46:
        ...
    @overload
    def get_item(self, key : Literal["QB1"]) -> RuleVariation_421:
        ...
    @overload
    def get_item(self, key : Literal["QC4"]) -> RuleVariation_527:
        ...
    @overload
    def get_item(self, key : Literal["QC2"]) -> RuleVariation_631:
        ...
    @overload
    def get_item(self, key : Literal["QC1"]) -> RuleVariation_717:
        ...
    @overload
    def get_item(self, key : Literal["QD4"]) -> RuleVariation_826:
        ...
    @overload
    def get_item(self, key : Literal["QD2"]) -> RuleVariation_903:
        ...
    @overload
    def get_item(self, key : Literal["QD1"]) -> RuleVariation_949:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1032.cv_arg") -> 'Variation_1032':
        return cls._create(arg) # type: ignore

class RuleVariation_1000(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1032.cv_arg
    cv_variation: TypeAlias = Variation_1032

    @classmethod
    def create(cls, arg : "RuleVariation_1000.cv_arg") -> "RuleVariation_1000":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1032:
        return self.arg # type: ignore

class NonSpare_233(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1000.cv_arg
    cv_name = "080"
    cv_title = "Mode-3/A Code Confidence Indicator"
    cv_rule: TypeAlias = RuleVariation_1000

    @classmethod
    def create(cls, arg : "NonSpare_233.cv_arg") -> "NonSpare_233":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1000:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1032:
        return self.rule.variation

class UapItem_233(UapItem):
    cv_non_spare: TypeAlias = NonSpare_233

class Item_12(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 2
    cv_bit_size = 2

class Variation_808(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 12
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_808.cv_arg") -> "Variation_808":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_778(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_808.cv_arg
    cv_variation: TypeAlias = Variation_808

    @classmethod
    def create(cls, arg : "RuleVariation_778.cv_arg") -> "RuleVariation_778":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_808:
        return self.arg # type: ignore

class NonSpare_1310(NonSpare):
    cv_arg: TypeAlias = RuleVariation_778.cv_arg
    cv_name = "MODEC"
    cv_title = "Mode-C Reply in Gray Notation"
    cv_rule: TypeAlias = RuleVariation_778

    @classmethod
    def create(cls, arg : "NonSpare_1310.cv_arg") -> "NonSpare_1310":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_778:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_808:
        return self.rule.variation

class Item_576(Item):
    cv_arg: TypeAlias = NonSpare_1310.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1310

    @classmethod
    def create(cls, arg : "Item_576.cv_arg") -> "Item_576":
        return cls._create(arg) # type: ignore

class Variation_852(Element):
    cv_arg: TypeAlias = RuleContent_225.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_225

    @classmethod
    def create(cls, arg: "Variation_852.cv_arg") -> "Variation_852":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_225:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_225:
        return self.rule.content

class RuleVariation_822(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_852.cv_arg
    cv_variation: TypeAlias = Variation_852

    @classmethod
    def create(cls, arg : "RuleVariation_822.cv_arg") -> "RuleVariation_822":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_852:
        return self.arg # type: ignore

class NonSpare_1488(NonSpare):
    cv_arg: TypeAlias = RuleVariation_822.cv_arg
    cv_name = "QA1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_822

    @classmethod
    def create(cls, arg : "NonSpare_1488.cv_arg") -> "NonSpare_1488":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_822:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_852:
        return self.rule.variation

class Item_721(Item):
    cv_arg: TypeAlias = NonSpare_1488.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1488

    @classmethod
    def create(cls, arg : "Item_721.cv_arg") -> "Item_721":
        return cls._create(arg) # type: ignore

class Variation_932(Element):
    cv_arg: TypeAlias = RuleContent_232.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_232

    @classmethod
    def create(cls, arg: "Variation_932.cv_arg") -> "Variation_932":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_232:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_232:
        return self.rule.content

class RuleVariation_902(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_932.cv_arg
    cv_variation: TypeAlias = Variation_932

    @classmethod
    def create(cls, arg : "RuleVariation_902.cv_arg") -> "RuleVariation_902":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_932:
        return self.arg # type: ignore

class NonSpare_1513(NonSpare):
    cv_arg: TypeAlias = RuleVariation_902.cv_arg
    cv_name = "QC2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_902

    @classmethod
    def create(cls, arg : "NonSpare_1513.cv_arg") -> "NonSpare_1513":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_902:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_932:
        return self.rule.variation

class Item_746(Item):
    cv_arg: TypeAlias = NonSpare_1513.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1513

    @classmethod
    def create(cls, arg : "Item_746.cv_arg") -> "Item_746":
        return cls._create(arg) # type: ignore

class Variation_976(Element):
    cv_arg: TypeAlias = RuleContent_226.cv_arg
    cv_bit_offset8 = 7
    cv_bit_size = 1
    cv_rule = RuleContent_226

    @classmethod
    def create(cls, arg: "Variation_976.cv_arg") -> "Variation_976":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_226:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_226:
        return self.rule.content

class RuleVariation_946(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_976.cv_arg
    cv_variation: TypeAlias = Variation_976

    @classmethod
    def create(cls, arg : "RuleVariation_946.cv_arg") -> "RuleVariation_946":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_976:
        return self.arg # type: ignore

class NonSpare_1493(NonSpare):
    cv_arg: TypeAlias = RuleVariation_946.cv_arg
    cv_name = "QA2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_946

    @classmethod
    def create(cls, arg : "NonSpare_1493.cv_arg") -> "NonSpare_1493":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_946:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_976:
        return self.rule.variation

class Item_726(Item):
    cv_arg: TypeAlias = NonSpare_1493.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1493

    @classmethod
    def create(cls, arg : "Item_726.cv_arg") -> "Item_726":
        return cls._create(arg) # type: ignore

class Variation_47(Element):
    cv_arg: TypeAlias = RuleContent_233.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_233

    @classmethod
    def create(cls, arg: "Variation_47.cv_arg") -> "Variation_47":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_233:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_233:
        return self.rule.content

class RuleVariation_47(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_47.cv_arg
    cv_variation: TypeAlias = Variation_47

    @classmethod
    def create(cls, arg : "RuleVariation_47.cv_arg") -> "RuleVariation_47":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_47:
        return self.arg # type: ignore

class NonSpare_1515(NonSpare):
    cv_arg: TypeAlias = RuleVariation_47.cv_arg
    cv_name = "QC4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_47

    @classmethod
    def create(cls, arg : "NonSpare_1515.cv_arg") -> "NonSpare_1515":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_47:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_47:
        return self.rule.variation

class Item_748(Item):
    cv_arg: TypeAlias = NonSpare_1515.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1515

    @classmethod
    def create(cls, arg : "Item_748.cv_arg") -> "Item_748":
        return cls._create(arg) # type: ignore

class Variation_431(Element):
    cv_arg: TypeAlias = RuleContent_227.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_227

    @classmethod
    def create(cls, arg: "Variation_431.cv_arg") -> "Variation_431":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_227:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_227:
        return self.rule.content

class RuleVariation_420(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_431.cv_arg
    cv_variation: TypeAlias = Variation_431

    @classmethod
    def create(cls, arg : "RuleVariation_420.cv_arg") -> "RuleVariation_420":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_431:
        return self.arg # type: ignore

class NonSpare_1495(NonSpare):
    cv_arg: TypeAlias = RuleVariation_420.cv_arg
    cv_name = "QA4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_420

    @classmethod
    def create(cls, arg : "NonSpare_1495.cv_arg") -> "NonSpare_1495":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_420:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_431:
        return self.rule.variation

class Item_728(Item):
    cv_arg: TypeAlias = NonSpare_1495.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1495

    @classmethod
    def create(cls, arg : "Item_728.cv_arg") -> "Item_728":
        return cls._create(arg) # type: ignore

class Variation_537(Element):
    cv_arg: TypeAlias = RuleContent_228.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_228

    @classmethod
    def create(cls, arg: "Variation_537.cv_arg") -> "Variation_537":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_228:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_228:
        return self.rule.content

class RuleVariation_526(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_537.cv_arg
    cv_variation: TypeAlias = Variation_537

    @classmethod
    def create(cls, arg : "RuleVariation_526.cv_arg") -> "RuleVariation_526":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_537:
        return self.arg # type: ignore

class NonSpare_1500(NonSpare):
    cv_arg: TypeAlias = RuleVariation_526.cv_arg
    cv_name = "QB1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_526

    @classmethod
    def create(cls, arg : "NonSpare_1500.cv_arg") -> "NonSpare_1500":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_526:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_537:
        return self.rule.variation

class Item_733(Item):
    cv_arg: TypeAlias = NonSpare_1500.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1500

    @classmethod
    def create(cls, arg : "Item_733.cv_arg") -> "Item_733":
        return cls._create(arg) # type: ignore

class Variation_643(Element):
    cv_arg: TypeAlias = RuleContent_234.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_234

    @classmethod
    def create(cls, arg: "Variation_643.cv_arg") -> "Variation_643":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_234:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_234:
        return self.rule.content

class RuleVariation_632(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_643.cv_arg
    cv_variation: TypeAlias = Variation_643

    @classmethod
    def create(cls, arg : "RuleVariation_632.cv_arg") -> "RuleVariation_632":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_643:
        return self.arg # type: ignore

class NonSpare_1518(NonSpare):
    cv_arg: TypeAlias = RuleVariation_632.cv_arg
    cv_name = "QD1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_632

    @classmethod
    def create(cls, arg : "NonSpare_1518.cv_arg") -> "NonSpare_1518":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_632:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_643:
        return self.rule.variation

class Item_751(Item):
    cv_arg: TypeAlias = NonSpare_1518.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1518

    @classmethod
    def create(cls, arg : "Item_751.cv_arg") -> "Item_751":
        return cls._create(arg) # type: ignore

class Variation_727(Element):
    cv_arg: TypeAlias = RuleContent_229.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_229

    @classmethod
    def create(cls, arg: "Variation_727.cv_arg") -> "Variation_727":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_229:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_229:
        return self.rule.content

class RuleVariation_716(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_727.cv_arg
    cv_variation: TypeAlias = Variation_727

    @classmethod
    def create(cls, arg : "RuleVariation_716.cv_arg") -> "RuleVariation_716":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_727:
        return self.arg # type: ignore

class NonSpare_1504(NonSpare):
    cv_arg: TypeAlias = RuleVariation_716.cv_arg
    cv_name = "QB2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_716

    @classmethod
    def create(cls, arg : "NonSpare_1504.cv_arg") -> "NonSpare_1504":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_716:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_727:
        return self.rule.variation

class Item_737(Item):
    cv_arg: TypeAlias = NonSpare_1504.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1504

    @classmethod
    def create(cls, arg : "Item_737.cv_arg") -> "Item_737":
        return cls._create(arg) # type: ignore

class Variation_855(Element):
    cv_arg: TypeAlias = RuleContent_235.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_235

    @classmethod
    def create(cls, arg: "Variation_855.cv_arg") -> "Variation_855":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_235:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_235:
        return self.rule.content

class RuleVariation_825(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_855.cv_arg
    cv_variation: TypeAlias = Variation_855

    @classmethod
    def create(cls, arg : "RuleVariation_825.cv_arg") -> "RuleVariation_825":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_855:
        return self.arg # type: ignore

class NonSpare_1521(NonSpare):
    cv_arg: TypeAlias = RuleVariation_825.cv_arg
    cv_name = "QD2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_825

    @classmethod
    def create(cls, arg : "NonSpare_1521.cv_arg") -> "NonSpare_1521":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_825:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_855:
        return self.rule.variation

class Item_754(Item):
    cv_arg: TypeAlias = NonSpare_1521.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1521

    @classmethod
    def create(cls, arg : "Item_754.cv_arg") -> "Item_754":
        return cls._create(arg) # type: ignore

class Variation_931(Element):
    cv_arg: TypeAlias = RuleContent_230.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_230

    @classmethod
    def create(cls, arg: "Variation_931.cv_arg") -> "Variation_931":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_230:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_230:
        return self.rule.content

class RuleVariation_901(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_931.cv_arg
    cv_variation: TypeAlias = Variation_931

    @classmethod
    def create(cls, arg : "RuleVariation_901.cv_arg") -> "RuleVariation_901":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_931:
        return self.arg # type: ignore

class NonSpare_1507(NonSpare):
    cv_arg: TypeAlias = RuleVariation_901.cv_arg
    cv_name = "QB4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_901

    @classmethod
    def create(cls, arg : "NonSpare_1507.cv_arg") -> "NonSpare_1507":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_901:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_931:
        return self.rule.variation

class Item_740(Item):
    cv_arg: TypeAlias = NonSpare_1507.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1507

    @classmethod
    def create(cls, arg : "Item_740.cv_arg") -> "Item_740":
        return cls._create(arg) # type: ignore

class Variation_980(Element):
    cv_arg: TypeAlias = RuleContent_236.cv_arg
    cv_bit_offset8 = 7
    cv_bit_size = 1
    cv_rule = RuleContent_236

    @classmethod
    def create(cls, arg: "Variation_980.cv_arg") -> "Variation_980":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_236:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_236:
        return self.rule.content

class RuleVariation_950(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_980.cv_arg
    cv_variation: TypeAlias = Variation_980

    @classmethod
    def create(cls, arg : "RuleVariation_950.cv_arg") -> "RuleVariation_950":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_980:
        return self.arg # type: ignore

class NonSpare_1525(NonSpare):
    cv_arg: TypeAlias = RuleVariation_950.cv_arg
    cv_name = "QD4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_950

    @classmethod
    def create(cls, arg : "NonSpare_1525.cv_arg") -> "NonSpare_1525":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_950:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_980:
        return self.rule.variation

class Item_758(Item):
    cv_arg: TypeAlias = NonSpare_1525.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1525

    @classmethod
    def create(cls, arg : "Item_758.cv_arg") -> "Item_758":
        return cls._create(arg) # type: ignore

class Variation_1253(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_15.cv_arg, Tuple[Literal["V"], RuleVariation_15.cv_arg]], Union[RuleVariation_396.cv_arg, Tuple[Literal["G"], RuleVariation_396.cv_arg]], int, Union[RuleVariation_778.cv_arg, Tuple[Literal["MODEC"], RuleVariation_778.cv_arg]], int, Union[RuleVariation_717.cv_arg, Tuple[Literal["QC1"], RuleVariation_717.cv_arg]], Union[RuleVariation_822.cv_arg, Tuple[Literal["QA1"], RuleVariation_822.cv_arg]], Union[RuleVariation_902.cv_arg, Tuple[Literal["QC2"], RuleVariation_902.cv_arg]], Union[RuleVariation_946.cv_arg, Tuple[Literal["QA2"], RuleVariation_946.cv_arg]], Union[RuleVariation_47.cv_arg, Tuple[Literal["QC4"], RuleVariation_47.cv_arg]], Union[RuleVariation_420.cv_arg, Tuple[Literal["QA4"], RuleVariation_420.cv_arg]], Union[RuleVariation_526.cv_arg, Tuple[Literal["QB1"], RuleVariation_526.cv_arg]], Union[RuleVariation_632.cv_arg, Tuple[Literal["QD1"], RuleVariation_632.cv_arg]], Union[RuleVariation_716.cv_arg, Tuple[Literal["QB2"], RuleVariation_716.cv_arg]], Union[RuleVariation_825.cv_arg, Tuple[Literal["QD2"], RuleVariation_825.cv_arg]], Union[RuleVariation_901.cv_arg, Tuple[Literal["QB4"], RuleVariation_901.cv_arg]], Union[RuleVariation_950.cv_arg, Tuple[Literal["QD4"], RuleVariation_950.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1253.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1102, 1), (Item_355, 1), (Item_12, 2), (Item_576, 12), (Item_3, 4), (Item_743, 1), (Item_721, 1), (Item_746, 1), (Item_726, 1), (Item_748, 1), (Item_728, 1), (Item_733, 1), (Item_751, 1), (Item_737, 1), (Item_754, 1), (Item_740, 1), (Item_758, 1)]
    cv_items_dict = {"V": RuleVariation_15, "G": RuleVariation_396, "MODEC": RuleVariation_778, "QC1": RuleVariation_717, "QA1": RuleVariation_822, "QC2": RuleVariation_902, "QA2": RuleVariation_946, "QC4": RuleVariation_47, "QA4": RuleVariation_420, "QB1": RuleVariation_526, "QD1": RuleVariation_632, "QB2": RuleVariation_716, "QD2": RuleVariation_825, "QB4": RuleVariation_901, "QD4": RuleVariation_950}

    @overload
    @classmethod
    def spec(cls, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> RuleVariation_396:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MODEC"]) -> RuleVariation_778:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QC1"]) -> RuleVariation_717:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QA1"]) -> RuleVariation_822:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QC2"]) -> RuleVariation_902:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QA2"]) -> RuleVariation_946:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QC4"]) -> RuleVariation_47:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QA4"]) -> RuleVariation_420:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QB1"]) -> RuleVariation_526:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QD1"]) -> RuleVariation_632:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QB2"]) -> RuleVariation_716:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QD2"]) -> RuleVariation_825:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QB4"]) -> RuleVariation_901:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QD4"]) -> RuleVariation_950:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["V"], Literal["G"], Literal["MODEC"], Literal["QC1"], Literal["QA1"], Literal["QC2"], Literal["QA2"], Literal["QC4"], Literal["QA4"], Literal["QB1"], Literal["QD1"], Literal["QB2"], Literal["QD2"], Literal["QB4"], Literal["QD4"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> RuleVariation_396:
        ...
    @overload
    def get_item(self, key : Literal["MODEC"]) -> RuleVariation_778:
        ...
    @overload
    def get_item(self, key : Literal["QC1"]) -> RuleVariation_717:
        ...
    @overload
    def get_item(self, key : Literal["QA1"]) -> RuleVariation_822:
        ...
    @overload
    def get_item(self, key : Literal["QC2"]) -> RuleVariation_902:
        ...
    @overload
    def get_item(self, key : Literal["QA2"]) -> RuleVariation_946:
        ...
    @overload
    def get_item(self, key : Literal["QC4"]) -> RuleVariation_47:
        ...
    @overload
    def get_item(self, key : Literal["QA4"]) -> RuleVariation_420:
        ...
    @overload
    def get_item(self, key : Literal["QB1"]) -> RuleVariation_526:
        ...
    @overload
    def get_item(self, key : Literal["QD1"]) -> RuleVariation_632:
        ...
    @overload
    def get_item(self, key : Literal["QB2"]) -> RuleVariation_716:
        ...
    @overload
    def get_item(self, key : Literal["QD2"]) -> RuleVariation_825:
        ...
    @overload
    def get_item(self, key : Literal["QB4"]) -> RuleVariation_901:
        ...
    @overload
    def get_item(self, key : Literal["QD4"]) -> RuleVariation_950:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1253.cv_arg") -> 'Variation_1253':
        return cls._create(arg) # type: ignore

class RuleVariation_1182(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1253.cv_arg
    cv_variation: TypeAlias = Variation_1253

    @classmethod
    def create(cls, arg : "RuleVariation_1182.cv_arg") -> "RuleVariation_1182":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1253:
        return self.arg # type: ignore

class NonSpare_274(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1182.cv_arg
    cv_name = "100"
    cv_title = "Mode-C Code and Code Confidence Indicator"
    cv_rule: TypeAlias = RuleVariation_1182

    @classmethod
    def create(cls, arg : "NonSpare_274.cv_arg") -> "NonSpare_274":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1182:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1253:
        return self.rule.variation

class UapItem_274(UapItem):
    cv_non_spare: TypeAlias = NonSpare_274

class NonSpare_189(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1000.cv_arg
    cv_name = "060"
    cv_title = "Mode-2 Code Confidence Indicator"
    cv_rule: TypeAlias = RuleVariation_1000

    @classmethod
    def create(cls, arg : "NonSpare_189.cv_arg") -> "NonSpare_189":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1000:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1032:
        return self.rule.variation

class UapItem_189(UapItem):
    cv_non_spare: TypeAlias = NonSpare_189

class Content_377(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No warning nor error condition", 1: "Garbled reply", 2: "Reflection", 3: "Sidelobe reply", 4: "Split plot", 5: "Second time around reply", 6: "Angels", 7: "Terrestrial vehicles", 64: "Possible wrong code in Mode-3/A", 65: "Possible wrong altitude information, transmitted when the Code C credibility check fails together with the Mode-C code in binary notation", 66: "Possible phantom MSSR plot", 80: "Fixed PSR plot", 81: "Slow PSR plot", 82: "Low quality PSR plot"}

class RuleContent_377(RuleContentContextFree):
    cv_arg: TypeAlias = Content_377.cv_arg
    cv_content: TypeAlias = Content_377

    @property
    def content(self) -> Content_377:
        return self._get_content() # type: ignore

class Variation_152(Element):
    cv_arg: TypeAlias = RuleContent_377.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 7
    cv_rule = RuleContent_377

    @classmethod
    def create(cls, arg: "Variation_152.cv_arg") -> "Variation_152":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_377:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_377:
        return self.rule.content

class Variation_1455(Repetitive):
    cv_arg: TypeAlias = List[Variation_152.cv_arg]
    cv_rep_bytes = None
    cv_variation: TypeAlias = Variation_152

    @classmethod
    def create(cls, arg: "Variation_1455.cv_arg") -> 'Variation_1455':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_152]:
        return self._get_list() # type: ignore

class RuleVariation_1376(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1455.cv_arg
    cv_variation: TypeAlias = Variation_1455

    @classmethod
    def create(cls, arg : "RuleVariation_1376.cv_arg") -> "RuleVariation_1376":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1455:
        return self.arg # type: ignore

class NonSpare_117(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1376.cv_arg
    cv_name = "030"
    cv_title = "Warning/Error Conditions"
    cv_rule: TypeAlias = RuleVariation_1376

    @classmethod
    def create(cls, arg : "NonSpare_117.cv_arg") -> "NonSpare_117":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1376:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1455:
        return self.rule.variation

class UapItem_117(UapItem):
    cv_non_spare: TypeAlias = NonSpare_117

class Content_167(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "X-pulse received in Mode-3/A reply"}

class RuleContent_167(RuleContentContextFree):
    cv_arg: TypeAlias = Content_167.cv_arg
    cv_content: TypeAlias = Content_167

    @property
    def content(self) -> Content_167:
        return self._get_content() # type: ignore

class Variation_37(Element):
    cv_arg: TypeAlias = RuleContent_167.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_167

    @classmethod
    def create(cls, arg: "Variation_37.cv_arg") -> "Variation_37":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_167:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_167:
        return self.rule.content

class RuleVariation_37(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_37.cv_arg
    cv_variation: TypeAlias = Variation_37

    @classmethod
    def create(cls, arg : "RuleVariation_37.cv_arg") -> "RuleVariation_37":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_37:
        return self.arg # type: ignore

class NonSpare_2113(NonSpare):
    cv_arg: TypeAlias = RuleVariation_37.cv_arg
    cv_name = "XA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_37

    @classmethod
    def create(cls, arg : "NonSpare_2113.cv_arg") -> "NonSpare_2113":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_37:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_37:
        return self.rule.variation

class Item_1214(Item):
    cv_arg: TypeAlias = NonSpare_2113.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2113

    @classmethod
    def create(cls, arg : "Item_1214.cv_arg") -> "Item_1214":
        return cls._create(arg) # type: ignore

class Item_7(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 1
    cv_bit_size = 1

class Content_168(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "X-pulse received in Mode-C reply"}

class RuleContent_168(RuleContentContextFree):
    cv_arg: TypeAlias = Content_168.cv_arg
    cv_content: TypeAlias = Content_168

    @property
    def content(self) -> Content_168:
        return self._get_content() # type: ignore

class Variation_525(Element):
    cv_arg: TypeAlias = RuleContent_168.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_168

    @classmethod
    def create(cls, arg: "Variation_525.cv_arg") -> "Variation_525":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_168:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_168:
        return self.rule.content

class RuleVariation_514(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_525.cv_arg
    cv_variation: TypeAlias = Variation_525

    @classmethod
    def create(cls, arg : "RuleVariation_514.cv_arg") -> "RuleVariation_514":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_525:
        return self.arg # type: ignore

class NonSpare_2114(NonSpare):
    cv_arg: TypeAlias = RuleVariation_514.cv_arg
    cv_name = "XC"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_514

    @classmethod
    def create(cls, arg : "NonSpare_2114.cv_arg") -> "NonSpare_2114":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_514:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_525:
        return self.rule.variation

class Item_1215(Item):
    cv_arg: TypeAlias = NonSpare_2114.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2114

    @classmethod
    def create(cls, arg : "Item_1215.cv_arg") -> "Item_1215":
        return cls._create(arg) # type: ignore

class Item_17(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 3
    cv_bit_size = 2

class Content_166(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "X-pulse received in Mode-2 reply"}

class RuleContent_166(RuleContentContextFree):
    cv_arg: TypeAlias = Content_166.cv_arg
    cv_content: TypeAlias = Content_166

    @property
    def content(self) -> Content_166:
        return self._get_content() # type: ignore

class Variation_842(Element):
    cv_arg: TypeAlias = RuleContent_166.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_166

    @classmethod
    def create(cls, arg: "Variation_842.cv_arg") -> "Variation_842":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_166:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_166:
        return self.rule.content

class RuleVariation_812(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_842.cv_arg
    cv_variation: TypeAlias = Variation_842

    @classmethod
    def create(cls, arg : "RuleVariation_812.cv_arg") -> "RuleVariation_812":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_842:
        return self.arg # type: ignore

class NonSpare_2107(NonSpare):
    cv_arg: TypeAlias = RuleVariation_812.cv_arg
    cv_name = "X2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_812

    @classmethod
    def create(cls, arg : "NonSpare_2107.cv_arg") -> "NonSpare_2107":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_812:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_842:
        return self.rule.variation

class Item_1208(Item):
    cv_arg: TypeAlias = NonSpare_2107.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2107

    @classmethod
    def create(cls, arg : "Item_1208.cv_arg") -> "Item_1208":
        return cls._create(arg) # type: ignore

class Item_27(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 6
    cv_bit_size = 2

class Variation_1320(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_37.cv_arg, Tuple[Literal["XA"], RuleVariation_37.cv_arg]], int, Union[RuleVariation_514.cv_arg, Tuple[Literal["XC"], RuleVariation_514.cv_arg]], int, Union[RuleVariation_812.cv_arg, Tuple[Literal["X2"], RuleVariation_812.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1320.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_1214, 1), (Item_7, 1), (Item_1215, 1), (Item_17, 2), (Item_1208, 1), (Item_27, 2)]
    cv_items_dict = {"XA": RuleVariation_37, "XC": RuleVariation_514, "X2": RuleVariation_812}

    @overload
    @classmethod
    def spec(cls, key : Literal["XA"]) -> RuleVariation_37:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["XC"]) -> RuleVariation_514:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["X2"]) -> RuleVariation_812:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["XA"], Literal["XC"], Literal["X2"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["XA"]) -> RuleVariation_37:
        ...
    @overload
    def get_item(self, key : Literal["XC"]) -> RuleVariation_514:
        ...
    @overload
    def get_item(self, key : Literal["X2"]) -> RuleVariation_812:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1320.cv_arg") -> 'Variation_1320':
        return cls._create(arg) # type: ignore

class RuleVariation_1244(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1320.cv_arg
    cv_variation: TypeAlias = Variation_1320

    @classmethod
    def create(cls, arg : "RuleVariation_1244.cv_arg") -> "RuleVariation_1244":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1320:
        return self.arg # type: ignore

class NonSpare_346(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1244.cv_arg
    cv_name = "150"
    cv_title = "Presence of X-Pulse"
    cv_rule: TypeAlias = RuleVariation_1244

    @classmethod
    def create(cls, arg : "NonSpare_346.cv_arg") -> "NonSpare_346":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1244:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1320:
        return self.rule.variation

class UapItem_346(UapItem):
    cv_non_spare: TypeAlias = NonSpare_346

class UapItem_549(UapItemSpare):
    pass

class Variation_1464(Explicit):
    cv_arg: TypeAlias = bytes
    cv_explicit_type: TypeAlias = SpecialPurpose

    @classmethod
    def create(cls, arg: "Variation_1464.cv_arg") -> 'Variation_1464':
        return cls._create(arg) # type: ignore

class RuleVariation_1385(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1464.cv_arg
    cv_variation: TypeAlias = Variation_1464

    @classmethod
    def create(cls, arg : "RuleVariation_1385.cv_arg") -> "RuleVariation_1385":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1464:
        return self.arg # type: ignore

class NonSpare_1732(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1385.cv_arg
    cv_name = "SP"
    cv_title = "Special Purpose Field"
    cv_rule: TypeAlias = RuleVariation_1385

    @classmethod
    def create(cls, arg : "NonSpare_1732.cv_arg") -> "NonSpare_1732":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1385:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1464:
        return self.rule.variation

class UapItem_548(UapItem):
    cv_non_spare: TypeAlias = NonSpare_1732

class UapItem_550(UapItemRFS):
    pass

class Record_18(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_36.cv_arg,
        "020": NonSpare_87.cv_arg,
        "040": NonSpare_138.cv_arg,
        "070": NonSpare_213.cv_arg,
        "090": NonSpare_253.cv_arg,
        "130": NonSpare_312.cv_arg,
        "141": NonSpare_337.cv_arg,
        "050": NonSpare_174.cv_arg,
        "120": NonSpare_300.cv_arg,
        "131": NonSpare_316.cv_arg,
        "080": NonSpare_233.cv_arg,
        "100": NonSpare_274.cv_arg,
        "060": NonSpare_189.cv_arg,
        "030": NonSpare_117.cv_arg,
        "150": NonSpare_346.cv_arg,
        "SP": NonSpare_1732.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_36.cv_arg],
        Tuple[Literal["020"], NonSpare_87.cv_arg],
        Tuple[Literal["040"], NonSpare_138.cv_arg],
        Tuple[Literal["070"], NonSpare_213.cv_arg],
        Tuple[Literal["090"], NonSpare_253.cv_arg],
        Tuple[Literal["130"], NonSpare_312.cv_arg],
        Tuple[Literal["141"], NonSpare_337.cv_arg],
        Tuple[Literal["050"], NonSpare_174.cv_arg],
        Tuple[Literal["120"], NonSpare_300.cv_arg],
        Tuple[Literal["131"], NonSpare_316.cv_arg],
        Tuple[Literal["080"], NonSpare_233.cv_arg],
        Tuple[Literal["100"], NonSpare_274.cv_arg],
        Tuple[Literal["060"], NonSpare_189.cv_arg],
        Tuple[Literal["030"], NonSpare_117.cv_arg],
        Tuple[Literal["150"], NonSpare_346.cv_arg],
        Tuple[Literal["SP"], NonSpare_1732.cv_arg],
    ]
    cv_fspec_max_bytes = 3
    cv_items_list = [UapItem_36, UapItem_87, UapItem_138, UapItem_213, UapItem_253, UapItem_312, UapItem_337, UapItem_174, UapItem_300, UapItem_316, UapItem_233, UapItem_274, UapItem_189, UapItem_117, UapItem_346, UapItem_549, UapItem_549, UapItem_549, UapItem_549, UapItem_548, UapItem_550]
    cv_items_dict = {"010": NonSpare_36, "020": NonSpare_87, "040": NonSpare_138, "070": NonSpare_213, "090": NonSpare_253, "130": NonSpare_312, "141": NonSpare_337, "050": NonSpare_174, "120": NonSpare_300, "131": NonSpare_316, "080": NonSpare_233, "100": NonSpare_274, "060": NonSpare_189, "030": NonSpare_117, "150": NonSpare_346, "SP": NonSpare_1732}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_36:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_87:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> NonSpare_138:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> NonSpare_213:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> NonSpare_253:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["130"]) -> NonSpare_312:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["141"]) -> NonSpare_337:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> NonSpare_174:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> NonSpare_300:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["131"]) -> NonSpare_316:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> NonSpare_233:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_274:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_189:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> NonSpare_117:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["150"]) -> NonSpare_346:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1732:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["020"], Literal["040"], Literal["070"], Literal["090"], Literal["130"], Literal["141"], Literal["050"], Literal["120"], Literal["131"], Literal["080"], Literal["100"], Literal["060"], Literal["030"], Literal["150"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_36]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_87]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_138]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_213]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_253]:
        ...
    @overload
    def get_item(self, key : Literal["130"]) -> Optional[NonSpare_312]:
        ...
    @overload
    def get_item(self, key : Literal["141"]) -> Optional[NonSpare_337]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_174]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_300]:
        ...
    @overload
    def get_item(self, key : Literal["131"]) -> Optional[NonSpare_316]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_233]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_274]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_189]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_117]:
        ...
    @overload
    def get_item(self, key : Literal["150"]) -> Optional[NonSpare_346]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1732]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_36.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_87.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_138.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_213.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_253.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["130"], val : NonSpare_312.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["141"], val : NonSpare_337.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_174.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_300.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["131"], val : NonSpare_316.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_233.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_274.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_189.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_117.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["150"], val : NonSpare_346.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1732.cv_arg) -> 'Record_18':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["130"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["141"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["131"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["150"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_18':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_36]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_87]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["040"]) -> List[NonSpare_138]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["070"]) -> List[NonSpare_213]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_253]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["130"]) -> List[NonSpare_312]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["141"]) -> List[NonSpare_337]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_174]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["120"]) -> List[NonSpare_300]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["131"]) -> List[NonSpare_316]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["080"]) -> List[NonSpare_233]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_274]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["060"]) -> List[NonSpare_189]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["030"]) -> List[NonSpare_117]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["150"]) -> List[NonSpare_346]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1732]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_18.cv_arg", rfs : Optional[List["Record_18.cv_union"]] = None) -> 'Record_18':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_18", Bits]]:
        return cls._parse(bs) # type: ignore

class Variation_253(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_253.cv_arg") -> "Variation_253":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_246(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_253.cv_arg
    cv_variation: TypeAlias = Variation_253

    @classmethod
    def create(cls, arg : "RuleVariation_246.cv_arg") -> "RuleVariation_246":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_253:
        return self.arg # type: ignore

class NonSpare_366(NonSpare):
    cv_arg: TypeAlias = RuleVariation_246.cv_arg
    cv_name = "161"
    cv_title = "Track Plot Number"
    cv_rule: TypeAlias = RuleVariation_246

    @classmethod
    def create(cls, arg : "NonSpare_366.cv_arg") -> "NonSpare_366":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_246:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_253:
        return self.rule.variation

class UapItem_366(UapItem):
    cv_non_spare: TypeAlias = NonSpare_366

class Content_674(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 1.5625e-2
    cv_unit = "NM"

    def as_quantity(self, cv_unit : Optional[Literal["NM"]] = None) -> float:
        return self._as_quantity()

class RuleContent_674(RuleContentContextFree):
    cv_arg: TypeAlias = Content_674.cv_arg
    cv_content: TypeAlias = Content_674

    @property
    def content(self) -> Content_674:
        return self._get_content() # type: ignore

class Variation_284(Element):
    cv_arg: TypeAlias = RuleContent_674.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_674

    @classmethod
    def create(cls, arg: "Variation_284.cv_arg") -> "Variation_284":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_674:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_674:
        return self.rule.content

class RuleVariation_277(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_284.cv_arg
    cv_variation: TypeAlias = Variation_284

    @classmethod
    def create(cls, arg : "RuleVariation_277.cv_arg") -> "RuleVariation_277":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_284:
        return self.arg # type: ignore

class NonSpare_2099(NonSpare):
    cv_arg: TypeAlias = RuleVariation_277.cv_arg
    cv_name = "X"
    cv_title = "X-Component"
    cv_rule: TypeAlias = RuleVariation_277

    @classmethod
    def create(cls, arg : "NonSpare_2099.cv_arg") -> "NonSpare_2099":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_277:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_284:
        return self.rule.variation

class Item_1200(Item):
    cv_arg: TypeAlias = NonSpare_2099.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2099

    @classmethod
    def create(cls, arg : "Item_1200.cv_arg") -> "Item_1200":
        return cls._create(arg) # type: ignore

class NonSpare_2153(NonSpare):
    cv_arg: TypeAlias = RuleVariation_277.cv_arg
    cv_name = "Y"
    cv_title = "Y-Component"
    cv_rule: TypeAlias = RuleVariation_277

    @classmethod
    def create(cls, arg : "NonSpare_2153.cv_arg") -> "NonSpare_2153":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_277:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_284:
        return self.rule.variation

class Item_1251(Item):
    cv_arg: TypeAlias = NonSpare_2153.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2153

    @classmethod
    def create(cls, arg : "Item_1251.cv_arg") -> "Item_1251":
        return cls._create(arg) # type: ignore

class Variation_1313(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_277.cv_arg, Tuple[Literal["X"], RuleVariation_277.cv_arg]], Union[RuleVariation_277.cv_arg, Tuple[Literal["Y"], RuleVariation_277.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1313.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1200, 16), (Item_1251, 16)]
    cv_items_dict = {"X": RuleVariation_277, "Y": RuleVariation_277}

    @overload
    @classmethod
    def spec(cls, key : Literal["X"]) -> RuleVariation_277:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y"]) -> RuleVariation_277:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X"], Literal["Y"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X"]) -> RuleVariation_277:
        ...
    @overload
    def get_item(self, key : Literal["Y"]) -> RuleVariation_277:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1313.cv_arg") -> 'Variation_1313':
        return cls._create(arg) # type: ignore

class RuleVariation_1240(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1313.cv_arg
    cv_variation: TypeAlias = Variation_1313

    @classmethod
    def create(cls, arg : "RuleVariation_1240.cv_arg") -> "RuleVariation_1240":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1313:
        return self.arg # type: ignore

class NonSpare_159(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1240.cv_arg
    cv_name = "042"
    cv_title = "Calculated Position in Cartesian Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1240

    @classmethod
    def create(cls, arg : "NonSpare_159.cv_arg") -> "NonSpare_159":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1240:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1313:
        return self.rule.variation

class UapItem_159(UapItem):
    cv_non_spare: TypeAlias = NonSpare_159

class Content_778(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM/s"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 6.103515625e-5
    cv_unit = "NM/s"

    def as_quantity(self, cv_unit : Optional[Literal["NM/s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_777(RuleContentContextFree):
    cv_arg: TypeAlias = Content_778.cv_arg
    cv_content: TypeAlias = Content_778

    @property
    def content(self) -> Content_778:
        return self._get_content() # type: ignore

class Variation_338(Element):
    cv_arg: TypeAlias = RuleContent_777.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_777

    @classmethod
    def create(cls, arg: "Variation_338.cv_arg") -> "Variation_338":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_777:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_778:
        return self.rule.content

class RuleVariation_331(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_338.cv_arg
    cv_variation: TypeAlias = Variation_338

    @classmethod
    def create(cls, arg : "RuleVariation_331.cv_arg") -> "RuleVariation_331":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_338:
        return self.arg # type: ignore

class NonSpare_1041(NonSpare):
    cv_arg: TypeAlias = RuleVariation_331.cv_arg
    cv_name = "GSP"
    cv_title = "Calculated Groundspeed"
    cv_rule: TypeAlias = RuleVariation_331

    @classmethod
    def create(cls, arg : "NonSpare_1041.cv_arg") -> "NonSpare_1041":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_331:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_338:
        return self.rule.variation

class Item_375(Item):
    cv_arg: TypeAlias = NonSpare_1041.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1041

    @classmethod
    def create(cls, arg : "Item_375.cv_arg") -> "Item_375":
        return cls._create(arg) # type: ignore

class NonSpare_1061(NonSpare):
    cv_arg: TypeAlias = RuleVariation_336.cv_arg
    cv_name = "HDG"
    cv_title = "Calculated Heading"
    cv_rule: TypeAlias = RuleVariation_336

    @classmethod
    def create(cls, arg : "NonSpare_1061.cv_arg") -> "NonSpare_1061":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_336:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_343:
        return self.rule.variation

class Item_389(Item):
    cv_arg: TypeAlias = NonSpare_1061.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1061

    @classmethod
    def create(cls, arg : "Item_389.cv_arg") -> "Item_389":
        return cls._create(arg) # type: ignore

class Variation_1114(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_331.cv_arg, Tuple[Literal["GSP"], RuleVariation_331.cv_arg]], Union[RuleVariation_336.cv_arg, Tuple[Literal["HDG"], RuleVariation_336.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1114.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_375, 16), (Item_389, 16)]
    cv_items_dict = {"GSP": RuleVariation_331, "HDG": RuleVariation_336}

    @overload
    @classmethod
    def spec(cls, key : Literal["GSP"]) -> RuleVariation_331:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["HDG"]) -> RuleVariation_336:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["GSP"], Literal["HDG"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["GSP"]) -> RuleVariation_331:
        ...
    @overload
    def get_item(self, key : Literal["HDG"]) -> RuleVariation_336:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1114.cv_arg") -> 'Variation_1114':
        return cls._create(arg) # type: ignore

class RuleVariation_1072(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1114.cv_arg
    cv_variation: TypeAlias = Variation_1114

    @classmethod
    def create(cls, arg : "RuleVariation_1072.cv_arg") -> "RuleVariation_1072":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1114:
        return self.arg # type: ignore

class NonSpare_389(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1072.cv_arg
    cv_name = "200"
    cv_title = "Calculated Track Velocity in Polar Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1072

    @classmethod
    def create(cls, arg : "NonSpare_389.cv_arg") -> "NonSpare_389":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1072:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1114:
        return self.rule.variation

class UapItem_389(UapItem):
    cv_non_spare: TypeAlias = NonSpare_389

class Content_61(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Confirmed Track", 1: "Track in initialisation phase"}

class RuleContent_61(RuleContentContextFree):
    cv_arg: TypeAlias = Content_61.cv_arg
    cv_content: TypeAlias = Content_61

    @property
    def content(self) -> Content_61:
        return self._get_content() # type: ignore

class Variation_17(Element):
    cv_arg: TypeAlias = RuleContent_61.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_61

    @classmethod
    def create(cls, arg: "Variation_17.cv_arg") -> "Variation_17":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_61:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_61:
        return self.rule.content

class RuleVariation_17(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_17.cv_arg
    cv_variation: TypeAlias = Variation_17

    @classmethod
    def create(cls, arg : "RuleVariation_17.cv_arg") -> "RuleVariation_17":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_17:
        return self.arg # type: ignore

class Content_431(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Primary track", 1: "SSR/Combined track"}

class RuleContent_431(RuleContentContextFree):
    cv_arg: TypeAlias = Content_431.cv_arg
    cv_content: TypeAlias = Content_431

    @property
    def content(self) -> Content_431:
        return self._get_content() # type: ignore

class Variation_449(Element):
    cv_arg: TypeAlias = RuleContent_431.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_431

    @classmethod
    def create(cls, arg: "Variation_449.cv_arg") -> "Variation_449":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_431:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_431:
        return self.rule.content

class RuleVariation_438(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_449.cv_arg
    cv_variation: TypeAlias = Variation_449

    @classmethod
    def create(cls, arg : "RuleVariation_438.cv_arg") -> "RuleVariation_438":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_449:
        return self.arg # type: ignore

class Content_84(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Aircraft manoeuvring"}

class RuleContent_84(RuleContentContextFree):
    cv_arg: TypeAlias = Content_84.cv_arg
    cv_content: TypeAlias = Content_84

    @property
    def content(self) -> Content_84:
        return self._get_content() # type: ignore

class Variation_515(Element):
    cv_arg: TypeAlias = RuleContent_84.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_84

    @classmethod
    def create(cls, arg: "Variation_515.cv_arg") -> "Variation_515":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_84:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_84:
        return self.rule.content

class RuleVariation_504(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_515.cv_arg
    cv_variation: TypeAlias = Variation_515

    @classmethod
    def create(cls, arg : "RuleVariation_504.cv_arg") -> "RuleVariation_504":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_515:
        return self.arg # type: ignore

class Content_94(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Doubtful plot to track association"}

class RuleContent_94(RuleContentContextFree):
    cv_arg: TypeAlias = Content_94.cv_arg
    cv_content: TypeAlias = Content_94

    @property
    def content(self) -> Content_94:
        return self._get_content() # type: ignore

class Variation_621(Element):
    cv_arg: TypeAlias = RuleContent_94.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_94

    @classmethod
    def create(cls, arg: "Variation_621.cv_arg") -> "Variation_621":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_94:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_94:
        return self.rule.content

class RuleVariation_610(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_621.cv_arg
    cv_variation: TypeAlias = Variation_621

    @classmethod
    def create(cls, arg : "RuleVariation_610.cv_arg") -> "RuleVariation_610":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_621:
        return self.arg # type: ignore

class Content_433(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "RDP Chain 1", 1: "RDP Chain 2"}

class RuleContent_433(RuleContentContextFree):
    cv_arg: TypeAlias = Content_433.cv_arg
    cv_content: TypeAlias = Content_433

    @property
    def content(self) -> Content_433:
        return self._get_content() # type: ignore

class Variation_746(Element):
    cv_arg: TypeAlias = RuleContent_433.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_433

    @classmethod
    def create(cls, arg: "Variation_746.cv_arg") -> "Variation_746":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_433:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_433:
        return self.rule.content

class RuleVariation_735(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_746.cv_arg
    cv_variation: TypeAlias = Variation_746

    @classmethod
    def create(cls, arg : "RuleVariation_735.cv_arg") -> "RuleVariation_735":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_746:
        return self.arg # type: ignore

class Content_99(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Ghost track"}

class RuleContent_99(RuleContentContextFree):
    cv_arg: TypeAlias = Content_99.cv_arg
    cv_content: TypeAlias = Content_99

    @property
    def content(self) -> Content_99:
        return self._get_content() # type: ignore

class Variation_912(Element):
    cv_arg: TypeAlias = RuleContent_99.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_99

    @classmethod
    def create(cls, arg: "Variation_912.cv_arg") -> "Variation_912":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_99:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_99:
        return self.rule.content

class RuleVariation_882(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_912.cv_arg
    cv_variation: TypeAlias = Variation_912

    @classmethod
    def create(cls, arg : "RuleVariation_882.cv_arg") -> "RuleVariation_882":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_912:
        return self.arg # type: ignore

class Content_112(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Last report for a track"}

class RuleContent_112(RuleContentContextFree):
    cv_arg: TypeAlias = Content_112.cv_arg
    cv_content: TypeAlias = Content_112

    @property
    def content(self) -> Content_112:
        return self._get_content() # type: ignore

class Variation_31(Element):
    cv_arg: TypeAlias = RuleContent_112.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_112

    @classmethod
    def create(cls, arg: "Variation_31.cv_arg") -> "Variation_31":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_112:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_112:
        return self.rule.content

class RuleVariation_31(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_31.cv_arg
    cv_variation: TypeAlias = Variation_31

    @classmethod
    def create(cls, arg : "RuleVariation_31.cv_arg") -> "RuleVariation_31":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_31:
        return self.arg # type: ignore

class NonSpare_791(NonSpare):
    cv_arg: TypeAlias = RuleVariation_17.cv_arg
    cv_name = "CON"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_17

    @classmethod
    def create(cls, arg : "NonSpare_791.cv_arg") -> "NonSpare_791":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_17:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_17:
        return self.rule.variation

class Item_190(Item):
    cv_arg: TypeAlias = NonSpare_791.cv_arg
    cv_non_spare: TypeAlias = NonSpare_791

    @classmethod
    def create(cls, arg : "Item_190.cv_arg") -> "Item_190":
        return cls._create(arg) # type: ignore

class NonSpare_1544(NonSpare):
    cv_arg: TypeAlias = RuleVariation_438.cv_arg
    cv_name = "RAD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_438

    @classmethod
    def create(cls, arg : "NonSpare_1544.cv_arg") -> "NonSpare_1544":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_438:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_449:
        return self.rule.variation

class Item_774(Item):
    cv_arg: TypeAlias = NonSpare_1544.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1544

    @classmethod
    def create(cls, arg : "Item_774.cv_arg") -> "Item_774":
        return cls._create(arg) # type: ignore

class NonSpare_1229(NonSpare):
    cv_arg: TypeAlias = RuleVariation_504.cv_arg
    cv_name = "MAN"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_504

    @classmethod
    def create(cls, arg : "NonSpare_1229.cv_arg") -> "NonSpare_1229":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_504:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_515:
        return self.rule.variation

class Item_528(Item):
    cv_arg: TypeAlias = NonSpare_1229.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1229

    @classmethod
    def create(cls, arg : "Item_528.cv_arg") -> "Item_528":
        return cls._create(arg) # type: ignore

class NonSpare_894(NonSpare):
    cv_arg: TypeAlias = RuleVariation_610.cv_arg
    cv_name = "DOU"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_610

    @classmethod
    def create(cls, arg : "NonSpare_894.cv_arg") -> "NonSpare_894":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_610:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_621:
        return self.rule.variation

class Item_269(Item):
    cv_arg: TypeAlias = NonSpare_894.cv_arg
    cv_non_spare: TypeAlias = NonSpare_894

    @classmethod
    def create(cls, arg : "Item_269.cv_arg") -> "Item_269":
        return cls._create(arg) # type: ignore

class NonSpare_1560(NonSpare):
    cv_arg: TypeAlias = RuleVariation_735.cv_arg
    cv_name = "RDPC"
    cv_title = "Radar Data Processing Chain"
    cv_rule: TypeAlias = RuleVariation_735

    @classmethod
    def create(cls, arg : "NonSpare_1560.cv_arg") -> "NonSpare_1560":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_735:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_746:
        return self.rule.variation

class Item_788(Item):
    cv_arg: TypeAlias = NonSpare_1560.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1560

    @classmethod
    def create(cls, arg : "Item_788.cv_arg") -> "Item_788":
        return cls._create(arg) # type: ignore

class Item_23(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 5
    cv_bit_size = 1

class NonSpare_1036(NonSpare):
    cv_arg: TypeAlias = RuleVariation_882.cv_arg
    cv_name = "GHO"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_882

    @classmethod
    def create(cls, arg : "NonSpare_1036.cv_arg") -> "NonSpare_1036":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_882:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_912:
        return self.rule.variation

class Item_371(Item):
    cv_arg: TypeAlias = NonSpare_1036.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1036

    @classmethod
    def create(cls, arg : "Item_371.cv_arg") -> "Item_371":
        return cls._create(arg) # type: ignore

class NonSpare_1914(NonSpare):
    cv_arg: TypeAlias = RuleVariation_31.cv_arg
    cv_name = "TRE"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_31

    @classmethod
    def create(cls, arg : "NonSpare_1914.cv_arg") -> "NonSpare_1914":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_31:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_31:
        return self.rule.variation

class Item_1035(Item):
    cv_arg: TypeAlias = NonSpare_1914.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1914

    @classmethod
    def create(cls, arg : "Item_1035.cv_arg") -> "Item_1035":
        return cls._create(arg) # type: ignore

class Item_9(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 1
    cv_bit_size = 6

class Variation_1355(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_17.cv_arg, Tuple[Literal["CON"], RuleVariation_17.cv_arg]], Union[RuleVariation_438.cv_arg, Tuple[Literal["RAD"], RuleVariation_438.cv_arg]], Union[RuleVariation_504.cv_arg, Tuple[Literal["MAN"], RuleVariation_504.cv_arg]], Union[RuleVariation_610.cv_arg, Tuple[Literal["DOU"], RuleVariation_610.cv_arg]], Union[RuleVariation_735.cv_arg, Tuple[Literal["RDPC"], RuleVariation_735.cv_arg]], int, Union[RuleVariation_882.cv_arg, Tuple[Literal["GHO"], RuleVariation_882.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_31.cv_arg, Tuple[Literal["TRE"], RuleVariation_31.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1355.cv_arg_group_1"],
        Tuple["Variation_1355.cv_arg_group_1", "Variation_1355.cv_arg_group_2"],
    ]
    cv_items_list = [[(Item_190, 1), (Item_774, 1), (Item_528, 1), (Item_269, 1), (Item_788, 1), (Item_23, 1), (Item_371, 1), None], [(Item_1035, 1), (Item_9, 6), None]]

    @classmethod
    def create(cls, arg: "Variation_1355.cv_arg") -> 'Variation_1355':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["CON"]) -> RuleVariation_17:
        ...
    @overload
    def get_item(self, key : Literal["RAD"]) -> RuleVariation_438:
        ...
    @overload
    def get_item(self, key : Literal["MAN"]) -> RuleVariation_504:
        ...
    @overload
    def get_item(self, key : Literal["DOU"]) -> RuleVariation_610:
        ...
    @overload
    def get_item(self, key : Literal["RDPC"]) -> RuleVariation_735:
        ...
    @overload
    def get_item(self, key : Literal["GHO"]) -> RuleVariation_882:
        ...
    @overload
    def get_item(self, key : Literal["TRE"]) -> Optional[RuleVariation_31]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1276(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1355.cv_arg
    cv_variation: TypeAlias = Variation_1355

    @classmethod
    def create(cls, arg : "RuleVariation_1276.cv_arg") -> "RuleVariation_1276":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1355:
        return self.arg # type: ignore

class NonSpare_378(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1276.cv_arg
    cv_name = "170"
    cv_title = "Track Status"
    cv_rule: TypeAlias = RuleVariation_1276

    @classmethod
    def create(cls, arg : "NonSpare_378.cv_arg") -> "NonSpare_378":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1276:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1355:
        return self.rule.variation

class UapItem_378(UapItem):
    cv_non_spare: TypeAlias = NonSpare_378

class NonSpare_417(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1375.cv_arg
    cv_name = "210"
    cv_title = "Track Quality"
    cv_rule: TypeAlias = RuleVariation_1375

    @classmethod
    def create(cls, arg : "NonSpare_417.cv_arg") -> "NonSpare_417":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1375:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1454:
        return self.rule.variation

class UapItem_417(UapItem):
    cv_non_spare: TypeAlias = NonSpare_417

class Record_19(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_36.cv_arg,
        "020": NonSpare_87.cv_arg,
        "161": NonSpare_366.cv_arg,
        "040": NonSpare_138.cv_arg,
        "042": NonSpare_159.cv_arg,
        "200": NonSpare_389.cv_arg,
        "070": NonSpare_213.cv_arg,
        "090": NonSpare_253.cv_arg,
        "141": NonSpare_337.cv_arg,
        "130": NonSpare_312.cv_arg,
        "131": NonSpare_316.cv_arg,
        "120": NonSpare_300.cv_arg,
        "170": NonSpare_378.cv_arg,
        "210": NonSpare_417.cv_arg,
        "050": NonSpare_174.cv_arg,
        "080": NonSpare_233.cv_arg,
        "100": NonSpare_274.cv_arg,
        "060": NonSpare_189.cv_arg,
        "030": NonSpare_117.cv_arg,
        "SP": NonSpare_1732.cv_arg,
        "150": NonSpare_346.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_36.cv_arg],
        Tuple[Literal["020"], NonSpare_87.cv_arg],
        Tuple[Literal["161"], NonSpare_366.cv_arg],
        Tuple[Literal["040"], NonSpare_138.cv_arg],
        Tuple[Literal["042"], NonSpare_159.cv_arg],
        Tuple[Literal["200"], NonSpare_389.cv_arg],
        Tuple[Literal["070"], NonSpare_213.cv_arg],
        Tuple[Literal["090"], NonSpare_253.cv_arg],
        Tuple[Literal["141"], NonSpare_337.cv_arg],
        Tuple[Literal["130"], NonSpare_312.cv_arg],
        Tuple[Literal["131"], NonSpare_316.cv_arg],
        Tuple[Literal["120"], NonSpare_300.cv_arg],
        Tuple[Literal["170"], NonSpare_378.cv_arg],
        Tuple[Literal["210"], NonSpare_417.cv_arg],
        Tuple[Literal["050"], NonSpare_174.cv_arg],
        Tuple[Literal["080"], NonSpare_233.cv_arg],
        Tuple[Literal["100"], NonSpare_274.cv_arg],
        Tuple[Literal["060"], NonSpare_189.cv_arg],
        Tuple[Literal["030"], NonSpare_117.cv_arg],
        Tuple[Literal["SP"], NonSpare_1732.cv_arg],
        Tuple[Literal["150"], NonSpare_346.cv_arg],
    ]
    cv_fspec_max_bytes = 4
    cv_items_list = [UapItem_36, UapItem_87, UapItem_366, UapItem_138, UapItem_159, UapItem_389, UapItem_213, UapItem_253, UapItem_337, UapItem_312, UapItem_316, UapItem_300, UapItem_378, UapItem_417, UapItem_174, UapItem_233, UapItem_274, UapItem_189, UapItem_117, UapItem_548, UapItem_550, UapItem_346]
    cv_items_dict = {"010": NonSpare_36, "020": NonSpare_87, "161": NonSpare_366, "040": NonSpare_138, "042": NonSpare_159, "200": NonSpare_389, "070": NonSpare_213, "090": NonSpare_253, "141": NonSpare_337, "130": NonSpare_312, "131": NonSpare_316, "120": NonSpare_300, "170": NonSpare_378, "210": NonSpare_417, "050": NonSpare_174, "080": NonSpare_233, "100": NonSpare_274, "060": NonSpare_189, "030": NonSpare_117, "SP": NonSpare_1732, "150": NonSpare_346}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_36:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_87:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["161"]) -> NonSpare_366:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> NonSpare_138:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["042"]) -> NonSpare_159:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["200"]) -> NonSpare_389:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> NonSpare_213:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> NonSpare_253:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["141"]) -> NonSpare_337:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["130"]) -> NonSpare_312:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["131"]) -> NonSpare_316:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> NonSpare_300:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["170"]) -> NonSpare_378:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["210"]) -> NonSpare_417:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> NonSpare_174:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> NonSpare_233:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_274:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_189:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> NonSpare_117:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1732:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["150"]) -> NonSpare_346:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["020"], Literal["161"], Literal["040"], Literal["042"], Literal["200"], Literal["070"], Literal["090"], Literal["141"], Literal["130"], Literal["131"], Literal["120"], Literal["170"], Literal["210"], Literal["050"], Literal["080"], Literal["100"], Literal["060"], Literal["030"], Literal["SP"], Literal["150"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_36]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_87]:
        ...
    @overload
    def get_item(self, key : Literal["161"]) -> Optional[NonSpare_366]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_138]:
        ...
    @overload
    def get_item(self, key : Literal["042"]) -> Optional[NonSpare_159]:
        ...
    @overload
    def get_item(self, key : Literal["200"]) -> Optional[NonSpare_389]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_213]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_253]:
        ...
    @overload
    def get_item(self, key : Literal["141"]) -> Optional[NonSpare_337]:
        ...
    @overload
    def get_item(self, key : Literal["130"]) -> Optional[NonSpare_312]:
        ...
    @overload
    def get_item(self, key : Literal["131"]) -> Optional[NonSpare_316]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_300]:
        ...
    @overload
    def get_item(self, key : Literal["170"]) -> Optional[NonSpare_378]:
        ...
    @overload
    def get_item(self, key : Literal["210"]) -> Optional[NonSpare_417]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_174]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_233]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_274]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_189]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_117]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1732]:
        ...
    @overload
    def get_item(self, key : Literal["150"]) -> Optional[NonSpare_346]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_36.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_87.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["161"], val : NonSpare_366.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_138.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["042"], val : NonSpare_159.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["200"], val : NonSpare_389.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_213.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_253.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["141"], val : NonSpare_337.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["130"], val : NonSpare_312.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["131"], val : NonSpare_316.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_300.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["170"], val : NonSpare_378.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["210"], val : NonSpare_417.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_174.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_233.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_274.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_189.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_117.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1732.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["150"], val : NonSpare_346.cv_arg) -> 'Record_19':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["161"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["042"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["200"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["141"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["130"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["131"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["170"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["210"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["150"]) -> 'Record_19':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_36]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_87]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["161"]) -> List[NonSpare_366]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["040"]) -> List[NonSpare_138]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["042"]) -> List[NonSpare_159]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["200"]) -> List[NonSpare_389]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["070"]) -> List[NonSpare_213]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_253]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["141"]) -> List[NonSpare_337]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["130"]) -> List[NonSpare_312]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["131"]) -> List[NonSpare_316]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["120"]) -> List[NonSpare_300]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["170"]) -> List[NonSpare_378]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["210"]) -> List[NonSpare_417]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_174]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["080"]) -> List[NonSpare_233]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_274]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["060"]) -> List[NonSpare_189]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["030"]) -> List[NonSpare_117]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1732]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["150"]) -> List[NonSpare_346]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_19.cv_arg", rfs : Optional[List["Record_19.cv_union"]] = None) -> 'Record_19':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_19", Bits]]:
        return cls._parse(bs) # type: ignore

class Uap_48(UapMultiple):
    cv_arg: TypeAlias = Union[Record_18, Record_19]
    cv_uaps = {"plot": Record_18, "track": Record_19}
    cv_selector = (["020", "TYP"], {0: "plot", 1: "track"})

    @overload
    @classmethod
    def spec(cls, key : Literal["plot"]) -> Record_18:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["track"]) -> Record_19:
        ...
    @classmethod
    def spec(cls, key : Any) -> Any:
        return cls._spec(key)

    @overload
    @classmethod
    def parse(cls, uap : Literal["plot"], bs : Bits) -> Union[ValueError, List[Record_18]]:
        ...
    @overload
    @classmethod
    def parse(cls, uap : Literal["track"], bs : Bits) -> Union[ValueError, List[Record_19]]:
        ...
    @classmethod
    def parse(cls, uap : str, bs : Bits) -> Any:
        return cls._parse(uap, bs)

    @classmethod
    def parse_any_uap(cls, bs : Bits) -> "List[List[Uap_48.cv_arg]]":
        return cls._parse_any_uap(bs)

class Asterix_0(AstCat):
    cv_category = 1
    cv_edition = (1, 2)
    cv_uap: TypeAlias = Uap_48

    @classmethod
    def create(cls, records : List[Uap_48.cv_arg]) -> "Asterix_0":
        return cls._create(records) # type: ignore

class NonSpare_37(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1140.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1140

    @classmethod
    def create(cls, arg : "NonSpare_37.cv_arg") -> "NonSpare_37":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1140:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1192:
        return self.rule.variation

class UapItem_37(UapItem):
    cv_non_spare: TypeAlias = NonSpare_37

class Record_25(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_37.cv_arg,
        "020": NonSpare_87.cv_arg,
        "040": NonSpare_138.cv_arg,
        "070": NonSpare_213.cv_arg,
        "090": NonSpare_253.cv_arg,
        "130": NonSpare_312.cv_arg,
        "141": NonSpare_337.cv_arg,
        "050": NonSpare_174.cv_arg,
        "120": NonSpare_300.cv_arg,
        "131": NonSpare_316.cv_arg,
        "080": NonSpare_233.cv_arg,
        "100": NonSpare_274.cv_arg,
        "060": NonSpare_189.cv_arg,
        "030": NonSpare_117.cv_arg,
        "150": NonSpare_346.cv_arg,
        "SP": NonSpare_1732.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_37.cv_arg],
        Tuple[Literal["020"], NonSpare_87.cv_arg],
        Tuple[Literal["040"], NonSpare_138.cv_arg],
        Tuple[Literal["070"], NonSpare_213.cv_arg],
        Tuple[Literal["090"], NonSpare_253.cv_arg],
        Tuple[Literal["130"], NonSpare_312.cv_arg],
        Tuple[Literal["141"], NonSpare_337.cv_arg],
        Tuple[Literal["050"], NonSpare_174.cv_arg],
        Tuple[Literal["120"], NonSpare_300.cv_arg],
        Tuple[Literal["131"], NonSpare_316.cv_arg],
        Tuple[Literal["080"], NonSpare_233.cv_arg],
        Tuple[Literal["100"], NonSpare_274.cv_arg],
        Tuple[Literal["060"], NonSpare_189.cv_arg],
        Tuple[Literal["030"], NonSpare_117.cv_arg],
        Tuple[Literal["150"], NonSpare_346.cv_arg],
        Tuple[Literal["SP"], NonSpare_1732.cv_arg],
    ]
    cv_fspec_max_bytes = 3
    cv_items_list = [UapItem_37, UapItem_87, UapItem_138, UapItem_213, UapItem_253, UapItem_312, UapItem_337, UapItem_174, UapItem_300, UapItem_316, UapItem_233, UapItem_274, UapItem_189, UapItem_117, UapItem_346, UapItem_549, UapItem_549, UapItem_549, UapItem_549, UapItem_548, UapItem_550]
    cv_items_dict = {"010": NonSpare_37, "020": NonSpare_87, "040": NonSpare_138, "070": NonSpare_213, "090": NonSpare_253, "130": NonSpare_312, "141": NonSpare_337, "050": NonSpare_174, "120": NonSpare_300, "131": NonSpare_316, "080": NonSpare_233, "100": NonSpare_274, "060": NonSpare_189, "030": NonSpare_117, "150": NonSpare_346, "SP": NonSpare_1732}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_37:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_87:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> NonSpare_138:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> NonSpare_213:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> NonSpare_253:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["130"]) -> NonSpare_312:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["141"]) -> NonSpare_337:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> NonSpare_174:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> NonSpare_300:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["131"]) -> NonSpare_316:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> NonSpare_233:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_274:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_189:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> NonSpare_117:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["150"]) -> NonSpare_346:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1732:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["020"], Literal["040"], Literal["070"], Literal["090"], Literal["130"], Literal["141"], Literal["050"], Literal["120"], Literal["131"], Literal["080"], Literal["100"], Literal["060"], Literal["030"], Literal["150"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_37]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_87]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_138]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_213]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_253]:
        ...
    @overload
    def get_item(self, key : Literal["130"]) -> Optional[NonSpare_312]:
        ...
    @overload
    def get_item(self, key : Literal["141"]) -> Optional[NonSpare_337]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_174]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_300]:
        ...
    @overload
    def get_item(self, key : Literal["131"]) -> Optional[NonSpare_316]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_233]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_274]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_189]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_117]:
        ...
    @overload
    def get_item(self, key : Literal["150"]) -> Optional[NonSpare_346]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1732]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_37.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_87.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_138.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_213.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_253.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["130"], val : NonSpare_312.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["141"], val : NonSpare_337.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_174.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_300.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["131"], val : NonSpare_316.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_233.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_274.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_189.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_117.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["150"], val : NonSpare_346.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1732.cv_arg) -> 'Record_25':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["130"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["141"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["131"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["150"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_25':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_37]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_87]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["040"]) -> List[NonSpare_138]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["070"]) -> List[NonSpare_213]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_253]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["130"]) -> List[NonSpare_312]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["141"]) -> List[NonSpare_337]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_174]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["120"]) -> List[NonSpare_300]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["131"]) -> List[NonSpare_316]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["080"]) -> List[NonSpare_233]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_274]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["060"]) -> List[NonSpare_189]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["030"]) -> List[NonSpare_117]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["150"]) -> List[NonSpare_346]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1732]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_25.cv_arg", rfs : Optional[List["Record_25.cv_union"]] = None) -> 'Record_25':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_25", Bits]]:
        return cls._parse(bs) # type: ignore

class Record_26(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_37.cv_arg,
        "020": NonSpare_87.cv_arg,
        "161": NonSpare_366.cv_arg,
        "040": NonSpare_138.cv_arg,
        "042": NonSpare_159.cv_arg,
        "200": NonSpare_389.cv_arg,
        "070": NonSpare_213.cv_arg,
        "090": NonSpare_253.cv_arg,
        "141": NonSpare_337.cv_arg,
        "130": NonSpare_312.cv_arg,
        "131": NonSpare_316.cv_arg,
        "120": NonSpare_300.cv_arg,
        "170": NonSpare_378.cv_arg,
        "210": NonSpare_417.cv_arg,
        "050": NonSpare_174.cv_arg,
        "080": NonSpare_233.cv_arg,
        "100": NonSpare_274.cv_arg,
        "060": NonSpare_189.cv_arg,
        "030": NonSpare_117.cv_arg,
        "SP": NonSpare_1732.cv_arg,
        "150": NonSpare_346.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_37.cv_arg],
        Tuple[Literal["020"], NonSpare_87.cv_arg],
        Tuple[Literal["161"], NonSpare_366.cv_arg],
        Tuple[Literal["040"], NonSpare_138.cv_arg],
        Tuple[Literal["042"], NonSpare_159.cv_arg],
        Tuple[Literal["200"], NonSpare_389.cv_arg],
        Tuple[Literal["070"], NonSpare_213.cv_arg],
        Tuple[Literal["090"], NonSpare_253.cv_arg],
        Tuple[Literal["141"], NonSpare_337.cv_arg],
        Tuple[Literal["130"], NonSpare_312.cv_arg],
        Tuple[Literal["131"], NonSpare_316.cv_arg],
        Tuple[Literal["120"], NonSpare_300.cv_arg],
        Tuple[Literal["170"], NonSpare_378.cv_arg],
        Tuple[Literal["210"], NonSpare_417.cv_arg],
        Tuple[Literal["050"], NonSpare_174.cv_arg],
        Tuple[Literal["080"], NonSpare_233.cv_arg],
        Tuple[Literal["100"], NonSpare_274.cv_arg],
        Tuple[Literal["060"], NonSpare_189.cv_arg],
        Tuple[Literal["030"], NonSpare_117.cv_arg],
        Tuple[Literal["SP"], NonSpare_1732.cv_arg],
        Tuple[Literal["150"], NonSpare_346.cv_arg],
    ]
    cv_fspec_max_bytes = 4
    cv_items_list = [UapItem_37, UapItem_87, UapItem_366, UapItem_138, UapItem_159, UapItem_389, UapItem_213, UapItem_253, UapItem_337, UapItem_312, UapItem_316, UapItem_300, UapItem_378, UapItem_417, UapItem_174, UapItem_233, UapItem_274, UapItem_189, UapItem_117, UapItem_548, UapItem_550, UapItem_346]
    cv_items_dict = {"010": NonSpare_37, "020": NonSpare_87, "161": NonSpare_366, "040": NonSpare_138, "042": NonSpare_159, "200": NonSpare_389, "070": NonSpare_213, "090": NonSpare_253, "141": NonSpare_337, "130": NonSpare_312, "131": NonSpare_316, "120": NonSpare_300, "170": NonSpare_378, "210": NonSpare_417, "050": NonSpare_174, "080": NonSpare_233, "100": NonSpare_274, "060": NonSpare_189, "030": NonSpare_117, "SP": NonSpare_1732, "150": NonSpare_346}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_37:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_87:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["161"]) -> NonSpare_366:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> NonSpare_138:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["042"]) -> NonSpare_159:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["200"]) -> NonSpare_389:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> NonSpare_213:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> NonSpare_253:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["141"]) -> NonSpare_337:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["130"]) -> NonSpare_312:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["131"]) -> NonSpare_316:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> NonSpare_300:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["170"]) -> NonSpare_378:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["210"]) -> NonSpare_417:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> NonSpare_174:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> NonSpare_233:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_274:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_189:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> NonSpare_117:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1732:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["150"]) -> NonSpare_346:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["020"], Literal["161"], Literal["040"], Literal["042"], Literal["200"], Literal["070"], Literal["090"], Literal["141"], Literal["130"], Literal["131"], Literal["120"], Literal["170"], Literal["210"], Literal["050"], Literal["080"], Literal["100"], Literal["060"], Literal["030"], Literal["SP"], Literal["150"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_37]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_87]:
        ...
    @overload
    def get_item(self, key : Literal["161"]) -> Optional[NonSpare_366]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_138]:
        ...
    @overload
    def get_item(self, key : Literal["042"]) -> Optional[NonSpare_159]:
        ...
    @overload
    def get_item(self, key : Literal["200"]) -> Optional[NonSpare_389]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_213]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_253]:
        ...
    @overload
    def get_item(self, key : Literal["141"]) -> Optional[NonSpare_337]:
        ...
    @overload
    def get_item(self, key : Literal["130"]) -> Optional[NonSpare_312]:
        ...
    @overload
    def get_item(self, key : Literal["131"]) -> Optional[NonSpare_316]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_300]:
        ...
    @overload
    def get_item(self, key : Literal["170"]) -> Optional[NonSpare_378]:
        ...
    @overload
    def get_item(self, key : Literal["210"]) -> Optional[NonSpare_417]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_174]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_233]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_274]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_189]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_117]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1732]:
        ...
    @overload
    def get_item(self, key : Literal["150"]) -> Optional[NonSpare_346]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_37.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_87.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["161"], val : NonSpare_366.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_138.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["042"], val : NonSpare_159.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["200"], val : NonSpare_389.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_213.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_253.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["141"], val : NonSpare_337.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["130"], val : NonSpare_312.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["131"], val : NonSpare_316.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_300.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["170"], val : NonSpare_378.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["210"], val : NonSpare_417.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_174.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_233.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_274.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_189.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_117.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1732.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["150"], val : NonSpare_346.cv_arg) -> 'Record_26':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["161"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["042"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["200"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["141"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["130"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["131"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["170"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["210"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["150"]) -> 'Record_26':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_37]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_87]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["161"]) -> List[NonSpare_366]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["040"]) -> List[NonSpare_138]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["042"]) -> List[NonSpare_159]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["200"]) -> List[NonSpare_389]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["070"]) -> List[NonSpare_213]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_253]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["141"]) -> List[NonSpare_337]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["130"]) -> List[NonSpare_312]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["131"]) -> List[NonSpare_316]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["120"]) -> List[NonSpare_300]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["170"]) -> List[NonSpare_378]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["210"]) -> List[NonSpare_417]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_174]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["080"]) -> List[NonSpare_233]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_274]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["060"]) -> List[NonSpare_189]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["030"]) -> List[NonSpare_117]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1732]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["150"]) -> List[NonSpare_346]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_26.cv_arg", rfs : Optional[List["Record_26.cv_union"]] = None) -> 'Record_26':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_26", Bits]]:
        return cls._parse(bs) # type: ignore

class Uap_49(UapMultiple):
    cv_arg: TypeAlias = Union[Record_25, Record_26]
    cv_uaps = {"plot": Record_25, "track": Record_26}
    cv_selector = (["020", "TYP"], {0: "plot", 1: "track"})

    @overload
    @classmethod
    def spec(cls, key : Literal["plot"]) -> Record_25:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["track"]) -> Record_26:
        ...
    @classmethod
    def spec(cls, key : Any) -> Any:
        return cls._spec(key)

    @overload
    @classmethod
    def parse(cls, uap : Literal["plot"], bs : Bits) -> Union[ValueError, List[Record_25]]:
        ...
    @overload
    @classmethod
    def parse(cls, uap : Literal["track"], bs : Bits) -> Union[ValueError, List[Record_26]]:
        ...
    @classmethod
    def parse(cls, uap : str, bs : Bits) -> Any:
        return cls._parse(uap, bs)

    @classmethod
    def parse_any_uap(cls, bs : Bits) -> "List[List[Uap_49.cv_arg]]":
        return cls._parse_any_uap(bs)

class Asterix_1(AstCat):
    cv_category = 1
    cv_edition = (1, 3)
    cv_uap: TypeAlias = Uap_49

    @classmethod
    def create(cls, records : List[Uap_49.cv_arg]) -> "Asterix_1":
        return cls._create(records) # type: ignore

class Asterix_2(AstCat):
    cv_category = 1
    cv_edition = (1, 4)
    cv_uap: TypeAlias = Uap_49

    @classmethod
    def create(cls, records : List[Uap_49.cv_arg]) -> "Asterix_2":
        return cls._create(records) # type: ignore

class NonSpare_47(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1140.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1140

    @classmethod
    def create(cls, arg : "NonSpare_47.cv_arg") -> "NonSpare_47":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1140:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1192:
        return self.rule.variation

class UapItem_47(UapItem):
    cv_non_spare: TypeAlias = NonSpare_47

class Content_590(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "North marker message", 2: "Sector crossing message", 3: "South marker message", 8: "Activation of blind zone filtering", 9: "Stop of blind zone filtering"}

class RuleContent_590(RuleContentContextFree):
    cv_arg: TypeAlias = Content_590.cv_arg
    cv_content: TypeAlias = Content_590

    @property
    def content(self) -> Content_590:
        return self._get_content() # type: ignore

class Variation_190(Element):
    cv_arg: TypeAlias = RuleContent_590.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_590

    @classmethod
    def create(cls, arg: "Variation_190.cv_arg") -> "Variation_190":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_590:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_590:
        return self.rule.content

class RuleVariation_183(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_190.cv_arg
    cv_variation: TypeAlias = Variation_190

    @classmethod
    def create(cls, arg : "RuleVariation_183.cv_arg") -> "RuleVariation_183":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_190:
        return self.arg # type: ignore

class NonSpare_7(NonSpare):
    cv_arg: TypeAlias = RuleVariation_183.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_183

    @classmethod
    def create(cls, arg : "NonSpare_7.cv_arg") -> "NonSpare_7":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_183:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_190:
        return self.rule.variation

class UapItem_7(UapItem):
    cv_non_spare: TypeAlias = NonSpare_7

class Content_790(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 1.40625
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_789(RuleContentContextFree):
    cv_arg: TypeAlias = Content_790.cv_arg
    cv_content: TypeAlias = Content_790

    @property
    def content(self) -> Content_790:
        return self._get_content() # type: ignore

class Variation_243(Element):
    cv_arg: TypeAlias = RuleContent_789.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_789

    @classmethod
    def create(cls, arg: "Variation_243.cv_arg") -> "Variation_243":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_789:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_790:
        return self.rule.content

class RuleVariation_236(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_243.cv_arg
    cv_variation: TypeAlias = Variation_243

    @classmethod
    def create(cls, arg : "RuleVariation_236.cv_arg") -> "RuleVariation_236":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_243:
        return self.arg # type: ignore

class NonSpare_81(NonSpare):
    cv_arg: TypeAlias = RuleVariation_236.cv_arg
    cv_name = "020"
    cv_title = "Sector Number"
    cv_rule: TypeAlias = RuleVariation_236

    @classmethod
    def create(cls, arg : "NonSpare_81.cv_arg") -> "NonSpare_81":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_236:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_243:
        return self.rule.variation

class UapItem_81(UapItem):
    cv_non_spare: TypeAlias = NonSpare_81

class Variation_370(Element):
    cv_arg: TypeAlias = RuleContent_769.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_rule = RuleContent_769

    @classmethod
    def create(cls, arg: "Variation_370.cv_arg") -> "Variation_370":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_769:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_770:
        return self.rule.content

class RuleVariation_363(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_370.cv_arg
    cv_variation: TypeAlias = Variation_370

    @classmethod
    def create(cls, arg : "RuleVariation_363.cv_arg") -> "RuleVariation_363":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_370:
        return self.arg # type: ignore

class NonSpare_109(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "030"
    cv_title = "Time of Day"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_109.cv_arg") -> "NonSpare_109":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class UapItem_109(UapItem):
    cv_non_spare: TypeAlias = NonSpare_109

class NonSpare_152(NonSpare):
    cv_arg: TypeAlias = RuleVariation_327.cv_arg
    cv_name = "041"
    cv_title = "Antenna Rotation Speed"
    cv_rule: TypeAlias = RuleVariation_327

    @classmethod
    def create(cls, arg : "NonSpare_152.cv_arg") -> "NonSpare_152":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_327:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_334:
        return self.rule.variation

class UapItem_152(UapItem):
    cv_non_spare: TypeAlias = NonSpare_152

class NonSpare_180(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1375.cv_arg
    cv_name = "050"
    cv_title = "Station Configuration Status"
    cv_rule: TypeAlias = RuleVariation_1375

    @classmethod
    def create(cls, arg : "NonSpare_180.cv_arg") -> "NonSpare_180":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1375:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1454:
        return self.rule.variation

class UapItem_180(UapItem):
    cv_non_spare: TypeAlias = NonSpare_180

class NonSpare_198(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1375.cv_arg
    cv_name = "060"
    cv_title = "Station Processing Mode"
    cv_rule: TypeAlias = RuleVariation_1375

    @classmethod
    def create(cls, arg : "NonSpare_198.cv_arg") -> "NonSpare_198":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1375:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1454:
        return self.rule.variation

class UapItem_198(UapItem):
    cv_non_spare: TypeAlias = NonSpare_198

class Content_69(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Counter for antenna 1", 1: "Counter for antenna 2"}

class RuleContent_69(RuleContentContextFree):
    cv_arg: TypeAlias = Content_69.cv_arg
    cv_content: TypeAlias = Content_69

    @property
    def content(self) -> Content_69:
        return self._get_content() # type: ignore

class Variation_21(Element):
    cv_arg: TypeAlias = RuleContent_69.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_69

    @classmethod
    def create(cls, arg: "Variation_21.cv_arg") -> "Variation_21":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_69:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_69:
        return self.rule.content

class RuleVariation_21(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_21.cv_arg
    cv_variation: TypeAlias = Variation_21

    @classmethod
    def create(cls, arg : "RuleVariation_21.cv_arg") -> "RuleVariation_21":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_21:
        return self.arg # type: ignore

class NonSpare_548(NonSpare):
    cv_arg: TypeAlias = RuleVariation_21.cv_arg
    cv_name = "A"
    cv_title = "Aerial Identification"
    cv_rule: TypeAlias = RuleVariation_21

    @classmethod
    def create(cls, arg : "NonSpare_548.cv_arg") -> "NonSpare_548":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_21:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_21:
        return self.rule.variation

class Item_33(Item):
    cv_arg: TypeAlias = NonSpare_548.cv_arg
    cv_non_spare: TypeAlias = NonSpare_548

    @classmethod
    def create(cls, arg : "Item_33.cv_arg") -> "Item_33":
        return cls._create(arg) # type: ignore

class Content_595(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Sole primary plots", 2: "Sole SSR plots", 3: "Combined plots"}

class RuleContent_595(RuleContentContextFree):
    cv_arg: TypeAlias = Content_595.cv_arg
    cv_content: TypeAlias = Content_595

    @property
    def content(self) -> Content_595:
        return self._get_content() # type: ignore

class Variation_491(Element):
    cv_arg: TypeAlias = RuleContent_595.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 5
    cv_rule = RuleContent_595

    @classmethod
    def create(cls, arg: "Variation_491.cv_arg") -> "Variation_491":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_595:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_595:
        return self.rule.content

class RuleVariation_480(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_491.cv_arg
    cv_variation: TypeAlias = Variation_491

    @classmethod
    def create(cls, arg : "RuleVariation_480.cv_arg") -> "RuleVariation_480":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_491:
        return self.arg # type: ignore

class NonSpare_1113(NonSpare):
    cv_arg: TypeAlias = RuleVariation_480.cv_arg
    cv_name = "IDENT"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_480

    @classmethod
    def create(cls, arg : "NonSpare_1113.cv_arg") -> "NonSpare_1113":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_480:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_491:
        return self.rule.variation

class Item_430(Item):
    cv_arg: TypeAlias = NonSpare_1113.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1113

    @classmethod
    def create(cls, arg : "Item_430.cv_arg") -> "Item_430":
        return cls._create(arg) # type: ignore

class Content_613(ContentInteger):
    cv_arg: TypeAlias = int
    cv_signedness: TypeAlias = Unsigned

class RuleContent_613(RuleContentContextFree):
    cv_arg: TypeAlias = Content_613.cv_arg
    cv_content: TypeAlias = Content_613

    @property
    def content(self) -> Content_613:
        return self._get_content() # type: ignore

class Variation_967(Element):
    cv_arg: TypeAlias = RuleContent_613.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 10
    cv_rule = RuleContent_613

    @classmethod
    def create(cls, arg: "Variation_967.cv_arg") -> "Variation_967":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_613:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_613:
        return self.rule.content

class RuleVariation_937(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_967.cv_arg
    cv_variation: TypeAlias = Variation_967

    @classmethod
    def create(cls, arg : "RuleVariation_937.cv_arg") -> "RuleVariation_937":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_967:
        return self.arg # type: ignore

class NonSpare_801(NonSpare):
    cv_arg: TypeAlias = RuleVariation_937.cv_arg
    cv_name = "COUNTER"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_937

    @classmethod
    def create(cls, arg : "NonSpare_801.cv_arg") -> "NonSpare_801":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_937:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_967:
        return self.rule.variation

class Item_200(Item):
    cv_arg: TypeAlias = NonSpare_801.cv_arg
    cv_non_spare: TypeAlias = NonSpare_801

    @classmethod
    def create(cls, arg : "Item_200.cv_arg") -> "Item_200":
        return cls._create(arg) # type: ignore

class Variation_1044(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_21.cv_arg, Tuple[Literal["A"], RuleVariation_21.cv_arg]], Union[RuleVariation_480.cv_arg, Tuple[Literal["IDENT"], RuleVariation_480.cv_arg]], Union[RuleVariation_937.cv_arg, Tuple[Literal["COUNTER"], RuleVariation_937.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1044.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_33, 1), (Item_430, 5), (Item_200, 10)]
    cv_items_dict = {"A": RuleVariation_21, "IDENT": RuleVariation_480, "COUNTER": RuleVariation_937}

    @overload
    @classmethod
    def spec(cls, key : Literal["A"]) -> RuleVariation_21:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["IDENT"]) -> RuleVariation_480:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["COUNTER"]) -> RuleVariation_937:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["A"], Literal["IDENT"], Literal["COUNTER"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["A"]) -> RuleVariation_21:
        ...
    @overload
    def get_item(self, key : Literal["IDENT"]) -> RuleVariation_480:
        ...
    @overload
    def get_item(self, key : Literal["COUNTER"]) -> RuleVariation_937:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1044.cv_arg") -> 'Variation_1044':
        return cls._create(arg) # type: ignore

class Variation_1409(Repetitive):
    cv_arg: TypeAlias = List[Variation_1044.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1044

    @classmethod
    def create(cls, arg: "Variation_1409.cv_arg") -> 'Variation_1409':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1044]:
        return self._get_list() # type: ignore

class RuleVariation_1330(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1409.cv_arg
    cv_variation: TypeAlias = Variation_1409

    @classmethod
    def create(cls, arg : "RuleVariation_1330.cv_arg") -> "RuleVariation_1330":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1409:
        return self.arg # type: ignore

class NonSpare_216(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1330.cv_arg
    cv_name = "070"
    cv_title = "Plot Count Values"
    cv_rule: TypeAlias = RuleVariation_1330

    @classmethod
    def create(cls, arg : "NonSpare_216.cv_arg") -> "NonSpare_216":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1330:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1409:
        return self.rule.variation

class UapItem_216(UapItem):
    cv_non_spare: TypeAlias = NonSpare_216

class Content_767(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 7.8125e-3
    cv_unit = "NM"

    def as_quantity(self, cv_unit : Optional[Literal["NM"]] = None) -> float:
        return self._as_quantity()

class RuleContent_766(RuleContentContextFree):
    cv_arg: TypeAlias = Content_767.cv_arg
    cv_content: TypeAlias = Content_767

    @property
    def content(self) -> Content_767:
        return self._get_content() # type: ignore

class Variation_331(Element):
    cv_arg: TypeAlias = RuleContent_766.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_766

    @classmethod
    def create(cls, arg: "Variation_331.cv_arg") -> "Variation_331":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_766:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_767:
        return self.rule.content

class RuleVariation_324(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_331.cv_arg
    cv_variation: TypeAlias = Variation_331

    @classmethod
    def create(cls, arg : "RuleVariation_324.cv_arg") -> "RuleVariation_324":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_331:
        return self.arg # type: ignore

class NonSpare_1614(NonSpare):
    cv_arg: TypeAlias = RuleVariation_324.cv_arg
    cv_name = "RS"
    cv_title = "Rho Start"
    cv_rule: TypeAlias = RuleVariation_324

    @classmethod
    def create(cls, arg : "NonSpare_1614.cv_arg") -> "NonSpare_1614":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_324:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_331:
        return self.rule.variation

class Item_832(Item):
    cv_arg: TypeAlias = NonSpare_1614.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1614

    @classmethod
    def create(cls, arg : "Item_832.cv_arg") -> "Item_832":
        return cls._create(arg) # type: ignore

class NonSpare_1569(NonSpare):
    cv_arg: TypeAlias = RuleVariation_324.cv_arg
    cv_name = "RE"
    cv_title = "Rho End"
    cv_rule: TypeAlias = RuleVariation_324

    @classmethod
    def create(cls, arg : "NonSpare_1569.cv_arg") -> "NonSpare_1569":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_324:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_331:
        return self.rule.variation

class Item_794(Item):
    cv_arg: TypeAlias = NonSpare_1569.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1569

    @classmethod
    def create(cls, arg : "Item_794.cv_arg") -> "Item_794":
        return cls._create(arg) # type: ignore

class NonSpare_1926(NonSpare):
    cv_arg: TypeAlias = RuleVariation_336.cv_arg
    cv_name = "TS"
    cv_title = "Theta Start"
    cv_rule: TypeAlias = RuleVariation_336

    @classmethod
    def create(cls, arg : "NonSpare_1926.cv_arg") -> "NonSpare_1926":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_336:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_343:
        return self.rule.variation

class Item_1043(Item):
    cv_arg: TypeAlias = NonSpare_1926.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1926

    @classmethod
    def create(cls, arg : "Item_1043.cv_arg") -> "Item_1043":
        return cls._create(arg) # type: ignore

class NonSpare_1852(NonSpare):
    cv_arg: TypeAlias = RuleVariation_336.cv_arg
    cv_name = "TE"
    cv_title = "Theta End"
    cv_rule: TypeAlias = RuleVariation_336

    @classmethod
    def create(cls, arg : "NonSpare_1852.cv_arg") -> "NonSpare_1852":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_336:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_343:
        return self.rule.variation

class Item_991(Item):
    cv_arg: TypeAlias = NonSpare_1852.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1852

    @classmethod
    def create(cls, arg : "Item_991.cv_arg") -> "Item_991":
        return cls._create(arg) # type: ignore

class Variation_1185(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_324.cv_arg, Tuple[Literal["RS"], RuleVariation_324.cv_arg]], Union[RuleVariation_324.cv_arg, Tuple[Literal["RE"], RuleVariation_324.cv_arg]], Union[RuleVariation_336.cv_arg, Tuple[Literal["TS"], RuleVariation_336.cv_arg]], Union[RuleVariation_336.cv_arg, Tuple[Literal["TE"], RuleVariation_336.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1185.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 64
    cv_items_list = [(Item_832, 16), (Item_794, 16), (Item_1043, 16), (Item_991, 16)]
    cv_items_dict = {"RS": RuleVariation_324, "RE": RuleVariation_324, "TS": RuleVariation_336, "TE": RuleVariation_336}

    @overload
    @classmethod
    def spec(cls, key : Literal["RS"]) -> RuleVariation_324:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["RE"]) -> RuleVariation_324:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TS"]) -> RuleVariation_336:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TE"]) -> RuleVariation_336:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["RS"], Literal["RE"], Literal["TS"], Literal["TE"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["RS"]) -> RuleVariation_324:
        ...
    @overload
    def get_item(self, key : Literal["RE"]) -> RuleVariation_324:
        ...
    @overload
    def get_item(self, key : Literal["TS"]) -> RuleVariation_336:
        ...
    @overload
    def get_item(self, key : Literal["TE"]) -> RuleVariation_336:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1185.cv_arg") -> 'Variation_1185':
        return cls._create(arg) # type: ignore

class RuleVariation_1135(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1185.cv_arg
    cv_variation: TypeAlias = Variation_1185

    @classmethod
    def create(cls, arg : "RuleVariation_1135.cv_arg") -> "RuleVariation_1135":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1185:
        return self.arg # type: ignore

class NonSpare_269(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1135.cv_arg
    cv_name = "100"
    cv_title = "Dynamic Window Type 1"
    cv_rule: TypeAlias = RuleVariation_1135

    @classmethod
    def create(cls, arg : "NonSpare_269.cv_arg") -> "NonSpare_269":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1135:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1185:
        return self.rule.variation

class UapItem_269(UapItem):
    cv_non_spare: TypeAlias = NonSpare_269

class Content_677(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 7.8125e-3
    cv_unit = "NM"

    def as_quantity(self, cv_unit : Optional[Literal["NM"]] = None) -> float:
        return self._as_quantity()

class RuleContent_677(RuleContentContextFree):
    cv_arg: TypeAlias = Content_677.cv_arg
    cv_content: TypeAlias = Content_677

    @property
    def content(self) -> Content_677:
        return self._get_content() # type: ignore

class Variation_215(Element):
    cv_arg: TypeAlias = RuleContent_677.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_677

    @classmethod
    def create(cls, arg: "Variation_215.cv_arg") -> "Variation_215":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_677:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_677:
        return self.rule.content

class RuleVariation_208(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_215.cv_arg
    cv_variation: TypeAlias = Variation_215

    @classmethod
    def create(cls, arg : "RuleVariation_208.cv_arg") -> "RuleVariation_208":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_215:
        return self.arg # type: ignore

class NonSpare_1565(NonSpare):
    cv_arg: TypeAlias = RuleVariation_208.cv_arg
    cv_name = "RE"
    cv_title = "Range Error"
    cv_rule: TypeAlias = RuleVariation_208

    @classmethod
    def create(cls, arg : "NonSpare_1565.cv_arg") -> "NonSpare_1565":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_208:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_215:
        return self.rule.variation

class Item_791(Item):
    cv_arg: TypeAlias = NonSpare_1565.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1565

    @classmethod
    def create(cls, arg : "Item_791.cv_arg") -> "Item_791":
        return cls._create(arg) # type: ignore

class Content_708(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 2.197265625e-2
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_708(RuleContentContextFree):
    cv_arg: TypeAlias = Content_708.cv_arg
    cv_content: TypeAlias = Content_708

    @property
    def content(self) -> Content_708:
        return self._get_content() # type: ignore

class Variation_220(Element):
    cv_arg: TypeAlias = RuleContent_708.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_708

    @classmethod
    def create(cls, arg: "Variation_220.cv_arg") -> "Variation_220":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_708:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_708:
        return self.rule.content

class RuleVariation_213(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_220.cv_arg
    cv_variation: TypeAlias = Variation_220

    @classmethod
    def create(cls, arg : "RuleVariation_213.cv_arg") -> "RuleVariation_213":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_220:
        return self.arg # type: ignore

class NonSpare_579(NonSpare):
    cv_arg: TypeAlias = RuleVariation_213.cv_arg
    cv_name = "AE"
    cv_title = "Azimuth Error"
    cv_rule: TypeAlias = RuleVariation_213

    @classmethod
    def create(cls, arg : "NonSpare_579.cv_arg") -> "NonSpare_579":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_213:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_220:
        return self.rule.variation

class Item_49(Item):
    cv_arg: TypeAlias = NonSpare_579.cv_arg
    cv_non_spare: TypeAlias = NonSpare_579

    @classmethod
    def create(cls, arg : "Item_49.cv_arg") -> "Item_49":
        return cls._create(arg) # type: ignore

class Variation_1171(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_208.cv_arg, Tuple[Literal["RE"], RuleVariation_208.cv_arg]], Union[RuleVariation_213.cv_arg, Tuple[Literal["AE"], RuleVariation_213.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1171.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_791, 8), (Item_49, 8)]
    cv_items_dict = {"RE": RuleVariation_208, "AE": RuleVariation_213}

    @overload
    @classmethod
    def spec(cls, key : Literal["RE"]) -> RuleVariation_208:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AE"]) -> RuleVariation_213:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["RE"], Literal["AE"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["RE"]) -> RuleVariation_208:
        ...
    @overload
    def get_item(self, key : Literal["AE"]) -> RuleVariation_213:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1171.cv_arg") -> 'Variation_1171':
        return cls._create(arg) # type: ignore

class RuleVariation_1122(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1171.cv_arg
    cv_variation: TypeAlias = Variation_1171

    @classmethod
    def create(cls, arg : "RuleVariation_1122.cv_arg") -> "RuleVariation_1122":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1171:
        return self.arg # type: ignore

class NonSpare_244(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1122.cv_arg
    cv_name = "090"
    cv_title = "Collimation Error"
    cv_rule: TypeAlias = RuleVariation_1122

    @classmethod
    def create(cls, arg : "NonSpare_244.cv_arg") -> "NonSpare_244":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1122:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1171:
        return self.rule.variation

class UapItem_244(UapItem):
    cv_non_spare: TypeAlias = NonSpare_244

class NonSpare_242(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1375.cv_arg
    cv_name = "080"
    cv_title = "Warning/Error Conditions"
    cv_rule: TypeAlias = RuleVariation_1375

    @classmethod
    def create(cls, arg : "NonSpare_242.cv_arg") -> "NonSpare_242":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1375:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1454:
        return self.rule.variation

class UapItem_242(UapItem):
    cv_non_spare: TypeAlias = NonSpare_242

class Record_46(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_47.cv_arg,
        "000": NonSpare_7.cv_arg,
        "020": NonSpare_81.cv_arg,
        "030": NonSpare_109.cv_arg,
        "041": NonSpare_152.cv_arg,
        "050": NonSpare_180.cv_arg,
        "060": NonSpare_198.cv_arg,
        "070": NonSpare_216.cv_arg,
        "100": NonSpare_269.cv_arg,
        "090": NonSpare_244.cv_arg,
        "080": NonSpare_242.cv_arg,
        "SP": NonSpare_1732.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_47.cv_arg],
        Tuple[Literal["000"], NonSpare_7.cv_arg],
        Tuple[Literal["020"], NonSpare_81.cv_arg],
        Tuple[Literal["030"], NonSpare_109.cv_arg],
        Tuple[Literal["041"], NonSpare_152.cv_arg],
        Tuple[Literal["050"], NonSpare_180.cv_arg],
        Tuple[Literal["060"], NonSpare_198.cv_arg],
        Tuple[Literal["070"], NonSpare_216.cv_arg],
        Tuple[Literal["100"], NonSpare_269.cv_arg],
        Tuple[Literal["090"], NonSpare_244.cv_arg],
        Tuple[Literal["080"], NonSpare_242.cv_arg],
        Tuple[Literal["SP"], NonSpare_1732.cv_arg],
    ]
    cv_fspec_max_bytes = 2
    cv_items_list = [UapItem_47, UapItem_7, UapItem_81, UapItem_109, UapItem_152, UapItem_180, UapItem_198, UapItem_216, UapItem_269, UapItem_244, UapItem_242, UapItem_549, UapItem_548, UapItem_550]
    cv_items_dict = {"010": NonSpare_47, "000": NonSpare_7, "020": NonSpare_81, "030": NonSpare_109, "041": NonSpare_152, "050": NonSpare_180, "060": NonSpare_198, "070": NonSpare_216, "100": NonSpare_269, "090": NonSpare_244, "080": NonSpare_242, "SP": NonSpare_1732}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_47:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> NonSpare_7:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_81:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> NonSpare_109:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["041"]) -> NonSpare_152:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> NonSpare_180:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_198:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> NonSpare_216:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_269:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> NonSpare_244:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> NonSpare_242:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1732:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["020"], Literal["030"], Literal["041"], Literal["050"], Literal["060"], Literal["070"], Literal["100"], Literal["090"], Literal["080"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_47]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_7]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_81]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_109]:
        ...
    @overload
    def get_item(self, key : Literal["041"]) -> Optional[NonSpare_152]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_180]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_198]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_216]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_269]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_244]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_242]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1732]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_47.cv_arg) -> 'Record_46':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_7.cv_arg) -> 'Record_46':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_81.cv_arg) -> 'Record_46':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_109.cv_arg) -> 'Record_46':
        ...
    @overload
    def set_item(self, key : Literal["041"], val : NonSpare_152.cv_arg) -> 'Record_46':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_180.cv_arg) -> 'Record_46':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_198.cv_arg) -> 'Record_46':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_216.cv_arg) -> 'Record_46':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_269.cv_arg) -> 'Record_46':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_244.cv_arg) -> 'Record_46':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_242.cv_arg) -> 'Record_46':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1732.cv_arg) -> 'Record_46':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_46':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_46':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_46':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_46':
        ...
    @overload
    def del_item(self, key : Literal["041"]) -> 'Record_46':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_46':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_46':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_46':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_46':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_46':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_46':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_46':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_47]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["000"]) -> List[NonSpare_7]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_81]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["030"]) -> List[NonSpare_109]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["041"]) -> List[NonSpare_152]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_180]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["060"]) -> List[NonSpare_198]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["070"]) -> List[NonSpare_216]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_269]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_244]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["080"]) -> List[NonSpare_242]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1732]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_46.cv_arg", rfs : Optional[List["Record_46.cv_union"]] = None) -> 'Record_46':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_46", Bits]]:
        return cls._parse(bs) # type: ignore

class Uap_42(UapSingle):
    cv_arg: TypeAlias = Record_46
    cv_record: TypeAlias = Record_46

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_46]]:
        return cls._parse(bs)

class Asterix_3(AstCat):
    cv_category = 2
    cv_edition = (1, 0)
    cv_uap: TypeAlias = Uap_42
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_42.cv_arg]) -> "Asterix_3":
        return cls._create(records) # type: ignore

class NonSpare_38(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1140.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1140

    @classmethod
    def create(cls, arg : "NonSpare_38.cv_arg") -> "NonSpare_38":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1140:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1192:
        return self.rule.variation

class UapItem_38(UapItem):
    cv_non_spare: TypeAlias = NonSpare_38

class Record_27(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_38.cv_arg,
        "000": NonSpare_7.cv_arg,
        "020": NonSpare_81.cv_arg,
        "030": NonSpare_109.cv_arg,
        "041": NonSpare_152.cv_arg,
        "050": NonSpare_180.cv_arg,
        "060": NonSpare_198.cv_arg,
        "070": NonSpare_216.cv_arg,
        "100": NonSpare_269.cv_arg,
        "090": NonSpare_244.cv_arg,
        "080": NonSpare_242.cv_arg,
        "SP": NonSpare_1732.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_38.cv_arg],
        Tuple[Literal["000"], NonSpare_7.cv_arg],
        Tuple[Literal["020"], NonSpare_81.cv_arg],
        Tuple[Literal["030"], NonSpare_109.cv_arg],
        Tuple[Literal["041"], NonSpare_152.cv_arg],
        Tuple[Literal["050"], NonSpare_180.cv_arg],
        Tuple[Literal["060"], NonSpare_198.cv_arg],
        Tuple[Literal["070"], NonSpare_216.cv_arg],
        Tuple[Literal["100"], NonSpare_269.cv_arg],
        Tuple[Literal["090"], NonSpare_244.cv_arg],
        Tuple[Literal["080"], NonSpare_242.cv_arg],
        Tuple[Literal["SP"], NonSpare_1732.cv_arg],
    ]
    cv_fspec_max_bytes = 2
    cv_items_list = [UapItem_38, UapItem_7, UapItem_81, UapItem_109, UapItem_152, UapItem_180, UapItem_198, UapItem_216, UapItem_269, UapItem_244, UapItem_242, UapItem_549, UapItem_548, UapItem_550]
    cv_items_dict = {"010": NonSpare_38, "000": NonSpare_7, "020": NonSpare_81, "030": NonSpare_109, "041": NonSpare_152, "050": NonSpare_180, "060": NonSpare_198, "070": NonSpare_216, "100": NonSpare_269, "090": NonSpare_244, "080": NonSpare_242, "SP": NonSpare_1732}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_38:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> NonSpare_7:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_81:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> NonSpare_109:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["041"]) -> NonSpare_152:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> NonSpare_180:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_198:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> NonSpare_216:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_269:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> NonSpare_244:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> NonSpare_242:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1732:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["020"], Literal["030"], Literal["041"], Literal["050"], Literal["060"], Literal["070"], Literal["100"], Literal["090"], Literal["080"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_38]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_7]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_81]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_109]:
        ...
    @overload
    def get_item(self, key : Literal["041"]) -> Optional[NonSpare_152]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_180]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_198]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_216]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_269]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_244]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_242]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1732]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_38.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_7.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_81.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_109.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["041"], val : NonSpare_152.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_180.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_198.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_216.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_269.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_244.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_242.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1732.cv_arg) -> 'Record_27':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["041"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_27':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_38]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["000"]) -> List[NonSpare_7]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_81]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["030"]) -> List[NonSpare_109]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["041"]) -> List[NonSpare_152]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_180]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["060"]) -> List[NonSpare_198]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["070"]) -> List[NonSpare_216]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_269]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_244]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["080"]) -> List[NonSpare_242]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1732]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_27.cv_arg", rfs : Optional[List["Record_27.cv_union"]] = None) -> 'Record_27':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_27", Bits]]:
        return cls._parse(bs) # type: ignore

class Uap_23(UapSingle):
    cv_arg: TypeAlias = Record_27
    cv_record: TypeAlias = Record_27

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_27]]:
        return cls._parse(bs)

class Asterix_4(AstCat):
    cv_category = 2
    cv_edition = (1, 1)
    cv_uap: TypeAlias = Uap_23
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_23.cv_arg]) -> "Asterix_4":
        return cls._create(records) # type: ignore

class Asterix_5(AstCat):
    cv_category = 2
    cv_edition = (1, 2)
    cv_uap: TypeAlias = Uap_23
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_23.cv_arg]) -> "Asterix_5":
        return cls._create(records) # type: ignore

class NonSpare_34(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1140.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1140

    @classmethod
    def create(cls, arg : "NonSpare_34.cv_arg") -> "NonSpare_34":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1140:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1192:
        return self.rule.variation

class UapItem_34(UapItem):
    cv_non_spare: TypeAlias = NonSpare_34

class Content_576(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Alive Message (AM)", 2: "Route Adherence Monitor Longitudinal Deviation (RAMLD)", 3: "Route Adherence Monitor Heading Deviation (RAMHD)", 4: "Minimum Safe Altitude Warning (MSAW)", 5: "Area Proximity Warning (APW)", 6: "Clearance Level Adherence Monitor (CLAM)", 7: "Short Term Conflict Alert (STCA)", 8: "Approach Path Monitor (APM)", 9: "RIMCAS Arrival / Landing Monitor (ALM)", 10: "RIMCAS Arrival / Departure Wrong Runway Alert (WRA)", 11: "RIMCAS Arrival / Departure Opposite Traffic Alert (OTA)", 12: "RIMCAS Departure Monitor (RDM)", 13: "RIMCAS Runway / Taxiway Crossing Monitor (RCM)", 14: "RIMCAS Taxiway Separation Monitor (TSM)", 15: "RIMCAS Unauthorized Taxiway Movement Monitor(UTMM)", 16: "RIMCAS Stop Bar Overrun Alert (SBOA)", 17: "End Of Conflict (EOC)", 18: "ACAS Resolution Advisory (ACASRA)", 19: "Near Term Conflict Alert (NTCA)", 20: "Downlinked Barometric Pressure Setting Monitor (DBPSM)", 21: "Speed Adherence Monitor (SAM)", 22: "Outside Controlled Airspace Tool (OCAT)", 23: "Vertical Conflict Detection (VCD)", 24: "Vertical Rate Adherence Monitor (VRAM)", 25: "Cleared Heading Adherence Monitor (CHAM)", 26: "Downlinked Selected Altitude Monitor (DSAM)", 27: "Holding Adherence Monitor (HAM)", 28: "Vertical Path Monitor (VPM)", 29: "RIMCAS Taxiway Traffic Alert (TTA)", 30: "RIMCAS Arrival/Departure Close Runway Alert (CRA)", 31: "RIMCAS Arrival/Departure Aircraft Separation Monitor (ASM)", 32: "RIMCAS ILS Area Violation Monitor (IAVM)", 33: "Final Target Distance Indicator (FTD)", 34: "Initial Target Distance Indicator (ITD)", 35: "Wake Vortex Indicator Infringement Alert (IIA)", 36: "Sequence Warning (SQW)", 37: "Catch Up Warning (CUW)", 38: "Conflicting ATC Clearances (CATC)", 39: "No ATC Clearance (NOCLR)", 40: "Aircraft Not Moving despite ATC Clearance (NOMOV)", 41: "Aircraft leaving/entering the aerodrome area without proper handover (NOH)", 42: "Wrong Runway or Taxiway Type (WRTY)", 43: "Stand Occupied (STOCC)", 44: "Ongoing Alert (ONGOING)", 97: "Lost Track Warning (LTW)", 98: "Holding Volume Infringement (HVI)", 99: "Airspace Infringement Warning (AIW)"}

class RuleContent_576(RuleContentContextFree):
    cv_arg: TypeAlias = Content_576.cv_arg
    cv_content: TypeAlias = Content_576

    @property
    def content(self) -> Content_576:
        return self._get_content() # type: ignore

class Variation_180(Element):
    cv_arg: TypeAlias = RuleContent_576.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_576

    @classmethod
    def create(cls, arg: "Variation_180.cv_arg") -> "Variation_180":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_576:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_576:
        return self.rule.content

class RuleVariation_173(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_180.cv_arg
    cv_variation: TypeAlias = Variation_180

    @classmethod
    def create(cls, arg : "RuleVariation_173.cv_arg") -> "RuleVariation_173":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_180:
        return self.arg # type: ignore

class NonSpare_3(NonSpare):
    cv_arg: TypeAlias = RuleVariation_173.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_173

    @classmethod
    def create(cls, arg : "NonSpare_3.cv_arg") -> "NonSpare_3":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_173:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_180:
        return self.rule.variation

class UapItem_3(UapItem):
    cv_non_spare: TypeAlias = NonSpare_3

class Variation_1429(Repetitive):
    cv_arg: TypeAlias = List[Variation_1192.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1192

    @classmethod
    def create(cls, arg: "Variation_1429.cv_arg") -> 'Variation_1429':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1192]:
        return self._get_list() # type: ignore

class RuleVariation_1350(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1429.cv_arg
    cv_variation: TypeAlias = Variation_1429

    @classmethod
    def create(cls, arg : "RuleVariation_1350.cv_arg") -> "RuleVariation_1350":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1429:
        return self.arg # type: ignore

class NonSpare_58(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1350.cv_arg
    cv_name = "015"
    cv_title = "SDPS Identifier"
    cv_rule: TypeAlias = RuleVariation_1350

    @classmethod
    def create(cls, arg : "NonSpare_58.cv_arg") -> "NonSpare_58":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1350:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1429:
        return self.rule.variation

class UapItem_58(UapItem):
    cv_non_spare: TypeAlias = NonSpare_58

class NonSpare_94(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "020"
    cv_title = "Time of Message"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_94.cv_arg") -> "NonSpare_94":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class UapItem_94(UapItem):
    cv_non_spare: TypeAlias = NonSpare_94

class NonSpare_136(NonSpare):
    cv_arg: TypeAlias = RuleVariation_246.cv_arg
    cv_name = "040"
    cv_title = "Alert Identifier"
    cv_rule: TypeAlias = RuleVariation_246

    @classmethod
    def create(cls, arg : "NonSpare_136.cv_arg") -> "NonSpare_136":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_246:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_253:
        return self.rule.variation

class UapItem_136(UapItem):
    cv_non_spare: TypeAlias = NonSpare_136

class Variation_774(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_774.cv_arg") -> "Variation_774":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_763(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_774.cv_arg
    cv_variation: TypeAlias = Variation_774

    @classmethod
    def create(cls, arg : "RuleVariation_763.cv_arg") -> "RuleVariation_763":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_774:
        return self.arg # type: ignore

class NonSpare_1783(NonSpare):
    cv_arg: TypeAlias = RuleVariation_763.cv_arg
    cv_name = "STAT"
    cv_title = "Status of the Alert"
    cv_rule: TypeAlias = RuleVariation_763

    @classmethod
    def create(cls, arg : "NonSpare_1783.cv_arg") -> "NonSpare_1783":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_763:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_774:
        return self.rule.variation

class Item_944(Item):
    cv_arg: TypeAlias = NonSpare_1783.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1783

    @classmethod
    def create(cls, arg : "Item_944.cv_arg") -> "Item_944":
        return cls._create(arg) # type: ignore

class Item_29(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 7
    cv_bit_size = 1

class Variation_1033(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_763.cv_arg, Tuple[Literal["STAT"], RuleVariation_763.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1033.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_3, 4), (Item_944, 3), (Item_29, 1)]
    cv_items_dict = {"STAT": RuleVariation_763}

    @classmethod
    def spec(cls, key : Literal["STAT"]) -> RuleVariation_763:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["STAT"]) -> RuleVariation_763:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1033.cv_arg") -> 'Variation_1033':
        return cls._create(arg) # type: ignore

class RuleVariation_1001(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1033.cv_arg
    cv_variation: TypeAlias = Variation_1033

    @classmethod
    def create(cls, arg : "RuleVariation_1001.cv_arg") -> "RuleVariation_1001":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1033:
        return self.arg # type: ignore

class NonSpare_163(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1001.cv_arg
    cv_name = "045"
    cv_title = "Alert Status"
    cv_rule: TypeAlias = RuleVariation_1001

    @classmethod
    def create(cls, arg : "NonSpare_163.cv_arg") -> "NonSpare_163":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1001:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1033:
        return self.rule.variation

class UapItem_163(UapItem):
    cv_non_spare: TypeAlias = NonSpare_163

class Content_114(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "MRVA function"}

class RuleContent_114(RuleContentContextFree):
    cv_arg: TypeAlias = Content_114.cv_arg
    cv_content: TypeAlias = Content_114

    @property
    def content(self) -> Content_114:
        return self._get_content() # type: ignore

class Variation_32(Element):
    cv_arg: TypeAlias = RuleContent_114.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_114

    @classmethod
    def create(cls, arg: "Variation_32.cv_arg") -> "Variation_32":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_114:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_114:
        return self.rule.content

class RuleVariation_32(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_32.cv_arg
    cv_variation: TypeAlias = Variation_32

    @classmethod
    def create(cls, arg : "RuleVariation_32.cv_arg") -> "RuleVariation_32":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_32:
        return self.arg # type: ignore

class Content_142(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "RAMLD function"}

class RuleContent_142(RuleContentContextFree):
    cv_arg: TypeAlias = Content_142.cv_arg
    cv_content: TypeAlias = Content_142

    @property
    def content(self) -> Content_142:
        return self._get_content() # type: ignore

class Variation_416(Element):
    cv_arg: TypeAlias = RuleContent_142.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_142

    @classmethod
    def create(cls, arg: "Variation_416.cv_arg") -> "Variation_416":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_142:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_142:
        return self.rule.content

class RuleVariation_405(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_416.cv_arg
    cv_variation: TypeAlias = Variation_416

    @classmethod
    def create(cls, arg : "RuleVariation_405.cv_arg") -> "RuleVariation_405":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_416:
        return self.arg # type: ignore

class Content_141(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "RAMHD function"}

class RuleContent_141(RuleContentContextFree):
    cv_arg: TypeAlias = Content_141.cv_arg
    cv_content: TypeAlias = Content_141

    @property
    def content(self) -> Content_141:
        return self._get_content() # type: ignore

class Variation_524(Element):
    cv_arg: TypeAlias = RuleContent_141.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_141

    @classmethod
    def create(cls, arg: "Variation_524.cv_arg") -> "Variation_524":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_141:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_141:
        return self.rule.content

class RuleVariation_513(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_524.cv_arg
    cv_variation: TypeAlias = Variation_524

    @classmethod
    def create(cls, arg : "RuleVariation_513.cv_arg") -> "RuleVariation_513":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_524:
        return self.arg # type: ignore

class Content_115(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "MSAW function"}

class RuleContent_115(RuleContentContextFree):
    cv_arg: TypeAlias = Content_115.cv_arg
    cv_content: TypeAlias = Content_115

    @property
    def content(self) -> Content_115:
        return self._get_content() # type: ignore

class Variation_626(Element):
    cv_arg: TypeAlias = RuleContent_115.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_115

    @classmethod
    def create(cls, arg: "Variation_626.cv_arg") -> "Variation_626":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_115:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_115:
        return self.rule.content

class RuleVariation_615(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_626.cv_arg
    cv_variation: TypeAlias = Variation_626

    @classmethod
    def create(cls, arg : "RuleVariation_615.cv_arg") -> "RuleVariation_615":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_626:
        return self.arg # type: ignore

class Content_82(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "APW function"}

class RuleContent_82(RuleContentContextFree):
    cv_arg: TypeAlias = Content_82.cv_arg
    cv_content: TypeAlias = Content_82

    @property
    def content(self) -> Content_82:
        return self._get_content() # type: ignore

class Variation_705(Element):
    cv_arg: TypeAlias = RuleContent_82.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_82

    @classmethod
    def create(cls, arg: "Variation_705.cv_arg") -> "Variation_705":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_82:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_82:
        return self.rule.content

class RuleVariation_694(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_705.cv_arg
    cv_variation: TypeAlias = Variation_705

    @classmethod
    def create(cls, arg : "RuleVariation_694.cv_arg") -> "RuleVariation_694":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_705:
        return self.arg # type: ignore

class Content_87(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "CLAM function"}

class RuleContent_87(RuleContentContextFree):
    cv_arg: TypeAlias = Content_87.cv_arg
    cv_content: TypeAlias = Content_87

    @property
    def content(self) -> Content_87:
        return self._get_content() # type: ignore

class Variation_830(Element):
    cv_arg: TypeAlias = RuleContent_87.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_87

    @classmethod
    def create(cls, arg: "Variation_830.cv_arg") -> "Variation_830":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_87:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_87:
        return self.rule.content

class RuleVariation_800(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_830.cv_arg
    cv_variation: TypeAlias = Variation_830

    @classmethod
    def create(cls, arg : "RuleVariation_800.cv_arg") -> "RuleVariation_800":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_830:
        return self.arg # type: ignore

class Content_150(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "STCA function"}

class RuleContent_150(RuleContentContextFree):
    cv_arg: TypeAlias = Content_150.cv_arg
    cv_content: TypeAlias = Content_150

    @property
    def content(self) -> Content_150:
        return self._get_content() # type: ignore

class Variation_919(Element):
    cv_arg: TypeAlias = RuleContent_150.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_150

    @classmethod
    def create(cls, arg: "Variation_919.cv_arg") -> "Variation_919":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_150:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_150:
        return self.rule.content

class RuleVariation_889(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_919.cv_arg
    cv_variation: TypeAlias = Variation_919

    @classmethod
    def create(cls, arg : "RuleVariation_889.cv_arg") -> "RuleVariation_889":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_919:
        return self.arg # type: ignore

class Content_81(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "APM function"}

class RuleContent_81(RuleContentContextFree):
    cv_arg: TypeAlias = Content_81.cv_arg
    cv_content: TypeAlias = Content_81

    @property
    def content(self) -> Content_81:
        return self._get_content() # type: ignore

class Variation_24(Element):
    cv_arg: TypeAlias = RuleContent_81.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_81

    @classmethod
    def create(cls, arg: "Variation_24.cv_arg") -> "Variation_24":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_81:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_81:
        return self.rule.content

class RuleVariation_24(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_24.cv_arg
    cv_variation: TypeAlias = Variation_24

    @classmethod
    def create(cls, arg : "RuleVariation_24.cv_arg") -> "RuleVariation_24":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_24:
        return self.arg # type: ignore

class Content_143(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "RIMCA function"}

class RuleContent_143(RuleContentContextFree):
    cv_arg: TypeAlias = Content_143.cv_arg
    cv_content: TypeAlias = Content_143

    @property
    def content(self) -> Content_143:
        return self._get_content() # type: ignore

class Variation_417(Element):
    cv_arg: TypeAlias = RuleContent_143.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_143

    @classmethod
    def create(cls, arg: "Variation_417.cv_arg") -> "Variation_417":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_143:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_143:
        return self.rule.content

class RuleVariation_406(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_417.cv_arg
    cv_variation: TypeAlias = Variation_417

    @classmethod
    def create(cls, arg : "RuleVariation_406.cv_arg") -> "RuleVariation_406":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_417:
        return self.arg # type: ignore

class Content_79(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "ACAS RA function"}

class RuleContent_79(RuleContentContextFree):
    cv_arg: TypeAlias = Content_79.cv_arg
    cv_content: TypeAlias = Content_79

    @property
    def content(self) -> Content_79:
        return self._get_content() # type: ignore

class Variation_514(Element):
    cv_arg: TypeAlias = RuleContent_79.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_79

    @classmethod
    def create(cls, arg: "Variation_514.cv_arg") -> "Variation_514":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_79:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_79:
        return self.rule.content

class RuleVariation_503(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_514.cv_arg
    cv_variation: TypeAlias = Variation_514

    @classmethod
    def create(cls, arg : "RuleVariation_503.cv_arg") -> "RuleVariation_503":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_514:
        return self.arg # type: ignore

class Content_132(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "NTCA function"}

class RuleContent_132(RuleContentContextFree):
    cv_arg: TypeAlias = Content_132.cv_arg
    cv_content: TypeAlias = Content_132

    @property
    def content(self) -> Content_132:
        return self._get_content() # type: ignore

class Variation_631(Element):
    cv_arg: TypeAlias = RuleContent_132.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_132

    @classmethod
    def create(cls, arg: "Variation_631.cv_arg") -> "Variation_631":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_132:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_132:
        return self.rule.content

class RuleVariation_620(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_631.cv_arg
    cv_variation: TypeAlias = Variation_631

    @classmethod
    def create(cls, arg : "RuleVariation_620.cv_arg") -> "RuleVariation_620":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_631:
        return self.arg # type: ignore

class Content_153(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "System degraded"}

class RuleContent_153(RuleContentContextFree):
    cv_arg: TypeAlias = Content_153.cv_arg
    cv_content: TypeAlias = Content_153

    @property
    def content(self) -> Content_153:
        return self._get_content() # type: ignore

class Variation_711(Element):
    cv_arg: TypeAlias = RuleContent_153.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_153

    @classmethod
    def create(cls, arg: "Variation_711.cv_arg") -> "Variation_711":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_153:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_153:
        return self.rule.content

class RuleVariation_700(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_711.cv_arg
    cv_variation: TypeAlias = Variation_711

    @classmethod
    def create(cls, arg : "RuleVariation_700.cv_arg") -> "RuleVariation_700":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_711:
        return self.arg # type: ignore

class Content_136(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Overflow error"}

class RuleContent_136(RuleContentContextFree):
    cv_arg: TypeAlias = Content_136.cv_arg
    cv_content: TypeAlias = Content_136

    @property
    def content(self) -> Content_136:
        return self._get_content() # type: ignore

class Variation_834(Element):
    cv_arg: TypeAlias = RuleContent_136.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_136

    @classmethod
    def create(cls, arg: "Variation_834.cv_arg") -> "Variation_834":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_136:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_136:
        return self.rule.content

class RuleVariation_804(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_834.cv_arg
    cv_variation: TypeAlias = Variation_834

    @classmethod
    def create(cls, arg : "RuleVariation_804.cv_arg") -> "RuleVariation_804":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_834:
        return self.arg # type: ignore

class Content_138(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Overload error"}

class RuleContent_138(RuleContentContextFree):
    cv_arg: TypeAlias = Content_138.cv_arg
    cv_content: TypeAlias = Content_138

    @property
    def content(self) -> Content_138:
        return self._get_content() # type: ignore

class Variation_916(Element):
    cv_arg: TypeAlias = RuleContent_138.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_138

    @classmethod
    def create(cls, arg: "Variation_916.cv_arg") -> "Variation_916":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_138:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_138:
        return self.rule.content

class RuleVariation_886(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_916.cv_arg
    cv_variation: TypeAlias = Variation_916

    @classmethod
    def create(cls, arg : "RuleVariation_886.cv_arg") -> "RuleVariation_886":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_916:
        return self.arg # type: ignore

class Content_80(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "AIW function"}

class RuleContent_80(RuleContentContextFree):
    cv_arg: TypeAlias = Content_80.cv_arg
    cv_content: TypeAlias = Content_80

    @property
    def content(self) -> Content_80:
        return self._get_content() # type: ignore

class Variation_23(Element):
    cv_arg: TypeAlias = RuleContent_80.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_80

    @classmethod
    def create(cls, arg: "Variation_23.cv_arg") -> "Variation_23":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_80:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_80:
        return self.rule.content

class RuleVariation_23(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_23.cv_arg
    cv_variation: TypeAlias = Variation_23

    @classmethod
    def create(cls, arg : "RuleVariation_23.cv_arg") -> "RuleVariation_23":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_23:
        return self.arg # type: ignore

class Content_139(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "PAIW function"}

class RuleContent_139(RuleContentContextFree):
    cv_arg: TypeAlias = Content_139.cv_arg
    cv_content: TypeAlias = Content_139

    @property
    def content(self) -> Content_139:
        return self._get_content() # type: ignore

class Variation_415(Element):
    cv_arg: TypeAlias = RuleContent_139.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_139

    @classmethod
    def create(cls, arg: "Variation_415.cv_arg") -> "Variation_415":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_139:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_139:
        return self.rule.content

class RuleVariation_404(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_415.cv_arg
    cv_variation: TypeAlias = Variation_415

    @classmethod
    def create(cls, arg : "RuleVariation_404.cv_arg") -> "RuleVariation_404":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_415:
        return self.arg # type: ignore

class Content_134(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "OCAT function"}

class RuleContent_134(RuleContentContextFree):
    cv_arg: TypeAlias = Content_134.cv_arg
    cv_content: TypeAlias = Content_134

    @property
    def content(self) -> Content_134:
        return self._get_content() # type: ignore

class Variation_522(Element):
    cv_arg: TypeAlias = RuleContent_134.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_134

    @classmethod
    def create(cls, arg: "Variation_522.cv_arg") -> "Variation_522":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_134:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_134:
        return self.rule.content

class RuleVariation_511(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_522.cv_arg
    cv_variation: TypeAlias = Variation_522

    @classmethod
    def create(cls, arg : "RuleVariation_511.cv_arg") -> "RuleVariation_511":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_522:
        return self.arg # type: ignore

class Content_148(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "SAM function"}

class RuleContent_148(RuleContentContextFree):
    cv_arg: TypeAlias = Content_148.cv_arg
    cv_content: TypeAlias = Content_148

    @property
    def content(self) -> Content_148:
        return self._get_content() # type: ignore

class Variation_632(Element):
    cv_arg: TypeAlias = RuleContent_148.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_148

    @classmethod
    def create(cls, arg: "Variation_632.cv_arg") -> "Variation_632":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_148:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_148:
        return self.rule.content

class RuleVariation_621(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_632.cv_arg
    cv_variation: TypeAlias = Variation_632

    @classmethod
    def create(cls, arg : "RuleVariation_621.cv_arg") -> "RuleVariation_621":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_632:
        return self.arg # type: ignore

class Content_160(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "VCD function"}

class RuleContent_160(RuleContentContextFree):
    cv_arg: TypeAlias = Content_160.cv_arg
    cv_content: TypeAlias = Content_160

    @property
    def content(self) -> Content_160:
        return self._get_content() # type: ignore

class Variation_712(Element):
    cv_arg: TypeAlias = RuleContent_160.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_160

    @classmethod
    def create(cls, arg: "Variation_712.cv_arg") -> "Variation_712":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_160:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_160:
        return self.rule.content

class RuleVariation_701(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_712.cv_arg
    cv_variation: TypeAlias = Variation_712

    @classmethod
    def create(cls, arg : "RuleVariation_701.cv_arg") -> "RuleVariation_701":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_712:
        return self.arg # type: ignore

class Content_86(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "CHAM function"}

class RuleContent_86(RuleContentContextFree):
    cv_arg: TypeAlias = Content_86.cv_arg
    cv_content: TypeAlias = Content_86

    @property
    def content(self) -> Content_86:
        return self._get_content() # type: ignore

class Variation_829(Element):
    cv_arg: TypeAlias = RuleContent_86.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_86

    @classmethod
    def create(cls, arg: "Variation_829.cv_arg") -> "Variation_829":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_86:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_86:
        return self.rule.content

class RuleVariation_799(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_829.cv_arg
    cv_variation: TypeAlias = Variation_829

    @classmethod
    def create(cls, arg : "RuleVariation_799.cv_arg") -> "RuleVariation_799":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_829:
        return self.arg # type: ignore

class Content_93(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "DSAM function"}

class RuleContent_93(RuleContentContextFree):
    cv_arg: TypeAlias = Content_93.cv_arg
    cv_content: TypeAlias = Content_93

    @property
    def content(self) -> Content_93:
        return self._get_content() # type: ignore

class Variation_910(Element):
    cv_arg: TypeAlias = RuleContent_93.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_93

    @classmethod
    def create(cls, arg: "Variation_910.cv_arg") -> "Variation_910":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_93:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_93:
        return self.rule.content

class RuleVariation_880(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_910.cv_arg
    cv_variation: TypeAlias = Variation_910

    @classmethod
    def create(cls, arg : "RuleVariation_880.cv_arg") -> "RuleVariation_880":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_910:
        return self.arg # type: ignore

class Content_90(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "DBPSM ARR sub-function"}

class RuleContent_90(RuleContentContextFree):
    cv_arg: TypeAlias = Content_90.cv_arg
    cv_content: TypeAlias = Content_90

    @property
    def content(self) -> Content_90:
        return self._get_content() # type: ignore

class Variation_27(Element):
    cv_arg: TypeAlias = RuleContent_90.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_90

    @classmethod
    def create(cls, arg: "Variation_27.cv_arg") -> "Variation_27":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_90:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_90:
        return self.rule.content

class RuleVariation_27(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_27.cv_arg
    cv_variation: TypeAlias = Variation_27

    @classmethod
    def create(cls, arg : "RuleVariation_27.cv_arg") -> "RuleVariation_27":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_27:
        return self.arg # type: ignore

class Content_91(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "DBPSM DEP sub-function"}

class RuleContent_91(RuleContentContextFree):
    cv_arg: TypeAlias = Content_91.cv_arg
    cv_content: TypeAlias = Content_91

    @property
    def content(self) -> Content_91:
        return self._get_content() # type: ignore

class Variation_406(Element):
    cv_arg: TypeAlias = RuleContent_91.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_91

    @classmethod
    def create(cls, arg: "Variation_406.cv_arg") -> "Variation_406":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_91:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_91:
        return self.rule.content

class RuleVariation_395(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_406.cv_arg
    cv_variation: TypeAlias = Variation_406

    @classmethod
    def create(cls, arg : "RuleVariation_395.cv_arg") -> "RuleVariation_395":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_406:
        return self.arg # type: ignore

class Content_92(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "DBPSM TL sub-function"}

class RuleContent_92(RuleContentContextFree):
    cv_arg: TypeAlias = Content_92.cv_arg
    cv_content: TypeAlias = Content_92

    @property
    def content(self) -> Content_92:
        return self._get_content() # type: ignore

class Variation_516(Element):
    cv_arg: TypeAlias = RuleContent_92.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_92

    @classmethod
    def create(cls, arg: "Variation_516.cv_arg") -> "Variation_516":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_92:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_92:
        return self.rule.content

class RuleVariation_505(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_516.cv_arg
    cv_variation: TypeAlias = Variation_516

    @classmethod
    def create(cls, arg : "RuleVariation_505.cv_arg") -> "RuleVariation_505":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_516:
        return self.arg # type: ignore

class Content_162(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "VRAM CRM sub-function"}

class RuleContent_162(RuleContentContextFree):
    cv_arg: TypeAlias = Content_162.cv_arg
    cv_content: TypeAlias = Content_162

    @property
    def content(self) -> Content_162:
        return self._get_content() # type: ignore

class Variation_634(Element):
    cv_arg: TypeAlias = RuleContent_162.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_162

    @classmethod
    def create(cls, arg: "Variation_634.cv_arg") -> "Variation_634":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_162:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_162:
        return self.rule.content

class RuleVariation_623(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_634.cv_arg
    cv_variation: TypeAlias = Variation_634

    @classmethod
    def create(cls, arg : "RuleVariation_623.cv_arg") -> "RuleVariation_623":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_634:
        return self.arg # type: ignore

class Content_164(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "VRAM VTM sub-function"}

class RuleContent_164(RuleContentContextFree):
    cv_arg: TypeAlias = Content_164.cv_arg
    cv_content: TypeAlias = Content_164

    @property
    def content(self) -> Content_164:
        return self._get_content() # type: ignore

class Variation_714(Element):
    cv_arg: TypeAlias = RuleContent_164.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_164

    @classmethod
    def create(cls, arg: "Variation_714.cv_arg") -> "Variation_714":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_164:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_164:
        return self.rule.content

class RuleVariation_703(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_714.cv_arg
    cv_variation: TypeAlias = Variation_714

    @classmethod
    def create(cls, arg : "RuleVariation_703.cv_arg") -> "RuleVariation_703":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_714:
        return self.arg # type: ignore

class Content_163(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "VRAM VRM sub-function"}

class RuleContent_163(RuleContentContextFree):
    cv_arg: TypeAlias = Content_163.cv_arg
    cv_content: TypeAlias = Content_163

    @property
    def content(self) -> Content_163:
        return self._get_content() # type: ignore

class Variation_841(Element):
    cv_arg: TypeAlias = RuleContent_163.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_163

    @classmethod
    def create(cls, arg: "Variation_841.cv_arg") -> "Variation_841":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_163:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_163:
        return self.rule.content

class RuleVariation_811(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_841.cv_arg
    cv_variation: TypeAlias = Variation_841

    @classmethod
    def create(cls, arg : "RuleVariation_811.cv_arg") -> "RuleVariation_811":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_841:
        return self.arg # type: ignore

class Content_101(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "HAM HD sub-function"}

class RuleContent_101(RuleContentContextFree):
    cv_arg: TypeAlias = Content_101.cv_arg
    cv_content: TypeAlias = Content_101

    @property
    def content(self) -> Content_101:
        return self._get_content() # type: ignore

class Variation_913(Element):
    cv_arg: TypeAlias = RuleContent_101.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_101

    @classmethod
    def create(cls, arg: "Variation_913.cv_arg") -> "Variation_913":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_101:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_101:
        return self.rule.content

class RuleVariation_883(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_913.cv_arg
    cv_variation: TypeAlias = Variation_913

    @classmethod
    def create(cls, arg : "RuleVariation_883.cv_arg") -> "RuleVariation_883":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_913:
        return self.arg # type: ignore

class Content_102(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "HAM RD sub-function"}

class RuleContent_102(RuleContentContextFree):
    cv_arg: TypeAlias = Content_102.cv_arg
    cv_content: TypeAlias = Content_102

    @property
    def content(self) -> Content_102:
        return self._get_content() # type: ignore

class Variation_29(Element):
    cv_arg: TypeAlias = RuleContent_102.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_102

    @classmethod
    def create(cls, arg: "Variation_29.cv_arg") -> "Variation_29":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_102:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_102:
        return self.rule.content

class RuleVariation_29(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_29.cv_arg
    cv_variation: TypeAlias = Variation_29

    @classmethod
    def create(cls, arg : "RuleVariation_29.cv_arg") -> "RuleVariation_29":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_29:
        return self.arg # type: ignore

class Content_103(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "HAM VD sub-function"}

class RuleContent_103(RuleContentContextFree):
    cv_arg: TypeAlias = Content_103.cv_arg
    cv_content: TypeAlias = Content_103

    @property
    def content(self) -> Content_103:
        return self._get_content() # type: ignore

class Variation_409(Element):
    cv_arg: TypeAlias = RuleContent_103.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_103

    @classmethod
    def create(cls, arg: "Variation_409.cv_arg") -> "Variation_409":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_103:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_103:
        return self.rule.content

class RuleVariation_398(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_409.cv_arg
    cv_variation: TypeAlias = Variation_409

    @classmethod
    def create(cls, arg : "RuleVariation_398.cv_arg") -> "RuleVariation_398":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_409:
        return self.arg # type: ignore

class Content_104(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "HVI function"}

class RuleContent_104(RuleContentContextFree):
    cv_arg: TypeAlias = Content_104.cv_arg
    cv_content: TypeAlias = Content_104

    @property
    def content(self) -> Content_104:
        return self._get_content() # type: ignore

class Variation_518(Element):
    cv_arg: TypeAlias = RuleContent_104.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_104

    @classmethod
    def create(cls, arg: "Variation_518.cv_arg") -> "Variation_518":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_104:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_104:
        return self.rule.content

class RuleVariation_507(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_518.cv_arg
    cv_variation: TypeAlias = Variation_518

    @classmethod
    def create(cls, arg : "RuleVariation_507.cv_arg") -> "RuleVariation_507":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_518:
        return self.arg # type: ignore

class Content_111(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "LTW function"}

class RuleContent_111(RuleContentContextFree):
    cv_arg: TypeAlias = Content_111.cv_arg
    cv_content: TypeAlias = Content_111

    @property
    def content(self) -> Content_111:
        return self._get_content() # type: ignore

class Variation_625(Element):
    cv_arg: TypeAlias = RuleContent_111.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_111

    @classmethod
    def create(cls, arg: "Variation_625.cv_arg") -> "Variation_625":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_111:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_111:
        return self.rule.content

class RuleVariation_614(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_625.cv_arg
    cv_variation: TypeAlias = Variation_625

    @classmethod
    def create(cls, arg : "RuleVariation_614.cv_arg") -> "RuleVariation_614":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_625:
        return self.arg # type: ignore

class Content_161(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "VPM function"}

class RuleContent_161(RuleContentContextFree):
    cv_arg: TypeAlias = Content_161.cv_arg
    cv_content: TypeAlias = Content_161

    @property
    def content(self) -> Content_161:
        return self._get_content() # type: ignore

class Variation_713(Element):
    cv_arg: TypeAlias = RuleContent_161.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_161

    @classmethod
    def create(cls, arg: "Variation_713.cv_arg") -> "Variation_713":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_161:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_161:
        return self.rule.content

class RuleVariation_702(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_713.cv_arg
    cv_variation: TypeAlias = Variation_713

    @classmethod
    def create(cls, arg : "RuleVariation_702.cv_arg") -> "RuleVariation_702":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_713:
        return self.arg # type: ignore

class Content_154(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "TTA function"}

class RuleContent_154(RuleContentContextFree):
    cv_arg: TypeAlias = Content_154.cv_arg
    cv_content: TypeAlias = Content_154

    @property
    def content(self) -> Content_154:
        return self._get_content() # type: ignore

class Variation_839(Element):
    cv_arg: TypeAlias = RuleContent_154.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_154

    @classmethod
    def create(cls, arg: "Variation_839.cv_arg") -> "Variation_839":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_154:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_154:
        return self.rule.content

class RuleVariation_809(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_839.cv_arg
    cv_variation: TypeAlias = Variation_839

    @classmethod
    def create(cls, arg : "RuleVariation_809.cv_arg") -> "RuleVariation_809":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_839:
        return self.arg # type: ignore

class Content_88(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "CRA function"}

class RuleContent_88(RuleContentContextFree):
    cv_arg: TypeAlias = Content_88.cv_arg
    cv_content: TypeAlias = Content_88

    @property
    def content(self) -> Content_88:
        return self._get_content() # type: ignore

class Variation_908(Element):
    cv_arg: TypeAlias = RuleContent_88.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_88

    @classmethod
    def create(cls, arg: "Variation_908.cv_arg") -> "Variation_908":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_88:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_88:
        return self.rule.content

class RuleVariation_878(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_908.cv_arg
    cv_variation: TypeAlias = Variation_908

    @classmethod
    def create(cls, arg : "RuleVariation_878.cv_arg") -> "RuleVariation_878":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_908:
        return self.arg # type: ignore

class Content_83(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "ASM sub-function"}

class RuleContent_83(RuleContentContextFree):
    cv_arg: TypeAlias = Content_83.cv_arg
    cv_content: TypeAlias = Content_83

    @property
    def content(self) -> Content_83:
        return self._get_content() # type: ignore

class Variation_25(Element):
    cv_arg: TypeAlias = RuleContent_83.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_83

    @classmethod
    def create(cls, arg: "Variation_25.cv_arg") -> "Variation_25":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_83:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_83:
        return self.rule.content

class RuleVariation_25(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_25.cv_arg
    cv_variation: TypeAlias = Variation_25

    @classmethod
    def create(cls, arg : "RuleVariation_25.cv_arg") -> "RuleVariation_25":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_25:
        return self.arg # type: ignore

class Content_106(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "IAVM sub-function"}

class RuleContent_106(RuleContentContextFree):
    cv_arg: TypeAlias = Content_106.cv_arg
    cv_content: TypeAlias = Content_106

    @property
    def content(self) -> Content_106:
        return self._get_content() # type: ignore

class Variation_410(Element):
    cv_arg: TypeAlias = RuleContent_106.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_106

    @classmethod
    def create(cls, arg: "Variation_410.cv_arg") -> "Variation_410":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_106:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_106:
        return self.rule.content

class RuleVariation_399(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_410.cv_arg
    cv_variation: TypeAlias = Variation_410

    @classmethod
    def create(cls, arg : "RuleVariation_399.cv_arg") -> "RuleVariation_399":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_410:
        return self.arg # type: ignore

class Content_96(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "FTD Function"}

class RuleContent_96(RuleContentContextFree):
    cv_arg: TypeAlias = Content_96.cv_arg
    cv_content: TypeAlias = Content_96

    @property
    def content(self) -> Content_96:
        return self._get_content() # type: ignore

class Variation_517(Element):
    cv_arg: TypeAlias = RuleContent_96.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_96

    @classmethod
    def create(cls, arg: "Variation_517.cv_arg") -> "Variation_517":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_96:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_96:
        return self.rule.content

class RuleVariation_506(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_517.cv_arg
    cv_variation: TypeAlias = Variation_517

    @classmethod
    def create(cls, arg : "RuleVariation_506.cv_arg") -> "RuleVariation_506":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_517:
        return self.arg # type: ignore

class Content_108(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "ITD function"}

class RuleContent_108(RuleContentContextFree):
    cv_arg: TypeAlias = Content_108.cv_arg
    cv_content: TypeAlias = Content_108

    @property
    def content(self) -> Content_108:
        return self._get_content() # type: ignore

class Variation_623(Element):
    cv_arg: TypeAlias = RuleContent_108.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_108

    @classmethod
    def create(cls, arg: "Variation_623.cv_arg") -> "Variation_623":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_108:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_108:
        return self.rule.content

class RuleVariation_612(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_623.cv_arg
    cv_variation: TypeAlias = Variation_623

    @classmethod
    def create(cls, arg : "RuleVariation_612.cv_arg") -> "RuleVariation_612":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_623:
        return self.arg # type: ignore

class Content_107(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "IIA function"}

class RuleContent_107(RuleContentContextFree):
    cv_arg: TypeAlias = Content_107.cv_arg
    cv_content: TypeAlias = Content_107

    @property
    def content(self) -> Content_107:
        return self._get_content() # type: ignore

class Variation_707(Element):
    cv_arg: TypeAlias = RuleContent_107.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_107

    @classmethod
    def create(cls, arg: "Variation_707.cv_arg") -> "Variation_707":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_107:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_107:
        return self.rule.content

class RuleVariation_696(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_707.cv_arg
    cv_variation: TypeAlias = Variation_707

    @classmethod
    def create(cls, arg : "RuleVariation_696.cv_arg") -> "RuleVariation_696":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_707:
        return self.arg # type: ignore

class Content_149(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "SQW function"}

class RuleContent_149(RuleContentContextFree):
    cv_arg: TypeAlias = Content_149.cv_arg
    cv_content: TypeAlias = Content_149

    @property
    def content(self) -> Content_149:
        return self._get_content() # type: ignore

class Variation_836(Element):
    cv_arg: TypeAlias = RuleContent_149.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_149

    @classmethod
    def create(cls, arg: "Variation_836.cv_arg") -> "Variation_836":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_149:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_149:
        return self.rule.content

class RuleVariation_806(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_836.cv_arg
    cv_variation: TypeAlias = Variation_836

    @classmethod
    def create(cls, arg : "RuleVariation_806.cv_arg") -> "RuleVariation_806":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_836:
        return self.arg # type: ignore

class Content_89(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "CUW function"}

class RuleContent_89(RuleContentContextFree):
    cv_arg: TypeAlias = Content_89.cv_arg
    cv_content: TypeAlias = Content_89

    @property
    def content(self) -> Content_89:
        return self._get_content() # type: ignore

class Variation_909(Element):
    cv_arg: TypeAlias = RuleContent_89.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_89

    @classmethod
    def create(cls, arg: "Variation_909.cv_arg") -> "Variation_909":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_89:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_89:
        return self.rule.content

class RuleVariation_879(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_909.cv_arg
    cv_variation: TypeAlias = Variation_909

    @classmethod
    def create(cls, arg : "RuleVariation_879.cv_arg") -> "RuleVariation_879":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_909:
        return self.arg # type: ignore

class Content_85(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "CATC function"}

class RuleContent_85(RuleContentContextFree):
    cv_arg: TypeAlias = Content_85.cv_arg
    cv_content: TypeAlias = Content_85

    @property
    def content(self) -> Content_85:
        return self._get_content() # type: ignore

class Variation_26(Element):
    cv_arg: TypeAlias = RuleContent_85.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_85

    @classmethod
    def create(cls, arg: "Variation_26.cv_arg") -> "Variation_26":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_85:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_85:
        return self.rule.content

class RuleVariation_26(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_26.cv_arg
    cv_variation: TypeAlias = Variation_26

    @classmethod
    def create(cls, arg : "RuleVariation_26.cv_arg") -> "RuleVariation_26":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_26:
        return self.arg # type: ignore

class Content_129(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "NOCLR sub-function"}

class RuleContent_129(RuleContentContextFree):
    cv_arg: TypeAlias = Content_129.cv_arg
    cv_content: TypeAlias = Content_129

    @property
    def content(self) -> Content_129:
        return self._get_content() # type: ignore

class Variation_414(Element):
    cv_arg: TypeAlias = RuleContent_129.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_129

    @classmethod
    def create(cls, arg: "Variation_414.cv_arg") -> "Variation_414":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_129:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_129:
        return self.rule.content

class RuleVariation_403(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_414.cv_arg
    cv_variation: TypeAlias = Variation_414

    @classmethod
    def create(cls, arg : "RuleVariation_403.cv_arg") -> "RuleVariation_403":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_414:
        return self.arg # type: ignore

class Content_131(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "NOMOV Function"}

class RuleContent_131(RuleContentContextFree):
    cv_arg: TypeAlias = Content_131.cv_arg
    cv_content: TypeAlias = Content_131

    @property
    def content(self) -> Content_131:
        return self._get_content() # type: ignore

class Variation_521(Element):
    cv_arg: TypeAlias = RuleContent_131.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_131

    @classmethod
    def create(cls, arg: "Variation_521.cv_arg") -> "Variation_521":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_131:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_131:
        return self.rule.content

class RuleVariation_510(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_521.cv_arg
    cv_variation: TypeAlias = Variation_521

    @classmethod
    def create(cls, arg : "RuleVariation_510.cv_arg") -> "RuleVariation_510":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_521:
        return self.arg # type: ignore

class Content_130(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "NOH function"}

class RuleContent_130(RuleContentContextFree):
    cv_arg: TypeAlias = Content_130.cv_arg
    cv_content: TypeAlias = Content_130

    @property
    def content(self) -> Content_130:
        return self._get_content() # type: ignore

class Variation_630(Element):
    cv_arg: TypeAlias = RuleContent_130.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_130

    @classmethod
    def create(cls, arg: "Variation_630.cv_arg") -> "Variation_630":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_130:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_130:
        return self.rule.content

class RuleVariation_619(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_630.cv_arg
    cv_variation: TypeAlias = Variation_630

    @classmethod
    def create(cls, arg : "RuleVariation_619.cv_arg") -> "RuleVariation_619":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_630:
        return self.arg # type: ignore

class Content_165(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "WRTY function"}

class RuleContent_165(RuleContentContextFree):
    cv_arg: TypeAlias = Content_165.cv_arg
    cv_content: TypeAlias = Content_165

    @property
    def content(self) -> Content_165:
        return self._get_content() # type: ignore

class Variation_715(Element):
    cv_arg: TypeAlias = RuleContent_165.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_165

    @classmethod
    def create(cls, arg: "Variation_715.cv_arg") -> "Variation_715":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_165:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_165:
        return self.rule.content

class RuleVariation_704(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_715.cv_arg
    cv_variation: TypeAlias = Variation_715

    @classmethod
    def create(cls, arg : "RuleVariation_704.cv_arg") -> "RuleVariation_704":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_715:
        return self.arg # type: ignore

class Content_151(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "STOCC function"}

class RuleContent_151(RuleContentContextFree):
    cv_arg: TypeAlias = Content_151.cv_arg
    cv_content: TypeAlias = Content_151

    @property
    def content(self) -> Content_151:
        return self._get_content() # type: ignore

class Variation_837(Element):
    cv_arg: TypeAlias = RuleContent_151.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_151

    @classmethod
    def create(cls, arg: "Variation_837.cv_arg") -> "Variation_837":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_151:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_151:
        return self.rule.content

class RuleVariation_807(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_837.cv_arg
    cv_variation: TypeAlias = Variation_837

    @classmethod
    def create(cls, arg : "RuleVariation_807.cv_arg") -> "RuleVariation_807":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_837:
        return self.arg # type: ignore

class Content_135(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "ONGOING function"}

class RuleContent_135(RuleContentContextFree):
    cv_arg: TypeAlias = Content_135.cv_arg
    cv_content: TypeAlias = Content_135

    @property
    def content(self) -> Content_135:
        return self._get_content() # type: ignore

class Variation_915(Element):
    cv_arg: TypeAlias = RuleContent_135.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_135

    @classmethod
    def create(cls, arg: "Variation_915.cv_arg") -> "Variation_915":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_135:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_135:
        return self.rule.content

class RuleVariation_885(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_915.cv_arg
    cv_variation: TypeAlias = Variation_915

    @classmethod
    def create(cls, arg : "RuleVariation_885.cv_arg") -> "RuleVariation_885":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_915:
        return self.arg # type: ignore

class NonSpare_1318(NonSpare):
    cv_arg: TypeAlias = RuleVariation_32.cv_arg
    cv_name = "MRVA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_32

    @classmethod
    def create(cls, arg : "NonSpare_1318.cv_arg") -> "NonSpare_1318":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_32:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_32:
        return self.rule.variation

class Item_584(Item):
    cv_arg: TypeAlias = NonSpare_1318.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1318

    @classmethod
    def create(cls, arg : "Item_584.cv_arg") -> "Item_584":
        return cls._create(arg) # type: ignore

class NonSpare_1547(NonSpare):
    cv_arg: TypeAlias = RuleVariation_405.cv_arg
    cv_name = "RAMLD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_405

    @classmethod
    def create(cls, arg : "NonSpare_1547.cv_arg") -> "NonSpare_1547":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_405:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_416:
        return self.rule.variation

class Item_777(Item):
    cv_arg: TypeAlias = NonSpare_1547.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1547

    @classmethod
    def create(cls, arg : "Item_777.cv_arg") -> "Item_777":
        return cls._create(arg) # type: ignore

class NonSpare_1546(NonSpare):
    cv_arg: TypeAlias = RuleVariation_513.cv_arg
    cv_name = "RAMHD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_513

    @classmethod
    def create(cls, arg : "NonSpare_1546.cv_arg") -> "NonSpare_1546":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_513:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_524:
        return self.rule.variation

class Item_776(Item):
    cv_arg: TypeAlias = NonSpare_1546.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1546

    @classmethod
    def create(cls, arg : "Item_776.cv_arg") -> "Item_776":
        return cls._create(arg) # type: ignore

class NonSpare_1323(NonSpare):
    cv_arg: TypeAlias = RuleVariation_615.cv_arg
    cv_name = "MSAW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_615

    @classmethod
    def create(cls, arg : "NonSpare_1323.cv_arg") -> "NonSpare_1323":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_615:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_626:
        return self.rule.variation

class Item_587(Item):
    cv_arg: TypeAlias = NonSpare_1323.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1323

    @classmethod
    def create(cls, arg : "Item_587.cv_arg") -> "Item_587":
        return cls._create(arg) # type: ignore

class NonSpare_619(NonSpare):
    cv_arg: TypeAlias = RuleVariation_694.cv_arg
    cv_name = "APW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_694

    @classmethod
    def create(cls, arg : "NonSpare_619.cv_arg") -> "NonSpare_619":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_694:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_705:
        return self.rule.variation

class Item_78(Item):
    cv_arg: TypeAlias = NonSpare_619.cv_arg
    cv_non_spare: TypeAlias = NonSpare_619

    @classmethod
    def create(cls, arg : "Item_78.cv_arg") -> "Item_78":
        return cls._create(arg) # type: ignore

class NonSpare_743(NonSpare):
    cv_arg: TypeAlias = RuleVariation_800.cv_arg
    cv_name = "CLAM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_800

    @classmethod
    def create(cls, arg : "NonSpare_743.cv_arg") -> "NonSpare_743":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_800:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_830:
        return self.rule.variation

class Item_162(Item):
    cv_arg: TypeAlias = NonSpare_743.cv_arg
    cv_non_spare: TypeAlias = NonSpare_743

    @classmethod
    def create(cls, arg : "Item_162.cv_arg") -> "Item_162":
        return cls._create(arg) # type: ignore

class NonSpare_1787(NonSpare):
    cv_arg: TypeAlias = RuleVariation_889.cv_arg
    cv_name = "STCA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_889

    @classmethod
    def create(cls, arg : "NonSpare_1787.cv_arg") -> "NonSpare_1787":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_889:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_919:
        return self.rule.variation

class Item_948(Item):
    cv_arg: TypeAlias = NonSpare_1787.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1787

    @classmethod
    def create(cls, arg : "Item_948.cv_arg") -> "Item_948":
        return cls._create(arg) # type: ignore

class NonSpare_618(NonSpare):
    cv_arg: TypeAlias = RuleVariation_24.cv_arg
    cv_name = "APM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_24

    @classmethod
    def create(cls, arg : "NonSpare_618.cv_arg") -> "NonSpare_618":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_24:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_24:
        return self.rule.variation

class Item_77(Item):
    cv_arg: TypeAlias = NonSpare_618.cv_arg
    cv_non_spare: TypeAlias = NonSpare_618

    @classmethod
    def create(cls, arg : "Item_77.cv_arg") -> "Item_77":
        return cls._create(arg) # type: ignore

class NonSpare_1597(NonSpare):
    cv_arg: TypeAlias = RuleVariation_406.cv_arg
    cv_name = "RIMCA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_406

    @classmethod
    def create(cls, arg : "NonSpare_1597.cv_arg") -> "NonSpare_1597":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_406:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_417:
        return self.rule.variation

class Item_822(Item):
    cv_arg: TypeAlias = NonSpare_1597.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1597

    @classmethod
    def create(cls, arg : "Item_822.cv_arg") -> "Item_822":
        return cls._create(arg) # type: ignore

class NonSpare_560(NonSpare):
    cv_arg: TypeAlias = RuleVariation_503.cv_arg
    cv_name = "ACASRA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_503

    @classmethod
    def create(cls, arg : "NonSpare_560.cv_arg") -> "NonSpare_560":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_503:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_514:
        return self.rule.variation

class Item_40(Item):
    cv_arg: TypeAlias = NonSpare_560.cv_arg
    cv_non_spare: TypeAlias = NonSpare_560

    @classmethod
    def create(cls, arg : "Item_40.cv_arg") -> "Item_40":
        return cls._create(arg) # type: ignore

class NonSpare_1381(NonSpare):
    cv_arg: TypeAlias = RuleVariation_620.cv_arg
    cv_name = "NTCA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_620

    @classmethod
    def create(cls, arg : "NonSpare_1381.cv_arg") -> "NonSpare_1381":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_620:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_631:
        return self.rule.variation

class Item_640(Item):
    cv_arg: TypeAlias = NonSpare_1381.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1381

    @classmethod
    def create(cls, arg : "Item_640.cv_arg") -> "Item_640":
        return cls._create(arg) # type: ignore

class NonSpare_883(NonSpare):
    cv_arg: TypeAlias = RuleVariation_700.cv_arg
    cv_name = "DG"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_700

    @classmethod
    def create(cls, arg : "NonSpare_883.cv_arg") -> "NonSpare_883":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_700:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_711:
        return self.rule.variation

class Item_260(Item):
    cv_arg: TypeAlias = NonSpare_883.cv_arg
    cv_non_spare: TypeAlias = NonSpare_883

    @classmethod
    def create(cls, arg : "Item_260.cv_arg") -> "Item_260":
        return cls._create(arg) # type: ignore

class NonSpare_1396(NonSpare):
    cv_arg: TypeAlias = RuleVariation_804.cv_arg
    cv_name = "OF"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_804

    @classmethod
    def create(cls, arg : "NonSpare_1396.cv_arg") -> "NonSpare_1396":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_804:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_834:
        return self.rule.variation

class Item_655(Item):
    cv_arg: TypeAlias = NonSpare_1396.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1396

    @classmethod
    def create(cls, arg : "Item_655.cv_arg") -> "Item_655":
        return cls._create(arg) # type: ignore

class NonSpare_1397(NonSpare):
    cv_arg: TypeAlias = RuleVariation_886.cv_arg
    cv_name = "OL"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_886

    @classmethod
    def create(cls, arg : "NonSpare_1397.cv_arg") -> "NonSpare_1397":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_886:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_916:
        return self.rule.variation

class Item_656(Item):
    cv_arg: TypeAlias = NonSpare_1397.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1397

    @classmethod
    def create(cls, arg : "Item_656.cv_arg") -> "Item_656":
        return cls._create(arg) # type: ignore

class NonSpare_589(NonSpare):
    cv_arg: TypeAlias = RuleVariation_23.cv_arg
    cv_name = "AIW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_23

    @classmethod
    def create(cls, arg : "NonSpare_589.cv_arg") -> "NonSpare_589":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_23:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_23:
        return self.rule.variation

class Item_56(Item):
    cv_arg: TypeAlias = NonSpare_589.cv_arg
    cv_non_spare: TypeAlias = NonSpare_589

    @classmethod
    def create(cls, arg : "Item_56.cv_arg") -> "Item_56":
        return cls._create(arg) # type: ignore

class NonSpare_1421(NonSpare):
    cv_arg: TypeAlias = RuleVariation_404.cv_arg
    cv_name = "PAIW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_404

    @classmethod
    def create(cls, arg : "NonSpare_1421.cv_arg") -> "NonSpare_1421":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_404:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_415:
        return self.rule.variation

class Item_678(Item):
    cv_arg: TypeAlias = NonSpare_1421.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1421

    @classmethod
    def create(cls, arg : "Item_678.cv_arg") -> "Item_678":
        return cls._create(arg) # type: ignore

class NonSpare_1390(NonSpare):
    cv_arg: TypeAlias = RuleVariation_511.cv_arg
    cv_name = "OCAT"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_511

    @classmethod
    def create(cls, arg : "NonSpare_1390.cv_arg") -> "NonSpare_1390":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_511:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_522:
        return self.rule.variation

class Item_649(Item):
    cv_arg: TypeAlias = NonSpare_1390.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1390

    @classmethod
    def create(cls, arg : "Item_649.cv_arg") -> "Item_649":
        return cls._create(arg) # type: ignore

class NonSpare_1661(NonSpare):
    cv_arg: TypeAlias = RuleVariation_621.cv_arg
    cv_name = "SAM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_621

    @classmethod
    def create(cls, arg : "NonSpare_1661.cv_arg") -> "NonSpare_1661":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_621:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_632:
        return self.rule.variation

class Item_859(Item):
    cv_arg: TypeAlias = NonSpare_1661.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1661

    @classmethod
    def create(cls, arg : "Item_859.cv_arg") -> "Item_859":
        return cls._create(arg) # type: ignore

class NonSpare_2028(NonSpare):
    cv_arg: TypeAlias = RuleVariation_701.cv_arg
    cv_name = "VCD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_701

    @classmethod
    def create(cls, arg : "NonSpare_2028.cv_arg") -> "NonSpare_2028":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_701:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_712:
        return self.rule.variation

class Item_1138(Item):
    cv_arg: TypeAlias = NonSpare_2028.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2028

    @classmethod
    def create(cls, arg : "Item_1138.cv_arg") -> "Item_1138":
        return cls._create(arg) # type: ignore

class NonSpare_733(NonSpare):
    cv_arg: TypeAlias = RuleVariation_799.cv_arg
    cv_name = "CHAM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_799

    @classmethod
    def create(cls, arg : "NonSpare_733.cv_arg") -> "NonSpare_733":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_799:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_829:
        return self.rule.variation

class Item_155(Item):
    cv_arg: TypeAlias = NonSpare_733.cv_arg
    cv_non_spare: TypeAlias = NonSpare_733

    @classmethod
    def create(cls, arg : "Item_155.cv_arg") -> "Item_155":
        return cls._create(arg) # type: ignore

class NonSpare_903(NonSpare):
    cv_arg: TypeAlias = RuleVariation_880.cv_arg
    cv_name = "DSAM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_880

    @classmethod
    def create(cls, arg : "NonSpare_903.cv_arg") -> "NonSpare_903":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_880:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_910:
        return self.rule.variation

class Item_276(Item):
    cv_arg: TypeAlias = NonSpare_903.cv_arg
    cv_non_spare: TypeAlias = NonSpare_903

    @classmethod
    def create(cls, arg : "Item_276.cv_arg") -> "Item_276":
        return cls._create(arg) # type: ignore

class NonSpare_865(NonSpare):
    cv_arg: TypeAlias = RuleVariation_27.cv_arg
    cv_name = "DBPSMARR"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_27

    @classmethod
    def create(cls, arg : "NonSpare_865.cv_arg") -> "NonSpare_865":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_27:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_27:
        return self.rule.variation

class Item_243(Item):
    cv_arg: TypeAlias = NonSpare_865.cv_arg
    cv_non_spare: TypeAlias = NonSpare_865

    @classmethod
    def create(cls, arg : "Item_243.cv_arg") -> "Item_243":
        return cls._create(arg) # type: ignore

class NonSpare_867(NonSpare):
    cv_arg: TypeAlias = RuleVariation_395.cv_arg
    cv_name = "DBPSMDEP"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_395

    @classmethod
    def create(cls, arg : "NonSpare_867.cv_arg") -> "NonSpare_867":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_395:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_406:
        return self.rule.variation

class Item_245(Item):
    cv_arg: TypeAlias = NonSpare_867.cv_arg
    cv_non_spare: TypeAlias = NonSpare_867

    @classmethod
    def create(cls, arg : "Item_245.cv_arg") -> "Item_245":
        return cls._create(arg) # type: ignore

class NonSpare_869(NonSpare):
    cv_arg: TypeAlias = RuleVariation_505.cv_arg
    cv_name = "DBPSMTL"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_505

    @classmethod
    def create(cls, arg : "NonSpare_869.cv_arg") -> "NonSpare_869":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_505:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_516:
        return self.rule.variation

class Item_247(Item):
    cv_arg: TypeAlias = NonSpare_869.cv_arg
    cv_non_spare: TypeAlias = NonSpare_869

    @classmethod
    def create(cls, arg : "Item_247.cv_arg") -> "Item_247":
        return cls._create(arg) # type: ignore

class NonSpare_2040(NonSpare):
    cv_arg: TypeAlias = RuleVariation_623.cv_arg
    cv_name = "VRAMCRM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_623

    @classmethod
    def create(cls, arg : "NonSpare_2040.cv_arg") -> "NonSpare_2040":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_623:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_634:
        return self.rule.variation

class Item_1149(Item):
    cv_arg: TypeAlias = NonSpare_2040.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2040

    @classmethod
    def create(cls, arg : "Item_1149.cv_arg") -> "Item_1149":
        return cls._create(arg) # type: ignore

class NonSpare_2043(NonSpare):
    cv_arg: TypeAlias = RuleVariation_703.cv_arg
    cv_name = "VRAMVTM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_703

    @classmethod
    def create(cls, arg : "NonSpare_2043.cv_arg") -> "NonSpare_2043":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_703:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_714:
        return self.rule.variation

class Item_1152(Item):
    cv_arg: TypeAlias = NonSpare_2043.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2043

    @classmethod
    def create(cls, arg : "Item_1152.cv_arg") -> "Item_1152":
        return cls._create(arg) # type: ignore

class NonSpare_2042(NonSpare):
    cv_arg: TypeAlias = RuleVariation_811.cv_arg
    cv_name = "VRAMVRM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_811

    @classmethod
    def create(cls, arg : "NonSpare_2042.cv_arg") -> "NonSpare_2042":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_811:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_841:
        return self.rule.variation

class Item_1151(Item):
    cv_arg: TypeAlias = NonSpare_2042.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2042

    @classmethod
    def create(cls, arg : "Item_1151.cv_arg") -> "Item_1151":
        return cls._create(arg) # type: ignore

class NonSpare_1054(NonSpare):
    cv_arg: TypeAlias = RuleVariation_883.cv_arg
    cv_name = "HAMHD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_883

    @classmethod
    def create(cls, arg : "NonSpare_1054.cv_arg") -> "NonSpare_1054":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_883:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_913:
        return self.rule.variation

class Item_382(Item):
    cv_arg: TypeAlias = NonSpare_1054.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1054

    @classmethod
    def create(cls, arg : "Item_382.cv_arg") -> "Item_382":
        return cls._create(arg) # type: ignore

class NonSpare_1056(NonSpare):
    cv_arg: TypeAlias = RuleVariation_29.cv_arg
    cv_name = "HAMRD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_29

    @classmethod
    def create(cls, arg : "NonSpare_1056.cv_arg") -> "NonSpare_1056":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_29:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_29:
        return self.rule.variation

class Item_384(Item):
    cv_arg: TypeAlias = NonSpare_1056.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1056

    @classmethod
    def create(cls, arg : "Item_384.cv_arg") -> "Item_384":
        return cls._create(arg) # type: ignore

class NonSpare_1058(NonSpare):
    cv_arg: TypeAlias = RuleVariation_398.cv_arg
    cv_name = "HAMVD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_398

    @classmethod
    def create(cls, arg : "NonSpare_1058.cv_arg") -> "NonSpare_1058":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_398:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_409:
        return self.rule.variation

class Item_386(Item):
    cv_arg: TypeAlias = NonSpare_1058.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1058

    @classmethod
    def create(cls, arg : "Item_386.cv_arg") -> "Item_386":
        return cls._create(arg) # type: ignore

class NonSpare_1085(NonSpare):
    cv_arg: TypeAlias = RuleVariation_507.cv_arg
    cv_name = "HVI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_507

    @classmethod
    def create(cls, arg : "NonSpare_1085.cv_arg") -> "NonSpare_1085":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_507:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_518:
        return self.rule.variation

class Item_407(Item):
    cv_arg: TypeAlias = NonSpare_1085.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1085

    @classmethod
    def create(cls, arg : "Item_407.cv_arg") -> "Item_407":
        return cls._create(arg) # type: ignore

class NonSpare_1202(NonSpare):
    cv_arg: TypeAlias = RuleVariation_614.cv_arg
    cv_name = "LTW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_614

    @classmethod
    def create(cls, arg : "NonSpare_1202.cv_arg") -> "NonSpare_1202":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_614:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_625:
        return self.rule.variation

class Item_510(Item):
    cv_arg: TypeAlias = NonSpare_1202.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1202

    @classmethod
    def create(cls, arg : "Item_510.cv_arg") -> "Item_510":
        return cls._create(arg) # type: ignore

class NonSpare_2038(NonSpare):
    cv_arg: TypeAlias = RuleVariation_702.cv_arg
    cv_name = "VPM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_702

    @classmethod
    def create(cls, arg : "NonSpare_2038.cv_arg") -> "NonSpare_2038":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_702:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_713:
        return self.rule.variation

class Item_1147(Item):
    cv_arg: TypeAlias = NonSpare_2038.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2038

    @classmethod
    def create(cls, arg : "Item_1147.cv_arg") -> "Item_1147":
        return cls._create(arg) # type: ignore

class NonSpare_1946(NonSpare):
    cv_arg: TypeAlias = RuleVariation_809.cv_arg
    cv_name = "TTA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_809

    @classmethod
    def create(cls, arg : "NonSpare_1946.cv_arg") -> "NonSpare_1946":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_809:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_839:
        return self.rule.variation

class Item_1061(Item):
    cv_arg: TypeAlias = NonSpare_1946.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1946

    @classmethod
    def create(cls, arg : "Item_1061.cv_arg") -> "Item_1061":
        return cls._create(arg) # type: ignore

class NonSpare_828(NonSpare):
    cv_arg: TypeAlias = RuleVariation_878.cv_arg
    cv_name = "CRA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_878

    @classmethod
    def create(cls, arg : "NonSpare_828.cv_arg") -> "NonSpare_828":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_878:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_908:
        return self.rule.variation

class Item_214(Item):
    cv_arg: TypeAlias = NonSpare_828.cv_arg
    cv_non_spare: TypeAlias = NonSpare_828

    @classmethod
    def create(cls, arg : "Item_214.cv_arg") -> "Item_214":
        return cls._create(arg) # type: ignore

class NonSpare_638(NonSpare):
    cv_arg: TypeAlias = RuleVariation_25.cv_arg
    cv_name = "ASM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_25

    @classmethod
    def create(cls, arg : "NonSpare_638.cv_arg") -> "NonSpare_638":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_25:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_25:
        return self.rule.variation

class Item_87(Item):
    cv_arg: TypeAlias = NonSpare_638.cv_arg
    cv_non_spare: TypeAlias = NonSpare_638

    @classmethod
    def create(cls, arg : "Item_87.cv_arg") -> "Item_87":
        return cls._create(arg) # type: ignore

class NonSpare_1105(NonSpare):
    cv_arg: TypeAlias = RuleVariation_399.cv_arg
    cv_name = "IAVM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_399

    @classmethod
    def create(cls, arg : "NonSpare_1105.cv_arg") -> "NonSpare_1105":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_399:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_410:
        return self.rule.variation

class Item_423(Item):
    cv_arg: TypeAlias = NonSpare_1105.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1105

    @classmethod
    def create(cls, arg : "Item_423.cv_arg") -> "Item_423":
        return cls._create(arg) # type: ignore

class NonSpare_1005(NonSpare):
    cv_arg: TypeAlias = RuleVariation_506.cv_arg
    cv_name = "FTD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_506

    @classmethod
    def create(cls, arg : "NonSpare_1005.cv_arg") -> "NonSpare_1005":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_506:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_517:
        return self.rule.variation

class Item_351(Item):
    cv_arg: TypeAlias = NonSpare_1005.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1005

    @classmethod
    def create(cls, arg : "Item_351.cv_arg") -> "Item_351":
        return cls._create(arg) # type: ignore

class NonSpare_1129(NonSpare):
    cv_arg: TypeAlias = RuleVariation_612.cv_arg
    cv_name = "ITD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_612

    @classmethod
    def create(cls, arg : "NonSpare_1129.cv_arg") -> "NonSpare_1129":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_612:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_623:
        return self.rule.variation

class Item_441(Item):
    cv_arg: TypeAlias = NonSpare_1129.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1129

    @classmethod
    def create(cls, arg : "Item_441.cv_arg") -> "Item_441":
        return cls._create(arg) # type: ignore

class NonSpare_1120(NonSpare):
    cv_arg: TypeAlias = RuleVariation_696.cv_arg
    cv_name = "IIA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_696

    @classmethod
    def create(cls, arg : "NonSpare_1120.cv_arg") -> "NonSpare_1120":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_696:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_707:
        return self.rule.variation

class Item_434(Item):
    cv_arg: TypeAlias = NonSpare_1120.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1120

    @classmethod
    def create(cls, arg : "Item_434.cv_arg") -> "Item_434":
        return cls._create(arg) # type: ignore

class NonSpare_1744(NonSpare):
    cv_arg: TypeAlias = RuleVariation_806.cv_arg
    cv_name = "SQW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_806

    @classmethod
    def create(cls, arg : "NonSpare_1744.cv_arg") -> "NonSpare_1744":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_806:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_836:
        return self.rule.variation

class Item_917(Item):
    cv_arg: TypeAlias = NonSpare_1744.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1744

    @classmethod
    def create(cls, arg : "Item_917.cv_arg") -> "Item_917":
        return cls._create(arg) # type: ignore

class NonSpare_851(NonSpare):
    cv_arg: TypeAlias = RuleVariation_879.cv_arg
    cv_name = "CUW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_879

    @classmethod
    def create(cls, arg : "NonSpare_851.cv_arg") -> "NonSpare_851":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_879:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_909:
        return self.rule.variation

class Item_232(Item):
    cv_arg: TypeAlias = NonSpare_851.cv_arg
    cv_non_spare: TypeAlias = NonSpare_851

    @classmethod
    def create(cls, arg : "Item_232.cv_arg") -> "Item_232":
        return cls._create(arg) # type: ignore

class NonSpare_707(NonSpare):
    cv_arg: TypeAlias = RuleVariation_26.cv_arg
    cv_name = "CATC"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_26

    @classmethod
    def create(cls, arg : "NonSpare_707.cv_arg") -> "NonSpare_707":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_26:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_26:
        return self.rule.variation

class Item_137(Item):
    cv_arg: TypeAlias = NonSpare_707.cv_arg
    cv_non_spare: TypeAlias = NonSpare_707

    @classmethod
    def create(cls, arg : "Item_137.cv_arg") -> "Item_137":
        return cls._create(arg) # type: ignore

class NonSpare_1363(NonSpare):
    cv_arg: TypeAlias = RuleVariation_403.cv_arg
    cv_name = "NOCLR"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_403

    @classmethod
    def create(cls, arg : "NonSpare_1363.cv_arg") -> "NonSpare_1363":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_403:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_414:
        return self.rule.variation

class Item_623(Item):
    cv_arg: TypeAlias = NonSpare_1363.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1363

    @classmethod
    def create(cls, arg : "Item_623.cv_arg") -> "Item_623":
        return cls._create(arg) # type: ignore

class NonSpare_1376(NonSpare):
    cv_arg: TypeAlias = RuleVariation_510.cv_arg
    cv_name = "NOMOV"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_510

    @classmethod
    def create(cls, arg : "NonSpare_1376.cv_arg") -> "NonSpare_1376":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_510:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_521:
        return self.rule.variation

class Item_636(Item):
    cv_arg: TypeAlias = NonSpare_1376.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1376

    @classmethod
    def create(cls, arg : "Item_636.cv_arg") -> "Item_636":
        return cls._create(arg) # type: ignore

class NonSpare_1371(NonSpare):
    cv_arg: TypeAlias = RuleVariation_619.cv_arg
    cv_name = "NOH"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_619

    @classmethod
    def create(cls, arg : "NonSpare_1371.cv_arg") -> "NonSpare_1371":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_619:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_630:
        return self.rule.variation

class Item_631(Item):
    cv_arg: TypeAlias = NonSpare_1371.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1371

    @classmethod
    def create(cls, arg : "Item_631.cv_arg") -> "Item_631":
        return cls._create(arg) # type: ignore

class NonSpare_2064(NonSpare):
    cv_arg: TypeAlias = RuleVariation_704.cv_arg
    cv_name = "WRTY"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_704

    @classmethod
    def create(cls, arg : "NonSpare_2064.cv_arg") -> "NonSpare_2064":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_704:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_715:
        return self.rule.variation

class Item_1168(Item):
    cv_arg: TypeAlias = NonSpare_2064.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2064

    @classmethod
    def create(cls, arg : "Item_1168.cv_arg") -> "Item_1168":
        return cls._create(arg) # type: ignore

class NonSpare_1794(NonSpare):
    cv_arg: TypeAlias = RuleVariation_807.cv_arg
    cv_name = "STOCC"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_807

    @classmethod
    def create(cls, arg : "NonSpare_1794.cv_arg") -> "NonSpare_1794":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_807:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_837:
        return self.rule.variation

class Item_954(Item):
    cv_arg: TypeAlias = NonSpare_1794.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1794

    @classmethod
    def create(cls, arg : "Item_954.cv_arg") -> "Item_954":
        return cls._create(arg) # type: ignore

class NonSpare_1399(NonSpare):
    cv_arg: TypeAlias = RuleVariation_885.cv_arg
    cv_name = "ONGOING"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_885

    @classmethod
    def create(cls, arg : "NonSpare_1399.cv_arg") -> "NonSpare_1399":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_885:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_915:
        return self.rule.variation

class Item_658(Item):
    cv_arg: TypeAlias = NonSpare_1399.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1399

    @classmethod
    def create(cls, arg : "Item_658.cv_arg") -> "Item_658":
        return cls._create(arg) # type: ignore

class Variation_1371(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_32.cv_arg, Tuple[Literal["MRVA"], RuleVariation_32.cv_arg]], Union[RuleVariation_405.cv_arg, Tuple[Literal["RAMLD"], RuleVariation_405.cv_arg]], Union[RuleVariation_513.cv_arg, Tuple[Literal["RAMHD"], RuleVariation_513.cv_arg]], Union[RuleVariation_615.cv_arg, Tuple[Literal["MSAW"], RuleVariation_615.cv_arg]], Union[RuleVariation_694.cv_arg, Tuple[Literal["APW"], RuleVariation_694.cv_arg]], Union[RuleVariation_800.cv_arg, Tuple[Literal["CLAM"], RuleVariation_800.cv_arg]], Union[RuleVariation_889.cv_arg, Tuple[Literal["STCA"], RuleVariation_889.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_24.cv_arg, Tuple[Literal["APM"], RuleVariation_24.cv_arg]], Union[RuleVariation_406.cv_arg, Tuple[Literal["RIMCA"], RuleVariation_406.cv_arg]], Union[RuleVariation_503.cv_arg, Tuple[Literal["ACASRA"], RuleVariation_503.cv_arg]], Union[RuleVariation_620.cv_arg, Tuple[Literal["NTCA"], RuleVariation_620.cv_arg]], Union[RuleVariation_700.cv_arg, Tuple[Literal["DG"], RuleVariation_700.cv_arg]], Union[RuleVariation_804.cv_arg, Tuple[Literal["OF"], RuleVariation_804.cv_arg]], Union[RuleVariation_886.cv_arg, Tuple[Literal["OL"], RuleVariation_886.cv_arg]], None]]
    cv_arg_group_3: TypeAlias = Union[int, Tuple[Union[RuleVariation_23.cv_arg, Tuple[Literal["AIW"], RuleVariation_23.cv_arg]], Union[RuleVariation_404.cv_arg, Tuple[Literal["PAIW"], RuleVariation_404.cv_arg]], Union[RuleVariation_511.cv_arg, Tuple[Literal["OCAT"], RuleVariation_511.cv_arg]], Union[RuleVariation_621.cv_arg, Tuple[Literal["SAM"], RuleVariation_621.cv_arg]], Union[RuleVariation_701.cv_arg, Tuple[Literal["VCD"], RuleVariation_701.cv_arg]], Union[RuleVariation_799.cv_arg, Tuple[Literal["CHAM"], RuleVariation_799.cv_arg]], Union[RuleVariation_880.cv_arg, Tuple[Literal["DSAM"], RuleVariation_880.cv_arg]], None]]
    cv_arg_group_4: TypeAlias = Union[int, Tuple[Union[RuleVariation_27.cv_arg, Tuple[Literal["DBPSMARR"], RuleVariation_27.cv_arg]], Union[RuleVariation_395.cv_arg, Tuple[Literal["DBPSMDEP"], RuleVariation_395.cv_arg]], Union[RuleVariation_505.cv_arg, Tuple[Literal["DBPSMTL"], RuleVariation_505.cv_arg]], Union[RuleVariation_623.cv_arg, Tuple[Literal["VRAMCRM"], RuleVariation_623.cv_arg]], Union[RuleVariation_703.cv_arg, Tuple[Literal["VRAMVTM"], RuleVariation_703.cv_arg]], Union[RuleVariation_811.cv_arg, Tuple[Literal["VRAMVRM"], RuleVariation_811.cv_arg]], Union[RuleVariation_883.cv_arg, Tuple[Literal["HAMHD"], RuleVariation_883.cv_arg]], None]]
    cv_arg_group_5: TypeAlias = Union[int, Tuple[Union[RuleVariation_29.cv_arg, Tuple[Literal["HAMRD"], RuleVariation_29.cv_arg]], Union[RuleVariation_398.cv_arg, Tuple[Literal["HAMVD"], RuleVariation_398.cv_arg]], Union[RuleVariation_507.cv_arg, Tuple[Literal["HVI"], RuleVariation_507.cv_arg]], Union[RuleVariation_614.cv_arg, Tuple[Literal["LTW"], RuleVariation_614.cv_arg]], Union[RuleVariation_702.cv_arg, Tuple[Literal["VPM"], RuleVariation_702.cv_arg]], Union[RuleVariation_809.cv_arg, Tuple[Literal["TTA"], RuleVariation_809.cv_arg]], Union[RuleVariation_878.cv_arg, Tuple[Literal["CRA"], RuleVariation_878.cv_arg]], None]]
    cv_arg_group_6: TypeAlias = Union[int, Tuple[Union[RuleVariation_25.cv_arg, Tuple[Literal["ASM"], RuleVariation_25.cv_arg]], Union[RuleVariation_399.cv_arg, Tuple[Literal["IAVM"], RuleVariation_399.cv_arg]], Union[RuleVariation_506.cv_arg, Tuple[Literal["FTD"], RuleVariation_506.cv_arg]], Union[RuleVariation_612.cv_arg, Tuple[Literal["ITD"], RuleVariation_612.cv_arg]], Union[RuleVariation_696.cv_arg, Tuple[Literal["IIA"], RuleVariation_696.cv_arg]], Union[RuleVariation_806.cv_arg, Tuple[Literal["SQW"], RuleVariation_806.cv_arg]], Union[RuleVariation_879.cv_arg, Tuple[Literal["CUW"], RuleVariation_879.cv_arg]], None]]
    cv_arg_group_7: TypeAlias = Union[int, Tuple[Union[RuleVariation_26.cv_arg, Tuple[Literal["CATC"], RuleVariation_26.cv_arg]], Union[RuleVariation_403.cv_arg, Tuple[Literal["NOCLR"], RuleVariation_403.cv_arg]], Union[RuleVariation_510.cv_arg, Tuple[Literal["NOMOV"], RuleVariation_510.cv_arg]], Union[RuleVariation_619.cv_arg, Tuple[Literal["NOH"], RuleVariation_619.cv_arg]], Union[RuleVariation_704.cv_arg, Tuple[Literal["WRTY"], RuleVariation_704.cv_arg]], Union[RuleVariation_807.cv_arg, Tuple[Literal["STOCC"], RuleVariation_807.cv_arg]], Union[RuleVariation_885.cv_arg, Tuple[Literal["ONGOING"], RuleVariation_885.cv_arg]], None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1371.cv_arg_group_1"],
        Tuple["Variation_1371.cv_arg_group_1", "Variation_1371.cv_arg_group_2"],
        Tuple["Variation_1371.cv_arg_group_1", "Variation_1371.cv_arg_group_2", "Variation_1371.cv_arg_group_3"],
        Tuple["Variation_1371.cv_arg_group_1", "Variation_1371.cv_arg_group_2", "Variation_1371.cv_arg_group_3", "Variation_1371.cv_arg_group_4"],
        Tuple["Variation_1371.cv_arg_group_1", "Variation_1371.cv_arg_group_2", "Variation_1371.cv_arg_group_3", "Variation_1371.cv_arg_group_4", "Variation_1371.cv_arg_group_5"],
        Tuple["Variation_1371.cv_arg_group_1", "Variation_1371.cv_arg_group_2", "Variation_1371.cv_arg_group_3", "Variation_1371.cv_arg_group_4", "Variation_1371.cv_arg_group_5", "Variation_1371.cv_arg_group_6"],
        Tuple["Variation_1371.cv_arg_group_1", "Variation_1371.cv_arg_group_2", "Variation_1371.cv_arg_group_3", "Variation_1371.cv_arg_group_4", "Variation_1371.cv_arg_group_5", "Variation_1371.cv_arg_group_6", "Variation_1371.cv_arg_group_7"],
    ]
    cv_items_list = [[(Item_584, 1), (Item_777, 1), (Item_776, 1), (Item_587, 1), (Item_78, 1), (Item_162, 1), (Item_948, 1), None], [(Item_77, 1), (Item_822, 1), (Item_40, 1), (Item_640, 1), (Item_260, 1), (Item_655, 1), (Item_656, 1), None], [(Item_56, 1), (Item_678, 1), (Item_649, 1), (Item_859, 1), (Item_1138, 1), (Item_155, 1), (Item_276, 1), None], [(Item_243, 1), (Item_245, 1), (Item_247, 1), (Item_1149, 1), (Item_1152, 1), (Item_1151, 1), (Item_382, 1), None], [(Item_384, 1), (Item_386, 1), (Item_407, 1), (Item_510, 1), (Item_1147, 1), (Item_1061, 1), (Item_214, 1), None], [(Item_87, 1), (Item_423, 1), (Item_351, 1), (Item_441, 1), (Item_434, 1), (Item_917, 1), (Item_232, 1), None], [(Item_137, 1), (Item_623, 1), (Item_636, 1), (Item_631, 1), (Item_1168, 1), (Item_954, 1), (Item_658, 1), None]]

    @classmethod
    def create(cls, arg: "Variation_1371.cv_arg") -> 'Variation_1371':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["MRVA"]) -> RuleVariation_32:
        ...
    @overload
    def get_item(self, key : Literal["RAMLD"]) -> RuleVariation_405:
        ...
    @overload
    def get_item(self, key : Literal["RAMHD"]) -> RuleVariation_513:
        ...
    @overload
    def get_item(self, key : Literal["MSAW"]) -> RuleVariation_615:
        ...
    @overload
    def get_item(self, key : Literal["APW"]) -> RuleVariation_694:
        ...
    @overload
    def get_item(self, key : Literal["CLAM"]) -> RuleVariation_800:
        ...
    @overload
    def get_item(self, key : Literal["STCA"]) -> RuleVariation_889:
        ...
    @overload
    def get_item(self, key : Literal["APM"]) -> Optional[RuleVariation_24]:
        ...
    @overload
    def get_item(self, key : Literal["RIMCA"]) -> Optional[RuleVariation_406]:
        ...
    @overload
    def get_item(self, key : Literal["ACASRA"]) -> Optional[RuleVariation_503]:
        ...
    @overload
    def get_item(self, key : Literal["NTCA"]) -> Optional[RuleVariation_620]:
        ...
    @overload
    def get_item(self, key : Literal["DG"]) -> Optional[RuleVariation_700]:
        ...
    @overload
    def get_item(self, key : Literal["OF"]) -> Optional[RuleVariation_804]:
        ...
    @overload
    def get_item(self, key : Literal["OL"]) -> Optional[RuleVariation_886]:
        ...
    @overload
    def get_item(self, key : Literal["AIW"]) -> Optional[RuleVariation_23]:
        ...
    @overload
    def get_item(self, key : Literal["PAIW"]) -> Optional[RuleVariation_404]:
        ...
    @overload
    def get_item(self, key : Literal["OCAT"]) -> Optional[RuleVariation_511]:
        ...
    @overload
    def get_item(self, key : Literal["SAM"]) -> Optional[RuleVariation_621]:
        ...
    @overload
    def get_item(self, key : Literal["VCD"]) -> Optional[RuleVariation_701]:
        ...
    @overload
    def get_item(self, key : Literal["CHAM"]) -> Optional[RuleVariation_799]:
        ...
    @overload
    def get_item(self, key : Literal["DSAM"]) -> Optional[RuleVariation_880]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMARR"]) -> Optional[RuleVariation_27]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMDEP"]) -> Optional[RuleVariation_395]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMTL"]) -> Optional[RuleVariation_505]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMCRM"]) -> Optional[RuleVariation_623]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMVTM"]) -> Optional[RuleVariation_703]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMVRM"]) -> Optional[RuleVariation_811]:
        ...
    @overload
    def get_item(self, key : Literal["HAMHD"]) -> Optional[RuleVariation_883]:
        ...
    @overload
    def get_item(self, key : Literal["HAMRD"]) -> Optional[RuleVariation_29]:
        ...
    @overload
    def get_item(self, key : Literal["HAMVD"]) -> Optional[RuleVariation_398]:
        ...
    @overload
    def get_item(self, key : Literal["HVI"]) -> Optional[RuleVariation_507]:
        ...
    @overload
    def get_item(self, key : Literal["LTW"]) -> Optional[RuleVariation_614]:
        ...
    @overload
    def get_item(self, key : Literal["VPM"]) -> Optional[RuleVariation_702]:
        ...
    @overload
    def get_item(self, key : Literal["TTA"]) -> Optional[RuleVariation_809]:
        ...
    @overload
    def get_item(self, key : Literal["CRA"]) -> Optional[RuleVariation_878]:
        ...
    @overload
    def get_item(self, key : Literal["ASM"]) -> Optional[RuleVariation_25]:
        ...
    @overload
    def get_item(self, key : Literal["IAVM"]) -> Optional[RuleVariation_399]:
        ...
    @overload
    def get_item(self, key : Literal["FTD"]) -> Optional[RuleVariation_506]:
        ...
    @overload
    def get_item(self, key : Literal["ITD"]) -> Optional[RuleVariation_612]:
        ...
    @overload
    def get_item(self, key : Literal["IIA"]) -> Optional[RuleVariation_696]:
        ...
    @overload
    def get_item(self, key : Literal["SQW"]) -> Optional[RuleVariation_806]:
        ...
    @overload
    def get_item(self, key : Literal["CUW"]) -> Optional[RuleVariation_879]:
        ...
    @overload
    def get_item(self, key : Literal["CATC"]) -> Optional[RuleVariation_26]:
        ...
    @overload
    def get_item(self, key : Literal["NOCLR"]) -> Optional[RuleVariation_403]:
        ...
    @overload
    def get_item(self, key : Literal["NOMOV"]) -> Optional[RuleVariation_510]:
        ...
    @overload
    def get_item(self, key : Literal["NOH"]) -> Optional[RuleVariation_619]:
        ...
    @overload
    def get_item(self, key : Literal["WRTY"]) -> Optional[RuleVariation_704]:
        ...
    @overload
    def get_item(self, key : Literal["STOCC"]) -> Optional[RuleVariation_807]:
        ...
    @overload
    def get_item(self, key : Literal["ONGOING"]) -> Optional[RuleVariation_885]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1292(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1371.cv_arg
    cv_variation: TypeAlias = Variation_1371

    @classmethod
    def create(cls, arg : "RuleVariation_1292.cv_arg") -> "RuleVariation_1292":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1371:
        return self.arg # type: ignore

class NonSpare_195(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1292.cv_arg
    cv_name = "060"
    cv_title = "Safety Net Function and System Status"
    cv_rule: TypeAlias = RuleVariation_1292

    @classmethod
    def create(cls, arg : "NonSpare_195.cv_arg") -> "NonSpare_195":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1292:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1371:
        return self.rule.variation

class UapItem_195(UapItem):
    cv_non_spare: TypeAlias = NonSpare_195

class NonSpare_114(NonSpare):
    cv_arg: TypeAlias = RuleVariation_246.cv_arg
    cv_name = "030"
    cv_title = "Track Number 1"
    cv_rule: TypeAlias = RuleVariation_246

    @classmethod
    def create(cls, arg : "NonSpare_114.cv_arg") -> "NonSpare_114":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_246:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_253:
        return self.rule.variation

class UapItem_114(UapItem):
    cv_non_spare: TypeAlias = NonSpare_114

class Content_609(ContentString):
    cv_arg: TypeAlias = Union[int, str]
    cv_string_type: TypeAlias = StringAscii

class RuleContent_609(RuleContentContextFree):
    cv_arg: TypeAlias = Content_609.cv_arg
    cv_content: TypeAlias = Content_609

    @property
    def content(self) -> Content_609:
        return self._get_content() # type: ignore

class Variation_393(Element):
    cv_arg: TypeAlias = RuleContent_609.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 56
    cv_rule = RuleContent_609

    @classmethod
    def create(cls, arg: "Variation_393.cv_arg") -> "Variation_393":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_609:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_609:
        return self.rule.content

class RuleVariation_385(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_393.cv_arg
    cv_variation: TypeAlias = Variation_393

    @classmethod
    def create(cls, arg : "RuleVariation_385.cv_arg") -> "RuleVariation_385":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_393:
        return self.arg # type: ignore

class NonSpare_586(NonSpare):
    cv_arg: TypeAlias = RuleVariation_385.cv_arg
    cv_name = "AI1"
    cv_title = "Aircraft Identifier (in 7 Characters) of Aircraft 1 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_385

    @classmethod
    def create(cls, arg : "NonSpare_586.cv_arg") -> "NonSpare_586":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_385:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_393:
        return self.rule.variation

class NonSpare_1307(NonSpare):
    cv_arg: TypeAlias = RuleVariation_779.cv_arg
    cv_name = "MODE3A"
    cv_title = "Mode-3/A Code (Converted Into Octal Representation) of Aircraft 1 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_779

    @classmethod
    def create(cls, arg : "NonSpare_1307.cv_arg") -> "NonSpare_1307":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_779:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_809:
        return self.rule.variation

class Item_573(Item):
    cv_arg: TypeAlias = NonSpare_1307.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1307

    @classmethod
    def create(cls, arg : "Item_573.cv_arg") -> "Item_573":
        return cls._create(arg) # type: ignore

class Variation_1027(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_779.cv_arg, Tuple[Literal["MODE3A"], RuleVariation_779.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1027.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_3, 4), (Item_573, 12)]
    cv_items_dict = {"MODE3A": RuleVariation_779}

    @classmethod
    def spec(cls, key : Literal["MODE3A"]) -> RuleVariation_779:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["MODE3A"]) -> RuleVariation_779:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1027.cv_arg") -> 'Variation_1027':
        return cls._create(arg) # type: ignore

class RuleVariation_996(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1027.cv_arg
    cv_variation: TypeAlias = Variation_1027

    @classmethod
    def create(cls, arg : "RuleVariation_996.cv_arg") -> "RuleVariation_996":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1027:
        return self.arg # type: ignore

class NonSpare_1214(NonSpare):
    cv_arg: TypeAlias = RuleVariation_996.cv_arg
    cv_name = "M31"
    cv_title = "Mode 3/A Code Aircraft 1"
    cv_rule: TypeAlias = RuleVariation_996

    @classmethod
    def create(cls, arg : "NonSpare_1214.cv_arg") -> "NonSpare_1214":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_996:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1027:
        return self.rule.variation

class Content_699(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 5.364418029785156e-6
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_699(RuleContentContextFree):
    cv_arg: TypeAlias = Content_699.cv_arg
    cv_content: TypeAlias = Content_699

    @property
    def content(self) -> Content_699:
        return self._get_content() # type: ignore

class Variation_378(Element):
    cv_arg: TypeAlias = RuleContent_699.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_rule = RuleContent_699

    @classmethod
    def create(cls, arg: "Variation_378.cv_arg") -> "Variation_378":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_699:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_699:
        return self.rule.content

class RuleVariation_371(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_378.cv_arg
    cv_variation: TypeAlias = Variation_378

    @classmethod
    def create(cls, arg : "RuleVariation_371.cv_arg") -> "RuleVariation_371":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_378:
        return self.arg # type: ignore

class NonSpare_1159(NonSpare):
    cv_arg: TypeAlias = RuleVariation_371.cv_arg
    cv_name = "LAT"
    cv_title = "Latitude in WGS-84 in Two’s Complement"
    cv_rule: TypeAlias = RuleVariation_371

    @classmethod
    def create(cls, arg : "NonSpare_1159.cv_arg") -> "NonSpare_1159":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_371:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_378:
        return self.rule.variation

class Item_471(Item):
    cv_arg: TypeAlias = NonSpare_1159.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1159

    @classmethod
    def create(cls, arg : "Item_471.cv_arg") -> "Item_471":
        return cls._create(arg) # type: ignore

class Content_698(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 5.364418029785156e-6
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_698(RuleContentContextFree):
    cv_arg: TypeAlias = Content_698.cv_arg
    cv_content: TypeAlias = Content_698

    @property
    def content(self) -> Content_698:
        return self._get_content() # type: ignore

class Variation_377(Element):
    cv_arg: TypeAlias = RuleContent_698.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_rule = RuleContent_698

    @classmethod
    def create(cls, arg: "Variation_377.cv_arg") -> "Variation_377":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_698:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_698:
        return self.rule.content

class RuleVariation_370(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_377.cv_arg
    cv_variation: TypeAlias = Variation_377

    @classmethod
    def create(cls, arg : "RuleVariation_370.cv_arg") -> "RuleVariation_370":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_377:
        return self.arg # type: ignore

class NonSpare_1189(NonSpare):
    cv_arg: TypeAlias = RuleVariation_370.cv_arg
    cv_name = "LON"
    cv_title = "Longitude in WGS-84 in Two’s Complement"
    cv_rule: TypeAlias = RuleVariation_370

    @classmethod
    def create(cls, arg : "NonSpare_1189.cv_arg") -> "NonSpare_1189":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_370:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_377:
        return self.rule.variation

class Item_499(Item):
    cv_arg: TypeAlias = NonSpare_1189.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1189

    @classmethod
    def create(cls, arg : "Item_499.cv_arg") -> "Item_499":
        return cls._create(arg) # type: ignore

class Content_634(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["ft"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 25.0
    cv_unit = "ft"

    def as_quantity(self, cv_unit : Optional[Literal["ft"]] = None) -> float:
        return self._as_quantity()

class RuleContent_634(RuleContentContextFree):
    cv_arg: TypeAlias = Content_634.cv_arg
    cv_content: TypeAlias = Content_634

    @property
    def content(self) -> Content_634:
        return self._get_content() # type: ignore

class Variation_263(Element):
    cv_arg: TypeAlias = RuleContent_634.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_634

    @classmethod
    def create(cls, arg: "Variation_263.cv_arg") -> "Variation_263":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_634:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_634:
        return self.rule.content

class RuleVariation_256(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_263.cv_arg
    cv_variation: TypeAlias = Variation_263

    @classmethod
    def create(cls, arg : "RuleVariation_256.cv_arg") -> "RuleVariation_256":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_263:
        return self.arg # type: ignore

class NonSpare_596(NonSpare):
    cv_arg: TypeAlias = RuleVariation_256.cv_arg
    cv_name = "ALT"
    cv_title = "Altitude of Predicted Conflict"
    cv_rule: TypeAlias = RuleVariation_256

    @classmethod
    def create(cls, arg : "NonSpare_596.cv_arg") -> "NonSpare_596":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_256:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_263:
        return self.rule.variation

class Item_63(Item):
    cv_arg: TypeAlias = NonSpare_596.cv_arg
    cv_non_spare: TypeAlias = NonSpare_596

    @classmethod
    def create(cls, arg : "Item_63.cv_arg") -> "Item_63":
        return cls._create(arg) # type: ignore

class Variation_1135(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_371.cv_arg, Tuple[Literal["LAT"], RuleVariation_371.cv_arg]], Union[RuleVariation_370.cv_arg, Tuple[Literal["LON"], RuleVariation_370.cv_arg]], Union[RuleVariation_256.cv_arg, Tuple[Literal["ALT"], RuleVariation_256.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1135.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 80
    cv_items_list = [(Item_471, 32), (Item_499, 32), (Item_63, 16)]
    cv_items_dict = {"LAT": RuleVariation_371, "LON": RuleVariation_370, "ALT": RuleVariation_256}

    @overload
    @classmethod
    def spec(cls, key : Literal["LAT"]) -> RuleVariation_371:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["LON"]) -> RuleVariation_370:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ALT"]) -> RuleVariation_256:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["LAT"], Literal["LON"], Literal["ALT"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["LAT"]) -> RuleVariation_371:
        ...
    @overload
    def get_item(self, key : Literal["LON"]) -> RuleVariation_370:
        ...
    @overload
    def get_item(self, key : Literal["ALT"]) -> RuleVariation_256:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1135.cv_arg") -> 'Variation_1135':
        return cls._create(arg) # type: ignore

class RuleVariation_1091(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1135.cv_arg
    cv_variation: TypeAlias = Variation_1135

    @classmethod
    def create(cls, arg : "RuleVariation_1091.cv_arg") -> "RuleVariation_1091":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1135:
        return self.arg # type: ignore

class NonSpare_824(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1091.cv_arg
    cv_name = "CPW"
    cv_title = "Predicted Conflict Position Target 1 in WGS-84 Coordinates"
    cv_rule: TypeAlias = RuleVariation_1091

    @classmethod
    def create(cls, arg : "NonSpare_824.cv_arg") -> "NonSpare_824":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1091:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1135:
        return self.rule.variation

class Content_639(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.5
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_639(RuleContentContextFree):
    cv_arg: TypeAlias = Content_639.cv_arg
    cv_content: TypeAlias = Content_639

    @property
    def content(self) -> Content_639:
        return self._get_content() # type: ignore

class Variation_352(Element):
    cv_arg: TypeAlias = RuleContent_639.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_rule = RuleContent_639

    @classmethod
    def create(cls, arg: "Variation_352.cv_arg") -> "Variation_352":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_639:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_639:
        return self.rule.content

class RuleVariation_345(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_352.cv_arg
    cv_variation: TypeAlias = Variation_352

    @classmethod
    def create(cls, arg : "RuleVariation_345.cv_arg") -> "RuleVariation_345":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_352:
        return self.arg # type: ignore

class NonSpare_2093(NonSpare):
    cv_arg: TypeAlias = RuleVariation_345.cv_arg
    cv_name = "X"
    cv_title = "Starting X-position of the Conflict"
    cv_rule: TypeAlias = RuleVariation_345

    @classmethod
    def create(cls, arg : "NonSpare_2093.cv_arg") -> "NonSpare_2093":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_345:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_352:
        return self.rule.variation

class Item_1194(Item):
    cv_arg: TypeAlias = NonSpare_2093.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2093

    @classmethod
    def create(cls, arg : "Item_1194.cv_arg") -> "Item_1194":
        return cls._create(arg) # type: ignore

class NonSpare_2146(NonSpare):
    cv_arg: TypeAlias = RuleVariation_345.cv_arg
    cv_name = "Y"
    cv_title = "Starting Y-position of the Conflict"
    cv_rule: TypeAlias = RuleVariation_345

    @classmethod
    def create(cls, arg : "NonSpare_2146.cv_arg") -> "NonSpare_2146":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_345:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_352:
        return self.rule.variation

class Item_1244(Item):
    cv_arg: TypeAlias = NonSpare_2146.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2146

    @classmethod
    def create(cls, arg : "Item_1244.cv_arg") -> "Item_1244":
        return cls._create(arg) # type: ignore

class NonSpare_2164(NonSpare):
    cv_arg: TypeAlias = RuleVariation_256.cv_arg
    cv_name = "Z"
    cv_title = "Starting Z-position of the Conflict"
    cv_rule: TypeAlias = RuleVariation_256

    @classmethod
    def create(cls, arg : "NonSpare_2164.cv_arg") -> "NonSpare_2164":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_256:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_263:
        return self.rule.variation

class Item_1262(Item):
    cv_arg: TypeAlias = NonSpare_2164.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2164

    @classmethod
    def create(cls, arg : "Item_1262.cv_arg") -> "Item_1262":
        return cls._create(arg) # type: ignore

class Variation_1307(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_345.cv_arg, Tuple[Literal["X"], RuleVariation_345.cv_arg]], Union[RuleVariation_345.cv_arg, Tuple[Literal["Y"], RuleVariation_345.cv_arg]], Union[RuleVariation_256.cv_arg, Tuple[Literal["Z"], RuleVariation_256.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1307.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 64
    cv_items_list = [(Item_1194, 24), (Item_1244, 24), (Item_1262, 16)]
    cv_items_dict = {"X": RuleVariation_345, "Y": RuleVariation_345, "Z": RuleVariation_256}

    @overload
    @classmethod
    def spec(cls, key : Literal["X"]) -> RuleVariation_345:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y"]) -> RuleVariation_345:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Z"]) -> RuleVariation_256:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X"], Literal["Y"], Literal["Z"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X"]) -> RuleVariation_345:
        ...
    @overload
    def get_item(self, key : Literal["Y"]) -> RuleVariation_345:
        ...
    @overload
    def get_item(self, key : Literal["Z"]) -> RuleVariation_256:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1307.cv_arg") -> 'Variation_1307':
        return cls._create(arg) # type: ignore

class RuleVariation_1236(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1307.cv_arg
    cv_variation: TypeAlias = Variation_1307

    @classmethod
    def create(cls, arg : "RuleVariation_1236.cv_arg") -> "RuleVariation_1236":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1307:
        return self.arg # type: ignore

class NonSpare_819(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1236.cv_arg
    cv_name = "CPC"
    cv_title = "Predicted Conflict Position for the Aircraft 1 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_1236

    @classmethod
    def create(cls, arg : "NonSpare_819.cv_arg") -> "NonSpare_819":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1236:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1307:
        return self.rule.variation

class NonSpare_1944(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "TT1"
    cv_title = "Time to Runway Threshold for First Approaching Aircraft in a RIMCA"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_1944.cv_arg") -> "NonSpare_1944":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class Content_732(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 0.5
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_732(RuleContentContextFree):
    cv_arg: TypeAlias = Content_732.cv_arg
    cv_content: TypeAlias = Content_732

    @property
    def content(self) -> Content_732:
        return self._get_content() # type: ignore

class Variation_311(Element):
    cv_arg: TypeAlias = RuleContent_732.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_732

    @classmethod
    def create(cls, arg: "Variation_311.cv_arg") -> "Variation_311":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_732:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_732:
        return self.rule.content

class RuleVariation_304(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_311.cv_arg
    cv_variation: TypeAlias = Variation_311

    @classmethod
    def create(cls, arg : "RuleVariation_304.cv_arg") -> "RuleVariation_304":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_311:
        return self.arg # type: ignore

class NonSpare_905(NonSpare):
    cv_arg: TypeAlias = RuleVariation_304.cv_arg
    cv_name = "DT1"
    cv_title = "Distance to Runway Threshold for Aircraft 1 Involved in a RIMCA"
    cv_rule: TypeAlias = RuleVariation_304

    @classmethod
    def create(cls, arg : "NonSpare_905.cv_arg") -> "NonSpare_905":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_304:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_311:
        return self.rule.variation

class Content_548(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Unknown", 1: "General Air Traffic", 2: "Operational Air Traffic", 3: "Not applicable"}

class RuleContent_548(RuleContentContextFree):
    cv_arg: TypeAlias = Content_548.cv_arg
    cv_content: TypeAlias = Content_548

    @property
    def content(self) -> Content_548:
        return self._get_content() # type: ignore

class Variation_116(Element):
    cv_arg: TypeAlias = RuleContent_548.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 2
    cv_rule = RuleContent_548

    @classmethod
    def create(cls, arg: "Variation_116.cv_arg") -> "Variation_116":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_548:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_548:
        return self.rule.content

class RuleVariation_116(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_116.cv_arg
    cv_variation: TypeAlias = Variation_116

    @classmethod
    def create(cls, arg : "RuleVariation_116.cv_arg") -> "RuleVariation_116":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_116:
        return self.arg # type: ignore

class Content_246(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Instrument Flight Rules", 1: "Visual Flight rules", 2: "Not applicable", 3: "Controlled Visual Flight Rules"}

class RuleContent_246(RuleContentContextFree):
    cv_arg: TypeAlias = Content_246.cv_arg
    cv_content: TypeAlias = Content_246

    @property
    def content(self) -> Content_246:
        return self._get_content() # type: ignore

class Variation_592(Element):
    cv_arg: TypeAlias = RuleContent_246.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 2
    cv_rule = RuleContent_246

    @classmethod
    def create(cls, arg: "Variation_592.cv_arg") -> "Variation_592":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_246:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_246:
        return self.rule.content

class RuleVariation_581(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_592.cv_arg
    cv_variation: TypeAlias = Variation_592

    @classmethod
    def create(cls, arg : "RuleVariation_581.cv_arg") -> "RuleVariation_581":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_592:
        return self.arg # type: ignore

class Content_541(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Unknown", 1: "Approved", 2: "Exempt", 3: "Not Approved"}

class RuleContent_541(RuleContentContextFree):
    cv_arg: TypeAlias = Content_541.cv_arg
    cv_content: TypeAlias = Content_541

    @property
    def content(self) -> Content_541:
        return self._get_content() # type: ignore

class Variation_769(Element):
    cv_arg: TypeAlias = RuleContent_541.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 2
    cv_rule = RuleContent_541

    @classmethod
    def create(cls, arg: "Variation_769.cv_arg") -> "Variation_769":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_541:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_541:
        return self.rule.content

class RuleVariation_758(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_769.cv_arg
    cv_variation: TypeAlias = Variation_769

    @classmethod
    def create(cls, arg : "RuleVariation_758.cv_arg") -> "RuleVariation_758":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_769:
        return self.arg # type: ignore

class Content_383(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Normal Priority Flight", 1: "High Priority Flight"}

class RuleContent_383(RuleContentContextFree):
    cv_arg: TypeAlias = Content_383.cv_arg
    cv_content: TypeAlias = Content_383

    @property
    def content(self) -> Content_383:
        return self._get_content() # type: ignore

class Variation_942(Element):
    cv_arg: TypeAlias = RuleContent_383.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_383

    @classmethod
    def create(cls, arg: "Variation_942.cv_arg") -> "Variation_942":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_383:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_383:
        return self.rule.content

class RuleVariation_912(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_942.cv_arg
    cv_variation: TypeAlias = Variation_942

    @classmethod
    def create(cls, arg : "RuleVariation_912.cv_arg") -> "RuleVariation_912":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_942:
        return self.arg # type: ignore

class Content_263(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Maintaining", 1: "Climbing", 2: "Descending", 3: "Invalid"}

class RuleContent_263(RuleContentContextFree):
    cv_arg: TypeAlias = Content_263.cv_arg
    cv_content: TypeAlias = Content_263

    @property
    def content(self) -> Content_263:
        return self._get_content() # type: ignore

class Variation_104(Element):
    cv_arg: TypeAlias = RuleContent_263.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 2
    cv_rule = RuleContent_263

    @classmethod
    def create(cls, arg: "Variation_104.cv_arg") -> "Variation_104":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_263:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_263:
        return self.rule.content

class RuleVariation_104(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_104.cv_arg
    cv_variation: TypeAlias = Variation_104

    @classmethod
    def create(cls, arg : "RuleVariation_104.cv_arg") -> "RuleVariation_104":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_104:
        return self.arg # type: ignore

class Content_378(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Non primary target", 1: "Primary target"}

class RuleContent_378(RuleContentContextFree):
    cv_arg: TypeAlias = Content_378.cv_arg
    cv_content: TypeAlias = Content_378

    @property
    def content(self) -> Content_378:
        return self._get_content() # type: ignore

class Variation_565(Element):
    cv_arg: TypeAlias = RuleContent_378.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_378

    @classmethod
    def create(cls, arg: "Variation_565.cv_arg") -> "Variation_565":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_378:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_378:
        return self.rule.content

class RuleVariation_554(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_565.cv_arg
    cv_variation: TypeAlias = Variation_565

    @classmethod
    def create(cls, arg : "RuleVariation_554.cv_arg") -> "RuleVariation_554":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_565:
        return self.arg # type: ignore

class Content_100(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Ground Vehicle"}

class RuleContent_100(RuleContentContextFree):
    cv_arg: TypeAlias = Content_100.cv_arg
    cv_content: TypeAlias = Content_100

    @property
    def content(self) -> Content_100:
        return self._get_content() # type: ignore

class Variation_622(Element):
    cv_arg: TypeAlias = RuleContent_100.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_100

    @classmethod
    def create(cls, arg: "Variation_622.cv_arg") -> "Variation_622":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_100:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_100:
        return self.rule.content

class RuleVariation_611(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_622.cv_arg
    cv_variation: TypeAlias = Variation_622

    @classmethod
    def create(cls, arg : "RuleVariation_611.cv_arg") -> "RuleVariation_611":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_622:
        return self.arg # type: ignore

class NonSpare_1026(NonSpare):
    cv_arg: TypeAlias = RuleVariation_116.cv_arg
    cv_name = "GATOAT"
    cv_title = "Identification of Conflict Categories Definition Table"
    cv_rule: TypeAlias = RuleVariation_116

    @classmethod
    def create(cls, arg : "NonSpare_1026.cv_arg") -> "NonSpare_1026":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_116:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_116:
        return self.rule.variation

class Item_364(Item):
    cv_arg: TypeAlias = NonSpare_1026.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1026

    @classmethod
    def create(cls, arg : "Item_364.cv_arg") -> "Item_364":
        return cls._create(arg) # type: ignore

class NonSpare_995(NonSpare):
    cv_arg: TypeAlias = RuleVariation_581.cv_arg
    cv_name = "FR1FR2"
    cv_title = "Flight Rules"
    cv_rule: TypeAlias = RuleVariation_581

    @classmethod
    def create(cls, arg : "NonSpare_995.cv_arg") -> "NonSpare_995":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_581:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_592:
        return self.rule.variation

class Item_344(Item):
    cv_arg: TypeAlias = NonSpare_995.cv_arg
    cv_non_spare: TypeAlias = NonSpare_995

    @classmethod
    def create(cls, arg : "Item_344.cv_arg") -> "Item_344":
        return cls._create(arg) # type: ignore

class NonSpare_1638(NonSpare):
    cv_arg: TypeAlias = RuleVariation_758.cv_arg
    cv_name = "RVSM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_758

    @classmethod
    def create(cls, arg : "NonSpare_1638.cv_arg") -> "NonSpare_1638":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_758:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_769:
        return self.rule.variation

class Item_843(Item):
    cv_arg: TypeAlias = NonSpare_1638.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1638

    @classmethod
    def create(cls, arg : "Item_843.cv_arg") -> "Item_843":
        return cls._create(arg) # type: ignore

class NonSpare_1077(NonSpare):
    cv_arg: TypeAlias = RuleVariation_912.cv_arg
    cv_name = "HPR"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_912

    @classmethod
    def create(cls, arg : "NonSpare_1077.cv_arg") -> "NonSpare_1077":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_912:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_942:
        return self.rule.variation

class Item_401(Item):
    cv_arg: TypeAlias = NonSpare_1077.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1077

    @classmethod
    def create(cls, arg : "Item_401.cv_arg") -> "Item_401":
        return cls._create(arg) # type: ignore

class NonSpare_716(NonSpare):
    cv_arg: TypeAlias = RuleVariation_104.cv_arg
    cv_name = "CDM"
    cv_title = "Climbing/Descending Mode"
    cv_rule: TypeAlias = RuleVariation_104

    @classmethod
    def create(cls, arg : "NonSpare_716.cv_arg") -> "NonSpare_716":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_104:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_104:
        return self.rule.variation

class Item_142(Item):
    cv_arg: TypeAlias = NonSpare_716.cv_arg
    cv_non_spare: TypeAlias = NonSpare_716

    @classmethod
    def create(cls, arg : "Item_142.cv_arg") -> "Item_142":
        return cls._create(arg) # type: ignore

class NonSpare_1465(NonSpare):
    cv_arg: TypeAlias = RuleVariation_554.cv_arg
    cv_name = "PRI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_554

    @classmethod
    def create(cls, arg : "NonSpare_1465.cv_arg") -> "NonSpare_1465":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_554:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_565:
        return self.rule.variation

class Item_708(Item):
    cv_arg: TypeAlias = NonSpare_1465.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1465

    @classmethod
    def create(cls, arg : "Item_708.cv_arg") -> "Item_708":
        return cls._create(arg) # type: ignore

class NonSpare_1046(NonSpare):
    cv_arg: TypeAlias = RuleVariation_611.cv_arg
    cv_name = "GV"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_611

    @classmethod
    def create(cls, arg : "NonSpare_1046.cv_arg") -> "NonSpare_1046":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_611:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_622:
        return self.rule.variation

class Item_379(Item):
    cv_arg: TypeAlias = NonSpare_1046.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1046

    @classmethod
    def create(cls, arg : "Item_379.cv_arg") -> "Item_379":
        return cls._create(arg) # type: ignore

class Item_21(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 4
    cv_bit_size = 3

class Variation_1362(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_116.cv_arg, Tuple[Literal["GATOAT"], RuleVariation_116.cv_arg]], Union[RuleVariation_581.cv_arg, Tuple[Literal["FR1FR2"], RuleVariation_581.cv_arg]], Union[RuleVariation_758.cv_arg, Tuple[Literal["RVSM"], RuleVariation_758.cv_arg]], Union[RuleVariation_912.cv_arg, Tuple[Literal["HPR"], RuleVariation_912.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_104.cv_arg, Tuple[Literal["CDM"], RuleVariation_104.cv_arg]], Union[RuleVariation_554.cv_arg, Tuple[Literal["PRI"], RuleVariation_554.cv_arg]], Union[RuleVariation_611.cv_arg, Tuple[Literal["GV"], RuleVariation_611.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1362.cv_arg_group_1"],
        Tuple["Variation_1362.cv_arg_group_1", "Variation_1362.cv_arg_group_2"],
    ]
    cv_items_list = [[(Item_364, 2), (Item_344, 2), (Item_843, 2), (Item_401, 1), None], [(Item_142, 2), (Item_708, 1), (Item_379, 1), (Item_21, 3), None]]

    @classmethod
    def create(cls, arg: "Variation_1362.cv_arg") -> 'Variation_1362':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["GATOAT"]) -> RuleVariation_116:
        ...
    @overload
    def get_item(self, key : Literal["FR1FR2"]) -> RuleVariation_581:
        ...
    @overload
    def get_item(self, key : Literal["RVSM"]) -> RuleVariation_758:
        ...
    @overload
    def get_item(self, key : Literal["HPR"]) -> RuleVariation_912:
        ...
    @overload
    def get_item(self, key : Literal["CDM"]) -> Optional[RuleVariation_104]:
        ...
    @overload
    def get_item(self, key : Literal["PRI"]) -> Optional[RuleVariation_554]:
        ...
    @overload
    def get_item(self, key : Literal["GV"]) -> Optional[RuleVariation_611]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1283(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1362.cv_arg
    cv_variation: TypeAlias = Variation_1362

    @classmethod
    def create(cls, arg : "RuleVariation_1283.cv_arg") -> "RuleVariation_1283":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1362:
        return self.arg # type: ignore

class NonSpare_558(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1283.cv_arg
    cv_name = "AC1"
    cv_title = "Characteristics of Aircraft 1 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_1283

    @classmethod
    def create(cls, arg : "NonSpare_558.cv_arg") -> "NonSpare_558":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1283:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1362:
        return self.rule.variation

class Content_610(ContentString):
    cv_arg: TypeAlias = Union[int, str]
    cv_string_type: TypeAlias = StringICAO

class RuleContent_610(RuleContentContextFree):
    cv_arg: TypeAlias = Content_610.cv_arg
    cv_content: TypeAlias = Content_610

    @property
    def content(self) -> Content_610:
        return self._get_content() # type: ignore

class Variation_391(Element):
    cv_arg: TypeAlias = RuleContent_610.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 48
    cv_rule = RuleContent_610

    @classmethod
    def create(cls, arg: "Variation_391.cv_arg") -> "Variation_391":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_610:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_610:
        return self.rule.content

class RuleVariation_383(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_391.cv_arg
    cv_variation: TypeAlias = Variation_391

    @classmethod
    def create(cls, arg : "RuleVariation_383.cv_arg") -> "RuleVariation_383":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_391:
        return self.arg # type: ignore

class NonSpare_1321(NonSpare):
    cv_arg: TypeAlias = RuleVariation_383.cv_arg
    cv_name = "MS1"
    cv_title = "Aircraft Identification Downloaded from Aircraft 1 Involved in the Conflict If Equipped with a Mode-S Transponder"
    cv_rule: TypeAlias = RuleVariation_383

    @classmethod
    def create(cls, arg : "NonSpare_1321.cv_arg") -> "NonSpare_1321":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_391:
        return self.rule.variation

class Item_4(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 0
    cv_bit_size = 5

class Content_710(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal[""]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 1.0
    cv_unit = ""

    def as_quantity(self, cv_unit : Optional[Literal[""]] = None) -> float:
        return self._as_quantity()

class RuleContent_710(RuleContentContextFree):
    cv_arg: TypeAlias = Content_710.cv_arg
    cv_content: TypeAlias = Content_710

    @property
    def content(self) -> Content_710:
        return self._get_content() # type: ignore

class Variation_898(Element):
    cv_arg: TypeAlias = RuleContent_710.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 27
    cv_rule = RuleContent_710

    @classmethod
    def create(cls, arg: "Variation_898.cv_arg") -> "Variation_898":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_710:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_710:
        return self.rule.content

class RuleVariation_868(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_898.cv_arg
    cv_variation: TypeAlias = Variation_898

    @classmethod
    def create(cls, arg : "RuleVariation_868.cv_arg") -> "RuleVariation_868":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_898:
        return self.arg # type: ignore

class NonSpare_1352(NonSpare):
    cv_arg: TypeAlias = RuleVariation_868.cv_arg
    cv_name = "NBR"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_868

    @classmethod
    def create(cls, arg : "NonSpare_1352.cv_arg") -> "NonSpare_1352":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_868:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_898:
        return self.rule.variation

class Item_612(Item):
    cv_arg: TypeAlias = NonSpare_1352.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1352

    @classmethod
    def create(cls, arg : "Item_612.cv_arg") -> "Item_612":
        return cls._create(arg) # type: ignore

class Variation_1038(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_868.cv_arg, Tuple[Literal["NBR"], RuleVariation_868.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1038.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_4, 5), (Item_612, 27)]
    cv_items_dict = {"NBR": RuleVariation_868}

    @classmethod
    def spec(cls, key : Literal["NBR"]) -> RuleVariation_868:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["NBR"]) -> RuleVariation_868:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1038.cv_arg") -> 'Variation_1038':
        return cls._create(arg) # type: ignore

class RuleVariation_1006(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1038.cv_arg
    cv_variation: TypeAlias = Variation_1038

    @classmethod
    def create(cls, arg : "RuleVariation_1006.cv_arg") -> "RuleVariation_1006":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1038:
        return self.arg # type: ignore

class NonSpare_986(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1006.cv_arg
    cv_name = "FP1"
    cv_title = "Number of the Flight Plan Correlated to Aircraft 1 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_1006

    @classmethod
    def create(cls, arg : "NonSpare_986.cv_arg") -> "NonSpare_986":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1006:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1038:
        return self.rule.variation

class Content_752(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["FL"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 0.25
    cv_unit = "FL"

    def as_quantity(self, cv_unit : Optional[Literal["FL"]] = None) -> float:
        return self._as_quantity()

class RuleContent_751(RuleContentContextFree):
    cv_arg: TypeAlias = Content_752.cv_arg
    cv_content: TypeAlias = Content_752

    @property
    def content(self) -> Content_752:
        return self._get_content() # type: ignore

class Variation_321(Element):
    cv_arg: TypeAlias = RuleContent_751.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_751

    @classmethod
    def create(cls, arg: "Variation_321.cv_arg") -> "Variation_321":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_751:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_752:
        return self.rule.content

class RuleVariation_314(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_321.cv_arg
    cv_variation: TypeAlias = Variation_321

    @classmethod
    def create(cls, arg : "RuleVariation_314.cv_arg") -> "RuleVariation_314":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_321:
        return self.arg # type: ignore

class NonSpare_725(NonSpare):
    cv_arg: TypeAlias = RuleVariation_314.cv_arg
    cv_name = "CF1"
    cv_title = "Cleared Flight Level for Aircraft 1 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_314

    @classmethod
    def create(cls, arg : "NonSpare_725.cv_arg") -> "NonSpare_725":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_314:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_321:
        return self.rule.variation

class Variation_1469(Compound):
    cv_arg = TypedDict('cv_arg', {
        "AI1": NonSpare_586.cv_arg,
        "M31": NonSpare_1214.cv_arg,
        "CPW": NonSpare_824.cv_arg,
        "CPC": NonSpare_819.cv_arg,
        "TT1": NonSpare_1944.cv_arg,
        "DT1": NonSpare_905.cv_arg,
        "AC1": NonSpare_558.cv_arg,
        "MS1": NonSpare_1321.cv_arg,
        "FP1": NonSpare_986.cv_arg,
        "CF1": NonSpare_725.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 2
    cv_items_list = [NonSpare_586, NonSpare_1214, NonSpare_824, NonSpare_819, NonSpare_1944, NonSpare_905, NonSpare_558, NonSpare_1321, NonSpare_986, NonSpare_725]
    cv_items_dict = {"AI1": NonSpare_586, "M31": NonSpare_1214, "CPW": NonSpare_824, "CPC": NonSpare_819, "TT1": NonSpare_1944, "DT1": NonSpare_905, "AC1": NonSpare_558, "MS1": NonSpare_1321, "FP1": NonSpare_986, "CF1": NonSpare_725}

    @overload
    @classmethod
    def spec(cls, key : Literal["AI1"]) -> NonSpare_586:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["M31"]) -> NonSpare_1214:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPW"]) -> NonSpare_824:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPC"]) -> NonSpare_819:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TT1"]) -> NonSpare_1944:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["DT1"]) -> NonSpare_905:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AC1"]) -> NonSpare_558:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MS1"]) -> NonSpare_1321:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["FP1"]) -> NonSpare_986:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CF1"]) -> NonSpare_725:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["AI1"], Literal["M31"], Literal["CPW"], Literal["CPC"], Literal["TT1"], Literal["DT1"], Literal["AC1"], Literal["MS1"], Literal["FP1"], Literal["CF1"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["AI1"]) -> Optional[NonSpare_586]:
        ...
    @overload
    def get_item(self, key : Literal["M31"]) -> Optional[NonSpare_1214]:
        ...
    @overload
    def get_item(self, key : Literal["CPW"]) -> Optional[NonSpare_824]:
        ...
    @overload
    def get_item(self, key : Literal["CPC"]) -> Optional[NonSpare_819]:
        ...
    @overload
    def get_item(self, key : Literal["TT1"]) -> Optional[NonSpare_1944]:
        ...
    @overload
    def get_item(self, key : Literal["DT1"]) -> Optional[NonSpare_905]:
        ...
    @overload
    def get_item(self, key : Literal["AC1"]) -> Optional[NonSpare_558]:
        ...
    @overload
    def get_item(self, key : Literal["MS1"]) -> Optional[NonSpare_1321]:
        ...
    @overload
    def get_item(self, key : Literal["FP1"]) -> Optional[NonSpare_986]:
        ...
    @overload
    def get_item(self, key : Literal["CF1"]) -> Optional[NonSpare_725]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["AI1"], val : NonSpare_586.cv_arg) -> "Variation_1469":
        ...
    @overload
    def set_item(self, key : Literal["M31"], val : NonSpare_1214.cv_arg) -> "Variation_1469":
        ...
    @overload
    def set_item(self, key : Literal["CPW"], val : NonSpare_824.cv_arg) -> "Variation_1469":
        ...
    @overload
    def set_item(self, key : Literal["CPC"], val : NonSpare_819.cv_arg) -> "Variation_1469":
        ...
    @overload
    def set_item(self, key : Literal["TT1"], val : NonSpare_1944.cv_arg) -> "Variation_1469":
        ...
    @overload
    def set_item(self, key : Literal["DT1"], val : NonSpare_905.cv_arg) -> "Variation_1469":
        ...
    @overload
    def set_item(self, key : Literal["AC1"], val : NonSpare_558.cv_arg) -> "Variation_1469":
        ...
    @overload
    def set_item(self, key : Literal["MS1"], val : NonSpare_1321.cv_arg) -> "Variation_1469":
        ...
    @overload
    def set_item(self, key : Literal["FP1"], val : NonSpare_986.cv_arg) -> "Variation_1469":
        ...
    @overload
    def set_item(self, key : Literal["CF1"], val : NonSpare_725.cv_arg) -> "Variation_1469":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["AI1"]) -> "Variation_1469":
        ...
    @overload
    def del_item(self, key : Literal["M31"]) -> "Variation_1469":
        ...
    @overload
    def del_item(self, key : Literal["CPW"]) -> "Variation_1469":
        ...
    @overload
    def del_item(self, key : Literal["CPC"]) -> "Variation_1469":
        ...
    @overload
    def del_item(self, key : Literal["TT1"]) -> "Variation_1469":
        ...
    @overload
    def del_item(self, key : Literal["DT1"]) -> "Variation_1469":
        ...
    @overload
    def del_item(self, key : Literal["AC1"]) -> "Variation_1469":
        ...
    @overload
    def del_item(self, key : Literal["MS1"]) -> "Variation_1469":
        ...
    @overload
    def del_item(self, key : Literal["FP1"]) -> "Variation_1469":
        ...
    @overload
    def del_item(self, key : Literal["CF1"]) -> "Variation_1469":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1469.cv_arg") -> 'Variation_1469':
        return cls._create(arg) # type: ignore

class RuleVariation_1390(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1469.cv_arg
    cv_variation: TypeAlias = Variation_1469

    @classmethod
    def create(cls, arg : "RuleVariation_1390.cv_arg") -> "RuleVariation_1390":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1469:
        return self.arg # type: ignore

class NonSpare_370(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1390.cv_arg
    cv_name = "170"
    cv_title = "Aircraft Identification and Characteristics 1"
    cv_rule: TypeAlias = RuleVariation_1390

    @classmethod
    def create(cls, arg : "NonSpare_370.cv_arg") -> "NonSpare_370":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1390:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1469:
        return self.rule.variation

class UapItem_370(UapItem):
    cv_non_spare: TypeAlias = NonSpare_370

class Content_66(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Conflict not predicted to occur in military airspace", 1: "Conflict predicted to occur in military airspace"}

class RuleContent_66(RuleContentContextFree):
    cv_arg: TypeAlias = Content_66.cv_arg
    cv_content: TypeAlias = Content_66

    @property
    def content(self) -> Content_66:
        return self._get_content() # type: ignore

class Variation_20(Element):
    cv_arg: TypeAlias = RuleContent_66.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_66

    @classmethod
    def create(cls, arg: "Variation_20.cv_arg") -> "Variation_20":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_66:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_66:
        return self.rule.content

class RuleVariation_20(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_20.cv_arg
    cv_variation: TypeAlias = Variation_20

    @classmethod
    def create(cls, arg : "RuleVariation_20.cv_arg") -> "RuleVariation_20":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_20:
        return self.arg # type: ignore

class Content_65(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Conflict not predicted to occur in civil airspace", 1: "Conflict predicted to occur in civil airspace"}

class RuleContent_65(RuleContentContextFree):
    cv_arg: TypeAlias = Content_65.cv_arg
    cv_content: TypeAlias = Content_65

    @property
    def content(self) -> Content_65:
        return self._get_content() # type: ignore

class Variation_404(Element):
    cv_arg: TypeAlias = RuleContent_65.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_65

    @classmethod
    def create(cls, arg: "Variation_404.cv_arg") -> "Variation_404":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_65:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_65:
        return self.rule.content

class RuleVariation_393(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_404.cv_arg
    cv_variation: TypeAlias = Variation_404

    @classmethod
    def create(cls, arg : "RuleVariation_393.cv_arg") -> "RuleVariation_393":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_404:
        return self.arg # type: ignore

class Content_25(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Aircraft are not fast diverging laterally at current time", 1: "Aircraft are fast diverging laterally at current time"}

class RuleContent_25(RuleContentContextFree):
    cv_arg: TypeAlias = Content_25.cv_arg
    cv_content: TypeAlias = Content_25

    @property
    def content(self) -> Content_25:
        return self._get_content() # type: ignore

class Variation_509(Element):
    cv_arg: TypeAlias = RuleContent_25.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_25

    @classmethod
    def create(cls, arg: "Variation_509.cv_arg") -> "Variation_509":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_25:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_25:
        return self.rule.content

class RuleVariation_498(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_509.cv_arg
    cv_variation: TypeAlias = Variation_509

    @classmethod
    def create(cls, arg : "RuleVariation_498.cv_arg") -> "RuleVariation_498":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_509:
        return self.arg # type: ignore

class Content_26(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Aircraft are not fast diverging vertically at current time", 1: "Aircraft are fast diverging vertically at current time"}

class RuleContent_26(RuleContentContextFree):
    cv_arg: TypeAlias = Content_26.cv_arg
    cv_content: TypeAlias = Content_26

    @property
    def content(self) -> Content_26:
        return self._get_content() # type: ignore

class Variation_616(Element):
    cv_arg: TypeAlias = RuleContent_26.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_26

    @classmethod
    def create(cls, arg: "Variation_616.cv_arg") -> "Variation_616":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_26:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_26:
        return self.rule.content

class RuleVariation_605(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_616.cv_arg
    cv_variation: TypeAlias = Variation_616

    @classmethod
    def create(cls, arg : "RuleVariation_605.cv_arg") -> "RuleVariation_605":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_616:
        return self.arg # type: ignore

class Content_270(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Minor separation infringement", 1: "Major separation infringement"}

class RuleContent_270(RuleContentContextFree):
    cv_arg: TypeAlias = Content_270.cv_arg
    cv_content: TypeAlias = Content_270

    @property
    def content(self) -> Content_270:
        return self._get_content() # type: ignore

class Variation_732(Element):
    cv_arg: TypeAlias = RuleContent_270.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_270

    @classmethod
    def create(cls, arg: "Variation_732.cv_arg") -> "Variation_732":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_270:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_270:
        return self.rule.content

class RuleVariation_721(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_732.cv_arg
    cv_variation: TypeAlias = Variation_732

    @classmethod
    def create(cls, arg : "RuleVariation_721.cv_arg") -> "RuleVariation_721":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_732:
        return self.arg # type: ignore

class Content_28(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Aircraft have not crossed at starting time of conflict", 1: "Aircraft have crossed at starting time of conflict"}

class RuleContent_28(RuleContentContextFree):
    cv_arg: TypeAlias = Content_28.cv_arg
    cv_content: TypeAlias = Content_28

    @property
    def content(self) -> Content_28:
        return self._get_content() # type: ignore

class Variation_821(Element):
    cv_arg: TypeAlias = RuleContent_28.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_28

    @classmethod
    def create(cls, arg: "Variation_821.cv_arg") -> "Variation_821":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_28:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_28:
        return self.rule.content

class RuleVariation_791(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_821.cv_arg
    cv_variation: TypeAlias = Variation_821

    @classmethod
    def create(cls, arg : "RuleVariation_791.cv_arg") -> "RuleVariation_791":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_821:
        return self.arg # type: ignore

class Content_24(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Aircraft are not diverging at starting time of conflict", 1: "Aircraft are diverging at starting time of conflict"}

class RuleContent_24(RuleContentContextFree):
    cv_arg: TypeAlias = Content_24.cv_arg
    cv_content: TypeAlias = Content_24

    @property
    def content(self) -> Content_24:
        return self._get_content() # type: ignore

class Variation_902(Element):
    cv_arg: TypeAlias = RuleContent_24.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_24

    @classmethod
    def create(cls, arg: "Variation_902.cv_arg") -> "Variation_902":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_24:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_24:
        return self.rule.content

class RuleVariation_872(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_902.cv_arg
    cv_variation: TypeAlias = Variation_902

    @classmethod
    def create(cls, arg : "RuleVariation_872.cv_arg") -> "RuleVariation_872":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_902:
        return self.arg # type: ignore

class Content_146(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Runway/Runway Crossing"}

class RuleContent_146(RuleContentContextFree):
    cv_arg: TypeAlias = Content_146.cv_arg
    cv_content: TypeAlias = Content_146

    @property
    def content(self) -> Content_146:
        return self._get_content() # type: ignore

class Variation_35(Element):
    cv_arg: TypeAlias = RuleContent_146.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_146

    @classmethod
    def create(cls, arg: "Variation_35.cv_arg") -> "Variation_35":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_146:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_146:
        return self.rule.content

class RuleVariation_35(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_35.cv_arg
    cv_variation: TypeAlias = Variation_35

    @classmethod
    def create(cls, arg : "RuleVariation_35.cv_arg") -> "RuleVariation_35":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_35:
        return self.arg # type: ignore

class Content_147(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Runway/Taxiway Crossing"}

class RuleContent_147(RuleContentContextFree):
    cv_arg: TypeAlias = Content_147.cv_arg
    cv_content: TypeAlias = Content_147

    @property
    def content(self) -> Content_147:
        return self._get_content() # type: ignore

class Variation_418(Element):
    cv_arg: TypeAlias = RuleContent_147.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_147

    @classmethod
    def create(cls, arg: "Variation_418.cv_arg") -> "Variation_418":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_147:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_147:
        return self.rule.content

class RuleVariation_407(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_418.cv_arg
    cv_variation: TypeAlias = Variation_418

    @classmethod
    def create(cls, arg : "RuleVariation_407.cv_arg") -> "RuleVariation_407":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_418:
        return self.arg # type: ignore

class Content_127(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 4 (MSAW) indicates MRVA"}

class RuleContent_127(RuleContentContextFree):
    cv_arg: TypeAlias = Content_127.cv_arg
    cv_content: TypeAlias = Content_127

    @property
    def content(self) -> Content_127:
        return self._get_content() # type: ignore

class Variation_520(Element):
    cv_arg: TypeAlias = RuleContent_127.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_127

    @classmethod
    def create(cls, arg: "Variation_520.cv_arg") -> "Variation_520":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_127:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_127:
        return self.rule.content

class RuleVariation_509(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_520.cv_arg
    cv_variation: TypeAlias = Variation_520

    @classmethod
    def create(cls, arg : "RuleVariation_509.cv_arg") -> "RuleVariation_509":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_520:
        return self.arg # type: ignore

class Content_121(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 25 (VRAM) indicates CRM"}

class RuleContent_121(RuleContentContextFree):
    cv_arg: TypeAlias = Content_121.cv_arg
    cv_content: TypeAlias = Content_121

    @property
    def content(self) -> Content_121:
        return self._get_content() # type: ignore

class Variation_629(Element):
    cv_arg: TypeAlias = RuleContent_121.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_121

    @classmethod
    def create(cls, arg: "Variation_629.cv_arg") -> "Variation_629":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_121:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_121:
        return self.rule.content

class RuleVariation_618(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_629.cv_arg
    cv_variation: TypeAlias = Variation_629

    @classmethod
    def create(cls, arg : "RuleVariation_618.cv_arg") -> "RuleVariation_618":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_629:
        return self.arg # type: ignore

class Content_122(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 25 (VRAM) indicates VRM"}

class RuleContent_122(RuleContentContextFree):
    cv_arg: TypeAlias = Content_122.cv_arg
    cv_content: TypeAlias = Content_122

    @property
    def content(self) -> Content_122:
        return self._get_content() # type: ignore

class Variation_710(Element):
    cv_arg: TypeAlias = RuleContent_122.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_122

    @classmethod
    def create(cls, arg: "Variation_710.cv_arg") -> "Variation_710":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_122:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_122:
        return self.rule.content

class RuleVariation_699(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_710.cv_arg
    cv_variation: TypeAlias = Variation_710

    @classmethod
    def create(cls, arg : "RuleVariation_699.cv_arg") -> "RuleVariation_699":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_710:
        return self.arg # type: ignore

class Content_123(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 25 (VRAM) indicates VTM"}

class RuleContent_123(RuleContentContextFree):
    cv_arg: TypeAlias = Content_123.cv_arg
    cv_content: TypeAlias = Content_123

    @property
    def content(self) -> Content_123:
        return self._get_content() # type: ignore

class Variation_832(Element):
    cv_arg: TypeAlias = RuleContent_123.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_123

    @classmethod
    def create(cls, arg: "Variation_832.cv_arg") -> "Variation_832":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_123:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_123:
        return self.rule.content

class RuleVariation_802(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_832.cv_arg
    cv_variation: TypeAlias = Variation_832

    @classmethod
    def create(cls, arg : "RuleVariation_802.cv_arg") -> "RuleVariation_802":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_832:
        return self.arg # type: ignore

class Content_124(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 29 (HAM) indicates HD"}

class RuleContent_124(RuleContentContextFree):
    cv_arg: TypeAlias = Content_124.cv_arg
    cv_content: TypeAlias = Content_124

    @property
    def content(self) -> Content_124:
        return self._get_content() # type: ignore

class Variation_914(Element):
    cv_arg: TypeAlias = RuleContent_124.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_124

    @classmethod
    def create(cls, arg: "Variation_914.cv_arg") -> "Variation_914":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_124:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_124:
        return self.rule.content

class RuleVariation_884(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_914.cv_arg
    cv_variation: TypeAlias = Variation_914

    @classmethod
    def create(cls, arg : "RuleVariation_884.cv_arg") -> "RuleVariation_884":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_914:
        return self.arg # type: ignore

class Content_125(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 29 (HAM) indicates RD"}

class RuleContent_125(RuleContentContextFree):
    cv_arg: TypeAlias = Content_125.cv_arg
    cv_content: TypeAlias = Content_125

    @property
    def content(self) -> Content_125:
        return self._get_content() # type: ignore

class Variation_33(Element):
    cv_arg: TypeAlias = RuleContent_125.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_125

    @classmethod
    def create(cls, arg: "Variation_33.cv_arg") -> "Variation_33":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_125:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_125:
        return self.rule.content

class RuleVariation_33(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_33.cv_arg
    cv_variation: TypeAlias = Variation_33

    @classmethod
    def create(cls, arg : "RuleVariation_33.cv_arg") -> "RuleVariation_33":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_33:
        return self.arg # type: ignore

class Content_126(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 29 (HAM) indicates VD"}

class RuleContent_126(RuleContentContextFree):
    cv_arg: TypeAlias = Content_126.cv_arg
    cv_content: TypeAlias = Content_126

    @property
    def content(self) -> Content_126:
        return self._get_content() # type: ignore

class Variation_413(Element):
    cv_arg: TypeAlias = RuleContent_126.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_126

    @classmethod
    def create(cls, arg: "Variation_413.cv_arg") -> "Variation_413":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_126:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_126:
        return self.rule.content

class RuleVariation_402(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_413.cv_arg
    cv_variation: TypeAlias = Variation_413

    @classmethod
    def create(cls, arg : "RuleVariation_402.cv_arg") -> "RuleVariation_402":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_413:
        return self.arg # type: ignore

class Content_118(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 20 (DBPSM) indicates ARR"}

class RuleContent_118(RuleContentContextFree):
    cv_arg: TypeAlias = Content_118.cv_arg
    cv_content: TypeAlias = Content_118

    @property
    def content(self) -> Content_118:
        return self._get_content() # type: ignore

class Variation_519(Element):
    cv_arg: TypeAlias = RuleContent_118.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_118

    @classmethod
    def create(cls, arg: "Variation_519.cv_arg") -> "Variation_519":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_118:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_118:
        return self.rule.content

class RuleVariation_508(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_519.cv_arg
    cv_variation: TypeAlias = Variation_519

    @classmethod
    def create(cls, arg : "RuleVariation_508.cv_arg") -> "RuleVariation_508":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_519:
        return self.arg # type: ignore

class Content_119(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 20 (DBPSM) indicates DEP"}

class RuleContent_119(RuleContentContextFree):
    cv_arg: TypeAlias = Content_119.cv_arg
    cv_content: TypeAlias = Content_119

    @property
    def content(self) -> Content_119:
        return self._get_content() # type: ignore

class Variation_628(Element):
    cv_arg: TypeAlias = RuleContent_119.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_119

    @classmethod
    def create(cls, arg: "Variation_628.cv_arg") -> "Variation_628":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_119:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_119:
        return self.rule.content

class RuleVariation_617(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_628.cv_arg
    cv_variation: TypeAlias = Variation_628

    @classmethod
    def create(cls, arg : "RuleVariation_617.cv_arg") -> "RuleVariation_617":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_628:
        return self.arg # type: ignore

class Content_120(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 20 (DBPSM) indicates above TL"}

class RuleContent_120(RuleContentContextFree):
    cv_arg: TypeAlias = Content_120.cv_arg
    cv_content: TypeAlias = Content_120

    @property
    def content(self) -> Content_120:
        return self._get_content() # type: ignore

class Variation_709(Element):
    cv_arg: TypeAlias = RuleContent_120.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_120

    @classmethod
    def create(cls, arg: "Variation_709.cv_arg") -> "Variation_709":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_120:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_120:
        return self.rule.content

class RuleVariation_698(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_709.cv_arg
    cv_variation: TypeAlias = Variation_709

    @classmethod
    def create(cls, arg : "RuleVariation_698.cv_arg") -> "RuleVariation_698":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_709:
        return self.arg # type: ignore

class Content_128(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 99 (AIW) indicates pAIW Alert"}

class RuleContent_128(RuleContentContextFree):
    cv_arg: TypeAlias = Content_128.cv_arg
    cv_content: TypeAlias = Content_128

    @property
    def content(self) -> Content_128:
        return self._get_content() # type: ignore

class Variation_833(Element):
    cv_arg: TypeAlias = RuleContent_128.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_128

    @classmethod
    def create(cls, arg: "Variation_833.cv_arg") -> "Variation_833":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_128:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_128:
        return self.rule.content

class RuleVariation_803(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_833.cv_arg
    cv_variation: TypeAlias = Variation_833

    @classmethod
    def create(cls, arg : "RuleVariation_803.cv_arg") -> "RuleVariation_803":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_833:
        return self.arg # type: ignore

class NonSpare_1230(NonSpare):
    cv_arg: TypeAlias = RuleVariation_20.cv_arg
    cv_name = "MAS"
    cv_title = "Conflict Location in Military Airspace"
    cv_rule: TypeAlias = RuleVariation_20

    @classmethod
    def create(cls, arg : "NonSpare_1230.cv_arg") -> "NonSpare_1230":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_20:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_20:
        return self.rule.variation

class Item_529(Item):
    cv_arg: TypeAlias = NonSpare_1230.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1230

    @classmethod
    def create(cls, arg : "Item_529.cv_arg") -> "Item_529":
        return cls._create(arg) # type: ignore

class NonSpare_705(NonSpare):
    cv_arg: TypeAlias = RuleVariation_393.cv_arg
    cv_name = "CAS"
    cv_title = "Conflict Location in Civil Airspace"
    cv_rule: TypeAlias = RuleVariation_393

    @classmethod
    def create(cls, arg : "NonSpare_705.cv_arg") -> "NonSpare_705":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_393:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_404:
        return self.rule.variation

class Item_135(Item):
    cv_arg: TypeAlias = NonSpare_705.cv_arg
    cv_non_spare: TypeAlias = NonSpare_705

    @classmethod
    def create(cls, arg : "Item_135.cv_arg") -> "Item_135":
        return cls._create(arg) # type: ignore

class NonSpare_976(NonSpare):
    cv_arg: TypeAlias = RuleVariation_498.cv_arg
    cv_name = "FLD"
    cv_title = "Fast Lateral Divergence"
    cv_rule: TypeAlias = RuleVariation_498

    @classmethod
    def create(cls, arg : "NonSpare_976.cv_arg") -> "NonSpare_976":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_498:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_509:
        return self.rule.variation

class Item_332(Item):
    cv_arg: TypeAlias = NonSpare_976.cv_arg
    cv_non_spare: TypeAlias = NonSpare_976

    @classmethod
    def create(cls, arg : "Item_332.cv_arg") -> "Item_332":
        return cls._create(arg) # type: ignore

class NonSpare_1008(NonSpare):
    cv_arg: TypeAlias = RuleVariation_605.cv_arg
    cv_name = "FVD"
    cv_title = "Fast Vertical Divergence"
    cv_rule: TypeAlias = RuleVariation_605

    @classmethod
    def create(cls, arg : "NonSpare_1008.cv_arg") -> "NonSpare_1008":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_605:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_616:
        return self.rule.variation

class Item_354(Item):
    cv_arg: TypeAlias = NonSpare_1008.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1008

    @classmethod
    def create(cls, arg : "Item_354.cv_arg") -> "Item_354":
        return cls._create(arg) # type: ignore

class NonSpare_1975(NonSpare):
    cv_arg: TypeAlias = RuleVariation_721.cv_arg
    cv_name = "TYPE"
    cv_title = "Type of Separation Infringement"
    cv_rule: TypeAlias = RuleVariation_721

    @classmethod
    def create(cls, arg : "NonSpare_1975.cv_arg") -> "NonSpare_1975":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_721:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_732:
        return self.rule.variation

class Item_1088(Item):
    cv_arg: TypeAlias = NonSpare_1975.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1975

    @classmethod
    def create(cls, arg : "Item_1088.cv_arg") -> "Item_1088":
        return cls._create(arg) # type: ignore

class NonSpare_829(NonSpare):
    cv_arg: TypeAlias = RuleVariation_791.cv_arg
    cv_name = "CROSS"
    cv_title = "Crossing Test"
    cv_rule: TypeAlias = RuleVariation_791

    @classmethod
    def create(cls, arg : "NonSpare_829.cv_arg") -> "NonSpare_829":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_791:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_821:
        return self.rule.variation

class Item_215(Item):
    cv_arg: TypeAlias = NonSpare_829.cv_arg
    cv_non_spare: TypeAlias = NonSpare_829

    @classmethod
    def create(cls, arg : "Item_215.cv_arg") -> "Item_215":
        return cls._create(arg) # type: ignore

class NonSpare_886(NonSpare):
    cv_arg: TypeAlias = RuleVariation_872.cv_arg
    cv_name = "DIV"
    cv_title = "Divergence Test"
    cv_rule: TypeAlias = RuleVariation_872

    @classmethod
    def create(cls, arg : "NonSpare_886.cv_arg") -> "NonSpare_886":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_872:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_902:
        return self.rule.variation

class Item_263(Item):
    cv_arg: TypeAlias = NonSpare_886.cv_arg
    cv_non_spare: TypeAlias = NonSpare_886

    @classmethod
    def create(cls, arg : "Item_263.cv_arg") -> "Item_263":
        return cls._create(arg) # type: ignore

class NonSpare_1611(NonSpare):
    cv_arg: TypeAlias = RuleVariation_35.cv_arg
    cv_name = "RRC"
    cv_title = "Runway/Runway Crossing in RIMCAS"
    cv_rule: TypeAlias = RuleVariation_35

    @classmethod
    def create(cls, arg : "NonSpare_1611.cv_arg") -> "NonSpare_1611":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_35:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_35:
        return self.rule.variation

class Item_829(Item):
    cv_arg: TypeAlias = NonSpare_1611.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1611

    @classmethod
    def create(cls, arg : "Item_829.cv_arg") -> "Item_829":
        return cls._create(arg) # type: ignore

class NonSpare_1633(NonSpare):
    cv_arg: TypeAlias = RuleVariation_407.cv_arg
    cv_name = "RTC"
    cv_title = "Runway/Taxiway Crossing in RIMCAS"
    cv_rule: TypeAlias = RuleVariation_407

    @classmethod
    def create(cls, arg : "NonSpare_1633.cv_arg") -> "NonSpare_1633":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_407:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_418:
        return self.rule.variation

class Item_839(Item):
    cv_arg: TypeAlias = NonSpare_1633.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1633

    @classmethod
    def create(cls, arg : "Item_839.cv_arg") -> "Item_839":
        return cls._create(arg) # type: ignore

class NonSpare_1319(NonSpare):
    cv_arg: TypeAlias = RuleVariation_509.cv_arg
    cv_name = "MRVA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_509

    @classmethod
    def create(cls, arg : "NonSpare_1319.cv_arg") -> "NonSpare_1319":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_509:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_520:
        return self.rule.variation

class Item_585(Item):
    cv_arg: TypeAlias = NonSpare_1319.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1319

    @classmethod
    def create(cls, arg : "Item_585.cv_arg") -> "Item_585":
        return cls._create(arg) # type: ignore

class NonSpare_2039(NonSpare):
    cv_arg: TypeAlias = RuleVariation_618.cv_arg
    cv_name = "VRAMCRM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_618

    @classmethod
    def create(cls, arg : "NonSpare_2039.cv_arg") -> "NonSpare_2039":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_618:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_629:
        return self.rule.variation

class Item_1148(Item):
    cv_arg: TypeAlias = NonSpare_2039.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2039

    @classmethod
    def create(cls, arg : "Item_1148.cv_arg") -> "Item_1148":
        return cls._create(arg) # type: ignore

class NonSpare_2041(NonSpare):
    cv_arg: TypeAlias = RuleVariation_699.cv_arg
    cv_name = "VRAMVRM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_699

    @classmethod
    def create(cls, arg : "NonSpare_2041.cv_arg") -> "NonSpare_2041":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_699:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_710:
        return self.rule.variation

class Item_1150(Item):
    cv_arg: TypeAlias = NonSpare_2041.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2041

    @classmethod
    def create(cls, arg : "Item_1150.cv_arg") -> "Item_1150":
        return cls._create(arg) # type: ignore

class NonSpare_2044(NonSpare):
    cv_arg: TypeAlias = RuleVariation_802.cv_arg
    cv_name = "VRAMVTM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_802

    @classmethod
    def create(cls, arg : "NonSpare_2044.cv_arg") -> "NonSpare_2044":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_802:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_832:
        return self.rule.variation

class Item_1153(Item):
    cv_arg: TypeAlias = NonSpare_2044.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2044

    @classmethod
    def create(cls, arg : "Item_1153.cv_arg") -> "Item_1153":
        return cls._create(arg) # type: ignore

class NonSpare_1055(NonSpare):
    cv_arg: TypeAlias = RuleVariation_884.cv_arg
    cv_name = "HAMHD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_884

    @classmethod
    def create(cls, arg : "NonSpare_1055.cv_arg") -> "NonSpare_1055":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_884:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_914:
        return self.rule.variation

class Item_383(Item):
    cv_arg: TypeAlias = NonSpare_1055.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1055

    @classmethod
    def create(cls, arg : "Item_383.cv_arg") -> "Item_383":
        return cls._create(arg) # type: ignore

class NonSpare_1057(NonSpare):
    cv_arg: TypeAlias = RuleVariation_33.cv_arg
    cv_name = "HAMRD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_33

    @classmethod
    def create(cls, arg : "NonSpare_1057.cv_arg") -> "NonSpare_1057":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_33:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_33:
        return self.rule.variation

class Item_385(Item):
    cv_arg: TypeAlias = NonSpare_1057.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1057

    @classmethod
    def create(cls, arg : "Item_385.cv_arg") -> "Item_385":
        return cls._create(arg) # type: ignore

class NonSpare_1059(NonSpare):
    cv_arg: TypeAlias = RuleVariation_402.cv_arg
    cv_name = "HAMVD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_402

    @classmethod
    def create(cls, arg : "NonSpare_1059.cv_arg") -> "NonSpare_1059":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_402:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_413:
        return self.rule.variation

class Item_387(Item):
    cv_arg: TypeAlias = NonSpare_1059.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1059

    @classmethod
    def create(cls, arg : "Item_387.cv_arg") -> "Item_387":
        return cls._create(arg) # type: ignore

class NonSpare_866(NonSpare):
    cv_arg: TypeAlias = RuleVariation_508.cv_arg
    cv_name = "DBPSMARR"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_508

    @classmethod
    def create(cls, arg : "NonSpare_866.cv_arg") -> "NonSpare_866":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_508:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_519:
        return self.rule.variation

class Item_244(Item):
    cv_arg: TypeAlias = NonSpare_866.cv_arg
    cv_non_spare: TypeAlias = NonSpare_866

    @classmethod
    def create(cls, arg : "Item_244.cv_arg") -> "Item_244":
        return cls._create(arg) # type: ignore

class NonSpare_868(NonSpare):
    cv_arg: TypeAlias = RuleVariation_617.cv_arg
    cv_name = "DBPSMDEP"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_617

    @classmethod
    def create(cls, arg : "NonSpare_868.cv_arg") -> "NonSpare_868":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_617:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_628:
        return self.rule.variation

class Item_246(Item):
    cv_arg: TypeAlias = NonSpare_868.cv_arg
    cv_non_spare: TypeAlias = NonSpare_868

    @classmethod
    def create(cls, arg : "Item_246.cv_arg") -> "Item_246":
        return cls._create(arg) # type: ignore

class NonSpare_870(NonSpare):
    cv_arg: TypeAlias = RuleVariation_698.cv_arg
    cv_name = "DBPSMTL"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_698

    @classmethod
    def create(cls, arg : "NonSpare_870.cv_arg") -> "NonSpare_870":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_698:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_709:
        return self.rule.variation

class Item_248(Item):
    cv_arg: TypeAlias = NonSpare_870.cv_arg
    cv_non_spare: TypeAlias = NonSpare_870

    @classmethod
    def create(cls, arg : "Item_248.cv_arg") -> "Item_248":
        return cls._create(arg) # type: ignore

class NonSpare_590(NonSpare):
    cv_arg: TypeAlias = RuleVariation_803.cv_arg
    cv_name = "AIW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_803

    @classmethod
    def create(cls, arg : "NonSpare_590.cv_arg") -> "NonSpare_590":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_803:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_833:
        return self.rule.variation

class Item_57(Item):
    cv_arg: TypeAlias = NonSpare_590.cv_arg
    cv_non_spare: TypeAlias = NonSpare_590

    @classmethod
    def create(cls, arg : "Item_57.cv_arg") -> "Item_57":
        return cls._create(arg) # type: ignore

class Item_26(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 6
    cv_bit_size = 1

class Variation_1364(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_20.cv_arg, Tuple[Literal["MAS"], RuleVariation_20.cv_arg]], Union[RuleVariation_393.cv_arg, Tuple[Literal["CAS"], RuleVariation_393.cv_arg]], Union[RuleVariation_498.cv_arg, Tuple[Literal["FLD"], RuleVariation_498.cv_arg]], Union[RuleVariation_605.cv_arg, Tuple[Literal["FVD"], RuleVariation_605.cv_arg]], Union[RuleVariation_721.cv_arg, Tuple[Literal["TYPE"], RuleVariation_721.cv_arg]], Union[RuleVariation_791.cv_arg, Tuple[Literal["CROSS"], RuleVariation_791.cv_arg]], Union[RuleVariation_872.cv_arg, Tuple[Literal["DIV"], RuleVariation_872.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_35.cv_arg, Tuple[Literal["RRC"], RuleVariation_35.cv_arg]], Union[RuleVariation_407.cv_arg, Tuple[Literal["RTC"], RuleVariation_407.cv_arg]], Union[RuleVariation_509.cv_arg, Tuple[Literal["MRVA"], RuleVariation_509.cv_arg]], Union[RuleVariation_618.cv_arg, Tuple[Literal["VRAMCRM"], RuleVariation_618.cv_arg]], Union[RuleVariation_699.cv_arg, Tuple[Literal["VRAMVRM"], RuleVariation_699.cv_arg]], Union[RuleVariation_802.cv_arg, Tuple[Literal["VRAMVTM"], RuleVariation_802.cv_arg]], Union[RuleVariation_884.cv_arg, Tuple[Literal["HAMHD"], RuleVariation_884.cv_arg]], None]]
    cv_arg_group_3: TypeAlias = Union[int, Tuple[Union[RuleVariation_33.cv_arg, Tuple[Literal["HAMRD"], RuleVariation_33.cv_arg]], Union[RuleVariation_402.cv_arg, Tuple[Literal["HAMVD"], RuleVariation_402.cv_arg]], Union[RuleVariation_508.cv_arg, Tuple[Literal["DBPSMARR"], RuleVariation_508.cv_arg]], Union[RuleVariation_617.cv_arg, Tuple[Literal["DBPSMDEP"], RuleVariation_617.cv_arg]], Union[RuleVariation_698.cv_arg, Tuple[Literal["DBPSMTL"], RuleVariation_698.cv_arg]], Union[RuleVariation_803.cv_arg, Tuple[Literal["AIW"], RuleVariation_803.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1364.cv_arg_group_1"],
        Tuple["Variation_1364.cv_arg_group_1", "Variation_1364.cv_arg_group_2"],
        Tuple["Variation_1364.cv_arg_group_1", "Variation_1364.cv_arg_group_2", "Variation_1364.cv_arg_group_3"],
    ]
    cv_items_list = [[(Item_529, 1), (Item_135, 1), (Item_332, 1), (Item_354, 1), (Item_1088, 1), (Item_215, 1), (Item_263, 1), None], [(Item_829, 1), (Item_839, 1), (Item_585, 1), (Item_1148, 1), (Item_1150, 1), (Item_1153, 1), (Item_383, 1), None], [(Item_385, 1), (Item_387, 1), (Item_244, 1), (Item_246, 1), (Item_248, 1), (Item_57, 1), (Item_26, 1), None]]

    @classmethod
    def create(cls, arg: "Variation_1364.cv_arg") -> 'Variation_1364':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["MAS"]) -> RuleVariation_20:
        ...
    @overload
    def get_item(self, key : Literal["CAS"]) -> RuleVariation_393:
        ...
    @overload
    def get_item(self, key : Literal["FLD"]) -> RuleVariation_498:
        ...
    @overload
    def get_item(self, key : Literal["FVD"]) -> RuleVariation_605:
        ...
    @overload
    def get_item(self, key : Literal["TYPE"]) -> RuleVariation_721:
        ...
    @overload
    def get_item(self, key : Literal["CROSS"]) -> RuleVariation_791:
        ...
    @overload
    def get_item(self, key : Literal["DIV"]) -> RuleVariation_872:
        ...
    @overload
    def get_item(self, key : Literal["RRC"]) -> Optional[RuleVariation_35]:
        ...
    @overload
    def get_item(self, key : Literal["RTC"]) -> Optional[RuleVariation_407]:
        ...
    @overload
    def get_item(self, key : Literal["MRVA"]) -> Optional[RuleVariation_509]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMCRM"]) -> Optional[RuleVariation_618]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMVRM"]) -> Optional[RuleVariation_699]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMVTM"]) -> Optional[RuleVariation_802]:
        ...
    @overload
    def get_item(self, key : Literal["HAMHD"]) -> Optional[RuleVariation_884]:
        ...
    @overload
    def get_item(self, key : Literal["HAMRD"]) -> Optional[RuleVariation_33]:
        ...
    @overload
    def get_item(self, key : Literal["HAMVD"]) -> Optional[RuleVariation_402]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMARR"]) -> Optional[RuleVariation_508]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMDEP"]) -> Optional[RuleVariation_617]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMTL"]) -> Optional[RuleVariation_698]:
        ...
    @overload
    def get_item(self, key : Literal["AIW"]) -> Optional[RuleVariation_803]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1285(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1364.cv_arg
    cv_variation: TypeAlias = Variation_1364

    @classmethod
    def create(cls, arg : "RuleVariation_1285.cv_arg") -> "RuleVariation_1285":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1364:
        return self.arg # type: ignore

class NonSpare_746(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1285.cv_arg
    cv_name = "CN"
    cv_title = "Conflict Nature"
    cv_rule: TypeAlias = RuleVariation_1285

    @classmethod
    def create(cls, arg : "NonSpare_746.cv_arg") -> "NonSpare_746":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1285:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1364:
        return self.rule.variation

class Variation_132(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 4
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_132.cv_arg") -> "Variation_132":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_132(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_132.cv_arg
    cv_variation: TypeAlias = Variation_132

    @classmethod
    def create(cls, arg : "RuleVariation_132.cv_arg") -> "RuleVariation_132":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_132:
        return self.arg # type: ignore

class NonSpare_1862(NonSpare):
    cv_arg: TypeAlias = RuleVariation_132.cv_arg
    cv_name = "TID"
    cv_title = "Identification of Conflict Categories Definition Table"
    cv_rule: TypeAlias = RuleVariation_132

    @classmethod
    def create(cls, arg : "NonSpare_1862.cv_arg") -> "NonSpare_1862":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_132:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_132:
        return self.rule.variation

class Item_998(Item):
    cv_arg: TypeAlias = NonSpare_1862.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1862

    @classmethod
    def create(cls, arg : "Item_998.cv_arg") -> "Item_998":
        return cls._create(arg) # type: ignore

class Content_11(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "APW Low Severity", 1: "APW Medium Severity", 2: "APW High Severity"}

class RuleContent_11(RuleContentContextFree):
    cv_arg: TypeAlias = Content_11.cv_arg
    cv_content: TypeAlias = Content_11

    @property
    def content(self) -> Content_11:
        return self._get_content() # type: ignore

class Variation_777(Element):
    cv_arg: TypeAlias = RuleContent_11.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_11

    @classmethod
    def create(cls, arg: "Variation_777.cv_arg") -> "Variation_777":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_11:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_11:
        return self.rule.content

class Content_584(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Major seperation infringement and not (crossed and diverging)", 2: "Minor seperation infringement and not (crossed and diverging)", 3: "Major seperation infringement and (crossed and diverging)", 4: "Minor seperation infringement and (crossed and diverging)"}

class RuleContent_584(RuleContentContextFree):
    cv_arg: TypeAlias = Content_584.cv_arg
    cv_content: TypeAlias = Content_584

    @property
    def content(self) -> Content_584:
        return self._get_content() # type: ignore

class Variation_798(Element):
    cv_arg: TypeAlias = RuleContent_584.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_584

    @classmethod
    def create(cls, arg: "Variation_798.cv_arg") -> "Variation_798":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_584:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_584:
        return self.rule.content

class Content_212(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Filter not set", 1: "Filter set"}

class RuleContent_212(RuleContentContextFree):
    cv_arg: TypeAlias = Content_212.cv_arg
    cv_content: TypeAlias = Content_212

    @property
    def content(self) -> Content_212:
        return self._get_content() # type: ignore

class Variation_724(Element):
    cv_arg: TypeAlias = RuleContent_212.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_212

    @classmethod
    def create(cls, arg: "Variation_724.cv_arg") -> "Variation_724":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_212:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_212:
        return self.rule.content

class RuleVariation_713(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_724.cv_arg
    cv_variation: TypeAlias = Variation_724

    @classmethod
    def create(cls, arg : "RuleVariation_713.cv_arg") -> "RuleVariation_713":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_724:
        return self.arg # type: ignore

class NonSpare_1197(NonSpare):
    cv_arg: TypeAlias = RuleVariation_713.cv_arg
    cv_name = "LPF"
    cv_title = "Linear Prediction Filter"
    cv_rule: TypeAlias = RuleVariation_713

    @classmethod
    def create(cls, arg : "NonSpare_1197.cv_arg") -> "NonSpare_1197":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_713:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_724:
        return self.rule.variation

class Item_505(Item):
    cv_arg: TypeAlias = NonSpare_1197.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1197

    @classmethod
    def create(cls, arg : "Item_505.cv_arg") -> "Item_505":
        return cls._create(arg) # type: ignore

class Variation_851(Element):
    cv_arg: TypeAlias = RuleContent_212.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_212

    @classmethod
    def create(cls, arg: "Variation_851.cv_arg") -> "Variation_851":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_212:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_212:
        return self.rule.content

class RuleVariation_821(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_851.cv_arg
    cv_variation: TypeAlias = Variation_851

    @classmethod
    def create(cls, arg : "RuleVariation_821.cv_arg") -> "RuleVariation_821":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_851:
        return self.arg # type: ignore

class NonSpare_820(NonSpare):
    cv_arg: TypeAlias = RuleVariation_821.cv_arg
    cv_name = "CPF"
    cv_title = "Current Proximity Filter"
    cv_rule: TypeAlias = RuleVariation_821

    @classmethod
    def create(cls, arg : "NonSpare_820.cv_arg") -> "NonSpare_820":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_821:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_851:
        return self.rule.variation

class Item_209(Item):
    cv_arg: TypeAlias = NonSpare_820.cv_arg
    cv_non_spare: TypeAlias = NonSpare_820

    @classmethod
    def create(cls, arg : "Item_209.cv_arg") -> "Item_209":
        return cls._create(arg) # type: ignore

class Variation_927(Element):
    cv_arg: TypeAlias = RuleContent_212.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_212

    @classmethod
    def create(cls, arg: "Variation_927.cv_arg") -> "Variation_927":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_212:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_212:
        return self.rule.content

class RuleVariation_897(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_927.cv_arg
    cv_variation: TypeAlias = Variation_927

    @classmethod
    def create(cls, arg : "RuleVariation_897.cv_arg") -> "RuleVariation_897":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_927:
        return self.arg # type: ignore

class NonSpare_1279(NonSpare):
    cv_arg: TypeAlias = RuleVariation_897.cv_arg
    cv_name = "MHF"
    cv_title = "Manoeuvre Hazard Filter"
    cv_rule: TypeAlias = RuleVariation_897

    @classmethod
    def create(cls, arg : "NonSpare_1279.cv_arg") -> "NonSpare_1279":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_897:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_927:
        return self.rule.variation

class Item_549(Item):
    cv_arg: TypeAlias = NonSpare_1279.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1279

    @classmethod
    def create(cls, arg : "Item_549.cv_arg") -> "Item_549":
        return cls._create(arg) # type: ignore

class Variation_1337(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_713.cv_arg, Tuple[Literal["LPF"], RuleVariation_713.cv_arg]], Union[RuleVariation_821.cv_arg, Tuple[Literal["CPF"], RuleVariation_821.cv_arg]], Union[RuleVariation_897.cv_arg, Tuple[Literal["MHF"], RuleVariation_897.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1337.cv_arg_group"]
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_items_list = [(Item_505, 1), (Item_209, 1), (Item_549, 1)]
    cv_items_dict = {"LPF": RuleVariation_713, "CPF": RuleVariation_821, "MHF": RuleVariation_897}

    @overload
    @classmethod
    def spec(cls, key : Literal["LPF"]) -> RuleVariation_713:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPF"]) -> RuleVariation_821:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MHF"]) -> RuleVariation_897:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["LPF"], Literal["CPF"], Literal["MHF"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["LPF"]) -> RuleVariation_713:
        ...
    @overload
    def get_item(self, key : Literal["CPF"]) -> RuleVariation_821:
        ...
    @overload
    def get_item(self, key : Literal["MHF"]) -> RuleVariation_897:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1337.cv_arg") -> 'Variation_1337':
        return cls._create(arg) # type: ignore

class Content_458(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Stage One Alert", 1: "Stage Two Alert"}

class RuleContent_458(RuleContentContextFree):
    cv_arg: TypeAlias = Content_458.cv_arg
    cv_content: TypeAlias = Content_458

    @property
    def content(self) -> Content_458:
        return self._get_content() # type: ignore

class Variation_751(Element):
    cv_arg: TypeAlias = RuleContent_458.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_458

    @classmethod
    def create(cls, arg: "Variation_751.cv_arg") -> "Variation_751":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_458:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_458:
        return self.rule.content

class RuleVariation_740(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_751.cv_arg
    cv_variation: TypeAlias = Variation_751

    @classmethod
    def create(cls, arg : "RuleVariation_740.cv_arg") -> "RuleVariation_740":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_751:
        return self.arg # type: ignore

class NonSpare_1550(NonSpare):
    cv_arg: TypeAlias = RuleVariation_740.cv_arg
    cv_name = "RAS"
    cv_title = "RIMCAS Alert Stage"
    cv_rule: TypeAlias = RuleVariation_740

    @classmethod
    def create(cls, arg : "NonSpare_1550.cv_arg") -> "NonSpare_1550":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_740:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_751:
        return self.rule.variation

class Item_778(Item):
    cv_arg: TypeAlias = NonSpare_1550.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1550

    @classmethod
    def create(cls, arg : "Item_778.cv_arg") -> "Item_778":
        return cls._create(arg) # type: ignore

class Variation_1338(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_740.cv_arg, Tuple[Literal["RAS"], RuleVariation_740.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1338.cv_arg_group"]
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_items_list = [(Item_778, 1), (Item_24, 2)]
    cv_items_dict = {"RAS": RuleVariation_740}

    @classmethod
    def spec(cls, key : Literal["RAS"]) -> RuleVariation_740:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["RAS"]) -> RuleVariation_740:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1338.cv_arg") -> 'Variation_1338':
        return cls._create(arg) # type: ignore

class Content_4(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "2 aircraft, same taxiway, opposite direction", 1: "Aircraft entering wrong direction", 2: "Aircraft entering wrong taxiway", 3: "Speed violation"}

class RuleContent_4(RuleContentContextFree):
    cv_arg: TypeAlias = Content_4.cv_arg
    cv_content: TypeAlias = Content_4

    @property
    def content(self) -> Content_4:
        return self._get_content() # type: ignore

class Variation_776(Element):
    cv_arg: TypeAlias = RuleContent_4.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_4

    @classmethod
    def create(cls, arg: "Variation_776.cv_arg") -> "Variation_776":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_4:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_4:
        return self.rule.content

class Content_557(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "VRM Slow Climb", 1: "VRM Slow Descent"}

class RuleContent_557(RuleContentContextFree):
    cv_arg: TypeAlias = Content_557.cv_arg
    cv_content: TypeAlias = Content_557

    @property
    def content(self) -> Content_557:
        return self._get_content() # type: ignore

class Variation_795(Element):
    cv_arg: TypeAlias = RuleContent_557.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_557

    @classmethod
    def create(cls, arg: "Variation_795.cv_arg") -> "Variation_795":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_557:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_557:
        return self.rule.content

class Content_558(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "VTM Fast Climb", 1: "VTM Fast Descent"}

class RuleContent_558(RuleContentContextFree):
    cv_arg: TypeAlias = Content_558.cv_arg
    cv_content: TypeAlias = Content_558

    @property
    def content(self) -> Content_558:
        return self._get_content() # type: ignore

class Variation_796(Element):
    cv_arg: TypeAlias = RuleContent_558.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_558

    @classmethod
    def create(cls, arg: "Variation_796.cv_arg") -> "Variation_796":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_558:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_558:
        return self.rule.content

class Content_563(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Vertical manoeuvre deviation prior to reaching its expected level", 1: "Vertical manoeuvre deviation past its expected level"}

class RuleContent_563(RuleContentContextFree):
    cv_arg: TypeAlias = Content_563.cv_arg
    cv_content: TypeAlias = Content_563

    @property
    def content(self) -> Content_563:
        return self._get_content() # type: ignore

class Variation_797(Element):
    cv_arg: TypeAlias = RuleContent_563.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_563

    @classmethod
    def create(cls, arg: "Variation_797.cv_arg") -> "Variation_797":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_563:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_563:
        return self.rule.content

class Content_457(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Slow Descent", 1: "Fast Descent", 2: "Slow Climb", 3: "Fast Climb"}

class RuleContent_457(RuleContentContextFree):
    cv_arg: TypeAlias = Content_457.cv_arg
    cv_content: TypeAlias = Content_457

    @property
    def content(self) -> Content_457:
        return self._get_content() # type: ignore

class Variation_790(Element):
    cv_arg: TypeAlias = RuleContent_457.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_457

    @classmethod
    def create(cls, arg: "Variation_790.cv_arg") -> "Variation_790":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_457:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_457:
        return self.rule.content

class Content_12(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Above", 1: "Below"}

class RuleContent_12(RuleContentContextFree):
    cv_arg: TypeAlias = Content_12.cv_arg
    cv_content: TypeAlias = Content_12

    @property
    def content(self) -> Content_12:
        return self._get_content() # type: ignore

class Variation_778(Element):
    cv_arg: TypeAlias = RuleContent_12.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_12

    @classmethod
    def create(cls, arg: "Variation_778.cv_arg") -> "Variation_778":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_12:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_12:
        return self.rule.content

class Content_477(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Table - Single RWY Operation", 1: "MRS - Single RWY Operation", 2: "ROT - Single RWY Operation", 3: "GAP - Single RWY Operation", 4: "Table - Parallel RWY Operation", 5: "MRS - Parallel RWY Operation", 6: "ROT - Parallel RWY Operation", 7: "GAP - Parallel RWY Operation"}

class RuleContent_477(RuleContentContextFree):
    cv_arg: TypeAlias = Content_477.cv_arg
    cv_content: TypeAlias = Content_477

    @property
    def content(self) -> Content_477:
        return self._get_content() # type: ignore

class Variation_791(Element):
    cv_arg: TypeAlias = RuleContent_477.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_477

    @classmethod
    def create(cls, arg: "Variation_791.cv_arg") -> "Variation_791":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_477:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_477:
        return self.rule.content

class Content_208(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "End of Alert", 1: "Planned Alert", 2: "Alert on TABLE Indicator", 3: "Alert on MRS Indicator", 4: "Alert on ROT Indicator", 5: "Alert on GAP Indicator"}

class RuleContent_208(RuleContentContextFree):
    cv_arg: TypeAlias = Content_208.cv_arg
    cv_content: TypeAlias = Content_208

    @property
    def content(self) -> Content_208:
        return self._get_content() # type: ignore

class Variation_782(Element):
    cv_arg: TypeAlias = RuleContent_208.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_208

    @classmethod
    def create(cls, arg: "Variation_782.cv_arg") -> "Variation_782":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_208:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_208:
        return self.rule.content

class Content_257(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Line-Up vs. Line-Up", 1: "Line-Up vs. Cross or Enter", 2: "Line-Up vs. Take-Off", 3: "Line-Up vs. Landing"}

class RuleContent_257(RuleContentContextFree):
    cv_arg: TypeAlias = Content_257.cv_arg
    cv_content: TypeAlias = Content_257

    @property
    def content(self) -> Content_257:
        return self._get_content() # type: ignore

class Variation_784(Element):
    cv_arg: TypeAlias = RuleContent_257.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_257

    @classmethod
    def create(cls, arg: "Variation_784.cv_arg") -> "Variation_784":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_257:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_257:
        return self.rule.content

class Content_70(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Cross or Enter  vs. Line-Up", 1: "Cross or Enter  vs. Cross or Enter", 2: "Cross or Enter  vs. Take-Off", 3: "Cross or Enter  vs. Landing"}

class RuleContent_70(RuleContentContextFree):
    cv_arg: TypeAlias = Content_70.cv_arg
    cv_content: TypeAlias = Content_70

    @property
    def content(self) -> Content_70:
        return self._get_content() # type: ignore

class Variation_781(Element):
    cv_arg: TypeAlias = RuleContent_70.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_70

    @classmethod
    def create(cls, arg: "Variation_781.cv_arg") -> "Variation_781":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_70:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_70:
        return self.rule.content

class Content_478(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Take-Off vs. Line-Up", 1: "Take-Off vs. Cross or Enter", 2: "Take-Off vs. Take-Off", 3: "Take-Off vs. Landing"}

class RuleContent_478(RuleContentContextFree):
    cv_arg: TypeAlias = Content_478.cv_arg
    cv_content: TypeAlias = Content_478

    @property
    def content(self) -> Content_478:
        return self._get_content() # type: ignore

class Variation_792(Element):
    cv_arg: TypeAlias = RuleContent_478.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_478

    @classmethod
    def create(cls, arg: "Variation_792.cv_arg") -> "Variation_792":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_478:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_478:
        return self.rule.content

class Content_254(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Landing vs. Line-Up", 1: "Landing vs. Cross or Enter", 2: "Landing vs. Take-Off", 3: "Landing vs. Landing"}

class RuleContent_254(RuleContentContextFree):
    cv_arg: TypeAlias = Content_254.cv_arg
    cv_content: TypeAlias = Content_254

    @property
    def content(self) -> Content_254:
        return self._get_content() # type: ignore

class Variation_783(Element):
    cv_arg: TypeAlias = RuleContent_254.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_254

    @classmethod
    def create(cls, arg: "Variation_783.cv_arg") -> "Variation_783":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_254:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_254:
        return self.rule.content

class Content_432(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Push-Back vs. Push-Back", 1: "Push-Back vs. Taxi"}

class RuleContent_432(RuleContentContextFree):
    cv_arg: TypeAlias = Content_432.cv_arg
    cv_content: TypeAlias = Content_432

    @property
    def content(self) -> Content_432:
        return self._get_content() # type: ignore

class Variation_789(Element):
    cv_arg: TypeAlias = RuleContent_432.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_432

    @classmethod
    def create(cls, arg: "Variation_789.cv_arg") -> "Variation_789":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_432:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_432:
        return self.rule.content

class Content_485(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Taxi vs. Push-Back", 1: "TAxi vs. Taxi"}

class RuleContent_485(RuleContentContextFree):
    cv_arg: TypeAlias = Content_485.cv_arg
    cv_content: TypeAlias = Content_485

    @property
    def content(self) -> Content_485:
        return self._get_content() # type: ignore

class Variation_793(Element):
    cv_arg: TypeAlias = RuleContent_485.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_485

    @classmethod
    def create(cls, arg: "Variation_793.cv_arg") -> "Variation_793":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_485:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_485:
        return self.rule.content

class Content_314(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No Push-Back Clearance", 1: "No Taxi Clearance", 2: "No Line-Up Clearance", 3: "No Crossing Clearance", 4: "No Enter Clearance", 5: "No Take-Off Clearance", 6: "Landing Clearance"}

class RuleContent_314(RuleContentContextFree):
    cv_arg: TypeAlias = Content_314.cv_arg
    cv_content: TypeAlias = Content_314

    @property
    def content(self) -> Content_314:
        return self._get_content() # type: ignore

class Variation_785(Element):
    cv_arg: TypeAlias = RuleContent_314.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_314

    @classmethod
    def create(cls, arg: "Variation_785.cv_arg") -> "Variation_785":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_314:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_314:
        return self.rule.content

class Content_21(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "After Push-Back Clearance", 1: "After Taxi Clearance", 2: "After Line-Up Clearance", 3: "After Crossing Clearance", 4: "After Enter Clearance", 5: "After Take-Off Clearance", 6: "Stationary on Runway", 7: "Stationary on Taxiway"}

class RuleContent_21(RuleContentContextFree):
    cv_arg: TypeAlias = Content_21.cv_arg
    cv_content: TypeAlias = Content_21

    @property
    def content(self) -> Content_21:
        return self._get_content() # type: ignore

class Variation_780(Element):
    cv_arg: TypeAlias = RuleContent_21.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_21

    @classmethod
    def create(cls, arg: "Variation_780.cv_arg") -> "Variation_780":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_21:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_21:
        return self.rule.content

class Content_343(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No contact (receiving ATSU)", 1: "No transfer (leaving ATSU)"}

class RuleContent_343(RuleContentContextFree):
    cv_arg: TypeAlias = Content_343.cv_arg
    cv_content: TypeAlias = Content_343

    @property
    def content(self) -> Content_343:
        return self._get_content() # type: ignore

class Variation_786(Element):
    cv_arg: TypeAlias = RuleContent_343.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_343

    @classmethod
    def create(cls, arg: "Variation_786.cv_arg") -> "Variation_786":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_343:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_343:
        return self.rule.content

class RuleVariation_1442(RuleVariationDependent):
    cv_arg: TypeAlias = Union[
        Variation_774.cv_arg,
        Variation_777.cv_arg,
        Variation_798.cv_arg,
        Variation_1337.cv_arg,
        Variation_1338.cv_arg,
        Variation_1338.cv_arg,
        Variation_1338.cv_arg,
        Variation_1338.cv_arg,
        Variation_1338.cv_arg,
        Variation_1338.cv_arg,
        Variation_1338.cv_arg,
        Variation_1338.cv_arg,
        Variation_776.cv_arg,
        Variation_795.cv_arg,
        Variation_796.cv_arg,
        Variation_797.cv_arg,
        Variation_790.cv_arg,
        Variation_778.cv_arg,
        Variation_791.cv_arg,
        Variation_791.cv_arg,
        Variation_782.cv_arg,
        Variation_784.cv_arg,
        Variation_781.cv_arg,
        Variation_792.cv_arg,
        Variation_783.cv_arg,
        Variation_789.cv_arg,
        Variation_793.cv_arg,
        Variation_785.cv_arg,
        Variation_780.cv_arg,
        Variation_786.cv_arg,
    ]
    cv_depends_on = [["000"], ["120", "CC", "TID"]]
    cv_default_variation: TypeAlias = Variation_774
    cv_cases = [
        ([5, 1], Variation_777),
        ([7, 0], Variation_798),
        ([7, 1], Variation_1337),
        ([9, 2], Variation_1338),
        ([10, 2], Variation_1338),
        ([11, 2], Variation_1338),
        ([12, 2], Variation_1338),
        ([13, 2], Variation_1338),
        ([14, 2], Variation_1338),
        ([15, 2], Variation_1338),
        ([16, 2], Variation_1338),
        ([15, 1], Variation_776),
        ([24, 1], Variation_795),
        ([24, 2], Variation_796),
        ([26, 1], Variation_797),
        ([27, 1], Variation_790),
        ([27, 2], Variation_778),
        ([33, 1], Variation_791),
        ([34, 1], Variation_791),
        ([35, 1], Variation_782),
        ([38, 0], Variation_784),
        ([38, 1], Variation_781),
        ([38, 2], Variation_792),
        ([38, 3], Variation_783),
        ([38, 4], Variation_789),
        ([38, 5], Variation_793),
        ([39, 1], Variation_785),
        ([40, 1], Variation_780),
        ([41, 1], Variation_786),
    ]

    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[5], Literal[1]]) -> Variation_777:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[7], Literal[0]]) -> Variation_798:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[7], Literal[1]]) -> Variation_1337:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[9], Literal[2]]) -> Variation_1338:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[10], Literal[2]]) -> Variation_1338:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[11], Literal[2]]) -> Variation_1338:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[12], Literal[2]]) -> Variation_1338:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[13], Literal[2]]) -> Variation_1338:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[14], Literal[2]]) -> Variation_1338:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[15], Literal[2]]) -> Variation_1338:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[16], Literal[2]]) -> Variation_1338:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[15], Literal[1]]) -> Variation_776:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[24], Literal[1]]) -> Variation_795:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[24], Literal[2]]) -> Variation_796:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[26], Literal[1]]) -> Variation_797:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[27], Literal[1]]) -> Variation_790:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[27], Literal[2]]) -> Variation_778:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[33], Literal[1]]) -> Variation_791:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[34], Literal[1]]) -> Variation_791:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[35], Literal[1]]) -> Variation_782:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[0]]) -> Variation_784:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[1]]) -> Variation_781:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[2]]) -> Variation_792:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[3]]) -> Variation_783:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[4]]) -> Variation_789:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[5]]) -> Variation_793:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[39], Literal[1]]) -> Variation_785:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[40], Literal[1]]) -> Variation_780:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[41], Literal[1]]) -> Variation_786:
        ...

    @classmethod
    def variation(cls, key : Any) -> Any:
        return cls._variation(key)

    @classmethod
    def create(cls, arg : "RuleVariation_1442.cv_arg") -> "RuleVariation_1442":
        return cls._create(arg) # type: ignore

class NonSpare_817(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1442.cv_arg
    cv_name = "CPC"
    cv_title = "Conflict Properties Class"
    cv_rule: TypeAlias = RuleVariation_1442

    @classmethod
    def create(cls, arg : "NonSpare_817.cv_arg") -> "NonSpare_817":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1442:
        return self.arg # type: ignore

class Item_207(Item):
    cv_arg: TypeAlias = NonSpare_817.cv_arg
    cv_non_spare: TypeAlias = NonSpare_817

    @classmethod
    def create(cls, arg : "Item_207.cv_arg") -> "Item_207":
        return cls._create(arg) # type: ignore

class Content_253(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "LOW", 1: "HIGH"}

class RuleContent_253(RuleContentContextFree):
    cv_arg: TypeAlias = Content_253.cv_arg
    cv_content: TypeAlias = Content_253

    @property
    def content(self) -> Content_253:
        return self._get_content() # type: ignore

class Variation_982(Element):
    cv_arg: TypeAlias = RuleContent_253.cv_arg
    cv_bit_offset8 = 7
    cv_bit_size = 1
    cv_rule = RuleContent_253

    @classmethod
    def create(cls, arg: "Variation_982.cv_arg") -> "Variation_982":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_253:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_253:
        return self.rule.content

class RuleVariation_952(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_982.cv_arg
    cv_variation: TypeAlias = Variation_982

    @classmethod
    def create(cls, arg : "RuleVariation_952.cv_arg") -> "RuleVariation_952":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_982:
        return self.arg # type: ignore

class NonSpare_834(NonSpare):
    cv_arg: TypeAlias = RuleVariation_952.cv_arg
    cv_name = "CS"
    cv_title = "Conflict Severity"
    cv_rule: TypeAlias = RuleVariation_952

    @classmethod
    def create(cls, arg : "NonSpare_834.cv_arg") -> "NonSpare_834":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_952:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_982:
        return self.rule.variation

class Item_219(Item):
    cv_arg: TypeAlias = NonSpare_834.cv_arg
    cv_non_spare: TypeAlias = NonSpare_834

    @classmethod
    def create(cls, arg : "Item_219.cv_arg") -> "Item_219":
        return cls._create(arg) # type: ignore

class Variation_1224(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_132.cv_arg, Tuple[Literal["TID"], RuleVariation_132.cv_arg]], Union[RuleVariation_1442.cv_arg, Tuple[Literal["CPC"], RuleVariation_1442.cv_arg]], Union[RuleVariation_952.cv_arg, Tuple[Literal["CS"], RuleVariation_952.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1224.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_998, 4), (Item_207, 3), (Item_219, 1)]
    cv_items_dict = {"TID": RuleVariation_132, "CPC": RuleVariation_1442, "CS": RuleVariation_952}

    @overload
    @classmethod
    def spec(cls, key : Literal["TID"]) -> RuleVariation_132:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPC"]) -> RuleVariation_1442:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CS"]) -> RuleVariation_952:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["TID"], Literal["CPC"], Literal["CS"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["TID"]) -> RuleVariation_132:
        ...
    @overload
    def get_item(self, key : Literal["CPC"]) -> RuleVariation_1442:
        ...
    @overload
    def get_item(self, key : Literal["CS"]) -> RuleVariation_952:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1224.cv_arg") -> 'Variation_1224':
        return cls._create(arg) # type: ignore

class RuleVariation_1164(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1224.cv_arg
    cv_variation: TypeAlias = Variation_1224

    @classmethod
    def create(cls, arg : "RuleVariation_1164.cv_arg") -> "RuleVariation_1164":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1224:
        return self.arg # type: ignore

class NonSpare_710(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1164.cv_arg
    cv_name = "CC"
    cv_title = "Conflict Classification"
    cv_rule: TypeAlias = RuleVariation_1164

    @classmethod
    def create(cls, arg : "NonSpare_710.cv_arg") -> "NonSpare_710":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1164:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1224:
        return self.rule.variation

class Content_731(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["%"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 0.5
    cv_unit = "%"

    def as_quantity(self, cv_unit : Optional[Literal["%"]] = None) -> float:
        return self._as_quantity()

class RuleContent_731(RuleContentContextFree):
    cv_arg: TypeAlias = Content_731.cv_arg
    cv_content: TypeAlias = Content_731

    @property
    def content(self) -> Content_731:
        return self._get_content() # type: ignore

class Variation_226(Element):
    cv_arg: TypeAlias = RuleContent_731.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_731

    @classmethod
    def create(cls, arg: "Variation_226.cv_arg") -> "Variation_226":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_731:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_731:
        return self.rule.content

class RuleVariation_219(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_226.cv_arg
    cv_variation: TypeAlias = Variation_226

    @classmethod
    def create(cls, arg : "RuleVariation_219.cv_arg") -> "RuleVariation_219":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_226:
        return self.arg # type: ignore

class NonSpare_815(NonSpare):
    cv_arg: TypeAlias = RuleVariation_219.cv_arg
    cv_name = "CP"
    cv_title = "Conflict Probability"
    cv_rule: TypeAlias = RuleVariation_219

    @classmethod
    def create(cls, arg : "NonSpare_815.cv_arg") -> "NonSpare_815":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_219:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_226:
        return self.rule.variation

class NonSpare_713(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "CD"
    cv_title = "Conflict Duration"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_713.cv_arg") -> "NonSpare_713":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class Variation_1479(Compound):
    cv_arg = TypedDict('cv_arg', {
        "CN": NonSpare_746.cv_arg,
        "CC": NonSpare_710.cv_arg,
        "CP": NonSpare_815.cv_arg,
        "CD": NonSpare_713.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 1
    cv_items_list = [NonSpare_746, NonSpare_710, NonSpare_815, NonSpare_713]
    cv_items_dict = {"CN": NonSpare_746, "CC": NonSpare_710, "CP": NonSpare_815, "CD": NonSpare_713}

    @overload
    @classmethod
    def spec(cls, key : Literal["CN"]) -> NonSpare_746:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CC"]) -> NonSpare_710:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CP"]) -> NonSpare_815:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CD"]) -> NonSpare_713:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["CN"], Literal["CC"], Literal["CP"], Literal["CD"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["CN"]) -> Optional[NonSpare_746]:
        ...
    @overload
    def get_item(self, key : Literal["CC"]) -> Optional[NonSpare_710]:
        ...
    @overload
    def get_item(self, key : Literal["CP"]) -> Optional[NonSpare_815]:
        ...
    @overload
    def get_item(self, key : Literal["CD"]) -> Optional[NonSpare_713]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["CN"], val : NonSpare_746.cv_arg) -> "Variation_1479":
        ...
    @overload
    def set_item(self, key : Literal["CC"], val : NonSpare_710.cv_arg) -> "Variation_1479":
        ...
    @overload
    def set_item(self, key : Literal["CP"], val : NonSpare_815.cv_arg) -> "Variation_1479":
        ...
    @overload
    def set_item(self, key : Literal["CD"], val : NonSpare_713.cv_arg) -> "Variation_1479":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["CN"]) -> "Variation_1479":
        ...
    @overload
    def del_item(self, key : Literal["CC"]) -> "Variation_1479":
        ...
    @overload
    def del_item(self, key : Literal["CP"]) -> "Variation_1479":
        ...
    @overload
    def del_item(self, key : Literal["CD"]) -> "Variation_1479":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1479.cv_arg") -> 'Variation_1479':
        return cls._create(arg) # type: ignore

class RuleVariation_1400(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1479.cv_arg
    cv_variation: TypeAlias = Variation_1479

    @classmethod
    def create(cls, arg : "RuleVariation_1400.cv_arg") -> "RuleVariation_1400":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1479:
        return self.arg # type: ignore

class NonSpare_297(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1400.cv_arg
    cv_name = "120"
    cv_title = "Conflict Characteristics"
    cv_rule: TypeAlias = RuleVariation_1400

    @classmethod
    def create(cls, arg : "NonSpare_297.cv_arg") -> "NonSpare_297":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1400:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1479:
        return self.rule.variation

class UapItem_297(UapItem):
    cv_non_spare: TypeAlias = NonSpare_297

class NonSpare_1835(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "TC"
    cv_title = "Time to Conflict"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_1835.cv_arg") -> "NonSpare_1835":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class NonSpare_1839(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "TCA"
    cv_title = "Time to Closest Approach"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_1839.cv_arg") -> "NonSpare_1839":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class Variation_366(Element):
    cv_arg: TypeAlias = RuleContent_732.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_rule = RuleContent_732

    @classmethod
    def create(cls, arg: "Variation_366.cv_arg") -> "Variation_366":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_732:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_732:
        return self.rule.content

class RuleVariation_359(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_366.cv_arg
    cv_variation: TypeAlias = Variation_366

    @classmethod
    def create(cls, arg : "RuleVariation_359.cv_arg") -> "RuleVariation_359":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_366:
        return self.arg # type: ignore

class NonSpare_738(NonSpare):
    cv_arg: TypeAlias = RuleVariation_359.cv_arg
    cv_name = "CHS"
    cv_title = "Current Horizontal Separation"
    cv_rule: TypeAlias = RuleVariation_359

    @classmethod
    def create(cls, arg : "NonSpare_738.cv_arg") -> "NonSpare_738":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_359:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_366:
        return self.rule.variation

class NonSpare_1282(NonSpare):
    cv_arg: TypeAlias = RuleVariation_304.cv_arg
    cv_name = "MHS"
    cv_title = "Estimated Minimum Horizontal Separation"
    cv_rule: TypeAlias = RuleVariation_304

    @classmethod
    def create(cls, arg : "NonSpare_1282.cv_arg") -> "NonSpare_1282":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_304:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_311:
        return self.rule.variation

class Content_729(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["ft"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 25.0
    cv_unit = "ft"

    def as_quantity(self, cv_unit : Optional[Literal["ft"]] = None) -> float:
        return self._as_quantity()

class RuleContent_729(RuleContentContextFree):
    cv_arg: TypeAlias = Content_729.cv_arg
    cv_content: TypeAlias = Content_729

    @property
    def content(self) -> Content_729:
        return self._get_content() # type: ignore

class Variation_310(Element):
    cv_arg: TypeAlias = RuleContent_729.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_729

    @classmethod
    def create(cls, arg: "Variation_310.cv_arg") -> "Variation_310":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_729:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_729:
        return self.rule.content

class RuleVariation_303(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_310.cv_arg
    cv_variation: TypeAlias = Variation_310

    @classmethod
    def create(cls, arg : "RuleVariation_303.cv_arg") -> "RuleVariation_303":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_310:
        return self.arg # type: ignore

class NonSpare_853(NonSpare):
    cv_arg: TypeAlias = RuleVariation_303.cv_arg
    cv_name = "CVS"
    cv_title = "Current Vertical Separation"
    cv_rule: TypeAlias = RuleVariation_303

    @classmethod
    def create(cls, arg : "NonSpare_853.cv_arg") -> "NonSpare_853":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_303:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_310:
        return self.rule.variation

class NonSpare_1341(NonSpare):
    cv_arg: TypeAlias = RuleVariation_303.cv_arg
    cv_name = "MVS"
    cv_title = "Estimated Minimum Vertical Separation"
    cv_rule: TypeAlias = RuleVariation_303

    @classmethod
    def create(cls, arg : "NonSpare_1341.cv_arg") -> "NonSpare_1341":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_303:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_310:
        return self.rule.variation

class Variation_1515(Compound):
    cv_arg = TypedDict('cv_arg', {
        "TC": NonSpare_1835.cv_arg,
        "TCA": NonSpare_1839.cv_arg,
        "CHS": NonSpare_738.cv_arg,
        "MHS": NonSpare_1282.cv_arg,
        "CVS": NonSpare_853.cv_arg,
        "MVS": NonSpare_1341.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 1
    cv_items_list = [NonSpare_1835, NonSpare_1839, NonSpare_738, NonSpare_1282, NonSpare_853, NonSpare_1341]
    cv_items_dict = {"TC": NonSpare_1835, "TCA": NonSpare_1839, "CHS": NonSpare_738, "MHS": NonSpare_1282, "CVS": NonSpare_853, "MVS": NonSpare_1341}

    @overload
    @classmethod
    def spec(cls, key : Literal["TC"]) -> NonSpare_1835:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TCA"]) -> NonSpare_1839:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CHS"]) -> NonSpare_738:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MHS"]) -> NonSpare_1282:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CVS"]) -> NonSpare_853:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MVS"]) -> NonSpare_1341:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["TC"], Literal["TCA"], Literal["CHS"], Literal["MHS"], Literal["CVS"], Literal["MVS"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["TC"]) -> Optional[NonSpare_1835]:
        ...
    @overload
    def get_item(self, key : Literal["TCA"]) -> Optional[NonSpare_1839]:
        ...
    @overload
    def get_item(self, key : Literal["CHS"]) -> Optional[NonSpare_738]:
        ...
    @overload
    def get_item(self, key : Literal["MHS"]) -> Optional[NonSpare_1282]:
        ...
    @overload
    def get_item(self, key : Literal["CVS"]) -> Optional[NonSpare_853]:
        ...
    @overload
    def get_item(self, key : Literal["MVS"]) -> Optional[NonSpare_1341]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["TC"], val : NonSpare_1835.cv_arg) -> "Variation_1515":
        ...
    @overload
    def set_item(self, key : Literal["TCA"], val : NonSpare_1839.cv_arg) -> "Variation_1515":
        ...
    @overload
    def set_item(self, key : Literal["CHS"], val : NonSpare_738.cv_arg) -> "Variation_1515":
        ...
    @overload
    def set_item(self, key : Literal["MHS"], val : NonSpare_1282.cv_arg) -> "Variation_1515":
        ...
    @overload
    def set_item(self, key : Literal["CVS"], val : NonSpare_853.cv_arg) -> "Variation_1515":
        ...
    @overload
    def set_item(self, key : Literal["MVS"], val : NonSpare_1341.cv_arg) -> "Variation_1515":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["TC"]) -> "Variation_1515":
        ...
    @overload
    def del_item(self, key : Literal["TCA"]) -> "Variation_1515":
        ...
    @overload
    def del_item(self, key : Literal["CHS"]) -> "Variation_1515":
        ...
    @overload
    def del_item(self, key : Literal["MHS"]) -> "Variation_1515":
        ...
    @overload
    def del_item(self, key : Literal["CVS"]) -> "Variation_1515":
        ...
    @overload
    def del_item(self, key : Literal["MVS"]) -> "Variation_1515":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1515.cv_arg") -> 'Variation_1515':
        return cls._create(arg) # type: ignore

class RuleVariation_1436(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1515.cv_arg
    cv_variation: TypeAlias = Variation_1515

    @classmethod
    def create(cls, arg : "RuleVariation_1436.cv_arg") -> "RuleVariation_1436":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1515:
        return self.arg # type: ignore

class NonSpare_204(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1436.cv_arg
    cv_name = "070"
    cv_title = "Conflict Timing and Separation"
    cv_rule: TypeAlias = RuleVariation_1436

    @classmethod
    def create(cls, arg : "NonSpare_204.cv_arg") -> "NonSpare_204":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1436:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1515:
        return self.rule.variation

class UapItem_204(UapItem):
    cv_non_spare: TypeAlias = NonSpare_204

class Content_633(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["ft"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 25.0
    cv_unit = "ft"

    def as_quantity(self, cv_unit : Optional[Literal["ft"]] = None) -> float:
        return self._as_quantity()

class RuleContent_633(RuleContentContextFree):
    cv_arg: TypeAlias = Content_633.cv_arg
    cv_content: TypeAlias = Content_633

    @property
    def content(self) -> Content_633:
        return self._get_content() # type: ignore

class Variation_262(Element):
    cv_arg: TypeAlias = RuleContent_633.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_633

    @classmethod
    def create(cls, arg: "Variation_262.cv_arg") -> "Variation_262":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_633:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_633:
        return self.rule.content

class RuleVariation_255(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_262.cv_arg
    cv_variation: TypeAlias = Variation_262

    @classmethod
    def create(cls, arg : "RuleVariation_255.cv_arg") -> "RuleVariation_255":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_262:
        return self.arg # type: ignore

class NonSpare_230(NonSpare):
    cv_arg: TypeAlias = RuleVariation_255.cv_arg
    cv_name = "076"
    cv_title = "Vertical Deviation"
    cv_rule: TypeAlias = RuleVariation_255

    @classmethod
    def create(cls, arg : "NonSpare_230.cv_arg") -> "NonSpare_230":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_255:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_262:
        return self.rule.variation

class UapItem_230(UapItem):
    cv_non_spare: TypeAlias = NonSpare_230

class Content_638(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 32.0
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_638(RuleContentContextFree):
    cv_arg: TypeAlias = Content_638.cv_arg
    cv_content: TypeAlias = Content_638

    @property
    def content(self) -> Content_638:
        return self._get_content() # type: ignore

class Variation_264(Element):
    cv_arg: TypeAlias = RuleContent_638.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_638

    @classmethod
    def create(cls, arg: "Variation_264.cv_arg") -> "Variation_264":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_638:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_638:
        return self.rule.content

class RuleVariation_257(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_264.cv_arg
    cv_variation: TypeAlias = Variation_264

    @classmethod
    def create(cls, arg : "RuleVariation_257.cv_arg") -> "RuleVariation_257":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_264:
        return self.arg # type: ignore

class NonSpare_225(NonSpare):
    cv_arg: TypeAlias = RuleVariation_257.cv_arg
    cv_name = "074"
    cv_title = "Longitudinal Deviation"
    cv_rule: TypeAlias = RuleVariation_257

    @classmethod
    def create(cls, arg : "NonSpare_225.cv_arg") -> "NonSpare_225":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_257:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_264:
        return self.rule.variation

class UapItem_225(UapItem):
    cv_non_spare: TypeAlias = NonSpare_225

class NonSpare_228(NonSpare):
    cv_arg: TypeAlias = RuleVariation_345.cv_arg
    cv_name = "075"
    cv_title = "Transversal Distance Deviation"
    cv_rule: TypeAlias = RuleVariation_345

    @classmethod
    def create(cls, arg : "NonSpare_228.cv_arg") -> "NonSpare_228":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_345:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_352:
        return self.rule.variation

class UapItem_228(UapItem):
    cv_non_spare: TypeAlias = NonSpare_228

class NonSpare_610(NonSpare):
    cv_arg: TypeAlias = RuleVariation_383.cv_arg
    cv_name = "AN"
    cv_title = "Area Name"
    cv_rule: TypeAlias = RuleVariation_383

    @classmethod
    def create(cls, arg : "NonSpare_610.cv_arg") -> "NonSpare_610":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_391:
        return self.rule.variation

class NonSpare_704(NonSpare):
    cv_arg: TypeAlias = RuleVariation_385.cv_arg
    cv_name = "CAN"
    cv_title = "Crossing Area Name"
    cv_rule: TypeAlias = RuleVariation_385

    @classmethod
    def create(cls, arg : "NonSpare_704.cv_arg") -> "NonSpare_704":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_385:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_393:
        return self.rule.variation

class NonSpare_1629(NonSpare):
    cv_arg: TypeAlias = RuleVariation_385.cv_arg
    cv_name = "RT1"
    cv_title = "Runway/Taxiway Designator 1"
    cv_rule: TypeAlias = RuleVariation_385

    @classmethod
    def create(cls, arg : "NonSpare_1629.cv_arg") -> "NonSpare_1629":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_385:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_393:
        return self.rule.variation

class NonSpare_1630(NonSpare):
    cv_arg: TypeAlias = RuleVariation_385.cv_arg
    cv_name = "RT2"
    cv_title = "Runway/Taxiway Designator 2"
    cv_rule: TypeAlias = RuleVariation_385

    @classmethod
    def create(cls, arg : "NonSpare_1630.cv_arg") -> "NonSpare_1630":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_385:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_393:
        return self.rule.variation

class NonSpare_1665(NonSpare):
    cv_arg: TypeAlias = RuleVariation_385.cv_arg
    cv_name = "SB"
    cv_title = "Stop Bar Designator"
    cv_rule: TypeAlias = RuleVariation_385

    @classmethod
    def create(cls, arg : "NonSpare_1665.cv_arg") -> "NonSpare_1665":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_385:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_393:
        return self.rule.variation

class NonSpare_1012(NonSpare):
    cv_arg: TypeAlias = RuleVariation_385.cv_arg
    cv_name = "G"
    cv_title = "Gate Designator"
    cv_rule: TypeAlias = RuleVariation_385

    @classmethod
    def create(cls, arg : "NonSpare_1012.cv_arg") -> "NonSpare_1012":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_385:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_393:
        return self.rule.variation

class Variation_1472(Compound):
    cv_arg = TypedDict('cv_arg', {
        "AN": NonSpare_610.cv_arg,
        "CAN": NonSpare_704.cv_arg,
        "RT1": NonSpare_1629.cv_arg,
        "RT2": NonSpare_1630.cv_arg,
        "SB": NonSpare_1665.cv_arg,
        "G": NonSpare_1012.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 1
    cv_items_list = [NonSpare_610, NonSpare_704, NonSpare_1629, NonSpare_1630, NonSpare_1665, NonSpare_1012]
    cv_items_dict = {"AN": NonSpare_610, "CAN": NonSpare_704, "RT1": NonSpare_1629, "RT2": NonSpare_1630, "SB": NonSpare_1665, "G": NonSpare_1012}

    @overload
    @classmethod
    def spec(cls, key : Literal["AN"]) -> NonSpare_610:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CAN"]) -> NonSpare_704:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["RT1"]) -> NonSpare_1629:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["RT2"]) -> NonSpare_1630:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SB"]) -> NonSpare_1665:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> NonSpare_1012:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["AN"], Literal["CAN"], Literal["RT1"], Literal["RT2"], Literal["SB"], Literal["G"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["AN"]) -> Optional[NonSpare_610]:
        ...
    @overload
    def get_item(self, key : Literal["CAN"]) -> Optional[NonSpare_704]:
        ...
    @overload
    def get_item(self, key : Literal["RT1"]) -> Optional[NonSpare_1629]:
        ...
    @overload
    def get_item(self, key : Literal["RT2"]) -> Optional[NonSpare_1630]:
        ...
    @overload
    def get_item(self, key : Literal["SB"]) -> Optional[NonSpare_1665]:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> Optional[NonSpare_1012]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["AN"], val : NonSpare_610.cv_arg) -> "Variation_1472":
        ...
    @overload
    def set_item(self, key : Literal["CAN"], val : NonSpare_704.cv_arg) -> "Variation_1472":
        ...
    @overload
    def set_item(self, key : Literal["RT1"], val : NonSpare_1629.cv_arg) -> "Variation_1472":
        ...
    @overload
    def set_item(self, key : Literal["RT2"], val : NonSpare_1630.cv_arg) -> "Variation_1472":
        ...
    @overload
    def set_item(self, key : Literal["SB"], val : NonSpare_1665.cv_arg) -> "Variation_1472":
        ...
    @overload
    def set_item(self, key : Literal["G"], val : NonSpare_1012.cv_arg) -> "Variation_1472":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["AN"]) -> "Variation_1472":
        ...
    @overload
    def del_item(self, key : Literal["CAN"]) -> "Variation_1472":
        ...
    @overload
    def del_item(self, key : Literal["RT1"]) -> "Variation_1472":
        ...
    @overload
    def del_item(self, key : Literal["RT2"]) -> "Variation_1472":
        ...
    @overload
    def del_item(self, key : Literal["SB"]) -> "Variation_1472":
        ...
    @overload
    def del_item(self, key : Literal["G"]) -> "Variation_1472":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1472.cv_arg") -> 'Variation_1472':
        return cls._create(arg) # type: ignore

class RuleVariation_1393(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1472.cv_arg
    cv_variation: TypeAlias = Variation_1472

    @classmethod
    def create(cls, arg : "RuleVariation_1393.cv_arg") -> "RuleVariation_1393":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1472:
        return self.arg # type: ignore

class NonSpare_267(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1393.cv_arg
    cv_name = "100"
    cv_title = "Area Definition"
    cv_rule: TypeAlias = RuleVariation_1393

    @classmethod
    def create(cls, arg : "NonSpare_267.cv_arg") -> "NonSpare_267":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1393:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1472:
        return self.rule.variation

class UapItem_267(UapItem):
    cv_non_spare: TypeAlias = NonSpare_267

class NonSpare_130(NonSpare):
    cv_arg: TypeAlias = RuleVariation_246.cv_arg
    cv_name = "035"
    cv_title = "Track Number 2"
    cv_rule: TypeAlias = RuleVariation_246

    @classmethod
    def create(cls, arg : "NonSpare_130.cv_arg") -> "NonSpare_130":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_246:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_253:
        return self.rule.variation

class UapItem_130(UapItem):
    cv_non_spare: TypeAlias = NonSpare_130

class NonSpare_587(NonSpare):
    cv_arg: TypeAlias = RuleVariation_385.cv_arg
    cv_name = "AI2"
    cv_title = "Aircraft Identifier (in 7 Characters) of Aircraft 2 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_385

    @classmethod
    def create(cls, arg : "NonSpare_587.cv_arg") -> "NonSpare_587":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_385:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_393:
        return self.rule.variation

class NonSpare_1308(NonSpare):
    cv_arg: TypeAlias = RuleVariation_779.cv_arg
    cv_name = "MODE3A"
    cv_title = "Mode-3/A Code (Converted Into Octal Representation) of Aircraft 2 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_779

    @classmethod
    def create(cls, arg : "NonSpare_1308.cv_arg") -> "NonSpare_1308":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_779:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_809:
        return self.rule.variation

class Item_574(Item):
    cv_arg: TypeAlias = NonSpare_1308.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1308

    @classmethod
    def create(cls, arg : "Item_574.cv_arg") -> "Item_574":
        return cls._create(arg) # type: ignore

class Variation_1028(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_779.cv_arg, Tuple[Literal["MODE3A"], RuleVariation_779.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1028.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_3, 4), (Item_574, 12)]
    cv_items_dict = {"MODE3A": RuleVariation_779}

    @classmethod
    def spec(cls, key : Literal["MODE3A"]) -> RuleVariation_779:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["MODE3A"]) -> RuleVariation_779:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1028.cv_arg") -> 'Variation_1028':
        return cls._create(arg) # type: ignore

class RuleVariation_997(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1028.cv_arg
    cv_variation: TypeAlias = Variation_1028

    @classmethod
    def create(cls, arg : "RuleVariation_997.cv_arg") -> "RuleVariation_997":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1028:
        return self.arg # type: ignore

class NonSpare_1215(NonSpare):
    cv_arg: TypeAlias = RuleVariation_997.cv_arg
    cv_name = "M32"
    cv_title = "Mode 3/A Code Aircraft 2"
    cv_rule: TypeAlias = RuleVariation_997

    @classmethod
    def create(cls, arg : "NonSpare_1215.cv_arg") -> "NonSpare_1215":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_997:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1028:
        return self.rule.variation

class NonSpare_825(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1091.cv_arg
    cv_name = "CPW"
    cv_title = "Predicted Conflict Position Target 2 in WGS-84 Coordinates"
    cv_rule: TypeAlias = RuleVariation_1091

    @classmethod
    def create(cls, arg : "NonSpare_825.cv_arg") -> "NonSpare_825":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1091:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1135:
        return self.rule.variation

class NonSpare_822(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1236.cv_arg
    cv_name = "CPL"
    cv_title = "Predicted Conflict Position for the Aircraft 2 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_1236

    @classmethod
    def create(cls, arg : "NonSpare_822.cv_arg") -> "NonSpare_822":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1236:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1307:
        return self.rule.variation

class NonSpare_1945(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "TT2"
    cv_title = "Time to Runway Threshold for Second Approaching Aircraft in a RIMCA"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_1945.cv_arg") -> "NonSpare_1945":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class NonSpare_906(NonSpare):
    cv_arg: TypeAlias = RuleVariation_304.cv_arg
    cv_name = "DT2"
    cv_title = "Distance to Runway Threshold for Aircraft 2 Involved in a RIMCA"
    cv_rule: TypeAlias = RuleVariation_304

    @classmethod
    def create(cls, arg : "NonSpare_906.cv_arg") -> "NonSpare_906":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_304:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_311:
        return self.rule.variation

class NonSpare_559(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1283.cv_arg
    cv_name = "AC2"
    cv_title = "Characteristics of Aircraft 2 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_1283

    @classmethod
    def create(cls, arg : "NonSpare_559.cv_arg") -> "NonSpare_559":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1283:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1362:
        return self.rule.variation

class NonSpare_1322(NonSpare):
    cv_arg: TypeAlias = RuleVariation_383.cv_arg
    cv_name = "MS2"
    cv_title = "Aircraft Identification Downloaded From Aircraft 2 Involved in the Conflict If Eequipped With a Mode-S Transponder"
    cv_rule: TypeAlias = RuleVariation_383

    @classmethod
    def create(cls, arg : "NonSpare_1322.cv_arg") -> "NonSpare_1322":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_391:
        return self.rule.variation

class NonSpare_987(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1006.cv_arg
    cv_name = "FP2"
    cv_title = "Number of the Flight Plan Correlated to Aircraft 2 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_1006

    @classmethod
    def create(cls, arg : "NonSpare_987.cv_arg") -> "NonSpare_987":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1006:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1038:
        return self.rule.variation

class NonSpare_726(NonSpare):
    cv_arg: TypeAlias = RuleVariation_314.cv_arg
    cv_name = "CF2"
    cv_title = "Cleared Flight Level for Aircraft 2 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_314

    @classmethod
    def create(cls, arg : "NonSpare_726.cv_arg") -> "NonSpare_726":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_314:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_321:
        return self.rule.variation

class Variation_1470(Compound):
    cv_arg = TypedDict('cv_arg', {
        "AI2": NonSpare_587.cv_arg,
        "M32": NonSpare_1215.cv_arg,
        "CPW": NonSpare_825.cv_arg,
        "CPL": NonSpare_822.cv_arg,
        "TT2": NonSpare_1945.cv_arg,
        "DT2": NonSpare_906.cv_arg,
        "AC2": NonSpare_559.cv_arg,
        "MS2": NonSpare_1322.cv_arg,
        "FP2": NonSpare_987.cv_arg,
        "CF2": NonSpare_726.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 2
    cv_items_list = [NonSpare_587, NonSpare_1215, NonSpare_825, NonSpare_822, NonSpare_1945, NonSpare_906, NonSpare_559, NonSpare_1322, NonSpare_987, NonSpare_726]
    cv_items_dict = {"AI2": NonSpare_587, "M32": NonSpare_1215, "CPW": NonSpare_825, "CPL": NonSpare_822, "TT2": NonSpare_1945, "DT2": NonSpare_906, "AC2": NonSpare_559, "MS2": NonSpare_1322, "FP2": NonSpare_987, "CF2": NonSpare_726}

    @overload
    @classmethod
    def spec(cls, key : Literal["AI2"]) -> NonSpare_587:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["M32"]) -> NonSpare_1215:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPW"]) -> NonSpare_825:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPL"]) -> NonSpare_822:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TT2"]) -> NonSpare_1945:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["DT2"]) -> NonSpare_906:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AC2"]) -> NonSpare_559:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MS2"]) -> NonSpare_1322:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["FP2"]) -> NonSpare_987:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CF2"]) -> NonSpare_726:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["AI2"], Literal["M32"], Literal["CPW"], Literal["CPL"], Literal["TT2"], Literal["DT2"], Literal["AC2"], Literal["MS2"], Literal["FP2"], Literal["CF2"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["AI2"]) -> Optional[NonSpare_587]:
        ...
    @overload
    def get_item(self, key : Literal["M32"]) -> Optional[NonSpare_1215]:
        ...
    @overload
    def get_item(self, key : Literal["CPW"]) -> Optional[NonSpare_825]:
        ...
    @overload
    def get_item(self, key : Literal["CPL"]) -> Optional[NonSpare_822]:
        ...
    @overload
    def get_item(self, key : Literal["TT2"]) -> Optional[NonSpare_1945]:
        ...
    @overload
    def get_item(self, key : Literal["DT2"]) -> Optional[NonSpare_906]:
        ...
    @overload
    def get_item(self, key : Literal["AC2"]) -> Optional[NonSpare_559]:
        ...
    @overload
    def get_item(self, key : Literal["MS2"]) -> Optional[NonSpare_1322]:
        ...
    @overload
    def get_item(self, key : Literal["FP2"]) -> Optional[NonSpare_987]:
        ...
    @overload
    def get_item(self, key : Literal["CF2"]) -> Optional[NonSpare_726]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["AI2"], val : NonSpare_587.cv_arg) -> "Variation_1470":
        ...
    @overload
    def set_item(self, key : Literal["M32"], val : NonSpare_1215.cv_arg) -> "Variation_1470":
        ...
    @overload
    def set_item(self, key : Literal["CPW"], val : NonSpare_825.cv_arg) -> "Variation_1470":
        ...
    @overload
    def set_item(self, key : Literal["CPL"], val : NonSpare_822.cv_arg) -> "Variation_1470":
        ...
    @overload
    def set_item(self, key : Literal["TT2"], val : NonSpare_1945.cv_arg) -> "Variation_1470":
        ...
    @overload
    def set_item(self, key : Literal["DT2"], val : NonSpare_906.cv_arg) -> "Variation_1470":
        ...
    @overload
    def set_item(self, key : Literal["AC2"], val : NonSpare_559.cv_arg) -> "Variation_1470":
        ...
    @overload
    def set_item(self, key : Literal["MS2"], val : NonSpare_1322.cv_arg) -> "Variation_1470":
        ...
    @overload
    def set_item(self, key : Literal["FP2"], val : NonSpare_987.cv_arg) -> "Variation_1470":
        ...
    @overload
    def set_item(self, key : Literal["CF2"], val : NonSpare_726.cv_arg) -> "Variation_1470":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["AI2"]) -> "Variation_1470":
        ...
    @overload
    def del_item(self, key : Literal["M32"]) -> "Variation_1470":
        ...
    @overload
    def del_item(self, key : Literal["CPW"]) -> "Variation_1470":
        ...
    @overload
    def del_item(self, key : Literal["CPL"]) -> "Variation_1470":
        ...
    @overload
    def del_item(self, key : Literal["TT2"]) -> "Variation_1470":
        ...
    @overload
    def del_item(self, key : Literal["DT2"]) -> "Variation_1470":
        ...
    @overload
    def del_item(self, key : Literal["AC2"]) -> "Variation_1470":
        ...
    @overload
    def del_item(self, key : Literal["MS2"]) -> "Variation_1470":
        ...
    @overload
    def del_item(self, key : Literal["FP2"]) -> "Variation_1470":
        ...
    @overload
    def del_item(self, key : Literal["CF2"]) -> "Variation_1470":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1470.cv_arg") -> 'Variation_1470':
        return cls._create(arg) # type: ignore

class RuleVariation_1391(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1470.cv_arg
    cv_variation: TypeAlias = Variation_1470

    @classmethod
    def create(cls, arg : "RuleVariation_1391.cv_arg") -> "RuleVariation_1391":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1470:
        return self.arg # type: ignore

class NonSpare_382(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1391.cv_arg
    cv_name = "171"
    cv_title = "Aircraft Identification and Characteristics 2"
    cv_rule: TypeAlias = RuleVariation_1391

    @classmethod
    def create(cls, arg : "NonSpare_382.cv_arg") -> "NonSpare_382":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1391:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1470:
        return self.rule.variation

class UapItem_382(UapItem):
    cv_non_spare: TypeAlias = NonSpare_382

class NonSpare_721(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "CEN"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_721.cv_arg") -> "NonSpare_721":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class Item_147(Item):
    cv_arg: TypeAlias = NonSpare_721.cv_arg
    cv_non_spare: TypeAlias = NonSpare_721

    @classmethod
    def create(cls, arg : "Item_147.cv_arg") -> "Item_147":
        return cls._create(arg) # type: ignore

class NonSpare_1443(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "POS"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_1443.cv_arg") -> "NonSpare_1443":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class Item_692(Item):
    cv_arg: TypeAlias = NonSpare_1443.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1443

    @classmethod
    def create(cls, arg : "Item_692.cv_arg") -> "Item_692":
        return cls._create(arg) # type: ignore

class Variation_1066(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_159.cv_arg, Tuple[Literal["CEN"], RuleVariation_159.cv_arg]], Union[RuleVariation_159.cv_arg, Tuple[Literal["POS"], RuleVariation_159.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1066.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_147, 8), (Item_692, 8)]
    cv_items_dict = {"CEN": RuleVariation_159, "POS": RuleVariation_159}

    @overload
    @classmethod
    def spec(cls, key : Literal["CEN"]) -> RuleVariation_159:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["POS"]) -> RuleVariation_159:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["CEN"], Literal["POS"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["CEN"]) -> RuleVariation_159:
        ...
    @overload
    def get_item(self, key : Literal["POS"]) -> RuleVariation_159:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1066.cv_arg") -> 'Variation_1066':
        return cls._create(arg) # type: ignore

class Variation_1414(Repetitive):
    cv_arg: TypeAlias = List[Variation_1066.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1066

    @classmethod
    def create(cls, arg: "Variation_1414.cv_arg") -> 'Variation_1414':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1066]:
        return self._get_list() # type: ignore

class RuleVariation_1335(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1414.cv_arg
    cv_variation: TypeAlias = Variation_1414

    @classmethod
    def create(cls, arg : "RuleVariation_1335.cv_arg") -> "RuleVariation_1335":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1414:
        return self.arg # type: ignore

class NonSpare_286(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1335.cv_arg
    cv_name = "110"
    cv_title = "FDPS Sector Control Identification"
    cv_rule: TypeAlias = RuleVariation_1335

    @classmethod
    def create(cls, arg : "NonSpare_286.cv_arg") -> "NonSpare_286":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1335:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1414:
        return self.rule.variation

class UapItem_286(UapItem):
    cv_non_spare: TypeAlias = NonSpare_286

class Variation_1463(Explicit):
    cv_arg: TypeAlias = bytes
    cv_explicit_type: TypeAlias = ReservedExpansion

    @classmethod
    def create(cls, arg: "Variation_1463.cv_arg") -> 'Variation_1463':
        return cls._create(arg) # type: ignore

class RuleVariation_1384(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1463.cv_arg
    cv_variation: TypeAlias = Variation_1463

    @classmethod
    def create(cls, arg : "RuleVariation_1384.cv_arg") -> "RuleVariation_1384":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1463:
        return self.arg # type: ignore

class NonSpare_1568(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1384.cv_arg
    cv_name = "RE"
    cv_title = "Reserved Expansion Field"
    cv_rule: TypeAlias = RuleVariation_1384

    @classmethod
    def create(cls, arg : "NonSpare_1568.cv_arg") -> "NonSpare_1568":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1384:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1463:
        return self.rule.variation

class UapItem_547(UapItem):
    cv_non_spare: TypeAlias = NonSpare_1568

class Record_14(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_34.cv_arg,
        "000": NonSpare_3.cv_arg,
        "015": NonSpare_58.cv_arg,
        "020": NonSpare_94.cv_arg,
        "040": NonSpare_136.cv_arg,
        "045": NonSpare_163.cv_arg,
        "060": NonSpare_195.cv_arg,
        "030": NonSpare_114.cv_arg,
        "170": NonSpare_370.cv_arg,
        "120": NonSpare_297.cv_arg,
        "070": NonSpare_204.cv_arg,
        "076": NonSpare_230.cv_arg,
        "074": NonSpare_225.cv_arg,
        "075": NonSpare_228.cv_arg,
        "100": NonSpare_267.cv_arg,
        "035": NonSpare_130.cv_arg,
        "171": NonSpare_382.cv_arg,
        "110": NonSpare_286.cv_arg,
        "RE": NonSpare_1568.cv_arg,
        "SP": NonSpare_1732.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 3
    cv_items_list = [UapItem_34, UapItem_3, UapItem_58, UapItem_94, UapItem_136, UapItem_163, UapItem_195, UapItem_114, UapItem_370, UapItem_297, UapItem_204, UapItem_230, UapItem_225, UapItem_228, UapItem_267, UapItem_130, UapItem_382, UapItem_286, UapItem_549, UapItem_547, UapItem_548]
    cv_items_dict = {"010": NonSpare_34, "000": NonSpare_3, "015": NonSpare_58, "020": NonSpare_94, "040": NonSpare_136, "045": NonSpare_163, "060": NonSpare_195, "030": NonSpare_114, "170": NonSpare_370, "120": NonSpare_297, "070": NonSpare_204, "076": NonSpare_230, "074": NonSpare_225, "075": NonSpare_228, "100": NonSpare_267, "035": NonSpare_130, "171": NonSpare_382, "110": NonSpare_286, "RE": NonSpare_1568, "SP": NonSpare_1732}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_34:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> NonSpare_3:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["015"]) -> NonSpare_58:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_94:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> NonSpare_136:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["045"]) -> NonSpare_163:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_195:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> NonSpare_114:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["170"]) -> NonSpare_370:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> NonSpare_297:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> NonSpare_204:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["076"]) -> NonSpare_230:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["074"]) -> NonSpare_225:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["075"]) -> NonSpare_228:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_267:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["035"]) -> NonSpare_130:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["171"]) -> NonSpare_382:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["110"]) -> NonSpare_286:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["RE"]) -> NonSpare_1568:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1732:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["015"], Literal["020"], Literal["040"], Literal["045"], Literal["060"], Literal["030"], Literal["170"], Literal["120"], Literal["070"], Literal["076"], Literal["074"], Literal["075"], Literal["100"], Literal["035"], Literal["171"], Literal["110"], Literal["RE"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_34]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_3]:
        ...
    @overload
    def get_item(self, key : Literal["015"]) -> Optional[NonSpare_58]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_94]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_136]:
        ...
    @overload
    def get_item(self, key : Literal["045"]) -> Optional[NonSpare_163]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_195]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_114]:
        ...
    @overload
    def get_item(self, key : Literal["170"]) -> Optional[NonSpare_370]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_297]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_204]:
        ...
    @overload
    def get_item(self, key : Literal["076"]) -> Optional[NonSpare_230]:
        ...
    @overload
    def get_item(self, key : Literal["074"]) -> Optional[NonSpare_225]:
        ...
    @overload
    def get_item(self, key : Literal["075"]) -> Optional[NonSpare_228]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_267]:
        ...
    @overload
    def get_item(self, key : Literal["035"]) -> Optional[NonSpare_130]:
        ...
    @overload
    def get_item(self, key : Literal["171"]) -> Optional[NonSpare_382]:
        ...
    @overload
    def get_item(self, key : Literal["110"]) -> Optional[NonSpare_286]:
        ...
    @overload
    def get_item(self, key : Literal["RE"]) -> Optional[NonSpare_1568]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1732]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_34.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_3.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["015"], val : NonSpare_58.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_94.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_136.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["045"], val : NonSpare_163.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_195.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_114.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["170"], val : NonSpare_370.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_297.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_204.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["076"], val : NonSpare_230.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["074"], val : NonSpare_225.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["075"], val : NonSpare_228.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_267.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["035"], val : NonSpare_130.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["171"], val : NonSpare_382.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["110"], val : NonSpare_286.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["RE"], val : NonSpare_1568.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1732.cv_arg) -> 'Record_14':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["015"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["045"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["170"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["076"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["074"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["075"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["035"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["171"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["110"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["RE"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_14':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Record_14.cv_arg") -> 'Record_14':
        return cls._create(arg) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_14", Bits]]:
        return cls._parse(bs) # type: ignore

class Uap_14(UapSingle):
    cv_arg: TypeAlias = Record_14
    cv_record: TypeAlias = Record_14

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_14]]:
        return cls._parse(bs)

class Asterix_6(AstCat):
    cv_category = 4
    cv_edition = (1, 12)
    cv_uap: TypeAlias = Uap_14
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_14.cv_arg]) -> "Asterix_6":
        return cls._create(records) # type: ignore

class Content_575(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Alive Message (AM)", 2: "Route Adherence Monitor Longitudinal Deviation (RAMLD)", 3: "Route Adherence Monitor Heading Deviation (RAMHD)", 4: "Minimum Safe Altitude Warning (MSAW)", 5: "Area Proximity Warning (APW)", 6: "Clearance Level Adherence Monitor (CLAM)", 7: "Short Term Conflict Alert (STCA)", 8: "Approach Path Monitor (APM)", 9: "RIMCAS Arrival / Landing Monitor (ALM)", 10: "RIMCAS Arrival / Departure Wrong Runway Alert (WRA)", 11: "RIMCAS Arrival / Departure Opposite Traffic Alert (OTA)", 12: "RIMCAS Departure Monitor (RDM)", 13: "RIMCAS Runway / Taxiway Crossing Monitor (RCM)", 14: "RIMCAS Taxiway Separation Monitor (TSM)", 15: "RIMCAS Unauthorized Taxiway Movement Monitor(UTMM)", 16: "RIMCAS Stop Bar Overrun Alert (SBOA)", 17: "End Of Conflict (EOC)", 18: "ACAS Resolution Advisory (ACASRA)", 19: "Near Term Conflict Alert (NTCA)", 20: "Downlinked Barometric Pressure Setting Monitor (DBPSM)", 21: "Speed Adherence Monitor (SAM)", 22: "Outside Controlled Airspace Tool (OCAT)", 23: "Vertical Conflict Detection (VCD)", 24: "Vertical Rate Adherence Monitor (VRAM)", 25: "Cleared Heading Adherence Monitor (CHAM)", 26: "Downlinked Selected Altitude Monitor (DSAM)", 27: "Holding Adherence Monitor (HAM)", 28: "Vertical Path Monitor (VPM)", 29: "RIMCAS Taxiway Traffic Alert (TTA)", 30: "RIMCAS Arrival/Departure Close Runway Alert (CRA)", 31: "RIMCAS Arrival/Departure Aircraft Separation Monitor (ASM)", 32: "RIMCAS ILS Area Violation Monitor (IAVM)", 33: "Final Target Distance Indicator (FTD)", 34: "Initial Target Distance Indicator (ITD)", 35: "Wake Vortex Indicator Infringement Alert (IIA)", 36: "Sequence Warning (SQW)", 37: "Catch Up Warning (CUW)", 38: "Conflicting ATC Clearances (CATC)", 39: "No ATC Clearance (NOCLR)", 40: "Aircraft Not Moving despite ATC Clearance (NOMOV)", 41: "Aircraft leaving/entering the aerodrome area without proper handover (NOH)", 42: "Wrong Runway or Taxiway Type (WRTY)", 43: "Stand Occupied (STOCC)", 44: "Ongoing Alert (ONGOING)", 45: "Non-Transgression Zone Violation (NTZ)", 97: "Lost Track Warning (LTW)", 98: "Holding Volume Infringement (HVI)", 99: "Airspace Infringement Warning (AIW)"}

class RuleContent_575(RuleContentContextFree):
    cv_arg: TypeAlias = Content_575.cv_arg
    cv_content: TypeAlias = Content_575

    @property
    def content(self) -> Content_575:
        return self._get_content() # type: ignore

class Variation_179(Element):
    cv_arg: TypeAlias = RuleContent_575.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_575

    @classmethod
    def create(cls, arg: "Variation_179.cv_arg") -> "Variation_179":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_575:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_575:
        return self.rule.content

class RuleVariation_172(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_179.cv_arg
    cv_variation: TypeAlias = Variation_179

    @classmethod
    def create(cls, arg : "RuleVariation_172.cv_arg") -> "RuleVariation_172":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_179:
        return self.arg # type: ignore

class NonSpare_2(NonSpare):
    cv_arg: TypeAlias = RuleVariation_172.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_172

    @classmethod
    def create(cls, arg : "NonSpare_2.cv_arg") -> "NonSpare_2":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_172:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_179:
        return self.rule.variation

class UapItem_2(UapItem):
    cv_non_spare: TypeAlias = NonSpare_2

class NonSpare_93(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "020"
    cv_title = "Time of Message"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_93.cv_arg") -> "NonSpare_93":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class UapItem_93(UapItem):
    cv_non_spare: TypeAlias = NonSpare_93

class Content_204(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Element not populated", 1: "Element populated"}

class RuleContent_204(RuleContentContextFree):
    cv_arg: TypeAlias = Content_204.cv_arg
    cv_content: TypeAlias = Content_204

    @property
    def content(self) -> Content_204:
        return self._get_content() # type: ignore

class Variation_42(Element):
    cv_arg: TypeAlias = RuleContent_204.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_204

    @classmethod
    def create(cls, arg: "Variation_42.cv_arg") -> "Variation_42":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_204:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_204:
        return self.rule.content

class RuleVariation_42(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_42.cv_arg
    cv_variation: TypeAlias = Variation_42

    @classmethod
    def create(cls, arg : "RuleVariation_42.cv_arg") -> "RuleVariation_42":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_42:
        return self.arg # type: ignore

class NonSpare_941(NonSpare):
    cv_arg: TypeAlias = RuleVariation_42.cv_arg
    cv_name = "EP"
    cv_title = "Element Populated Bit"
    cv_rule: TypeAlias = RuleVariation_42

    @classmethod
    def create(cls, arg : "NonSpare_941.cv_arg") -> "NonSpare_941":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_42:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_42:
        return self.rule.variation

class Item_302(Item):
    cv_arg: TypeAlias = NonSpare_941.cv_arg
    cv_non_spare: TypeAlias = NonSpare_941

    @classmethod
    def create(cls, arg : "Item_302.cv_arg") -> "Item_302":
        return cls._create(arg) # type: ignore

class Content_243(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Inactive", 1: "Active", 2: "Pre-active", 3: "Reserved for Future Use", 4: "Reserved for Future Use", 5: "Reserved for Future Use", 6: "Reserved for Future Use", 7: "Reserved for Future Use"}

class RuleContent_243(RuleContentContextFree):
    cv_arg: TypeAlias = Content_243.cv_arg
    cv_content: TypeAlias = Content_243

    @property
    def content(self) -> Content_243:
        return self._get_content() # type: ignore

class Variation_483(Element):
    cv_arg: TypeAlias = RuleContent_243.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 3
    cv_rule = RuleContent_243

    @classmethod
    def create(cls, arg: "Variation_483.cv_arg") -> "Variation_483":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_243:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_243:
        return self.rule.content

class RuleVariation_472(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_483.cv_arg
    cv_variation: TypeAlias = Variation_483

    @classmethod
    def create(cls, arg : "RuleVariation_472.cv_arg") -> "RuleVariation_472":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_483:
        return self.arg # type: ignore

class NonSpare_1996(NonSpare):
    cv_arg: TypeAlias = RuleVariation_472.cv_arg
    cv_name = "VAL"
    cv_title = "Area Status Value"
    cv_rule: TypeAlias = RuleVariation_472

    @classmethod
    def create(cls, arg : "NonSpare_1996.cv_arg") -> "NonSpare_1996":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_472:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_483:
        return self.rule.variation

class Item_1106(Item):
    cv_arg: TypeAlias = NonSpare_1996.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1996

    @classmethod
    def create(cls, arg : "Item_1106.cv_arg") -> "Item_1106":
        return cls._create(arg) # type: ignore

class Variation_1092(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_42.cv_arg, Tuple[Literal["EP"], RuleVariation_42.cv_arg]], Union[RuleVariation_472.cv_arg, Tuple[Literal["VAL"], RuleVariation_472.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1092.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 4
    cv_items_list = [(Item_302, 1), (Item_1106, 3)]
    cv_items_dict = {"EP": RuleVariation_42, "VAL": RuleVariation_472}

    @overload
    @classmethod
    def spec(cls, key : Literal["EP"]) -> RuleVariation_42:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["VAL"]) -> RuleVariation_472:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["EP"], Literal["VAL"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["EP"]) -> RuleVariation_42:
        ...
    @overload
    def get_item(self, key : Literal["VAL"]) -> RuleVariation_472:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1092.cv_arg") -> 'Variation_1092':
        return cls._create(arg) # type: ignore

class RuleVariation_1050(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1092.cv_arg
    cv_variation: TypeAlias = Variation_1092

    @classmethod
    def create(cls, arg : "RuleVariation_1050.cv_arg") -> "RuleVariation_1050":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1092:
        return self.arg # type: ignore

class NonSpare_631(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1050.cv_arg
    cv_name = "AREA"
    cv_title = "Area Status"
    cv_rule: TypeAlias = RuleVariation_1050

    @classmethod
    def create(cls, arg : "NonSpare_631.cv_arg") -> "NonSpare_631":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1050:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1092:
        return self.rule.variation

class Item_84(Item):
    cv_arg: TypeAlias = NonSpare_631.cv_arg
    cv_non_spare: TypeAlias = NonSpare_631

    @classmethod
    def create(cls, arg : "Item_84.cv_arg") -> "Item_84":
        return cls._create(arg) # type: ignore

class Variation_1054(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_1050.cv_arg, Tuple[Literal["AREA"], RuleVariation_1050.cv_arg]], Union[RuleVariation_763.cv_arg, Tuple[Literal["STAT"], RuleVariation_763.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1054.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_84, 4), (Item_944, 3), (Item_29, 1)]
    cv_items_dict = {"AREA": RuleVariation_1050, "STAT": RuleVariation_763}

    @overload
    @classmethod
    def spec(cls, key : Literal["AREA"]) -> RuleVariation_1050:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["STAT"]) -> RuleVariation_763:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["AREA"], Literal["STAT"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["AREA"]) -> RuleVariation_1050:
        ...
    @overload
    def get_item(self, key : Literal["STAT"]) -> RuleVariation_763:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1054.cv_arg") -> 'Variation_1054':
        return cls._create(arg) # type: ignore

class RuleVariation_1021(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1054.cv_arg
    cv_variation: TypeAlias = Variation_1054

    @classmethod
    def create(cls, arg : "RuleVariation_1021.cv_arg") -> "RuleVariation_1021":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1054:
        return self.arg # type: ignore

class NonSpare_164(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1021.cv_arg
    cv_name = "045"
    cv_title = "Area and Alert Status"
    cv_rule: TypeAlias = RuleVariation_1021

    @classmethod
    def create(cls, arg : "NonSpare_164.cv_arg") -> "NonSpare_164":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1021:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1054:
        return self.rule.variation

class UapItem_164(UapItem):
    cv_non_spare: TypeAlias = NonSpare_164

class Content_133(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Non-Transgression Zone Function"}

class RuleContent_133(RuleContentContextFree):
    cv_arg: TypeAlias = Content_133.cv_arg
    cv_content: TypeAlias = Content_133

    @property
    def content(self) -> Content_133:
        return self._get_content() # type: ignore

class Variation_34(Element):
    cv_arg: TypeAlias = RuleContent_133.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_133

    @classmethod
    def create(cls, arg: "Variation_34.cv_arg") -> "Variation_34":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_133:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_133:
        return self.rule.content

class RuleVariation_34(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_34.cv_arg
    cv_variation: TypeAlias = Variation_34

    @classmethod
    def create(cls, arg : "RuleVariation_34.cv_arg") -> "RuleVariation_34":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_34:
        return self.arg # type: ignore

class NonSpare_1382(NonSpare):
    cv_arg: TypeAlias = RuleVariation_34.cv_arg
    cv_name = "NTZ"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_34

    @classmethod
    def create(cls, arg : "NonSpare_1382.cv_arg") -> "NonSpare_1382":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_34:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_34:
        return self.rule.variation

class Item_641(Item):
    cv_arg: TypeAlias = NonSpare_1382.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1382

    @classmethod
    def create(cls, arg : "Item_641.cv_arg") -> "Item_641":
        return cls._create(arg) # type: ignore

class Variation_1372(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_32.cv_arg, Tuple[Literal["MRVA"], RuleVariation_32.cv_arg]], Union[RuleVariation_405.cv_arg, Tuple[Literal["RAMLD"], RuleVariation_405.cv_arg]], Union[RuleVariation_513.cv_arg, Tuple[Literal["RAMHD"], RuleVariation_513.cv_arg]], Union[RuleVariation_615.cv_arg, Tuple[Literal["MSAW"], RuleVariation_615.cv_arg]], Union[RuleVariation_694.cv_arg, Tuple[Literal["APW"], RuleVariation_694.cv_arg]], Union[RuleVariation_800.cv_arg, Tuple[Literal["CLAM"], RuleVariation_800.cv_arg]], Union[RuleVariation_889.cv_arg, Tuple[Literal["STCA"], RuleVariation_889.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_24.cv_arg, Tuple[Literal["APM"], RuleVariation_24.cv_arg]], Union[RuleVariation_406.cv_arg, Tuple[Literal["RIMCA"], RuleVariation_406.cv_arg]], Union[RuleVariation_503.cv_arg, Tuple[Literal["ACASRA"], RuleVariation_503.cv_arg]], Union[RuleVariation_620.cv_arg, Tuple[Literal["NTCA"], RuleVariation_620.cv_arg]], Union[RuleVariation_700.cv_arg, Tuple[Literal["DG"], RuleVariation_700.cv_arg]], Union[RuleVariation_804.cv_arg, Tuple[Literal["OF"], RuleVariation_804.cv_arg]], Union[RuleVariation_886.cv_arg, Tuple[Literal["OL"], RuleVariation_886.cv_arg]], None]]
    cv_arg_group_3: TypeAlias = Union[int, Tuple[Union[RuleVariation_23.cv_arg, Tuple[Literal["AIW"], RuleVariation_23.cv_arg]], Union[RuleVariation_404.cv_arg, Tuple[Literal["PAIW"], RuleVariation_404.cv_arg]], Union[RuleVariation_511.cv_arg, Tuple[Literal["OCAT"], RuleVariation_511.cv_arg]], Union[RuleVariation_621.cv_arg, Tuple[Literal["SAM"], RuleVariation_621.cv_arg]], Union[RuleVariation_701.cv_arg, Tuple[Literal["VCD"], RuleVariation_701.cv_arg]], Union[RuleVariation_799.cv_arg, Tuple[Literal["CHAM"], RuleVariation_799.cv_arg]], Union[RuleVariation_880.cv_arg, Tuple[Literal["DSAM"], RuleVariation_880.cv_arg]], None]]
    cv_arg_group_4: TypeAlias = Union[int, Tuple[Union[RuleVariation_27.cv_arg, Tuple[Literal["DBPSMARR"], RuleVariation_27.cv_arg]], Union[RuleVariation_395.cv_arg, Tuple[Literal["DBPSMDEP"], RuleVariation_395.cv_arg]], Union[RuleVariation_505.cv_arg, Tuple[Literal["DBPSMTL"], RuleVariation_505.cv_arg]], Union[RuleVariation_623.cv_arg, Tuple[Literal["VRAMCRM"], RuleVariation_623.cv_arg]], Union[RuleVariation_703.cv_arg, Tuple[Literal["VRAMVTM"], RuleVariation_703.cv_arg]], Union[RuleVariation_811.cv_arg, Tuple[Literal["VRAMVRM"], RuleVariation_811.cv_arg]], Union[RuleVariation_883.cv_arg, Tuple[Literal["HAMHD"], RuleVariation_883.cv_arg]], None]]
    cv_arg_group_5: TypeAlias = Union[int, Tuple[Union[RuleVariation_29.cv_arg, Tuple[Literal["HAMRD"], RuleVariation_29.cv_arg]], Union[RuleVariation_398.cv_arg, Tuple[Literal["HAMVD"], RuleVariation_398.cv_arg]], Union[RuleVariation_507.cv_arg, Tuple[Literal["HVI"], RuleVariation_507.cv_arg]], Union[RuleVariation_614.cv_arg, Tuple[Literal["LTW"], RuleVariation_614.cv_arg]], Union[RuleVariation_702.cv_arg, Tuple[Literal["VPM"], RuleVariation_702.cv_arg]], Union[RuleVariation_809.cv_arg, Tuple[Literal["TTA"], RuleVariation_809.cv_arg]], Union[RuleVariation_878.cv_arg, Tuple[Literal["CRA"], RuleVariation_878.cv_arg]], None]]
    cv_arg_group_6: TypeAlias = Union[int, Tuple[Union[RuleVariation_25.cv_arg, Tuple[Literal["ASM"], RuleVariation_25.cv_arg]], Union[RuleVariation_399.cv_arg, Tuple[Literal["IAVM"], RuleVariation_399.cv_arg]], Union[RuleVariation_506.cv_arg, Tuple[Literal["FTD"], RuleVariation_506.cv_arg]], Union[RuleVariation_612.cv_arg, Tuple[Literal["ITD"], RuleVariation_612.cv_arg]], Union[RuleVariation_696.cv_arg, Tuple[Literal["IIA"], RuleVariation_696.cv_arg]], Union[RuleVariation_806.cv_arg, Tuple[Literal["SQW"], RuleVariation_806.cv_arg]], Union[RuleVariation_879.cv_arg, Tuple[Literal["CUW"], RuleVariation_879.cv_arg]], None]]
    cv_arg_group_7: TypeAlias = Union[int, Tuple[Union[RuleVariation_26.cv_arg, Tuple[Literal["CATC"], RuleVariation_26.cv_arg]], Union[RuleVariation_403.cv_arg, Tuple[Literal["NOCLR"], RuleVariation_403.cv_arg]], Union[RuleVariation_510.cv_arg, Tuple[Literal["NOMOV"], RuleVariation_510.cv_arg]], Union[RuleVariation_619.cv_arg, Tuple[Literal["NOH"], RuleVariation_619.cv_arg]], Union[RuleVariation_704.cv_arg, Tuple[Literal["WRTY"], RuleVariation_704.cv_arg]], Union[RuleVariation_807.cv_arg, Tuple[Literal["STOCC"], RuleVariation_807.cv_arg]], Union[RuleVariation_885.cv_arg, Tuple[Literal["ONGOING"], RuleVariation_885.cv_arg]], None]]
    cv_arg_group_8: TypeAlias = Union[int, Tuple[Union[RuleVariation_34.cv_arg, Tuple[Literal["NTZ"], RuleVariation_34.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1372.cv_arg_group_1"],
        Tuple["Variation_1372.cv_arg_group_1", "Variation_1372.cv_arg_group_2"],
        Tuple["Variation_1372.cv_arg_group_1", "Variation_1372.cv_arg_group_2", "Variation_1372.cv_arg_group_3"],
        Tuple["Variation_1372.cv_arg_group_1", "Variation_1372.cv_arg_group_2", "Variation_1372.cv_arg_group_3", "Variation_1372.cv_arg_group_4"],
        Tuple["Variation_1372.cv_arg_group_1", "Variation_1372.cv_arg_group_2", "Variation_1372.cv_arg_group_3", "Variation_1372.cv_arg_group_4", "Variation_1372.cv_arg_group_5"],
        Tuple["Variation_1372.cv_arg_group_1", "Variation_1372.cv_arg_group_2", "Variation_1372.cv_arg_group_3", "Variation_1372.cv_arg_group_4", "Variation_1372.cv_arg_group_5", "Variation_1372.cv_arg_group_6"],
        Tuple["Variation_1372.cv_arg_group_1", "Variation_1372.cv_arg_group_2", "Variation_1372.cv_arg_group_3", "Variation_1372.cv_arg_group_4", "Variation_1372.cv_arg_group_5", "Variation_1372.cv_arg_group_6", "Variation_1372.cv_arg_group_7"],
        Tuple["Variation_1372.cv_arg_group_1", "Variation_1372.cv_arg_group_2", "Variation_1372.cv_arg_group_3", "Variation_1372.cv_arg_group_4", "Variation_1372.cv_arg_group_5", "Variation_1372.cv_arg_group_6", "Variation_1372.cv_arg_group_7", "Variation_1372.cv_arg_group_8"],
    ]
    cv_items_list = [[(Item_584, 1), (Item_777, 1), (Item_776, 1), (Item_587, 1), (Item_78, 1), (Item_162, 1), (Item_948, 1), None], [(Item_77, 1), (Item_822, 1), (Item_40, 1), (Item_640, 1), (Item_260, 1), (Item_655, 1), (Item_656, 1), None], [(Item_56, 1), (Item_678, 1), (Item_649, 1), (Item_859, 1), (Item_1138, 1), (Item_155, 1), (Item_276, 1), None], [(Item_243, 1), (Item_245, 1), (Item_247, 1), (Item_1149, 1), (Item_1152, 1), (Item_1151, 1), (Item_382, 1), None], [(Item_384, 1), (Item_386, 1), (Item_407, 1), (Item_510, 1), (Item_1147, 1), (Item_1061, 1), (Item_214, 1), None], [(Item_87, 1), (Item_423, 1), (Item_351, 1), (Item_441, 1), (Item_434, 1), (Item_917, 1), (Item_232, 1), None], [(Item_137, 1), (Item_623, 1), (Item_636, 1), (Item_631, 1), (Item_1168, 1), (Item_954, 1), (Item_658, 1), None], [(Item_641, 1), (Item_9, 6), None]]

    @classmethod
    def create(cls, arg: "Variation_1372.cv_arg") -> 'Variation_1372':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["MRVA"]) -> RuleVariation_32:
        ...
    @overload
    def get_item(self, key : Literal["RAMLD"]) -> RuleVariation_405:
        ...
    @overload
    def get_item(self, key : Literal["RAMHD"]) -> RuleVariation_513:
        ...
    @overload
    def get_item(self, key : Literal["MSAW"]) -> RuleVariation_615:
        ...
    @overload
    def get_item(self, key : Literal["APW"]) -> RuleVariation_694:
        ...
    @overload
    def get_item(self, key : Literal["CLAM"]) -> RuleVariation_800:
        ...
    @overload
    def get_item(self, key : Literal["STCA"]) -> RuleVariation_889:
        ...
    @overload
    def get_item(self, key : Literal["APM"]) -> Optional[RuleVariation_24]:
        ...
    @overload
    def get_item(self, key : Literal["RIMCA"]) -> Optional[RuleVariation_406]:
        ...
    @overload
    def get_item(self, key : Literal["ACASRA"]) -> Optional[RuleVariation_503]:
        ...
    @overload
    def get_item(self, key : Literal["NTCA"]) -> Optional[RuleVariation_620]:
        ...
    @overload
    def get_item(self, key : Literal["DG"]) -> Optional[RuleVariation_700]:
        ...
    @overload
    def get_item(self, key : Literal["OF"]) -> Optional[RuleVariation_804]:
        ...
    @overload
    def get_item(self, key : Literal["OL"]) -> Optional[RuleVariation_886]:
        ...
    @overload
    def get_item(self, key : Literal["AIW"]) -> Optional[RuleVariation_23]:
        ...
    @overload
    def get_item(self, key : Literal["PAIW"]) -> Optional[RuleVariation_404]:
        ...
    @overload
    def get_item(self, key : Literal["OCAT"]) -> Optional[RuleVariation_511]:
        ...
    @overload
    def get_item(self, key : Literal["SAM"]) -> Optional[RuleVariation_621]:
        ...
    @overload
    def get_item(self, key : Literal["VCD"]) -> Optional[RuleVariation_701]:
        ...
    @overload
    def get_item(self, key : Literal["CHAM"]) -> Optional[RuleVariation_799]:
        ...
    @overload
    def get_item(self, key : Literal["DSAM"]) -> Optional[RuleVariation_880]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMARR"]) -> Optional[RuleVariation_27]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMDEP"]) -> Optional[RuleVariation_395]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMTL"]) -> Optional[RuleVariation_505]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMCRM"]) -> Optional[RuleVariation_623]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMVTM"]) -> Optional[RuleVariation_703]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMVRM"]) -> Optional[RuleVariation_811]:
        ...
    @overload
    def get_item(self, key : Literal["HAMHD"]) -> Optional[RuleVariation_883]:
        ...
    @overload
    def get_item(self, key : Literal["HAMRD"]) -> Optional[RuleVariation_29]:
        ...
    @overload
    def get_item(self, key : Literal["HAMVD"]) -> Optional[RuleVariation_398]:
        ...
    @overload
    def get_item(self, key : Literal["HVI"]) -> Optional[RuleVariation_507]:
        ...
    @overload
    def get_item(self, key : Literal["LTW"]) -> Optional[RuleVariation_614]:
        ...
    @overload
    def get_item(self, key : Literal["VPM"]) -> Optional[RuleVariation_702]:
        ...
    @overload
    def get_item(self, key : Literal["TTA"]) -> Optional[RuleVariation_809]:
        ...
    @overload
    def get_item(self, key : Literal["CRA"]) -> Optional[RuleVariation_878]:
        ...
    @overload
    def get_item(self, key : Literal["ASM"]) -> Optional[RuleVariation_25]:
        ...
    @overload
    def get_item(self, key : Literal["IAVM"]) -> Optional[RuleVariation_399]:
        ...
    @overload
    def get_item(self, key : Literal["FTD"]) -> Optional[RuleVariation_506]:
        ...
    @overload
    def get_item(self, key : Literal["ITD"]) -> Optional[RuleVariation_612]:
        ...
    @overload
    def get_item(self, key : Literal["IIA"]) -> Optional[RuleVariation_696]:
        ...
    @overload
    def get_item(self, key : Literal["SQW"]) -> Optional[RuleVariation_806]:
        ...
    @overload
    def get_item(self, key : Literal["CUW"]) -> Optional[RuleVariation_879]:
        ...
    @overload
    def get_item(self, key : Literal["CATC"]) -> Optional[RuleVariation_26]:
        ...
    @overload
    def get_item(self, key : Literal["NOCLR"]) -> Optional[RuleVariation_403]:
        ...
    @overload
    def get_item(self, key : Literal["NOMOV"]) -> Optional[RuleVariation_510]:
        ...
    @overload
    def get_item(self, key : Literal["NOH"]) -> Optional[RuleVariation_619]:
        ...
    @overload
    def get_item(self, key : Literal["WRTY"]) -> Optional[RuleVariation_704]:
        ...
    @overload
    def get_item(self, key : Literal["STOCC"]) -> Optional[RuleVariation_807]:
        ...
    @overload
    def get_item(self, key : Literal["ONGOING"]) -> Optional[RuleVariation_885]:
        ...
    @overload
    def get_item(self, key : Literal["NTZ"]) -> Optional[RuleVariation_34]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1293(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1372.cv_arg
    cv_variation: TypeAlias = Variation_1372

    @classmethod
    def create(cls, arg : "RuleVariation_1293.cv_arg") -> "RuleVariation_1293":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1372:
        return self.arg # type: ignore

class NonSpare_196(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1293.cv_arg
    cv_name = "060"
    cv_title = "Safety Net Function and System Status"
    cv_rule: TypeAlias = RuleVariation_1293

    @classmethod
    def create(cls, arg : "NonSpare_196.cv_arg") -> "NonSpare_196":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1293:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1372:
        return self.rule.variation

class UapItem_196(UapItem):
    cv_non_spare: TypeAlias = NonSpare_196

class NonSpare_1170(NonSpare):
    cv_arg: TypeAlias = RuleVariation_713.cv_arg
    cv_name = "LFP"
    cv_title = "Linear Prediction Filter"
    cv_rule: TypeAlias = RuleVariation_713

    @classmethod
    def create(cls, arg : "NonSpare_1170.cv_arg") -> "NonSpare_1170":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_713:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_724:
        return self.rule.variation

class Item_480(Item):
    cv_arg: TypeAlias = NonSpare_1170.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1170

    @classmethod
    def create(cls, arg : "Item_480.cv_arg") -> "Item_480":
        return cls._create(arg) # type: ignore

class NonSpare_1332(NonSpare):
    cv_arg: TypeAlias = RuleVariation_897.cv_arg
    cv_name = "MSM"
    cv_title = "Mode S Manoeuvre/Prediction Filter"
    cv_rule: TypeAlias = RuleVariation_897

    @classmethod
    def create(cls, arg : "NonSpare_1332.cv_arg") -> "NonSpare_1332":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_897:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_927:
        return self.rule.variation

class Item_596(Item):
    cv_arg: TypeAlias = NonSpare_1332.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1332

    @classmethod
    def create(cls, arg : "Item_596.cv_arg") -> "Item_596":
        return cls._create(arg) # type: ignore

class Variation_1336(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_713.cv_arg, Tuple[Literal["LFP"], RuleVariation_713.cv_arg]], int, Union[RuleVariation_897.cv_arg, Tuple[Literal["MSM"], RuleVariation_897.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1336.cv_arg_group"]
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_items_list = [(Item_480, 1), (Item_23, 1), (Item_596, 1)]
    cv_items_dict = {"LFP": RuleVariation_713, "MSM": RuleVariation_897}

    @overload
    @classmethod
    def spec(cls, key : Literal["LFP"]) -> RuleVariation_713:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MSM"]) -> RuleVariation_897:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["LFP"], Literal["MSM"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["LFP"]) -> RuleVariation_713:
        ...
    @overload
    def get_item(self, key : Literal["MSM"]) -> RuleVariation_897:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1336.cv_arg") -> 'Variation_1336':
        return cls._create(arg) # type: ignore

class RuleVariation_1443(RuleVariationDependent):
    cv_arg: TypeAlias = Union[
        Variation_774.cv_arg,
        Variation_777.cv_arg,
        Variation_798.cv_arg,
        Variation_1337.cv_arg,
        Variation_1338.cv_arg,
        Variation_1338.cv_arg,
        Variation_1338.cv_arg,
        Variation_1338.cv_arg,
        Variation_1338.cv_arg,
        Variation_1338.cv_arg,
        Variation_1338.cv_arg,
        Variation_1338.cv_arg,
        Variation_776.cv_arg,
        Variation_795.cv_arg,
        Variation_796.cv_arg,
        Variation_797.cv_arg,
        Variation_790.cv_arg,
        Variation_778.cv_arg,
        Variation_791.cv_arg,
        Variation_791.cv_arg,
        Variation_782.cv_arg,
        Variation_784.cv_arg,
        Variation_781.cv_arg,
        Variation_792.cv_arg,
        Variation_783.cv_arg,
        Variation_789.cv_arg,
        Variation_793.cv_arg,
        Variation_785.cv_arg,
        Variation_780.cv_arg,
        Variation_786.cv_arg,
        Variation_1336.cv_arg,
    ]
    cv_depends_on = [["000"], ["120", "CC", "TID"]]
    cv_default_variation: TypeAlias = Variation_774
    cv_cases = [
        ([5, 1], Variation_777),
        ([7, 0], Variation_798),
        ([7, 1], Variation_1337),
        ([9, 2], Variation_1338),
        ([10, 2], Variation_1338),
        ([11, 2], Variation_1338),
        ([12, 2], Variation_1338),
        ([13, 2], Variation_1338),
        ([14, 2], Variation_1338),
        ([15, 2], Variation_1338),
        ([16, 2], Variation_1338),
        ([15, 1], Variation_776),
        ([24, 1], Variation_795),
        ([24, 2], Variation_796),
        ([26, 1], Variation_797),
        ([27, 1], Variation_790),
        ([27, 2], Variation_778),
        ([33, 1], Variation_791),
        ([34, 1], Variation_791),
        ([35, 1], Variation_782),
        ([38, 0], Variation_784),
        ([38, 1], Variation_781),
        ([38, 2], Variation_792),
        ([38, 3], Variation_783),
        ([38, 4], Variation_789),
        ([38, 5], Variation_793),
        ([39, 1], Variation_785),
        ([40, 1], Variation_780),
        ([41, 1], Variation_786),
        ([45, 1], Variation_1336),
    ]

    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[5], Literal[1]]) -> Variation_777:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[7], Literal[0]]) -> Variation_798:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[7], Literal[1]]) -> Variation_1337:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[9], Literal[2]]) -> Variation_1338:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[10], Literal[2]]) -> Variation_1338:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[11], Literal[2]]) -> Variation_1338:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[12], Literal[2]]) -> Variation_1338:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[13], Literal[2]]) -> Variation_1338:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[14], Literal[2]]) -> Variation_1338:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[15], Literal[2]]) -> Variation_1338:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[16], Literal[2]]) -> Variation_1338:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[15], Literal[1]]) -> Variation_776:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[24], Literal[1]]) -> Variation_795:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[24], Literal[2]]) -> Variation_796:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[26], Literal[1]]) -> Variation_797:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[27], Literal[1]]) -> Variation_790:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[27], Literal[2]]) -> Variation_778:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[33], Literal[1]]) -> Variation_791:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[34], Literal[1]]) -> Variation_791:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[35], Literal[1]]) -> Variation_782:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[0]]) -> Variation_784:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[1]]) -> Variation_781:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[2]]) -> Variation_792:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[3]]) -> Variation_783:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[4]]) -> Variation_789:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[5]]) -> Variation_793:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[39], Literal[1]]) -> Variation_785:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[40], Literal[1]]) -> Variation_780:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[41], Literal[1]]) -> Variation_786:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[45], Literal[1]]) -> Variation_1336:
        ...

    @classmethod
    def variation(cls, key : Any) -> Any:
        return cls._variation(key)

    @classmethod
    def create(cls, arg : "RuleVariation_1443.cv_arg") -> "RuleVariation_1443":
        return cls._create(arg) # type: ignore

class NonSpare_818(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1443.cv_arg
    cv_name = "CPC"
    cv_title = "Conflict Properties Class"
    cv_rule: TypeAlias = RuleVariation_1443

    @classmethod
    def create(cls, arg : "NonSpare_818.cv_arg") -> "NonSpare_818":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1443:
        return self.arg # type: ignore

class Item_208(Item):
    cv_arg: TypeAlias = NonSpare_818.cv_arg
    cv_non_spare: TypeAlias = NonSpare_818

    @classmethod
    def create(cls, arg : "Item_208.cv_arg") -> "Item_208":
        return cls._create(arg) # type: ignore

class Variation_1225(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_132.cv_arg, Tuple[Literal["TID"], RuleVariation_132.cv_arg]], Union[RuleVariation_1443.cv_arg, Tuple[Literal["CPC"], RuleVariation_1443.cv_arg]], Union[RuleVariation_952.cv_arg, Tuple[Literal["CS"], RuleVariation_952.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1225.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_998, 4), (Item_208, 3), (Item_219, 1)]
    cv_items_dict = {"TID": RuleVariation_132, "CPC": RuleVariation_1443, "CS": RuleVariation_952}

    @overload
    @classmethod
    def spec(cls, key : Literal["TID"]) -> RuleVariation_132:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPC"]) -> RuleVariation_1443:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CS"]) -> RuleVariation_952:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["TID"], Literal["CPC"], Literal["CS"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["TID"]) -> RuleVariation_132:
        ...
    @overload
    def get_item(self, key : Literal["CPC"]) -> RuleVariation_1443:
        ...
    @overload
    def get_item(self, key : Literal["CS"]) -> RuleVariation_952:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1225.cv_arg") -> 'Variation_1225':
        return cls._create(arg) # type: ignore

class RuleVariation_1165(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1225.cv_arg
    cv_variation: TypeAlias = Variation_1225

    @classmethod
    def create(cls, arg : "RuleVariation_1165.cv_arg") -> "RuleVariation_1165":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1225:
        return self.arg # type: ignore

class NonSpare_711(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1165.cv_arg
    cv_name = "CC"
    cv_title = "Conflict Classification"
    cv_rule: TypeAlias = RuleVariation_1165

    @classmethod
    def create(cls, arg : "NonSpare_711.cv_arg") -> "NonSpare_711":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1165:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1225:
        return self.rule.variation

class Variation_1480(Compound):
    cv_arg = TypedDict('cv_arg', {
        "CN": NonSpare_746.cv_arg,
        "CC": NonSpare_711.cv_arg,
        "CP": NonSpare_815.cv_arg,
        "CD": NonSpare_713.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 1
    cv_items_list = [NonSpare_746, NonSpare_711, NonSpare_815, NonSpare_713]
    cv_items_dict = {"CN": NonSpare_746, "CC": NonSpare_711, "CP": NonSpare_815, "CD": NonSpare_713}

    @overload
    @classmethod
    def spec(cls, key : Literal["CN"]) -> NonSpare_746:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CC"]) -> NonSpare_711:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CP"]) -> NonSpare_815:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CD"]) -> NonSpare_713:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["CN"], Literal["CC"], Literal["CP"], Literal["CD"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["CN"]) -> Optional[NonSpare_746]:
        ...
    @overload
    def get_item(self, key : Literal["CC"]) -> Optional[NonSpare_711]:
        ...
    @overload
    def get_item(self, key : Literal["CP"]) -> Optional[NonSpare_815]:
        ...
    @overload
    def get_item(self, key : Literal["CD"]) -> Optional[NonSpare_713]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["CN"], val : NonSpare_746.cv_arg) -> "Variation_1480":
        ...
    @overload
    def set_item(self, key : Literal["CC"], val : NonSpare_711.cv_arg) -> "Variation_1480":
        ...
    @overload
    def set_item(self, key : Literal["CP"], val : NonSpare_815.cv_arg) -> "Variation_1480":
        ...
    @overload
    def set_item(self, key : Literal["CD"], val : NonSpare_713.cv_arg) -> "Variation_1480":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["CN"]) -> "Variation_1480":
        ...
    @overload
    def del_item(self, key : Literal["CC"]) -> "Variation_1480":
        ...
    @overload
    def del_item(self, key : Literal["CP"]) -> "Variation_1480":
        ...
    @overload
    def del_item(self, key : Literal["CD"]) -> "Variation_1480":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1480.cv_arg") -> 'Variation_1480':
        return cls._create(arg) # type: ignore

class RuleVariation_1401(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1480.cv_arg
    cv_variation: TypeAlias = Variation_1480

    @classmethod
    def create(cls, arg : "RuleVariation_1401.cv_arg") -> "RuleVariation_1401":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1480:
        return self.arg # type: ignore

class NonSpare_298(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1401.cv_arg
    cv_name = "120"
    cv_title = "Conflict Characteristics"
    cv_rule: TypeAlias = RuleVariation_1401

    @classmethod
    def create(cls, arg : "NonSpare_298.cv_arg") -> "NonSpare_298":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1401:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1480:
        return self.rule.variation

class UapItem_298(UapItem):
    cv_non_spare: TypeAlias = NonSpare_298

class Record_13(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_34.cv_arg,
        "000": NonSpare_2.cv_arg,
        "015": NonSpare_58.cv_arg,
        "020": NonSpare_93.cv_arg,
        "040": NonSpare_136.cv_arg,
        "045": NonSpare_164.cv_arg,
        "060": NonSpare_196.cv_arg,
        "030": NonSpare_114.cv_arg,
        "170": NonSpare_370.cv_arg,
        "120": NonSpare_298.cv_arg,
        "070": NonSpare_204.cv_arg,
        "076": NonSpare_230.cv_arg,
        "074": NonSpare_225.cv_arg,
        "075": NonSpare_228.cv_arg,
        "100": NonSpare_267.cv_arg,
        "035": NonSpare_130.cv_arg,
        "171": NonSpare_382.cv_arg,
        "110": NonSpare_286.cv_arg,
        "RE": NonSpare_1568.cv_arg,
        "SP": NonSpare_1732.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 3
    cv_items_list = [UapItem_34, UapItem_2, UapItem_58, UapItem_93, UapItem_136, UapItem_164, UapItem_196, UapItem_114, UapItem_370, UapItem_298, UapItem_204, UapItem_230, UapItem_225, UapItem_228, UapItem_267, UapItem_130, UapItem_382, UapItem_286, UapItem_549, UapItem_547, UapItem_548]
    cv_items_dict = {"010": NonSpare_34, "000": NonSpare_2, "015": NonSpare_58, "020": NonSpare_93, "040": NonSpare_136, "045": NonSpare_164, "060": NonSpare_196, "030": NonSpare_114, "170": NonSpare_370, "120": NonSpare_298, "070": NonSpare_204, "076": NonSpare_230, "074": NonSpare_225, "075": NonSpare_228, "100": NonSpare_267, "035": NonSpare_130, "171": NonSpare_382, "110": NonSpare_286, "RE": NonSpare_1568, "SP": NonSpare_1732}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_34:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> NonSpare_2:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["015"]) -> NonSpare_58:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_93:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> NonSpare_136:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["045"]) -> NonSpare_164:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_196:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> NonSpare_114:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["170"]) -> NonSpare_370:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> NonSpare_298:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> NonSpare_204:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["076"]) -> NonSpare_230:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["074"]) -> NonSpare_225:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["075"]) -> NonSpare_228:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_267:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["035"]) -> NonSpare_130:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["171"]) -> NonSpare_382:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["110"]) -> NonSpare_286:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["RE"]) -> NonSpare_1568:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1732:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["015"], Literal["020"], Literal["040"], Literal["045"], Literal["060"], Literal["030"], Literal["170"], Literal["120"], Literal["070"], Literal["076"], Literal["074"], Literal["075"], Literal["100"], Literal["035"], Literal["171"], Literal["110"], Literal["RE"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_34]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_2]:
        ...
    @overload
    def get_item(self, key : Literal["015"]) -> Optional[NonSpare_58]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_93]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_136]:
        ...
    @overload
    def get_item(self, key : Literal["045"]) -> Optional[NonSpare_164]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_196]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_114]:
        ...
    @overload
    def get_item(self, key : Literal["170"]) -> Optional[NonSpare_370]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_298]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_204]:
        ...
    @overload
    def get_item(self, key : Literal["076"]) -> Optional[NonSpare_230]:
        ...
    @overload
    def get_item(self, key : Literal["074"]) -> Optional[NonSpare_225]:
        ...
    @overload
    def get_item(self, key : Literal["075"]) -> Optional[NonSpare_228]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_267]:
        ...
    @overload
    def get_item(self, key : Literal["035"]) -> Optional[NonSpare_130]:
        ...
    @overload
    def get_item(self, key : Literal["171"]) -> Optional[NonSpare_382]:
        ...
    @overload
    def get_item(self, key : Literal["110"]) -> Optional[NonSpare_286]:
        ...
    @overload
    def get_item(self, key : Literal["RE"]) -> Optional[NonSpare_1568]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1732]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_34.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_2.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["015"], val : NonSpare_58.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_93.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_136.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["045"], val : NonSpare_164.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_196.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_114.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["170"], val : NonSpare_370.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_298.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_204.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["076"], val : NonSpare_230.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["074"], val : NonSpare_225.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["075"], val : NonSpare_228.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_267.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["035"], val : NonSpare_130.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["171"], val : NonSpare_382.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["110"], val : NonSpare_286.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["RE"], val : NonSpare_1568.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1732.cv_arg) -> 'Record_13':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["015"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["045"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["170"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["076"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["074"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["075"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["035"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["171"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["110"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["RE"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_13':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Record_13.cv_arg") -> 'Record_13':
        return cls._create(arg) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_13", Bits]]:
        return cls._parse(bs) # type: ignore

class Uap_13(UapSingle):
    cv_arg: TypeAlias = Record_13
    cv_record: TypeAlias = Record_13

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_13]]:
        return cls._parse(bs)

class Asterix_7(AstCat):
    cv_category = 4
    cv_edition = (1, 13)
    cv_uap: TypeAlias = Uap_13
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_13.cv_arg]) -> "Asterix_7":
        return cls._create(records) # type: ignore

class Content_592(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Polar vector", 2: "Cartesian vector of start point/length", 3: "Contour record", 4: "Cartesian start point and end point vector", 254: "SOP message", 255: "EOP message"}

class RuleContent_592(RuleContentContextFree):
    cv_arg: TypeAlias = Content_592.cv_arg
    cv_content: TypeAlias = Content_592

    @property
    def content(self) -> Content_592:
        return self._get_content() # type: ignore

class Variation_192(Element):
    cv_arg: TypeAlias = RuleContent_592.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_592

    @classmethod
    def create(cls, arg: "Variation_192.cv_arg") -> "Variation_192":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_592:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_592:
        return self.rule.content

class RuleVariation_185(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_192.cv_arg
    cv_variation: TypeAlias = Variation_192

    @classmethod
    def create(cls, arg : "RuleVariation_185.cv_arg") -> "RuleVariation_185":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_192:
        return self.arg # type: ignore

class NonSpare_8(NonSpare):
    cv_arg: TypeAlias = RuleVariation_185.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_185

    @classmethod
    def create(cls, arg : "NonSpare_8.cv_arg") -> "NonSpare_8":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_185:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_192:
        return self.rule.variation

class UapItem_8(UapItem):
    cv_non_spare: TypeAlias = NonSpare_8

class Content_259(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Local Coordinates", 1: "System Coordinates"}

class RuleContent_259(RuleContentContextFree):
    cv_arg: TypeAlias = Content_259.cv_arg
    cv_content: TypeAlias = Content_259

    @property
    def content(self) -> Content_259:
        return self._get_content() # type: ignore

class Variation_52(Element):
    cv_arg: TypeAlias = RuleContent_259.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_259

    @classmethod
    def create(cls, arg: "Variation_52.cv_arg") -> "Variation_52":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_259:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_259:
        return self.rule.content

class RuleVariation_52(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_52.cv_arg
    cv_variation: TypeAlias = Variation_52

    @classmethod
    def create(cls, arg : "RuleVariation_52.cv_arg") -> "RuleVariation_52":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_52:
        return self.arg # type: ignore

class Variation_488(Element):
    cv_arg: TypeAlias = RuleContent_613.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 3
    cv_rule = RuleContent_613

    @classmethod
    def create(cls, arg: "Variation_488.cv_arg") -> "Variation_488":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_613:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_613:
        return self.rule.content

class RuleVariation_477(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_488.cv_arg
    cv_variation: TypeAlias = Variation_488

    @classmethod
    def create(cls, arg : "RuleVariation_477.cv_arg") -> "RuleVariation_477":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_488:
        return self.arg # type: ignore

class Content_2(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "0°", 1: "22.5°", 2: "45°", 3: "67.5°", 4: "90°", 5: "112.5°", 6: "135°", 7: "157.5°"}

class RuleContent_2(RuleContentContextFree):
    cv_arg: TypeAlias = Content_2.cv_arg
    cv_content: TypeAlias = Content_2

    @property
    def content(self) -> Content_2:
        return self._get_content() # type: ignore

class Variation_775(Element):
    cv_arg: TypeAlias = RuleContent_2.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_2

    @classmethod
    def create(cls, arg: "Variation_775.cv_arg") -> "Variation_775":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_2:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_2:
        return self.rule.content

class RuleVariation_764(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_775.cv_arg
    cv_variation: TypeAlias = Variation_775

    @classmethod
    def create(cls, arg : "RuleVariation_764.cv_arg") -> "RuleVariation_764":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_775:
        return self.arg # type: ignore

class Content_157(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Test vector"}

class RuleContent_157(RuleContentContextFree):
    cv_arg: TypeAlias = Content_157.cv_arg
    cv_content: TypeAlias = Content_157

    @property
    def content(self) -> Content_157:
        return self._get_content() # type: ignore

class Variation_840(Element):
    cv_arg: TypeAlias = RuleContent_157.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_157

    @classmethod
    def create(cls, arg: "Variation_840.cv_arg") -> "Variation_840":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_157:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_157:
        return self.rule.content

class RuleVariation_810(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_840.cv_arg
    cv_variation: TypeAlias = Variation_840

    @classmethod
    def create(cls, arg : "RuleVariation_810.cv_arg") -> "RuleVariation_810":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_840:
        return self.arg # type: ignore

class Content_95(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Error condition encountered"}

class RuleContent_95(RuleContentContextFree):
    cv_arg: TypeAlias = Content_95.cv_arg
    cv_content: TypeAlias = Content_95

    @property
    def content(self) -> Content_95:
        return self._get_content() # type: ignore

class Variation_911(Element):
    cv_arg: TypeAlias = RuleContent_95.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_95

    @classmethod
    def create(cls, arg: "Variation_911.cv_arg") -> "Variation_911":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_95:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_95:
        return self.rule.content

class RuleVariation_881(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_911.cv_arg
    cv_variation: TypeAlias = Variation_911

    @classmethod
    def create(cls, arg : "RuleVariation_881.cv_arg") -> "RuleVariation_881":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_911:
        return self.arg # type: ignore

class NonSpare_1402(NonSpare):
    cv_arg: TypeAlias = RuleVariation_52.cv_arg
    cv_name = "ORG"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_52

    @classmethod
    def create(cls, arg : "NonSpare_1402.cv_arg") -> "NonSpare_1402":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_52:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_52:
        return self.rule.variation

class Item_661(Item):
    cv_arg: TypeAlias = NonSpare_1402.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1402

    @classmethod
    def create(cls, arg : "Item_661.cv_arg") -> "Item_661":
        return cls._create(arg) # type: ignore

class NonSpare_1087(NonSpare):
    cv_arg: TypeAlias = RuleVariation_477.cv_arg
    cv_name = "I"
    cv_title = "Intensity Level"
    cv_rule: TypeAlias = RuleVariation_477

    @classmethod
    def create(cls, arg : "NonSpare_1087.cv_arg") -> "NonSpare_1087":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_477:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_488:
        return self.rule.variation

class Item_409(Item):
    cv_arg: TypeAlias = NonSpare_1087.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1087

    @classmethod
    def create(cls, arg : "Item_409.cv_arg") -> "Item_409":
        return cls._create(arg) # type: ignore

class NonSpare_1647(NonSpare):
    cv_arg: TypeAlias = RuleVariation_764.cv_arg
    cv_name = "S"
    cv_title = "Shading Orientation with Respect to North"
    cv_rule: TypeAlias = RuleVariation_764

    @classmethod
    def create(cls, arg : "NonSpare_1647.cv_arg") -> "NonSpare_1647":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_764:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_775:
        return self.rule.variation

class Item_850(Item):
    cv_arg: TypeAlias = NonSpare_1647.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1647

    @classmethod
    def create(cls, arg : "Item_850.cv_arg") -> "Item_850":
        return cls._create(arg) # type: ignore

class NonSpare_1936(NonSpare):
    cv_arg: TypeAlias = RuleVariation_810.cv_arg
    cv_name = "TST"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_810

    @classmethod
    def create(cls, arg : "NonSpare_1936.cv_arg") -> "NonSpare_1936":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_810:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_840:
        return self.rule.variation

class Item_1053(Item):
    cv_arg: TypeAlias = NonSpare_1936.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1936

    @classmethod
    def create(cls, arg : "Item_1053.cv_arg") -> "Item_1053":
        return cls._create(arg) # type: ignore

class NonSpare_956(NonSpare):
    cv_arg: TypeAlias = RuleVariation_881.cv_arg
    cv_name = "ER"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_881

    @classmethod
    def create(cls, arg : "NonSpare_956.cv_arg") -> "NonSpare_956":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_881:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_911:
        return self.rule.variation

class Item_317(Item):
    cv_arg: TypeAlias = NonSpare_956.cv_arg
    cv_non_spare: TypeAlias = NonSpare_956

    @classmethod
    def create(cls, arg : "Item_317.cv_arg") -> "Item_317":
        return cls._create(arg) # type: ignore

class Variation_1379(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_52.cv_arg, Tuple[Literal["ORG"], RuleVariation_52.cv_arg]], Union[RuleVariation_477.cv_arg, Tuple[Literal["I"], RuleVariation_477.cv_arg]], Union[RuleVariation_764.cv_arg, Tuple[Literal["S"], RuleVariation_764.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[int, Union[RuleVariation_810.cv_arg, Tuple[Literal["TST"], RuleVariation_810.cv_arg]], Union[RuleVariation_881.cv_arg, Tuple[Literal["ER"], RuleVariation_881.cv_arg]], None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1379.cv_arg_group_1"],
        Tuple["Variation_1379.cv_arg_group_1", "Variation_1379.cv_arg_group_2"],
    ]
    cv_items_list = [[(Item_661, 1), (Item_409, 3), (Item_850, 3), None], [(Item_4, 5), (Item_1053, 1), (Item_317, 1), None]]

    @classmethod
    def create(cls, arg: "Variation_1379.cv_arg") -> 'Variation_1379':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["ORG"]) -> RuleVariation_52:
        ...
    @overload
    def get_item(self, key : Literal["I"]) -> RuleVariation_477:
        ...
    @overload
    def get_item(self, key : Literal["S"]) -> RuleVariation_764:
        ...
    @overload
    def get_item(self, key : Literal["TST"]) -> Optional[RuleVariation_810]:
        ...
    @overload
    def get_item(self, key : Literal["ER"]) -> Optional[RuleVariation_881]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1300(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1379.cv_arg
    cv_variation: TypeAlias = Variation_1379

    @classmethod
    def create(cls, arg : "RuleVariation_1300.cv_arg") -> "RuleVariation_1300":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1379:
        return self.arg # type: ignore

class NonSpare_96(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1300.cv_arg
    cv_name = "020"
    cv_title = "Vector Qualifier"
    cv_rule: TypeAlias = RuleVariation_1300

    @classmethod
    def create(cls, arg : "NonSpare_96.cv_arg") -> "NonSpare_96":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1300:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1379:
        return self.rule.variation

class UapItem_96(UapItem):
    cv_non_spare: TypeAlias = NonSpare_96

class Content_612(ContentInteger):
    cv_arg: TypeAlias = int
    cv_signedness: TypeAlias = Signed

class RuleContent_612(RuleContentContextFree):
    cv_arg: TypeAlias = Content_612.cv_arg
    cv_content: TypeAlias = Content_612

    @property
    def content(self) -> Content_612:
        return self._get_content() # type: ignore

class Variation_204(Element):
    cv_arg: TypeAlias = RuleContent_612.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_612

    @classmethod
    def create(cls, arg: "Variation_204.cv_arg") -> "Variation_204":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_612:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_612:
        return self.rule.content

class RuleVariation_197(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_204.cv_arg
    cv_variation: TypeAlias = Variation_204

    @classmethod
    def create(cls, arg : "RuleVariation_197.cv_arg") -> "RuleVariation_197":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_204:
        return self.arg # type: ignore

class NonSpare_2097(NonSpare):
    cv_arg: TypeAlias = RuleVariation_197.cv_arg
    cv_name = "X"
    cv_title = "X-Component"
    cv_rule: TypeAlias = RuleVariation_197

    @classmethod
    def create(cls, arg : "NonSpare_2097.cv_arg") -> "NonSpare_2097":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_197:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_204:
        return self.rule.variation

class Item_1198(Item):
    cv_arg: TypeAlias = NonSpare_2097.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2097

    @classmethod
    def create(cls, arg : "Item_1198.cv_arg") -> "Item_1198":
        return cls._create(arg) # type: ignore

class NonSpare_2151(NonSpare):
    cv_arg: TypeAlias = RuleVariation_197.cv_arg
    cv_name = "Y"
    cv_title = "Y-Component"
    cv_rule: TypeAlias = RuleVariation_197

    @classmethod
    def create(cls, arg : "NonSpare_2151.cv_arg") -> "NonSpare_2151":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_197:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_204:
        return self.rule.variation

class Item_1249(Item):
    cv_arg: TypeAlias = NonSpare_2151.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2151

    @classmethod
    def create(cls, arg : "Item_1249.cv_arg") -> "Item_1249":
        return cls._create(arg) # type: ignore

class Variation_205(Element):
    cv_arg: TypeAlias = RuleContent_613.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_613

    @classmethod
    def create(cls, arg: "Variation_205.cv_arg") -> "Variation_205":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_613:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_613:
        return self.rule.content

class RuleVariation_198(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_205.cv_arg
    cv_variation: TypeAlias = Variation_205

    @classmethod
    def create(cls, arg : "RuleVariation_198.cv_arg") -> "RuleVariation_198":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_205:
        return self.arg # type: ignore

class NonSpare_1169(NonSpare):
    cv_arg: TypeAlias = RuleVariation_198.cv_arg
    cv_name = "LENGTH"
    cv_title = "Length"
    cv_rule: TypeAlias = RuleVariation_198

    @classmethod
    def create(cls, arg : "NonSpare_1169.cv_arg") -> "NonSpare_1169":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_198:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_205:
        return self.rule.variation

class Item_479(Item):
    cv_arg: TypeAlias = NonSpare_1169.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1169

    @classmethod
    def create(cls, arg : "Item_479.cv_arg") -> "Item_479":
        return cls._create(arg) # type: ignore

class Variation_1311(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_197.cv_arg, Tuple[Literal["X"], RuleVariation_197.cv_arg]], Union[RuleVariation_197.cv_arg, Tuple[Literal["Y"], RuleVariation_197.cv_arg]], Union[RuleVariation_198.cv_arg, Tuple[Literal["LENGTH"], RuleVariation_198.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1311.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_items_list = [(Item_1198, 8), (Item_1249, 8), (Item_479, 8)]
    cv_items_dict = {"X": RuleVariation_197, "Y": RuleVariation_197, "LENGTH": RuleVariation_198}

    @overload
    @classmethod
    def spec(cls, key : Literal["X"]) -> RuleVariation_197:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y"]) -> RuleVariation_197:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["LENGTH"]) -> RuleVariation_198:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X"], Literal["Y"], Literal["LENGTH"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X"]) -> RuleVariation_197:
        ...
    @overload
    def get_item(self, key : Literal["Y"]) -> RuleVariation_197:
        ...
    @overload
    def get_item(self, key : Literal["LENGTH"]) -> RuleVariation_198:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1311.cv_arg") -> 'Variation_1311':
        return cls._create(arg) # type: ignore

class Variation_1450(Repetitive):
    cv_arg: TypeAlias = List[Variation_1311.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1311

    @classmethod
    def create(cls, arg: "Variation_1450.cv_arg") -> 'Variation_1450':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1311]:
        return self._get_list() # type: ignore

class RuleVariation_1371(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1450.cv_arg
    cv_variation: TypeAlias = Variation_1450

    @classmethod
    def create(cls, arg : "RuleVariation_1371.cv_arg") -> "RuleVariation_1371":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1450:
        return self.arg # type: ignore

class NonSpare_133(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1371.cv_arg
    cv_name = "036"
    cv_title = "Sequence of Cartesian Vectors in SPF Notation"
    cv_rule: TypeAlias = RuleVariation_1371

    @classmethod
    def create(cls, arg : "NonSpare_133.cv_arg") -> "NonSpare_133":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1371:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1450:
        return self.rule.variation

class UapItem_133(UapItem):
    cv_non_spare: TypeAlias = NonSpare_133

class NonSpare_1797(NonSpare):
    cv_arg: TypeAlias = RuleVariation_198.cv_arg
    cv_name = "STR"
    cv_title = "Start Range"
    cv_rule: TypeAlias = RuleVariation_198

    @classmethod
    def create(cls, arg : "NonSpare_1797.cv_arg") -> "NonSpare_1797":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_198:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_205:
        return self.rule.variation

class Item_957(Item):
    cv_arg: TypeAlias = NonSpare_1797.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1797

    @classmethod
    def create(cls, arg : "Item_957.cv_arg") -> "Item_957":
        return cls._create(arg) # type: ignore

class NonSpare_935(NonSpare):
    cv_arg: TypeAlias = RuleVariation_198.cv_arg
    cv_name = "ENDR"
    cv_title = "End Range"
    cv_rule: TypeAlias = RuleVariation_198

    @classmethod
    def create(cls, arg : "NonSpare_935.cv_arg") -> "NonSpare_935":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_198:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_205:
        return self.rule.variation

class Item_296(Item):
    cv_arg: TypeAlias = NonSpare_935.cv_arg
    cv_non_spare: TypeAlias = NonSpare_935

    @classmethod
    def create(cls, arg : "Item_296.cv_arg") -> "Item_296":
        return cls._create(arg) # type: ignore

class NonSpare_663(NonSpare):
    cv_arg: TypeAlias = RuleVariation_336.cv_arg
    cv_name = "AZ"
    cv_title = "Azimuth"
    cv_rule: TypeAlias = RuleVariation_336

    @classmethod
    def create(cls, arg : "NonSpare_663.cv_arg") -> "NonSpare_663":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_336:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_343:
        return self.rule.variation

class Item_106(Item):
    cv_arg: TypeAlias = NonSpare_663.cv_arg
    cv_non_spare: TypeAlias = NonSpare_663

    @classmethod
    def create(cls, arg : "Item_106.cv_arg") -> "Item_106":
        return cls._create(arg) # type: ignore

class Variation_1219(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_198.cv_arg, Tuple[Literal["STR"], RuleVariation_198.cv_arg]], Union[RuleVariation_198.cv_arg, Tuple[Literal["ENDR"], RuleVariation_198.cv_arg]], Union[RuleVariation_336.cv_arg, Tuple[Literal["AZ"], RuleVariation_336.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1219.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_957, 8), (Item_296, 8), (Item_106, 16)]
    cv_items_dict = {"STR": RuleVariation_198, "ENDR": RuleVariation_198, "AZ": RuleVariation_336}

    @overload
    @classmethod
    def spec(cls, key : Literal["STR"]) -> RuleVariation_198:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ENDR"]) -> RuleVariation_198:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AZ"]) -> RuleVariation_336:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["STR"], Literal["ENDR"], Literal["AZ"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["STR"]) -> RuleVariation_198:
        ...
    @overload
    def get_item(self, key : Literal["ENDR"]) -> RuleVariation_198:
        ...
    @overload
    def get_item(self, key : Literal["AZ"]) -> RuleVariation_336:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1219.cv_arg") -> 'Variation_1219':
        return cls._create(arg) # type: ignore

class Variation_1434(Repetitive):
    cv_arg: TypeAlias = List[Variation_1219.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1219

    @classmethod
    def create(cls, arg: "Variation_1434.cv_arg") -> 'Variation_1434':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1219]:
        return self._get_list() # type: ignore

class RuleVariation_1355(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1434.cv_arg
    cv_variation: TypeAlias = Variation_1434

    @classmethod
    def create(cls, arg : "RuleVariation_1355.cv_arg") -> "RuleVariation_1355":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1434:
        return self.arg # type: ignore

class NonSpare_128(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1355.cv_arg
    cv_name = "034"
    cv_title = "Sequence of Polar Vectors in SPF Notation"
    cv_rule: TypeAlias = RuleVariation_1355

    @classmethod
    def create(cls, arg : "NonSpare_128.cv_arg") -> "NonSpare_128":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1355:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1434:
        return self.rule.variation

class UapItem_128(UapItem):
    cv_non_spare: TypeAlias = NonSpare_128

class Variation_482(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 3
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_482.cv_arg") -> "Variation_482":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_471(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_482.cv_arg
    cv_variation: TypeAlias = Variation_482

    @classmethod
    def create(cls, arg : "RuleVariation_471.cv_arg") -> "RuleVariation_471":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_482:
        return self.arg # type: ignore

class NonSpare_1086(NonSpare):
    cv_arg: TypeAlias = RuleVariation_471.cv_arg
    cv_name = "I"
    cv_title = "Intensity Level"
    cv_rule: TypeAlias = RuleVariation_471

    @classmethod
    def create(cls, arg : "NonSpare_1086.cv_arg") -> "NonSpare_1086":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_471:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_482:
        return self.rule.variation

class Item_408(Item):
    cv_arg: TypeAlias = NonSpare_1086.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1086

    @classmethod
    def create(cls, arg : "Item_408.cv_arg") -> "Item_408":
        return cls._create(arg) # type: ignore

class Item_20(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 4
    cv_bit_size = 2

class Content_247(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Intermediate record of a contour", 1: "Last record of a contour of at least two records", 2: "First record of a contour of at least two records", 3: "First and only record, fully defining a contour"}

class RuleContent_247(RuleContentContextFree):
    cv_arg: TypeAlias = Content_247.cv_arg
    cv_content: TypeAlias = Content_247

    @property
    def content(self) -> Content_247:
        return self._get_content() # type: ignore

class Variation_961(Element):
    cv_arg: TypeAlias = RuleContent_247.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 2
    cv_rule = RuleContent_247

    @classmethod
    def create(cls, arg: "Variation_961.cv_arg") -> "Variation_961":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_247:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_247:
        return self.rule.content

class RuleVariation_931(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_961.cv_arg
    cv_variation: TypeAlias = Variation_961

    @classmethod
    def create(cls, arg : "RuleVariation_931.cv_arg") -> "RuleVariation_931":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_961:
        return self.arg # type: ignore

class NonSpare_1004(NonSpare):
    cv_arg: TypeAlias = RuleVariation_931.cv_arg
    cv_name = "FSTLST"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_931

    @classmethod
    def create(cls, arg : "NonSpare_1004.cv_arg") -> "NonSpare_1004":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_931:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_961:
        return self.rule.variation

class Item_350(Item):
    cv_arg: TypeAlias = NonSpare_1004.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1004

    @classmethod
    def create(cls, arg : "Item_350.cv_arg") -> "Item_350":
        return cls._create(arg) # type: ignore

class NonSpare_836(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "CSN"
    cv_title = "Contour Serial Number"
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_836.cv_arg") -> "NonSpare_836":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class Item_220(Item):
    cv_arg: TypeAlias = NonSpare_836.cv_arg
    cv_non_spare: TypeAlias = NonSpare_836

    @classmethod
    def create(cls, arg : "Item_220.cv_arg") -> "Item_220":
        return cls._create(arg) # type: ignore

class Variation_1156(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_52.cv_arg, Tuple[Literal["ORG"], RuleVariation_52.cv_arg]], Union[RuleVariation_471.cv_arg, Tuple[Literal["I"], RuleVariation_471.cv_arg]], int, Union[RuleVariation_931.cv_arg, Tuple[Literal["FSTLST"], RuleVariation_931.cv_arg]], Union[RuleVariation_159.cv_arg, Tuple[Literal["CSN"], RuleVariation_159.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1156.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_661, 1), (Item_408, 3), (Item_20, 2), (Item_350, 2), (Item_220, 8)]
    cv_items_dict = {"ORG": RuleVariation_52, "I": RuleVariation_471, "FSTLST": RuleVariation_931, "CSN": RuleVariation_159}

    @overload
    @classmethod
    def spec(cls, key : Literal["ORG"]) -> RuleVariation_52:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["I"]) -> RuleVariation_471:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["FSTLST"]) -> RuleVariation_931:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CSN"]) -> RuleVariation_159:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["ORG"], Literal["I"], Literal["FSTLST"], Literal["CSN"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["ORG"]) -> RuleVariation_52:
        ...
    @overload
    def get_item(self, key : Literal["I"]) -> RuleVariation_471:
        ...
    @overload
    def get_item(self, key : Literal["FSTLST"]) -> RuleVariation_931:
        ...
    @overload
    def get_item(self, key : Literal["CSN"]) -> RuleVariation_159:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1156.cv_arg") -> 'Variation_1156':
        return cls._create(arg) # type: ignore

class RuleVariation_1109(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1156.cv_arg
    cv_variation: TypeAlias = Variation_1156

    @classmethod
    def create(cls, arg : "RuleVariation_1109.cv_arg") -> "RuleVariation_1109":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1156:
        return self.arg # type: ignore

class NonSpare_137(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1109.cv_arg
    cv_name = "040"
    cv_title = "Contour Identifier"
    cv_rule: TypeAlias = RuleVariation_1109

    @classmethod
    def create(cls, arg : "NonSpare_137.cv_arg") -> "NonSpare_137":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1109:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1156:
        return self.rule.variation

class UapItem_137(UapItem):
    cv_non_spare: TypeAlias = NonSpare_137

class NonSpare_2104(NonSpare):
    cv_arg: TypeAlias = RuleVariation_197.cv_arg
    cv_name = "X1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_197

    @classmethod
    def create(cls, arg : "NonSpare_2104.cv_arg") -> "NonSpare_2104":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_197:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_204:
        return self.rule.variation

class Item_1205(Item):
    cv_arg: TypeAlias = NonSpare_2104.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2104

    @classmethod
    def create(cls, arg : "Item_1205.cv_arg") -> "Item_1205":
        return cls._create(arg) # type: ignore

class NonSpare_2158(NonSpare):
    cv_arg: TypeAlias = RuleVariation_197.cv_arg
    cv_name = "Y1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_197

    @classmethod
    def create(cls, arg : "NonSpare_2158.cv_arg") -> "NonSpare_2158":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_197:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_204:
        return self.rule.variation

class Item_1256(Item):
    cv_arg: TypeAlias = NonSpare_2158.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2158

    @classmethod
    def create(cls, arg : "Item_1256.cv_arg") -> "Item_1256":
        return cls._create(arg) # type: ignore

class Variation_1318(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_197.cv_arg, Tuple[Literal["X1"], RuleVariation_197.cv_arg]], Union[RuleVariation_197.cv_arg, Tuple[Literal["Y1"], RuleVariation_197.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1318.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_1205, 8), (Item_1256, 8)]
    cv_items_dict = {"X1": RuleVariation_197, "Y1": RuleVariation_197}

    @overload
    @classmethod
    def spec(cls, key : Literal["X1"]) -> RuleVariation_197:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y1"]) -> RuleVariation_197:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X1"], Literal["Y1"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X1"]) -> RuleVariation_197:
        ...
    @overload
    def get_item(self, key : Literal["Y1"]) -> RuleVariation_197:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1318.cv_arg") -> 'Variation_1318':
        return cls._create(arg) # type: ignore

class Variation_1452(Repetitive):
    cv_arg: TypeAlias = List[Variation_1318.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1318

    @classmethod
    def create(cls, arg: "Variation_1452.cv_arg") -> 'Variation_1452':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1318]:
        return self._get_list() # type: ignore

class RuleVariation_1373(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1452.cv_arg
    cv_variation: TypeAlias = Variation_1452

    @classmethod
    def create(cls, arg : "RuleVariation_1373.cv_arg") -> "RuleVariation_1373":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1452:
        return self.arg # type: ignore

class NonSpare_178(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1373.cv_arg
    cv_name = "050"
    cv_title = "Sequence of Contour Points in SPF Notation"
    cv_rule: TypeAlias = RuleVariation_1373

    @classmethod
    def create(cls, arg : "NonSpare_178.cv_arg") -> "NonSpare_178":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1373:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1452:
        return self.rule.variation

class UapItem_178(UapItem):
    cv_non_spare: TypeAlias = NonSpare_178

class NonSpare_259(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "090"
    cv_title = "Time of Day"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_259.cv_arg") -> "NonSpare_259":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class UapItem_259(UapItem):
    cv_non_spare: TypeAlias = NonSpare_259

class Variation_146(Element):
    cv_arg: TypeAlias = RuleContent_612.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 5
    cv_rule = RuleContent_612

    @classmethod
    def create(cls, arg: "Variation_146.cv_arg") -> "Variation_146":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_612:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_612:
        return self.rule.content

class RuleVariation_146(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_146.cv_arg
    cv_variation: TypeAlias = Variation_146

    @classmethod
    def create(cls, arg : "RuleVariation_146.cv_arg") -> "RuleVariation_146":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_146:
        return self.arg # type: ignore

class Variation_889(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 3
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_889.cv_arg") -> "Variation_889":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_859(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_889.cv_arg
    cv_variation: TypeAlias = Variation_889

    @classmethod
    def create(cls, arg : "RuleVariation_859.cv_arg") -> "RuleVariation_859":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_889:
        return self.arg # type: ignore

class Variation_251(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 15
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_251.cv_arg") -> "Variation_251":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_244(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_251.cv_arg
    cv_variation: TypeAlias = Variation_251

    @classmethod
    def create(cls, arg : "RuleVariation_244.cv_arg") -> "RuleVariation_244":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_251:
        return self.arg # type: ignore

class NonSpare_968(NonSpare):
    cv_arg: TypeAlias = RuleVariation_146.cv_arg
    cv_name = "F"
    cv_title = "Scaling Factor"
    cv_rule: TypeAlias = RuleVariation_146

    @classmethod
    def create(cls, arg : "NonSpare_968.cv_arg") -> "NonSpare_968":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_146:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_146:
        return self.rule.variation

class Item_326(Item):
    cv_arg: TypeAlias = NonSpare_968.cv_arg
    cv_non_spare: TypeAlias = NonSpare_968

    @classmethod
    def create(cls, arg : "Item_326.cv_arg") -> "Item_326":
        return cls._create(arg) # type: ignore

class NonSpare_1531(NonSpare):
    cv_arg: TypeAlias = RuleVariation_859.cv_arg
    cv_name = "R"
    cv_title = "Current Reduction Stage in Use"
    cv_rule: TypeAlias = RuleVariation_859

    @classmethod
    def create(cls, arg : "NonSpare_1531.cv_arg") -> "NonSpare_1531":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_859:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_889:
        return self.rule.variation

class Item_763(Item):
    cv_arg: TypeAlias = NonSpare_1531.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1531

    @classmethod
    def create(cls, arg : "Item_763.cv_arg") -> "Item_763":
        return cls._create(arg) # type: ignore

class NonSpare_1487(NonSpare):
    cv_arg: TypeAlias = RuleVariation_244.cv_arg
    cv_name = "Q"
    cv_title = "Processing Parameters"
    cv_rule: TypeAlias = RuleVariation_244

    @classmethod
    def create(cls, arg : "NonSpare_1487.cv_arg") -> "NonSpare_1487":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_244:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_251:
        return self.rule.variation

class Item_720(Item):
    cv_arg: TypeAlias = NonSpare_1487.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1487

    @classmethod
    def create(cls, arg : "Item_720.cv_arg") -> "Item_720":
        return cls._create(arg) # type: ignore

class Variation_1359(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_146.cv_arg, Tuple[Literal["F"], RuleVariation_146.cv_arg]], Union[RuleVariation_859.cv_arg, Tuple[Literal["R"], RuleVariation_859.cv_arg]], Union[RuleVariation_244.cv_arg, Tuple[Literal["Q"], RuleVariation_244.cv_arg]], None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1359.cv_arg_group_1"],
    ]
    cv_items_list = [[(Item_326, 5), (Item_763, 3), (Item_720, 15), None]]

    @classmethod
    def create(cls, arg: "Variation_1359.cv_arg") -> 'Variation_1359':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["F"]) -> RuleVariation_146:
        ...
    @overload
    def get_item(self, key : Literal["R"]) -> RuleVariation_859:
        ...
    @overload
    def get_item(self, key : Literal["Q"]) -> RuleVariation_244:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1280(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1359.cv_arg
    cv_variation: TypeAlias = Variation_1359

    @classmethod
    def create(cls, arg : "RuleVariation_1280.cv_arg") -> "RuleVariation_1280":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1359:
        return self.arg # type: ignore

class NonSpare_275(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1280.cv_arg
    cv_name = "100"
    cv_title = "Processing Status"
    cv_rule: TypeAlias = RuleVariation_1280

    @classmethod
    def create(cls, arg : "NonSpare_275.cv_arg") -> "NonSpare_275":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1280:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1359:
        return self.rule.variation

class UapItem_275(UapItem):
    cv_non_spare: TypeAlias = NonSpare_275

class NonSpare_291(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1375.cv_arg
    cv_name = "110"
    cv_title = "Station Configuration Status"
    cv_rule: TypeAlias = RuleVariation_1375

    @classmethod
    def create(cls, arg : "NonSpare_291.cv_arg") -> "NonSpare_291":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1375:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1454:
        return self.rule.variation

class UapItem_291(UapItem):
    cv_non_spare: TypeAlias = NonSpare_291

class Variation_256(Element):
    cv_arg: TypeAlias = RuleContent_613.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_613

    @classmethod
    def create(cls, arg: "Variation_256.cv_arg") -> "Variation_256":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_613:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_613:
        return self.rule.content

class RuleVariation_249(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_256.cv_arg
    cv_variation: TypeAlias = Variation_256

    @classmethod
    def create(cls, arg : "RuleVariation_249.cv_arg") -> "RuleVariation_249":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_256:
        return self.arg # type: ignore

class NonSpare_304(NonSpare):
    cv_arg: TypeAlias = RuleVariation_249.cv_arg
    cv_name = "120"
    cv_title = "Total Number of Items Constituting One Weather Picture"
    cv_rule: TypeAlias = RuleVariation_249

    @classmethod
    def create(cls, arg : "NonSpare_304.cv_arg") -> "NonSpare_304":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_249:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_256:
        return self.rule.variation

class UapItem_304(UapItem):
    cv_non_spare: TypeAlias = NonSpare_304

class NonSpare_2106(NonSpare):
    cv_arg: TypeAlias = RuleVariation_197.cv_arg
    cv_name = "X1"
    cv_title = "X1-Component"
    cv_rule: TypeAlias = RuleVariation_197

    @classmethod
    def create(cls, arg : "NonSpare_2106.cv_arg") -> "NonSpare_2106":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_197:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_204:
        return self.rule.variation

class Item_1207(Item):
    cv_arg: TypeAlias = NonSpare_2106.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2106

    @classmethod
    def create(cls, arg : "Item_1207.cv_arg") -> "Item_1207":
        return cls._create(arg) # type: ignore

class NonSpare_2159(NonSpare):
    cv_arg: TypeAlias = RuleVariation_197.cv_arg
    cv_name = "Y1"
    cv_title = "Y1-Component"
    cv_rule: TypeAlias = RuleVariation_197

    @classmethod
    def create(cls, arg : "NonSpare_2159.cv_arg") -> "NonSpare_2159":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_197:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_204:
        return self.rule.variation

class Item_1257(Item):
    cv_arg: TypeAlias = NonSpare_2159.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2159

    @classmethod
    def create(cls, arg : "Item_1257.cv_arg") -> "Item_1257":
        return cls._create(arg) # type: ignore

class NonSpare_2110(NonSpare):
    cv_arg: TypeAlias = RuleVariation_197.cv_arg
    cv_name = "X2"
    cv_title = "X2-Component"
    cv_rule: TypeAlias = RuleVariation_197

    @classmethod
    def create(cls, arg : "NonSpare_2110.cv_arg") -> "NonSpare_2110":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_197:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_204:
        return self.rule.variation

class Item_1211(Item):
    cv_arg: TypeAlias = NonSpare_2110.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2110

    @classmethod
    def create(cls, arg : "Item_1211.cv_arg") -> "Item_1211":
        return cls._create(arg) # type: ignore

class NonSpare_2161(NonSpare):
    cv_arg: TypeAlias = RuleVariation_197.cv_arg
    cv_name = "Y2"
    cv_title = "Y2-Component"
    cv_rule: TypeAlias = RuleVariation_197

    @classmethod
    def create(cls, arg : "NonSpare_2161.cv_arg") -> "NonSpare_2161":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_197:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_204:
        return self.rule.variation

class Item_1259(Item):
    cv_arg: TypeAlias = NonSpare_2161.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2161

    @classmethod
    def create(cls, arg : "Item_1259.cv_arg") -> "Item_1259":
        return cls._create(arg) # type: ignore

class Variation_1319(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_197.cv_arg, Tuple[Literal["X1"], RuleVariation_197.cv_arg]], Union[RuleVariation_197.cv_arg, Tuple[Literal["Y1"], RuleVariation_197.cv_arg]], Union[RuleVariation_197.cv_arg, Tuple[Literal["X2"], RuleVariation_197.cv_arg]], Union[RuleVariation_197.cv_arg, Tuple[Literal["Y2"], RuleVariation_197.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1319.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1207, 8), (Item_1257, 8), (Item_1211, 8), (Item_1259, 8)]
    cv_items_dict = {"X1": RuleVariation_197, "Y1": RuleVariation_197, "X2": RuleVariation_197, "Y2": RuleVariation_197}

    @overload
    @classmethod
    def spec(cls, key : Literal["X1"]) -> RuleVariation_197:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y1"]) -> RuleVariation_197:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["X2"]) -> RuleVariation_197:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y2"]) -> RuleVariation_197:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X1"], Literal["Y1"], Literal["X2"], Literal["Y2"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X1"]) -> RuleVariation_197:
        ...
    @overload
    def get_item(self, key : Literal["Y1"]) -> RuleVariation_197:
        ...
    @overload
    def get_item(self, key : Literal["X2"]) -> RuleVariation_197:
        ...
    @overload
    def get_item(self, key : Literal["Y2"]) -> RuleVariation_197:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1319.cv_arg") -> 'Variation_1319':
        return cls._create(arg) # type: ignore

class Variation_1453(Repetitive):
    cv_arg: TypeAlias = List[Variation_1319.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1319

    @classmethod
    def create(cls, arg: "Variation_1453.cv_arg") -> 'Variation_1453':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1319]:
        return self._get_list() # type: ignore

class RuleVariation_1374(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1453.cv_arg
    cv_variation: TypeAlias = Variation_1453

    @classmethod
    def create(cls, arg : "RuleVariation_1374.cv_arg") -> "RuleVariation_1374":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1453:
        return self.arg # type: ignore

class NonSpare_135(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1374.cv_arg
    cv_name = "038"
    cv_title = "Sequence of Weather Vectors in SPF Notation"
    cv_rule: TypeAlias = RuleVariation_1374

    @classmethod
    def create(cls, arg : "NonSpare_135.cv_arg") -> "NonSpare_135":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1374:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1453:
        return self.rule.variation

class UapItem_135(UapItem):
    cv_non_spare: TypeAlias = NonSpare_135

class Record_20(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_37.cv_arg,
        "000": NonSpare_8.cv_arg,
        "020": NonSpare_96.cv_arg,
        "036": NonSpare_133.cv_arg,
        "034": NonSpare_128.cv_arg,
        "040": NonSpare_137.cv_arg,
        "050": NonSpare_178.cv_arg,
        "090": NonSpare_259.cv_arg,
        "100": NonSpare_275.cv_arg,
        "110": NonSpare_291.cv_arg,
        "120": NonSpare_304.cv_arg,
        "038": NonSpare_135.cv_arg,
        "SP": NonSpare_1732.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_37.cv_arg],
        Tuple[Literal["000"], NonSpare_8.cv_arg],
        Tuple[Literal["020"], NonSpare_96.cv_arg],
        Tuple[Literal["036"], NonSpare_133.cv_arg],
        Tuple[Literal["034"], NonSpare_128.cv_arg],
        Tuple[Literal["040"], NonSpare_137.cv_arg],
        Tuple[Literal["050"], NonSpare_178.cv_arg],
        Tuple[Literal["090"], NonSpare_259.cv_arg],
        Tuple[Literal["100"], NonSpare_275.cv_arg],
        Tuple[Literal["110"], NonSpare_291.cv_arg],
        Tuple[Literal["120"], NonSpare_304.cv_arg],
        Tuple[Literal["038"], NonSpare_135.cv_arg],
        Tuple[Literal["SP"], NonSpare_1732.cv_arg],
    ]
    cv_fspec_max_bytes = 2
    cv_items_list = [UapItem_37, UapItem_8, UapItem_96, UapItem_133, UapItem_128, UapItem_137, UapItem_178, UapItem_259, UapItem_275, UapItem_291, UapItem_304, UapItem_135, UapItem_548, UapItem_550]
    cv_items_dict = {"010": NonSpare_37, "000": NonSpare_8, "020": NonSpare_96, "036": NonSpare_133, "034": NonSpare_128, "040": NonSpare_137, "050": NonSpare_178, "090": NonSpare_259, "100": NonSpare_275, "110": NonSpare_291, "120": NonSpare_304, "038": NonSpare_135, "SP": NonSpare_1732}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_37:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> NonSpare_8:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_96:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["036"]) -> NonSpare_133:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["034"]) -> NonSpare_128:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> NonSpare_137:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> NonSpare_178:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> NonSpare_259:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_275:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["110"]) -> NonSpare_291:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> NonSpare_304:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["038"]) -> NonSpare_135:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1732:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["020"], Literal["036"], Literal["034"], Literal["040"], Literal["050"], Literal["090"], Literal["100"], Literal["110"], Literal["120"], Literal["038"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_37]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_8]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_96]:
        ...
    @overload
    def get_item(self, key : Literal["036"]) -> Optional[NonSpare_133]:
        ...
    @overload
    def get_item(self, key : Literal["034"]) -> Optional[NonSpare_128]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_137]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_178]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_259]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_275]:
        ...
    @overload
    def get_item(self, key : Literal["110"]) -> Optional[NonSpare_291]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_304]:
        ...
    @overload
    def get_item(self, key : Literal["038"]) -> Optional[NonSpare_135]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1732]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_37.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_8.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_96.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["036"], val : NonSpare_133.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["034"], val : NonSpare_128.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_137.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_178.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_259.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_275.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["110"], val : NonSpare_291.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_304.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["038"], val : NonSpare_135.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1732.cv_arg) -> 'Record_20':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["036"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["034"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["110"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["038"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_20':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_37]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["000"]) -> List[NonSpare_8]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_96]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["036"]) -> List[NonSpare_133]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["034"]) -> List[NonSpare_128]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["040"]) -> List[NonSpare_137]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_178]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_259]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_275]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["110"]) -> List[NonSpare_291]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["120"]) -> List[NonSpare_304]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["038"]) -> List[NonSpare_135]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1732]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_20.cv_arg", rfs : Optional[List["Record_20.cv_union"]] = None) -> 'Record_20':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_20", Bits]]:
        return cls._parse(bs) # type: ignore

class Uap_18(UapSingle):
    cv_arg: TypeAlias = Record_20
    cv_record: TypeAlias = Record_20

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_20]]:
        return cls._parse(bs)

class Asterix_8(AstCat):
    cv_category = 8
    cv_edition = (1, 2)
    cv_uap: TypeAlias = Uap_18
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_18.cv_arg]) -> "Asterix_8":
        return cls._create(records) # type: ignore

class Asterix_9(AstCat):
    cv_category = 8
    cv_edition = (1, 3)
    cv_uap: TypeAlias = Uap_18
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_18.cv_arg]) -> "Asterix_9":
        return cls._create(records) # type: ignore

class Content_605(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {2: "Cartesian vector", 253: "Intermediate-update-step message", 254: "Start-of-picture message", 255: "End-of-picture message"}

class RuleContent_605(RuleContentContextFree):
    cv_arg: TypeAlias = Content_605.cv_arg
    cv_content: TypeAlias = Content_605

    @property
    def content(self) -> Content_605:
        return self._get_content() # type: ignore

class Variation_201(Element):
    cv_arg: TypeAlias = RuleContent_605.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_605

    @classmethod
    def create(cls, arg: "Variation_201.cv_arg") -> "Variation_201":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_605:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_605:
        return self.rule.content

class RuleVariation_194(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_201.cv_arg
    cv_variation: TypeAlias = Variation_201

    @classmethod
    def create(cls, arg : "RuleVariation_194.cv_arg") -> "RuleVariation_194":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_201:
        return self.arg # type: ignore

class NonSpare_16(NonSpare):
    cv_arg: TypeAlias = RuleVariation_194.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_194

    @classmethod
    def create(cls, arg : "NonSpare_16.cv_arg") -> "NonSpare_16":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_194:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_201:
        return self.rule.variation

class UapItem_16(UapItem):
    cv_non_spare: TypeAlias = NonSpare_16

class Variation_1378(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_52.cv_arg, Tuple[Literal["ORG"], RuleVariation_52.cv_arg]], Union[RuleVariation_477.cv_arg, Tuple[Literal["I"], RuleVariation_477.cv_arg]], Union[RuleVariation_764.cv_arg, Tuple[Literal["S"], RuleVariation_764.cv_arg]], None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1378.cv_arg_group_1"],
    ]
    cv_items_list = [[(Item_661, 1), (Item_409, 3), (Item_850, 3), None]]

    @classmethod
    def create(cls, arg: "Variation_1378.cv_arg") -> 'Variation_1378':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["ORG"]) -> RuleVariation_52:
        ...
    @overload
    def get_item(self, key : Literal["I"]) -> RuleVariation_477:
        ...
    @overload
    def get_item(self, key : Literal["S"]) -> RuleVariation_764:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1299(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1378.cv_arg
    cv_variation: TypeAlias = Variation_1378

    @classmethod
    def create(cls, arg : "RuleVariation_1299.cv_arg") -> "RuleVariation_1299":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1378:
        return self.arg # type: ignore

class NonSpare_95(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1299.cv_arg
    cv_name = "020"
    cv_title = "Vector Qualifier"
    cv_rule: TypeAlias = RuleVariation_1299

    @classmethod
    def create(cls, arg : "NonSpare_95.cv_arg") -> "NonSpare_95":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1299:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1378:
        return self.rule.variation

class UapItem_95(UapItem):
    cv_non_spare: TypeAlias = NonSpare_95

class Variation_255(Element):
    cv_arg: TypeAlias = RuleContent_612.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_612

    @classmethod
    def create(cls, arg: "Variation_255.cv_arg") -> "Variation_255":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_612:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_612:
        return self.rule.content

class RuleVariation_248(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_255.cv_arg
    cv_variation: TypeAlias = Variation_255

    @classmethod
    def create(cls, arg : "RuleVariation_248.cv_arg") -> "RuleVariation_248":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_255:
        return self.arg # type: ignore

class NonSpare_2101(NonSpare):
    cv_arg: TypeAlias = RuleVariation_248.cv_arg
    cv_name = "X"
    cv_title = "X-coordinate"
    cv_rule: TypeAlias = RuleVariation_248

    @classmethod
    def create(cls, arg : "NonSpare_2101.cv_arg") -> "NonSpare_2101":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_248:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_255:
        return self.rule.variation

class Item_1202(Item):
    cv_arg: TypeAlias = NonSpare_2101.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2101

    @classmethod
    def create(cls, arg : "Item_1202.cv_arg") -> "Item_1202":
        return cls._create(arg) # type: ignore

class NonSpare_2155(NonSpare):
    cv_arg: TypeAlias = RuleVariation_248.cv_arg
    cv_name = "Y"
    cv_title = "Y-coordinate"
    cv_rule: TypeAlias = RuleVariation_248

    @classmethod
    def create(cls, arg : "NonSpare_2155.cv_arg") -> "NonSpare_2155":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_248:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_255:
        return self.rule.variation

class Item_1253(Item):
    cv_arg: TypeAlias = NonSpare_2155.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2155

    @classmethod
    def create(cls, arg : "Item_1253.cv_arg") -> "Item_1253":
        return cls._create(arg) # type: ignore

class NonSpare_1145(NonSpare):
    cv_arg: TypeAlias = RuleVariation_249.cv_arg
    cv_name = "L"
    cv_title = "Vector Length"
    cv_rule: TypeAlias = RuleVariation_249

    @classmethod
    def create(cls, arg : "NonSpare_1145.cv_arg") -> "NonSpare_1145":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_249:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_256:
        return self.rule.variation

class Item_457(Item):
    cv_arg: TypeAlias = NonSpare_1145.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1145

    @classmethod
    def create(cls, arg : "Item_457.cv_arg") -> "Item_457":
        return cls._create(arg) # type: ignore

class Variation_1316(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_248.cv_arg, Tuple[Literal["X"], RuleVariation_248.cv_arg]], Union[RuleVariation_248.cv_arg, Tuple[Literal["Y"], RuleVariation_248.cv_arg]], Union[RuleVariation_249.cv_arg, Tuple[Literal["L"], RuleVariation_249.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1316.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 48
    cv_items_list = [(Item_1202, 16), (Item_1253, 16), (Item_457, 16)]
    cv_items_dict = {"X": RuleVariation_248, "Y": RuleVariation_248, "L": RuleVariation_249}

    @overload
    @classmethod
    def spec(cls, key : Literal["X"]) -> RuleVariation_248:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y"]) -> RuleVariation_248:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["L"]) -> RuleVariation_249:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X"], Literal["Y"], Literal["L"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X"]) -> RuleVariation_248:
        ...
    @overload
    def get_item(self, key : Literal["Y"]) -> RuleVariation_248:
        ...
    @overload
    def get_item(self, key : Literal["L"]) -> RuleVariation_249:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1316.cv_arg") -> 'Variation_1316':
        return cls._create(arg) # type: ignore

class Variation_1451(Repetitive):
    cv_arg: TypeAlias = List[Variation_1316.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1316

    @classmethod
    def create(cls, arg: "Variation_1451.cv_arg") -> 'Variation_1451':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1316]:
        return self._get_list() # type: ignore

class RuleVariation_1372(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1451.cv_arg
    cv_variation: TypeAlias = Variation_1451

    @classmethod
    def create(cls, arg : "RuleVariation_1372.cv_arg") -> "RuleVariation_1372":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1451:
        return self.arg # type: ignore

class NonSpare_107(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1372.cv_arg
    cv_name = "030"
    cv_title = "Sequence of Cartesian Vectors"
    cv_rule: TypeAlias = RuleVariation_1372

    @classmethod
    def create(cls, arg : "NonSpare_107.cv_arg") -> "NonSpare_107":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1372:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1451:
        return self.rule.variation

class UapItem_107(UapItem):
    cv_non_spare: TypeAlias = NonSpare_107

class Variation_149(Element):
    cv_arg: TypeAlias = RuleContent_613.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 6
    cv_rule = RuleContent_613

    @classmethod
    def create(cls, arg: "Variation_149.cv_arg") -> "Variation_149":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_613:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_613:
        return self.rule.content

class RuleVariation_149(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_149.cv_arg
    cv_variation: TypeAlias = Variation_149

    @classmethod
    def create(cls, arg : "RuleVariation_149.cv_arg") -> "RuleVariation_149":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_149:
        return self.arg # type: ignore

class NonSpare_1729(NonSpare):
    cv_arg: TypeAlias = RuleVariation_149.cv_arg
    cv_name = "SN"
    cv_title = "Step Number"
    cv_rule: TypeAlias = RuleVariation_149

    @classmethod
    def create(cls, arg : "NonSpare_1729.cv_arg") -> "NonSpare_1729":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_149:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_149:
        return self.rule.variation

class Item_904(Item):
    cv_arg: TypeAlias = NonSpare_1729.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1729

    @classmethod
    def create(cls, arg : "Item_904.cv_arg") -> "Item_904":
        return cls._create(arg) # type: ignore

class Variation_1382(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_149.cv_arg, Tuple[Literal["SN"], RuleVariation_149.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1382.cv_arg_group_1"],
    ]
    cv_items_list = [[(Item_904, 6), (Item_26, 1), None]]

    @classmethod
    def create(cls, arg: "Variation_1382.cv_arg") -> 'Variation_1382':
        return cls._create(arg) # type: ignore

    @overload # type: ignore
    def get_item(self, key : Literal["SN"]) -> RuleVariation_149:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1303(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1382.cv_arg
    cv_variation: TypeAlias = Variation_1382

    @classmethod
    def create(cls, arg : "RuleVariation_1303.cv_arg") -> "RuleVariation_1303":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1382:
        return self.arg # type: ignore

class NonSpare_199(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1303.cv_arg
    cv_name = "060"
    cv_title = "Synchronisation/Control Signal"
    cv_rule: TypeAlias = RuleVariation_1303

    @classmethod
    def create(cls, arg : "NonSpare_199.cv_arg") -> "NonSpare_199":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1303:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1382:
        return self.rule.variation

class UapItem_199(UapItem):
    cv_non_spare: TypeAlias = NonSpare_199

class NonSpare_221(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "070"
    cv_title = "Time of Day"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_221.cv_arg") -> "NonSpare_221":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class UapItem_221(UapItem):
    cv_non_spare: TypeAlias = NonSpare_221

class NonSpare_234(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1280.cv_arg
    cv_name = "080"
    cv_title = "Processing Status"
    cv_rule: TypeAlias = RuleVariation_1280

    @classmethod
    def create(cls, arg : "NonSpare_234.cv_arg") -> "NonSpare_234":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1280:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1359:
        return self.rule.variation

class UapItem_234(UapItem):
    cv_non_spare: TypeAlias = NonSpare_234

class NonSpare_1654(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "SAC"
    cv_title = "SAC of Radar Concerned"
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_1654.cv_arg") -> "NonSpare_1654":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class Item_855(Item):
    cv_arg: TypeAlias = NonSpare_1654.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1654

    @classmethod
    def create(cls, arg : "Item_855.cv_arg") -> "Item_855":
        return cls._create(arg) # type: ignore

class NonSpare_1709(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "SIC"
    cv_title = "SIC of Radar Concerned"
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_1709.cv_arg") -> "NonSpare_1709":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class Item_886(Item):
    cv_arg: TypeAlias = NonSpare_1709.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1709

    @classmethod
    def create(cls, arg : "Item_886.cv_arg") -> "Item_886":
        return cls._create(arg) # type: ignore

class Item_2(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 0
    cv_bit_size = 3

class Variation_614(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_614.cv_arg") -> "Variation_614":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_603(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_614.cv_arg
    cv_variation: TypeAlias = Variation_614

    @classmethod
    def create(cls, arg : "RuleVariation_603.cv_arg") -> "RuleVariation_603":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_614:
        return self.arg # type: ignore

class NonSpare_814(NonSpare):
    cv_arg: TypeAlias = RuleVariation_603.cv_arg
    cv_name = "CP"
    cv_title = "Circular Polarisation"
    cv_rule: TypeAlias = RuleVariation_603

    @classmethod
    def create(cls, arg : "NonSpare_814.cv_arg") -> "NonSpare_814":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_603:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_614:
        return self.rule.variation

class Item_206(Item):
    cv_arg: TypeAlias = NonSpare_814.cv_arg
    cv_non_spare: TypeAlias = NonSpare_814

    @classmethod
    def create(cls, arg : "Item_206.cv_arg") -> "Item_206":
        return cls._create(arg) # type: ignore

class Variation_699(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_699.cv_arg") -> "Variation_699":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_688(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_699.cv_arg
    cv_variation: TypeAlias = Variation_699

    @classmethod
    def create(cls, arg : "RuleVariation_688.cv_arg") -> "RuleVariation_688":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_699:
        return self.arg # type: ignore

class NonSpare_2063(NonSpare):
    cv_arg: TypeAlias = RuleVariation_688.cv_arg
    cv_name = "WO"
    cv_title = "Weather Channel Overload"
    cv_rule: TypeAlias = RuleVariation_688

    @classmethod
    def create(cls, arg : "NonSpare_2063.cv_arg") -> "NonSpare_2063":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_688:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_699:
        return self.rule.variation

class Item_1167(Item):
    cv_arg: TypeAlias = NonSpare_2063.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2063

    @classmethod
    def create(cls, arg : "Item_1167.cv_arg") -> "Item_1167":
        return cls._create(arg) # type: ignore

class NonSpare_1533(NonSpare):
    cv_arg: TypeAlias = RuleVariation_859.cv_arg
    cv_name = "R"
    cv_title = "Reduction Step in Use By Radar  Concerned"
    cv_rule: TypeAlias = RuleVariation_859

    @classmethod
    def create(cls, arg : "NonSpare_1533.cv_arg") -> "NonSpare_1533":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_859:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_889:
        return self.rule.variation

class Item_764(Item):
    cv_arg: TypeAlias = NonSpare_1533.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1533

    @classmethod
    def create(cls, arg : "Item_764.cv_arg") -> "Item_764":
        return cls._create(arg) # type: ignore

class Variation_1191(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_159.cv_arg, Tuple[Literal["SAC"], RuleVariation_159.cv_arg]], Union[RuleVariation_159.cv_arg, Tuple[Literal["SIC"], RuleVariation_159.cv_arg]], int, Union[RuleVariation_603.cv_arg, Tuple[Literal["CP"], RuleVariation_603.cv_arg]], Union[RuleVariation_688.cv_arg, Tuple[Literal["WO"], RuleVariation_688.cv_arg]], Union[RuleVariation_859.cv_arg, Tuple[Literal["R"], RuleVariation_859.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1191.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_items_list = [(Item_855, 8), (Item_886, 8), (Item_2, 3), (Item_206, 1), (Item_1167, 1), (Item_764, 3)]
    cv_items_dict = {"SAC": RuleVariation_159, "SIC": RuleVariation_159, "CP": RuleVariation_603, "WO": RuleVariation_688, "R": RuleVariation_859}

    @overload
    @classmethod
    def spec(cls, key : Literal["SAC"]) -> RuleVariation_159:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SIC"]) -> RuleVariation_159:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CP"]) -> RuleVariation_603:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["WO"]) -> RuleVariation_688:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["R"]) -> RuleVariation_859:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["SAC"], Literal["SIC"], Literal["CP"], Literal["WO"], Literal["R"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["SAC"]) -> RuleVariation_159:
        ...
    @overload
    def get_item(self, key : Literal["SIC"]) -> RuleVariation_159:
        ...
    @overload
    def get_item(self, key : Literal["CP"]) -> RuleVariation_603:
        ...
    @overload
    def get_item(self, key : Literal["WO"]) -> RuleVariation_688:
        ...
    @overload
    def get_item(self, key : Literal["R"]) -> RuleVariation_859:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1191.cv_arg") -> 'Variation_1191':
        return cls._create(arg) # type: ignore

class Variation_1428(Repetitive):
    cv_arg: TypeAlias = List[Variation_1191.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1191

    @classmethod
    def create(cls, arg: "Variation_1428.cv_arg") -> 'Variation_1428':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1191]:
        return self._get_list() # type: ignore

class RuleVariation_1349(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1428.cv_arg
    cv_variation: TypeAlias = Variation_1428

    @classmethod
    def create(cls, arg : "RuleVariation_1349.cv_arg") -> "RuleVariation_1349":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1428:
        return self.arg # type: ignore

class NonSpare_257(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1349.cv_arg
    cv_name = "090"
    cv_title = "Radar Configuration and Status"
    cv_rule: TypeAlias = RuleVariation_1349

    @classmethod
    def create(cls, arg : "NonSpare_257.cv_arg") -> "NonSpare_257":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1349:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1428:
        return self.rule.variation

class UapItem_257(UapItem):
    cv_non_spare: TypeAlias = NonSpare_257

class NonSpare_279(NonSpare):
    cv_arg: TypeAlias = RuleVariation_249.cv_arg
    cv_name = "100"
    cv_title = "Vector Count"
    cv_rule: TypeAlias = RuleVariation_249

    @classmethod
    def create(cls, arg : "NonSpare_279.cv_arg") -> "NonSpare_279":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_249:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_256:
        return self.rule.variation

class UapItem_279(UapItem):
    cv_non_spare: TypeAlias = NonSpare_279

class Record_21(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_37.cv_arg,
        "000": NonSpare_16.cv_arg,
        "020": NonSpare_95.cv_arg,
        "030": NonSpare_107.cv_arg,
        "060": NonSpare_199.cv_arg,
        "070": NonSpare_221.cv_arg,
        "080": NonSpare_234.cv_arg,
        "090": NonSpare_257.cv_arg,
        "100": NonSpare_279.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 2
    cv_items_list = [UapItem_37, UapItem_16, UapItem_95, UapItem_107, UapItem_199, UapItem_221, UapItem_234, UapItem_257, UapItem_279]
    cv_items_dict = {"010": NonSpare_37, "000": NonSpare_16, "020": NonSpare_95, "030": NonSpare_107, "060": NonSpare_199, "070": NonSpare_221, "080": NonSpare_234, "090": NonSpare_257, "100": NonSpare_279}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_37:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> NonSpare_16:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_95:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> NonSpare_107:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_199:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> NonSpare_221:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> NonSpare_234:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> NonSpare_257:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> NonSpare_279:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["020"], Literal["030"], Literal["060"], Literal["070"], Literal["080"], Literal["090"], Literal["100"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_37]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_16]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_95]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_107]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_199]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_221]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_234]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_257]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_279]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_37.cv_arg) -> 'Record_21':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_16.cv_arg) -> 'Record_21':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_95.cv_arg) -> 'Record_21':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_107.cv_arg) -> 'Record_21':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_199.cv_arg) -> 'Record_21':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_221.cv_arg) -> 'Record_21':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_234.cv_arg) -> 'Record_21':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_257.cv_arg) -> 'Record_21':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_279.cv_arg) -> 'Record_21':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_21':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_21':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_21':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_21':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_21':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_21':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_21':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_21':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_21':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Record_21.cv_arg") -> 'Record_21':
        return cls._create(arg) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_21", Bits]]:
        return cls._parse(bs) # type: ignore

class Uap_19(UapSingle):
    cv_arg: TypeAlias = Record_21
    cv_record: TypeAlias = Record_21

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_21]]:
        return cls._parse(bs)

class Asterix_10(AstCat):
    cv_category = 9
    cv_edition = (2, 1)
    cv_uap: TypeAlias = Uap_19
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_19.cv_arg]) -> "Asterix_10":
        return cls._create(records) # type: ignore

class NonSpare_43(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1140.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1140

    @classmethod
    def create(cls, arg : "NonSpare_43.cv_arg") -> "NonSpare_43":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1140:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1192:
        return self.rule.variation

class UapItem_43(UapItem):
    cv_non_spare: TypeAlias = NonSpare_43

class Content_599(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Target Report", 2: "Start of Update Cycle", 3: "Periodic Status Message", 4: "Event-triggered Status Message"}

class RuleContent_599(RuleContentContextFree):
    cv_arg: TypeAlias = Content_599.cv_arg
    cv_content: TypeAlias = Content_599

    @property
    def content(self) -> Content_599:
        return self._get_content() # type: ignore

class Variation_198(Element):
    cv_arg: TypeAlias = RuleContent_599.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_599

    @classmethod
    def create(cls, arg: "Variation_198.cv_arg") -> "Variation_198":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_599:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_599:
        return self.rule.content

class RuleVariation_191(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_198.cv_arg
    cv_variation: TypeAlias = Variation_198

    @classmethod
    def create(cls, arg : "RuleVariation_191.cv_arg") -> "RuleVariation_191":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_198:
        return self.arg # type: ignore

class NonSpare_13(NonSpare):
    cv_arg: TypeAlias = RuleVariation_191.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_191

    @classmethod
    def create(cls, arg : "NonSpare_13.cv_arg") -> "NonSpare_13":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_191:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_198:
        return self.rule.variation

class UapItem_13(UapItem):
    cv_non_spare: TypeAlias = NonSpare_13

class Content_451(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "SSR multilateration", 1: "Mode S multilateration", 2: "ADS-B", 3: "PSR", 4: "Magnetic Loop System", 5: "HF multilateration", 6: "Not defined", 7: "Other types"}

class RuleContent_451(RuleContentContextFree):
    cv_arg: TypeAlias = Content_451.cv_arg
    cv_content: TypeAlias = Content_451

    @property
    def content(self) -> Content_451:
        return self._get_content() # type: ignore

class Variation_131(Element):
    cv_arg: TypeAlias = RuleContent_451.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 3
    cv_rule = RuleContent_451

    @classmethod
    def create(cls, arg: "Variation_131.cv_arg") -> "Variation_131":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_451:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_451:
        return self.rule.content

class RuleVariation_131(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_131.cv_arg
    cv_variation: TypeAlias = Variation_131

    @classmethod
    def create(cls, arg : "RuleVariation_131.cv_arg") -> "RuleVariation_131":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_131:
        return self.arg # type: ignore

class Content_352(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No differential correction (ADS-B)", 1: "Differential correction (ADS-B)"}

class RuleContent_352(RuleContentContextFree):
    cv_arg: TypeAlias = Content_352.cv_arg
    cv_content: TypeAlias = Content_352

    @property
    def content(self) -> Content_352:
        return self._get_content() # type: ignore

class Variation_652(Element):
    cv_arg: TypeAlias = RuleContent_352.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_352

    @classmethod
    def create(cls, arg: "Variation_652.cv_arg") -> "Variation_652":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_352:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_352:
        return self.rule.content

class RuleVariation_641(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_652.cv_arg
    cv_variation: TypeAlias = Variation_652

    @classmethod
    def create(cls, arg : "RuleVariation_641.cv_arg") -> "RuleVariation_641":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_652:
        return self.arg # type: ignore

class Content_53(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Chain 1", 1: "Chain 2"}

class RuleContent_53(RuleContentContextFree):
    cv_arg: TypeAlias = Content_53.cv_arg
    cv_content: TypeAlias = Content_53

    @property
    def content(self) -> Content_53:
        return self._get_content() # type: ignore

class Variation_703(Element):
    cv_arg: TypeAlias = RuleContent_53.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_53

    @classmethod
    def create(cls, arg: "Variation_703.cv_arg") -> "Variation_703":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_53:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_53:
        return self.rule.content

class RuleVariation_692(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_703.cv_arg
    cv_variation: TypeAlias = Variation_703

    @classmethod
    def create(cls, arg : "RuleVariation_692.cv_arg") -> "RuleVariation_692":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_703:
        return self.arg # type: ignore

class Content_521(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Transponder Ground bit not set", 1: "Transponder Ground bit set"}

class RuleContent_521(RuleContentContextFree):
    cv_arg: TypeAlias = Content_521.cv_arg
    cv_content: TypeAlias = Content_521

    @property
    def content(self) -> Content_521:
        return self._get_content() # type: ignore

class Variation_875(Element):
    cv_arg: TypeAlias = RuleContent_521.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_521

    @classmethod
    def create(cls, arg: "Variation_875.cv_arg") -> "Variation_875":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_521:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_521:
        return self.rule.content

class RuleVariation_845(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_875.cv_arg
    cv_variation: TypeAlias = Variation_875

    @classmethod
    def create(cls, arg : "RuleVariation_845.cv_arg") -> "RuleVariation_845":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_875:
        return self.arg # type: ignore

class Content_306(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No Corrupted reply in multilateration", 1: "Corrupted replies in multilateration"}

class RuleContent_306(RuleContentContextFree):
    cv_arg: TypeAlias = Content_306.cv_arg
    cv_content: TypeAlias = Content_306

    @property
    def content(self) -> Content_306:
        return self._get_content() # type: ignore

class Variation_940(Element):
    cv_arg: TypeAlias = RuleContent_306.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_306

    @classmethod
    def create(cls, arg: "Variation_940.cv_arg") -> "Variation_940":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_306:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_306:
        return self.rule.content

class RuleVariation_910(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_940.cv_arg
    cv_variation: TypeAlias = Variation_940

    @classmethod
    def create(cls, arg : "RuleVariation_910.cv_arg") -> "RuleVariation_910":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_940:
        return self.arg # type: ignore

class Content_19(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Actual target report", 1: "Simulated target report"}

class RuleContent_19(RuleContentContextFree):
    cv_arg: TypeAlias = Content_19.cv_arg
    cv_content: TypeAlias = Content_19

    @property
    def content(self) -> Content_19:
        return self._get_content() # type: ignore

class Variation_5(Element):
    cv_arg: TypeAlias = RuleContent_19.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_19

    @classmethod
    def create(cls, arg: "Variation_5.cv_arg") -> "Variation_5":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_19:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_19:
        return self.rule.content

class RuleVariation_5(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_5.cv_arg
    cv_variation: TypeAlias = Variation_5

    @classmethod
    def create(cls, arg : "RuleVariation_5.cv_arg") -> "RuleVariation_5":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_5:
        return self.arg # type: ignore

class Content_155(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Test Target"}

class RuleContent_155(RuleContentContextFree):
    cv_arg: TypeAlias = Content_155.cv_arg
    cv_content: TypeAlias = Content_155

    @property
    def content(self) -> Content_155:
        return self._get_content() # type: ignore

class Variation_419(Element):
    cv_arg: TypeAlias = RuleContent_155.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_155

    @classmethod
    def create(cls, arg: "Variation_419.cv_arg") -> "Variation_419":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_155:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_155:
        return self.rule.content

class RuleVariation_408(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_419.cv_arg
    cv_variation: TypeAlias = Variation_419

    @classmethod
    def create(cls, arg : "RuleVariation_408.cv_arg") -> "RuleVariation_408":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_419:
        return self.arg # type: ignore

class Content_442(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Report from target transponder", 1: "Report from field monitor (fixed transponder)"}

class RuleContent_442(RuleContentContextFree):
    cv_arg: TypeAlias = Content_442.cv_arg
    cv_content: TypeAlias = Content_442

    @property
    def content(self) -> Content_442:
        return self._get_content() # type: ignore

class Variation_574(Element):
    cv_arg: TypeAlias = RuleContent_442.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_442

    @classmethod
    def create(cls, arg: "Variation_574.cv_arg") -> "Variation_574":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_442:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_442:
        return self.rule.content

class RuleVariation_563(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_574.cv_arg
    cv_variation: TypeAlias = Variation_574

    @classmethod
    def create(cls, arg : "RuleVariation_563.cv_arg") -> "RuleVariation_563":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_574:
        return self.arg # type: ignore

class Content_533(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Undetermined", 1: "Loop start", 2: "Loop finish"}

class RuleContent_533(RuleContentContextFree):
    cv_arg: TypeAlias = Content_533.cv_arg
    cv_content: TypeAlias = Content_533

    @property
    def content(self) -> Content_533:
        return self._get_content() # type: ignore

class Variation_682(Element):
    cv_arg: TypeAlias = RuleContent_533.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 2
    cv_rule = RuleContent_533

    @classmethod
    def create(cls, arg: "Variation_682.cv_arg") -> "Variation_682":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_533:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_533:
        return self.rule.content

class RuleVariation_671(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_682.cv_arg
    cv_variation: TypeAlias = Variation_682

    @classmethod
    def create(cls, arg : "RuleVariation_671.cv_arg") -> "RuleVariation_671":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_682:
        return self.arg # type: ignore

class Content_532(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Undetermined", 1: "Aircraft", 2: "Ground vehicle", 3: "Helicopter"}

class RuleContent_532(RuleContentContextFree):
    cv_arg: TypeAlias = Content_532.cv_arg
    cv_content: TypeAlias = Content_532

    @property
    def content(self) -> Content_532:
        return self._get_content() # type: ignore

class Variation_887(Element):
    cv_arg: TypeAlias = RuleContent_532.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 2
    cv_rule = RuleContent_532

    @classmethod
    def create(cls, arg: "Variation_887.cv_arg") -> "Variation_887":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_532:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_532:
        return self.rule.content

class RuleVariation_857(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_887.cv_arg
    cv_variation: TypeAlias = Variation_887

    @classmethod
    def create(cls, arg : "RuleVariation_857.cv_arg") -> "RuleVariation_857":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_887:
        return self.arg # type: ignore

class Content_13(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Absence of SPI", 1: "Special Position Identification"}

class RuleContent_13(RuleContentContextFree):
    cv_arg: TypeAlias = Content_13.cv_arg
    cv_content: TypeAlias = Content_13

    @property
    def content(self) -> Content_13:
        return self._get_content() # type: ignore

class Variation_3(Element):
    cv_arg: TypeAlias = RuleContent_13.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_13

    @classmethod
    def create(cls, arg: "Variation_3.cv_arg") -> "Variation_3":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_13:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_13:
        return self.rule.content

class RuleVariation_3(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_3.cv_arg
    cv_variation: TypeAlias = Variation_3

    @classmethod
    def create(cls, arg : "RuleVariation_3.cv_arg") -> "RuleVariation_3":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_3:
        return self.arg # type: ignore

class NonSpare_1960(NonSpare):
    cv_arg: TypeAlias = RuleVariation_131.cv_arg
    cv_name = "TYP"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_131

    @classmethod
    def create(cls, arg : "NonSpare_1960.cv_arg") -> "NonSpare_1960":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_131:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_131:
        return self.rule.variation

class Item_1074(Item):
    cv_arg: TypeAlias = NonSpare_1960.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1960

    @classmethod
    def create(cls, arg : "Item_1074.cv_arg") -> "Item_1074":
        return cls._create(arg) # type: ignore

class NonSpare_875(NonSpare):
    cv_arg: TypeAlias = RuleVariation_641.cv_arg
    cv_name = "DCR"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_641

    @classmethod
    def create(cls, arg : "NonSpare_875.cv_arg") -> "NonSpare_875":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_641:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_652:
        return self.rule.variation

class Item_253(Item):
    cv_arg: TypeAlias = NonSpare_875.cv_arg
    cv_non_spare: TypeAlias = NonSpare_875

    @classmethod
    def create(cls, arg : "Item_253.cv_arg") -> "Item_253":
        return cls._create(arg) # type: ignore

class NonSpare_735(NonSpare):
    cv_arg: TypeAlias = RuleVariation_692.cv_arg
    cv_name = "CHN"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_692

    @classmethod
    def create(cls, arg : "NonSpare_735.cv_arg") -> "NonSpare_735":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_692:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_703:
        return self.rule.variation

class Item_157(Item):
    cv_arg: TypeAlias = NonSpare_735.cv_arg
    cv_non_spare: TypeAlias = NonSpare_735

    @classmethod
    def create(cls, arg : "Item_157.cv_arg") -> "Item_157":
        return cls._create(arg) # type: ignore

class NonSpare_1029(NonSpare):
    cv_arg: TypeAlias = RuleVariation_845.cv_arg
    cv_name = "GBS"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_845

    @classmethod
    def create(cls, arg : "NonSpare_1029.cv_arg") -> "NonSpare_1029":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_845:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_875:
        return self.rule.variation

class Item_367(Item):
    cv_arg: TypeAlias = NonSpare_1029.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1029

    @classmethod
    def create(cls, arg : "Item_367.cv_arg") -> "Item_367":
        return cls._create(arg) # type: ignore

class NonSpare_831(NonSpare):
    cv_arg: TypeAlias = RuleVariation_910.cv_arg
    cv_name = "CRT"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_910

    @classmethod
    def create(cls, arg : "NonSpare_831.cv_arg") -> "NonSpare_831":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_910:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_940:
        return self.rule.variation

class Item_217(Item):
    cv_arg: TypeAlias = NonSpare_831.cv_arg
    cv_non_spare: TypeAlias = NonSpare_831

    @classmethod
    def create(cls, arg : "Item_217.cv_arg") -> "Item_217":
        return cls._create(arg) # type: ignore

class NonSpare_1723(NonSpare):
    cv_arg: TypeAlias = RuleVariation_5.cv_arg
    cv_name = "SIM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_5

    @classmethod
    def create(cls, arg : "NonSpare_1723.cv_arg") -> "NonSpare_1723":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_5:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_5:
        return self.rule.variation

class Item_898(Item):
    cv_arg: TypeAlias = NonSpare_1723.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1723

    @classmethod
    def create(cls, arg : "Item_898.cv_arg") -> "Item_898":
        return cls._create(arg) # type: ignore

class NonSpare_1935(NonSpare):
    cv_arg: TypeAlias = RuleVariation_408.cv_arg
    cv_name = "TST"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_408

    @classmethod
    def create(cls, arg : "NonSpare_1935.cv_arg") -> "NonSpare_1935":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_408:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_419:
        return self.rule.variation

class Item_1052(Item):
    cv_arg: TypeAlias = NonSpare_1935.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1935

    @classmethod
    def create(cls, arg : "Item_1052.cv_arg") -> "Item_1052":
        return cls._create(arg) # type: ignore

class NonSpare_1537(NonSpare):
    cv_arg: TypeAlias = RuleVariation_563.cv_arg
    cv_name = "RAB"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_563

    @classmethod
    def create(cls, arg : "NonSpare_1537.cv_arg") -> "NonSpare_1537":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_563:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_574:
        return self.rule.variation

class Item_767(Item):
    cv_arg: TypeAlias = NonSpare_1537.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1537

    @classmethod
    def create(cls, arg : "Item_767.cv_arg") -> "Item_767":
        return cls._create(arg) # type: ignore

class NonSpare_1194(NonSpare):
    cv_arg: TypeAlias = RuleVariation_671.cv_arg
    cv_name = "LOP"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_671

    @classmethod
    def create(cls, arg : "NonSpare_1194.cv_arg") -> "NonSpare_1194":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_671:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_682:
        return self.rule.variation

class Item_504(Item):
    cv_arg: TypeAlias = NonSpare_1194.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1194

    @classmethod
    def create(cls, arg : "Item_504.cv_arg") -> "Item_504":
        return cls._create(arg) # type: ignore

class NonSpare_1888(NonSpare):
    cv_arg: TypeAlias = RuleVariation_857.cv_arg
    cv_name = "TOT"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_857

    @classmethod
    def create(cls, arg : "NonSpare_1888.cv_arg") -> "NonSpare_1888":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_857:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_887:
        return self.rule.variation

class Item_1011(Item):
    cv_arg: TypeAlias = NonSpare_1888.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1888

    @classmethod
    def create(cls, arg : "Item_1011.cv_arg") -> "Item_1011":
        return cls._create(arg) # type: ignore

class NonSpare_1736(NonSpare):
    cv_arg: TypeAlias = RuleVariation_3.cv_arg
    cv_name = "SPI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_3

    @classmethod
    def create(cls, arg : "NonSpare_1736.cv_arg") -> "NonSpare_1736":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_3:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_3:
        return self.rule.variation

class Item_909(Item):
    cv_arg: TypeAlias = NonSpare_1736.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1736

    @classmethod
    def create(cls, arg : "Item_909.cv_arg") -> "Item_909":
        return cls._create(arg) # type: ignore

class Variation_1392(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_131.cv_arg, Tuple[Literal["TYP"], RuleVariation_131.cv_arg]], Union[RuleVariation_641.cv_arg, Tuple[Literal["DCR"], RuleVariation_641.cv_arg]], Union[RuleVariation_692.cv_arg, Tuple[Literal["CHN"], RuleVariation_692.cv_arg]], Union[RuleVariation_845.cv_arg, Tuple[Literal["GBS"], RuleVariation_845.cv_arg]], Union[RuleVariation_910.cv_arg, Tuple[Literal["CRT"], RuleVariation_910.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_5.cv_arg, Tuple[Literal["SIM"], RuleVariation_5.cv_arg]], Union[RuleVariation_408.cv_arg, Tuple[Literal["TST"], RuleVariation_408.cv_arg]], Union[RuleVariation_563.cv_arg, Tuple[Literal["RAB"], RuleVariation_563.cv_arg]], Union[RuleVariation_671.cv_arg, Tuple[Literal["LOP"], RuleVariation_671.cv_arg]], Union[RuleVariation_857.cv_arg, Tuple[Literal["TOT"], RuleVariation_857.cv_arg]], None]]
    cv_arg_group_3: TypeAlias = Union[int, Tuple[Union[RuleVariation_3.cv_arg, Tuple[Literal["SPI"], RuleVariation_3.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1392.cv_arg_group_1"],
        Tuple["Variation_1392.cv_arg_group_1", "Variation_1392.cv_arg_group_2"],
        Tuple["Variation_1392.cv_arg_group_1", "Variation_1392.cv_arg_group_2", "Variation_1392.cv_arg_group_3"],
    ]
    cv_items_list = [[(Item_1074, 3), (Item_253, 1), (Item_157, 1), (Item_367, 1), (Item_217, 1), None], [(Item_898, 1), (Item_1052, 1), (Item_767, 1), (Item_504, 2), (Item_1011, 2), None], [(Item_909, 1), (Item_9, 6), None]]

    @classmethod
    def create(cls, arg: "Variation_1392.cv_arg") -> 'Variation_1392':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["TYP"]) -> RuleVariation_131:
        ...
    @overload
    def get_item(self, key : Literal["DCR"]) -> RuleVariation_641:
        ...
    @overload
    def get_item(self, key : Literal["CHN"]) -> RuleVariation_692:
        ...
    @overload
    def get_item(self, key : Literal["GBS"]) -> RuleVariation_845:
        ...
    @overload
    def get_item(self, key : Literal["CRT"]) -> RuleVariation_910:
        ...
    @overload
    def get_item(self, key : Literal["SIM"]) -> Optional[RuleVariation_5]:
        ...
    @overload
    def get_item(self, key : Literal["TST"]) -> Optional[RuleVariation_408]:
        ...
    @overload
    def get_item(self, key : Literal["RAB"]) -> Optional[RuleVariation_563]:
        ...
    @overload
    def get_item(self, key : Literal["LOP"]) -> Optional[RuleVariation_671]:
        ...
    @overload
    def get_item(self, key : Literal["TOT"]) -> Optional[RuleVariation_857]:
        ...
    @overload
    def get_item(self, key : Literal["SPI"]) -> Optional[RuleVariation_3]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1313(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1392.cv_arg
    cv_variation: TypeAlias = Variation_1392

    @classmethod
    def create(cls, arg : "RuleVariation_1313.cv_arg") -> "RuleVariation_1313":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1392:
        return self.arg # type: ignore

class NonSpare_91(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1313.cv_arg
    cv_name = "020"
    cv_title = "Target Report Descriptor"
    cv_rule: TypeAlias = RuleVariation_1313

    @classmethod
    def create(cls, arg : "NonSpare_91.cv_arg") -> "NonSpare_91":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1313:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1392:
        return self.rule.variation

class UapItem_91(UapItem):
    cv_non_spare: TypeAlias = NonSpare_91

class NonSpare_331(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "140"
    cv_title = "Time of Day"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_331.cv_arg") -> "NonSpare_331":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class UapItem_331(UapItem):
    cv_non_spare: TypeAlias = NonSpare_331

class Content_705(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 8.381903171539307e-8
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_705(RuleContentContextFree):
    cv_arg: TypeAlias = Content_705.cv_arg
    cv_content: TypeAlias = Content_705

    @property
    def content(self) -> Content_705:
        return self._get_content() # type: ignore

class Variation_383(Element):
    cv_arg: TypeAlias = RuleContent_705.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_rule = RuleContent_705

    @classmethod
    def create(cls, arg: "Variation_383.cv_arg") -> "Variation_383":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_705:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_705:
        return self.rule.content

class RuleVariation_376(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_383.cv_arg
    cv_variation: TypeAlias = Variation_383

    @classmethod
    def create(cls, arg : "RuleVariation_376.cv_arg") -> "RuleVariation_376":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_383:
        return self.arg # type: ignore

class NonSpare_1154(NonSpare):
    cv_arg: TypeAlias = RuleVariation_376.cv_arg
    cv_name = "LAT"
    cv_title = "Latitude"
    cv_rule: TypeAlias = RuleVariation_376

    @classmethod
    def create(cls, arg : "NonSpare_1154.cv_arg") -> "NonSpare_1154":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_376:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_383:
        return self.rule.variation

class Item_466(Item):
    cv_arg: TypeAlias = NonSpare_1154.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1154

    @classmethod
    def create(cls, arg : "Item_466.cv_arg") -> "Item_466":
        return cls._create(arg) # type: ignore

class Content_703(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 8.381903171539307e-8
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_703(RuleContentContextFree):
    cv_arg: TypeAlias = Content_703.cv_arg
    cv_content: TypeAlias = Content_703

    @property
    def content(self) -> Content_703:
        return self._get_content() # type: ignore

class Variation_381(Element):
    cv_arg: TypeAlias = RuleContent_703.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_rule = RuleContent_703

    @classmethod
    def create(cls, arg: "Variation_381.cv_arg") -> "Variation_381":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_703:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_703:
        return self.rule.content

class RuleVariation_374(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_381.cv_arg
    cv_variation: TypeAlias = Variation_381

    @classmethod
    def create(cls, arg : "RuleVariation_374.cv_arg") -> "RuleVariation_374":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_381:
        return self.arg # type: ignore

class NonSpare_1184(NonSpare):
    cv_arg: TypeAlias = RuleVariation_374.cv_arg
    cv_name = "LON"
    cv_title = "Longitude"
    cv_rule: TypeAlias = RuleVariation_374

    @classmethod
    def create(cls, arg : "NonSpare_1184.cv_arg") -> "NonSpare_1184":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_374:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_381:
        return self.rule.variation

class Item_494(Item):
    cv_arg: TypeAlias = NonSpare_1184.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1184

    @classmethod
    def create(cls, arg : "Item_494.cv_arg") -> "Item_494":
        return cls._create(arg) # type: ignore

class Variation_1130(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_376.cv_arg, Tuple[Literal["LAT"], RuleVariation_376.cv_arg]], Union[RuleVariation_374.cv_arg, Tuple[Literal["LON"], RuleVariation_374.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1130.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 64
    cv_items_list = [(Item_466, 32), (Item_494, 32)]
    cv_items_dict = {"LAT": RuleVariation_376, "LON": RuleVariation_374}

    @overload
    @classmethod
    def spec(cls, key : Literal["LAT"]) -> RuleVariation_376:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["LON"]) -> RuleVariation_374:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["LAT"], Literal["LON"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["LAT"]) -> RuleVariation_376:
        ...
    @overload
    def get_item(self, key : Literal["LON"]) -> RuleVariation_374:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1130.cv_arg") -> 'Variation_1130':
        return cls._create(arg) # type: ignore

class RuleVariation_1086(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1130.cv_arg
    cv_variation: TypeAlias = Variation_1130

    @classmethod
    def create(cls, arg : "RuleVariation_1086.cv_arg") -> "RuleVariation_1086":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1130:
        return self.arg # type: ignore

class NonSpare_155(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1086.cv_arg
    cv_name = "041"
    cv_title = "Position in WGS-84 Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1086

    @classmethod
    def create(cls, arg : "NonSpare_155.cv_arg") -> "NonSpare_155":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1086:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1130:
        return self.rule.variation

class UapItem_155(UapItem):
    cv_non_spare: TypeAlias = NonSpare_155

class Content_720(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 1.0
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_720(RuleContentContextFree):
    cv_arg: TypeAlias = Content_720.cv_arg
    cv_content: TypeAlias = Content_720

    @property
    def content(self) -> Content_720:
        return self._get_content() # type: ignore

class Variation_305(Element):
    cv_arg: TypeAlias = RuleContent_720.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_720

    @classmethod
    def create(cls, arg: "Variation_305.cv_arg") -> "Variation_305":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_720:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_720:
        return self.rule.content

class RuleVariation_298(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_305.cv_arg
    cv_variation: TypeAlias = Variation_305

    @classmethod
    def create(cls, arg : "RuleVariation_298.cv_arg") -> "RuleVariation_298":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_305:
        return self.arg # type: ignore

class NonSpare_1592(NonSpare):
    cv_arg: TypeAlias = RuleVariation_298.cv_arg
    cv_name = "RHO"
    cv_title = "RHO"
    cv_rule: TypeAlias = RuleVariation_298

    @classmethod
    def create(cls, arg : "NonSpare_1592.cv_arg") -> "NonSpare_1592":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_298:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_305:
        return self.rule.variation

class Item_817(Item):
    cv_arg: TypeAlias = NonSpare_1592.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1592

    @classmethod
    def create(cls, arg : "Item_817.cv_arg") -> "Item_817":
        return cls._create(arg) # type: ignore

class NonSpare_1854(NonSpare):
    cv_arg: TypeAlias = RuleVariation_336.cv_arg
    cv_name = "TH"
    cv_title = "Theta"
    cv_rule: TypeAlias = RuleVariation_336

    @classmethod
    def create(cls, arg : "NonSpare_1854.cv_arg") -> "NonSpare_1854":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_336:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_343:
        return self.rule.variation

class Item_992(Item):
    cv_arg: TypeAlias = NonSpare_1854.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1854

    @classmethod
    def create(cls, arg : "Item_992.cv_arg") -> "Item_992":
        return cls._create(arg) # type: ignore

class Variation_1181(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_298.cv_arg, Tuple[Literal["RHO"], RuleVariation_298.cv_arg]], Union[RuleVariation_336.cv_arg, Tuple[Literal["TH"], RuleVariation_336.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1181.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_817, 16), (Item_992, 16)]
    cv_items_dict = {"RHO": RuleVariation_298, "TH": RuleVariation_336}

    @overload
    @classmethod
    def spec(cls, key : Literal["RHO"]) -> RuleVariation_298:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TH"]) -> RuleVariation_336:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["RHO"], Literal["TH"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["RHO"]) -> RuleVariation_298:
        ...
    @overload
    def get_item(self, key : Literal["TH"]) -> RuleVariation_336:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1181.cv_arg") -> 'Variation_1181':
        return cls._create(arg) # type: ignore

class RuleVariation_1132(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1181.cv_arg
    cv_variation: TypeAlias = Variation_1181

    @classmethod
    def create(cls, arg : "RuleVariation_1132.cv_arg") -> "RuleVariation_1132":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1181:
        return self.arg # type: ignore

class NonSpare_140(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1132.cv_arg
    cv_name = "040"
    cv_title = "Measured Position in Polar Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1132

    @classmethod
    def create(cls, arg : "NonSpare_140.cv_arg") -> "NonSpare_140":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1132:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1181:
        return self.rule.variation

class UapItem_140(UapItem):
    cv_non_spare: TypeAlias = NonSpare_140

class Content_627(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 1.0
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_627(RuleContentContextFree):
    cv_arg: TypeAlias = Content_627.cv_arg
    cv_content: TypeAlias = Content_627

    @property
    def content(self) -> Content_627:
        return self._get_content() # type: ignore

class Variation_259(Element):
    cv_arg: TypeAlias = RuleContent_627.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_627

    @classmethod
    def create(cls, arg: "Variation_259.cv_arg") -> "Variation_259":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_627:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_627:
        return self.rule.content

class RuleVariation_252(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_259.cv_arg
    cv_variation: TypeAlias = Variation_259

    @classmethod
    def create(cls, arg : "RuleVariation_252.cv_arg") -> "RuleVariation_252":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_259:
        return self.arg # type: ignore

class NonSpare_2095(NonSpare):
    cv_arg: TypeAlias = RuleVariation_252.cv_arg
    cv_name = "X"
    cv_title = "X Coordinate"
    cv_rule: TypeAlias = RuleVariation_252

    @classmethod
    def create(cls, arg : "NonSpare_2095.cv_arg") -> "NonSpare_2095":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_252:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_259:
        return self.rule.variation

class Item_1196(Item):
    cv_arg: TypeAlias = NonSpare_2095.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2095

    @classmethod
    def create(cls, arg : "Item_1196.cv_arg") -> "Item_1196":
        return cls._create(arg) # type: ignore

class NonSpare_2149(NonSpare):
    cv_arg: TypeAlias = RuleVariation_252.cv_arg
    cv_name = "Y"
    cv_title = "Y Coordinate"
    cv_rule: TypeAlias = RuleVariation_252

    @classmethod
    def create(cls, arg : "NonSpare_2149.cv_arg") -> "NonSpare_2149":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_252:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_259:
        return self.rule.variation

class Item_1247(Item):
    cv_arg: TypeAlias = NonSpare_2149.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2149

    @classmethod
    def create(cls, arg : "Item_1247.cv_arg") -> "Item_1247":
        return cls._create(arg) # type: ignore

class Variation_1309(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_252.cv_arg, Tuple[Literal["X"], RuleVariation_252.cv_arg]], Union[RuleVariation_252.cv_arg, Tuple[Literal["Y"], RuleVariation_252.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1309.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1196, 16), (Item_1247, 16)]
    cv_items_dict = {"X": RuleVariation_252, "Y": RuleVariation_252}

    @overload
    @classmethod
    def spec(cls, key : Literal["X"]) -> RuleVariation_252:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y"]) -> RuleVariation_252:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X"], Literal["Y"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X"]) -> RuleVariation_252:
        ...
    @overload
    def get_item(self, key : Literal["Y"]) -> RuleVariation_252:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1309.cv_arg") -> 'Variation_1309':
        return cls._create(arg) # type: ignore

class RuleVariation_1237(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1309.cv_arg
    cv_variation: TypeAlias = Variation_1309

    @classmethod
    def create(cls, arg : "RuleVariation_1237.cv_arg") -> "RuleVariation_1237":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1309:
        return self.arg # type: ignore

class NonSpare_161(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1237.cv_arg
    cv_name = "042"
    cv_title = "Position in Cartesian Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1237

    @classmethod
    def create(cls, arg : "NonSpare_161.cv_arg") -> "NonSpare_161":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1237:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1309:
        return self.rule.variation

class UapItem_161(UapItem):
    cv_non_spare: TypeAlias = NonSpare_161

class Content_780(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM/s"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 6.103515625e-5
    cv_unit = "NM/s"

    def as_quantity(self, cv_unit : Optional[Literal["NM/s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_779(RuleContentContextFree):
    cv_arg: TypeAlias = Content_780.cv_arg
    cv_content: TypeAlias = Content_780

    @property
    def content(self) -> Content_780:
        return self._get_content() # type: ignore

class Variation_339(Element):
    cv_arg: TypeAlias = RuleContent_779.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_779

    @classmethod
    def create(cls, arg: "Variation_339.cv_arg") -> "Variation_339":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_779:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_780:
        return self.rule.content

class RuleVariation_332(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_339.cv_arg
    cv_variation: TypeAlias = Variation_339

    @classmethod
    def create(cls, arg : "RuleVariation_332.cv_arg") -> "RuleVariation_332":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_339:
        return self.arg # type: ignore

class NonSpare_1042(NonSpare):
    cv_arg: TypeAlias = RuleVariation_332.cv_arg
    cv_name = "GSP"
    cv_title = "Ground Speed"
    cv_rule: TypeAlias = RuleVariation_332

    @classmethod
    def create(cls, arg : "NonSpare_1042.cv_arg") -> "NonSpare_1042":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_332:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_339:
        return self.rule.variation

class Item_376(Item):
    cv_arg: TypeAlias = NonSpare_1042.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1042

    @classmethod
    def create(cls, arg : "Item_376.cv_arg") -> "Item_376":
        return cls._create(arg) # type: ignore

class NonSpare_1901(NonSpare):
    cv_arg: TypeAlias = RuleVariation_336.cv_arg
    cv_name = "TRA"
    cv_title = "Track Angle"
    cv_rule: TypeAlias = RuleVariation_336

    @classmethod
    def create(cls, arg : "NonSpare_1901.cv_arg") -> "NonSpare_1901":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_336:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_343:
        return self.rule.variation

class Item_1024(Item):
    cv_arg: TypeAlias = NonSpare_1901.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1901

    @classmethod
    def create(cls, arg : "Item_1024.cv_arg") -> "Item_1024":
        return cls._create(arg) # type: ignore

class Variation_1115(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_332.cv_arg, Tuple[Literal["GSP"], RuleVariation_332.cv_arg]], Union[RuleVariation_336.cv_arg, Tuple[Literal["TRA"], RuleVariation_336.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1115.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_376, 16), (Item_1024, 16)]
    cv_items_dict = {"GSP": RuleVariation_332, "TRA": RuleVariation_336}

    @overload
    @classmethod
    def spec(cls, key : Literal["GSP"]) -> RuleVariation_332:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TRA"]) -> RuleVariation_336:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["GSP"], Literal["TRA"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["GSP"]) -> RuleVariation_332:
        ...
    @overload
    def get_item(self, key : Literal["TRA"]) -> RuleVariation_336:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1115.cv_arg") -> 'Variation_1115':
        return cls._create(arg) # type: ignore

class RuleVariation_1073(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1115.cv_arg
    cv_variation: TypeAlias = Variation_1115

    @classmethod
    def create(cls, arg : "RuleVariation_1073.cv_arg") -> "RuleVariation_1073":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1115:
        return self.arg # type: ignore

class NonSpare_391(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1073.cv_arg
    cv_name = "200"
    cv_title = "Calculated Track Velocity in Polar Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1073

    @classmethod
    def create(cls, arg : "NonSpare_391.cv_arg") -> "NonSpare_391":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1073:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1115:
        return self.rule.variation

class UapItem_391(UapItem):
    cv_non_spare: TypeAlias = NonSpare_391

class Content_669(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m/s"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 6.25e-2
    cv_unit = "m/s"

    def as_quantity(self, cv_unit : Optional[Literal["m/s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_669(RuleContentContextFree):
    cv_arg: TypeAlias = Content_669.cv_arg
    cv_content: TypeAlias = Content_669

    @property
    def content(self) -> Content_669:
        return self._get_content() # type: ignore

class Variation_282(Element):
    cv_arg: TypeAlias = RuleContent_669.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_669

    @classmethod
    def create(cls, arg: "Variation_282.cv_arg") -> "Variation_282":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_669:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_669:
        return self.rule.content

class RuleVariation_275(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_282.cv_arg
    cv_variation: TypeAlias = Variation_282

    @classmethod
    def create(cls, arg : "RuleVariation_275.cv_arg") -> "RuleVariation_275":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_282:
        return self.arg # type: ignore

class NonSpare_2052(NonSpare):
    cv_arg: TypeAlias = RuleVariation_275.cv_arg
    cv_name = "VX"
    cv_title = "X Velocity"
    cv_rule: TypeAlias = RuleVariation_275

    @classmethod
    def create(cls, arg : "NonSpare_2052.cv_arg") -> "NonSpare_2052":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_275:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_282:
        return self.rule.variation

class Item_1158(Item):
    cv_arg: TypeAlias = NonSpare_2052.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2052

    @classmethod
    def create(cls, arg : "Item_1158.cv_arg") -> "Item_1158":
        return cls._create(arg) # type: ignore

class NonSpare_2057(NonSpare):
    cv_arg: TypeAlias = RuleVariation_275.cv_arg
    cv_name = "VY"
    cv_title = "Y Velocity"
    cv_rule: TypeAlias = RuleVariation_275

    @classmethod
    def create(cls, arg : "NonSpare_2057.cv_arg") -> "NonSpare_2057":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_275:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_282:
        return self.rule.variation

class Item_1163(Item):
    cv_arg: TypeAlias = NonSpare_2057.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2057

    @classmethod
    def create(cls, arg : "Item_1163.cv_arg") -> "Item_1163":
        return cls._create(arg) # type: ignore

class Variation_1283(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_275.cv_arg, Tuple[Literal["VX"], RuleVariation_275.cv_arg]], Union[RuleVariation_275.cv_arg, Tuple[Literal["VY"], RuleVariation_275.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1283.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1158, 16), (Item_1163, 16)]
    cv_items_dict = {"VX": RuleVariation_275, "VY": RuleVariation_275}

    @overload
    @classmethod
    def spec(cls, key : Literal["VX"]) -> RuleVariation_275:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["VY"]) -> RuleVariation_275:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["VX"], Literal["VY"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["VX"]) -> RuleVariation_275:
        ...
    @overload
    def get_item(self, key : Literal["VY"]) -> RuleVariation_275:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1283.cv_arg") -> 'Variation_1283':
        return cls._create(arg) # type: ignore

class RuleVariation_1212(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1283.cv_arg
    cv_variation: TypeAlias = Variation_1283

    @classmethod
    def create(cls, arg : "RuleVariation_1212.cv_arg") -> "RuleVariation_1212":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1283:
        return self.arg # type: ignore

class NonSpare_404(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1212.cv_arg
    cv_name = "202"
    cv_title = "Calculated Track Velocity in Cartesian Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1212

    @classmethod
    def create(cls, arg : "NonSpare_404.cv_arg") -> "NonSpare_404":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1212:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1283:
        return self.rule.variation

class UapItem_404(UapItem):
    cv_non_spare: TypeAlias = NonSpare_404

class NonSpare_1919(NonSpare):
    cv_arg: TypeAlias = RuleVariation_778.cv_arg
    cv_name = "TRK"
    cv_title = "Track Number"
    cv_rule: TypeAlias = RuleVariation_778

    @classmethod
    def create(cls, arg : "NonSpare_1919.cv_arg") -> "NonSpare_1919":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_778:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_808:
        return self.rule.variation

class Item_1038(Item):
    cv_arg: TypeAlias = NonSpare_1919.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1919

    @classmethod
    def create(cls, arg : "Item_1038.cv_arg") -> "Item_1038":
        return cls._create(arg) # type: ignore

class Variation_1034(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_778.cv_arg, Tuple[Literal["TRK"], RuleVariation_778.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1034.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_3, 4), (Item_1038, 12)]
    cv_items_dict = {"TRK": RuleVariation_778}

    @classmethod
    def spec(cls, key : Literal["TRK"]) -> RuleVariation_778:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["TRK"]) -> RuleVariation_778:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1034.cv_arg") -> 'Variation_1034':
        return cls._create(arg) # type: ignore

class RuleVariation_1002(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1034.cv_arg
    cv_variation: TypeAlias = Variation_1034

    @classmethod
    def create(cls, arg : "RuleVariation_1002.cv_arg") -> "RuleVariation_1002":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1034:
        return self.arg # type: ignore

class NonSpare_362(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1002.cv_arg
    cv_name = "161"
    cv_title = "Track Number"
    cv_rule: TypeAlias = RuleVariation_1002

    @classmethod
    def create(cls, arg : "NonSpare_362.cv_arg") -> "NonSpare_362":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1002:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1034:
        return self.rule.variation

class UapItem_362(UapItem):
    cv_non_spare: TypeAlias = NonSpare_362

class Content_63(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Confirmed track", 1: "Track in initialisation phase"}

class RuleContent_63(RuleContentContextFree):
    cv_arg: TypeAlias = Content_63.cv_arg
    cv_content: TypeAlias = Content_63

    @property
    def content(self) -> Content_63:
        return self._get_content() # type: ignore

class Variation_18(Element):
    cv_arg: TypeAlias = RuleContent_63.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_63

    @classmethod
    def create(cls, arg: "Variation_18.cv_arg") -> "Variation_18":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_63:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_63:
        return self.rule.content

class RuleVariation_18(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_18.cv_arg
    cv_variation: TypeAlias = Variation_18

    @classmethod
    def create(cls, arg : "RuleVariation_18.cv_arg") -> "RuleVariation_18":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_18:
        return self.arg # type: ignore

class Variation_411(Element):
    cv_arg: TypeAlias = RuleContent_112.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_112

    @classmethod
    def create(cls, arg: "Variation_411.cv_arg") -> "Variation_411":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_112:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_112:
        return self.rule.content

class RuleVariation_400(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_411.cv_arg
    cv_variation: TypeAlias = Variation_411

    @classmethod
    def create(cls, arg : "RuleVariation_400.cv_arg") -> "RuleVariation_400":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_411:
        return self.arg # type: ignore

class Content_361(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No extrapolation", 1: "Predictable extrapolation due to sensor refresh period (see NOTE)", 2: "Predictable extrapolation in masked area", 3: "Extrapolation due to unpredictable absence of detection"}

class RuleContent_361(RuleContentContextFree):
    cv_arg: TypeAlias = Content_361.cv_arg
    cv_content: TypeAlias = Content_361

    @property
    def content(self) -> Content_361:
        return self._get_content() # type: ignore

class Variation_594(Element):
    cv_arg: TypeAlias = RuleContent_361.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 2
    cv_rule = RuleContent_361

    @classmethod
    def create(cls, arg: "Variation_594.cv_arg") -> "Variation_594":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_361:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_361:
        return self.rule.content

class RuleVariation_583(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_594.cv_arg
    cv_variation: TypeAlias = Variation_594

    @classmethod
    def create(cls, arg : "RuleVariation_583.cv_arg") -> "RuleVariation_583":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_594:
        return self.arg # type: ignore

class Content_105(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Horizontal manoeuvre"}

class RuleContent_105(RuleContentContextFree):
    cv_arg: TypeAlias = Content_105.cv_arg
    cv_content: TypeAlias = Content_105

    @property
    def content(self) -> Content_105:
        return self._get_content() # type: ignore

class Variation_706(Element):
    cv_arg: TypeAlias = RuleContent_105.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_105

    @classmethod
    def create(cls, arg: "Variation_706.cv_arg") -> "Variation_706":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_105:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_105:
        return self.rule.content

class RuleVariation_695(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_706.cv_arg
    cv_variation: TypeAlias = Variation_706

    @classmethod
    def create(cls, arg : "RuleVariation_695.cv_arg") -> "RuleVariation_695":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_706:
        return self.arg # type: ignore

class Content_515(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Tracking performed in 'Sensor Plane', i.e. neither slant range correction nor projection was applied", 1: "Slant range correction and a suitable projection technique are used to track in a 2D.reference plane, tangential to the earth model at the Sensor Site co-ordinates"}

class RuleContent_515(RuleContentContextFree):
    cv_arg: TypeAlias = Content_515.cv_arg
    cv_content: TypeAlias = Content_515

    @property
    def content(self) -> Content_515:
        return self._get_content() # type: ignore

class Variation_874(Element):
    cv_arg: TypeAlias = RuleContent_515.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_515

    @classmethod
    def create(cls, arg: "Variation_874.cv_arg") -> "Variation_874":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_515:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_515:
        return self.rule.content

class RuleVariation_844(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_874.cv_arg
    cv_variation: TypeAlias = Variation_874

    @classmethod
    def create(cls, arg : "RuleVariation_844.cv_arg") -> "RuleVariation_844":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_874:
        return self.arg # type: ignore

class Content_268(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Measured position", 1: "Smoothed position"}

class RuleContent_268(RuleContentContextFree):
    cv_arg: TypeAlias = Content_268.cv_arg
    cv_content: TypeAlias = Content_268

    @property
    def content(self) -> Content_268:
        return self._get_content() # type: ignore

class Variation_937(Element):
    cv_arg: TypeAlias = RuleContent_268.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_268

    @classmethod
    def create(cls, arg: "Variation_937.cv_arg") -> "Variation_937":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_268:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_268:
        return self.rule.content

class RuleVariation_907(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_937.cv_arg
    cv_variation: TypeAlias = Variation_937

    @classmethod
    def create(cls, arg : "RuleVariation_907.cv_arg") -> "RuleVariation_907":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_937:
        return self.arg # type: ignore

class Content_554(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Unknown type of movement", 1: "Taking-off", 2: "Landing", 3: "Other types of movement"}

class RuleContent_554(RuleContentContextFree):
    cv_arg: TypeAlias = Content_554.cv_arg
    cv_content: TypeAlias = Content_554

    @property
    def content(self) -> Content_554:
        return self._get_content() # type: ignore

class Variation_117(Element):
    cv_arg: TypeAlias = RuleContent_554.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 2
    cv_rule = RuleContent_554

    @classmethod
    def create(cls, arg: "Variation_117.cv_arg") -> "Variation_117":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_554:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_554:
        return self.rule.content

class RuleVariation_117(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_117.cv_arg
    cv_variation: TypeAlias = Variation_117

    @classmethod
    def create(cls, arg : "RuleVariation_117.cv_arg") -> "RuleVariation_117":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_117:
        return self.arg # type: ignore

class Content_353(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No doubt", 1: "Doubtful correlation (undetermined reason)", 2: "Doubtful correlation in clutter", 3: "Loss of accuracy", 4: "Loss of accuracy in clutter", 5: "Unstable track", 6: "Previously coasted"}

class RuleContent_353(RuleContentContextFree):
    cv_arg: TypeAlias = Content_353.cv_arg
    cv_content: TypeAlias = Content_353

    @property
    def content(self) -> Content_353:
        return self._get_content() # type: ignore

class Variation_600(Element):
    cv_arg: TypeAlias = RuleContent_353.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 3
    cv_rule = RuleContent_353

    @classmethod
    def create(cls, arg: "Variation_600.cv_arg") -> "Variation_600":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_353:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_353:
        return self.rule.content

class RuleVariation_589(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_600.cv_arg
    cv_variation: TypeAlias = Variation_600

    @classmethod
    def create(cls, arg : "RuleVariation_589.cv_arg") -> "RuleVariation_589":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_600:
        return self.arg # type: ignore

class Content_269(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Merge or split indication undetermined", 1: "Track merged by association to plot", 2: "Track merged by non-association to plot", 3: "Split track"}

class RuleContent_269(RuleContentContextFree):
    cv_arg: TypeAlias = Content_269.cv_arg
    cv_content: TypeAlias = Content_269

    @property
    def content(self) -> Content_269:
        return self._get_content() # type: ignore

class Variation_879(Element):
    cv_arg: TypeAlias = RuleContent_269.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 2
    cv_rule = RuleContent_269

    @classmethod
    def create(cls, arg: "Variation_879.cv_arg") -> "Variation_879":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_269:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_269:
        return self.rule.content

class RuleVariation_849(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_879.cv_arg
    cv_variation: TypeAlias = Variation_879

    @classmethod
    def create(cls, arg : "RuleVariation_849.cv_arg") -> "RuleVariation_849":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_879:
        return self.arg # type: ignore

class Variation_28(Element):
    cv_arg: TypeAlias = RuleContent_99.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_99

    @classmethod
    def create(cls, arg: "Variation_28.cv_arg") -> "Variation_28":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_99:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_99:
        return self.rule.content

class RuleVariation_28(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_28.cv_arg
    cv_variation: TypeAlias = Variation_28

    @classmethod
    def create(cls, arg : "RuleVariation_28.cv_arg") -> "RuleVariation_28":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_28:
        return self.arg # type: ignore

class NonSpare_747(NonSpare):
    cv_arg: TypeAlias = RuleVariation_18.cv_arg
    cv_name = "CNF"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_18

    @classmethod
    def create(cls, arg : "NonSpare_747.cv_arg") -> "NonSpare_747":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_18:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_18:
        return self.rule.variation

class Item_165(Item):
    cv_arg: TypeAlias = NonSpare_747.cv_arg
    cv_non_spare: TypeAlias = NonSpare_747

    @classmethod
    def create(cls, arg : "Item_165.cv_arg") -> "Item_165":
        return cls._create(arg) # type: ignore

class NonSpare_1915(NonSpare):
    cv_arg: TypeAlias = RuleVariation_400.cv_arg
    cv_name = "TRE"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_400

    @classmethod
    def create(cls, arg : "NonSpare_1915.cv_arg") -> "NonSpare_1915":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_400:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_411:
        return self.rule.variation

class Item_1036(Item):
    cv_arg: TypeAlias = NonSpare_1915.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1915

    @classmethod
    def create(cls, arg : "Item_1036.cv_arg") -> "Item_1036":
        return cls._create(arg) # type: ignore

class NonSpare_842(NonSpare):
    cv_arg: TypeAlias = RuleVariation_583.cv_arg
    cv_name = "CST"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_583

    @classmethod
    def create(cls, arg : "NonSpare_842.cv_arg") -> "NonSpare_842":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_583:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_594:
        return self.rule.variation

class Item_225(Item):
    cv_arg: TypeAlias = NonSpare_842.cv_arg
    cv_non_spare: TypeAlias = NonSpare_842

    @classmethod
    def create(cls, arg : "Item_225.cv_arg") -> "Item_225":
        return cls._create(arg) # type: ignore

class NonSpare_1224(NonSpare):
    cv_arg: TypeAlias = RuleVariation_695.cv_arg
    cv_name = "MAH"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_695

    @classmethod
    def create(cls, arg : "NonSpare_1224.cv_arg") -> "NonSpare_1224":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_695:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_706:
        return self.rule.variation

class Item_524(Item):
    cv_arg: TypeAlias = NonSpare_1224.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1224

    @classmethod
    def create(cls, arg : "Item_524.cv_arg") -> "Item_524":
        return cls._create(arg) # type: ignore

class NonSpare_1840(NonSpare):
    cv_arg: TypeAlias = RuleVariation_844.cv_arg
    cv_name = "TCC"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_844

    @classmethod
    def create(cls, arg : "NonSpare_1840.cv_arg") -> "NonSpare_1840":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_844:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_874:
        return self.rule.variation

class Item_979(Item):
    cv_arg: TypeAlias = NonSpare_1840.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1840

    @classmethod
    def create(cls, arg : "Item_979.cv_arg") -> "Item_979":
        return cls._create(arg) # type: ignore

class NonSpare_1789(NonSpare):
    cv_arg: TypeAlias = RuleVariation_907.cv_arg
    cv_name = "STH"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_907

    @classmethod
    def create(cls, arg : "NonSpare_1789.cv_arg") -> "NonSpare_1789":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_907:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_937:
        return self.rule.variation

class Item_949(Item):
    cv_arg: TypeAlias = NonSpare_1789.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1789

    @classmethod
    def create(cls, arg : "Item_949.cv_arg") -> "Item_949":
        return cls._create(arg) # type: ignore

class NonSpare_1884(NonSpare):
    cv_arg: TypeAlias = RuleVariation_117.cv_arg
    cv_name = "TOM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_117

    @classmethod
    def create(cls, arg : "NonSpare_1884.cv_arg") -> "NonSpare_1884":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_117:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_117:
        return self.rule.variation

class Item_1009(Item):
    cv_arg: TypeAlias = NonSpare_1884.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1884

    @classmethod
    def create(cls, arg : "Item_1009.cv_arg") -> "Item_1009":
        return cls._create(arg) # type: ignore

class NonSpare_893(NonSpare):
    cv_arg: TypeAlias = RuleVariation_589.cv_arg
    cv_name = "DOU"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_589

    @classmethod
    def create(cls, arg : "NonSpare_893.cv_arg") -> "NonSpare_893":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_589:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_600:
        return self.rule.variation

class Item_268(Item):
    cv_arg: TypeAlias = NonSpare_893.cv_arg
    cv_non_spare: TypeAlias = NonSpare_893

    @classmethod
    def create(cls, arg : "Item_268.cv_arg") -> "Item_268":
        return cls._create(arg) # type: ignore

class NonSpare_1317(NonSpare):
    cv_arg: TypeAlias = RuleVariation_849.cv_arg
    cv_name = "MRS"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_849

    @classmethod
    def create(cls, arg : "NonSpare_1317.cv_arg") -> "NonSpare_1317":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_849:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_879:
        return self.rule.variation

class Item_583(Item):
    cv_arg: TypeAlias = NonSpare_1317.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1317

    @classmethod
    def create(cls, arg : "Item_583.cv_arg") -> "Item_583":
        return cls._create(arg) # type: ignore

class NonSpare_1035(NonSpare):
    cv_arg: TypeAlias = RuleVariation_28.cv_arg
    cv_name = "GHO"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_28

    @classmethod
    def create(cls, arg : "NonSpare_1035.cv_arg") -> "NonSpare_1035":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_28:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_28:
        return self.rule.variation

class Item_370(Item):
    cv_arg: TypeAlias = NonSpare_1035.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1035

    @classmethod
    def create(cls, arg : "Item_370.cv_arg") -> "Item_370":
        return cls._create(arg) # type: ignore

class Variation_1351(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_18.cv_arg, Tuple[Literal["CNF"], RuleVariation_18.cv_arg]], Union[RuleVariation_400.cv_arg, Tuple[Literal["TRE"], RuleVariation_400.cv_arg]], Union[RuleVariation_583.cv_arg, Tuple[Literal["CST"], RuleVariation_583.cv_arg]], Union[RuleVariation_695.cv_arg, Tuple[Literal["MAH"], RuleVariation_695.cv_arg]], Union[RuleVariation_844.cv_arg, Tuple[Literal["TCC"], RuleVariation_844.cv_arg]], Union[RuleVariation_907.cv_arg, Tuple[Literal["STH"], RuleVariation_907.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_117.cv_arg, Tuple[Literal["TOM"], RuleVariation_117.cv_arg]], Union[RuleVariation_589.cv_arg, Tuple[Literal["DOU"], RuleVariation_589.cv_arg]], Union[RuleVariation_849.cv_arg, Tuple[Literal["MRS"], RuleVariation_849.cv_arg]], None]]
    cv_arg_group_3: TypeAlias = Union[int, Tuple[Union[RuleVariation_28.cv_arg, Tuple[Literal["GHO"], RuleVariation_28.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1351.cv_arg_group_1"],
        Tuple["Variation_1351.cv_arg_group_1", "Variation_1351.cv_arg_group_2"],
        Tuple["Variation_1351.cv_arg_group_1", "Variation_1351.cv_arg_group_2", "Variation_1351.cv_arg_group_3"],
    ]
    cv_items_list = [[(Item_165, 1), (Item_1036, 1), (Item_225, 2), (Item_524, 1), (Item_979, 1), (Item_949, 1), None], [(Item_1009, 2), (Item_268, 3), (Item_583, 2), None], [(Item_370, 1), (Item_9, 6), None]]

    @classmethod
    def create(cls, arg: "Variation_1351.cv_arg") -> 'Variation_1351':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["CNF"]) -> RuleVariation_18:
        ...
    @overload
    def get_item(self, key : Literal["TRE"]) -> RuleVariation_400:
        ...
    @overload
    def get_item(self, key : Literal["CST"]) -> RuleVariation_583:
        ...
    @overload
    def get_item(self, key : Literal["MAH"]) -> RuleVariation_695:
        ...
    @overload
    def get_item(self, key : Literal["TCC"]) -> RuleVariation_844:
        ...
    @overload
    def get_item(self, key : Literal["STH"]) -> RuleVariation_907:
        ...
    @overload
    def get_item(self, key : Literal["TOM"]) -> Optional[RuleVariation_117]:
        ...
    @overload
    def get_item(self, key : Literal["DOU"]) -> Optional[RuleVariation_589]:
        ...
    @overload
    def get_item(self, key : Literal["MRS"]) -> Optional[RuleVariation_849]:
        ...
    @overload
    def get_item(self, key : Literal["GHO"]) -> Optional[RuleVariation_28]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1272(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1351.cv_arg
    cv_variation: TypeAlias = Variation_1351

    @classmethod
    def create(cls, arg : "RuleVariation_1272.cv_arg") -> "RuleVariation_1272":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1351:
        return self.arg # type: ignore

class NonSpare_374(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1272.cv_arg
    cv_name = "170"
    cv_title = "Track Status"
    cv_rule: TypeAlias = RuleVariation_1272

    @classmethod
    def create(cls, arg : "NonSpare_374.cv_arg") -> "NonSpare_374":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1272:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1351:
        return self.rule.variation

class UapItem_374(UapItem):
    cv_non_spare: TypeAlias = NonSpare_374

class NonSpare_1991(NonSpare):
    cv_arg: TypeAlias = RuleVariation_15.cv_arg
    cv_name = "V"
    cv_title = "Validated"
    cv_rule: TypeAlias = RuleVariation_15

    @classmethod
    def create(cls, arg : "NonSpare_1991.cv_arg") -> "NonSpare_1991":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_15:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_15:
        return self.rule.variation

class Item_1103(Item):
    cv_arg: TypeAlias = NonSpare_1991.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1991

    @classmethod
    def create(cls, arg : "Item_1103.cv_arg") -> "Item_1103":
        return cls._create(arg) # type: ignore

class NonSpare_1011(NonSpare):
    cv_arg: TypeAlias = RuleVariation_396.cv_arg
    cv_name = "G"
    cv_title = "Garbled"
    cv_rule: TypeAlias = RuleVariation_396

    @classmethod
    def create(cls, arg : "NonSpare_1011.cv_arg") -> "NonSpare_1011":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_396:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_407:
        return self.rule.variation

class Item_357(Item):
    cv_arg: TypeAlias = NonSpare_1011.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1011

    @classmethod
    def create(cls, arg : "Item_357.cv_arg") -> "Item_357":
        return cls._create(arg) # type: ignore

class Content_290(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Mode-3/A code derived from the reply of the transponder", 1: "Mode-3/A code not extracted during the last scan"}

class RuleContent_290(RuleContentContextFree):
    cv_arg: TypeAlias = Content_290.cv_arg
    cv_content: TypeAlias = Content_290

    @property
    def content(self) -> Content_290:
        return self._get_content() # type: ignore

class Variation_553(Element):
    cv_arg: TypeAlias = RuleContent_290.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_290

    @classmethod
    def create(cls, arg: "Variation_553.cv_arg") -> "Variation_553":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_290:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_290:
        return self.rule.content

class RuleVariation_542(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_553.cv_arg
    cv_variation: TypeAlias = Variation_553

    @classmethod
    def create(cls, arg : "RuleVariation_542.cv_arg") -> "RuleVariation_542":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_553:
        return self.arg # type: ignore

class NonSpare_1141(NonSpare):
    cv_arg: TypeAlias = RuleVariation_542.cv_arg
    cv_name = "L"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_542

    @classmethod
    def create(cls, arg : "NonSpare_1141.cv_arg") -> "NonSpare_1141":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_542:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_553:
        return self.rule.variation

class Item_453(Item):
    cv_arg: TypeAlias = NonSpare_1141.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1141

    @classmethod
    def create(cls, arg : "Item_453.cv_arg") -> "Item_453":
        return cls._create(arg) # type: ignore

class Variation_1275(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_15.cv_arg, Tuple[Literal["V"], RuleVariation_15.cv_arg]], Union[RuleVariation_396.cv_arg, Tuple[Literal["G"], RuleVariation_396.cv_arg]], Union[RuleVariation_542.cv_arg, Tuple[Literal["L"], RuleVariation_542.cv_arg]], int, Union[RuleVariation_779.cv_arg, Tuple[Literal["MODE3A"], RuleVariation_779.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1275.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_1103, 1), (Item_357, 1), (Item_453, 1), (Item_16, 1), (Item_575, 12)]
    cv_items_dict = {"V": RuleVariation_15, "G": RuleVariation_396, "L": RuleVariation_542, "MODE3A": RuleVariation_779}

    @overload
    @classmethod
    def spec(cls, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> RuleVariation_396:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["L"]) -> RuleVariation_542:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MODE3A"]) -> RuleVariation_779:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["V"], Literal["G"], Literal["L"], Literal["MODE3A"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> RuleVariation_396:
        ...
    @overload
    def get_item(self, key : Literal["L"]) -> RuleVariation_542:
        ...
    @overload
    def get_item(self, key : Literal["MODE3A"]) -> RuleVariation_779:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1275.cv_arg") -> 'Variation_1275':
        return cls._create(arg) # type: ignore

class RuleVariation_1204(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1275.cv_arg
    cv_variation: TypeAlias = Variation_1275

    @classmethod
    def create(cls, arg : "RuleVariation_1204.cv_arg") -> "RuleVariation_1204":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1275:
        return self.arg # type: ignore

class NonSpare_192(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1204.cv_arg
    cv_name = "060"
    cv_title = "Mode-3/A Code in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_1204

    @classmethod
    def create(cls, arg : "NonSpare_192.cv_arg") -> "NonSpare_192":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1204:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1275:
        return self.rule.variation

class UapItem_192(UapItem):
    cv_non_spare: TypeAlias = NonSpare_192

class Variation_349(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_349.cv_arg") -> "Variation_349":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_342(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_349.cv_arg
    cv_variation: TypeAlias = Variation_349

    @classmethod
    def create(cls, arg : "RuleVariation_342.cv_arg") -> "RuleVariation_342":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_349:
        return self.arg # type: ignore

class NonSpare_426(NonSpare):
    cv_arg: TypeAlias = RuleVariation_342.cv_arg
    cv_name = "220"
    cv_title = "Target Address"
    cv_rule: TypeAlias = RuleVariation_342

    @classmethod
    def create(cls, arg : "NonSpare_426.cv_arg") -> "NonSpare_426":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_342:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_349:
        return self.rule.variation

class UapItem_426(UapItem):
    cv_non_spare: TypeAlias = NonSpare_426

class Content_51(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Callsign or registration downlinked from transponder", 1: "Callsign not downlinked from transponder", 2: "Registration not downlinked from transponder"}

class RuleContent_51(RuleContentContextFree):
    cv_arg: TypeAlias = Content_51.cv_arg
    cv_content: TypeAlias = Content_51

    @property
    def content(self) -> Content_51:
        return self._get_content() # type: ignore

class Variation_98(Element):
    cv_arg: TypeAlias = RuleContent_51.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 2
    cv_rule = RuleContent_51

    @classmethod
    def create(cls, arg: "Variation_98.cv_arg") -> "Variation_98":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_51:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_51:
        return self.rule.content

class RuleVariation_98(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_98.cv_arg
    cv_variation: TypeAlias = Variation_98

    @classmethod
    def create(cls, arg : "RuleVariation_98.cv_arg") -> "RuleVariation_98":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_98:
        return self.arg # type: ignore

class NonSpare_1791(NonSpare):
    cv_arg: TypeAlias = RuleVariation_98.cv_arg
    cv_name = "STI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_98

    @classmethod
    def create(cls, arg : "NonSpare_1791.cv_arg") -> "NonSpare_1791":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_98:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_98:
        return self.rule.variation

class Item_951(Item):
    cv_arg: TypeAlias = NonSpare_1791.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1791

    @classmethod
    def create(cls, arg : "Item_951.cv_arg") -> "Item_951":
        return cls._create(arg) # type: ignore

class Item_15(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 2
    cv_bit_size = 6

class NonSpare_736(NonSpare):
    cv_arg: TypeAlias = RuleVariation_383.cv_arg
    cv_name = "CHR"
    cv_title = "Characters 1-8 (Coded on 6 Bits Each) Defining Target Identification"
    cv_rule: TypeAlias = RuleVariation_383

    @classmethod
    def create(cls, arg : "NonSpare_736.cv_arg") -> "NonSpare_736":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_391:
        return self.rule.variation

class Item_158(Item):
    cv_arg: TypeAlias = NonSpare_736.cv_arg
    cv_non_spare: TypeAlias = NonSpare_736

    @classmethod
    def create(cls, arg : "Item_158.cv_arg") -> "Item_158":
        return cls._create(arg) # type: ignore

class Variation_1216(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_98.cv_arg, Tuple[Literal["STI"], RuleVariation_98.cv_arg]], int, Union[RuleVariation_383.cv_arg, Tuple[Literal["CHR"], RuleVariation_383.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1216.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 56
    cv_items_list = [(Item_951, 2), (Item_15, 6), (Item_158, 48)]
    cv_items_dict = {"STI": RuleVariation_98, "CHR": RuleVariation_383}

    @overload
    @classmethod
    def spec(cls, key : Literal["STI"]) -> RuleVariation_98:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CHR"]) -> RuleVariation_383:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["STI"], Literal["CHR"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["STI"]) -> RuleVariation_98:
        ...
    @overload
    def get_item(self, key : Literal["CHR"]) -> RuleVariation_383:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1216.cv_arg") -> 'Variation_1216':
        return cls._create(arg) # type: ignore

class RuleVariation_1160(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1216.cv_arg
    cv_variation: TypeAlias = Variation_1216

    @classmethod
    def create(cls, arg : "RuleVariation_1160.cv_arg") -> "RuleVariation_1160":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1216:
        return self.arg # type: ignore

class NonSpare_441(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1160.cv_arg
    cv_name = "245"
    cv_title = "Target Identification"
    cv_rule: TypeAlias = RuleVariation_1160

    @classmethod
    def create(cls, arg : "NonSpare_441.cv_arg") -> "NonSpare_441":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1160:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1216:
        return self.rule.variation

class UapItem_441(UapItem):
    cv_non_spare: TypeAlias = NonSpare_441

class Variation_392(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 56
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_392.cv_arg") -> "Variation_392":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_384(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_392.cv_arg
    cv_variation: TypeAlias = Variation_392

    @classmethod
    def create(cls, arg : "RuleVariation_384.cv_arg") -> "RuleVariation_384":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_392:
        return self.arg # type: ignore

class NonSpare_1235(NonSpare):
    cv_arg: TypeAlias = RuleVariation_384.cv_arg
    cv_name = "MBDATA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_384

    @classmethod
    def create(cls, arg : "NonSpare_1235.cv_arg") -> "NonSpare_1235":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_384:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_392:
        return self.rule.variation

class Item_531(Item):
    cv_arg: TypeAlias = NonSpare_1235.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1235

    @classmethod
    def create(cls, arg : "Item_531.cv_arg") -> "Item_531":
        return cls._create(arg) # type: ignore

class NonSpare_675(NonSpare):
    cv_arg: TypeAlias = RuleVariation_132.cv_arg
    cv_name = "BDS1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_132

    @classmethod
    def create(cls, arg : "NonSpare_675.cv_arg") -> "NonSpare_675":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_132:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_132:
        return self.rule.variation

class Item_115(Item):
    cv_arg: TypeAlias = NonSpare_675.cv_arg
    cv_non_spare: TypeAlias = NonSpare_675

    @classmethod
    def create(cls, arg : "Item_115.cv_arg") -> "Item_115":
        return cls._create(arg) # type: ignore

class Variation_799(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 4
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_799.cv_arg") -> "Variation_799":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_769(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_799.cv_arg
    cv_variation: TypeAlias = Variation_799

    @classmethod
    def create(cls, arg : "RuleVariation_769.cv_arg") -> "RuleVariation_769":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_799:
        return self.arg # type: ignore

class NonSpare_677(NonSpare):
    cv_arg: TypeAlias = RuleVariation_769.cv_arg
    cv_name = "BDS2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_769

    @classmethod
    def create(cls, arg : "NonSpare_677.cv_arg") -> "NonSpare_677":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_769:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_799:
        return self.rule.variation

class Item_117(Item):
    cv_arg: TypeAlias = NonSpare_677.cv_arg
    cv_non_spare: TypeAlias = NonSpare_677

    @classmethod
    def create(cls, arg : "Item_117.cv_arg") -> "Item_117":
        return cls._create(arg) # type: ignore

class Variation_1142(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_384.cv_arg, Tuple[Literal["MBDATA"], RuleVariation_384.cv_arg]], Union[RuleVariation_132.cv_arg, Tuple[Literal["BDS1"], RuleVariation_132.cv_arg]], Union[RuleVariation_769.cv_arg, Tuple[Literal["BDS2"], RuleVariation_769.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1142.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 64
    cv_items_list = [(Item_531, 56), (Item_115, 4), (Item_117, 4)]
    cv_items_dict = {"MBDATA": RuleVariation_384, "BDS1": RuleVariation_132, "BDS2": RuleVariation_769}

    @overload
    @classmethod
    def spec(cls, key : Literal["MBDATA"]) -> RuleVariation_384:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["BDS1"]) -> RuleVariation_132:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["BDS2"]) -> RuleVariation_769:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["MBDATA"], Literal["BDS1"], Literal["BDS2"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["MBDATA"]) -> RuleVariation_384:
        ...
    @overload
    def get_item(self, key : Literal["BDS1"]) -> RuleVariation_132:
        ...
    @overload
    def get_item(self, key : Literal["BDS2"]) -> RuleVariation_769:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1142.cv_arg") -> 'Variation_1142':
        return cls._create(arg) # type: ignore

class Variation_1421(Repetitive):
    cv_arg: TypeAlias = List[Variation_1142.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1142

    @classmethod
    def create(cls, arg: "Variation_1421.cv_arg") -> 'Variation_1421':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1142]:
        return self._get_list() # type: ignore

class RuleVariation_1342(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1421.cv_arg
    cv_variation: TypeAlias = Variation_1421

    @classmethod
    def create(cls, arg : "RuleVariation_1342.cv_arg") -> "RuleVariation_1342":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1421:
        return self.arg # type: ignore

class NonSpare_448(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1342.cv_arg
    cv_name = "250"
    cv_title = "Mode S MB Data"
    cv_rule: TypeAlias = RuleVariation_1342

    @classmethod
    def create(cls, arg : "NonSpare_448.cv_arg") -> "NonSpare_448":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1342:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1421:
        return self.rule.variation

class UapItem_448(UapItem):
    cv_non_spare: TypeAlias = NonSpare_448

class Content_537(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Unknown", 1: "ATC equipment maintenance", 2: "Airport maintenance", 3: "Fire", 4: "Bird scarer", 5: "Snow plough", 6: "Runway sweeper", 7: "Emergency", 8: "Police", 9: "Bus", 10: "Tug (push/tow)", 11: "Grass cutter", 12: "Fuel", 13: "Baggage", 14: "Catering", 15: "Aircraft maintenance", 16: "Flyco (follow me)"}

class RuleContent_537(RuleContentContextFree):
    cv_arg: TypeAlias = Content_537.cv_arg
    cv_content: TypeAlias = Content_537

    @property
    def content(self) -> Content_537:
        return self._get_content() # type: ignore

class Variation_177(Element):
    cv_arg: TypeAlias = RuleContent_537.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_537

    @classmethod
    def create(cls, arg: "Variation_177.cv_arg") -> "Variation_177":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_537:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_537:
        return self.rule.content

class RuleVariation_170(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_177.cv_arg
    cv_variation: TypeAlias = Variation_177

    @classmethod
    def create(cls, arg : "RuleVariation_170.cv_arg") -> "RuleVariation_170":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_177:
        return self.arg # type: ignore

class NonSpare_477(NonSpare):
    cv_arg: TypeAlias = RuleVariation_170.cv_arg
    cv_name = "300"
    cv_title = "Vehicle Fleet Identification"
    cv_rule: TypeAlias = RuleVariation_170

    @classmethod
    def create(cls, arg : "NonSpare_477.cv_arg") -> "NonSpare_477":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_170:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_177:
        return self.rule.variation

class UapItem_477(UapItem):
    cv_non_spare: TypeAlias = NonSpare_477

class NonSpare_974(NonSpare):
    cv_arg: TypeAlias = RuleVariation_598.cv_arg
    cv_name = "FL"
    cv_title = "Flight Level"
    cv_rule: TypeAlias = RuleVariation_598

    @classmethod
    def create(cls, arg : "NonSpare_974.cv_arg") -> "NonSpare_974":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_598:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_609:
        return self.rule.variation

class Item_331(Item):
    cv_arg: TypeAlias = NonSpare_974.cv_arg
    cv_non_spare: TypeAlias = NonSpare_974

    @classmethod
    def create(cls, arg : "Item_331.cv_arg") -> "Item_331":
        return cls._create(arg) # type: ignore

class Variation_1271(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_15.cv_arg, Tuple[Literal["V"], RuleVariation_15.cv_arg]], Union[RuleVariation_396.cv_arg, Tuple[Literal["G"], RuleVariation_396.cv_arg]], Union[RuleVariation_598.cv_arg, Tuple[Literal["FL"], RuleVariation_598.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1271.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_1103, 1), (Item_357, 1), (Item_331, 14)]
    cv_items_dict = {"V": RuleVariation_15, "G": RuleVariation_396, "FL": RuleVariation_598}

    @overload
    @classmethod
    def spec(cls, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> RuleVariation_396:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["FL"]) -> RuleVariation_598:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["V"], Literal["G"], Literal["FL"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> RuleVariation_396:
        ...
    @overload
    def get_item(self, key : Literal["FL"]) -> RuleVariation_598:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1271.cv_arg") -> 'Variation_1271':
        return cls._create(arg) # type: ignore

class RuleVariation_1200(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1271.cv_arg
    cv_variation: TypeAlias = Variation_1271

    @classmethod
    def create(cls, arg : "RuleVariation_1200.cv_arg") -> "RuleVariation_1200":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1271:
        return self.arg # type: ignore

class NonSpare_250(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1200.cv_arg
    cv_name = "090"
    cv_title = "Flight Level in Binary Representation"
    cv_rule: TypeAlias = RuleVariation_1200

    @classmethod
    def create(cls, arg : "NonSpare_250.cv_arg") -> "NonSpare_250":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1200:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1271:
        return self.rule.variation

class UapItem_250(UapItem):
    cv_non_spare: TypeAlias = NonSpare_250

class Content_685(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["ft"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 6.25
    cv_unit = "ft"

    def as_quantity(self, cv_unit : Optional[Literal["ft"]] = None) -> float:
        return self._as_quantity()

class RuleContent_685(RuleContentContextFree):
    cv_arg: TypeAlias = Content_685.cv_arg
    cv_content: TypeAlias = Content_685

    @property
    def content(self) -> Content_685:
        return self._get_content() # type: ignore

class Variation_290(Element):
    cv_arg: TypeAlias = RuleContent_685.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_685

    @classmethod
    def create(cls, arg: "Variation_290.cv_arg") -> "Variation_290":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_685:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_685:
        return self.rule.content

class RuleVariation_283(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_290.cv_arg
    cv_variation: TypeAlias = Variation_290

    @classmethod
    def create(cls, arg : "RuleVariation_283.cv_arg") -> "RuleVariation_283":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_290:
        return self.arg # type: ignore

class NonSpare_260(NonSpare):
    cv_arg: TypeAlias = RuleVariation_283.cv_arg
    cv_name = "091"
    cv_title = "Measured Height"
    cv_rule: TypeAlias = RuleVariation_283

    @classmethod
    def create(cls, arg : "NonSpare_260.cv_arg") -> "NonSpare_260":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_283:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_290:
        return self.rule.variation

class UapItem_260(UapItem):
    cv_non_spare: TypeAlias = NonSpare_260

class Content_719(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 1.0
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_719(RuleContentContextFree):
    cv_arg: TypeAlias = Content_719.cv_arg
    cv_content: TypeAlias = Content_719

    @property
    def content(self) -> Content_719:
        return self._get_content() # type: ignore

class Variation_161(Element):
    cv_arg: TypeAlias = RuleContent_719.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 7
    cv_rule = RuleContent_719

    @classmethod
    def create(cls, arg: "Variation_161.cv_arg") -> "Variation_161":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_719:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_719:
        return self.rule.content

class RuleVariation_155(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_161.cv_arg
    cv_variation: TypeAlias = Variation_161

    @classmethod
    def create(cls, arg : "RuleVariation_155.cv_arg") -> "RuleVariation_155":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_161:
        return self.arg # type: ignore

class Content_789(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 2.8125
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_788(RuleContentContextFree):
    cv_arg: TypeAlias = Content_789.cv_arg
    cv_content: TypeAlias = Content_789

    @property
    def content(self) -> Content_789:
        return self._get_content() # type: ignore

class Variation_164(Element):
    cv_arg: TypeAlias = RuleContent_788.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 7
    cv_rule = RuleContent_788

    @classmethod
    def create(cls, arg: "Variation_164.cv_arg") -> "Variation_164":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_788:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_789:
        return self.rule.content

class RuleVariation_158(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_164.cv_arg
    cv_variation: TypeAlias = Variation_164

    @classmethod
    def create(cls, arg : "RuleVariation_158.cv_arg") -> "RuleVariation_158":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_164:
        return self.arg # type: ignore

class NonSpare_1168(NonSpare):
    cv_arg: TypeAlias = RuleVariation_155.cv_arg
    cv_name = "LENGTH"
    cv_title = "Length"
    cv_rule: TypeAlias = RuleVariation_155

    @classmethod
    def create(cls, arg : "NonSpare_1168.cv_arg") -> "NonSpare_1168":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_155:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_161:
        return self.rule.variation

class Item_478(Item):
    cv_arg: TypeAlias = NonSpare_1168.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1168

    @classmethod
    def create(cls, arg : "Item_478.cv_arg") -> "Item_478":
        return cls._create(arg) # type: ignore

class NonSpare_1403(NonSpare):
    cv_arg: TypeAlias = RuleVariation_158.cv_arg
    cv_name = "ORIENTATION"
    cv_title = "Orientation"
    cv_rule: TypeAlias = RuleVariation_158

    @classmethod
    def create(cls, arg : "NonSpare_1403.cv_arg") -> "NonSpare_1403":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_158:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_164:
        return self.rule.variation

class Item_662(Item):
    cv_arg: TypeAlias = NonSpare_1403.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1403

    @classmethod
    def create(cls, arg : "Item_662.cv_arg") -> "Item_662":
        return cls._create(arg) # type: ignore

class NonSpare_2062(NonSpare):
    cv_arg: TypeAlias = RuleVariation_155.cv_arg
    cv_name = "WIDTH"
    cv_title = "Width"
    cv_rule: TypeAlias = RuleVariation_155

    @classmethod
    def create(cls, arg : "NonSpare_2062.cv_arg") -> "NonSpare_2062":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_155:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_161:
        return self.rule.variation

class Item_1166(Item):
    cv_arg: TypeAlias = NonSpare_2062.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2062

    @classmethod
    def create(cls, arg : "Item_1166.cv_arg") -> "Item_1166":
        return cls._create(arg) # type: ignore

class Variation_1363(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_155.cv_arg, Tuple[Literal["LENGTH"], RuleVariation_155.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_158.cv_arg, Tuple[Literal["ORIENTATION"], RuleVariation_158.cv_arg]], None]]
    cv_arg_group_3: TypeAlias = Union[int, Tuple[Union[RuleVariation_155.cv_arg, Tuple[Literal["WIDTH"], RuleVariation_155.cv_arg]], None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1363.cv_arg_group_1"],
        Tuple["Variation_1363.cv_arg_group_1", "Variation_1363.cv_arg_group_2"],
        Tuple["Variation_1363.cv_arg_group_1", "Variation_1363.cv_arg_group_2", "Variation_1363.cv_arg_group_3"],
    ]
    cv_items_list = [[(Item_478, 7), None], [(Item_662, 7), None], [(Item_1166, 7), None]]

    @classmethod
    def create(cls, arg: "Variation_1363.cv_arg") -> 'Variation_1363':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["LENGTH"]) -> RuleVariation_155:
        ...
    @overload
    def get_item(self, key : Literal["ORIENTATION"]) -> Optional[RuleVariation_158]:
        ...
    @overload
    def get_item(self, key : Literal["WIDTH"]) -> Optional[RuleVariation_155]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1284(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1363.cv_arg
    cv_variation: TypeAlias = Variation_1363

    @classmethod
    def create(cls, arg : "RuleVariation_1284.cv_arg") -> "RuleVariation_1284":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1363:
        return self.arg # type: ignore

class NonSpare_461(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1284.cv_arg
    cv_name = "270"
    cv_title = "Target Size and Orientation"
    cv_rule: TypeAlias = RuleVariation_1284

    @classmethod
    def create(cls, arg : "NonSpare_461.cv_arg") -> "NonSpare_461":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1284:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1363:
        return self.rule.variation

class UapItem_461(UapItem):
    cv_non_spare: TypeAlias = NonSpare_461

class Content_411(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Operational", 1: "Degraded", 2: "NOGO"}

class RuleContent_411(RuleContentContextFree):
    cv_arg: TypeAlias = Content_411.cv_arg
    cv_content: TypeAlias = Content_411

    @property
    def content(self) -> Content_411:
        return self._get_content() # type: ignore

class Variation_108(Element):
    cv_arg: TypeAlias = RuleContent_411.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 2
    cv_rule = RuleContent_411

    @classmethod
    def create(cls, arg: "Variation_108.cv_arg") -> "Variation_108":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_411:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_411:
        return self.rule.content

class RuleVariation_108(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_108.cv_arg
    cv_variation: TypeAlias = Variation_108

    @classmethod
    def create(cls, arg : "RuleVariation_108.cv_arg") -> "RuleVariation_108":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_108:
        return self.arg # type: ignore

class NonSpare_1369(NonSpare):
    cv_arg: TypeAlias = RuleVariation_108.cv_arg
    cv_name = "NOGO"
    cv_title = "Operational Release Status of the System"
    cv_rule: TypeAlias = RuleVariation_108

    @classmethod
    def create(cls, arg : "NonSpare_1369.cv_arg") -> "NonSpare_1369":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_108:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_108:
        return self.rule.variation

class Item_629(Item):
    cv_arg: TypeAlias = NonSpare_1369.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1369

    @classmethod
    def create(cls, arg : "Item_629.cv_arg") -> "Item_629":
        return cls._create(arg) # type: ignore

class Content_369(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No overload", 1: "Overload"}

class RuleContent_369(RuleContentContextFree):
    cv_arg: TypeAlias = Content_369.cv_arg
    cv_content: TypeAlias = Content_369

    @property
    def content(self) -> Content_369:
        return self._get_content() # type: ignore

class Variation_564(Element):
    cv_arg: TypeAlias = RuleContent_369.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_369

    @classmethod
    def create(cls, arg: "Variation_564.cv_arg") -> "Variation_564":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_369:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_369:
        return self.rule.content

class RuleVariation_553(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_564.cv_arg
    cv_variation: TypeAlias = Variation_564

    @classmethod
    def create(cls, arg : "RuleVariation_553.cv_arg") -> "RuleVariation_553":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_564:
        return self.arg # type: ignore

class NonSpare_1410(NonSpare):
    cv_arg: TypeAlias = RuleVariation_553.cv_arg
    cv_name = "OVL"
    cv_title = "Overload Indicator"
    cv_rule: TypeAlias = RuleVariation_553

    @classmethod
    def create(cls, arg : "NonSpare_1410.cv_arg") -> "NonSpare_1410":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_553:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_564:
        return self.rule.variation

class Item_668(Item):
    cv_arg: TypeAlias = NonSpare_1410.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1410

    @classmethod
    def create(cls, arg : "Item_668.cv_arg") -> "Item_668":
        return cls._create(arg) # type: ignore

class Content_559(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Valid", 1: "Invalid"}

class RuleContent_559(RuleContentContextFree):
    cv_arg: TypeAlias = Content_559.cv_arg
    cv_content: TypeAlias = Content_559

    @property
    def content(self) -> Content_559:
        return self._get_content() # type: ignore

class Variation_673(Element):
    cv_arg: TypeAlias = RuleContent_559.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_559

    @classmethod
    def create(cls, arg: "Variation_673.cv_arg") -> "Variation_673":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_559:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_559:
        return self.rule.content

class RuleVariation_662(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_673.cv_arg
    cv_variation: TypeAlias = Variation_673

    @classmethod
    def create(cls, arg : "RuleVariation_662.cv_arg") -> "RuleVariation_662":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_673:
        return self.arg # type: ignore

class NonSpare_1941(NonSpare):
    cv_arg: TypeAlias = RuleVariation_662.cv_arg
    cv_name = "TSV"
    cv_title = "Time Source Validity"
    cv_rule: TypeAlias = RuleVariation_662

    @classmethod
    def create(cls, arg : "NonSpare_1941.cv_arg") -> "NonSpare_1941":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_662:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_673:
        return self.rule.variation

class Item_1058(Item):
    cv_arg: TypeAlias = NonSpare_1941.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1941

    @classmethod
    def create(cls, arg : "Item_1058.cv_arg") -> "Item_1058":
        return cls._create(arg) # type: ignore

class Content_382(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Normal Operation", 1: "Diversity degraded"}

class RuleContent_382(RuleContentContextFree):
    cv_arg: TypeAlias = Content_382.cv_arg
    cv_content: TypeAlias = Content_382

    @property
    def content(self) -> Content_382:
        return self._get_content() # type: ignore

class Variation_742(Element):
    cv_arg: TypeAlias = RuleContent_382.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_382

    @classmethod
    def create(cls, arg: "Variation_742.cv_arg") -> "Variation_742":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_382:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_382:
        return self.rule.content

class RuleVariation_731(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_742.cv_arg
    cv_variation: TypeAlias = Variation_742

    @classmethod
    def create(cls, arg : "RuleVariation_731.cv_arg") -> "RuleVariation_731":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_742:
        return self.arg # type: ignore

class NonSpare_885(NonSpare):
    cv_arg: TypeAlias = RuleVariation_731.cv_arg
    cv_name = "DIV"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_731

    @classmethod
    def create(cls, arg : "NonSpare_885.cv_arg") -> "NonSpare_885":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_731:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_742:
        return self.rule.variation

class Item_262(Item):
    cv_arg: TypeAlias = NonSpare_885.cv_arg
    cv_non_spare: TypeAlias = NonSpare_885

    @classmethod
    def create(cls, arg : "Item_262.cv_arg") -> "Item_262":
        return cls._create(arg) # type: ignore

class Content_487(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Test Target Operative", 1: "Test Target Failure"}

class RuleContent_487(RuleContentContextFree):
    cv_arg: TypeAlias = Content_487.cv_arg
    cv_content: TypeAlias = Content_487

    @property
    def content(self) -> Content_487:
        return self._get_content() # type: ignore

class Variation_872(Element):
    cv_arg: TypeAlias = RuleContent_487.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_487

    @classmethod
    def create(cls, arg: "Variation_872.cv_arg") -> "Variation_872":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_487:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_487:
        return self.rule.content

class RuleVariation_842(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_872.cv_arg
    cv_variation: TypeAlias = Variation_872

    @classmethod
    def create(cls, arg : "RuleVariation_842.cv_arg") -> "RuleVariation_842":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_872:
        return self.arg # type: ignore

class NonSpare_1948(NonSpare):
    cv_arg: TypeAlias = RuleVariation_842.cv_arg
    cv_name = "TTF"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_842

    @classmethod
    def create(cls, arg : "NonSpare_1948.cv_arg") -> "NonSpare_1948":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_842:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_872:
        return self.rule.variation

class Item_1063(Item):
    cv_arg: TypeAlias = NonSpare_1948.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1948

    @classmethod
    def create(cls, arg : "Item_1063.cv_arg") -> "Item_1063":
        return cls._create(arg) # type: ignore

class Variation_1153(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_108.cv_arg, Tuple[Literal["NOGO"], RuleVariation_108.cv_arg]], Union[RuleVariation_553.cv_arg, Tuple[Literal["OVL"], RuleVariation_553.cv_arg]], Union[RuleVariation_662.cv_arg, Tuple[Literal["TSV"], RuleVariation_662.cv_arg]], Union[RuleVariation_731.cv_arg, Tuple[Literal["DIV"], RuleVariation_731.cv_arg]], Union[RuleVariation_842.cv_arg, Tuple[Literal["TTF"], RuleVariation_842.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1153.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_629, 2), (Item_668, 1), (Item_1058, 1), (Item_262, 1), (Item_1063, 1), (Item_27, 2)]
    cv_items_dict = {"NOGO": RuleVariation_108, "OVL": RuleVariation_553, "TSV": RuleVariation_662, "DIV": RuleVariation_731, "TTF": RuleVariation_842}

    @overload
    @classmethod
    def spec(cls, key : Literal["NOGO"]) -> RuleVariation_108:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["OVL"]) -> RuleVariation_553:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TSV"]) -> RuleVariation_662:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["DIV"]) -> RuleVariation_731:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TTF"]) -> RuleVariation_842:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["NOGO"], Literal["OVL"], Literal["TSV"], Literal["DIV"], Literal["TTF"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["NOGO"]) -> RuleVariation_108:
        ...
    @overload
    def get_item(self, key : Literal["OVL"]) -> RuleVariation_553:
        ...
    @overload
    def get_item(self, key : Literal["TSV"]) -> RuleVariation_662:
        ...
    @overload
    def get_item(self, key : Literal["DIV"]) -> RuleVariation_731:
        ...
    @overload
    def get_item(self, key : Literal["TTF"]) -> RuleVariation_842:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1153.cv_arg") -> 'Variation_1153':
        return cls._create(arg) # type: ignore

class RuleVariation_1106(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1153.cv_arg
    cv_variation: TypeAlias = Variation_1153

    @classmethod
    def create(cls, arg : "RuleVariation_1106.cv_arg") -> "RuleVariation_1106":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1153:
        return self.arg # type: ignore

class NonSpare_523(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1106.cv_arg
    cv_name = "550"
    cv_title = "System Status"
    cv_rule: TypeAlias = RuleVariation_1106

    @classmethod
    def create(cls, arg : "NonSpare_523.cv_arg") -> "NonSpare_523":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1106:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1153:
        return self.rule.variation

class UapItem_522(UapItem):
    cv_non_spare: TypeAlias = NonSpare_523

class Content_109(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "In Trouble"}

class RuleContent_109(RuleContentContextFree):
    cv_arg: TypeAlias = Content_109.cv_arg
    cv_content: TypeAlias = Content_109

    @property
    def content(self) -> Content_109:
        return self._get_content() # type: ignore

class Variation_30(Element):
    cv_arg: TypeAlias = RuleContent_109.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_109

    @classmethod
    def create(cls, arg: "Variation_30.cv_arg") -> "Variation_30":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_109:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_109:
        return self.rule.content

class RuleVariation_30(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_30.cv_arg
    cv_variation: TypeAlias = Variation_30

    @classmethod
    def create(cls, arg : "RuleVariation_30.cv_arg") -> "RuleVariation_30":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_30:
        return self.arg # type: ignore

class NonSpare_1908(NonSpare):
    cv_arg: TypeAlias = RuleVariation_30.cv_arg
    cv_name = "TRB"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_30

    @classmethod
    def create(cls, arg : "NonSpare_1908.cv_arg") -> "NonSpare_1908":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_30:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_30:
        return self.rule.variation

class Item_1031(Item):
    cv_arg: TypeAlias = NonSpare_1908.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1908

    @classmethod
    def create(cls, arg : "Item_1031.cv_arg") -> "Item_1031":
        return cls._create(arg) # type: ignore

class Content_602(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Towing aircraft", 2: "“Follow me” operation", 3: "Runway check", 4: "Emergency operation (fire, medical...)", 5: "Work in progress (maintenance, birds scarer, sweepers...)"}

class RuleContent_602(RuleContentContextFree):
    cv_arg: TypeAlias = Content_602.cv_arg
    cv_content: TypeAlias = Content_602

    @property
    def content(self) -> Content_602:
        return self._get_content() # type: ignore

class Variation_496(Element):
    cv_arg: TypeAlias = RuleContent_602.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 7
    cv_rule = RuleContent_602

    @classmethod
    def create(cls, arg: "Variation_496.cv_arg") -> "Variation_496":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_602:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_602:
        return self.rule.content

class RuleVariation_485(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_496.cv_arg
    cv_variation: TypeAlias = Variation_496

    @classmethod
    def create(cls, arg : "RuleVariation_485.cv_arg") -> "RuleVariation_485":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_496:
        return self.arg # type: ignore

class NonSpare_1330(NonSpare):
    cv_arg: TypeAlias = RuleVariation_485.cv_arg
    cv_name = "MSG"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_485

    @classmethod
    def create(cls, arg : "NonSpare_1330.cv_arg") -> "NonSpare_1330":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_485:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_496:
        return self.rule.variation

class Item_594(Item):
    cv_arg: TypeAlias = NonSpare_1330.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1330

    @classmethod
    def create(cls, arg : "Item_594.cv_arg") -> "Item_594":
        return cls._create(arg) # type: ignore

class Variation_1231(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_30.cv_arg, Tuple[Literal["TRB"], RuleVariation_30.cv_arg]], Union[RuleVariation_485.cv_arg, Tuple[Literal["MSG"], RuleVariation_485.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1231.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_1031, 1), (Item_594, 7)]
    cv_items_dict = {"TRB": RuleVariation_30, "MSG": RuleVariation_485}

    @overload
    @classmethod
    def spec(cls, key : Literal["TRB"]) -> RuleVariation_30:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MSG"]) -> RuleVariation_485:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["TRB"], Literal["MSG"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["TRB"]) -> RuleVariation_30:
        ...
    @overload
    def get_item(self, key : Literal["MSG"]) -> RuleVariation_485:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1231.cv_arg") -> 'Variation_1231':
        return cls._create(arg) # type: ignore

class RuleVariation_1169(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1231.cv_arg
    cv_variation: TypeAlias = Variation_1231

    @classmethod
    def create(cls, arg : "RuleVariation_1169.cv_arg") -> "RuleVariation_1169":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1231:
        return self.arg # type: ignore

class NonSpare_479(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1169.cv_arg
    cv_name = "310"
    cv_title = "Pre-programmed Message"
    cv_rule: TypeAlias = RuleVariation_1169

    @classmethod
    def create(cls, arg : "NonSpare_479.cv_arg") -> "NonSpare_479":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1169:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1231:
        return self.rule.variation

class UapItem_479(UapItem):
    cv_non_spare: TypeAlias = NonSpare_479

class Content_755(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 0.25
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_754(RuleContentContextFree):
    cv_arg: TypeAlias = Content_755.cv_arg
    cv_content: TypeAlias = Content_755

    @property
    def content(self) -> Content_755:
        return self._get_content() # type: ignore

class Variation_232(Element):
    cv_arg: TypeAlias = RuleContent_754.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_754

    @classmethod
    def create(cls, arg: "Variation_232.cv_arg") -> "Variation_232":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_754:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_755:
        return self.rule.content

class RuleVariation_225(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_232.cv_arg
    cv_variation: TypeAlias = Variation_232

    @classmethod
    def create(cls, arg : "RuleVariation_225.cv_arg") -> "RuleVariation_225":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_232:
        return self.arg # type: ignore

class NonSpare_880(NonSpare):
    cv_arg: TypeAlias = RuleVariation_225.cv_arg
    cv_name = "DEVX"
    cv_title = "Standard Deviation of X Component"
    cv_rule: TypeAlias = RuleVariation_225

    @classmethod
    def create(cls, arg : "NonSpare_880.cv_arg") -> "NonSpare_880":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_225:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_232:
        return self.rule.variation

class Item_257(Item):
    cv_arg: TypeAlias = NonSpare_880.cv_arg
    cv_non_spare: TypeAlias = NonSpare_880

    @classmethod
    def create(cls, arg : "Item_257.cv_arg") -> "Item_257":
        return cls._create(arg) # type: ignore

class NonSpare_881(NonSpare):
    cv_arg: TypeAlias = RuleVariation_225.cv_arg
    cv_name = "DEVY"
    cv_title = "Standard Deviation of Y Component"
    cv_rule: TypeAlias = RuleVariation_225

    @classmethod
    def create(cls, arg : "NonSpare_881.cv_arg") -> "NonSpare_881":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_225:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_232:
        return self.rule.variation

class Item_258(Item):
    cv_arg: TypeAlias = NonSpare_881.cv_arg
    cv_non_spare: TypeAlias = NonSpare_881

    @classmethod
    def create(cls, arg : "Item_258.cv_arg") -> "Item_258":
        return cls._create(arg) # type: ignore

class Content_658(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.25
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_658(RuleContentContextFree):
    cv_arg: TypeAlias = Content_658.cv_arg
    cv_content: TypeAlias = Content_658

    @property
    def content(self) -> Content_658:
        return self._get_content() # type: ignore

class Variation_275(Element):
    cv_arg: TypeAlias = RuleContent_658.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_658

    @classmethod
    def create(cls, arg: "Variation_275.cv_arg") -> "Variation_275":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_658:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_658:
        return self.rule.content

class RuleVariation_268(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_275.cv_arg
    cv_variation: TypeAlias = Variation_275

    @classmethod
    def create(cls, arg : "RuleVariation_268.cv_arg") -> "RuleVariation_268":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_275:
        return self.arg # type: ignore

class NonSpare_813(NonSpare):
    cv_arg: TypeAlias = RuleVariation_268.cv_arg
    cv_name = "COVXY"
    cv_title = "Covariance in Two’s Complement Form"
    cv_rule: TypeAlias = RuleVariation_268

    @classmethod
    def create(cls, arg : "NonSpare_813.cv_arg") -> "NonSpare_813":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_268:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_275:
        return self.rule.variation

class Item_205(Item):
    cv_arg: TypeAlias = NonSpare_813.cv_arg
    cv_non_spare: TypeAlias = NonSpare_813

    @classmethod
    def create(cls, arg : "Item_205.cv_arg") -> "Item_205":
        return cls._create(arg) # type: ignore

class Variation_1084(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_225.cv_arg, Tuple[Literal["DEVX"], RuleVariation_225.cv_arg]], Union[RuleVariation_225.cv_arg, Tuple[Literal["DEVY"], RuleVariation_225.cv_arg]], Union[RuleVariation_268.cv_arg, Tuple[Literal["COVXY"], RuleVariation_268.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1084.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_257, 8), (Item_258, 8), (Item_205, 16)]
    cv_items_dict = {"DEVX": RuleVariation_225, "DEVY": RuleVariation_225, "COVXY": RuleVariation_268}

    @overload
    @classmethod
    def spec(cls, key : Literal["DEVX"]) -> RuleVariation_225:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["DEVY"]) -> RuleVariation_225:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["COVXY"]) -> RuleVariation_268:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["DEVX"], Literal["DEVY"], Literal["COVXY"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["DEVX"]) -> RuleVariation_225:
        ...
    @overload
    def get_item(self, key : Literal["DEVY"]) -> RuleVariation_225:
        ...
    @overload
    def get_item(self, key : Literal["COVXY"]) -> RuleVariation_268:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1084.cv_arg") -> 'Variation_1084':
        return cls._create(arg) # type: ignore

class RuleVariation_1044(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1084.cv_arg
    cv_variation: TypeAlias = Variation_1084

    @classmethod
    def create(cls, arg : "RuleVariation_1044.cv_arg") -> "RuleVariation_1044":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1084:
        return self.arg # type: ignore

class NonSpare_518(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1044.cv_arg
    cv_name = "500"
    cv_title = "Standard Deviation of Position"
    cv_rule: TypeAlias = RuleVariation_1044

    @classmethod
    def create(cls, arg : "NonSpare_518.cv_arg") -> "NonSpare_518":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1044:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1084:
        return self.rule.variation

class UapItem_517(UapItem):
    cv_non_spare: TypeAlias = NonSpare_518

class Content_628(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 1.0
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_628(RuleContentContextFree):
    cv_arg: TypeAlias = Content_628.cv_arg
    cv_content: TypeAlias = Content_628

    @property
    def content(self) -> Content_628:
        return self._get_content() # type: ignore

class Variation_210(Element):
    cv_arg: TypeAlias = RuleContent_628.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_628

    @classmethod
    def create(cls, arg: "Variation_210.cv_arg") -> "Variation_210":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_628:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_628:
        return self.rule.content

class RuleVariation_203(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_210.cv_arg
    cv_variation: TypeAlias = Variation_210

    @classmethod
    def create(cls, arg : "RuleVariation_203.cv_arg") -> "RuleVariation_203":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_210:
        return self.arg # type: ignore

class NonSpare_898(NonSpare):
    cv_arg: TypeAlias = RuleVariation_203.cv_arg
    cv_name = "DRHO"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_203

    @classmethod
    def create(cls, arg : "NonSpare_898.cv_arg") -> "NonSpare_898":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_203:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_210:
        return self.rule.variation

class Item_271(Item):
    cv_arg: TypeAlias = NonSpare_898.cv_arg
    cv_non_spare: TypeAlias = NonSpare_898

    @classmethod
    def create(cls, arg : "Item_271.cv_arg") -> "Item_271":
        return cls._create(arg) # type: ignore

class Content_684(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.15
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_684(RuleContentContextFree):
    cv_arg: TypeAlias = Content_684.cv_arg
    cv_content: TypeAlias = Content_684

    @property
    def content(self) -> Content_684:
        return self._get_content() # type: ignore

class Variation_219(Element):
    cv_arg: TypeAlias = RuleContent_684.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_684

    @classmethod
    def create(cls, arg: "Variation_219.cv_arg") -> "Variation_219":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_684:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_684:
        return self.rule.content

class RuleVariation_212(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_219.cv_arg
    cv_variation: TypeAlias = Variation_219

    @classmethod
    def create(cls, arg : "RuleVariation_212.cv_arg") -> "RuleVariation_212":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_219:
        return self.arg # type: ignore

class NonSpare_909(NonSpare):
    cv_arg: TypeAlias = RuleVariation_212.cv_arg
    cv_name = "DTHETA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_212

    @classmethod
    def create(cls, arg : "NonSpare_909.cv_arg") -> "NonSpare_909":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_212:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_219:
        return self.rule.variation

class Item_279(Item):
    cv_arg: TypeAlias = NonSpare_909.cv_arg
    cv_non_spare: TypeAlias = NonSpare_909

    @classmethod
    def create(cls, arg : "Item_279.cv_arg") -> "Item_279":
        return cls._create(arg) # type: ignore

class Variation_1086(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_203.cv_arg, Tuple[Literal["DRHO"], RuleVariation_203.cv_arg]], Union[RuleVariation_212.cv_arg, Tuple[Literal["DTHETA"], RuleVariation_212.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1086.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_271, 8), (Item_279, 8)]
    cv_items_dict = {"DRHO": RuleVariation_203, "DTHETA": RuleVariation_212}

    @overload
    @classmethod
    def spec(cls, key : Literal["DRHO"]) -> RuleVariation_203:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["DTHETA"]) -> RuleVariation_212:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["DRHO"], Literal["DTHETA"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["DRHO"]) -> RuleVariation_203:
        ...
    @overload
    def get_item(self, key : Literal["DTHETA"]) -> RuleVariation_212:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1086.cv_arg") -> 'Variation_1086':
        return cls._create(arg) # type: ignore

class Variation_1418(Repetitive):
    cv_arg: TypeAlias = List[Variation_1086.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1086

    @classmethod
    def create(cls, arg: "Variation_1418.cv_arg") -> 'Variation_1418':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1086]:
        return self._get_list() # type: ignore

class RuleVariation_1339(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1418.cv_arg
    cv_variation: TypeAlias = Variation_1418

    @classmethod
    def create(cls, arg : "RuleVariation_1339.cv_arg") -> "RuleVariation_1339":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1418:
        return self.arg # type: ignore

class NonSpare_467(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1339.cv_arg
    cv_name = "280"
    cv_title = "Presence"
    cv_rule: TypeAlias = RuleVariation_1339

    @classmethod
    def create(cls, arg : "NonSpare_467.cv_arg") -> "NonSpare_467":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1339:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1418:
        return self.rule.variation

class UapItem_467(UapItem):
    cv_non_spare: TypeAlias = NonSpare_467

class NonSpare_314(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "131"
    cv_title = "Amplitude of Primary Plot"
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_314.cv_arg") -> "NonSpare_314":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class UapItem_314(UapItem):
    cv_non_spare: TypeAlias = NonSpare_314

class Content_671(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m/s²"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 6.25e-2
    cv_unit = "m/s²"

    def as_quantity(self, cv_unit : Optional[Literal["m/s²"]] = None) -> float:
        return self._as_quantity()

class RuleContent_671(RuleContentContextFree):
    cv_arg: TypeAlias = Content_671.cv_arg
    cv_content: TypeAlias = Content_671

    @property
    def content(self) -> Content_671:
        return self._get_content() # type: ignore

class Variation_213(Element):
    cv_arg: TypeAlias = RuleContent_671.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_671

    @classmethod
    def create(cls, arg: "Variation_213.cv_arg") -> "Variation_213":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_671:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_671:
        return self.rule.content

class RuleVariation_206(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_213.cv_arg
    cv_variation: TypeAlias = Variation_213

    @classmethod
    def create(cls, arg : "RuleVariation_206.cv_arg") -> "RuleVariation_206":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_213:
        return self.arg # type: ignore

class NonSpare_658(NonSpare):
    cv_arg: TypeAlias = RuleVariation_206.cv_arg
    cv_name = "AX"
    cv_title = "X Acceleration"
    cv_rule: TypeAlias = RuleVariation_206

    @classmethod
    def create(cls, arg : "NonSpare_658.cv_arg") -> "NonSpare_658":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_206:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_213:
        return self.rule.variation

class Item_101(Item):
    cv_arg: TypeAlias = NonSpare_658.cv_arg
    cv_non_spare: TypeAlias = NonSpare_658

    @classmethod
    def create(cls, arg : "Item_101.cv_arg") -> "Item_101":
        return cls._create(arg) # type: ignore

class NonSpare_662(NonSpare):
    cv_arg: TypeAlias = RuleVariation_206.cv_arg
    cv_name = "AY"
    cv_title = "Y Acceleration"
    cv_rule: TypeAlias = RuleVariation_206

    @classmethod
    def create(cls, arg : "NonSpare_662.cv_arg") -> "NonSpare_662":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_206:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_213:
        return self.rule.variation

class Item_105(Item):
    cv_arg: TypeAlias = NonSpare_662.cv_arg
    cv_non_spare: TypeAlias = NonSpare_662

    @classmethod
    def create(cls, arg : "Item_105.cv_arg") -> "Item_105":
        return cls._create(arg) # type: ignore

class Variation_1058(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_206.cv_arg, Tuple[Literal["AX"], RuleVariation_206.cv_arg]], Union[RuleVariation_206.cv_arg, Tuple[Literal["AY"], RuleVariation_206.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1058.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_101, 8), (Item_105, 8)]
    cv_items_dict = {"AX": RuleVariation_206, "AY": RuleVariation_206}

    @overload
    @classmethod
    def spec(cls, key : Literal["AX"]) -> RuleVariation_206:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AY"]) -> RuleVariation_206:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["AX"], Literal["AY"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["AX"]) -> RuleVariation_206:
        ...
    @overload
    def get_item(self, key : Literal["AY"]) -> RuleVariation_206:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1058.cv_arg") -> 'Variation_1058':
        return cls._create(arg) # type: ignore

class RuleVariation_1025(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1058.cv_arg
    cv_variation: TypeAlias = Variation_1058

    @classmethod
    def create(cls, arg : "RuleVariation_1025.cv_arg") -> "RuleVariation_1025":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1058:
        return self.arg # type: ignore

class NonSpare_409(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1025.cv_arg
    cv_name = "210"
    cv_title = "Calculated Acceleration"
    cv_rule: TypeAlias = RuleVariation_1025

    @classmethod
    def create(cls, arg : "NonSpare_409.cv_arg") -> "NonSpare_409":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1025:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1058:
        return self.rule.variation

class UapItem_409(UapItem):
    cv_non_spare: TypeAlias = NonSpare_409

class Record_38(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_43.cv_arg,
        "000": NonSpare_13.cv_arg,
        "020": NonSpare_91.cv_arg,
        "140": NonSpare_331.cv_arg,
        "041": NonSpare_155.cv_arg,
        "040": NonSpare_140.cv_arg,
        "042": NonSpare_161.cv_arg,
        "200": NonSpare_391.cv_arg,
        "202": NonSpare_404.cv_arg,
        "161": NonSpare_362.cv_arg,
        "170": NonSpare_374.cv_arg,
        "060": NonSpare_192.cv_arg,
        "220": NonSpare_426.cv_arg,
        "245": NonSpare_441.cv_arg,
        "250": NonSpare_448.cv_arg,
        "300": NonSpare_477.cv_arg,
        "090": NonSpare_250.cv_arg,
        "091": NonSpare_260.cv_arg,
        "270": NonSpare_461.cv_arg,
        "550": NonSpare_523.cv_arg,
        "310": NonSpare_479.cv_arg,
        "500": NonSpare_518.cv_arg,
        "280": NonSpare_467.cv_arg,
        "131": NonSpare_314.cv_arg,
        "210": NonSpare_409.cv_arg,
        "SP": NonSpare_1732.cv_arg,
        "RE": NonSpare_1568.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 4
    cv_items_list = [UapItem_43, UapItem_13, UapItem_91, UapItem_331, UapItem_155, UapItem_140, UapItem_161, UapItem_391, UapItem_404, UapItem_362, UapItem_374, UapItem_192, UapItem_426, UapItem_441, UapItem_448, UapItem_477, UapItem_250, UapItem_260, UapItem_461, UapItem_522, UapItem_479, UapItem_517, UapItem_467, UapItem_314, UapItem_409, UapItem_549, UapItem_548, UapItem_547]
    cv_items_dict = {"010": NonSpare_43, "000": NonSpare_13, "020": NonSpare_91, "140": NonSpare_331, "041": NonSpare_155, "040": NonSpare_140, "042": NonSpare_161, "200": NonSpare_391, "202": NonSpare_404, "161": NonSpare_362, "170": NonSpare_374, "060": NonSpare_192, "220": NonSpare_426, "245": NonSpare_441, "250": NonSpare_448, "300": NonSpare_477, "090": NonSpare_250, "091": NonSpare_260, "270": NonSpare_461, "550": NonSpare_523, "310": NonSpare_479, "500": NonSpare_518, "280": NonSpare_467, "131": NonSpare_314, "210": NonSpare_409, "SP": NonSpare_1732, "RE": NonSpare_1568}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> NonSpare_43:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> NonSpare_13:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> NonSpare_91:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["140"]) -> NonSpare_331:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["041"]) -> NonSpare_155:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> NonSpare_140:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["042"]) -> NonSpare_161:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["200"]) -> NonSpare_391:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["202"]) -> NonSpare_404:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["161"]) -> NonSpare_362:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["170"]) -> NonSpare_374:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> NonSpare_192:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["220"]) -> NonSpare_426:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["245"]) -> NonSpare_441:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["250"]) -> NonSpare_448:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["300"]) -> NonSpare_477:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> NonSpare_250:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["091"]) -> NonSpare_260:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["270"]) -> NonSpare_461:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["550"]) -> NonSpare_523:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["310"]) -> NonSpare_479:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["500"]) -> NonSpare_518:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["280"]) -> NonSpare_467:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["131"]) -> NonSpare_314:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["210"]) -> NonSpare_409:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> NonSpare_1732:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["RE"]) -> NonSpare_1568:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["020"], Literal["140"], Literal["041"], Literal["040"], Literal["042"], Literal["200"], Literal["202"], Literal["161"], Literal["170"], Literal["060"], Literal["220"], Literal["245"], Literal["250"], Literal["300"], Literal["090"], Literal["091"], Literal["270"], Literal["550"], Literal["310"], Literal["500"], Literal["280"], Literal["131"], Literal["210"], Literal["SP"], Literal["RE"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_43]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_13]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_91]:
        ...
    @overload
    def get_item(self, key : Literal["140"]) -> Optional[NonSpare_331]:
        ...
    @overload
    def get_item(self, key : Literal["041"]) -> Optional[NonSpare_155]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_140]:
        ...
    @overload
    def get_item(self, key : Literal["042"]) -> Optional[NonSpare_161]:
        ...
    @overload
    def get_item(self, key : Literal["200"]) -> Optional[NonSpare_391]:
        ...
    @overload
    def get_item(self, key : Literal["202"]) -> Optional[NonSpare_404]:
        ...
    @overload
    def get_item(self, key : Literal["161"]) -> Optional[NonSpare_362]:
        ...
    @overload
    def get_item(self, key : Literal["170"]) -> Optional[NonSpare_374]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_192]:
        ...
    @overload
    def get_item(self, key : Literal["220"]) -> Optional[NonSpare_426]:
        ...
    @overload
    def get_item(self, key : Literal["245"]) -> Optional[NonSpare_441]:
        ...
    @overload
    def get_item(self, key : Literal["250"]) -> Optional[NonSpare_448]:
        ...
    @overload
    def get_item(self, key : Literal["300"]) -> Optional[NonSpare_477]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_250]:
        ...
    @overload
    def get_item(self, key : Literal["091"]) -> Optional[NonSpare_260]:
        ...
    @overload
    def get_item(self, key : Literal["270"]) -> Optional[NonSpare_461]:
        ...
    @overload
    def get_item(self, key : Literal["550"]) -> Optional[NonSpare_523]:
        ...
    @overload
    def get_item(self, key : Literal["310"]) -> Optional[NonSpare_479]:
        ...
    @overload
    def get_item(self, key : Literal["500"]) -> Optional[NonSpare_518]:
        ...
    @overload
    def get_item(self, key : Literal["280"]) -> Optional[NonSpare_467]:
        ...
    @overload
    def get_item(self, key : Literal["131"]) -> Optional[NonSpare_314]:
        ...
    @overload
    def get_item(self, key : Literal["210"]) -> Optional[NonSpare_409]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1732]:
        ...
    @overload
    def get_item(self, key : Literal["RE"]) -> Optional[NonSpare_1568]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_43.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_13.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_91.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["140"], val : NonSpare_331.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["041"], val : NonSpare_155.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_140.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["042"], val : NonSpare_161.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["200"], val : NonSpare_391.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["202"], val : NonSpare_404.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["161"], val : NonSpare_362.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["170"], val : NonSpare_374.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_192.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["220"], val : NonSpare_426.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["245"], val : NonSpare_441.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["250"], val : NonSpare_448.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["300"], val : NonSpare_477.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_250.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["091"], val : NonSpare_260.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["270"], val : NonSpare_461.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["550"], val : NonSpare_523.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["310"], val : NonSpare_479.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["500"], val : NonSpare_518.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["280"], val : NonSpare_467.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["131"], val : NonSpare_314.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["210"], val : NonSpare_409.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1732.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["RE"], val : NonSpare_1568.cv_arg) -> 'Record_38':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["140"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["041"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["042"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["200"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["202"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["161"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["170"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["220"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["245"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["250"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["300"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["091"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["270"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["550"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["310"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["500"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["280"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["131"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["210"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["RE"]) -> 'Record_38':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Record_38.cv_arg") -> 'Record_38':
        return cls._create(arg) # type: ignore

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, Tuple["Record_38", Bits]]:
        return cls._parse(bs) # type: ignore

class Uap_34(UapSingle):
    cv_arg: TypeAlias = Record_38
    cv_record: TypeAlias = Record_38

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_38]]:
        return cls._parse(bs)

class Asterix_11(AstCat):
    cv_category = 10
    cv_edition = (1, 1)
    cv_uap: TypeAlias = Uap_34
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_34.cv_arg]) -> "Asterix_11":
        return cls._create(records) # type: ignore

class NonSpare_1656(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "SAC"
    cv_title = "System Area Code Fixed to Zero"
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_1656.cv_arg") -> "NonSpare_1656":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class Item_857(Item):
    cv_arg: TypeAlias = NonSpare_1656.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1656

    @classmethod
    def create(cls, arg : "Item_857.cv_arg") -> "Item_857":
        return cls._create(arg) # type: ignore

class Variation_1196(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_159.cv_arg, Tuple[Literal["SAC"], RuleVariation_159.cv_arg]], Union[RuleVariation_159.cv_arg, Tuple[Literal["SIC"], RuleVariation_159.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1196.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_857, 8), (Item_887, 8)]
    cv_items_dict = {"SAC": RuleVariation_159, "SIC": RuleVariation_159}

    @overload
    @classmethod
    def spec(cls, key : Literal["SAC"]) -> RuleVariation_159:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SIC"]) -> RuleVariation_159:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["SAC"], Literal["SIC"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["SAC"]) -> RuleVariation_159:
        ...
    @overload
    def get_item(self, key : Literal["SIC"]) -> RuleVariation_159:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1196.cv_arg") -> 'Variation_1196':
        return cls._create(arg) # type: ignore

class RuleVariation_1142(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1196.cv_arg
    cv_variation: TypeAlias = Variation_1196

    @classmethod
    def create(cls, arg : "RuleVariation_1142.cv_arg") -> "RuleVariation_1142":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1196:
        return self.arg # type: ignore

class NonSpare_48(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1142.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1142

    @classmethod
    def create(cls, arg : "NonSpare_48.cv_arg") -> "NonSpare_48":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1142:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1196:
        return self.rule.variation

class UapItem_48(UapItem):
    cv_non_spare: TypeAlias = NonSpare_48

class Content_600(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Target reports, flight plan data and basic alerts", 2: "Manual attachment of flight plan to track", 3: "Manual detachment of flight plan to track", 4: "Insertion of flight plan data", 5: "Suppression of flight plan data", 6: "Modification of flight plan data", 7: "Holdbar status"}

class RuleContent_600(RuleContentContextFree):
    cv_arg: TypeAlias = Content_600.cv_arg
    cv_content: TypeAlias = Content_600

    @property
    def content(self) -> Content_600:
        return self._get_content() # type: ignore

class Variation_199(Element):
    cv_arg: TypeAlias = RuleContent_600.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_600

    @classmethod
    def create(cls, arg: "Variation_199.cv_arg") -> "Variation_199":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_600:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_600:
        return self.rule.content

class RuleVariation_192(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_199.cv_arg
    cv_variation: TypeAlias = Variation_199

    @classmethod
    def create(cls, arg : "RuleVariation_192.cv_arg") -> "RuleVariation_192":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_199:
        return self.arg # type: ignore

class NonSpare_14(NonSpare):
    cv_arg: TypeAlias = RuleVariation_192.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_192

    @classmethod
    def create(cls, arg : "NonSpare_14.cv_arg") -> "NonSpare_14":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_192:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_199:
        return self.rule.variation

class UapItem_14(UapItem):
    cv_non_spare: TypeAlias = NonSpare_14

class NonSpare_62(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "015"
    cv_title = "Service Identification"
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_62.cv_arg") -> "NonSpare_62":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class UapItem_62(UapItem):
    cv_non_spare: TypeAlias = NonSpare_62

class NonSpare_336(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "140"
    cv_title = "Time of Track Information"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_336.cv_arg") -> "NonSpare_336":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class UapItem_336(UapItem):
    cv_non_spare: TypeAlias = NonSpare_336

class NonSpare_1158(NonSpare):
    cv_arg: TypeAlias = RuleVariation_376.cv_arg
    cv_name = "LAT"
    cv_title = "Latitude in WGS-84 in Two's Complement"
    cv_rule: TypeAlias = RuleVariation_376

    @classmethod
    def create(cls, arg : "NonSpare_1158.cv_arg") -> "NonSpare_1158":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_376:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_383:
        return self.rule.variation

class Item_470(Item):
    cv_arg: TypeAlias = NonSpare_1158.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1158

    @classmethod
    def create(cls, arg : "Item_470.cv_arg") -> "Item_470":
        return cls._create(arg) # type: ignore

class NonSpare_1188(NonSpare):
    cv_arg: TypeAlias = RuleVariation_374.cv_arg
    cv_name = "LON"
    cv_title = "Longitude in WGS-84 in Two's Complement"
    cv_rule: TypeAlias = RuleVariation_374

    @classmethod
    def create(cls, arg : "NonSpare_1188.cv_arg") -> "NonSpare_1188":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_374:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_381:
        return self.rule.variation

class Item_498(Item):
    cv_arg: TypeAlias = NonSpare_1188.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1188

    @classmethod
    def create(cls, arg : "Item_498.cv_arg") -> "Item_498":
        return cls._create(arg) # type: ignore

class Variation_1134(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_376.cv_arg, Tuple[Literal["LAT"], RuleVariation_376.cv_arg]], Union[RuleVariation_374.cv_arg, Tuple[Literal["LON"], RuleVariation_374.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1134.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 64
    cv_items_list = [(Item_470, 32), (Item_498, 32)]
    cv_items_dict = {"LAT": RuleVariation_376, "LON": RuleVariation_374}

    @overload
    @classmethod
    def spec(cls, key : Literal["LAT"]) -> RuleVariation_376:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["LON"]) -> RuleVariation_374:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["LAT"], Literal["LON"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["LAT"]) -> RuleVariation_376:
        ...
    @overload
    def get_item(self, key : Literal["LON"]) -> RuleVariation_374:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1134.cv_arg") -> 'Variation_1134':
        return cls._create(arg) # type: ignore

class RuleVariation_1090(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1134.cv_arg
    cv_variation: TypeAlias = Variation_1134

    @classmethod
    def create(cls, arg : "RuleVariation_1090.cv_arg") -> "RuleVariation_1090":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1134:
        return self.arg # type: ignore

class NonSpare_156(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1090.cv_arg
    cv_name = "041"
    cv_title = "Position in WGS-84 Coordinates"
    cv_rule: TypeAlias = RuleVariation_1090

    @classmethod
    def create(cls, arg : "NonSpare_156.cv_arg") -> "NonSpare_156":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1090:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1134:
        return self.rule.variation

class UapItem_156(UapItem):
    cv_non_spare: TypeAlias = NonSpare_156

class NonSpare_2098(NonSpare):
    cv_arg: TypeAlias = RuleVariation_252.cv_arg
    cv_name = "X"
    cv_title = "X-Component"
    cv_rule: TypeAlias = RuleVariation_252

    @classmethod
    def create(cls, arg : "NonSpare_2098.cv_arg") -> "NonSpare_2098":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_252:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_259:
        return self.rule.variation

class Item_1199(Item):
    cv_arg: TypeAlias = NonSpare_2098.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2098

    @classmethod
    def create(cls, arg : "Item_1199.cv_arg") -> "Item_1199":
        return cls._create(arg) # type: ignore

class NonSpare_2152(NonSpare):
    cv_arg: TypeAlias = RuleVariation_252.cv_arg
    cv_name = "Y"
    cv_title = "Y-Component"
    cv_rule: TypeAlias = RuleVariation_252

    @classmethod
    def create(cls, arg : "NonSpare_2152.cv_arg") -> "NonSpare_2152":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_252:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_259:
        return self.rule.variation

class Item_1250(Item):
    cv_arg: TypeAlias = NonSpare_2152.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2152

    @classmethod
    def create(cls, arg : "Item_1250.cv_arg") -> "Item_1250":
        return cls._create(arg) # type: ignore

class Variation_1312(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_252.cv_arg, Tuple[Literal["X"], RuleVariation_252.cv_arg]], Union[RuleVariation_252.cv_arg, Tuple[Literal["Y"], RuleVariation_252.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1312.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1199, 16), (Item_1250, 16)]
    cv_items_dict = {"X": RuleVariation_252, "Y": RuleVariation_252}

    @overload
    @classmethod
    def spec(cls, key : Literal["X"]) -> RuleVariation_252:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y"]) -> RuleVariation_252:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X"], Literal["Y"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X"]) -> RuleVariation_252:
        ...
    @overload
    def get_item(self, key : Literal["Y"]) -> RuleVariation_252:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1312.cv_arg") -> 'Variation_1312':
        return cls._create(arg) # type: ignore

class RuleVariation_1239(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1312.cv_arg
    cv_variation: TypeAlias = Variation_1312

    @classmethod
    def create(cls, arg : "RuleVariation_1239.cv_arg") -> "RuleVariation_1239":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1312:
        return self.arg # type: ignore

class NonSpare_158(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1239.cv_arg
    cv_name = "042"
    cv_title = "Calculated Position in Cartesian Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1239

    @classmethod
    def create(cls, arg : "NonSpare_158.cv_arg") -> "NonSpare_158":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1239:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1312:
        return self.rule.variation

class UapItem_158(UapItem):
    cv_non_spare: TypeAlias = NonSpare_158

class Content_662(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m/s"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.25
    cv_unit = "m/s"

    def as_quantity(self, cv_unit : Optional[Literal["m/s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_662(RuleContentContextFree):
    cv_arg: TypeAlias = Content_662.cv_arg
    cv_content: TypeAlias = Content_662

    @property
    def content(self) -> Content_662:
        return self._get_content() # type: ignore

class Variation_279(Element):
    cv_arg: TypeAlias = RuleContent_662.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_662

    @classmethod
    def create(cls, arg: "Variation_279.cv_arg") -> "Variation_279":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_662:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_662:
        return self.rule.content

class RuleVariation_272(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_279.cv_arg
    cv_variation: TypeAlias = Variation_279

    @classmethod
    def create(cls, arg : "RuleVariation_272.cv_arg") -> "RuleVariation_272":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_279:
        return self.arg # type: ignore

class NonSpare_2051(NonSpare):
    cv_arg: TypeAlias = RuleVariation_272.cv_arg
    cv_name = "VX"
    cv_title = "Vx"
    cv_rule: TypeAlias = RuleVariation_272

    @classmethod
    def create(cls, arg : "NonSpare_2051.cv_arg") -> "NonSpare_2051":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_272:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_279:
        return self.rule.variation

class Item_1157(Item):
    cv_arg: TypeAlias = NonSpare_2051.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2051

    @classmethod
    def create(cls, arg : "Item_1157.cv_arg") -> "Item_1157":
        return cls._create(arg) # type: ignore

class NonSpare_2056(NonSpare):
    cv_arg: TypeAlias = RuleVariation_272.cv_arg
    cv_name = "VY"
    cv_title = "Vy"
    cv_rule: TypeAlias = RuleVariation_272

    @classmethod
    def create(cls, arg : "NonSpare_2056.cv_arg") -> "NonSpare_2056":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_272:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_279:
        return self.rule.variation

class Item_1162(Item):
    cv_arg: TypeAlias = NonSpare_2056.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2056

    @classmethod
    def create(cls, arg : "Item_1162.cv_arg") -> "Item_1162":
        return cls._create(arg) # type: ignore

class Variation_1282(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_272.cv_arg, Tuple[Literal["VX"], RuleVariation_272.cv_arg]], Union[RuleVariation_272.cv_arg, Tuple[Literal["VY"], RuleVariation_272.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1282.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1157, 16), (Item_1162, 16)]
    cv_items_dict = {"VX": RuleVariation_272, "VY": RuleVariation_272}

    @overload
    @classmethod
    def spec(cls, key : Literal["VX"]) -> RuleVariation_272:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["VY"]) -> RuleVariation_272:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["VX"], Literal["VY"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["VX"]) -> RuleVariation_272:
        ...
    @overload
    def get_item(self, key : Literal["VY"]) -> RuleVariation_272:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1282.cv_arg") -> 'Variation_1282':
        return cls._create(arg) # type: ignore

class RuleVariation_1211(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1282.cv_arg
    cv_variation: TypeAlias = Variation_1282

    @classmethod
    def create(cls, arg : "RuleVariation_1211.cv_arg") -> "RuleVariation_1211":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1282:
        return self.arg # type: ignore

class NonSpare_406(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1211.cv_arg
    cv_name = "202"
    cv_title = "Calculated Track Velocity in Cartesian Coordinates"
    cv_rule: TypeAlias = RuleVariation_1211

    @classmethod
    def create(cls, arg : "NonSpare_406.cv_arg") -> "NonSpare_406":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1211:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1282:
        return self.rule.variation

class UapItem_406(UapItem):
    cv_non_spare: TypeAlias = NonSpare_406

class Content_665(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m/s²"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.25
    cv_unit = "m/s²"

    def as_quantity(self, cv_unit : Optional[Literal["m/s²"]] = None) -> float:
        return self._as_quantity()

class RuleContent_665(RuleContentContextFree):
    cv_arg: TypeAlias = Content_665.cv_arg
    cv_content: TypeAlias = Content_665

    @property
    def content(self) -> Content_665:
        return self._get_content() # type: ignore

class Variation_212(Element):
    cv_arg: TypeAlias = RuleContent_665.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_665

    @classmethod
    def create(cls, arg: "Variation_212.cv_arg") -> "Variation_212":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_665:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_665:
        return self.rule.content

class RuleVariation_205(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_212.cv_arg
    cv_variation: TypeAlias = Variation_212

    @classmethod
    def create(cls, arg : "RuleVariation_205.cv_arg") -> "RuleVariation_205":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_212:
        return self.arg # type: ignore

class NonSpare_657(NonSpare):
    cv_arg: TypeAlias = RuleVariation_205.cv_arg
    cv_name = "AX"
    cv_title = "Ax"
    cv_rule: TypeAlias = RuleVariation_205

    @classmethod
    def create(cls, arg : "NonSpare_657.cv_arg") -> "NonSpare_657":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_205:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_212:
        return self.rule.variation

class Item_100(Item):
    cv_arg: TypeAlias = NonSpare_657.cv_arg
    cv_non_spare: TypeAlias = NonSpare_657

    @classmethod
    def create(cls, arg : "Item_100.cv_arg") -> "Item_100":
        return cls._create(arg) # type: ignore

class NonSpare_661(NonSpare):
    cv_arg: TypeAlias = RuleVariation_205.cv_arg
    cv_name = "AY"
    cv_title = "Ay"
    cv_rule: TypeAlias = RuleVariation_205

    @classmethod
    def create(cls, arg : "NonSpare_661.cv_arg") -> "NonSpare_661":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_205:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_212:
        return self.rule.variation

class Item_104(Item):
    cv_arg: TypeAlias = NonSpare_661.cv_arg
    cv_non_spare: TypeAlias = NonSpare_661

    @classmethod
    def create(cls, arg : "Item_104.cv_arg") -> "Item_104":
        return cls._create(arg) # type: ignore

class Variation_1057(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_205.cv_arg, Tuple[Literal["AX"], RuleVariation_205.cv_arg]], Union[RuleVariation_205.cv_arg, Tuple[Literal["AY"], RuleVariation_205.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1057.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_100, 8), (Item_104, 8)]
    cv_items_dict = {"AX": RuleVariation_205, "AY": RuleVariation_205}

    @overload
    @classmethod
    def spec(cls, key : Literal["AX"]) -> RuleVariation_205:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AY"]) -> RuleVariation_205:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["AX"], Literal["AY"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["AX"]) -> RuleVariation_205:
        ...
    @overload
    def get_item(self, key : Literal["AY"]) -> RuleVariation_205:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1057.cv_arg") -> 'Variation_1057':
        return cls._create(arg) # type: ignore

class RuleVariation_1024(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1057.cv_arg
    cv_variation: TypeAlias = Variation_1057

    @classmethod
    def create(cls, arg : "RuleVariation_1024.cv_arg") -> "RuleVariation_1024":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1057:
        return self.arg # type: ignore

class NonSpare_408(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1024.cv_arg
    cv_name = "210"
    cv_title = "Calculated Acceleration"
    cv_rule: TypeAlias = RuleVariation_1024

    @classmethod
    def create(cls, arg : "NonSpare_408.cv_arg") -> "NonSpare_408":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1024:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1057:
        return self.rule.variation

class UapItem_408(UapItem):
    cv_non_spare: TypeAlias = NonSpare_408

class NonSpare_1299(NonSpare):
    cv_arg: TypeAlias = RuleVariation_779.cv_arg
    cv_name = "MOD3A"
    cv_title = "Mode-3/A Reply in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_779

    @classmethod
    def create(cls, arg : "NonSpare_1299.cv_arg") -> "NonSpare_1299":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_779:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_809:
        return self.rule.variation

class Item_565(Item):
    cv_arg: TypeAlias = NonSpare_1299.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1299

    @classmethod
    def create(cls, arg : "Item_565.cv_arg") -> "Item_565":
        return cls._create(arg) # type: ignore

class Variation_1024(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_779.cv_arg, Tuple[Literal["MOD3A"], RuleVariation_779.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1024.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_3, 4), (Item_565, 12)]
    cv_items_dict = {"MOD3A": RuleVariation_779}

    @classmethod
    def spec(cls, key : Literal["MOD3A"]) -> RuleVariation_779:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["MOD3A"]) -> RuleVariation_779:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1024.cv_arg") -> 'Variation_1024':
        return cls._create(arg) # type: ignore

class RuleVariation_993(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1024.cv_arg
    cv_variation: TypeAlias = Variation_1024

    @classmethod
    def create(cls, arg : "RuleVariation_993.cv_arg") -> "RuleVariation_993":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1024:
        return self.arg # type: ignore

class NonSpare_191(NonSpare):
    cv_arg: TypeAlias = RuleVariation_993.cv_arg
    cv_name = "060"
    cv_title = "Mode-3/A Code in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_993

    @classmethod
    def create(cls, arg : "NonSpare_191.cv_arg") -> "NonSpare_191":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_993:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1024:
        return self.rule.variation

class UapItem_191(UapItem):
    cv_non_spare: TypeAlias = NonSpare_191

class NonSpare_1863(NonSpare):
    cv_arg: TypeAlias = RuleVariation_383.cv_arg
    cv_name = "TID"
    cv_title = "Target Identification"
    cv_rule: TypeAlias = RuleVariation_383

    @classmethod
    def create(cls, arg : "NonSpare_1863.cv_arg") -> "NonSpare_1863":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_391:
        return self.rule.variation

class Item_999(Item):
    cv_arg: TypeAlias = NonSpare_1863.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1863

    @classmethod
    def create(cls, arg : "Item_999.cv_arg") -> "Item_999":
        return cls._create(arg) # type: ignore

class Variation_1217(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_98.cv_arg, Tuple[Literal["STI"], RuleVariation_98.cv_arg]], int, Union[RuleVariation_383.cv_arg, Tuple[Literal["TID"], RuleVariation_383.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1217.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 56
    cv_items_list = [(Item_951, 2), (Item_15, 6), (Item_999, 48)]
    cv_items_dict = {"STI": RuleVariation_98, "TID": RuleVariation_383}

    @overload
    @classmethod
    def spec(cls, key : Literal["STI"]) -> RuleVariation_98:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TID"]) -> RuleVariation_383:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["STI"], Literal["TID"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["STI"]) -> RuleVariation_98:
        ...
    @overload
    def get_item(self, key : Literal["TID"]) -> RuleVariation_383:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1217.cv_arg") -> 'Variation_1217':
        return cls._create(arg) # type: ignore

class RuleVariation_1161(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1217.cv_arg
    cv_variation: TypeAlias = Variation_1217

    @classmethod
    def create(cls, arg : "RuleVariation_1161.cv_arg") -> "RuleVariation_1161":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1217:
        return self.arg # type: ignore

class NonSpare_442(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1161.cv_arg
    cv_name = "245"
    cv_title = "Target Identification"
    cv_rule: TypeAlias = RuleVariation_1161

    @classmethod
    def create(cls, arg : "NonSpare_442.cv_arg") -> "NonSpare_442":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1161:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1217:
        return self.rule.variation

class UapItem_442(UapItem):
    cv_non_spare: TypeAlias = NonSpare_442

class Content_798(ContentBds):
    cv_arg: TypeAlias = int
    cv_bds_type = BdsWithAddress

class RuleContent_797(RuleContentContextFree):
    cv_arg: TypeAlias = Content_798.cv_arg
    cv_content: TypeAlias = Content_798

    @property
    def content(self) -> Content_798:
        return self._get_content() # type: ignore

class Variation_396(Element):
    cv_arg: TypeAlias = RuleContent_797.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 64
    cv_rule = RuleContent_797

    @classmethod
    def create(cls, arg: "Variation_396.cv_arg") -> "Variation_396":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_797:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_798:
        return self.rule.content

class Variation_1404(Repetitive):
    cv_arg: TypeAlias = List[Variation_396.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_396

    @classmethod
    def create(cls, arg: "Variation_1404.cv_arg") -> 'Variation_1404':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_396]:
        return self._get_list() # type: ignore

class RuleVariation_1325(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1404.cv_arg
    cv_variation: TypeAlias = Variation_1404

    @classmethod
    def create(cls, arg : "RuleVariation_1325.cv_arg") -> "RuleVariation_1325":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1404:
        return self.arg # type: ignore

class NonSpare_1231(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1325.cv_arg
    cv_name = "MB"
    cv_title = "BDS"
    cv_rule: TypeAlias = RuleVariation_1325

    @classmethod
    def create(cls, arg : "NonSpare_1231.cv_arg") -> "NonSpare_1231":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1325:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1404:
        return self.rule.variation

class NonSpare_571(NonSpare):
    cv_arg: TypeAlias = RuleVariation_342.cv_arg
    cv_name = "ADR"
    cv_title = "24 Bits Aircraft Address"
    cv_rule: TypeAlias = RuleVariation_342

    @classmethod
    def create(cls, arg : "NonSpare_571.cv_arg") -> "NonSpare_571":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_342:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_349:
        return self.rule.variation

class Content_339(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No communications capability (surveillance only)", 1: "Comm. A and Comm. B capability", 2: "Comm. A, Comm. B and Uplink ELM", 3: "Comm. A, Comm. B, Uplink ELM and Downlink ELM", 4: "Level 5 Transponder capability", 5: "Not assigned", 6: "Not assigned", 7: "Not assigned"}

class RuleContent_339(RuleContentContextFree):
    cv_arg: TypeAlias = Content_339.cv_arg
    cv_content: TypeAlias = Content_339

    @property
    def content(self) -> Content_339:
        return self._get_content() # type: ignore

class Variation_124(Element):
    cv_arg: TypeAlias = RuleContent_339.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 3
    cv_rule = RuleContent_339

    @classmethod
    def create(cls, arg: "Variation_124.cv_arg") -> "Variation_124":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_339:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_339:
        return self.rule.content

class RuleVariation_124(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_124.cv_arg
    cv_variation: TypeAlias = Variation_124

    @classmethod
    def create(cls, arg : "RuleVariation_124.cv_arg") -> "RuleVariation_124":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_124:
        return self.arg # type: ignore

class NonSpare_785(NonSpare):
    cv_arg: TypeAlias = RuleVariation_124.cv_arg
    cv_name = "COM"
    cv_title = "Communications Capability of the Transponder"
    cv_rule: TypeAlias = RuleVariation_124

    @classmethod
    def create(cls, arg : "NonSpare_785.cv_arg") -> "NonSpare_785":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_124:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_124:
        return self.rule.variation

class Item_188(Item):
    cv_arg: TypeAlias = NonSpare_785.cv_arg
    cv_non_spare: TypeAlias = NonSpare_785

    @classmethod
    def create(cls, arg : "Item_188.cv_arg") -> "Item_188":
        return cls._create(arg) # type: ignore

class Content_320(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No alert, no SPI, aircraft airborne", 1: "No alert, no SPI, aircraft on ground", 2: "Alert, no SPI, aircraft airborne", 3: "Alert, no SPI, aircraft on ground", 4: "Alert, SPI, aircraft airborne or on ground", 5: "No alert, SPI, aircraft airborne or on ground", 6: "General Emergency", 7: "Lifeguard / medical", 8: "Minimum fuel", 9: "No communications", 10: "Unlawful"}

class RuleContent_320(RuleContentContextFree):
    cv_arg: TypeAlias = Content_320.cv_arg
    cv_content: TypeAlias = Content_320

    @property
    def content(self) -> Content_320:
        return self._get_content() # type: ignore

class Variation_692(Element):
    cv_arg: TypeAlias = RuleContent_320.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 4
    cv_rule = RuleContent_320

    @classmethod
    def create(cls, arg: "Variation_692.cv_arg") -> "Variation_692":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_320:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_320:
        return self.rule.content

class RuleVariation_681(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_692.cv_arg
    cv_variation: TypeAlias = Variation_692

    @classmethod
    def create(cls, arg : "RuleVariation_681.cv_arg") -> "RuleVariation_681":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_692:
        return self.arg # type: ignore

class NonSpare_1779(NonSpare):
    cv_arg: TypeAlias = RuleVariation_681.cv_arg
    cv_name = "STAT"
    cv_title = "Flight Status"
    cv_rule: TypeAlias = RuleVariation_681

    @classmethod
    def create(cls, arg : "NonSpare_1779.cv_arg") -> "NonSpare_1779":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_681:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_692:
        return self.rule.variation

class Item_940(Item):
    cv_arg: TypeAlias = NonSpare_1779.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1779

    @classmethod
    def create(cls, arg : "Item_940.cv_arg") -> "Item_940":
        return cls._create(arg) # type: ignore

class Content_304(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No", 1: "Yes"}

class RuleContent_304(RuleContentContextFree):
    cv_arg: TypeAlias = Content_304.cv_arg
    cv_content: TypeAlias = Content_304

    @property
    def content(self) -> Content_304:
        return self._get_content() # type: ignore

class Variation_56(Element):
    cv_arg: TypeAlias = RuleContent_304.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_304

    @classmethod
    def create(cls, arg: "Variation_56.cv_arg") -> "Variation_56":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_304:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_304:
        return self.rule.content

class RuleVariation_56(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_56.cv_arg
    cv_variation: TypeAlias = Variation_56

    @classmethod
    def create(cls, arg : "RuleVariation_56.cv_arg") -> "RuleVariation_56":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_56:
        return self.arg # type: ignore

class NonSpare_1756(NonSpare):
    cv_arg: TypeAlias = RuleVariation_56.cv_arg
    cv_name = "SSC"
    cv_title = "Specific Service Capability"
    cv_rule: TypeAlias = RuleVariation_56

    @classmethod
    def create(cls, arg : "NonSpare_1756.cv_arg") -> "NonSpare_1756":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_56:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_56:
        return self.rule.variation

class Item_926(Item):
    cv_arg: TypeAlias = NonSpare_1756.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1756

    @classmethod
    def create(cls, arg : "Item_926.cv_arg") -> "Item_926":
        return cls._create(arg) # type: ignore

class Content_3(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "100 ft resolution", 1: "25 ft resolution"}

class RuleContent_3(RuleContentContextFree):
    cv_arg: TypeAlias = Content_3.cv_arg
    cv_content: TypeAlias = Content_3

    @property
    def content(self) -> Content_3:
        return self._get_content() # type: ignore

class Variation_401(Element):
    cv_arg: TypeAlias = RuleContent_3.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_3

    @classmethod
    def create(cls, arg: "Variation_401.cv_arg") -> "Variation_401":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_3:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_3:
        return self.rule.content

class RuleVariation_390(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_401.cv_arg
    cv_variation: TypeAlias = Variation_401

    @classmethod
    def create(cls, arg : "RuleVariation_390.cv_arg") -> "RuleVariation_390":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_401:
        return self.arg # type: ignore

class NonSpare_626(NonSpare):
    cv_arg: TypeAlias = RuleVariation_390.cv_arg
    cv_name = "ARC"
    cv_title = "Altitude Reporting Capability"
    cv_rule: TypeAlias = RuleVariation_390

    @classmethod
    def create(cls, arg : "NonSpare_626.cv_arg") -> "NonSpare_626":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_390:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_401:
        return self.rule.variation

class Item_81(Item):
    cv_arg: TypeAlias = NonSpare_626.cv_arg
    cv_non_spare: TypeAlias = NonSpare_626

    @classmethod
    def create(cls, arg : "Item_81.cv_arg") -> "Item_81":
        return cls._create(arg) # type: ignore

class Variation_558(Element):
    cv_arg: TypeAlias = RuleContent_304.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_304

    @classmethod
    def create(cls, arg: "Variation_558.cv_arg") -> "Variation_558":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_304:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_304:
        return self.rule.content

class RuleVariation_547(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_558.cv_arg
    cv_variation: TypeAlias = Variation_558

    @classmethod
    def create(cls, arg : "RuleVariation_547.cv_arg") -> "RuleVariation_547":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_558:
        return self.arg # type: ignore

class NonSpare_588(NonSpare):
    cv_arg: TypeAlias = RuleVariation_547.cv_arg
    cv_name = "AIC"
    cv_title = "Aircraft Identification Capability"
    cv_rule: TypeAlias = RuleVariation_547

    @classmethod
    def create(cls, arg : "NonSpare_588.cv_arg") -> "NonSpare_588":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_547:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_558:
        return self.rule.variation

class Item_55(Item):
    cv_arg: TypeAlias = NonSpare_588.cv_arg
    cv_non_spare: TypeAlias = NonSpare_588

    @classmethod
    def create(cls, arg : "Item_55.cv_arg") -> "Item_55":
        return cls._create(arg) # type: ignore

class NonSpare_669(NonSpare):
    cv_arg: TypeAlias = RuleVariation_603.cv_arg
    cv_name = "B1A"
    cv_title = "BDS 1,0 Bit 16"
    cv_rule: TypeAlias = RuleVariation_603

    @classmethod
    def create(cls, arg : "NonSpare_669.cv_arg") -> "NonSpare_669":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_603:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_614:
        return self.rule.variation

class Item_109(Item):
    cv_arg: TypeAlias = NonSpare_669.cv_arg
    cv_non_spare: TypeAlias = NonSpare_669

    @classmethod
    def create(cls, arg : "Item_109.cv_arg") -> "Item_109":
        return cls._create(arg) # type: ignore

class NonSpare_670(NonSpare):
    cv_arg: TypeAlias = RuleVariation_769.cv_arg
    cv_name = "B1B"
    cv_title = "BDS 1,0 Bit 37/40"
    cv_rule: TypeAlias = RuleVariation_769

    @classmethod
    def create(cls, arg : "NonSpare_670.cv_arg") -> "NonSpare_670":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_769:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_799:
        return self.rule.variation

class Item_110(Item):
    cv_arg: TypeAlias = NonSpare_670.cv_arg
    cv_non_spare: TypeAlias = NonSpare_670

    @classmethod
    def create(cls, arg : "Item_110.cv_arg") -> "Item_110":
        return cls._create(arg) # type: ignore

class NonSpare_555(NonSpare):
    cv_arg: TypeAlias = RuleVariation_56.cv_arg
    cv_name = "AC"
    cv_title = "ACAS Operational"
    cv_rule: TypeAlias = RuleVariation_56

    @classmethod
    def create(cls, arg : "NonSpare_555.cv_arg") -> "NonSpare_555":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_56:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_56:
        return self.rule.variation

class Item_37(Item):
    cv_arg: TypeAlias = NonSpare_555.cv_arg
    cv_non_spare: TypeAlias = NonSpare_555

    @classmethod
    def create(cls, arg : "Item_37.cv_arg") -> "Item_37":
        return cls._create(arg) # type: ignore

class Variation_439(Element):
    cv_arg: TypeAlias = RuleContent_304.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_304

    @classmethod
    def create(cls, arg: "Variation_439.cv_arg") -> "Variation_439":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_304:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_304:
        return self.rule.content

class RuleVariation_428(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_439.cv_arg
    cv_variation: TypeAlias = Variation_439

    @classmethod
    def create(cls, arg : "RuleVariation_428.cv_arg") -> "RuleVariation_428":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_439:
        return self.arg # type: ignore

class NonSpare_1296(NonSpare):
    cv_arg: TypeAlias = RuleVariation_428.cv_arg
    cv_name = "MN"
    cv_title = "Multiple Navigational Aids Operating"
    cv_rule: TypeAlias = RuleVariation_428

    @classmethod
    def create(cls, arg : "NonSpare_1296.cv_arg") -> "NonSpare_1296":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_428:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_439:
        return self.rule.variation

class Item_562(Item):
    cv_arg: TypeAlias = NonSpare_1296.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1296

    @classmethod
    def create(cls, arg : "Item_562.cv_arg") -> "Item_562":
        return cls._create(arg) # type: ignore

class Content_571(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Yes", 1: "No"}

class RuleContent_571(RuleContentContextFree):
    cv_arg: TypeAlias = Content_571.cv_arg
    cv_content: TypeAlias = Content_571

    @property
    def content(self) -> Content_571:
        return self._get_content() # type: ignore

class Variation_585(Element):
    cv_arg: TypeAlias = RuleContent_571.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_571

    @classmethod
    def create(cls, arg: "Variation_585.cv_arg") -> "Variation_585":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_571:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_571:
        return self.rule.content

class RuleVariation_574(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_585.cv_arg
    cv_variation: TypeAlias = Variation_585

    @classmethod
    def create(cls, arg : "RuleVariation_574.cv_arg") -> "RuleVariation_574":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_585:
        return self.arg # type: ignore

class NonSpare_872(NonSpare):
    cv_arg: TypeAlias = RuleVariation_574.cv_arg
    cv_name = "DC"
    cv_title = "Differential Correction"
    cv_rule: TypeAlias = RuleVariation_574

    @classmethod
    def create(cls, arg : "NonSpare_872.cv_arg") -> "NonSpare_872":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_574:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_585:
        return self.rule.variation

class Item_250(Item):
    cv_arg: TypeAlias = NonSpare_872.cv_arg
    cv_non_spare: TypeAlias = NonSpare_872

    @classmethod
    def create(cls, arg : "Item_250.cv_arg") -> "Item_250":
        return cls._create(arg) # type: ignore

class Item_19(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 3
    cv_bit_size = 5

class Variation_1079(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_124.cv_arg, Tuple[Literal["COM"], RuleVariation_124.cv_arg]], Union[RuleVariation_681.cv_arg, Tuple[Literal["STAT"], RuleVariation_681.cv_arg]], int, Union[RuleVariation_56.cv_arg, Tuple[Literal["SSC"], RuleVariation_56.cv_arg]], Union[RuleVariation_390.cv_arg, Tuple[Literal["ARC"], RuleVariation_390.cv_arg]], Union[RuleVariation_547.cv_arg, Tuple[Literal["AIC"], RuleVariation_547.cv_arg]], Union[RuleVariation_603.cv_arg, Tuple[Literal["B1A"], RuleVariation_603.cv_arg]], Union[RuleVariation_769.cv_arg, Tuple[Literal["B1B"], RuleVariation_769.cv_arg]], Union[RuleVariation_56.cv_arg, Tuple[Literal["AC"], RuleVariation_56.cv_arg]], Union[RuleVariation_428.cv_arg, Tuple[Literal["MN"], RuleVariation_428.cv_arg]], Union[RuleVariation_574.cv_arg, Tuple[Literal["DC"], RuleVariation_574.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1079.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_items_list = [(Item_188, 3), (Item_940, 4), (Item_29, 1), (Item_926, 1), (Item_81, 1), (Item_55, 1), (Item_109, 1), (Item_110, 4), (Item_37, 1), (Item_562, 1), (Item_250, 1), (Item_19, 5)]
    cv_items_dict = {"COM": RuleVariation_124, "STAT": RuleVariation_681, "SSC": RuleVariation_56, "ARC": RuleVariation_390, "AIC": RuleVariation_547, "B1A": RuleVariation_603, "B1B": RuleVariation_769, "AC": RuleVariation_56, "MN": RuleVariation_428, "DC": RuleVariation_574}

    @overload
    @classmethod
    def spec(cls, key : Literal["COM"]) -> RuleVariation_124:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["STAT"]) -> RuleVariation_681:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SSC"]) -> RuleVariation_56:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ARC"]) -> RuleVariation_390:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AIC"]) -> RuleVariation_547:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["B1A"]) -> RuleVariation_603:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["B1B"]) -> RuleVariation_769:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AC"]) -> RuleVariation_56:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MN"]) -> RuleVariation_428:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["DC"]) -> RuleVariation_574:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["COM"], Literal["STAT"], Literal["SSC"], Literal["ARC"], Literal["AIC"], Literal["B1A"], Literal["B1B"], Literal["AC"], Literal["MN"], Literal["DC"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["COM"]) -> RuleVariation_124:
        ...
    @overload
    def get_item(self, key : Literal["STAT"]) -> RuleVariation_681:
        ...
    @overload
    def get_item(self, key : Literal["SSC"]) -> RuleVariation_56:
        ...
    @overload
    def get_item(self, key : Literal["ARC"]) -> RuleVariation_390:
        ...
    @overload
    def get_item(self, key : Literal["AIC"]) -> RuleVariation_547:
        ...
    @overload
    def get_item(self, key : Literal["B1A"]) -> RuleVariation_603:
        ...
    @overload
    def get_item(self, key : Literal["B1B"]) -> RuleVariation_769:
        ...
    @overload
    def get_item(self, key : Literal["AC"]) -> RuleVariation_56:
        ...
    @overload
    def get_item(self, key : Literal["MN"]) -> RuleVariation_428:
        ...
    @overload
    def get_item(self, key : Literal["DC"]) -> RuleVariation_574:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1079.cv_arg") -> 'Variation_1079':
        return cls._create(arg) # type: ignore

class RuleVariation_1039(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1079.cv_arg
    cv_variation: TypeAlias = Variation_1079

    @classmethod
    def create(cls, arg : "RuleVariation_1039.cv_arg") -> "RuleVariation_1039":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1079:
        return self.arg # type: ignore

class NonSpare_789(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1039.cv_arg
    cv_name = "COMACAS"
    cv_title = "Communications/ACAS Capability and Flight Status"
    cv_rule: TypeAlias = RuleVariation_1039

    @classmethod
    def create(cls, arg : "NonSpare_789.cv_arg") -> "NonSpare_789":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1039:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1079:
        return self.rule.variation

class Variation_374(Element):
    cv_arg: TypeAlias = RuleContent_609.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_rule = RuleContent_609

    @classmethod
    def create(cls, arg: "Variation_374.cv_arg") -> "Variation_374":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_609:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_609:
        return self.rule.content

class RuleVariation_367(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_374.cv_arg
    cv_variation: TypeAlias = Variation_374

    @classmethod
    def create(cls, arg : "RuleVariation_367.cv_arg") -> "RuleVariation_367":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_374:
        return self.arg # type: ignore

class NonSpare_566(NonSpare):
    cv_arg: TypeAlias = RuleVariation_367.cv_arg
    cv_name = "ACT"
    cv_title = "Aircraft Derived Aircraft Type"
    cv_rule: TypeAlias = RuleVariation_367

    @classmethod
    def create(cls, arg : "NonSpare_566.cv_arg") -> "NonSpare_566":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_367:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_374:
        return self.rule.variation

class Content_581(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Light aircraft <= 7000 kg", 2: "Reserved", 3: "7000 kg &lt; medium aircraft &lt; 136000 kg", 4: "Reserved", 5: "136000 kg <= heavy aircraft", 6: "Highly manoeuvrable (5g acceleration capability) and high speed (&gt;400 knots cruise)", 7: "Reserved", 8: "Reserved", 9: "Reserved", 10: "Rotocraft", 11: "Glider / sailplane", 12: "Lighter-than-air", 13: "Unmanned aerial vehicle", 14: "Space / transatmospheric vehicle", 15: "Ultralight / handglider / paraglider", 16: "Parachutist / skydiver", 17: "Reserved", 18: "Reserved", 19: "Reserved", 20: "Surface emergency vehicle", 21: "Surface service vehicle", 22: "Fixed ground or tethered obstruction", 23: "Reserved", 24: "Reserved"}

class RuleContent_581(RuleContentContextFree):
    cv_arg: TypeAlias = Content_581.cv_arg
    cv_content: TypeAlias = Content_581

    @property
    def content(self) -> Content_581:
        return self._get_content() # type: ignore

class Variation_183(Element):
    cv_arg: TypeAlias = RuleContent_581.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_581

    @classmethod
    def create(cls, arg: "Variation_183.cv_arg") -> "Variation_183":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_581:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_581:
        return self.rule.content

class RuleVariation_176(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_183.cv_arg
    cv_variation: TypeAlias = Variation_183

    @classmethod
    def create(cls, arg : "RuleVariation_176.cv_arg") -> "RuleVariation_176":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_183:
        return self.arg # type: ignore

class NonSpare_919(NonSpare):
    cv_arg: TypeAlias = RuleVariation_176.cv_arg
    cv_name = "ECAT"
    cv_title = "Emitter Category"
    cv_rule: TypeAlias = RuleVariation_176

    @classmethod
    def create(cls, arg : "NonSpare_919.cv_arg") -> "NonSpare_919":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_176:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_183:
        return self.rule.variation

class Content_555(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "VDL Mode 4 available", 1: "VDL Mode 4 not available"}

class RuleContent_555(RuleContentContextFree):
    cv_arg: TypeAlias = Content_555.cv_arg
    cv_content: TypeAlias = Content_555

    @property
    def content(self) -> Content_555:
        return self._get_content() # type: ignore

class Variation_95(Element):
    cv_arg: TypeAlias = RuleContent_555.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_555

    @classmethod
    def create(cls, arg: "Variation_95.cv_arg") -> "Variation_95":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_555:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_555:
        return self.rule.content

class RuleVariation_95(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_95.cv_arg
    cv_variation: TypeAlias = Variation_95

    @classmethod
    def create(cls, arg : "RuleVariation_95.cv_arg") -> "RuleVariation_95":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_95:
        return self.arg # type: ignore

class NonSpare_2030(NonSpare):
    cv_arg: TypeAlias = RuleVariation_95.cv_arg
    cv_name = "VDL"
    cv_title = "VDL Mode 4"
    cv_rule: TypeAlias = RuleVariation_95

    @classmethod
    def create(cls, arg : "NonSpare_2030.cv_arg") -> "NonSpare_2030":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_95:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_95:
        return self.rule.variation

class Item_1139(Item):
    cv_arg: TypeAlias = NonSpare_2030.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2030

    @classmethod
    def create(cls, arg : "Item_1139.cv_arg") -> "Item_1139":
        return cls._create(arg) # type: ignore

class Content_282(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Mode S available", 1: "Mode S not available"}

class RuleContent_282(RuleContentContextFree):
    cv_arg: TypeAlias = Content_282.cv_arg
    cv_content: TypeAlias = Content_282

    @property
    def content(self) -> Content_282:
        return self._get_content() # type: ignore

class Variation_437(Element):
    cv_arg: TypeAlias = RuleContent_282.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_282

    @classmethod
    def create(cls, arg: "Variation_437.cv_arg") -> "Variation_437":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_282:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_282:
        return self.rule.content

class RuleVariation_426(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_437.cv_arg
    cv_variation: TypeAlias = Variation_437

    @classmethod
    def create(cls, arg : "RuleVariation_426.cv_arg") -> "RuleVariation_426":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_437:
        return self.arg # type: ignore

class NonSpare_1260(NonSpare):
    cv_arg: TypeAlias = RuleVariation_426.cv_arg
    cv_name = "MDS"
    cv_title = "Mode S"
    cv_rule: TypeAlias = RuleVariation_426

    @classmethod
    def create(cls, arg : "NonSpare_1260.cv_arg") -> "NonSpare_1260":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_426:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_437:
        return self.rule.variation

class Item_541(Item):
    cv_arg: TypeAlias = NonSpare_1260.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1260

    @classmethod
    def create(cls, arg : "Item_541.cv_arg") -> "Item_541":
        return cls._create(arg) # type: ignore

class Content_528(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "UAT available", 1: "UAT not available"}

class RuleContent_528(RuleContentContextFree):
    cv_arg: TypeAlias = Content_528.cv_arg
    cv_content: TypeAlias = Content_528

    @property
    def content(self) -> Content_528:
        return self._get_content() # type: ignore

class Variation_583(Element):
    cv_arg: TypeAlias = RuleContent_528.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_528

    @classmethod
    def create(cls, arg: "Variation_583.cv_arg") -> "Variation_583":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_528:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_528:
        return self.rule.content

class RuleVariation_572(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_583.cv_arg
    cv_variation: TypeAlias = Variation_583

    @classmethod
    def create(cls, arg : "RuleVariation_572.cv_arg") -> "RuleVariation_572":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_583:
        return self.arg # type: ignore

class NonSpare_1979(NonSpare):
    cv_arg: TypeAlias = RuleVariation_572.cv_arg
    cv_name = "UAT"
    cv_title = "UAT"
    cv_rule: TypeAlias = RuleVariation_572

    @classmethod
    def create(cls, arg : "NonSpare_1979.cv_arg") -> "NonSpare_1979":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_572:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_583:
        return self.rule.variation

class Item_1091(Item):
    cv_arg: TypeAlias = NonSpare_1979.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1979

    @classmethod
    def create(cls, arg : "Item_1091.cv_arg") -> "Item_1091":
        return cls._create(arg) # type: ignore

class Variation_1278(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_95.cv_arg, Tuple[Literal["VDL"], RuleVariation_95.cv_arg]], Union[RuleVariation_426.cv_arg, Tuple[Literal["MDS"], RuleVariation_426.cv_arg]], Union[RuleVariation_572.cv_arg, Tuple[Literal["UAT"], RuleVariation_572.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1278.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_1139, 1), (Item_541, 1), (Item_1091, 1), (Item_19, 5)]
    cv_items_dict = {"VDL": RuleVariation_95, "MDS": RuleVariation_426, "UAT": RuleVariation_572}

    @overload
    @classmethod
    def spec(cls, key : Literal["VDL"]) -> RuleVariation_95:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MDS"]) -> RuleVariation_426:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["UAT"]) -> RuleVariation_572:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["VDL"], Literal["MDS"], Literal["UAT"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["VDL"]) -> RuleVariation_95:
        ...
    @overload
    def get_item(self, key : Literal["MDS"]) -> RuleVariation_426:
        ...
    @overload
    def get_item(self, key : Literal["UAT"]) -> RuleVariation_572:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1278.cv_arg") -> 'Variation_1278':
        return cls._create(arg) # type: ignore

class RuleVariation_1207(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1278.cv_arg
    cv_variation: TypeAlias = Variation_1278

    @classmethod
    def create(cls, arg : "RuleVariation_1207.cv_arg") -> "RuleVariation_1207":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1278:
        return self.arg # type: ignore

class NonSpare_654(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1207.cv_arg
    cv_name = "AVTECH"
    cv_title = "Available Technologies"
    cv_rule: TypeAlias = RuleVariation_1207

    @classmethod
    def create(cls, arg : "NonSpare_654.cv_arg") -> "NonSpare_654":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1207:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1278:
        return self.rule.variation

class Variation_1494(Compound):
    cv_arg = TypedDict('cv_arg', {
        "MB": NonSpare_1231.cv_arg,
        "ADR": NonSpare_571.cv_arg,
        "COMACAS": NonSpare_789.cv_arg,
        "ACT": NonSpare_566.cv_arg,
        "ECAT": NonSpare_919.cv_arg,
        "AVTECH": NonSpare_654.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 2
    cv_items_list = [NonSpare_1231, NonSpare_571, None, NonSpare_789, None, None, None, NonSpare_566, NonSpare_919, None, NonSpare_654]
    cv_items_dict = {"MB": NonSpare_1231, "ADR": NonSpare_571, "COMACAS": NonSpare_789, "ACT": NonSpare_566, "ECAT": NonSpare_919, "AVTECH": NonSpare_654}

    @overload
    @classmethod
    def spec(cls, key : Literal["MB"]) -> NonSpare_1231:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ADR"]) -> NonSpare_571:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["COMACAS"]) -> NonSpare_789:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ACT"]) -> NonSpare_566:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ECAT"]) -> NonSpare_919:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AVTECH"]) -> NonSpare_654:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["MB"], Literal["ADR"], Literal["COMACAS"], Literal["ACT"], Literal["ECAT"], Literal["AVTECH"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["MB"]) -> Optional[NonSpare_1231]:
        ...
    @overload
    def get_item(self, key : Literal["ADR"]) -> Optional[NonSpare_571]:
        ...
    @overload
    def get_item(self, key : Literal["COMACAS"]) -> Optional[NonSpare_789]:
        ...
    @overload
    def get_item(self, key : Literal["ACT"]) -> Optional[NonSpare_566]:
        ...
    @overload
    def get_item(self, key : Literal["ECAT"]) -> Optional[NonSpare_919]:
        ...
    @overload
    def get_item(self, key : Literal["AVTECH"]) -> Optional[NonSpare_654]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["MB"], val : NonSpare_1231.cv_arg) -> "Variation_1494":
        ...
    @overload
    def set_item(self, key : Literal["ADR"], val : NonSpare_571.cv_arg) -> "Variation_1494":
        ...
    @overload
    def set_item(self, key : Literal["COMACAS"], val : NonSpare_789.cv_arg) -> "Variation_1494":
        ...
    @overload
    def set_item(self, key : Literal["ACT"], val : NonSpare_566.cv_arg) -> "Variation_1494":
        ...
    @overload
    def set_item(self, key : Literal["ECAT"], val : NonSpare_919.cv_arg) -> "Variation_1494":
        ...
    @overload
    def set_item(self, key : Literal["AVTECH"], val : NonSpare_654.cv_arg) -> "Variation_1494":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["MB"]) -> "Variation_1494":
        ...
    @overload
    def del_item(self, key : Literal["ADR"]) -> "Variation_1494":
        ...
    @overload
    def del_item(self, key : Literal["COMACAS"]) -> "Variation_1494":
        ...
    @overload
    def del_item(self, key : Literal["ACT"]) -> "Variation_1494":
        ...
    @overload
    def del_item(self, key : Literal["ECAT"]) -> "Variation_1494":
        ...
    @overload
    def del_item(self, key : Literal["AVTECH"]) -> "Variation_1494":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1494.cv_arg") -> 'Variation_1494':
        return cls._create(arg) # type: ignore

class RuleVariation_1415(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1494.cv_arg
    cv_variation: TypeAlias = Variation_1494

    @classmethod
    def create(cls, arg : "RuleVariation_1415.cv_arg") -> "RuleVariation_1415":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1494:
        return self.arg # type: ignore

class NonSpare_489(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1415.cv_arg
    cv_name = "380"
    cv_title = "Mode-S / ADS-B Related Data"
    cv_rule: TypeAlias = RuleVariation_1415

    @classmethod
    def create(cls, arg : "NonSpare_489.cv_arg") -> "NonSpare_489":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1415:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1494:
        return self.rule.variation

class UapItem_489(UapItem):
    cv_non_spare: TypeAlias = NonSpare_489

class Item_0(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 0
    cv_bit_size = 1

class Variation_499(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 15
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_499.cv_arg") -> "Variation_499":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_488(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_499.cv_arg
    cv_variation: TypeAlias = Variation_499

    @classmethod
    def create(cls, arg : "RuleVariation_488.cv_arg") -> "RuleVariation_488":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_499:
        return self.arg # type: ignore

class NonSpare_1006(NonSpare):
    cv_arg: TypeAlias = RuleVariation_488.cv_arg
    cv_name = "FTN"
    cv_title = "Fusion Track Number"
    cv_rule: TypeAlias = RuleVariation_488

    @classmethod
    def create(cls, arg : "NonSpare_1006.cv_arg") -> "NonSpare_1006":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_488:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_499:
        return self.rule.variation

class Item_352(Item):
    cv_arg: TypeAlias = NonSpare_1006.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1006

    @classmethod
    def create(cls, arg : "Item_352.cv_arg") -> "Item_352":
        return cls._create(arg) # type: ignore

class Variation_995(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_488.cv_arg, Tuple[Literal["FTN"], RuleVariation_488.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_995.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_0, 1), (Item_352, 15)]
    cv_items_dict = {"FTN": RuleVariation_488}

    @classmethod
    def spec(cls, key : Literal["FTN"]) -> RuleVariation_488:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["FTN"]) -> RuleVariation_488:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_995.cv_arg") -> 'Variation_995':
        return cls._create(arg) # type: ignore

class RuleVariation_965(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_995.cv_arg
    cv_variation: TypeAlias = Variation_995

    @classmethod
    def create(cls, arg : "RuleVariation_965.cv_arg") -> "RuleVariation_965":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_995:
        return self.arg # type: ignore

class NonSpare_361(NonSpare):
    cv_arg: TypeAlias = RuleVariation_965.cv_arg
    cv_name = "161"
    cv_title = "Track Number"
    cv_rule: TypeAlias = RuleVariation_965

    @classmethod
    def create(cls, arg : "NonSpare_361.cv_arg") -> "NonSpare_361":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_965:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_995:
        return self.rule.variation

class UapItem_361(UapItem):
    cv_non_spare: TypeAlias = NonSpare_361

class Content_298(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Multisensor Track", 1: "Monosensor Track"}

class RuleContent_298(RuleContentContextFree):
    cv_arg: TypeAlias = Content_298.cv_arg
    cv_content: TypeAlias = Content_298

    @property
    def content(self) -> Content_298:
        return self._get_content() # type: ignore

class Variation_54(Element):
    cv_arg: TypeAlias = RuleContent_298.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_298

    @classmethod
    def create(cls, arg: "Variation_54.cv_arg") -> "Variation_54":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_298:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_298:
        return self.rule.content

class RuleVariation_54(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_54.cv_arg
    cv_variation: TypeAlias = Variation_54

    @classmethod
    def create(cls, arg : "RuleVariation_54.cv_arg") -> "RuleVariation_54":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_54:
        return self.arg # type: ignore

class Content_522(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Transponder Ground bit not set or unknown", 1: "Transponder Ground bit set"}

class RuleContent_522(RuleContentContextFree):
    cv_arg: TypeAlias = Content_522.cv_arg
    cv_content: TypeAlias = Content_522

    @property
    def content(self) -> Content_522:
        return self._get_content() # type: ignore

class Variation_461(Element):
    cv_arg: TypeAlias = RuleContent_522.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_522

    @classmethod
    def create(cls, arg: "Variation_461.cv_arg") -> "Variation_461":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_522:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_522:
        return self.rule.content

class RuleVariation_450(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_461.cv_arg
    cv_variation: TypeAlias = Variation_461

    @classmethod
    def create(cls, arg : "RuleVariation_450.cv_arg") -> "RuleVariation_450":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_461:
        return self.arg # type: ignore

class Content_45(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Barometric altitude (Mode C) more reliable", 1: "Geometric altitude more reliable"}

class RuleContent_45(RuleContentContextFree):
    cv_arg: TypeAlias = Content_45.cv_arg
    cv_content: TypeAlias = Content_45

    @property
    def content(self) -> Content_45:
        return self._get_content() # type: ignore

class Variation_511(Element):
    cv_arg: TypeAlias = RuleContent_45.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_45

    @classmethod
    def create(cls, arg: "Variation_511.cv_arg") -> "Variation_511":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_45:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_45:
        return self.rule.content

class RuleVariation_500(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_511.cv_arg
    cv_variation: TypeAlias = Variation_511

    @classmethod
    def create(cls, arg : "RuleVariation_500.cv_arg") -> "RuleVariation_500":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_511:
        return self.arg # type: ignore

class Content_372(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No source", 1: "GPS", 2: "3d radar", 3: "Triangulation", 4: "Height from coverage", 5: "Speed look-up table", 6: "Default height", 7: "Multilateration"}

class RuleContent_372(RuleContentContextFree):
    cv_arg: TypeAlias = Content_372.cv_arg
    cv_content: TypeAlias = Content_372

    @property
    def content(self) -> Content_372:
        return self._get_content() # type: ignore

class Variation_690(Element):
    cv_arg: TypeAlias = RuleContent_372.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 3
    cv_rule = RuleContent_372

    @classmethod
    def create(cls, arg: "Variation_690.cv_arg") -> "Variation_690":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_372:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_372:
        return self.rule.content

class RuleVariation_679(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_690.cv_arg
    cv_variation: TypeAlias = Variation_690

    @classmethod
    def create(cls, arg : "RuleVariation_679.cv_arg") -> "RuleVariation_679":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_690:
        return self.arg # type: ignore

class Content_62(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Confirmed track", 1: "Tentative track"}

class RuleContent_62(RuleContentContextFree):
    cv_arg: TypeAlias = Content_62.cv_arg
    cv_content: TypeAlias = Content_62

    @property
    def content(self) -> Content_62:
        return self._get_content() # type: ignore

class Variation_907(Element):
    cv_arg: TypeAlias = RuleContent_62.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_62

    @classmethod
    def create(cls, arg: "Variation_907.cv_arg") -> "Variation_907":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_62:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_62:
        return self.rule.content

class RuleVariation_877(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_907.cv_arg
    cv_variation: TypeAlias = Variation_907

    @classmethod
    def create(cls, arg : "RuleVariation_877.cv_arg") -> "RuleVariation_877":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_907:
        return self.arg # type: ignore

class Content_17(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Actual Track", 1: "Simulated track"}

class RuleContent_17(RuleContentContextFree):
    cv_arg: TypeAlias = Content_17.cv_arg
    cv_content: TypeAlias = Content_17

    @property
    def content(self) -> Content_17:
        return self._get_content() # type: ignore

class Variation_4(Element):
    cv_arg: TypeAlias = RuleContent_17.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_17

    @classmethod
    def create(cls, arg: "Variation_4.cv_arg") -> "Variation_4":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_17:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_17:
        return self.rule.content

class RuleVariation_4(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_4.cv_arg
    cv_variation: TypeAlias = Variation_4

    @classmethod
    def create(cls, arg : "RuleVariation_4.cv_arg") -> "RuleVariation_4":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_4:
        return self.arg # type: ignore

class Content_196(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default value", 1: "Track service end (i.e. last message transmitted to the user for the track)"}

class RuleContent_196(RuleContentContextFree):
    cv_arg: TypeAlias = Content_196.cv_arg
    cv_content: TypeAlias = Content_196

    @property
    def content(self) -> Content_196:
        return self._get_content() # type: ignore

class Variation_424(Element):
    cv_arg: TypeAlias = RuleContent_196.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_196

    @classmethod
    def create(cls, arg: "Variation_424.cv_arg") -> "Variation_424":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_196:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_196:
        return self.rule.content

class RuleVariation_413(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_424.cv_arg
    cv_variation: TypeAlias = Variation_424

    @classmethod
    def create(cls, arg : "RuleVariation_413.cv_arg") -> "RuleVariation_413":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_424:
        return self.arg # type: ignore

class Content_195(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default value", 1: "Track service begin (i.e. first message transmitted to the user for the track)"}

class RuleContent_195(RuleContentContextFree):
    cv_arg: TypeAlias = Content_195.cv_arg
    cv_content: TypeAlias = Content_195

    @property
    def content(self) -> Content_195:
        return self._get_content() # type: ignore

class Variation_532(Element):
    cv_arg: TypeAlias = RuleContent_195.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_195

    @classmethod
    def create(cls, arg: "Variation_532.cv_arg") -> "Variation_532":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_195:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_195:
        return self.rule.content

class RuleVariation_521(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_532.cv_arg
    cv_variation: TypeAlias = Variation_532

    @classmethod
    def create(cls, arg : "RuleVariation_521.cv_arg") -> "RuleVariation_521":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_532:
        return self.arg # type: ignore

class Content_311(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No Mode 4 interrogationt", 1: "Friendly target", 2: "Unknown target", 3: "No reply"}

class RuleContent_311(RuleContentContextFree):
    cv_arg: TypeAlias = Content_311.cv_arg
    cv_content: TypeAlias = Content_311

    @property
    def content(self) -> Content_311:
        return self._get_content() # type: ignore

class Variation_679(Element):
    cv_arg: TypeAlias = RuleContent_311.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 2
    cv_rule = RuleContent_311

    @classmethod
    def create(cls, arg: "Variation_679.cv_arg") -> "Variation_679":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_311:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_311:
        return self.rule.content

class RuleVariation_668(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_679.cv_arg
    cv_variation: TypeAlias = Variation_679

    @classmethod
    def create(cls, arg : "RuleVariation_668.cv_arg") -> "RuleVariation_668":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_679:
        return self.arg # type: ignore

class Content_188(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default value", 1: "Military Emergency present in the last report received from a sensor capable of decoding this data"}

class RuleContent_188(RuleContentContextFree):
    cv_arg: TypeAlias = Content_188.cv_arg
    cv_content: TypeAlias = Content_188

    @property
    def content(self) -> Content_188:
        return self._get_content() # type: ignore

class Variation_845(Element):
    cv_arg: TypeAlias = RuleContent_188.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_188

    @classmethod
    def create(cls, arg: "Variation_845.cv_arg") -> "Variation_845":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_188:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_188:
        return self.rule.content

class RuleVariation_815(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_845.cv_arg
    cv_variation: TypeAlias = Variation_845

    @classmethod
    def create(cls, arg : "RuleVariation_815.cv_arg") -> "RuleVariation_815":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_845:
        return self.arg # type: ignore

class Content_209(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "End of Data Item", 1: "Military Identification present in the last report received from a sensor capable of decoding this data"}

class RuleContent_209(RuleContentContextFree):
    cv_arg: TypeAlias = Content_209.cv_arg
    cv_content: TypeAlias = Content_209

    @property
    def content(self) -> Content_209:
        return self._get_content() # type: ignore

class Variation_926(Element):
    cv_arg: TypeAlias = RuleContent_209.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_209

    @classmethod
    def create(cls, arg: "Variation_926.cv_arg") -> "Variation_926":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_209:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_209:
        return self.rule.content

class RuleVariation_896(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_926.cv_arg
    cv_variation: TypeAlias = Variation_926

    @classmethod
    def create(cls, arg : "RuleVariation_896.cv_arg") -> "RuleVariation_896":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_926:
        return self.arg # type: ignore

class Content_513(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Track not resulting from amalgamation process", 1: "Track resulting from amalgamation process"}

class RuleContent_513(RuleContentContextFree):
    cv_arg: TypeAlias = Content_513.cv_arg
    cv_content: TypeAlias = Content_513

    @property
    def content(self) -> Content_513:
        return self._get_content() # type: ignore

class Variation_90(Element):
    cv_arg: TypeAlias = RuleContent_513.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_513

    @classmethod
    def create(cls, arg: "Variation_90.cv_arg") -> "Variation_90":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_513:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_513:
        return self.rule.content

class RuleVariation_90(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_90.cv_arg
    cv_variation: TypeAlias = Variation_90

    @classmethod
    def create(cls, arg : "RuleVariation_90.cv_arg") -> "RuleVariation_90":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_90:
        return self.arg # type: ignore

class Content_190(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default value", 1: "SPI present in the last report received from a sensor capable of decoding this data"}

class RuleContent_190(RuleContentContextFree):
    cv_arg: TypeAlias = Content_190.cv_arg
    cv_content: TypeAlias = Content_190

    @property
    def content(self) -> Content_190:
        return self._get_content() # type: ignore

class Variation_423(Element):
    cv_arg: TypeAlias = RuleContent_190.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_190

    @classmethod
    def create(cls, arg: "Variation_423.cv_arg") -> "Variation_423":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_190:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_190:
        return self.rule.content

class RuleVariation_412(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_423.cv_arg
    cv_variation: TypeAlias = Variation_423

    @classmethod
    def create(cls, arg : "RuleVariation_412.cv_arg") -> "RuleVariation_412":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_423:
        return self.arg # type: ignore

class Content_179(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default value", 1: "Age of the last received track update is higher than system dependent threshold (coasting)"}

class RuleContent_179(RuleContentContextFree):
    cv_arg: TypeAlias = Content_179.cv_arg
    cv_content: TypeAlias = Content_179

    @property
    def content(self) -> Content_179:
        return self._get_content() # type: ignore

class Variation_529(Element):
    cv_arg: TypeAlias = RuleContent_179.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_179

    @classmethod
    def create(cls, arg: "Variation_529.cv_arg") -> "Variation_529":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_179:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_179:
        return self.rule.content

class RuleVariation_518(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_529.cv_arg
    cv_variation: TypeAlias = Variation_529

    @classmethod
    def create(cls, arg : "RuleVariation_518.cv_arg") -> "RuleVariation_518":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_529:
        return self.arg # type: ignore

class Content_399(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Not flight-plan correlated", 1: "Flight plan correlated"}

class RuleContent_399(RuleContentContextFree):
    cv_arg: TypeAlias = Content_399.cv_arg
    cv_content: TypeAlias = Content_399

    @property
    def content(self) -> Content_399:
        return self._get_content() # type: ignore

class Variation_658(Element):
    cv_arg: TypeAlias = RuleContent_399.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_399

    @classmethod
    def create(cls, arg: "Variation_658.cv_arg") -> "Variation_658":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_399:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_399:
        return self.rule.content

class RuleVariation_647(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_658.cv_arg
    cv_variation: TypeAlias = Variation_658

    @classmethod
    def create(cls, arg : "RuleVariation_647.cv_arg") -> "RuleVariation_647":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_658:
        return self.arg # type: ignore

class Content_172(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default value", 1: "ADS-B data inconsistent with other surveillance information"}

class RuleContent_172(RuleContentContextFree):
    cv_arg: TypeAlias = Content_172.cv_arg
    cv_content: TypeAlias = Content_172

    @property
    def content(self) -> Content_172:
        return self._get_content() # type: ignore

class Variation_716(Element):
    cv_arg: TypeAlias = RuleContent_172.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_172

    @classmethod
    def create(cls, arg: "Variation_716.cv_arg") -> "Variation_716":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_172:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_172:
        return self.rule.content

class RuleVariation_705(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_716.cv_arg
    cv_variation: TypeAlias = Variation_716

    @classmethod
    def create(cls, arg : "RuleVariation_705.cv_arg") -> "RuleVariation_705":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_716:
        return self.arg # type: ignore

class NonSpare_1312(NonSpare):
    cv_arg: TypeAlias = RuleVariation_54.cv_arg
    cv_name = "MON"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_54

    @classmethod
    def create(cls, arg : "NonSpare_1312.cv_arg") -> "NonSpare_1312":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_54:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_54:
        return self.rule.variation

class Item_578(Item):
    cv_arg: TypeAlias = NonSpare_1312.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1312

    @classmethod
    def create(cls, arg : "Item_578.cv_arg") -> "Item_578":
        return cls._create(arg) # type: ignore

class NonSpare_1027(NonSpare):
    cv_arg: TypeAlias = RuleVariation_450.cv_arg
    cv_name = "GBS"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_450

    @classmethod
    def create(cls, arg : "NonSpare_1027.cv_arg") -> "NonSpare_1027":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_450:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_461:
        return self.rule.variation

class Item_365(Item):
    cv_arg: TypeAlias = NonSpare_1027.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1027

    @classmethod
    def create(cls, arg : "Item_365.cv_arg") -> "Item_365":
        return cls._create(arg) # type: ignore

class NonSpare_1315(NonSpare):
    cv_arg: TypeAlias = RuleVariation_500.cv_arg
    cv_name = "MRH"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_500

    @classmethod
    def create(cls, arg : "NonSpare_1315.cv_arg") -> "NonSpare_1315":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_500:
        return self.arg # type: ignore

    # shortcut