# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CatalogArgs', 'Catalog']

@pulumi.input_type
class CatalogArgs:
    def __init__(__self__, *,
                 browse_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_predictive_optimization_flag: Optional[pulumi.Input['CatalogEffectivePredictiveOptimizationFlagArgs']] = None,
                 enable_predictive_optimization: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioning_info: Optional[pulumi.Input['CatalogProvisioningInfoArgs']] = None,
                 share_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_root: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Catalog resource.
        :param pulumi.Input[_builtins.str] comment: User-supplied free-form text.
        :param pulumi.Input[_builtins.str] connection_name: For Foreign Catalogs: the name of the connection to an external data source. Changes forces creation of a new resource.
        :param pulumi.Input[_builtins.str] enable_predictive_optimization: Whether predictive optimization should be enabled for this object and objects under it. Can be `ENABLE`, `DISABLE` or `INHERIT`
        :param pulumi.Input[_builtins.bool] force_destroy: Delete catalog regardless of its contents.
        :param pulumi.Input[_builtins.str] isolation_mode: Whether the catalog is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATED` or `OPEN`. Setting the catalog to `ISOLATED` will automatically allow access from the current workspace.
        :param pulumi.Input[_builtins.str] metastore_id: ID of the parent metastore.
        :param pulumi.Input[_builtins.str] name: Name of Catalog relative to parent metastore.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: For Foreign Catalogs: the name of the entity from an external data source that maps to a catalog. For example, the database name in a PostgreSQL server.
        :param pulumi.Input[_builtins.str] owner: Username/groupname/sp application_id of the catalog owner.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: Extensible Catalog properties.
        :param pulumi.Input[_builtins.str] provider_name: For Delta Sharing Catalogs: the name of the delta sharing provider. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] share_name: For Delta Sharing Catalogs: the name of the share under the share provider. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] storage_root: Managed location of the catalog. Location in cloud storage where data for managed tables will be stored. If not specified, the location will default to the metastore root location. Change forces creation of a new resource.
        """
        if browse_only is not None:
            pulumi.set(__self__, "browse_only", browse_only)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if effective_predictive_optimization_flag is not None:
            pulumi.set(__self__, "effective_predictive_optimization_flag", effective_predictive_optimization_flag)
        if enable_predictive_optimization is not None:
            pulumi.set(__self__, "enable_predictive_optimization", enable_predictive_optimization)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if isolation_mode is not None:
            pulumi.set(__self__, "isolation_mode", isolation_mode)
        if metastore_id is not None:
            pulumi.set(__self__, "metastore_id", metastore_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if provider_name is not None:
            pulumi.set(__self__, "provider_name", provider_name)
        if provisioning_info is not None:
            pulumi.set(__self__, "provisioning_info", provisioning_info)
        if share_name is not None:
            pulumi.set(__self__, "share_name", share_name)
        if storage_location is not None:
            pulumi.set(__self__, "storage_location", storage_location)
        if storage_root is not None:
            pulumi.set(__self__, "storage_root", storage_root)

    @_builtins.property
    @pulumi.getter(name="browseOnly")
    def browse_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "browse_only")

    @browse_only.setter
    def browse_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "browse_only", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-supplied free-form text.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For Foreign Catalogs: the name of the connection to an external data source. Changes forces creation of a new resource.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_name", value)

    @_builtins.property
    @pulumi.getter(name="effectivePredictiveOptimizationFlag")
    def effective_predictive_optimization_flag(self) -> Optional[pulumi.Input['CatalogEffectivePredictiveOptimizationFlagArgs']]:
        return pulumi.get(self, "effective_predictive_optimization_flag")

    @effective_predictive_optimization_flag.setter
    def effective_predictive_optimization_flag(self, value: Optional[pulumi.Input['CatalogEffectivePredictiveOptimizationFlagArgs']]):
        pulumi.set(self, "effective_predictive_optimization_flag", value)

    @_builtins.property
    @pulumi.getter(name="enablePredictiveOptimization")
    def enable_predictive_optimization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether predictive optimization should be enabled for this object and objects under it. Can be `ENABLE`, `DISABLE` or `INHERIT`
        """
        return pulumi.get(self, "enable_predictive_optimization")

    @enable_predictive_optimization.setter
    def enable_predictive_optimization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_predictive_optimization", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Delete catalog regardless of its contents.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="isolationMode")
    def isolation_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the catalog is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATED` or `OPEN`. Setting the catalog to `ISOLATED` will automatically allow access from the current workspace.
        """
        return pulumi.get(self, "isolation_mode")

    @isolation_mode.setter
    def isolation_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isolation_mode", value)

    @_builtins.property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the parent metastore.
        """
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metastore_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of Catalog relative to parent metastore.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        For Foreign Catalogs: the name of the entity from an external data source that maps to a catalog. For example, the database name in a PostgreSQL server.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username/groupname/sp application_id of the catalog owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Extensible Catalog properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For Delta Sharing Catalogs: the name of the delta sharing provider. Change forces creation of a new resource.
        """
        return pulumi.get(self, "provider_name")

    @provider_name.setter
    def provider_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_name", value)

    @_builtins.property
    @pulumi.getter(name="provisioningInfo")
    def provisioning_info(self) -> Optional[pulumi.Input['CatalogProvisioningInfoArgs']]:
        return pulumi.get(self, "provisioning_info")

    @provisioning_info.setter
    def provisioning_info(self, value: Optional[pulumi.Input['CatalogProvisioningInfoArgs']]):
        pulumi.set(self, "provisioning_info", value)

    @_builtins.property
    @pulumi.getter(name="shareName")
    def share_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For Delta Sharing Catalogs: the name of the share under the share provider. Change forces creation of a new resource.
        """
        return pulumi.get(self, "share_name")

    @share_name.setter
    def share_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share_name", value)

    @_builtins.property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "storage_location")

    @storage_location.setter
    def storage_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_location", value)

    @_builtins.property
    @pulumi.getter(name="storageRoot")
    def storage_root(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Managed location of the catalog. Location in cloud storage where data for managed tables will be stored. If not specified, the location will default to the metastore root location. Change forces creation of a new resource.
        """
        return pulumi.get(self, "storage_root")

    @storage_root.setter
    def storage_root(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_root", value)


@pulumi.input_type
class _CatalogState:
    def __init__(__self__, *,
                 browse_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 catalog_type: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.int]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_predictive_optimization_flag: Optional[pulumi.Input['CatalogEffectivePredictiveOptimizationFlagArgs']] = None,
                 enable_predictive_optimization: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 full_name: Optional[pulumi.Input[_builtins.str]] = None,
                 isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioning_info: Optional[pulumi.Input['CatalogProvisioningInfoArgs']] = None,
                 securable_type: Optional[pulumi.Input[_builtins.str]] = None,
                 share_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_root: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.int]] = None,
                 updated_by: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Catalog resources.
        :param pulumi.Input[_builtins.str] comment: User-supplied free-form text.
        :param pulumi.Input[_builtins.str] connection_name: For Foreign Catalogs: the name of the connection to an external data source. Changes forces creation of a new resource.
        :param pulumi.Input[_builtins.str] enable_predictive_optimization: Whether predictive optimization should be enabled for this object and objects under it. Can be `ENABLE`, `DISABLE` or `INHERIT`
        :param pulumi.Input[_builtins.bool] force_destroy: Delete catalog regardless of its contents.
        :param pulumi.Input[_builtins.str] isolation_mode: Whether the catalog is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATED` or `OPEN`. Setting the catalog to `ISOLATED` will automatically allow access from the current workspace.
        :param pulumi.Input[_builtins.str] metastore_id: ID of the parent metastore.
        :param pulumi.Input[_builtins.str] name: Name of Catalog relative to parent metastore.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: For Foreign Catalogs: the name of the entity from an external data source that maps to a catalog. For example, the database name in a PostgreSQL server.
        :param pulumi.Input[_builtins.str] owner: Username/groupname/sp application_id of the catalog owner.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: Extensible Catalog properties.
        :param pulumi.Input[_builtins.str] provider_name: For Delta Sharing Catalogs: the name of the delta sharing provider. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] share_name: For Delta Sharing Catalogs: the name of the share under the share provider. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] storage_root: Managed location of the catalog. Location in cloud storage where data for managed tables will be stored. If not specified, the location will default to the metastore root location. Change forces creation of a new resource.
        """
        if browse_only is not None:
            pulumi.set(__self__, "browse_only", browse_only)
        if catalog_type is not None:
            pulumi.set(__self__, "catalog_type", catalog_type)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if effective_predictive_optimization_flag is not None:
            pulumi.set(__self__, "effective_predictive_optimization_flag", effective_predictive_optimization_flag)
        if enable_predictive_optimization is not None:
            pulumi.set(__self__, "enable_predictive_optimization", enable_predictive_optimization)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if isolation_mode is not None:
            pulumi.set(__self__, "isolation_mode", isolation_mode)
        if metastore_id is not None:
            pulumi.set(__self__, "metastore_id", metastore_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if provider_name is not None:
            pulumi.set(__self__, "provider_name", provider_name)
        if provisioning_info is not None:
            pulumi.set(__self__, "provisioning_info", provisioning_info)
        if securable_type is not None:
            pulumi.set(__self__, "securable_type", securable_type)
        if share_name is not None:
            pulumi.set(__self__, "share_name", share_name)
        if storage_location is not None:
            pulumi.set(__self__, "storage_location", storage_location)
        if storage_root is not None:
            pulumi.set(__self__, "storage_root", storage_root)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if updated_by is not None:
            pulumi.set(__self__, "updated_by", updated_by)

    @_builtins.property
    @pulumi.getter(name="browseOnly")
    def browse_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "browse_only")

    @browse_only.setter
    def browse_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "browse_only", value)

    @_builtins.property
    @pulumi.getter(name="catalogType")
    def catalog_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "catalog_type")

    @catalog_type.setter
    def catalog_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "catalog_type", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-supplied free-form text.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For Foreign Catalogs: the name of the connection to an external data source. Changes forces creation of a new resource.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_name", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="effectivePredictiveOptimizationFlag")
    def effective_predictive_optimization_flag(self) -> Optional[pulumi.Input['CatalogEffectivePredictiveOptimizationFlagArgs']]:
        return pulumi.get(self, "effective_predictive_optimization_flag")

    @effective_predictive_optimization_flag.setter
    def effective_predictive_optimization_flag(self, value: Optional[pulumi.Input['CatalogEffectivePredictiveOptimizationFlagArgs']]):
        pulumi.set(self, "effective_predictive_optimization_flag", value)

    @_builtins.property
    @pulumi.getter(name="enablePredictiveOptimization")
    def enable_predictive_optimization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether predictive optimization should be enabled for this object and objects under it. Can be `ENABLE`, `DISABLE` or `INHERIT`
        """
        return pulumi.get(self, "enable_predictive_optimization")

    @enable_predictive_optimization.setter
    def enable_predictive_optimization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_predictive_optimization", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Delete catalog regardless of its contents.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "full_name")

    @full_name.setter
    def full_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "full_name", value)

    @_builtins.property
    @pulumi.getter(name="isolationMode")
    def isolation_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the catalog is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATED` or `OPEN`. Setting the catalog to `ISOLATED` will automatically allow access from the current workspace.
        """
        return pulumi.get(self, "isolation_mode")

    @isolation_mode.setter
    def isolation_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isolation_mode", value)

    @_builtins.property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the parent metastore.
        """
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metastore_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of Catalog relative to parent metastore.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        For Foreign Catalogs: the name of the entity from an external data source that maps to a catalog. For example, the database name in a PostgreSQL server.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username/groupname/sp application_id of the catalog owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Extensible Catalog properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For Delta Sharing Catalogs: the name of the delta sharing provider. Change forces creation of a new resource.
        """
        return pulumi.get(self, "provider_name")

    @provider_name.setter
    def provider_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_name", value)

    @_builtins.property
    @pulumi.getter(name="provisioningInfo")
    def provisioning_info(self) -> Optional[pulumi.Input['CatalogProvisioningInfoArgs']]:
        return pulumi.get(self, "provisioning_info")

    @provisioning_info.setter
    def provisioning_info(self, value: Optional[pulumi.Input['CatalogProvisioningInfoArgs']]):
        pulumi.set(self, "provisioning_info", value)

    @_builtins.property
    @pulumi.getter(name="securableType")
    def securable_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "securable_type")

    @securable_type.setter
    def securable_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "securable_type", value)

    @_builtins.property
    @pulumi.getter(name="shareName")
    def share_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For Delta Sharing Catalogs: the name of the share under the share provider. Change forces creation of a new resource.
        """
        return pulumi.get(self, "share_name")

    @share_name.setter
    def share_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share_name", value)

    @_builtins.property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "storage_location")

    @storage_location.setter
    def storage_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_location", value)

    @_builtins.property
    @pulumi.getter(name="storageRoot")
    def storage_root(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Managed location of the catalog. Location in cloud storage where data for managed tables will be stored. If not specified, the location will default to the metastore root location. Change forces creation of a new resource.
        """
        return pulumi.get(self, "storage_root")

    @storage_root.setter
    def storage_root(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_root", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_by")

    @updated_by.setter
    def updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_by", value)


@pulumi.type_token("databricks:index/catalog:Catalog")
class Catalog(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 browse_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_predictive_optimization_flag: Optional[pulumi.Input[Union['CatalogEffectivePredictiveOptimizationFlagArgs', 'CatalogEffectivePredictiveOptimizationFlagArgsDict']]] = None,
                 enable_predictive_optimization: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioning_info: Optional[pulumi.Input[Union['CatalogProvisioningInfoArgs', 'CatalogProvisioningInfoArgsDict']]] = None,
                 share_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_root: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Within a metastore, Unity Catalog provides a 3-level namespace for organizing data: Catalogs, Databases (also called Schemas), and Tables / Views.

        A `Catalog` is contained within Metastore and can contain databricks_schema. By default, Databricks creates `default` schema for every new catalog, but Pulumi plugin is removing this auto-created schema, so that resource destruction could be done in a clean way.

        > This resource can only be used with a workspace-level provider!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sandbox = databricks.Catalog("sandbox",
            name="sandbox",
            comment="this catalog is managed by terraform",
            properties={
                "purpose": "testing",
            })
        ```

        ## Related Resources

        The following resources are used in the same context:

        * get_tables data to list tables within Unity Catalog.
        * get_schemas data to list schemas within Unity Catalog.
        * get_catalogs data to list catalogs within Unity Catalog.

        ## Import

        This resource can be imported by name:

        hcl

        import {

          to = databricks_catalog.this

          id = "<name>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/catalog:Catalog this <name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: User-supplied free-form text.
        :param pulumi.Input[_builtins.str] connection_name: For Foreign Catalogs: the name of the connection to an external data source. Changes forces creation of a new resource.
        :param pulumi.Input[_builtins.str] enable_predictive_optimization: Whether predictive optimization should be enabled for this object and objects under it. Can be `ENABLE`, `DISABLE` or `INHERIT`
        :param pulumi.Input[_builtins.bool] force_destroy: Delete catalog regardless of its contents.
        :param pulumi.Input[_builtins.str] isolation_mode: Whether the catalog is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATED` or `OPEN`. Setting the catalog to `ISOLATED` will automatically allow access from the current workspace.
        :param pulumi.Input[_builtins.str] metastore_id: ID of the parent metastore.
        :param pulumi.Input[_builtins.str] name: Name of Catalog relative to parent metastore.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: For Foreign Catalogs: the name of the entity from an external data source that maps to a catalog. For example, the database name in a PostgreSQL server.
        :param pulumi.Input[_builtins.str] owner: Username/groupname/sp application_id of the catalog owner.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: Extensible Catalog properties.
        :param pulumi.Input[_builtins.str] provider_name: For Delta Sharing Catalogs: the name of the delta sharing provider. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] share_name: For Delta Sharing Catalogs: the name of the share under the share provider. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] storage_root: Managed location of the catalog. Location in cloud storage where data for managed tables will be stored. If not specified, the location will default to the metastore root location. Change forces creation of a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CatalogArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Within a metastore, Unity Catalog provides a 3-level namespace for organizing data: Catalogs, Databases (also called Schemas), and Tables / Views.

        A `Catalog` is contained within Metastore and can contain databricks_schema. By default, Databricks creates `default` schema for every new catalog, but Pulumi plugin is removing this auto-created schema, so that resource destruction could be done in a clean way.

        > This resource can only be used with a workspace-level provider!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sandbox = databricks.Catalog("sandbox",
            name="sandbox",
            comment="this catalog is managed by terraform",
            properties={
                "purpose": "testing",
            })
        ```

        ## Related Resources

        The following resources are used in the same context:

        * get_tables data to list tables within Unity Catalog.
        * get_schemas data to list schemas within Unity Catalog.
        * get_catalogs data to list catalogs within Unity Catalog.

        ## Import

        This resource can be imported by name:

        hcl

        import {

          to = databricks_catalog.this

          id = "<name>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/catalog:Catalog this <name>
        ```

        :param str resource_name: The name of the resource.
        :param CatalogArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CatalogArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 browse_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_predictive_optimization_flag: Optional[pulumi.Input[Union['CatalogEffectivePredictiveOptimizationFlagArgs', 'CatalogEffectivePredictiveOptimizationFlagArgsDict']]] = None,
                 enable_predictive_optimization: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioning_info: Optional[pulumi.Input[Union['CatalogProvisioningInfoArgs', 'CatalogProvisioningInfoArgsDict']]] = None,
                 share_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_root: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CatalogArgs.__new__(CatalogArgs)

            __props__.__dict__["browse_only"] = browse_only
            __props__.__dict__["comment"] = comment
            __props__.__dict__["connection_name"] = connection_name
            __props__.__dict__["effective_predictive_optimization_flag"] = effective_predictive_optimization_flag
            __props__.__dict__["enable_predictive_optimization"] = enable_predictive_optimization
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["isolation_mode"] = isolation_mode
            __props__.__dict__["metastore_id"] = metastore_id
            __props__.__dict__["name"] = name
            __props__.__dict__["options"] = options
            __props__.__dict__["owner"] = owner
            __props__.__dict__["properties"] = properties
            __props__.__dict__["provider_name"] = provider_name
            __props__.__dict__["provisioning_info"] = provisioning_info
            __props__.__dict__["share_name"] = share_name
            __props__.__dict__["storage_location"] = storage_location
            __props__.__dict__["storage_root"] = storage_root
            __props__.__dict__["catalog_type"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["full_name"] = None
            __props__.__dict__["securable_type"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["updated_by"] = None
        super(Catalog, __self__).__init__(
            'databricks:index/catalog:Catalog',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            browse_only: Optional[pulumi.Input[_builtins.bool]] = None,
            catalog_type: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            connection_name: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.int]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            effective_predictive_optimization_flag: Optional[pulumi.Input[Union['CatalogEffectivePredictiveOptimizationFlagArgs', 'CatalogEffectivePredictiveOptimizationFlagArgsDict']]] = None,
            enable_predictive_optimization: Optional[pulumi.Input[_builtins.str]] = None,
            force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            full_name: Optional[pulumi.Input[_builtins.str]] = None,
            isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
            metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            provider_name: Optional[pulumi.Input[_builtins.str]] = None,
            provisioning_info: Optional[pulumi.Input[Union['CatalogProvisioningInfoArgs', 'CatalogProvisioningInfoArgsDict']]] = None,
            securable_type: Optional[pulumi.Input[_builtins.str]] = None,
            share_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_location: Optional[pulumi.Input[_builtins.str]] = None,
            storage_root: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.int]] = None,
            updated_by: Optional[pulumi.Input[_builtins.str]] = None) -> 'Catalog':
        """
        Get an existing Catalog resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: User-supplied free-form text.
        :param pulumi.Input[_builtins.str] connection_name: For Foreign Catalogs: the name of the connection to an external data source. Changes forces creation of a new resource.
        :param pulumi.Input[_builtins.str] enable_predictive_optimization: Whether predictive optimization should be enabled for this object and objects under it. Can be `ENABLE`, `DISABLE` or `INHERIT`
        :param pulumi.Input[_builtins.bool] force_destroy: Delete catalog regardless of its contents.
        :param pulumi.Input[_builtins.str] isolation_mode: Whether the catalog is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATED` or `OPEN`. Setting the catalog to `ISOLATED` will automatically allow access from the current workspace.
        :param pulumi.Input[_builtins.str] metastore_id: ID of the parent metastore.
        :param pulumi.Input[_builtins.str] name: Name of Catalog relative to parent metastore.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] options: For Foreign Catalogs: the name of the entity from an external data source that maps to a catalog. For example, the database name in a PostgreSQL server.
        :param pulumi.Input[_builtins.str] owner: Username/groupname/sp application_id of the catalog owner.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: Extensible Catalog properties.
        :param pulumi.Input[_builtins.str] provider_name: For Delta Sharing Catalogs: the name of the delta sharing provider. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] share_name: For Delta Sharing Catalogs: the name of the share under the share provider. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] storage_root: Managed location of the catalog. Location in cloud storage where data for managed tables will be stored. If not specified, the location will default to the metastore root location. Change forces creation of a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CatalogState.__new__(_CatalogState)

        __props__.__dict__["browse_only"] = browse_only
        __props__.__dict__["catalog_type"] = catalog_type
        __props__.__dict__["comment"] = comment
        __props__.__dict__["connection_name"] = connection_name
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["effective_predictive_optimization_flag"] = effective_predictive_optimization_flag
        __props__.__dict__["enable_predictive_optimization"] = enable_predictive_optimization
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["full_name"] = full_name
        __props__.__dict__["isolation_mode"] = isolation_mode
        __props__.__dict__["metastore_id"] = metastore_id
        __props__.__dict__["name"] = name
        __props__.__dict__["options"] = options
        __props__.__dict__["owner"] = owner
        __props__.__dict__["properties"] = properties
        __props__.__dict__["provider_name"] = provider_name
        __props__.__dict__["provisioning_info"] = provisioning_info
        __props__.__dict__["securable_type"] = securable_type
        __props__.__dict__["share_name"] = share_name
        __props__.__dict__["storage_location"] = storage_location
        __props__.__dict__["storage_root"] = storage_root
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["updated_by"] = updated_by
        return Catalog(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="browseOnly")
    def browse_only(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "browse_only")

    @_builtins.property
    @pulumi.getter(name="catalogType")
    def catalog_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "catalog_type")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-supplied free-form text.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        For Foreign Catalogs: the name of the connection to an external data source. Changes forces creation of a new resource.
        """
        return pulumi.get(self, "connection_name")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="effectivePredictiveOptimizationFlag")
    def effective_predictive_optimization_flag(self) -> pulumi.Output['outputs.CatalogEffectivePredictiveOptimizationFlag']:
        return pulumi.get(self, "effective_predictive_optimization_flag")

    @_builtins.property
    @pulumi.getter(name="enablePredictiveOptimization")
    def enable_predictive_optimization(self) -> pulumi.Output[_builtins.str]:
        """
        Whether predictive optimization should be enabled for this object and objects under it. Can be `ENABLE`, `DISABLE` or `INHERIT`
        """
        return pulumi.get(self, "enable_predictive_optimization")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Delete catalog regardless of its contents.
        """
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter(name="fullName")
    def full_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "full_name")

    @_builtins.property
    @pulumi.getter(name="isolationMode")
    def isolation_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Whether the catalog is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATED` or `OPEN`. Setting the catalog to `ISOLATED` will automatically allow access from the current workspace.
        """
        return pulumi.get(self, "isolation_mode")

    @_builtins.property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the parent metastore.
        """
        return pulumi.get(self, "metastore_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of Catalog relative to parent metastore.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        For Foreign Catalogs: the name of the entity from an external data source that maps to a catalog. For example, the database name in a PostgreSQL server.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        Username/groupname/sp application_id of the catalog owner.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Extensible Catalog properties.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        For Delta Sharing Catalogs: the name of the delta sharing provider. Change forces creation of a new resource.
        """
        return pulumi.get(self, "provider_name")

    @_builtins.property
    @pulumi.getter(name="provisioningInfo")
    def provisioning_info(self) -> pulumi.Output[Optional['outputs.CatalogProvisioningInfo']]:
        return pulumi.get(self, "provisioning_info")

    @_builtins.property
    @pulumi.getter(name="securableType")
    def securable_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "securable_type")

    @_builtins.property
    @pulumi.getter(name="shareName")
    def share_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        For Delta Sharing Catalogs: the name of the share under the share provider. Change forces creation of a new resource.
        """
        return pulumi.get(self, "share_name")

    @_builtins.property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "storage_location")

    @_builtins.property
    @pulumi.getter(name="storageRoot")
    def storage_root(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Managed location of the catalog. Location in cloud storage where data for managed tables will be stored. If not specified, the location will default to the metastore root location. Change forces creation of a new resource.
        """
        return pulumi.get(self, "storage_root")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated_by")

