# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDatabaseSyncedDatabaseTableResult',
    'AwaitableGetDatabaseSyncedDatabaseTableResult',
    'get_database_synced_database_table',
    'get_database_synced_database_table_output',
]

@pulumi.output_type
class GetDatabaseSyncedDatabaseTableResult:
    """
    A collection of values returned by getDatabaseSyncedDatabaseTable.
    """
    def __init__(__self__, data_synchronization_status=None, database_instance_name=None, effective_database_instance_name=None, effective_logical_database_name=None, id=None, logical_database_name=None, name=None, spec=None, unity_catalog_provisioning_state=None, workspace_id=None):
        if data_synchronization_status and not isinstance(data_synchronization_status, dict):
            raise TypeError("Expected argument 'data_synchronization_status' to be a dict")
        pulumi.set(__self__, "data_synchronization_status", data_synchronization_status)
        if database_instance_name and not isinstance(database_instance_name, str):
            raise TypeError("Expected argument 'database_instance_name' to be a str")
        pulumi.set(__self__, "database_instance_name", database_instance_name)
        if effective_database_instance_name and not isinstance(effective_database_instance_name, str):
            raise TypeError("Expected argument 'effective_database_instance_name' to be a str")
        pulumi.set(__self__, "effective_database_instance_name", effective_database_instance_name)
        if effective_logical_database_name and not isinstance(effective_logical_database_name, str):
            raise TypeError("Expected argument 'effective_logical_database_name' to be a str")
        pulumi.set(__self__, "effective_logical_database_name", effective_logical_database_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if logical_database_name and not isinstance(logical_database_name, str):
            raise TypeError("Expected argument 'logical_database_name' to be a str")
        pulumi.set(__self__, "logical_database_name", logical_database_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if spec and not isinstance(spec, dict):
            raise TypeError("Expected argument 'spec' to be a dict")
        pulumi.set(__self__, "spec", spec)
        if unity_catalog_provisioning_state and not isinstance(unity_catalog_provisioning_state, str):
            raise TypeError("Expected argument 'unity_catalog_provisioning_state' to be a str")
        pulumi.set(__self__, "unity_catalog_provisioning_state", unity_catalog_provisioning_state)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="dataSynchronizationStatus")
    def data_synchronization_status(self) -> 'outputs.GetDatabaseSyncedDatabaseTableDataSynchronizationStatusResult':
        """
        (SyncedTableStatus) - Synced Table data synchronization status
        """
        return pulumi.get(self, "data_synchronization_status")

    @_builtins.property
    @pulumi.getter(name="databaseInstanceName")
    def database_instance_name(self) -> _builtins.str:
        """
        (string) - Name of the target database instance. This is required when creating synced database tables in standard catalogs.
        This is optional when creating synced database tables in registered catalogs. If this field is specified
        when creating synced database tables in registered catalogs, the database instance name MUST
        match that of the registered catalog (or the request will be rejected)
        """
        return pulumi.get(self, "database_instance_name")

    @_builtins.property
    @pulumi.getter(name="effectiveDatabaseInstanceName")
    def effective_database_instance_name(self) -> _builtins.str:
        """
        (string) - The name of the database instance that this table is registered to. This field is always returned, and for
        tables inside database catalogs is inferred database instance associated with the catalog
        """
        return pulumi.get(self, "effective_database_instance_name")

    @_builtins.property
    @pulumi.getter(name="effectiveLogicalDatabaseName")
    def effective_logical_database_name(self) -> _builtins.str:
        """
        (string) - The name of the logical database that this table is registered to
        """
        return pulumi.get(self, "effective_logical_database_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="logicalDatabaseName")
    def logical_database_name(self) -> _builtins.str:
        """
        (string) - Target Postgres database object (logical database) name for this table.
        """
        return pulumi.get(self, "logical_database_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        (string) - Full three-part (catalog, schema, table) name of the table
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.GetDatabaseSyncedDatabaseTableSpecResult']:
        """
        (SyncedTableSpec)
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter(name="unityCatalogProvisioningState")
    def unity_catalog_provisioning_state(self) -> _builtins.str:
        """
        (string) - The provisioning state of the synced table entity in Unity Catalog. This is distinct from the
        state of the data synchronization pipeline (i.e. the table may be in "ACTIVE" but the pipeline
        may be in "PROVISIONING" as it runs asynchronously). Possible values are: `ACTIVE`, `DEGRADED`, `DELETING`, `FAILED`, `PROVISIONING`, `UPDATING`
        """
        return pulumi.get(self, "unity_catalog_provisioning_state")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "workspace_id")


class AwaitableGetDatabaseSyncedDatabaseTableResult(GetDatabaseSyncedDatabaseTableResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseSyncedDatabaseTableResult(
            data_synchronization_status=self.data_synchronization_status,
            database_instance_name=self.database_instance_name,
            effective_database_instance_name=self.effective_database_instance_name,
            effective_logical_database_name=self.effective_logical_database_name,
            id=self.id,
            logical_database_name=self.logical_database_name,
            name=self.name,
            spec=self.spec,
            unity_catalog_provisioning_state=self.unity_catalog_provisioning_state,
            workspace_id=self.workspace_id)


def get_database_synced_database_table(database_instance_name: Optional[_builtins.str] = None,
                                       logical_database_name: Optional[_builtins.str] = None,
                                       name: Optional[_builtins.str] = None,
                                       spec: Optional[Union['GetDatabaseSyncedDatabaseTableSpecArgs', 'GetDatabaseSyncedDatabaseTableSpecArgsDict']] = None,
                                       workspace_id: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseSyncedDatabaseTableResult:
    """
    This data source can be used to get a single Synced Database Table.

    ## Example Usage

    Referring to a Database Instance by name:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_database_synced_database_table(name="my_database_catalog.public.synced_table")
    ```


    :param _builtins.str database_instance_name: (string) - Name of the target database instance. This is required when creating synced database tables in standard catalogs.
           This is optional when creating synced database tables in registered catalogs. If this field is specified
           when creating synced database tables in registered catalogs, the database instance name MUST
           match that of the registered catalog (or the request will be rejected)
    :param _builtins.str logical_database_name: (string) - Target Postgres database object (logical database) name for this table.
    :param _builtins.str name: Full three-part (catalog, schema, table) name of the table
    :param Union['GetDatabaseSyncedDatabaseTableSpecArgs', 'GetDatabaseSyncedDatabaseTableSpecArgsDict'] spec: (SyncedTableSpec)
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['databaseInstanceName'] = database_instance_name
    __args__['logicalDatabaseName'] = logical_database_name
    __args__['name'] = name
    __args__['spec'] = spec
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getDatabaseSyncedDatabaseTable:getDatabaseSyncedDatabaseTable', __args__, opts=opts, typ=GetDatabaseSyncedDatabaseTableResult).value

    return AwaitableGetDatabaseSyncedDatabaseTableResult(
        data_synchronization_status=pulumi.get(__ret__, 'data_synchronization_status'),
        database_instance_name=pulumi.get(__ret__, 'database_instance_name'),
        effective_database_instance_name=pulumi.get(__ret__, 'effective_database_instance_name'),
        effective_logical_database_name=pulumi.get(__ret__, 'effective_logical_database_name'),
        id=pulumi.get(__ret__, 'id'),
        logical_database_name=pulumi.get(__ret__, 'logical_database_name'),
        name=pulumi.get(__ret__, 'name'),
        spec=pulumi.get(__ret__, 'spec'),
        unity_catalog_provisioning_state=pulumi.get(__ret__, 'unity_catalog_provisioning_state'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_database_synced_database_table_output(database_instance_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              logical_database_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              name: Optional[pulumi.Input[_builtins.str]] = None,
                                              spec: Optional[pulumi.Input[Optional[Union['GetDatabaseSyncedDatabaseTableSpecArgs', 'GetDatabaseSyncedDatabaseTableSpecArgsDict']]]] = None,
                                              workspace_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseSyncedDatabaseTableResult]:
    """
    This data source can be used to get a single Synced Database Table.

    ## Example Usage

    Referring to a Database Instance by name:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_database_synced_database_table(name="my_database_catalog.public.synced_table")
    ```


    :param _builtins.str database_instance_name: (string) - Name of the target database instance. This is required when creating synced database tables in standard catalogs.
           This is optional when creating synced database tables in registered catalogs. If this field is specified
           when creating synced database tables in registered catalogs, the database instance name MUST
           match that of the registered catalog (or the request will be rejected)
    :param _builtins.str logical_database_name: (string) - Target Postgres database object (logical database) name for this table.
    :param _builtins.str name: Full three-part (catalog, schema, table) name of the table
    :param Union['GetDatabaseSyncedDatabaseTableSpecArgs', 'GetDatabaseSyncedDatabaseTableSpecArgsDict'] spec: (SyncedTableSpec)
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['databaseInstanceName'] = database_instance_name
    __args__['logicalDatabaseName'] = logical_database_name
    __args__['name'] = name
    __args__['spec'] = spec
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getDatabaseSyncedDatabaseTable:getDatabaseSyncedDatabaseTable', __args__, opts=opts, typ=GetDatabaseSyncedDatabaseTableResult)
    return __ret__.apply(lambda __response__: GetDatabaseSyncedDatabaseTableResult(
        data_synchronization_status=pulumi.get(__response__, 'data_synchronization_status'),
        database_instance_name=pulumi.get(__response__, 'database_instance_name'),
        effective_database_instance_name=pulumi.get(__response__, 'effective_database_instance_name'),
        effective_logical_database_name=pulumi.get(__response__, 'effective_logical_database_name'),
        id=pulumi.get(__response__, 'id'),
        logical_database_name=pulumi.get(__response__, 'logical_database_name'),
        name=pulumi.get(__response__, 'name'),
        spec=pulumi.get(__response__, 'spec'),
        unity_catalog_provisioning_state=pulumi.get(__response__, 'unity_catalog_provisioning_state'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
