# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetEntityTagAssignmentsResult',
    'AwaitableGetEntityTagAssignmentsResult',
    'get_entity_tag_assignments',
    'get_entity_tag_assignments_output',
]

@pulumi.output_type
class GetEntityTagAssignmentsResult:
    """
    A collection of values returned by getEntityTagAssignments.
    """
    def __init__(__self__, entity_name=None, entity_type=None, id=None, tag_assignments=None, workspace_id=None):
        if entity_name and not isinstance(entity_name, str):
            raise TypeError("Expected argument 'entity_name' to be a str")
        pulumi.set(__self__, "entity_name", entity_name)
        if entity_type and not isinstance(entity_type, str):
            raise TypeError("Expected argument 'entity_type' to be a str")
        pulumi.set(__self__, "entity_type", entity_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tag_assignments and not isinstance(tag_assignments, list):
            raise TypeError("Expected argument 'tag_assignments' to be a list")
        pulumi.set(__self__, "tag_assignments", tag_assignments)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="entityName")
    def entity_name(self) -> _builtins.str:
        """
        (string) - The fully qualified name of the entity to which the tag is assigned
        """
        return pulumi.get(self, "entity_name")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> _builtins.str:
        """
        (string) - The type of the entity to which the tag is assigned. Allowed values are: catalogs, schemas, tables, columns, volumes
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="tagAssignments")
    def tag_assignments(self) -> Sequence['outputs.GetEntityTagAssignmentsTagAssignmentResult']:
        return pulumi.get(self, "tag_assignments")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "workspace_id")


class AwaitableGetEntityTagAssignmentsResult(GetEntityTagAssignmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEntityTagAssignmentsResult(
            entity_name=self.entity_name,
            entity_type=self.entity_type,
            id=self.id,
            tag_assignments=self.tag_assignments,
            workspace_id=self.workspace_id)


def get_entity_tag_assignments(entity_name: Optional[_builtins.str] = None,
                               entity_type: Optional[_builtins.str] = None,
                               workspace_id: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEntityTagAssignmentsResult:
    """
    Use this data source to access information about an existing resource.

    :param _builtins.str entity_name: The fully qualified name of the entity to which the tag is assigned
    :param _builtins.str entity_type: The type of the entity to which the tag is assigned. Allowed values are: catalogs, schemas, tables, columns, volumes
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['entityName'] = entity_name
    __args__['entityType'] = entity_type
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getEntityTagAssignments:getEntityTagAssignments', __args__, opts=opts, typ=GetEntityTagAssignmentsResult).value

    return AwaitableGetEntityTagAssignmentsResult(
        entity_name=pulumi.get(__ret__, 'entity_name'),
        entity_type=pulumi.get(__ret__, 'entity_type'),
        id=pulumi.get(__ret__, 'id'),
        tag_assignments=pulumi.get(__ret__, 'tag_assignments'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_entity_tag_assignments_output(entity_name: Optional[pulumi.Input[_builtins.str]] = None,
                                      entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                                      workspace_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEntityTagAssignmentsResult]:
    """
    Use this data source to access information about an existing resource.

    :param _builtins.str entity_name: The fully qualified name of the entity to which the tag is assigned
    :param _builtins.str entity_type: The type of the entity to which the tag is assigned. Allowed values are: catalogs, schemas, tables, columns, volumes
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['entityName'] = entity_name
    __args__['entityType'] = entity_type
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getEntityTagAssignments:getEntityTagAssignments', __args__, opts=opts, typ=GetEntityTagAssignmentsResult)
    return __ret__.apply(lambda __response__: GetEntityTagAssignmentsResult(
        entity_name=pulumi.get(__response__, 'entity_name'),
        entity_type=pulumi.get(__response__, 'entity_type'),
        id=pulumi.get(__response__, 'id'),
        tag_assignments=pulumi.get(__response__, 'tag_assignments'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
