# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetJobResult',
    'AwaitableGetJobResult',
    'get_job',
    'get_job_output',
]

@pulumi.output_type
class GetJobResult:
    """
    A collection of values returned by getJob.
    """
    def __init__(__self__, id=None, job_id=None, job_name=None, job_settings=None, name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if job_id and not isinstance(job_id, str):
            raise TypeError("Expected argument 'job_id' to be a str")
        pulumi.set(__self__, "job_id", job_id)
        if job_name and not isinstance(job_name, str):
            raise TypeError("Expected argument 'job_name' to be a str")
        pulumi.set(__self__, "job_name", job_name)
        if job_settings and not isinstance(job_settings, dict):
            raise TypeError("Expected argument 'job_settings' to be a dict")
        pulumi.set(__self__, "job_settings", job_settings)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        the id of Job if the resource was matched by name.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> _builtins.str:
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="jobName")
    def job_name(self) -> _builtins.str:
        return pulumi.get(self, "job_name")

    @_builtins.property
    @pulumi.getter(name="jobSettings")
    def job_settings(self) -> 'outputs.GetJobJobSettingsResult':
        """
        the same fields as in databricks_job.
        """
        return pulumi.get(self, "job_settings")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        the job name of Job if the resource was matched by id.
        """
        return pulumi.get(self, "name")


class AwaitableGetJobResult(GetJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJobResult(
            id=self.id,
            job_id=self.job_id,
            job_name=self.job_name,
            job_settings=self.job_settings,
            name=self.name)


def get_job(id: Optional[_builtins.str] = None,
            job_id: Optional[_builtins.str] = None,
            job_name: Optional[_builtins.str] = None,
            job_settings: Optional[Union['GetJobJobSettingsArgs', 'GetJobJobSettingsArgsDict']] = None,
            name: Optional[_builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJobResult:
    """
    Retrieves the settings of Job by name or by id. Complements the feature of the get_jobs data source.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    Getting the existing cluster id of specific Job by name or by id:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_job(job_name="My job")
    pulumi.export("jobNumWorkers", this.job_settings.settings.new_cluster.num_workers)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * get_jobs data to get all jobs and their names from a workspace.
    * Job to manage [Databricks Jobs](https://docs.databricks.com/jobs.html) to run non-interactive code in a databricks_cluster.


    :param _builtins.str id: the id of Job if the resource was matched by name.
    :param Union['GetJobJobSettingsArgs', 'GetJobJobSettingsArgsDict'] job_settings: the same fields as in databricks_job.
    :param _builtins.str name: the job name of Job if the resource was matched by id.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['jobId'] = job_id
    __args__['jobName'] = job_name
    __args__['jobSettings'] = job_settings
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getJob:getJob', __args__, opts=opts, typ=GetJobResult).value

    return AwaitableGetJobResult(
        id=pulumi.get(__ret__, 'id'),
        job_id=pulumi.get(__ret__, 'job_id'),
        job_name=pulumi.get(__ret__, 'job_name'),
        job_settings=pulumi.get(__ret__, 'job_settings'),
        name=pulumi.get(__ret__, 'name'))
def get_job_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   job_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   job_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   job_settings: Optional[pulumi.Input[Optional[Union['GetJobJobSettingsArgs', 'GetJobJobSettingsArgsDict']]]] = None,
                   name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetJobResult]:
    """
    Retrieves the settings of Job by name or by id. Complements the feature of the get_jobs data source.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    Getting the existing cluster id of specific Job by name or by id:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_job(job_name="My job")
    pulumi.export("jobNumWorkers", this.job_settings.settings.new_cluster.num_workers)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * get_jobs data to get all jobs and their names from a workspace.
    * Job to manage [Databricks Jobs](https://docs.databricks.com/jobs.html) to run non-interactive code in a databricks_cluster.


    :param _builtins.str id: the id of Job if the resource was matched by name.
    :param Union['GetJobJobSettingsArgs', 'GetJobJobSettingsArgsDict'] job_settings: the same fields as in databricks_job.
    :param _builtins.str name: the job name of Job if the resource was matched by id.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['jobId'] = job_id
    __args__['jobName'] = job_name
    __args__['jobSettings'] = job_settings
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getJob:getJob', __args__, opts=opts, typ=GetJobResult)
    return __ret__.apply(lambda __response__: GetJobResult(
        id=pulumi.get(__response__, 'id'),
        job_id=pulumi.get(__response__, 'job_id'),
        job_name=pulumi.get(__response__, 'job_name'),
        job_settings=pulumi.get(__response__, 'job_settings'),
        name=pulumi.get(__response__, 'name')))
