# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetQualityMonitorV2Result',
    'AwaitableGetQualityMonitorV2Result',
    'get_quality_monitor_v2',
    'get_quality_monitor_v2_output',
]

@pulumi.output_type
class GetQualityMonitorV2Result:
    """
    A collection of values returned by getQualityMonitorV2.
    """
    def __init__(__self__, anomaly_detection_config=None, id=None, object_id=None, object_type=None, workspace_id=None):
        if anomaly_detection_config and not isinstance(anomaly_detection_config, dict):
            raise TypeError("Expected argument 'anomaly_detection_config' to be a dict")
        pulumi.set(__self__, "anomaly_detection_config", anomaly_detection_config)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if object_id and not isinstance(object_id, str):
            raise TypeError("Expected argument 'object_id' to be a str")
        pulumi.set(__self__, "object_id", object_id)
        if object_type and not isinstance(object_type, str):
            raise TypeError("Expected argument 'object_type' to be a str")
        pulumi.set(__self__, "object_type", object_type)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="anomalyDetectionConfig")
    def anomaly_detection_config(self) -> 'outputs.GetQualityMonitorV2AnomalyDetectionConfigResult':
        """
        (AnomalyDetectionConfig)
        """
        return pulumi.get(self, "anomaly_detection_config")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> _builtins.str:
        """
        (string) - The uuid of the request object. For example, schema id
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter(name="objectType")
    def object_type(self) -> _builtins.str:
        """
        (string) - The type of the monitored object. Can be one of the following: schema
        """
        return pulumi.get(self, "object_type")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "workspace_id")


class AwaitableGetQualityMonitorV2Result(GetQualityMonitorV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQualityMonitorV2Result(
            anomaly_detection_config=self.anomaly_detection_config,
            id=self.id,
            object_id=self.object_id,
            object_type=self.object_type,
            workspace_id=self.workspace_id)


def get_quality_monitor_v2(object_id: Optional[_builtins.str] = None,
                           object_type: Optional[_builtins.str] = None,
                           workspace_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQualityMonitorV2Result:
    """
    This data source can be used to fetch a quality monitors v2.

    > **Note** This data source can only be used with an workspace-level provider!

    ## Example Usage

    Referring to a quality monitor by uc object type (currently only support `schema`) and object id:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_schema(name="my_catalog.my_schema")
    this_get_quality_monitor_v2 = databricks.get_quality_monitor_v2(object_type="schema",
        object_id=this.schema_info.schema_id)
    ```


    :param _builtins.str object_id: The uuid of the request object. For example, schema id
    :param _builtins.str object_type: The type of the monitored object. Can be one of the following: schema
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['objectId'] = object_id
    __args__['objectType'] = object_type
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getQualityMonitorV2:getQualityMonitorV2', __args__, opts=opts, typ=GetQualityMonitorV2Result).value

    return AwaitableGetQualityMonitorV2Result(
        anomaly_detection_config=pulumi.get(__ret__, 'anomaly_detection_config'),
        id=pulumi.get(__ret__, 'id'),
        object_id=pulumi.get(__ret__, 'object_id'),
        object_type=pulumi.get(__ret__, 'object_type'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_quality_monitor_v2_output(object_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  object_type: Optional[pulumi.Input[_builtins.str]] = None,
                                  workspace_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetQualityMonitorV2Result]:
    """
    This data source can be used to fetch a quality monitors v2.

    > **Note** This data source can only be used with an workspace-level provider!

    ## Example Usage

    Referring to a quality monitor by uc object type (currently only support `schema`) and object id:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_schema(name="my_catalog.my_schema")
    this_get_quality_monitor_v2 = databricks.get_quality_monitor_v2(object_type="schema",
        object_id=this.schema_info.schema_id)
    ```


    :param _builtins.str object_id: The uuid of the request object. For example, schema id
    :param _builtins.str object_type: The type of the monitored object. Can be one of the following: schema
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['objectId'] = object_id
    __args__['objectType'] = object_type
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getQualityMonitorV2:getQualityMonitorV2', __args__, opts=opts, typ=GetQualityMonitorV2Result)
    return __ret__.apply(lambda __response__: GetQualityMonitorV2Result(
        anomaly_detection_config=pulumi.get(__response__, 'anomaly_detection_config'),
        id=pulumi.get(__response__, 'id'),
        object_id=pulumi.get(__response__, 'object_id'),
        object_type=pulumi.get(__response__, 'object_type'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
