# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetWorkspaceNetworkOptionResult',
    'AwaitableGetWorkspaceNetworkOptionResult',
    'get_workspace_network_option',
    'get_workspace_network_option_output',
]

@pulumi.output_type
class GetWorkspaceNetworkOptionResult:
    """
    A collection of values returned by getWorkspaceNetworkOption.
    """
    def __init__(__self__, id=None, network_policy_id=None, workspace_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if network_policy_id and not isinstance(network_policy_id, str):
            raise TypeError("Expected argument 'network_policy_id' to be a str")
        pulumi.set(__self__, "network_policy_id", network_policy_id)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="networkPolicyId")
    def network_policy_id(self) -> Optional[_builtins.str]:
        """
        (string) - The network policy ID to apply to the workspace. This controls the network access rules
        for all serverless compute resources in the workspace. Each workspace can only be
        linked to one policy at a time. If no policy is explicitly assigned,
        the workspace will use 'default-policy'
        """
        return pulumi.get(self, "network_policy_id")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[_builtins.str]:
        """
        (integer) - The workspace ID
        """
        return pulumi.get(self, "workspace_id")


class AwaitableGetWorkspaceNetworkOptionResult(GetWorkspaceNetworkOptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkspaceNetworkOptionResult(
            id=self.id,
            network_policy_id=self.network_policy_id,
            workspace_id=self.workspace_id)


def get_workspace_network_option(network_policy_id: Optional[_builtins.str] = None,
                                 workspace_id: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkspaceNetworkOptionResult:
    """
    This data source can be used to get a single workspace network option.

    > **Note** This data source can only be used with an account-level provider!

    ## Example Usage

    Referring to a network policy by id:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_workspace_network_option(workspace_id="9999999999999999")
    ```


    :param _builtins.str network_policy_id: (string) - The network policy ID to apply to the workspace. This controls the network access rules
           for all serverless compute resources in the workspace. Each workspace can only be
           linked to one policy at a time. If no policy is explicitly assigned,
           the workspace will use 'default-policy'
    :param _builtins.str workspace_id: The workspace ID
    """
    __args__ = dict()
    __args__['networkPolicyId'] = network_policy_id
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getWorkspaceNetworkOption:getWorkspaceNetworkOption', __args__, opts=opts, typ=GetWorkspaceNetworkOptionResult).value

    return AwaitableGetWorkspaceNetworkOptionResult(
        id=pulumi.get(__ret__, 'id'),
        network_policy_id=pulumi.get(__ret__, 'network_policy_id'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_workspace_network_option_output(network_policy_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        workspace_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkspaceNetworkOptionResult]:
    """
    This data source can be used to get a single workspace network option.

    > **Note** This data source can only be used with an account-level provider!

    ## Example Usage

    Referring to a network policy by id:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_workspace_network_option(workspace_id="9999999999999999")
    ```


    :param _builtins.str network_policy_id: (string) - The network policy ID to apply to the workspace. This controls the network access rules
           for all serverless compute resources in the workspace. Each workspace can only be
           linked to one policy at a time. If no policy is explicitly assigned,
           the workspace will use 'default-policy'
    :param _builtins.str workspace_id: The workspace ID
    """
    __args__ = dict()
    __args__['networkPolicyId'] = network_policy_id
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getWorkspaceNetworkOption:getWorkspaceNetworkOption', __args__, opts=opts, typ=GetWorkspaceNetworkOptionResult)
    return __ret__.apply(lambda __response__: GetWorkspaceNetworkOptionResult(
        id=pulumi.get(__response__, 'id'),
        network_policy_id=pulumi.get(__response__, 'network_policy_id'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
