# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServicePrincipalFederationPolicyArgs', 'ServicePrincipalFederationPolicy']

@pulumi.input_type
class ServicePrincipalFederationPolicyArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_policy: Optional[pulumi.Input['ServicePrincipalFederationPolicyOidcPolicyArgs']] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ServicePrincipalFederationPolicy resource.
        :param pulumi.Input[_builtins.str] description: Description of the federation policy
        :param pulumi.Input[_builtins.str] policy_id: (string) - The ID of the federation policy
        :param pulumi.Input[_builtins.int] service_principal_id: (integer) - The service principal ID that this federation policy applies to. Only set for service principal federation policies
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if oidc_policy is not None:
            pulumi.set(__self__, "oidc_policy", oidc_policy)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the federation policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="oidcPolicy")
    def oidc_policy(self) -> Optional[pulumi.Input['ServicePrincipalFederationPolicyOidcPolicyArgs']]:
        return pulumi.get(self, "oidc_policy")

    @oidc_policy.setter
    def oidc_policy(self, value: Optional[pulumi.Input['ServicePrincipalFederationPolicyOidcPolicyArgs']]):
        pulumi.set(self, "oidc_policy", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The ID of the federation policy
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (integer) - The service principal ID that this federation policy applies to. Only set for service principal federation policies
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "service_principal_id", value)


@pulumi.input_type
class _ServicePrincipalFederationPolicyState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_policy: Optional[pulumi.Input['ServicePrincipalFederationPolicyOidcPolicyArgs']] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.int]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServicePrincipalFederationPolicy resources.
        :param pulumi.Input[_builtins.str] create_time: (string) - Creation time of the federation policy
        :param pulumi.Input[_builtins.str] description: Description of the federation policy
        :param pulumi.Input[_builtins.str] name: (string) - Resource name for the federation policy. Example values include
               `accounts/<account-id>/federationPolicies/my-federation-policy` for Account Federation Policies, and
               `accounts/<account-id>/servicePrincipals/<service-principal-id>/federationPolicies/my-federation-policy`
               for Service Principal Federation Policies. Typically an output parameter, which does not need to be
               specified in create or update requests. If specified in a request, must match the value in the
               request URL
        :param pulumi.Input[_builtins.str] policy_id: (string) - The ID of the federation policy
        :param pulumi.Input[_builtins.int] service_principal_id: (integer) - The service principal ID that this federation policy applies to. Only set for service principal federation policies
        :param pulumi.Input[_builtins.str] uid: (string) - Unique, immutable id of the federation policy
        :param pulumi.Input[_builtins.str] update_time: (string) - Last update time of the federation policy
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oidc_policy is not None:
            pulumi.set(__self__, "oidc_policy", oidc_policy)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - Creation time of the federation policy
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the federation policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - Resource name for the federation policy. Example values include
        `accounts/<account-id>/federationPolicies/my-federation-policy` for Account Federation Policies, and
        `accounts/<account-id>/servicePrincipals/<service-principal-id>/federationPolicies/my-federation-policy`
        for Service Principal Federation Policies. Typically an output parameter, which does not need to be
        specified in create or update requests. If specified in a request, must match the value in the
        request URL
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oidcPolicy")
    def oidc_policy(self) -> Optional[pulumi.Input['ServicePrincipalFederationPolicyOidcPolicyArgs']]:
        return pulumi.get(self, "oidc_policy")

    @oidc_policy.setter
    def oidc_policy(self, value: Optional[pulumi.Input['ServicePrincipalFederationPolicyOidcPolicyArgs']]):
        pulumi.set(self, "oidc_policy", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The ID of the federation policy
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (integer) - The service principal ID that this federation policy applies to. Only set for service principal federation policies
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "service_principal_id", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - Unique, immutable id of the federation policy
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - Last update time of the federation policy
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("databricks:index/servicePrincipalFederationPolicy:ServicePrincipalFederationPolicy")
class ServicePrincipalFederationPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_policy: Optional[pulumi.Input[Union['ServicePrincipalFederationPolicyOidcPolicyArgs', 'ServicePrincipalFederationPolicyOidcPolicyArgsDict']]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Service principal federation policies allow automated workloads running outside of Databricks to access Databricks APIs without the need for Databricks secrets. Your application (workload) authenticates to Databricks as a Databricks service principal using tokens issued by the workload runtime, for example Github Actions.

        A service principal federation policy is associated with a service principal in your Databricks account, and specifies:
        * The identity provider (or issuer) from which the service principal can authenticate.
        * The workload identity (or subject) that is permitted to authenticate as the Databricks service principal.

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = "service_principal_id,policy_id"

          to = databricks_service_principal_federation_policy.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/servicePrincipalFederationPolicy:ServicePrincipalFederationPolicy databricks_service_principal_federation_policy "service_principal_id,policy_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the federation policy
        :param pulumi.Input[_builtins.str] policy_id: (string) - The ID of the federation policy
        :param pulumi.Input[_builtins.int] service_principal_id: (integer) - The service principal ID that this federation policy applies to. Only set for service principal federation policies
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ServicePrincipalFederationPolicyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Service principal federation policies allow automated workloads running outside of Databricks to access Databricks APIs without the need for Databricks secrets. Your application (workload) authenticates to Databricks as a Databricks service principal using tokens issued by the workload runtime, for example Github Actions.

        A service principal federation policy is associated with a service principal in your Databricks account, and specifies:
        * The identity provider (or issuer) from which the service principal can authenticate.
        * The workload identity (or subject) that is permitted to authenticate as the Databricks service principal.

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = "service_principal_id,policy_id"

          to = databricks_service_principal_federation_policy.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/servicePrincipalFederationPolicy:ServicePrincipalFederationPolicy databricks_service_principal_federation_policy "service_principal_id,policy_id"
        ```

        :param str resource_name: The name of the resource.
        :param ServicePrincipalFederationPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServicePrincipalFederationPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_policy: Optional[pulumi.Input[Union['ServicePrincipalFederationPolicyOidcPolicyArgs', 'ServicePrincipalFederationPolicyOidcPolicyArgsDict']]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServicePrincipalFederationPolicyArgs.__new__(ServicePrincipalFederationPolicyArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["oidc_policy"] = oidc_policy
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["service_principal_id"] = service_principal_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(ServicePrincipalFederationPolicy, __self__).__init__(
            'databricks:index/servicePrincipalFederationPolicy:ServicePrincipalFederationPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            oidc_policy: Optional[pulumi.Input[Union['ServicePrincipalFederationPolicyOidcPolicyArgs', 'ServicePrincipalFederationPolicyOidcPolicyArgsDict']]] = None,
            policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_principal_id: Optional[pulumi.Input[_builtins.int]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServicePrincipalFederationPolicy':
        """
        Get an existing ServicePrincipalFederationPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: (string) - Creation time of the federation policy
        :param pulumi.Input[_builtins.str] description: Description of the federation policy
        :param pulumi.Input[_builtins.str] name: (string) - Resource name for the federation policy. Example values include
               `accounts/<account-id>/federationPolicies/my-federation-policy` for Account Federation Policies, and
               `accounts/<account-id>/servicePrincipals/<service-principal-id>/federationPolicies/my-federation-policy`
               for Service Principal Federation Policies. Typically an output parameter, which does not need to be
               specified in create or update requests. If specified in a request, must match the value in the
               request URL
        :param pulumi.Input[_builtins.str] policy_id: (string) - The ID of the federation policy
        :param pulumi.Input[_builtins.int] service_principal_id: (integer) - The service principal ID that this federation policy applies to. Only set for service principal federation policies
        :param pulumi.Input[_builtins.str] uid: (string) - Unique, immutable id of the federation policy
        :param pulumi.Input[_builtins.str] update_time: (string) - Last update time of the federation policy
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServicePrincipalFederationPolicyState.__new__(_ServicePrincipalFederationPolicyState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["oidc_policy"] = oidc_policy
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["service_principal_id"] = service_principal_id
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return ServicePrincipalFederationPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - Creation time of the federation policy
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the federation policy
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - Resource name for the federation policy. Example values include
        `accounts/<account-id>/federationPolicies/my-federation-policy` for Account Federation Policies, and
        `accounts/<account-id>/servicePrincipals/<service-principal-id>/federationPolicies/my-federation-policy`
        for Service Principal Federation Policies. Typically an output parameter, which does not need to be
        specified in create or update requests. If specified in a request, must match the value in the
        request URL
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="oidcPolicy")
    def oidc_policy(self) -> pulumi.Output[Optional['outputs.ServicePrincipalFederationPolicyOidcPolicy']]:
        return pulumi.get(self, "oidc_policy")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The ID of the federation policy
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> pulumi.Output[_builtins.int]:
        """
        (integer) - The service principal ID that this federation policy applies to. Only set for service principal federation policies
        """
        return pulumi.get(self, "service_principal_id")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - Unique, immutable id of the federation policy
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - Last update time of the federation policy
        """
        return pulumi.get(self, "update_time")

