# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['VolumeArgs', 'Volume']

@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 catalog_name: pulumi.Input[_builtins.str],
                 schema_name: pulumi.Input[_builtins.str],
                 volume_type: pulumi.Input[_builtins.str],
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Volume resource.
        :param pulumi.Input[_builtins.str] catalog_name: Name of parent Catalog. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] schema_name: Name of parent Schema relative to parent Catalog. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] volume_type: Volume type. `EXTERNAL` or `MANAGED`. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] comment: Free-form text.
        :param pulumi.Input[_builtins.str] name: Name of the Volume
        :param pulumi.Input[_builtins.str] owner: Name of the volume owner.
        :param pulumi.Input[_builtins.str] storage_location: Path inside an External Location. Only used for `EXTERNAL` Volumes. Change forces creation of a new resource.
        """
        pulumi.set(__self__, "catalog_name", catalog_name)
        pulumi.set(__self__, "schema_name", schema_name)
        pulumi.set(__self__, "volume_type", volume_type)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if storage_location is not None:
            pulumi.set(__self__, "storage_location", storage_location)

    @_builtins.property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of parent Catalog. Change forces creation of a new resource.
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "catalog_name", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of parent Schema relative to parent Catalog. Change forces creation of a new resource.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Input[_builtins.str]:
        """
        Volume type. `EXTERNAL` or `MANAGED`. Change forces creation of a new resource.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "volume_type", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Free-form text.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Volume
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the volume owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path inside an External Location. Only used for `EXTERNAL` Volumes. Change forces creation of a new resource.
        """
        return pulumi.get(self, "storage_location")

    @storage_location.setter
    def storage_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_location", value)


@pulumi.input_type
class _VolumeState:
    def __init__(__self__, *,
                 catalog_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_path: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Volume resources.
        :param pulumi.Input[_builtins.str] catalog_name: Name of parent Catalog. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] comment: Free-form text.
        :param pulumi.Input[_builtins.str] name: Name of the Volume
        :param pulumi.Input[_builtins.str] owner: Name of the volume owner.
        :param pulumi.Input[_builtins.str] schema_name: Name of parent Schema relative to parent Catalog. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] storage_location: Path inside an External Location. Only used for `EXTERNAL` Volumes. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] volume_path: base file path for this Unity Catalog Volume in form of `/Volumes/<catalog>/<schema>/<name>`.
        :param pulumi.Input[_builtins.str] volume_type: Volume type. `EXTERNAL` or `MANAGED`. Change forces creation of a new resource.
        """
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if storage_location is not None:
            pulumi.set(__self__, "storage_location", storage_location)
        if volume_path is not None:
            pulumi.set(__self__, "volume_path", volume_path)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of parent Catalog. Change forces creation of a new resource.
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "catalog_name", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Free-form text.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Volume
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the volume owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of parent Schema relative to parent Catalog. Change forces creation of a new resource.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @_builtins.property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path inside an External Location. Only used for `EXTERNAL` Volumes. Change forces creation of a new resource.
        """
        return pulumi.get(self, "storage_location")

    @storage_location.setter
    def storage_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_location", value)

    @_builtins.property
    @pulumi.getter(name="volumePath")
    def volume_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        base file path for this Unity Catalog Volume in form of `/Volumes/<catalog>/<schema>/<name>`.
        """
        return pulumi.get(self, "volume_path")

    @volume_path.setter
    def volume_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_path", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Volume type. `EXTERNAL` or `MANAGED`. Change forces creation of a new resource.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.type_token("databricks:index/volume:Volume")
class Volume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Volumes are Unity Catalog objects representing a logical volume of storage in a cloud object storage location. Volumes provide capabilities for accessing, storing, governing, and organizing files. While tables provide governance over tabular datasets, volumes add governance over non-tabular datasets. You can use volumes to store and access files in any format, including structured, semi-structured, and unstructured data.

        > This resource can only be used with a workspace-level provider!

        A volume resides in the third layer of Unity Catalog's three-level namespace. Volumes are siblings to tables, views, and other objects organized under a schema in Unity Catalog.

        A volume can be **managed** or **external**.

        A **managed volume** is a Unity Catalog-governed storage volume created within the default storage location of the containing schema. Managed volumes allow the creation of governed storage for working with files without the overhead of external locations and storage credentials. You do not need to specify a location when creating a managed volume, and all file access for data in managed volumes is through paths managed by Unity Catalog.

        An **external volume** is a Unity Catalog-governed storage volume registered against a directory within an external location.

        A volume can be referenced using its identifier: ```<catalogName>.<schemaName>.<volumeName>```, where:

        * ```<catalogName>```: The name of the catalog containing the Volume.
        * ```<schemaName>```: The name of the schema containing the Volume.
        * ```<volumeName>```: The name of the Volume. It identifies the volume object.

        The path to access files in volumes uses the following format:

        ```/Volumes/<catalog>/<schema>/<volume>/<path>/<file_name>```

        Databricks also supports an optional ```dbfs:/``` scheme, so the following path also works:

        ```dbfs:/Volumes/<catalog>/<schema>/<volume>/<path>/<file_name>```

        This resource manages Volumes in Unity Catalog.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sandbox = databricks.Catalog("sandbox",
            name="sandbox",
            comment="this catalog is managed by terraform",
            properties={
                "purpose": "testing",
            })
        things = databricks.Schema("things",
            catalog_name=sandbox.name,
            name="things",
            comment="this schema is managed by terraform",
            properties={
                "kind": "various",
            })
        external = databricks.StorageCredential("external",
            name="creds",
            aws_iam_role={
                "role_arn": external_data_access["arn"],
            })
        some = databricks.ExternalLocation("some",
            name="external_location",
            url=f"s3://{external_aws_s3_bucket['id']}/some",
            credential_name=external.name)
        this = databricks.Volume("this",
            name="quickstart_volume",
            catalog_name=sandbox.name,
            schema_name=things.name,
            volume_type="EXTERNAL",
            storage_location=some.url,
            comment="this volume is managed by terraform")
        ```

        ## Import

        This resource can be imported by `full_name` which is the 3-level Volume identifier: `<catalog>.<schema>.<name>`

        hcl

        import {

          to = databricks_volume.this

          id = "<catalog_name>.<schema_name>.<name>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/volume:Volume this <catalog_name>.<schema_name>.<name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog_name: Name of parent Catalog. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] comment: Free-form text.
        :param pulumi.Input[_builtins.str] name: Name of the Volume
        :param pulumi.Input[_builtins.str] owner: Name of the volume owner.
        :param pulumi.Input[_builtins.str] schema_name: Name of parent Schema relative to parent Catalog. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] storage_location: Path inside an External Location. Only used for `EXTERNAL` Volumes. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] volume_type: Volume type. `EXTERNAL` or `MANAGED`. Change forces creation of a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Volumes are Unity Catalog objects representing a logical volume of storage in a cloud object storage location. Volumes provide capabilities for accessing, storing, governing, and organizing files. While tables provide governance over tabular datasets, volumes add governance over non-tabular datasets. You can use volumes to store and access files in any format, including structured, semi-structured, and unstructured data.

        > This resource can only be used with a workspace-level provider!

        A volume resides in the third layer of Unity Catalog's three-level namespace. Volumes are siblings to tables, views, and other objects organized under a schema in Unity Catalog.

        A volume can be **managed** or **external**.

        A **managed volume** is a Unity Catalog-governed storage volume created within the default storage location of the containing schema. Managed volumes allow the creation of governed storage for working with files without the overhead of external locations and storage credentials. You do not need to specify a location when creating a managed volume, and all file access for data in managed volumes is through paths managed by Unity Catalog.

        An **external volume** is a Unity Catalog-governed storage volume registered against a directory within an external location.

        A volume can be referenced using its identifier: ```<catalogName>.<schemaName>.<volumeName>```, where:

        * ```<catalogName>```: The name of the catalog containing the Volume.
        * ```<schemaName>```: The name of the schema containing the Volume.
        * ```<volumeName>```: The name of the Volume. It identifies the volume object.

        The path to access files in volumes uses the following format:

        ```/Volumes/<catalog>/<schema>/<volume>/<path>/<file_name>```

        Databricks also supports an optional ```dbfs:/``` scheme, so the following path also works:

        ```dbfs:/Volumes/<catalog>/<schema>/<volume>/<path>/<file_name>```

        This resource manages Volumes in Unity Catalog.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        sandbox = databricks.Catalog("sandbox",
            name="sandbox",
            comment="this catalog is managed by terraform",
            properties={
                "purpose": "testing",
            })
        things = databricks.Schema("things",
            catalog_name=sandbox.name,
            name="things",
            comment="this schema is managed by terraform",
            properties={
                "kind": "various",
            })
        external = databricks.StorageCredential("external",
            name="creds",
            aws_iam_role={
                "role_arn": external_data_access["arn"],
            })
        some = databricks.ExternalLocation("some",
            name="external_location",
            url=f"s3://{external_aws_s3_bucket['id']}/some",
            credential_name=external.name)
        this = databricks.Volume("this",
            name="quickstart_volume",
            catalog_name=sandbox.name,
            schema_name=things.name,
            volume_type="EXTERNAL",
            storage_location=some.url,
            comment="this volume is managed by terraform")
        ```

        ## Import

        This resource can be imported by `full_name` which is the 3-level Volume identifier: `<catalog>.<schema>.<name>`

        hcl

        import {

          to = databricks_volume.this

          id = "<catalog_name>.<schema_name>.<name>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/volume:Volume this <catalog_name>.<schema_name>.<name>
        ```

        :param str resource_name: The name of the resource.
        :param VolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_name: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeArgs.__new__(VolumeArgs)

            if catalog_name is None and not opts.urn:
                raise TypeError("Missing required property 'catalog_name'")
            __props__.__dict__["catalog_name"] = catalog_name
            __props__.__dict__["comment"] = comment
            __props__.__dict__["name"] = name
            __props__.__dict__["owner"] = owner
            if schema_name is None and not opts.urn:
                raise TypeError("Missing required property 'schema_name'")
            __props__.__dict__["schema_name"] = schema_name
            __props__.__dict__["storage_location"] = storage_location
            if volume_type is None and not opts.urn:
                raise TypeError("Missing required property 'volume_type'")
            __props__.__dict__["volume_type"] = volume_type
            __props__.__dict__["volume_path"] = None
        super(Volume, __self__).__init__(
            'databricks:index/volume:Volume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            catalog_name: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            schema_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_location: Optional[pulumi.Input[_builtins.str]] = None,
            volume_path: Optional[pulumi.Input[_builtins.str]] = None,
            volume_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Volume':
        """
        Get an existing Volume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog_name: Name of parent Catalog. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] comment: Free-form text.
        :param pulumi.Input[_builtins.str] name: Name of the Volume
        :param pulumi.Input[_builtins.str] owner: Name of the volume owner.
        :param pulumi.Input[_builtins.str] schema_name: Name of parent Schema relative to parent Catalog. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] storage_location: Path inside an External Location. Only used for `EXTERNAL` Volumes. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] volume_path: base file path for this Unity Catalog Volume in form of `/Volumes/<catalog>/<schema>/<name>`.
        :param pulumi.Input[_builtins.str] volume_type: Volume type. `EXTERNAL` or `MANAGED`. Change forces creation of a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeState.__new__(_VolumeState)

        __props__.__dict__["catalog_name"] = catalog_name
        __props__.__dict__["comment"] = comment
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["storage_location"] = storage_location
        __props__.__dict__["volume_path"] = volume_path
        __props__.__dict__["volume_type"] = volume_type
        return Volume(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of parent Catalog. Change forces creation of a new resource.
        """
        return pulumi.get(self, "catalog_name")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Free-form text.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Volume
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the volume owner.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of parent Schema relative to parent Catalog. Change forces creation of a new resource.
        """
        return pulumi.get(self, "schema_name")

    @_builtins.property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path inside an External Location. Only used for `EXTERNAL` Volumes. Change forces creation of a new resource.
        """
        return pulumi.get(self, "storage_location")

    @_builtins.property
    @pulumi.getter(name="volumePath")
    def volume_path(self) -> pulumi.Output[_builtins.str]:
        """
        base file path for this Unity Catalog Volume in form of `/Volumes/<catalog>/<schema>/<name>`.
        """
        return pulumi.get(self, "volume_path")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[_builtins.str]:
        """
        Volume type. `EXTERNAL` or `MANAGED`. Change forces creation of a new resource.
        """
        return pulumi.get(self, "volume_type")

