# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['WorkspaceFileArgs', 'WorkspaceFile']

@pulumi.input_type
class WorkspaceFileArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[_builtins.str],
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 md5: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.int]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspaceFile resource.
        :param pulumi.Input[_builtins.str] path: The absolute path of the workspace file, beginning with "/", e.g. "/Demo".
        :param pulumi.Input[_builtins.str] content_base64: The base64-encoded file content. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances, like creating a workspace file with configuration properties for a data pipeline.
        :param pulumi.Input[_builtins.int] object_id: Unique identifier for a workspace file
        :param pulumi.Input[_builtins.str] source: Path to file on local filesystem. Conflicts with `content_base64`.
        """
        pulumi.set(__self__, "path", path)
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if md5 is not None:
            pulumi.set(__self__, "md5", md5)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        The absolute path of the workspace file, beginning with "/", e.g. "/Demo".
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded file content. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances, like creating a workspace file with configuration properties for a data pipeline.
        """
        return pulumi.get(self, "content_base64")

    @content_base64.setter
    def content_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_base64", value)

    @_builtins.property
    @pulumi.getter
    def md5(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "md5")

    @md5.setter
    def md5(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "md5", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier for a workspace file
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to file on local filesystem. Conflicts with `content_base64`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class _WorkspaceFileState:
    def __init__(__self__, *,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 md5: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceFile resources.
        :param pulumi.Input[_builtins.str] content_base64: The base64-encoded file content. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances, like creating a workspace file with configuration properties for a data pipeline.
        :param pulumi.Input[_builtins.int] object_id: Unique identifier for a workspace file
        :param pulumi.Input[_builtins.str] path: The absolute path of the workspace file, beginning with "/", e.g. "/Demo".
        :param pulumi.Input[_builtins.str] source: Path to file on local filesystem. Conflicts with `content_base64`.
        :param pulumi.Input[_builtins.str] url: Routable URL of the workspace file
        :param pulumi.Input[_builtins.str] workspace_path: path on Workspace File System (WSFS) in form of `/Workspace` + `path`
        """
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if md5 is not None:
            pulumi.set(__self__, "md5", md5)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if workspace_path is not None:
            pulumi.set(__self__, "workspace_path", workspace_path)

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded file content. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances, like creating a workspace file with configuration properties for a data pipeline.
        """
        return pulumi.get(self, "content_base64")

    @content_base64.setter
    def content_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_base64", value)

    @_builtins.property
    @pulumi.getter
    def md5(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "md5")

    @md5.setter
    def md5(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "md5", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier for a workspace file
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The absolute path of the workspace file, beginning with "/", e.g. "/Demo".
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to file on local filesystem. Conflicts with `content_base64`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Routable URL of the workspace file
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="workspacePath")
    def workspace_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        path on Workspace File System (WSFS) in form of `/Workspace` + `path`
        """
        return pulumi.get(self, "workspace_path")

    @workspace_path.setter
    def workspace_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_path", value)


@pulumi.type_token("databricks:index/workspaceFile:WorkspaceFile")
class WorkspaceFile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 md5: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to manage [Databricks Workspace Files](https://docs.databricks.com/files/workspace.html).

        > This resource can only be used with a workspace-level provider!

        ## Import

        The workspace file resource can be imported using workspace file path

        hcl

        import {

          to = databricks_workspace_file.this

          id = "/path/to/file"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/workspaceFile:WorkspaceFile this /path/to/file
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content_base64: The base64-encoded file content. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances, like creating a workspace file with configuration properties for a data pipeline.
        :param pulumi.Input[_builtins.int] object_id: Unique identifier for a workspace file
        :param pulumi.Input[_builtins.str] path: The absolute path of the workspace file, beginning with "/", e.g. "/Demo".
        :param pulumi.Input[_builtins.str] source: Path to file on local filesystem. Conflicts with `content_base64`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceFileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to manage [Databricks Workspace Files](https://docs.databricks.com/files/workspace.html).

        > This resource can only be used with a workspace-level provider!

        ## Import

        The workspace file resource can be imported using workspace file path

        hcl

        import {

          to = databricks_workspace_file.this

          id = "/path/to/file"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/workspaceFile:WorkspaceFile this /path/to/file
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceFileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceFileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 md5: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceFileArgs.__new__(WorkspaceFileArgs)

            __props__.__dict__["content_base64"] = content_base64
            __props__.__dict__["md5"] = md5
            __props__.__dict__["object_id"] = object_id
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["source"] = source
            __props__.__dict__["url"] = None
            __props__.__dict__["workspace_path"] = None
        super(WorkspaceFile, __self__).__init__(
            'databricks:index/workspaceFile:WorkspaceFile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content_base64: Optional[pulumi.Input[_builtins.str]] = None,
            md5: Optional[pulumi.Input[_builtins.str]] = None,
            object_id: Optional[pulumi.Input[_builtins.int]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_path: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspaceFile':
        """
        Get an existing WorkspaceFile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content_base64: The base64-encoded file content. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances, like creating a workspace file with configuration properties for a data pipeline.
        :param pulumi.Input[_builtins.int] object_id: Unique identifier for a workspace file
        :param pulumi.Input[_builtins.str] path: The absolute path of the workspace file, beginning with "/", e.g. "/Demo".
        :param pulumi.Input[_builtins.str] source: Path to file on local filesystem. Conflicts with `content_base64`.
        :param pulumi.Input[_builtins.str] url: Routable URL of the workspace file
        :param pulumi.Input[_builtins.str] workspace_path: path on Workspace File System (WSFS) in form of `/Workspace` + `path`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceFileState.__new__(_WorkspaceFileState)

        __props__.__dict__["content_base64"] = content_base64
        __props__.__dict__["md5"] = md5
        __props__.__dict__["object_id"] = object_id
        __props__.__dict__["path"] = path
        __props__.__dict__["source"] = source
        __props__.__dict__["url"] = url
        __props__.__dict__["workspace_path"] = workspace_path
        return WorkspaceFile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The base64-encoded file content. Conflicts with `source`. Use of `content_base64` is discouraged, as it's increasing memory footprint of Pulumi state and should only be used in exceptional circumstances, like creating a workspace file with configuration properties for a data pipeline.
        """
        return pulumi.get(self, "content_base64")

    @_builtins.property
    @pulumi.getter
    def md5(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "md5")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[_builtins.int]:
        """
        Unique identifier for a workspace file
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[_builtins.str]:
        """
        The absolute path of the workspace file, beginning with "/", e.g. "/Demo".
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path to file on local filesystem. Conflicts with `content_base64`.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        Routable URL of the workspace file
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="workspacePath")
    def workspace_path(self) -> pulumi.Output[_builtins.str]:
        """
        path on Workspace File System (WSFS) in form of `/Workspace` + `path`
        """
        return pulumi.get(self, "workspace_path")

