# Generated by Django 4.2.24 on 2025-09-21 19:05

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='IndicatorSet',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort', models.BigIntegerField(null=True, verbose_name='序号')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('modify_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('disabled', models.BooleanField(default=False, verbose_name='禁用')),
                ('saved', models.BooleanField(default=False, verbose_name='已保存')),
                ('pid', models.IntegerField(default=0, verbose_name='父节点')),
                ('isLeaf', models.BooleanField(default=False, verbose_name='叶子节点')),
                ('icon', models.CharField(max_length=255, null=True, verbose_name='图标')),
                ('name', models.CharField(max_length=100, null=True)),
            ],
            options={
                'verbose_name': '指标集',
            },
        ),
        migrations.CreateModel(
            name='Meta',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort', models.BigIntegerField(null=True, verbose_name='序号')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('modify_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('disabled', models.BooleanField(default=False, verbose_name='禁用')),
                ('saved', models.BooleanField(default=False, verbose_name='已保存')),
                ('db', models.CharField(max_length=100, null=True, verbose_name='数据库')),
                ('entity', models.CharField(max_length=100, null=True, verbose_name='数据源')),
                ('name', models.CharField(max_length=50, null=True, verbose_name='实体别名')),
                ('tree', models.BooleanField(default=False, verbose_name='是否树形')),
            ],
            options={
                'verbose_name': '数据实体',
                'unique_together': {('db', 'entity')},
            },
        ),
        migrations.CreateModel(
            name='MetaFieldTool',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort', models.BigIntegerField(null=True, verbose_name='序号')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('modify_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('disabled', models.BooleanField(default=False, verbose_name='禁用')),
                ('saved', models.BooleanField(default=False, verbose_name='已保存')),
                ('pid', models.IntegerField(default=0, verbose_name='父节点')),
                ('isLeaf', models.BooleanField(default=False, verbose_name='叶子节点')),
                ('icon', models.CharField(max_length=255, null=True, verbose_name='图标')),
                ('name', models.CharField(max_length=255, null=True, verbose_name='名称')),
                ('code', models.CharField(max_length=100, null=True, unique=True, verbose_name='代码')),
                ('align', models.CharField(max_length=10, null=True, verbose_name='对齐方式')),
            ],
            options={
                'verbose_name': '元数据字段工具',
            },
        ),
        migrations.CreateModel(
            name='MetaViewDefault',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort', models.BigIntegerField(null=True, verbose_name='序号')),
                ('name', models.CharField(max_length=50, null=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('modify_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('disabled', models.BooleanField(default=False, verbose_name='禁用')),
                ('saved', models.BooleanField(default=False, verbose_name='已保存')),
            ],
            options={
                'verbose_name': '元数据字段类型',
            },
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort', models.BigIntegerField(null=True, verbose_name='序号')),
                ('name', models.CharField(max_length=50, null=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('modify_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('disabled', models.BooleanField(default=False, verbose_name='禁用')),
                ('saved', models.BooleanField(default=False, verbose_name='已保存')),
                ('duty', models.TextField(null=True, verbose_name='职责描述')),
            ],
            options={
                'verbose_name': '角色',
            },
        ),
        migrations.CreateModel(
            name='Valar',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort', models.BigIntegerField(null=True, verbose_name='序号')),
                ('name', models.CharField(max_length=50, null=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('modify_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('disabled', models.BooleanField(default=False, verbose_name='禁用')),
                ('saved', models.BooleanField(default=False, verbose_name='已保存')),
                ('text_field', models.TextField(null=True, verbose_name='Text Field')),
                ('boolean_field', models.BooleanField(null=True, verbose_name='Boolean Field')),
                ('integer_field', models.IntegerField(null=True, verbose_name='Integer Field')),
                ('float_field', models.FloatField(null=True, verbose_name='Float Field')),
                ('date_field', models.DateField(null=True, verbose_name='Date Field')),
                ('datetime_field', models.DateTimeField(null=True, verbose_name='Datetime Field')),
                ('time_field', models.TimeField(null=True, verbose_name='Time Field')),
                ('json_field', models.JSONField(null=True, verbose_name='Json Field')),
                ('file', models.FileField(null=True, upload_to='', verbose_name='File Field')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Voo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort', models.BigIntegerField(null=True, verbose_name='序号')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('modify_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('disabled', models.BooleanField(default=False, verbose_name='禁用')),
                ('saved', models.BooleanField(default=False, verbose_name='已保存')),
                ('name', models.CharField(max_length=100, null=True, verbose_name='Name')),
                ('valar', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, to='valar.valar', verbose_name='Valar')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Vmo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort', models.BigIntegerField(null=True, verbose_name='序号')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('modify_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('disabled', models.BooleanField(default=False, verbose_name='禁用')),
                ('saved', models.BooleanField(default=False, verbose_name='已保存')),
                ('name', models.CharField(max_length=100, null=True, verbose_name='Name')),
                ('valar', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='valar.valar', verbose_name='Valar')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Vmm',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort', models.BigIntegerField(null=True, verbose_name='序号')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('modify_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('disabled', models.BooleanField(default=False, verbose_name='禁用')),
                ('saved', models.BooleanField(default=False, verbose_name='已保存')),
                ('pid', models.IntegerField(default=0, verbose_name='父节点')),
                ('isLeaf', models.BooleanField(default=False, verbose_name='叶子节点')),
                ('icon', models.CharField(max_length=255, null=True, verbose_name='图标')),
                ('name', models.CharField(max_length=100, null=True, verbose_name='name')),
                ('valars', models.ManyToManyField(to='valar.valar', verbose_name='valars')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MetaView',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort', models.BigIntegerField(null=True, verbose_name='序号')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('modify_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('disabled', models.BooleanField(default=False, verbose_name='禁用')),
                ('saved', models.BooleanField(default=False, verbose_name='已保存')),
                ('property', models.JSONField(default=dict, verbose_name='属性')),
                ('code', models.CharField(default='default ', max_length=50, verbose_name='类视图')),
                ('name', models.CharField(max_length=50, null=True, verbose_name='视图名称')),
                ('lock', models.BooleanField(default=False, verbose_name='锁定元数据')),
                ('enable', models.BooleanField(default=True, verbose_name='是否启用')),
                ('form_width', models.IntegerField(null=True, verbose_name='表单宽度')),
                ('form_height', models.IntegerField(null=True, verbose_name='表单高度')),
                ('table_width', models.IntegerField(null=True, verbose_name='表格宽度')),
                ('table_height', models.IntegerField(null=True, verbose_name='表格高度')),
                ('allow_search', models.BooleanField(default=True, verbose_name='检索功能')),
                ('allow_order', models.BooleanField(default=True, verbose_name='排序功能')),
                ('allow_insert', models.BooleanField(default=True, verbose_name='新增功能')),
                ('allow_edit', models.BooleanField(default=True, verbose_name='编辑功能')),
                ('allow_edit_on_form', models.BooleanField(default=True, verbose_name='表单编辑')),
                ('allow_edit_on_cell', models.BooleanField(default=True, verbose_name='表内编辑')),
                ('allow_edit_on_sort', models.BooleanField(default=True, verbose_name='移动功能')),
                ('allow_remove', models.BooleanField(default=True, verbose_name='删除功能')),
                ('allow_download', models.BooleanField(default=True, verbose_name='下载功能')),
                ('allow_upload', models.BooleanField(default=True, verbose_name='上传功能')),
                ('meta', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='valar.meta', verbose_name='元数据')),
            ],
            options={
                'verbose_name': '数据视图',
                'unique_together': {('meta', 'code')},
            },
        ),
        migrations.CreateModel(
            name='MetaFieldDomain',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort', models.BigIntegerField(null=True, verbose_name='序号')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('modify_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('disabled', models.BooleanField(default=False, verbose_name='禁用')),
                ('saved', models.BooleanField(default=False, verbose_name='已保存')),
                ('name', models.CharField(max_length=255, null=True, unique=True, verbose_name='名称')),
                ('default', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='valar.metafieldtool', verbose_name='默认工具')),
                ('tools', models.ManyToManyField(to='valar.metafieldtool', verbose_name='工具集')),
            ],
            options={
                'verbose_name': '元数据字段类型',
            },
        ),
        migrations.CreateModel(
            name='MetaField',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort', models.BigIntegerField(null=True, verbose_name='序号')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('modify_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('saved', models.BooleanField(default=False, verbose_name='已保存')),
                ('prop', models.CharField(max_length=100, verbose_name='字段名称')),
                ('label', models.CharField(max_length=100, verbose_name='字段标签')),
                ('name', models.CharField(max_length=100, verbose_name='字段别名')),
                ('domain', models.CharField(max_length=100, verbose_name='字段类型')),
                ('tool', models.CharField(default='default', max_length=100, verbose_name='工具组件')),
                ('refer', models.JSONField(default=dict, verbose_name='索引')),
                ('format', models.JSONField(default=dict, verbose_name='格式')),
                ('disabled', models.BooleanField(default=False, verbose_name='禁用')),
                ('not_null', models.BooleanField(default=False, verbose_name='不为空')),
                ('allow_edit', models.BooleanField(default=True, verbose_name='可编辑')),
                ('allow_order', models.BooleanField(default=True, verbose_name='可排序')),
                ('allow_search', models.BooleanField(default=True, verbose_name='可搜索')),
                ('allow_download', models.BooleanField(default=True, verbose_name='可下载')),
                ('allow_upload', models.BooleanField(default=True, verbose_name='可上传')),
                ('allow_update', models.BooleanField(default=True, verbose_name='可更新')),
                ('unit', models.CharField(max_length=55, null=True, verbose_name='单位符')),
                ('column_width', models.FloatField(default=0, verbose_name='表头宽度')),
                ('align', models.CharField(max_length=55, null=True, verbose_name='对齐方式')),
                ('fixed', models.CharField(max_length=100, null=True, verbose_name='固定位置')),
                ('header_color', models.CharField(max_length=55, null=True, verbose_name='表头颜色')),
                ('cell_color', models.CharField(max_length=55, null=True, verbose_name='单元颜色')),
                ('edit_on_table', models.BooleanField(default=True, verbose_name='表格编辑')),
                ('hide_on_table', models.BooleanField(default=False, verbose_name='表内隐藏')),
                ('span', models.IntegerField(default=0, verbose_name='表单占位')),
                ('hide_on_form', models.BooleanField(default=False, verbose_name='表单隐藏')),
                ('hide_on_form_edit', models.BooleanField(default=False, verbose_name='编辑隐藏')),
                ('hide_on_form_insert', models.BooleanField(default=False, verbose_name='新增隐藏')),
                ('hide_on_form_branch', models.BooleanField(default=False, verbose_name='分支隐藏')),
                ('hide_on_form_leaf', models.BooleanField(default=False, verbose_name='叶子隐藏')),
                ('view', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='valar.metaview', verbose_name='数据视图')),
            ],
            options={
                'verbose_name': '视图字段',
            },
        ),
        migrations.CreateModel(
            name='Indicator',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort', models.BigIntegerField(null=True, verbose_name='序号')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('modify_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('disabled', models.BooleanField(default=False, verbose_name='禁用')),
                ('saved', models.BooleanField(default=False, verbose_name='已保存')),
                ('domain', models.CharField(max_length=100, null=True, verbose_name='domain')),
                ('category', models.CharField(max_length=100, null=True, verbose_name='category')),
                ('name', models.CharField(max_length=100, null=True, verbose_name='名称')),
                ('frequency', models.CharField(max_length=100, null=True, verbose_name='频度')),
                ('scope', models.CharField(max_length=100, null=True, verbose_name='尺度')),
                ('unit', models.CharField(max_length=100, null=True, verbose_name='单位')),
                ('object_id', models.CharField(max_length=100, null=True, verbose_name='ObjectId')),
                ('file', models.FileField(null=True, upload_to='', verbose_name='数据文件')),
                ('set', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='valar.indicatorset', verbose_name='指标集')),
            ],
            options={
                'verbose_name': '指标项',
            },
        ),
        migrations.CreateModel(
            name='Account',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort', models.BigIntegerField(null=True, verbose_name='序号')),
                ('name', models.CharField(max_length=50, null=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('modify_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('disabled', models.BooleanField(default=False, verbose_name='禁用')),
                ('saved', models.BooleanField(default=False, verbose_name='已保存')),
                ('username', models.CharField(max_length=255, null=True, unique=True, verbose_name='账号')),
                ('password', models.CharField(max_length=255, null=True, verbose_name='密码')),
                ('email', models.CharField(max_length=255, null=True, unique=True, verbose_name='邮箱')),
                ('is_admin', models.BooleanField(default=False, verbose_name='超级管理员')),
                ('is_active', models.BooleanField(default=False, verbose_name='激活状态')),
                ('token', models.CharField(max_length=255, null=True, verbose_name='Token')),
                ('roles', models.ManyToManyField(to='valar.role')),
            ],
            options={
                'verbose_name': '账户信息',
            },
        ),
        migrations.CreateModel(
            name='Menu',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort', models.BigIntegerField(null=True, verbose_name='序号')),
                ('name', models.CharField(max_length=50, null=True)),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('modify_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('disabled', models.BooleanField(default=False, verbose_name='禁用')),
                ('saved', models.BooleanField(default=False, verbose_name='已保存')),
                ('pid', models.IntegerField(default=0, verbose_name='父节点')),
                ('isLeaf', models.BooleanField(default=False, verbose_name='叶子节点')),
                ('icon', models.CharField(max_length=255, null=True, verbose_name='图标')),
                ('scope', models.CharField(max_length=100, null=True, verbose_name='域')),
                ('path', models.CharField(max_length=255, null=True, verbose_name='地址')),
                ('is_admin', models.BooleanField(default=False, null=True, verbose_name='超管权限')),
                ('is_auth', models.BooleanField(default=False, null=True, verbose_name='需要登录')),
                ('roles', models.ManyToManyField(to='valar.role')),
            ],
            options={
                'verbose_name': '菜单',
                'unique_together': {('scope', 'path')},
            },
        ),
    ]
