from xares.task import TaskConfig


def fluentspeechcommands_config(encoder) -> TaskConfig:
    data_key = "transcription"
    class_label_maps = {
        "Change language": 0,
        "Resume": 1,
        "Turn the lights on": 2,
        "Switch on the lights": 3,
        "Switch off the lights": 4,
        "Volume up": 5,
        "Turn the volume up": 6,
        "Turn the volume down": 7,
        "Turn up the temperature": 8,
        "Turn the heat up": 9,
        "Turn down the temperature": 10,
        "Turn the temperature down": 11,
        "Turn down the heat": 12,
        "Turn the heat down": 13,
        "Turn off the music": 14,
        "Stop the music": 15,
        "Put on the music": 16,
        "Play the music": 17,
        "Start the music": 18,
        "Turn on the lamp": 19,
        "Switch on the lamp": 20,
        "Lamp on": 21,
        "Turn off the lamp": 22,
        "Turn the lamp off": 23,
        "Lamp off": 24,
        "Turn on the kitchen lights": 25,
        "Switch on the kitchen lights": 26,
        "Turn the lights on in the kitchen": 27,
        "Switch on the lights in the kitchen": 28,
        "Lights on in the kitchen": 29,
        "Kitchen lights on": 30,
        "Switch the kitchen lights on": 31,
        "Turn the kitchen lights on": 32,
        "Turn on the lights in the bedroom": 33,
        "Switch on the lights in the bedroom": 34,
        "Turn on the washroom lights": 35,
        "Turn the washroom lights on": 36,
        "Switch on the washroom lights": 37,
        "Lights on in the washroom": 38,
        "Washroom lights on": 39,
        "Turn on the bathroom lights": 40,
        "Turn the bathroom lights on": 41,
        "Switch on the bathroom lights": 42,
        "Lights on in the bathroom": 43,
        "Bathroom lights on": 44,
        "Switch the lights off": 45,
        "Turn the lights off in the kitchen": 46,
        "Switch off the lights in the kitchen": 47,
        "Switch the lights off in the kitchen": 48,
        "Kitchen lights off": 49,
        "Turn the bedroom lights off": 50,
        "Switch the bedroom lights off": 51,
        "Bedroom lights off": 52,
        "Switch off the washroom lights": 53,
        "Lights off in the washroom": 54,
        "Washroom lights off": 55,
        "Turn it up": 56,
        "Volume max": 57,
        "Louder please": 58,
        "Increase the volume": 59,
        "Increase the sound volume": 60,
        "I need volume": 61,
        "Louder phone": 62,
        "I need to hear this, increase the volume": 63,
        "I couldn't hear anything, turn up the volume": 64,
        "This video sound is too low, turn up the volume": 65,
        "Turn sound down": 66,
        "Decrease audio volume": 67,
        "Reduce audio volume": 68,
        "Quieter": 69,
        "Volume mute": 70,
        "Lower the volume": 71,
        "Decrease sound levels": 72,
        "Too loud": 73,
        "That\u2019s too loud": 74,
        "Far too loud": 75,
        "It\u2019s too loud, turn it down": 76,
        "It\u2019s too loud, turn the volume down": 77,
        "Increase the temperature": 78,
        "Increase the heating": 79,
        "Could you increase the heating please?": 80,
        "Make it hotter": 81,
        "More heat": 82,
        "Heat up": 83,
        "Turn the kitchen temperature up": 84,
        "Increase the temperature in the kitchen": 85,
        "Increase the heating in the kitchen": 86,
        "Turn up the heat in the kitchen": 87,
        "Turn up the temperature in the bedroom": 88,
        "Turn the temperature in the bedroom up": 89,
        "Turn up the bedroom heat": 90,
        "Bedroom heat up": 91,
        "Increase the temperature in the bedroom": 92,
        "Increase the heating in the bedroom": 93,
        "Turn up the washroom temperature": 94,
        "Washroom heat up": 95,
        "Increase the temperature in the washroom": 96,
        "Turn up the bathroom temperature": 97,
        "Turn the temperature up in the bathroom": 98,
        "Turn up the heat in the bathroom": 99,
        "Turn the heat up in the bathroom": 100,
        "Bathroom heat up": 101,
        "Increase the temperature in the bathroom": 102,
        "Increase the heating in the bathroom": 103,
        "Less heat": 104,
        "Heat down": 105,
        "Could you decrease the heating?": 106,
        "Turn the kitchen temperature down": 107,
        "Turn the heat down in the kitchen": 108,
        "Kitchen heat down": 109,
        "Decrease the temperature in the kitchen": 110,
        "Turn down the bedroom heat": 111,
        "Turn the bedroom heat down": 112,
        "Bedroom heat down": 113,
        "Decrease the temperature in the bedroom": 114,
        "Decrease the heating in the bedroom": 115,
        "Turn the temperature down in the washroom": 116,
        "Turn down the heat in the washroom": 117,
        "Decrease the heating in the washroom": 118,
        "Turn down the bathroom temperature": 119,
        "Turn down the heat in the bathroom": 120,
        "Turn the heat down in the bathroom": 121,
        "Decrease the temperature in the bathroom": 122,
        "Decrease the heating in the bathroom": 123,
        "Bathroom heat down": 124,
        "Pause music": 125,
        "Stop": 126,
        "Get me the newspaper": 127,
        "Bring the newspaper": 128,
        "Fetch the newspaper": 129,
        "Bring some juice": 130,
        "Bring socks": 131,
        "Go get me my socks": 132,
        "Fetch my socks": 133,
        "Switch the language": 134,
        "Change system language": 135,
        "Open language settings": 136,
        "Set the language": 137,
        "Language settings": 138,
        "Set language to Chinese": 139,
        "Set language to Korean": 140,
        "Set my device to Chinese": 141,
        "OK now switch the main language to Chinese": 142,
        "Set my phone's language to English": 143,
        "I need to practice my German. Switch the language": 144,
        "I need to practice my English. Switch the language": 145,
        "Turn the washroom lights off": 146,
        "Turn off the lights": 147,
        "Pause the music": 148,
        "Volume down": 149,
        "Lights on": 150,
        "Turn the lights off": 151,
        "Lights off": 152,
        "Make the music softer": 153,
        "Lights on in the bedroom": 154,
        "Turn sound up": 155,
        "Make it louder": 156,
        "Louder": 157,
        "Too quiet": 158,
        "Turn it down": 159,
        "Volume lower": 160,
        "Could you increase the heating?": 161,
        "Turn up the temperature in the kitchen": 162,
        "Turn the heat up in the kitchen": 163,
        "Kitchen heat up": 164,
        "Turn the heat up in the washroom": 165,
        "Increase the heating in the washroom": 166,
        "Make it cooler": 167,
        "Decrease the temperature": 168,
        "Decrease the heating": 169,
        "Turn down the heat in the kitchen": 170,
        "Decrease the heating in the kitchen": 171,
        "Turn down the temperature in the bedroom": 172,
        "Turn the temperature in the bedroom down": 173,
        "Turn the heat down in the washroom": 174,
        "Washroom heat down": 175,
        "Turn the temperature down in the bathroom": 176,
        "Play music": 177,
        "Bring newspaper": 178,
        "Go get me some juice": 179,
        "Bring me my socks": 180,
        "Get me my socks": 181,
        "Bring my socks": 182,
        "Set language to German": 183,
        "Set language to English": 184,
        "OK now switch the main language to Korean": 185,
        "OK now switch the main language to English": 186,
        "Set my phone's language to Chinese": 187,
        "I need to practice my Korean. Switch the language": 188,
        "Turn on the lights": 189,
        "Turn up the volume": 190,
        "Make the music louder": 191,
        "Turn down the volume": 192,
        "Turn the temperature up": 193,
        "Turn up the heat": 194,
        "Play": 195,
        "Turn the lamp on": 196,
        "Switch off the lamp": 197,
        "Switch the lights on": 198,
        "Turn the bedroom lights on": 199,
        "Switch the bedroom lights on": 200,
        "Bedroom lights on": 201,
        "Turn off the kitchen lights": 202,
        "Lights off in the kitchen": 203,
        "Turn off the lights in the bedroom": 204,
        "Switch off the lights in the bedroom": 205,
        "Lights off in the bedroom": 206,
        "Turn off the washroom lights": 207,
        "Turn volume up": 208,
        "Increase the sound": 209,
        "I can't hear that": 210,
        "That's too quiet": 211,
        "Far too quiet": 212,
        "Turn the sound up": 213,
        "Decrease volume": 214,
        "Turn volume down": 215,
        "Decrease the volume": 216,
        "Make it quieter": 217,
        "Turn the bedroom heat up": 218,
        "Turn the temperature up in the washroom": 219,
        "Turn up the heat in the washroom": 220,
        "Could you decrease the heating please?": 221,
        "Turn down the temperature in the kitchen": 222,
        "Turn down the washroom temperature": 223,
        "Decrease the temperature in the washroom": 224,
        "Stop music": 225,
        "Resume music": 226,
        "Bring me the newspaper": 227,
        "Go get the newspaper": 228,
        "Bring me some juice": 229,
        "Get me some juice": 230,
        "Bring juice": 231,
        "Bring me my shoes": 232,
        "Get me my shoes": 233,
        "Bring shoes": 234,
        "Bring my shoes": 235,
        "Go get me my shoes": 236,
        "Fetch my shoes": 237,
        "Allow a different language": 238,
        "Use a different language": 239,
        "Change the language": 240,
        "Switch language": 241,
        "Switch languages": 242,
        "Set my phone's language to German": 243,
        "Set my phone's language to Korean": 244,
        "I need to practice my Chinese. Switch the language": 245,
        "Pause": 246,
        "OK now switch the main language to German": 247,
    }

    return TaskConfig(
        encoder=encoder,
        eval_weight=2000,
        formal_name="Fluent Speech Commands",
        label_processor=lambda x: class_label_maps[x[data_key]],
        name="fluentspeechcommands",
        output_dim=len(class_label_maps),
        batch_size_encode=1,
        test_split="fluentspeechcommands_test",
        train_split="fluentspeechcommands_train",
        valid_split="fluentspeechcommands_valid",
        zenodo_id="14722453",
    )
