# Hypha

![PyPI](https://img.shields.io/pypi/v/hypha.svg?style=popout)

<img src="./docs/img/hypha-logo-black.svg" width="320" alt="Hypha">

**Hypha** is a generative AI-powered application framework designed for large-scale data management, AI model serving, and real-time communication. Hypha allows the creation of computational platforms consisting of both computational and user interface components.

## Key Features

- **Generative AI-Powered:** Leverage the power of generative AI to build advanced data management and AI model serving solutions.
- **Hypha-RPC:** Utilize [hypha-rpc](https://github.com/oeway/hypha-rpc), a bidirectional remote procedure call system, enabling seamless communication and integration across distributed components.
- **Real-Time Communication:** Support for real-time communication within virtual workspaces, similar to platforms like Zoom.
- **Scalable and Flexible:** Connect and orchestrate various compute services, AI models, tools, and services running on distributed locations.
- **GenAI-Powered Automation:** Build GenAI-powered automation platforms and agentic workflows, enabling fully autonomous agent systems.

## How It Works

Hypha acts as a hub that connects different components through **Hypha-RPC**. Users and programmatic clients connect to the platform in virtual workspaces, where they can seamlessly make remote procedure calls (RPC) as if they are calling local functions. Developers can integrate all types of compute services, including AI models, tools, and services, across distributed locations.

### Virtual Workspaces

- Hypha's virtual workspaces are akin to Zoom rooms, where clients (users and programmatic) can connect and interact.
- Within these workspaces, all clients can perform seamless RPCs, facilitating easy and efficient collaboration and computation.

### Integration with Compute Services

- Hypha supports the integration of various compute services, including AI models and data analytics tools.
- These services, when connected to the platform, can be understood and orchestrated by large language models (LLMs), paving the way for creating next-generation GenAI-powered automation platforms and agentic workflows.

## Use Cases

- **Research Institutions:** Build integrated platforms for data management and AI-powered services.
- **AI-Powered Automation:** Create autonomous agent systems and GenAI-powered automation platforms.
- **Data Services:** Facilitate scalable and efficient data services and analytics through distributed computing.

## Getting Started

To get started with Hypha, follow the installation and setup instructions in the [documentation](https://docs.amun.ai).

## License

Hypha is released under the MIT License. See the [LICENSE](./LICENSE) file for more details.

## Contributing

We welcome contributions from the community. Please see our [Contributing Guidelines](./CONTRIBUTING.md) for more information.

## Acknowledgments

We thank the contributors and community members who have helped make Hypha what it is today.
