# Generated by Django 2.0.6 on 2018-06-26 17:58

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import taggit.managers
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('taggit', '0002_auto_20150616_2121'),
    ]

    operations = [
        migrations.CreateModel(
            name='Claim',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.TextField(blank=True, help_text='A claim being fact checked')),
                ('short_text', models.CharField(blank=True, help_text='A summary of the claim (75 character limit)', max_length=75)),
                ('archive_url', models.URLField(help_text='A permanent record of the claim being made')),
                ('canoncial_url', models.URLField(help_text='The original or most prominent spreading of the claim')),
            ],
        ),
        migrations.CreateModel(
            name='DisinformationType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(max_length=50)),
                ('description', models.TextField(blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='FactCheck',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('publish_date', models.DateField(help_text='The date this fact check was published.')),
                ('explanation', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True)),
                ('cover', models.URLField(blank=True, help_text='An image link to use as the cover and for social.', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='MediaType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(max_length=50)),
                ('description', models.TextField(blank=True)),
                ('archive_service', models.CharField(choices=[('screenshot', 'Screenshot'), ('wayback', 'Wayback Machine')], max_length=20)),
            ],
        ),
        migrations.CreateModel(
            name='Rating',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(blank=True, max_length=50)),
                ('description', models.TextField(blank=True)),
                ('value', models.IntegerField(help_text='A numerical value for the rating from 5 to 1')),
            ],
        ),
        migrations.CreateModel(
            name='Share',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(help_text='The canoncial link to a source spreading a claim.')),
                ('publish_date', models.DateField(help_text='The date this claim was spread by this source.', null=True)),
                ('claim', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='fakenews.Claim')),
            ],
        ),
        migrations.CreateModel(
            name='Source',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=50)),
                ('url', models.URLField()),
                ('description', models.TextField(blank=True, help_text='A Wikipedia-like description of the source')),
            ],
        ),
        migrations.CreateModel(
            name='SourceType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(max_length=50)),
                ('description', models.TextField(blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('api_id', models.CharField(max_length=50)),
                ('first_name', models.CharField(blank=True, max_length=100, null=True)),
                ('last_name', models.CharField(blank=True, max_length=200, null=True)),
                ('email', models.EmailField(blank=True, max_length=254, null=True)),
                ('title', models.CharField(max_length=255)),
            ],
        ),
        migrations.AddField(
            model_name='source',
            name='source_type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='fakenews.SourceType'),
        ),
        migrations.AddField(
            model_name='source',
            name='tags',
            field=taggit.managers.TaggableManager(help_text='A comma-separated list of tags.', through='taggit.TaggedItem', to='taggit.Tag', verbose_name='Tags'),
        ),
        migrations.AddField(
            model_name='share',
            name='source',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='fakenews.Source'),
        ),
        migrations.AddField(
            model_name='factcheck',
            name='author',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='fakenews.User'),
        ),
        migrations.AddField(
            model_name='factcheck',
            name='claim_reviewed',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='fakenews.Claim'),
        ),
        migrations.AddField(
            model_name='factcheck',
            name='rating',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='fakenews.Rating'),
        ),
        migrations.AddField(
            model_name='factcheck',
            name='tags',
            field=taggit.managers.TaggableManager(blank=True, help_text='A comma-separated list of tags.', through='taggit.TaggedItem', to='taggit.Tag', verbose_name='Tags'),
        ),
        migrations.AddField(
            model_name='claim',
            name='disinformation_type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='fakenews.DisinformationType'),
        ),
        migrations.AddField(
            model_name='claim',
            name='media_type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='fakenews.MediaType'),
        ),
    ]
