# coding: utf-8

"""
    Merlin

    API Guide for accessing Merlin's model management, deployment, and serving functionalities

    The version of the OpenAPI document: 0.14.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
from client.models.endpoint_status import EndpointStatus
from client.models.environment import Environment
from client.models.model_endpoint_rule import ModelEndpointRule
from client.models.protocol import Protocol
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class ModelEndpoint(BaseModel):
    """
    ModelEndpoint
    """ # noqa: E501
    id: Optional[StrictInt] = None
    model_id: Optional[StrictInt] = None
    model: Optional[Model] = None
    status: Optional[EndpointStatus] = None
    url: Optional[StrictStr] = None
    rule: Optional[ModelEndpointRule] = None
    environment_name: Optional[StrictStr] = None
    environment: Optional[Environment] = None
    protocol: Optional[Protocol] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["id", "model_id", "model", "status", "url", "rule", "environment_name", "environment", "protocol", "created_at", "updated_at"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ModelEndpoint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of model
        if self.model:
            _dict['model'] = self.model.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rule
        if self.rule:
            _dict['rule'] = self.rule.to_dict()
        # override the default output from pydantic by calling `to_dict()` of environment
        if self.environment:
            _dict['environment'] = self.environment.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of ModelEndpoint from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "model_id": obj.get("model_id"),
            "model": Model.from_dict(obj.get("model")) if obj.get("model") is not None else None,
            "status": obj.get("status"),
            "url": obj.get("url"),
            "rule": ModelEndpointRule.from_dict(obj.get("rule")) if obj.get("rule") is not None else None,
            "environment_name": obj.get("environment_name"),
            "environment": Environment.from_dict(obj.get("environment")) if obj.get("environment") is not None else None,
            "protocol": obj.get("protocol"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at")
        })
        return _obj

from client.models.model import Model
# TODO: Rewrite to not use raise_errors
ModelEndpoint.model_rebuild(raise_errors=False)

