# coding: utf-8

"""
    Merlin

    API Guide for accessing Merlin's model management, deployment, and serving functionalities

    The version of the OpenAPI document: 0.14.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel
from client.models.model_endpoint_rule_destination import ModelEndpointRuleDestination
from client.models.version_endpoint import VersionEndpoint
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class ModelEndpointRule(BaseModel):
    """
    ModelEndpointRule
    """ # noqa: E501
    destinations: Optional[List[ModelEndpointRuleDestination]] = None
    mirror: Optional[VersionEndpoint] = None
    __properties: ClassVar[List[str]] = ["destinations", "mirror"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ModelEndpointRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in destinations (list)
        _items = []
        if self.destinations:
            for _item in self.destinations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['destinations'] = _items
        # override the default output from pydantic by calling `to_dict()` of mirror
        if self.mirror:
            _dict['mirror'] = self.mirror.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of ModelEndpointRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "destinations": [ModelEndpointRuleDestination.from_dict(_item) for _item in obj.get("destinations")] if obj.get("destinations") is not None else None,
            "mirror": VersionEndpoint.from_dict(obj.get("mirror")) if obj.get("mirror") is not None else None
        })
        return _obj


