# coding: utf-8

"""
    Merlin

    API Guide for accessing Merlin's model management, deployment, and serving functionalities

    The version of the OpenAPI document: 0.14.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr
from client.models.prediction_job_config_bigquery_sink import PredictionJobConfigBigquerySink
from client.models.prediction_job_config_bigquery_source import PredictionJobConfigBigquerySource
from client.models.prediction_job_config_gcs_sink import PredictionJobConfigGcsSink
from client.models.prediction_job_config_gcs_source import PredictionJobConfigGcsSource
from client.models.prediction_job_config_model import PredictionJobConfigModel
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class PredictionJobConfig(BaseModel):
    """
    PredictionJobConfig
    """ # noqa: E501
    version: Optional[StrictStr] = None
    kind: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    bigquery_source: Optional[PredictionJobConfigBigquerySource] = None
    gcs_source: Optional[PredictionJobConfigGcsSource] = None
    model: Optional[PredictionJobConfigModel] = None
    bigquery_sink: Optional[PredictionJobConfigBigquerySink] = None
    gcs_sink: Optional[PredictionJobConfigGcsSink] = None
    __properties: ClassVar[List[str]] = ["version", "kind", "name", "bigquery_source", "gcs_source", "model", "bigquery_sink", "gcs_sink"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of PredictionJobConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of bigquery_source
        if self.bigquery_source:
            _dict['bigquery_source'] = self.bigquery_source.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gcs_source
        if self.gcs_source:
            _dict['gcs_source'] = self.gcs_source.to_dict()
        # override the default output from pydantic by calling `to_dict()` of model
        if self.model:
            _dict['model'] = self.model.to_dict()
        # override the default output from pydantic by calling `to_dict()` of bigquery_sink
        if self.bigquery_sink:
            _dict['bigquery_sink'] = self.bigquery_sink.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gcs_sink
        if self.gcs_sink:
            _dict['gcs_sink'] = self.gcs_sink.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of PredictionJobConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "version": obj.get("version"),
            "kind": obj.get("kind"),
            "name": obj.get("name"),
            "bigquery_source": PredictionJobConfigBigquerySource.from_dict(obj.get("bigquery_source")) if obj.get("bigquery_source") is not None else None,
            "gcs_source": PredictionJobConfigGcsSource.from_dict(obj.get("gcs_source")) if obj.get("gcs_source") is not None else None,
            "model": PredictionJobConfigModel.from_dict(obj.get("model")) if obj.get("model") is not None else None,
            "bigquery_sink": PredictionJobConfigBigquerySink.from_dict(obj.get("bigquery_sink")) if obj.get("bigquery_sink") is not None else None,
            "gcs_sink": PredictionJobConfigGcsSink.from_dict(obj.get("gcs_sink")) if obj.get("gcs_sink") is not None else None
        })
        return _obj


