# coding: utf-8

"""
    Merlin

    API Guide for accessing Merlin's model management, deployment, and serving functionalities

    The version of the OpenAPI document: 0.14.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictStr
from client.models.env_var import EnvVar
from client.models.resource_request import ResourceRequest
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class Transformer(BaseModel):
    """
    Transformer
    """ # noqa: E501
    id: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    transformer_type: Optional[StrictStr] = None
    image: Optional[StrictStr] = None
    command: Optional[StrictStr] = None
    args: Optional[StrictStr] = None
    resource_request: Optional[ResourceRequest] = None
    env_vars: Optional[List[EnvVar]] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["id", "enabled", "transformer_type", "image", "command", "args", "resource_request", "env_vars", "created_at", "updated_at"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Transformer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of resource_request
        if self.resource_request:
            _dict['resource_request'] = self.resource_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in env_vars (list)
        _items = []
        if self.env_vars:
            for _item in self.env_vars:
                if _item:
                    _items.append(_item.to_dict())
            _dict['env_vars'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Transformer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "enabled": obj.get("enabled"),
            "transformer_type": obj.get("transformer_type"),
            "image": obj.get("image"),
            "command": obj.get("command"),
            "args": obj.get("args"),
            "resource_request": ResourceRequest.from_dict(obj.get("resource_request")) if obj.get("resource_request") is not None else None,
            "env_vars": [EnvVar.from_dict(_item) for _item in obj.get("env_vars")] if obj.get("env_vars") is not None else None,
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


