# Проблема обработки ошибок в Embedding Service API

## Описание проблемы

При выполнении команды `embed` сервер возвращает ошибки в двух разных форматах:

1. В виде поля `"error"` в корне ответа:
   ```json
   {
     "error": {
       "code": -32603,
       "message": "Command execution error: ...",
       "data": { ... }
     }
   }
   ```

2. В виде поля `"error"` внутри `"result"` с флагом `"success": false`:
   ```json
   {
     "result": {
       "success": false,
       "error": {
         "code": -32603,
         "message": "Command execution error: ...",
         "data": { ... }
       }
     }
   }
   ```

## Влияние на клиент

Такая несогласованность в формате ошибок приводит к проблемам в клиентском коде:
- Клиент вынужден проверять наличие ошибок в двух местах
- Усложняется обработка ошибок
- Возникают ложные срабатывания в тестах

## Рекомендации

1. Унифицировать формат ошибок. Рекомендуемый формат:
   ```json
   {
     "error": {
       "code": <код ошибки>,
       "message": <сообщение об ошибке>,
       "data": <дополнительные данные>
     }
   }
   ```

2. Добавить в OpenAPI схему явное описание формата ошибок для всех эндпоинтов

3. Обновить документацию API с описанием единого формата ошибок

## Примеры проблемных ответов

1. Ошибка в корне:
   ```json
   {
     "error": {
       "code": -32603,
       "message": "Command execution error: 'NoneType' object has no attribute 'split'",
       "data": {
         "original_error": "'NoneType' object has no attribute 'split'"
       }
     }
   }
   ```

2. Ошибка в result:
   ```json
   {
     "result": {
       "success": false,
       "error": {
         "code": -32603,
         "message": "Command execution error: 'NoneType' object has no attribute 'split'",
         "data": {
           "original_error": "'NoneType' object has no attribute 'split'"
         }
       }
     }
   }
   ```

## Временное решение

До исправления на стороне сервера, клиент будет обрабатывать оба формата ошибок. Однако это временное решение, которое усложняет код и может привести к проблемам в будущем.

## Контакты

Если у вас есть вопросы или нужны дополнительные детали, пожалуйста, свяжитесь с нами.

С уважением,
Команда разработки клиента 