# Type stubs for groggy._groggy
# Auto-generated by scripts/generate_stubs.py
# DO NOT EDIT MANUALLY - regenerate with: python scripts/generate_stubs.py
# Generated WITHOUT experimental features (build with --features experimental-delegation to include)

from __future__ import annotations  # Enable forward references
from typing import Any, List, Dict, Optional, Tuple, Union, Iterator

# Module-level functions

def array(*args, **kwargs) -> Any:
    """
    Create a BaseArray from a Python list or array-like object
    
    Examples:
      gr.array([1, 2, 3, 4])
      gr.array(['a', 'b', 'c'])
      gr.array([1.0, 2.5, 3.7])
    """
    ...

def bool_array(*args, **kwargs) -> Any:
    """
    Create NumArray with bool dtype (replaces BoolArray constructor)
    """
    ...

def format_table_function(*args, **kwargs) -> Any:
    """
    Standalone function for formatting tables (exported to Python)
    """
    ...

def int_array(*args, **kwargs) -> Any:
    """
    Integer array factory function (backward compatibility)
    """
    ...

def matrix(*args, **kwargs) -> Any:
    """
    Create a GraphMatrix from arrays or nested lists
    
    Examples:
      gr.matrix([[1, 2], [3, 4]])  # From nested lists
      gr.matrix([arr1, arr2])      # From GraphArrays
      gr.matrix.zeros(3, 3)        # Factory methods available on class
    """
    ...

def merge(*args, **kwargs) -> Any:
    """
    Create a GraphTable from dictionary or arrays with column names
    
    Examples:
      gr.table({'name': ['Alice', 'Bob'], 'age': [25, 30]})
      gr.table([arr1, arr2], columns=['col1', 'col2'])
    Merge multiple graphs into a single new graph
    
    Examples:
      gr.merge([g1, g2, g3])  # Merge multiple graphs
      gr.merge([g1, g2])      # Merge two graphs
    """
    ...

def num_array(*args, **kwargs) -> Any:
    """
    Create a NumArray for numerical operations from a Python list
    
    Examples:
      gr.num_array([1, 2, 3, 4])
      gr.num_array([1.0, 2.5, 3.7])
    """
    ...

def ones_bool(*args, **kwargs) -> Any:
    """
    Create NumArray with bool dtype filled with True values
    """
    ...

def parse_edge_query(*args, **kwargs) -> Any:
    """
    Convenience function for parsing edge queries (stateless)
    """
    ...

def parse_node_query(*args, **kwargs) -> Any:
    """
    Convenience function for parsing node queries (stateless)
    """
    ...

def table(*args, **kwargs) -> Any:
    """
    Create a BaseTable from a Python list of dictionaries or other data
    
    Examples:
      gr.table([{"name": "Alice", "age": 25}, {"name": "Bob", "age": 30}])
      gr.table({"node_id": [1, 2, 3], "name": ["A", "B", "C"]})
    """
    ...

def zeros_bool(*args, **kwargs) -> Any:
    """
    Create NumArray with bool dtype filled with False values
    """
    ...

# Classes

class AggregationFunction:
    """
    Python wrapper for AggregationFunction
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def aggregate(self, *args, **kwargs) -> Any:
        """
        Apply aggregation to a list of values
        """
        ...

    def concat(self, *args, **kwargs) -> Any:
        """
        Create a Concat aggregation function with custom separator
        """
        ...

    def count(self, *args, **kwargs) -> Any:
        """
        Create a Count aggregation function
        """
        ...

    def first(self, *args, **kwargs) -> Any:
        """
        Create a First aggregation function
        """
        ...

    def from_string(self, *args, **kwargs) -> Any:
        """
        Parse aggregation function from string
        """
        ...

    def last(self, *args, **kwargs) -> Any:
        """
        Create a Last aggregation function
        """
        ...

    def max(self, *args, **kwargs) -> Any:
        """
        Create a Max aggregation function
        """
        ...

    def mean(self, *args, **kwargs) -> Any:
        """
        Create a Mean aggregation function
        """
        ...

    def min(self, *args, **kwargs) -> Any:
        """
        Create a Min aggregation function
        """
        ...

    def sum(self, *args, **kwargs) -> Any:
        """
        Create a Sum aggregation function
        """
        ...


class AggregationResult:
    """
    Result of an aggregation operation
    """
    @property
    def attribute(self) -> Any:
        ...

    @property
    def count(self) -> Any:
        ...

    @property
    def operation(self) -> Any:
        ...

    @property
    def value(self) -> Any:
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...


class ArrayArray:
    """
    Python wrapper for ArrayArray
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def agg(self, *args, **kwargs) -> Any:
        """
        Apply multiple aggregations at once
        
        Args:
            spec: Dictionary mapping aggregation names to functions
                  e.g., {"mean": "mean", "std": "std"}
        
        Returns:
            BaseTable with columns for each aggregation
        
        Example:
        ```python
        result = arr_arr.agg({"mean": "mean", "std": "std", "count": "count"})
        # Returns table with columns: [group_key, mean, std, count]
        ```
        """
        ...

    def count(self, *args, **kwargs) -> Any:
        """
        Count elements in each array
        """
        ...

    def is_empty(self, *args, **kwargs) -> Any:
        """
        Check if empty
        """
        ...

    def keys(self, *args, **kwargs) -> Any:
        """
        Get keys if available
        """
        ...

    def max(self, *args, **kwargs) -> Any:
        """
        Calculate maximum of each array
        """
        ...

    def mean(self, *args, **kwargs) -> Any:
        """
        Calculate mean of each array
        
        Returns a BaseTable with group keys and means if keys are present,
        otherwise returns a Python list of means.
        
        Example:
        ```python
        arr_arr = ArrayArray([
            BaseArray([1.0, 2.0, 3.0]),
            BaseArray([4.0, 5.0, 6.0])
        ])
        means = arr_arr.mean()  # [2.0, 5.0]
        ```
        """
        ...

    def min(self, *args, **kwargs) -> Any:
        """
        Calculate minimum of each array
        """
        ...

    def std(self, *args, **kwargs) -> Any:
        """
        Calculate standard deviation of each array
        """
        ...

    def sum(self, *args, **kwargs) -> Any:
        """
        Calculate sum of each array
        """
        ...

    def to_type(self, *args, **kwargs) -> Any:
        """
        Convert ArrayArray to numeric NumArray for operations
        
        Converts all arrays to f64 and returns as NumArray.
        Non-numeric values are filtered out during conversion.
        
        Example:
        ```python
        arr_arr = ArrayArray([
            BaseArray([1, 2, 3]),
            BaseArray([4.0, 5.0, 6.0])
        ])
        num_arr = arr_arr.to_type("float64")  # Returns NumArray with aggregations
        ```
        """
        ...


class AttrValue:
    """
    Python wrapper for AttrValue
    """
    @property
    def type_name(self) -> Any:
        ...

    @property
    def value(self) -> Any:
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...


class AttributeFilter:
    """
    Python wrapper for AttributeFilter
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def equals(self, *args, **kwargs) -> Any:
        ...

    def greater_than(self, *args, **kwargs) -> Any:
        ...

    def greater_than_or_equal(self, *args, **kwargs) -> Any:
        ...

    def less_than(self, *args, **kwargs) -> Any:
        ...

    def less_than_or_equal(self, *args, **kwargs) -> Any:
        ...

    def not_equals(self, *args, **kwargs) -> Any:
        ...


class BaseArray:
    """
    New BaseArray-powered array with chaining support
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def append(self, *args, **kwargs) -> Any:
        """
        Append a single element (standard Python method)
        
        # Arguments
        * `element` - Value to append to the array
        
        # Returns
        New array with the element appended
        
        # Examples
        ```python
        new_array = array.append(42)
        ```
        """
        ...

    def append_element(self, *args, **kwargs) -> Any:
        """
        Append a single element to the array
        
        # Arguments
        * `element` - Value to append to the array
        
        # Examples
        ```python
        new_array = array.append_element(42)
        ```
        """
        ...

    def apply(self, *args, **kwargs) -> Any:
        """
        Apply a Python function to each element in the array (pandas-style apply)
        
        # Arguments
        * `func` - Python function to apply to each element
        
        # Returns
        New BaseArray with transformed values
        
        # Examples
        ```python
        # Square each number
        def square(x):
            if isinstance(x, (int, float)):
                return x * x
            return x
        
        squared = array.apply(square)
        
        # Using lambda
        doubled = array.apply(lambda x: x * 2 if isinstance(x, (int, float)) else x)
        ```
        """
        ...

    def apply_to_each(self, *args, **kwargs) -> Any:
        """
        Delegation-based method application to each element
        This demonstrates the concept: apply a method to each element and return new array
        """
        ...

    def contains(self, *args, **kwargs) -> Any:
        """
        Check whether the array contains the provided value
        """
        ...

    def corr(self, *args, **kwargs) -> Any:
        """
        Compute correlation coefficient with another array
        
        # Arguments
        * `other` - The other array to compute correlation with
        * `method` - Correlation method: "pearson" (default), "spearman", or "kendall"
        
        # Returns
        Correlation coefficient as a Python float
        """
        ...

    def count(self, *args, **kwargs) -> Any:
        """
        Count non-null values in the array
        """
        ...

    def cov(self, *args, **kwargs) -> Any:
        """
        Compute covariance with another array
        
        # Arguments
        * `other` - The other array to compute covariance with
        * `ddof` - Delta degrees of freedom (default: 1)
        
        # Returns
        Covariance as a Python float
        """
        ...

    def cummax(self, *args, **kwargs) -> Any:
        """
        Cumulative maximum operation
        
        # Returns
        New BaseArray with cumulative maximum values
        """
        ...

    def cummin(self, *args, **kwargs) -> Any:
        """
        Cumulative minimum operation
        
        # Returns
        New BaseArray with cumulative minimum values
        """
        ...

    def cumsum(self, *args, **kwargs) -> Any:
        """
        Cumulative sum operation
        
        # Returns
        New BaseArray with cumulative sum values
        """
        ...

    def describe(self, *args, **kwargs) -> Any:
        ...

    def drop_duplicates_elements(self, *args, **kwargs) -> Any:
        """
        Drop duplicate elements
        
        # Examples
        ```python
        new_array = array.drop_duplicates_elements()
        ```
        """
        ...

    def drop_elements(self, *args, **kwargs) -> Any:
        """
        Drop elements by indices
        
        # Arguments
        * `indices` - List of indices to drop from the array
        
        # Examples
        ```python
        new_array = array.drop_elements([0, 2, 4])  # Drop elements at indices 0, 2, and 4
        ```
        """
        ...

    def dropna(self, *args, **kwargs) -> Any:
        """
        Remove missing/null values from the array
        Returns a new array with null values filtered out
        Similar to pandas Series.dropna()
        """
        ...

    def dtype(self, *args, **kwargs) -> Any:
        """
        Get the data type of the array based on the first non-null element
        """
        ...

    def expanding(self, *args, **kwargs) -> Any:
        """
        Expanding window operation (cumulative from start)
        
        # Arguments
        * `operation` - Function to apply to expanding window (e.g., "mean", "sum", "min", "max", "std")
        
        # Returns
        New BaseArray with expanding operation results
        """
        ...

    def extend(self, *args, **kwargs) -> Any:
        """
        Extend array with multiple elements (standard Python method)
        
        # Arguments
        * `elements` - List of values to append to the array
        
        # Returns
        New array with all elements appended
        
        # Examples
        ```python
        new_array = array.extend([42, "hello", 3.14])
        ```
        """
        ...

    def extend_elements(self, *args, **kwargs) -> Any:
        """
        Extend array with multiple elements
        
        # Arguments
        * `elements` - List of values to append to the array
        
        # Examples
        ```python
        new_array = array.extend_elements([42, "hello", 3.14])
        ```
        """
        ...

    def fillna(self, *args, **kwargs) -> Any:
        """
        Fill null values with a specified value
        Returns a new array with nulls replaced by the fill value
        Similar to pandas Series.fillna()
        """
        ...

    def filter(self, *args, **kwargs) -> Any:
        """
        Filter elements using a Python function
        
        # Arguments
        * `predicate` - Python function that returns True/False for each element
        
        # Returns
        New array with elements where predicate returns True
        
        # Examples
        ```python
        filtered = array.filter(lambda x: x > 5)
        ```
        """
        ...

    def get(self, *args, **kwargs) -> Any:
        """
        Get element at specific index
        
        # Arguments
        * `index` - Index to retrieve (0-based)
        
        # Returns
        The element at the specified index
        
        # Examples
        ```python
        element = array.get(0)  # Get first element
        ```
        """
        ...

    def get_percentile(self, *args, **kwargs) -> Any:
        """
        Compute specific percentile for the array (direct method for consistency)
        
        # Arguments
        * `percentile` - Percentile to compute (0.0 to 100.0)
        * `interpolation` - Method for interpolation
        
        # Returns
        The computed percentile as PyObject
        
        # Examples
        ```python
        # Get median (50th percentile)
        median = array.get_percentile(50.0)
        
        # Get 95th percentile with nearest interpolation
        p95 = array.get_percentile(95.0, "nearest")
        ```
        """
        ...

    def has_nulls(self, *args, **kwargs) -> Any:
        """
        Check if the array contains any null values
        Similar to pandas Series.hasnans
        """
        ...

    def head(self, *args, **kwargs) -> Any:
        ...

    def infer_numeric_type(self, *args, **kwargs) -> Any:
        """
        Infer the optimal numeric type for this BaseArray
        Analyzes all elements to determine the most appropriate NumericType
        Returns None if the array contains non-numeric data
        """
        ...

    def insert(self, *args, **kwargs) -> Any:
        """
        Insert element at specific index
        
        # Arguments
        * `index` - Index to insert at
        * `element` - Value to insert
        
        # Returns
        New array with element inserted
        
        # Examples
        ```python
        new_array = array.insert(2, "new_value")
        ```
        """
        ...

    def is_empty(self, *args, **kwargs) -> Any:
        """
        Check whether the array contains any elements
        """
        ...

    def is_numeric(self, *args, **kwargs) -> Any:
        """
        Check if this BaseArray can be converted to a numeric array
        """
        ...

    def isna(self, *args, **kwargs) -> Any:
        """
        Detect missing/null values in the array
        Returns a boolean BaseArray where True indicates a null value
        Similar to pandas Series.isna()
        """
        ...

    def iter(self, *args, **kwargs) -> Any:
        """
        NEW: Enable fluent chaining with .iter() method
        """
        ...

    def len(self, *args, **kwargs) -> Any:
        """
        Get the length of the array (standard Python method)
        
        # Returns
        The number of elements in the array
        
        # Examples
        ```python
        size = array.len()
        ```
        """
        ...

    def map(self, *args, **kwargs) -> Any:
        """
        Map elements using a Python function
        
        # Arguments
        * `func` - Python function to apply to each element
        
        # Returns
        New array with transformed elements
        
        # Examples
        ```python
        mapped = array.map(lambda x: x * 2)
        ```
        """
        ...

    def max(self, *args, **kwargs) -> Any:
        """
        Find maximum value in the array
        """
        ...

    def mean(self, *args, **kwargs) -> Any:
        """
        Calculate mean of numeric values in the array
        """
        ...

    def median(self, *args, **kwargs) -> Any:
        """
        Calculate median of numeric values in the array
        """
        ...

    def min(self, *args, **kwargs) -> Any:
        """
        Find minimum value in the array
        """
        ...

    def notna(self, *args, **kwargs) -> Any:
        """
        Detect non-missing/non-null values in the array
        Returns a boolean BaseArray where True indicates a non-null value
        Similar to pandas Series.notna()
        """
        ...

    def null_count(self, *args, **kwargs) -> Any:
        """
        Count the number of null values in the array
        """
        ...

    def numeric_compatibility_info(self, *args, **kwargs) -> Any:
        """
        Get statistics about the numeric compatibility of this BaseArray
        """
        ...

    def nunique(self, *args, **kwargs) -> Any:
        """
        Count unique non-null values in the array
        """
        ...

    def pct_change(self, *args, **kwargs) -> Any:
        """
        Percentage change operation
        
        # Arguments
        * `periods` - Number of periods to use for comparison (default: 1)
        
        # Returns
        New BaseArray with percentage change values
        """
        ...

    def percentile(self, *args, **kwargs) -> Any:
        """
        Compute percentile for the array (equivalent to quantile * 100)
        
        # Arguments
        * `percentile` - Percentile to compute (0.0 to 100.0)
        * `interpolation` - Method for interpolation
        
        # Examples
        ```python
        # Get median (50th percentile)
        median = array.percentile(50.0, "linear")
        
        # Get quartiles
        q1 = array.percentile(25.0)
        q3 = array.percentile(75.0)
        ```
        """
        ...

    def percentiles(self, *args, **kwargs) -> Any:
        """
        Compute multiple percentiles for the array
        
        # Arguments
        * `percentiles` - List of percentiles to compute (each 0.0 to 100.0)
        * `interpolation` - Method for interpolation
        
        # Returns
        BaseArray containing the computed percentiles
        """
        ...

    def quantile(self, *args, **kwargs) -> Any:
        """
        Compute quantile for the array (pandas-style quantile)
        
        # Arguments
        * `q` - Quantile to compute (0.0 to 1.0)
        * `interpolation` - Method for interpolation ("linear", "lower", "higher", "midpoint", "nearest")
        
        # Returns
        AttrValue containing the computed quantile
        
        # Examples
        ```python
        # Get median (50th percentile)
        median = array.quantile(0.5, "linear")
        
        # Get 95th percentile with nearest interpolation
        p95 = array.quantile(0.95, "nearest")
        ```
        """
        ...

    def quantiles(self, *args, **kwargs) -> Any:
        """
        Compute multiple quantiles for the array
        
        # Arguments
        * `quantiles` - List of quantiles to compute (each 0.0 to 1.0)
        * `interpolation` - Method for interpolation
        
        # Returns
        BaseArray containing the computed quantiles
        """
        ...

    def remove(self, *args, **kwargs) -> Any:
        """
        Remove element at specific index
        
        # Arguments
        * `index` - Index to remove
        
        # Returns
        New array with element removed
        
        # Examples
        ```python
        new_array = array.remove(0)  # Remove first element
        ```
        """
        ...

    def reverse(self, *args, **kwargs) -> Any:
        """
        Reverse the order of elements
        
        # Returns
        New array with elements in reverse order
        
        # Examples
        ```python
        reversed_array = array.reverse()
        ```
        """
        ...

    def rolling(self, *args, **kwargs) -> Any:
        """
        Rolling window operation with specified window size
        
        # Arguments
        * `window` - Window size for rolling operations
        * `operation` - Function to apply to each window (e.g., "mean", "sum", "min", "max", "std")
        
        # Returns
        New BaseArray with rolling operation results
        """
        ...

    def shift(self, *args, **kwargs) -> Any:
        """
        Shift operation - shift values by specified periods
        
        # Arguments
        * `periods` - Number of periods to shift (positive = shift right, negative = shift left)
        * `fill_value` - Value to use for filling gaps (default: Null)
        
        # Returns
        New BaseArray with shifted values
        """
        ...

    def sort(self, *args, **kwargs) -> Any:
        """
        Sort the array elements
        
        # Arguments
        * `ascending` - Whether to sort in ascending order (default: true)
        
        # Returns
        New array with sorted elements
        
        # Examples
        ```python
        sorted_asc = array.sort()
        sorted_desc = array.sort(ascending=False)
        ```
        """
        ...

    def std(self, *args, **kwargs) -> Any:
        """
        Calculate standard deviation of numeric values in the array
        """
        ...

    def sum(self, *args, **kwargs) -> Any:
        """
        Calculate sum of numeric values in the array
        """
        ...

    def tail(self, *args, **kwargs) -> Any:
        ...

    def to_list(self, *args, **kwargs) -> Any:
        """
        Convert the array to a plain Python list
        """
        ...

    def to_num_array(self, *args, **kwargs) -> Any:
        """
        Convert BaseArray to NumArray if all elements are numeric
        Returns appropriate numeric array type based on inferred type
        OPTIMIZED: Single-pass conversion with pre-allocated vectors
        """
        ...

    def to_table(self, *args, **kwargs) -> Any:
        """
        Convert array to table format for streaming visualization
        
        Creates a BaseTable with 'index' and 'value' columns from the array data.
        This enables the array to use the rich streaming table infrastructure.
        """
        ...

    def to_table_with_name(self, *args, **kwargs) -> Any:
        """
        Convert array to single-column table with specified column name
        
        # Arguments
        * `column_name` - Name for the column when converting to table
        
        # Examples
        ```python
        table = array.to_table_with_name("scores")
        ```
        """
        ...

    def to_table_with_prefix(self, *args, **kwargs) -> Any:
        """
        Convert array to single-column table with prefix added to default column name
        
        # Arguments
        * `prefix` - Prefix to add to the default 'values' column name
        
        # Examples
        ```python
        table = array.to_table_with_prefix("old_")  # Creates column "old_values"
        ```
        """
        ...

    def to_table_with_suffix(self, *args, **kwargs) -> Any:
        """
        Convert array to single-column table with suffix added to default column name
        
        # Arguments
        * `suffix` - Suffix to add to the default 'values' column name
        
        # Examples
        ```python
        table = array.to_table_with_suffix("_v1")  # Creates column "values_v1"
        ```
        """
        ...

    def to_type(self, *args, **kwargs) -> Any:
        """
        Convert BaseArray to different numeric types when possible
        """
        ...

    def unique(self, *args, **kwargs) -> Any:
        ...

    def value_counts(self, *args, **kwargs) -> Any:
        """
        Count the frequency of unique values (pandas-style value_counts)
        
        # Arguments
        * `sort` - Whether to sort results by count (default: true)
        * `ascending` - Sort order when sort=true (default: false, most frequent first)
        * `dropna` - Whether to exclude null values (default: true)
        
        # Returns
        Table with 'value' and 'count' columns showing frequency of each unique value
        
        # Examples
        ```python
        # Basic usage
        counts = array.value_counts()
        
        # Custom sorting
        counts = array.value_counts(sort=True, ascending=True)
        
        # Include null values
        counts = array.value_counts(dropna=False)
        ```
        """
        ...

    def var(self, *args, **kwargs) -> Any:
        """
        Calculate variance of numeric values in the array
        """
        ...


class BaseTable:
    """
    Python wrapper for BaseTable
    """
    @property
    def column_names(self) -> Any:
        """
        Get column names
        """
        ...

    @property
    def columns(self) -> Any:
        """
        Get column names (alias for column_names)
        """
        ...

    @property
    def ncols(self) -> Any:
        """
        Get number of columns
        """
        ...

    @property
    def nrows(self) -> Any:
        """
        Get number of rows
        """
        ...

    @property
    def shape(self) -> Any:
        """
        Get shape as (rows, cols)
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __iter__(self) -> Iterator:
        """
        Implement iter(self).
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __setitem__(self, key: Any, value: Any) -> None:
        """
        Set self[key] to value.
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def add_prefix(self, *args, **kwargs) -> Any:
        """
        Add prefix to all column names
        
        # Arguments
        * `prefix` - String prefix to add to all column names
        
        # Examples
        ```python
        prefixed = table.add_prefix("old_")
        ```
        """
        ...

    def add_suffix(self, *args, **kwargs) -> Any:
        """
        Add suffix to all column names
        
        # Arguments
        * `suffix` - String suffix to add to all column names
        
        # Examples
        ```python
        suffixed = table.add_suffix("_v1")
        ```
        """
        ...

    def agg(self, *args, **kwargs) -> Any:
        """
        Alias for aggregate method (more concise)
        
        # Arguments
        * `agg_specs` - Dictionary mapping column names to aggregation functions
        
        # Returns
        PyBaseTable: A single table with aggregated results
        
        # Example
        ```python
        # Aggregate the entire table
        summary = table.agg({'sales': 'sum', 'price': 'avg', 'items': 'count'})
        ```
        """
        ...

    def aggregate(self, *args, **kwargs) -> Any:
        """
        Aggregate entire table without grouping
        
        # Arguments
        * `agg_specs` - Dictionary mapping column names to aggregation functions
        
        # Examples
        ```python
        # Calculate summary statistics
        summary = table.aggregate({'sales': 'sum', 'price': 'avg', 'items': 'count'})
        ```
        """
        ...

    def append(self, *args, **kwargs) -> Any:
        """
        Append a new row to the table (pandas-style append)
        
        # Arguments
        * `row_data` - Dictionary mapping column names to values
        
        # Returns
        New table with the row appended
        
        # Examples
        ```python
        # Add a new row
        new_table = table.append({'name': 'Alice', 'age': 30})
        ```
        """
        ...

    def append_row(self, *args, **kwargs) -> Any:
        """
        Append a single row to the table
        
        # Arguments
        * `row` - Dictionary mapping column names to values
        
        # Examples
        ```python
        new_table = table.append_row({"name": "David", "age": 40, "score": 95})
        ```
        """
        ...

    def apply(self, *args, **kwargs) -> Any:
        """
        Apply a Python function along an axis of the table (pandas-style apply)
        
        # Arguments
        * `func` - Python function to apply
        * `axis` - 0 for columns, 1 for rows
        * `result_name` - Name for the result column (only used when axis=1)
        
        # Returns
        Transformed table based on the axis
        
        # Examples
        ```python
        # Apply to columns (axis=0)
        column_sums = table.apply(lambda col: sum(col), axis=0)
        
        # Apply to rows (axis=1)
        row_sums = table.apply(lambda row: sum(row.values()), axis=1, result_name="total")
        ```
        """
        ...

    def apply_to_columns(self, *args, **kwargs) -> Any:
        """
        Apply a Python function to each column in the table (pandas-style apply with axis=0)
        
        # Arguments
        * `func` - Python function to apply to each column
        
        # Returns
        New single-row table with one column per original column containing the function results
        
        # Examples
        ```python
        # Get column sums
        def sum_column(col):
            return sum(x for x in col if isinstance(x, (int, float)))
        
        result = table.apply(sum_column, axis=0)
        
        # Using lambda for column means
        means = table.apply(lambda col: sum(col) / len(col), axis=0)
        ```
        """
        ...

    def apply_to_rows(self, *args, **kwargs) -> Any:
        """
        Apply a Python function to each row in the table (pandas-style apply with axis=1)
        
        # Arguments
        * `func` - Python function to apply to each row
        * `result_name` - Name for the result column
        
        # Returns
        New single-column table with one row per original row containing the function results
        
        # Examples
        ```python
        # Compute row sums
        def sum_row(row):
            return sum(v for v in row.values() if isinstance(v, (int, float)))
        
        result = table.apply(sum_row, axis=1, result_name="row_sum")
        
        # Using lambda for row means
        means = table.apply(lambda row: sum(row.values()) / len(row), axis=1, result_name="row_mean")
        ```
        """
        ...

    def assign(self, *args, **kwargs) -> Any:
        """
        Assign updates to multiple columns at once
        
        Args:
            updates: Dictionary mapping column names to values. Values can be:
                     - Lists: ['value1', 'value2', ...]  
                     - Dictionaries with integer keys: {0: 'value1', 1: 'value2', ...}
            
        Examples:
            # Using lists (updates entire columns)
            updates = {"bonus": [1000, 1500], "status": ["active", "inactive"]}
            table.assign(updates)
            
            # Using dictionaries with integer keys (sparse updates)
            updates = {"bonus": {0: 1000, 3: 1500}, "status": {1: "active", 2: "inactive"}}
            table.assign(updates)
        """
        ...

    def check_outliers(self, *args, **kwargs) -> Any:
        """
        Detect outliers in numeric columns using IQR method
        
        # Arguments
        * `column` - Column name to analyze for outliers
        * `factor` - IQR multiplication factor (default: 1.5)
        
        # Returns
        BaseArray with boolean values indicating outliers
        """
        ...

    def column(self, *args, **kwargs) -> Any:
        """
        Get a specific column as BaseArray for chaining operations
        This enables: table.column('age').iter().filter(...).collect()
        """
        ...

    def column_info(self, *args, **kwargs) -> Any:
        """
        Get column information for type introspection
        Returns a dictionary with column metadata including type, shape, and statistics
        """
        ...

    def corr(self, *args, **kwargs) -> Any:
        """
        Compute correlation matrix for numeric columns
        
        # Arguments
        * `method` - Correlation method: "pearson" (default), "spearman", or "kendall"
        
        # Returns
        BaseTable containing the correlation matrix
        """
        ...

    def corr_columns(self, *args, **kwargs) -> Any:
        """
        Compute correlation between two specific columns
        
        # Arguments
        * `col1` - First column name
        * `col2` - Second column name
        * `method` - Correlation method: "pearson" (default), "spearman", or "kendall"
        
        # Returns
        Correlation coefficient as a Python float
        """
        ...

    def cov(self, *args, **kwargs) -> Any:
        """
        Compute covariance matrix for numeric columns
        
        # Arguments
        * `ddof` - Delta degrees of freedom (default: 1)
        
        # Returns
        BaseTable containing the covariance matrix
        """
        ...

    def cov_columns(self, *args, **kwargs) -> Any:
        """
        Compute covariance between two specific columns
        
        # Arguments
        * `col1` - First column name
        * `col2` - Second column name
        * `ddof` - Delta degrees of freedom (default: 1)
        
        # Returns
        Covariance as a Python float
        """
        ...

    def cummax(self, *args, **kwargs) -> Any:
        """
        Cumulative maximum operation on a specific column
        
        # Arguments
        * `column` - Column name to apply cumulative maximum to
        
        # Returns
        BaseArray with cumulative maximum values
        """
        ...

    def cummin(self, *args, **kwargs) -> Any:
        """
        Cumulative minimum operation on a specific column
        
        # Arguments
        * `column` - Column name to apply cumulative minimum to
        
        # Returns
        BaseArray with cumulative minimum values
        """
        ...

    def cumsum(self, *args, **kwargs) -> Any:
        """
        Cumulative sum operation on a specific column
        
        # Arguments
        * `column` - Column name to apply cumulative sum to
        
        # Returns
        BaseArray with cumulative sum values
        """
        ...

    def describe(self, *args, **kwargs) -> Any:
        """
        Generate descriptive statistics for numeric columns
        
        Returns a table with summary statistics including count, mean, std, min,
        percentiles (25%, 50%, 75%), and max for all numeric columns.
        Similar to pandas DataFrame.describe()
        
        # Returns
        PyBaseTable: A table where each row represents a statistic and each column
        represents a numeric column from the original table
        
        # Examples
        ```python
        # Generate descriptive statistics
        stats = table.describe()
        print(stats)
        #          age    salary
        # count   5.0    5.0
        # mean   30.0  65000.3
        # std     4.1   15201.2
        # min    25.0   45000.0
        # 25%    27.0   55000.0
        # 50%    30.0   68000.0
        # 75%    32.0   75000.0
        # max    35.0   82000.0
        ```
        """
        ...

    def drop_columns(self, *args, **kwargs) -> Any:
        """
        Drop columns from the table
        
        Args:
            columns: List of column names to drop
        
        Returns:
            PyBaseTable: A new table without the specified columns
        """
        ...

    def drop_duplicates(self, *args, **kwargs) -> Any:
        """
        Drop duplicate rows based on specified columns (or all columns if none specified)
        
        # Arguments
        * `subset` - Optional list of column names to check for duplicates
        
        # Examples
        ```python
        # Drop duplicates based on all columns
        new_table = table.drop_duplicates()
        
        # Drop duplicates based only on 'name' and 'age' columns
        new_table = table.drop_duplicates(["name", "age"])
        ```
        """
        ...

    def drop_rows(self, *args, **kwargs) -> Any:
        """
        Drop rows by indices
        
        # Arguments
        * `indices` - List of row indices to drop
        
        # Examples
        ```python
        new_table = table.drop_rows([0, 2, 4])  # Drop rows at indices 0, 2, and 4
        ```
        """
        ...

    def dropna(self, *args, **kwargs) -> Any:
        """
        Remove rows with any null values
        Returns a new table with rows containing null values removed
        Similar to pandas DataFrame.dropna()
        """
        ...

    def dropna_subset(self, *args, **kwargs) -> Any:
        """
        Remove rows with null values in specified columns
        Similar to pandas DataFrame.dropna(subset=['col1', 'col2'])
        """
        ...

    def expanding(self, *args, **kwargs) -> Any:
        """
        Expanding window operation on a specific column
        
        # Arguments
        * `column` - Column name to apply expanding operation to
        * `operation` - Function to apply to expanding window (e.g., "mean", "sum", "min", "max", "std")
        
        # Returns
        BaseArray with expanding operation results
        """
        ...

    def expanding_all(self, *args, **kwargs) -> Any:
        """
        Apply expanding window operations to all numeric columns
        
        # Arguments
        * `operation` - Function to apply to expanding window
        
        # Returns
        New table with expanding operations applied to all numeric columns
        """
        ...

    def extend(self, *args, **kwargs) -> Any:
        """
        Extend the table with multiple rows (pandas-style extend/concat)
        
        # Arguments
        * `rows_data` - List of dictionaries, each representing a row
        
        # Returns
        New table with all rows appended
        
        # Examples
        ```python
        # Add multiple rows
        rows = [
            {'name': 'Alice', 'age': 30},
            {'name': 'Bob', 'age': 25}
        ]
        new_table = table.extend(rows)
        ```
        """
        ...

    def extend_rows(self, *args, **kwargs) -> Any:
        """
        Extend table with multiple rows
        
        # Arguments
        * `rows` - List of dictionaries, each mapping column names to values
        
        # Examples
        ```python
        new_table = table.extend_rows([
            {"name": "David", "age": 40, "score": 95},
            {"name": "Eve", "age": 35, "score": 88}
        ])
        ```
        """
        ...

    def fillna(self, *args, **kwargs) -> Any:
        """
        Fill null values with specified values per column
        Returns a new table with nulls replaced by the fill values
        Similar to pandas DataFrame.fillna()
        """
        ...

    def fillna_all(self, *args, **kwargs) -> Any:
        """
        Fill null values with a single value for all columns
        """
        ...

    def filter(self, *args, **kwargs) -> Any:
        """
        Filter rows using a query expression or Python function
        
        Args:
            predicate: Either a string query expression (e.g. "age > 25") or a Python function
        
        Returns:
            PyBaseTable: A new table with filtered rows
        """
        ...

    def from_csv(self, *args, **kwargs) -> Any:
        """
        Import BaseTable from CSV file
        """
        ...

    def from_dict(self, *args, **kwargs) -> Any:
        """
        Create BaseTable from a Python dictionary
        
        # Arguments
        * `data` - Dictionary mapping column names to lists of values
        
        # Examples
        ```python
        data = {
            'id': [1, 2, 3],
            'name': ['Alice', 'Bob', 'Charlie'],
            'age': [25, 30, 35]
        }
        table = BaseTable.from_dict(data)
        ```
        """
        ...

    def from_json(self, *args, **kwargs) -> Any:
        """
        Import BaseTable from JSON file
        """
        ...

    def from_parquet(self, *args, **kwargs) -> Any:
        """
        Import BaseTable from Parquet file
        """
        ...

    def get_column_numeric(self, *args, **kwargs) -> Any:
        """
        Get column as numeric array if possible (returns NumArray/IntArray or error)
        """
        ...

    def get_column_raw(self, *args, **kwargs) -> Any:
        """
        Get column as raw BaseArray (always returns BaseArray regardless of type)
        """
        ...

    def get_percentile(self, *args, **kwargs) -> Any:
        """
        Compute specific percentile for a column (direct method for consistency)
        
        # Arguments
        * `column` - Column name to analyze
        * `percentile` - Percentile to compute (0.0 to 100.0)
        * `interpolation` - Method for interpolation
        
        # Returns
        The computed percentile as PyObject
        
        # Examples
        ```python
        # Get median (50th percentile)
        median = table.get_percentile("age", 50.0)
        
        # Get 95th percentile with nearest interpolation
        p95 = table.get_percentile("score", 95.0, "nearest")
        ```
        """
        ...

    def group_by(self, *args, **kwargs) -> Any:
        """
        Group by columns and return grouped tables
        
        Args:
            columns: List of column names to group by
        
        Returns:
            PyTableArray: Array-like container holding the grouped tables
        """
        ...

    def group_by_agg(self, *args, **kwargs) -> Any:
        """
        Group by columns and apply aggregations
        
        # Arguments
        * `group_cols` - List of column names to group by
        * `agg_specs` - Dictionary mapping column names to aggregation functions
          Supported functions: "count", "sum", "avg", "mean", "min", "max"
        
        # Examples
        ```python
        # Group by 'category' and aggregate 'value' column
        result = table.group_by_agg(['category'], {'value': 'sum', 'price': 'avg'})
        
        # Multiple grouping columns
        result = table.group_by_agg(['region', 'category'], {'sales': 'sum', 'items': 'count'})
        ```
        """
        ...

    def groupby(self, *args, **kwargs) -> Any:
        """
        Group table by one or more columns, returning a TableArray for fluent operations
        This enables powerful operations like table.groupby(['category']).sum()
        
        # Arguments
        * `by` - Column name(s) to group by. Can be string or list of strings.
        
        # Returns
        A TableArray where each table represents one group
        
        # Examples
        ```python
        # Group by single column and sum
        result = table.groupby('category').sum()
        
        # Group by multiple columns with custom aggregation
        result = table.groupby(['category', 'region']).agg({
            'sales': 'sum',
            'price': 'mean'
        })
        ```
        """
        ...

    def groupby_single(self, *args, **kwargs) -> Any:
        """
        Convenience method for grouping by a single column
        """
        ...

    def has_column(self, *args, **kwargs) -> Any:
        """
        Check if column exists
        """
        ...

    def has_nulls(self, *args, **kwargs) -> Any:
        """
        Check if the table contains any null values
        """
        ...

    def head(self, *args, **kwargs) -> Any:
        """
        Get first n rows (default 5)
        """
        ...

    def intersect(self, *args, **kwargs) -> Any:
        """
        Intersect with another table (returns common rows)
        
        # Arguments
        * `other` - The table to intersect with
        
        # Examples
        ```python
        # Find common rows between tables
        common = table1.intersect(table2)
        ```
        """
        ...

    def is_empty(self, *args, **kwargs) -> Any:
        """
        Check whether the table contains any rows
        """
        ...

    def isin(self, *args, **kwargs) -> Any:
        """
        Check if values in a column are in a provided set (pandas-style isin)
        
        # Arguments
        * `column_name` - Name of the column to check
        * `values` - List of values to check membership against
        
        # Returns
        Boolean array indicating which rows match the values
        
        # Examples
        ```python
        mask = table.isin("department", ["Engineering", "Marketing"])
        filtered = table[mask]
        ```
        """
        ...

    def isna(self, *args, **kwargs) -> Any:
        """
        Detect missing values in the entire table
        Returns a new table of the same shape with boolean values indicating null positions
        Similar to pandas DataFrame.isna()
        """
        ...

    def iter(self, *args, **kwargs) -> Any:
        """
        Explicit row iterator that mirrors the default Python iteration protocol.
        """
        ...

    def join(self, *args, **kwargs) -> Any:
        """
        Unified join method with pandas-style interface
        
        # Arguments
        * `other` - The table to join with
        * `on` - Column name(s) to join on. Can be:
          - String: single column name (same in both tables)
          - List[str]: multiple column names (same in both tables)
          - Dict: {"left": "col1", "right": "col2"} for different column names
          - Dict: {"left": ["col1", "col2"], "right": ["col3", "col4"]} for multiple different columns
        * `how` - Join type: "inner", "left", "right", "outer"
        
        # Examples
        ```python
        # Simple inner join on same column name
        result = table1.join(table2, on="id", how="inner")
        
        # Left join on different column names  
        result = table1.join(table2, on={"left": "user_id", "right": "id"}, how="left")
        
        # Multi-column join
        result = table1.join(table2, on=["key1", "key2"], how="outer")
        ```
        """
        ...

    def median(self, *args, **kwargs) -> Any:
        """
        Calculate median for a specific column
        
        # Arguments
        * `column` - Column name to analyze
        
        # Returns
        Median value as f64
        
        # Examples
        ```python
        # Get median of age column
        median_age = table.median("age")
        ```
        """
        ...

    def melt(self, *args, **kwargs) -> Any:
        """
        Melt operation for data unpivoting (pandas-style melt)
        
        # Arguments
        * `id_vars` - Column(s) to use as identifier variables
        * `value_vars` - Column(s) to unpivot (if None, uses all columns except id_vars)
        * `var_name` - Name for the variable column (default: "variable")
        * `value_name` - Name for the value column (default: "value")
        
        # Returns
        Unpivoted table in long format
        
        # Examples
        ```python
        # Basic melt
        melted = table.melt(["id"], ["col1", "col2"])
        
        # Custom column names
        melted = table.melt(["id"], ["col1", "col2"], "metric", "score")
        ```
        """
        ...

    def nlargest(self, *args, **kwargs) -> Any:
        """
        Get the N largest values in a column (pandas-style nlargest)
        
        # Arguments
        * `n` - Number of largest values to return
        * `column_name` - Name of the column to sort by
        
        # Returns
        New table with the N rows having the largest values in the specified column
        
        # Examples
        ```python
        top_5_salaries = table.nlargest(5, "salary")
        ```
        """
        ...

    def notna(self, *args, **kwargs) -> Any:
        """
        Detect non-missing values in the entire table
        Returns a new table of the same shape with boolean values indicating non-null positions
        Similar to pandas DataFrame.notna()
        """
        ...

    def nsmallest(self, *args, **kwargs) -> Any:
        """
        Get the N smallest values in a column (pandas-style nsmallest)
        
        # Arguments
        * `n` - Number of smallest values to return
        * `column_name` - Name of the column to sort by
        
        # Returns
        New table with the N rows having the smallest values in the specified column
        
        # Examples
        ```python
        bottom_5_salaries = table.nsmallest(5, "salary")
        ```
        """
        ...

    def null_counts(self, *args, **kwargs) -> Any:
        """
        Count null values in each column
        Returns a dictionary with column names and their null counts
        """
        ...

    def parse_join_on(self, *args, **kwargs) -> Any:
        """
        Parse the 'on' parameter for join operations
        """
        ...

    def pct_change(self, *args, **kwargs) -> Any:
        """
        Percentage change operation on a specific column
        
        # Arguments
        * `column` - Column name to compute percentage change for
        * `periods` - Number of periods to use for comparison (default: 1)
        
        # Returns
        BaseArray with percentage change values
        """
        ...

    def percentile(self, *args, **kwargs) -> Any:
        """
        Compute percentile for a specific column
        
        # Arguments
        * `column` - Column name to analyze
        * `percentile` - Percentile to compute (0.0 to 100.0)
        * `interpolation` - Method for interpolation
        
        # Examples
        ```python
        # Get median (50th percentile)
        median = table.percentile("sales", 50.0, "linear")
        ```
        """
        ...

    def percentiles(self, *args, **kwargs) -> Any:
        """
        Compute multiple percentiles for a specific column
        """
        ...

    def pivot_table(self, *args, **kwargs) -> Any:
        """
        Create a pivot table for data reshaping (pandas-style pivot_table)
        
        # Arguments
        * `index` - Column(s) to use as index for the pivot table
        * `columns` - Column to spread into new columns
        * `values` - Column to aggregate
        * `aggfunc` - Aggregation function ("mean", "sum", "count", etc.)
        
        # Returns
        Reshaped table with index as rows and unique values from columns as columns
        
        # Examples
        ```python
        # Create pivot table showing average salary by department and level
        pivot = table.pivot_table(["dept"], "level", "salary", "mean")
        
        # Multi-index pivot
        pivot = table.pivot_table(["dept", "team"], "level", "salary", "sum")
        ```
        """
        ...

    def profile(self, *args, **kwargs) -> Any:
        """
        Comprehensive data profiling and quality assessment
        
        # Returns
        BaseTable containing detailed statistics and quality metrics for each column
        """
        ...

    def quantile(self, *args, **kwargs) -> Any:
        """
        Drop rows at specified indices (pandas-style drop)
        
        # Arguments
        * `indices` - List of row indices to remove
        
        # Returns
        New table with specified rows removed
        
        # Examples
        ```python
        # Remove rows at indices 0, 2, and 5
        new_table = table.drop_rows([0, 2, 5])
        ```
        Compute quantile for a specific column (pandas-style quantile)
        
        # Arguments
        * `column` - Column name to analyze
        * `q` - Quantile to compute (0.0 to 1.0)
        * `interpolation` - Method for interpolation ("linear", "lower", "higher", "midpoint", "nearest")
        
        # Returns
        AttrValue containing the computed quantile
        
        # Examples
        ```python
        # Get median (50th percentile) of sales column
        median = table.quantile("sales", 0.5, "linear")
        
        # Get 95th percentile with nearest interpolation
        p95 = table.quantile("price", 0.95, "nearest")
        ```
        """
        ...

    def quantiles(self, *args, **kwargs) -> Any:
        """
        Compute multiple quantiles for a specific column
        
        # Arguments
        * `column` - Column name to analyze
        * `quantiles` - List of quantiles to compute (each 0.0 to 1.0)
        * `interpolation` - Method for interpolation
        
        # Returns
        BaseArray containing the computed quantiles
        """
        ...

    def query(self, *args, **kwargs) -> Any:
        """
        Pandas-style query method for string-based filtering
        
        # Arguments
        * `expr` - String expression to evaluate (uses enhanced filter syntax)
        
        # Returns
        New table with rows matching the query expression
        
        # Examples
        ```python
        result = table.query("age > 25 AND department == Engineering")
        result = table.query("salary BETWEEN 50000 AND 100000")
        result = table.query("name LIKE A%")
        result = table.query("department IN [Engineering, Marketing]")
        ```
        """
        ...

    def rename(self, *args, **kwargs) -> Any:
        """
        Rename columns using a dictionary mapping
        
        # Arguments
        * `columns` - Dictionary mapping old column names to new column names
        
        # Examples
        ```python
        renamed = table.rename({"old_name": "new_name", "score": "final_score"})
        ```
        """
        ...

    def reorder_columns(self, *args, **kwargs) -> Any:
        """
        Reorder columns according to specified order
        
        # Arguments
        * `new_order` - List of column names in the desired order
        
        # Examples
        ```python
        reordered = table.reorder_columns(["name", "age", "score"])
        ```
        """
        ...

    def rich_display(self, *args, **kwargs) -> Any:
        """
        Get rich display representation using Rust formatter
        """
        ...

    def rolling(self, *args, **kwargs) -> Any:
        """
        Rolling window operation on a specific column
        
        # Arguments
        * `column` - Column name to apply rolling operation to
        * `window` - Window size for rolling operations
        * `operation` - Function to apply to each window (e.g., "mean", "sum", "min", "max", "std")
        
        # Returns
        BaseArray with rolling operation results
        """
        ...

    def rolling_all(self, *args, **kwargs) -> Any:
        """
        Apply rolling window operations to all numeric columns
        
        # Arguments
        * `window` - Window size for rolling operations
        * `operation` - Function to apply to each window
        
        # Returns
        New table with rolling operations applied to all numeric columns
        """
        ...

    def sample(self, *args, **kwargs) -> Any:
        """
        Comprehensive random sampling method
        
        # Parameters
        - `n`: Number of rows to sample (mutually exclusive with `fraction`)
        - `fraction`: Fraction of rows to sample (0.0 to 1.0, mutually exclusive with `n`)
        - `weights`: Optional weights for each row (must match table length)
        - `subset`: Optional subset of columns to consider for sampling
        - `class_weights`: Optional mapping of column values to weights for stratified sampling
        - `replace`: Whether to sample with replacement (default: false)
        
        # Examples
        ```python
        # Sample 10 rows
        sample = table.sample(n=10)
        
        # Sample 20% of rows
        sample = table.sample(fraction=0.2)
        
        # Weighted sampling with replacement
        weights = [1.0, 2.0, 1.0, 3.0]  # Higher weight for certain rows
        sample = table.sample(n=5, weights=weights, replace=True)
        
        # Stratified sampling by 'category' column
        class_weights = {"category": [("A", 2.0), ("B", 1.0), ("C", 3.0)]}
        sample = table.sample(n=10, class_weights=class_weights)
        
        # Focus on complete rows in subset of columns
        sample = table.sample(n=20, subset=["age", "income"])
        ```
        """
        ...

    def select(self, *args, **kwargs) -> Any:
        """
        Select specific columns to create a new table
        
        Args:
            columns: List of column names to select
        
        Returns:
            PyBaseTable: A new table with only the selected columns
        """
        ...

    def set_column(self, *args, **kwargs) -> Any:
        """
        Set an entire column with new values
        
        Args:
            column_name: Name of the column to set
            values: List of new values for the column
            
        Example:
            table.set_column("score", [95, 87, 92, 88])
        """
        ...

    def set_value(self, *args, **kwargs) -> Any:
        """
        Set a single value at a specific row and column
        
        Args:
            row: Row index (0-based)
            column_name: Name of the column
            value: New value to set
            
        Example:
            table.set_value(0, "name", "Alice Updated")
        """
        ...

    def set_values_by_mask(self, *args, **kwargs) -> Any:
        """
        Set values for multiple rows in a column using a boolean mask
        
        Args:
            mask: List of booleans indicating which rows to update
            column_name: Name of the column to update
            value: Value to set for all masked rows
            
        Example:
            table.set_values_by_mask([True, False, True], "flag", "updated")
        """
        ...

    def set_values_by_range(self, *args, **kwargs) -> Any:
        """
        Set values for a range of rows in a column
        
        Args:
            start: Starting row index (inclusive)
            end: Ending row index (exclusive)
            step: Step size (default 1 for consecutive rows)
            column_name: Name of the column to update
            value: Value to set for all rows in the range
            
        Example:
            table.set_values_by_range(10, 20, 1, "score", 0.0)  # rows 10-19
            table.set_values_by_range(0, 10, 2, "flag", True)   # rows 0,2,4,6,8
        """
        ...

    def shift(self, *args, **kwargs) -> Any:
        """
        Shift operation on a specific column
        
        # Arguments
        * `column` - Column name to shift
        * `periods` - Number of periods to shift (positive = shift right, negative = shift left)
        * `fill_value` - Value to use for filling gaps (default: Null)
        
        # Returns
        BaseArray with shifted values
        """
        ...

    def slice(self, *args, **kwargs) -> Any:
        """
        Get a slice of rows [start, end)
        
        Args:
            start: Starting row index (inclusive)
            end: Ending row index (exclusive)
        
        Returns:
            PyBaseTable: A new table with the specified row slice
        """
        ...

    def sort_by(self, *args, **kwargs) -> Any:
        """
        Sort table by column
        
        Args:
            column: Name of the column to sort by
            ascending: If True, sort in ascending order; if False, descending
        
        Returns:
            PyBaseTable: A new sorted table
        """
        ...

    def sort_values(self, *args, **kwargs) -> Any:
        """
        Sort table by multiple columns with mixed ascending/descending order
        Pandas-style multi-column sorting with priority order
        
        Args:
            columns: List of column names to sort by (in priority order)
            ascending: List of booleans for sort direction per column.
                      If single bool, applies to all columns.
                      If list, must match length of columns.
        
        Returns:
            PyBaseTable: A new sorted table
        
        Examples:
            # Sort by department ascending, then salary descending
            sorted_table = table.sort_values(['department', 'salary'], [True, False])
        
            # Sort by all columns ascending
            sorted_table = table.sort_values(['col1', 'col2'], True)
        """
        ...

    def std(self, *args, **kwargs) -> Any:
        """
        Calculate standard deviation for a specific column
        
        # Arguments
        * `column` - Column name to analyze
        
        # Returns
        Standard deviation as f64
        
        # Examples
        ```python
        # Get standard deviation of scores column
        std_scores = table.std("scores")
        ```
        """
        ...

    def tail(self, *args, **kwargs) -> Any:
        """
        Get last n rows (default 5)
        """
        ...

    def to_csv(self, *args, **kwargs) -> Any:
        """
        Export BaseTable to CSV file
        """
        ...

    def to_edges_table(self, *args, **kwargs) -> Any:
        """
        Convert BaseTable to EdgesTable.
        
        Args:
            source_id_column: Name of column containing source node IDs
            target_id_column: Name of column containing target node IDs
            edge_id_column: Optional name of column containing edge IDs
        
        Returns:
            EdgesTable: New EdgesTable with same data
        
        Example:
            >>> base_table = gr.table({
            ...     "source": [1, 2],
            ...     "target": [2, 3],
            ...     "weight": [0.5, 1.0]
            ... })
            >>> edges_table = base_table.to_edges_table("source", "target")
        """
        ...

    def to_json(self, *args, **kwargs) -> Any:
        """
        Export BaseTable to JSON file
        """
        ...

    def to_nodes_table(self, *args, **kwargs) -> Any:
        """
        Convert BaseTable to NodesTable.
        
        Args:
            node_id_column: Name of column containing node IDs
        
        Returns:
            NodesTable: New NodesTable with same data
        
        Example:
            >>> base_table = gr.table({"node_id": [1, 2], "name": ["A", "B"]})
            >>> nodes_table = base_table.to_nodes_table("node_id")
        """
        ...

    def to_pandas(self, *args, **kwargs) -> Any:
        """
        Convert to pandas DataFrame
        """
        ...

    def to_parquet(self, *args, **kwargs) -> Any:
        """
        Export BaseTable to Parquet file
        """
        ...

    def to_type(self, *args, **kwargs) -> Any:
        """
        Convert table columns to specified type
        
        Returns a copy of the table with all numeric columns converted to the specified type.
        Non-numeric columns are left unchanged.
        
        Example:
        ```python
        # Convert all numeric columns to float64
        float_table = table.to_type("float64")
        ```
        """
        ...

    def union(self, *args, **kwargs) -> Any:
        """
        Union with another table (removes duplicates)
        
        # Arguments
        * `other` - The table to union with
        
        # Examples
        ```python
        # Combine two tables with same schema
        combined = table1.union(table2)
        ```
        """
        ...

    def validate_schema(self, *args, **kwargs) -> Any:
        """
        Validate table schema against expected schema
        
        # Arguments
        * `expected_columns` - Dictionary mapping column names to expected data types
        
        # Returns
        BaseTable with validation results
        """
        ...

    def value_counts(self, *args, **kwargs) -> Any:
        """
        Count the frequency of unique values in a column (pandas-style value_counts)
        
        # Arguments
        * `column` - Column name to analyze
        * `sort` - Whether to sort results by count (default: true)
        * `ascending` - Sort order when sort=true (default: false, most frequent first)
        * `dropna` - Whether to exclude null values (default: true)
        
        # Returns
        Table with 'value' and 'count' columns showing frequency of each unique value
        
        # Examples
        ```python
        # Basic usage
        counts = table.value_counts("category")
        
        # Custom sorting
        counts = table.value_counts("category", sort=True, ascending=True)
        
        # Include null values
        counts = table.value_counts("category", dropna=False)
        ```
        """
        ...

    def var(self, *args, **kwargs) -> Any:
        """
        Calculate variance for a specific column
        
        # Arguments
        * `column` - Column name to analyze
        
        # Returns
        Variance as f64
        
        # Examples
        ```python
        # Get variance of prices column
        var_prices = table.var("prices")
        ```
        """
        ...


class BranchInfo:
    """
    Python wrapper for branch information
    """
    @property
    def head(self) -> Any:
        ...

    @property
    def is_current(self) -> Any:
        ...

    @property
    def name(self) -> Any:
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...


class Commit:
    """
    Python wrapper for commit information
    """
    @property
    def author(self) -> Any:
        ...

    @property
    def id(self) -> Any:
        ...

    @property
    def message(self) -> Any:
        ...

    @property
    def parents(self) -> Any:
        ...

    @property
    def timestamp(self) -> Any:
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...


class ComponentSubgraph:
    """
    Python wrapper for ComponentSubgraph - Pure delegation to existing traits
    """
    @property
    def component_id(self) -> Any:
        ...

    @property
    def component_size(self) -> Any:
        ...

    @property
    def edge_count(self) -> Any:
        ...

    @property
    def is_largest_component(self) -> Any:
        ...

    @property
    def node_count(self) -> Any:
        ...

    @property
    def total_components(self) -> Any:
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def contains_edge(self, *args, **kwargs) -> Any:
        ...

    def contains_node(self, *args, **kwargs) -> Any:
        ...

    def edge_ids(self, *args, **kwargs) -> Any:
        ...

    def node_ids(self, *args, **kwargs) -> Any:
        ...


class ComponentsArray:
    """
    Lazy array of connected components - avoids creating hundreds of PySubgraphs immediately
    """
    @property
    def viz(self) -> Any:
        """
        Get viz accessor for visualization
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __iter__(self) -> Iterator:
        """
        Implement iter(self).
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def collapse(self, *args, **kwargs) -> Any:
        """
        Collapse each component into a meta-node using the Subgraph collapse API.
        """
        ...

    def filter(self, *args, **kwargs) -> Any:
        """
        Direct delegation: Apply filter to components
        """
        ...

    def largest_component(self, *args, **kwargs) -> Any:
        """
        Get largest component without materializing others
        """
        ...

    def neighborhood(self, *args, **kwargs) -> Any:
        """
        Direct delegation: Apply neighborhood() to each component and return PySubgraphArray
        """
        ...

    def sample(self, *args, **kwargs) -> Any:
        """
        Direct delegation: Apply sample(k) to each component and return PySubgraphArray
        """
        ...

    def sizes(self, *args, **kwargs) -> Any:
        """
        Get component sizes without materializing subgraphs
        """
        ...

    def table(self, *args, **kwargs) -> Any:
        """
        Direct delegation: Apply table() to each component and return PyTableArray
        """
        ...

    def to_list(self, *args, **kwargs) -> Any:
        """
        Convert to regular Python list (materializes all components)
        """
        ...


class ComposerPreview:
    """
    Python wrapper for ComposerPreview
    """
    @property
    def edge_strategy(self) -> Any:
        """
        Get the edge strategy
        """
        ...

    @property
    def entity_type(self) -> Any:
        """
        Get the entity type
        """
        ...

    @property
    def meta_edges_count(self) -> Any:
        """
        Get estimated number of meta-edges
        """
        ...

    @property
    def meta_node_attributes(self) -> Any:
        """
        Get the meta-node attributes that will be created
        """
        ...

    @property
    def will_include_edge_count(self) -> Any:
        """
        Whether edge count will be included
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...


class DisplayConfig:
    """
    Python wrapper for DisplayConfig
    """
    @property
    def max_cols(self) -> Any:
        """
        Get max_cols setting
        """
        ...

    @property
    def max_rows(self) -> Any:
        """
        Get max_rows setting
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def default(self, *args, **kwargs) -> Any:
        """
        Create DisplayConfig with default values
        """
        ...


class Edge:
    """
    Python wrapper for a regular graph edge
    
    Regular edges are the basic connections between nodes in graphs. They provide access
    to edge attributes, topology information (source/target), and graph operations.
    """
    @property
    def entity_type(self) -> Any:
        """
        Get the entity type for this edge
        
        # Returns
        The string "edge"
        """
        ...

    @property
    def id(self) -> Any:
        """
        Get the edge ID
        
        # Returns
        The unique EdgeId for this edge
        """
        ...

    @property
    def is_active(self) -> Any:
        """
        Check if this edge is currently active
        
        # Returns
        True if the edge is active in the graph
        """
        ...

    @property
    def source(self) -> Any:
        """
        Get the edge's source node ID
        
        # Returns
        The NodeId of the source node
        
        # Raises
        * `RuntimeError` - If there's an error getting the source
        """
        ...

    @property
    def target(self) -> Any:
        """
        Get the edge's target node ID
        
        # Returns
        The NodeId of the target node
        
        # Raises
        * `RuntimeError` - If there's an error getting the target
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __setitem__(self, key: Any, value: Any) -> None:
        """
        Set self[key] to value.
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def keys(self, *args, **kwargs) -> Any:
        """
        Get all attribute keys for this edge
        
        # Returns
        List of attribute names
        
        # Raises
        * `RuntimeError` - If there's an error accessing attributes
        """
        ...

    def summary(self, *args, **kwargs) -> Any:
        """
        Get a summary of this edge
        
        # Returns
        A human-readable summary string
        """
        ...

    def values(self, *args, **kwargs) -> Any:
        """
        Get all attribute values for this edge
        
        # Arguments
        * `py` - Python interpreter instance
        
        # Returns
        List of attribute values
        
        # Raises
        * `RuntimeError` - If there's an error accessing attributes
        """
        ...


class EdgeFilter:
    """
    Python wrapper for EdgeFilter
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def and_filters(self, *args, **kwargs) -> Any:
        ...

    def attribute_equals(self, *args, **kwargs) -> Any:
        ...

    def attribute_filter(self, *args, **kwargs) -> Any:
        ...

    def connects_any(self, *args, **kwargs) -> Any:
        ...

    def connects_nodes(self, *args, **kwargs) -> Any:
        ...

    def has_attribute(self, *args, **kwargs) -> Any:
        ...

    def not_filter(self, *args, **kwargs) -> Any:
        ...

    def or_filters(self, *args, **kwargs) -> Any:
        ...

    def source_attribute_equals(self, *args, **kwargs) -> Any:
        """
        Filter edges where the source node has a specific attribute value
        """
        ...

    def source_or_target_attribute_equals(self, *args, **kwargs) -> Any:
        """
        Filter edges where source OR target node has the specified attribute value
        This addresses the user's complaint about complex OR conditions
        """
        ...

    def source_or_target_attribute_in(self, *args, **kwargs) -> Any:
        """
        Filter edges where source OR target node attribute matches any of the provided values
        This makes the "contains an attribute as either the target or source" use case much simpler
        """
        ...

    def target_attribute_equals(self, *args, **kwargs) -> Any:
        """
        Filter edges where the target node has a specific attribute value
        """
        ...


class EdgeStrategy:
    """
    Python wrapper for EdgeStrategy
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def aggregate(self, *args, **kwargs) -> Any:
        """
        Create aggregate strategy (default)
        """
        ...

    def contract_all(self, *args, **kwargs) -> Any:
        """
        Create contract_all strategy
        """
        ...

    def drop_all(self, *args, **kwargs) -> Any:
        """
        Create drop_all strategy
        """
        ...

    def keep_external(self, *args, **kwargs) -> Any:
        """
        Create keep_external strategy  
        """
        ...


class EdgesAccessor:
    """
    Wrapper for g.edges that supports indexing syntax: g.edges[id] -> EdgeView  
    """
    @property
    def attributes(self) -> Any:
        """
        Get all unique attribute names across all edges
        """
        ...

    @property
    def base(self) -> Any:
        """
        Get filtered accessor for base edges (non-meta edges)
        
        Returns a new EdgesAccessor that only shows edges where entity_type != 'meta'
        
        Example:
            base_edges = g.edges.base
            base_count = len(base_edges)  
            base_table = base_edges.table()
        """
        ...

    @property
    def meta(self) -> Any:
        """
        Get filtered accessor for meta-edges
        
        Returns a new EdgesAccessor that only shows edges where entity_type == 'meta'
        
        Example:
            meta_edges = g.edges.meta
            meta_count = len(meta_edges)
            meta_table = meta_edges.table()
        """
        ...

    @property
    def sources(self) -> NumArray:
        """
        Get source node IDs for all edges
        Returns a NumArray parallel to edge_ids where each element is the source of the corresponding edge
        """
        ...

    @property
    def targets(self) -> NumArray:
        """
        Get target node IDs for all edges  
        Returns a NumArray parallel to edge_ids where each element is the target of the corresponding edge
        """
        ...

    @property
    def viz(self) -> Any:
        """
        Get viz accessor for visualization operations
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __iter__(self) -> Iterator:
        """
        Implement iter(self).
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __setitem__(self, key: Any, value: Any) -> None:
        """
        Set self[key] to value.
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def all(self, *args, **kwargs) -> Subgraph:
        """
        Get all edges as a subgraph (equivalent to g.edges[:]) - DELEGATED to SubgraphOperations
        Returns a subgraph containing all nodes that are connected by the edges and all edges
        """
        ...

    def array(self, *args, **kwargs) -> EdgesArray:
        """
        Create an EdgesArray for delegation chains
        Implements: g.edges.array()
        """
        ...

    def attribute_names(self, *args, **kwargs) -> Any:
        """
        List attribute names available within this accessor's edge set
        """
        ...

    def filter(self, *args, **kwargs) -> Any:
        """
        Filter edges using the same syntax as graph.filter_edges and return a subgraph
        """
        ...

    def group_by(self, *args, **kwargs) -> Any:
        """
        Group edges by attribute value, returning SubgraphArray
        
        Args:
            attr_name: Name of the edge attribute to group by
        
        Returns:
            SubgraphArray: Array of subgraphs, one for each unique attribute value
        
        Example:
            type_groups = g.edges.group_by('interaction_type')
            # Returns subgraphs for each interaction type
        """
        ...

    def ids(self, *args, **kwargs) -> NumArray:
        """
        Get edge IDs as a NumArray for numerical operations
        Implements: g.edges.ids()
        """
        ...

    def matrix(self, *args, **kwargs) -> Any:
        """
        Convert edge attributes to matrix
        Implements: g.edges.matrix()
        """
        ...

    def set_attrs(self, *args, **kwargs) -> Any:
        """
        Set attributes for multiple edges (bulk operation)
        Supports the same formats as the main graph: edge-centric, column-centric, etc.
        """
        ...

    def table(self, *args, **kwargs) -> Any:
        """
        Get an EdgesTable representation of accessible edges
        Implements: g.edges.table()  
        """
        ...

    def weight_matrix(self, *args, **kwargs) -> Any:
        """
        Edge weight matrix (source × target with weights)
        Default to 'weight' attribute, but allow custom attribute selection
        Implements: g.edges.weight_matrix() and g.edges.weight_matrix('strength')
        """
        ...


class EdgesArray:
    """
    EdgesArray: Collection of EdgesAccessor objects with delegation to BaseArray
    Provides basic array operations and graph-specific transformations
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def contains(self, *args, **kwargs) -> Any:
        """
        Check if the array contains a specific EdgesAccessor
        """
        ...

    def filter(self, *args, **kwargs) -> EdgesArray:
        """
        Filter EdgesAccessor objects using a Python predicate function
        """
        ...

    def filter_by_size(self, *args, **kwargs) -> Any:
        """
        Filter EdgesAccessor objects by edge count threshold
        """
        ...

    def filter_by_weight(self, *args, **kwargs) -> Any:
        """
        Filter EdgesAccessor objects by weight threshold (if edges have weights)
        """
        ...

    def first(self, *args, **kwargs) -> Any:
        """
        Get the first EdgesAccessor
        """
        ...

    def interactive(self, *args, **kwargs) -> Any:
        """
        Launch interactive visualization for this EdgesArray
        
        Converts the EdgesArray to a table view and launches visualization
        
        # Arguments
        * `port` - Optional port number (0 for auto-assign)
        * `layout` - Layout algorithm: \"force-directed\", \"circular\", \"grid\", \"hierarchical\"
        * `theme` - Visual theme: \"light\", \"dark\", \"publication\", \"minimal\"
        * `width` - Canvas width in pixels
        * `height` - Canvas height in pixels
        
        # Returns
        VizAccessor for launching interactive visualization
        """
        ...

    def is_empty(self, *args, **kwargs) -> Any:
        """
        Check if the array is empty
        """
        ...

    def iter(self, *args, **kwargs) -> Any:
        """
        Create an iterator for method chaining
        """
        ...

    def last(self, *args, **kwargs) -> Any:
        """
        Get the last EdgesAccessor
        """
        ...

    def nodes(self, *args, **kwargs) -> Any:
        """
        Get source and target nodes from all EdgesAccessor objects
        """
        ...

    def stats(self, *args, **kwargs) -> Any:
        """
        Get statistics about the EdgesAccessor collection
        """
        ...

    def table(self, *args, **kwargs) -> Any:
        """
        Apply table() to each EdgesAccessor in the array
        """
        ...

    def to_list(self, *args, **kwargs) -> Any:
        """
        Convert to Python list
        """
        ...

    def total_edge_count(self, *args, **kwargs) -> Any:
        """
        Get total edge count across all EdgesAccessor objects
        """
        ...

    def union(self, *args, **kwargs) -> Any:
        """
        Combine all EdgesAccessor objects into a single unified EdgesAccessor
        """
        ...


class EdgesArrayIterator:
    """
    Iterator for EdgesArray that enables method chaining
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def collect(self, *args, **kwargs) -> Any:
        """
        Collect the iterator back into an EdgesArray
        """
        ...

    def filter(self, *args, **kwargs) -> Any:
        """
        Filter the iterator using a Python predicate function
        """
        ...

    def filter_by_weight(self, *args, **kwargs) -> Any:
        """
        Filter by weight threshold
        """
        ...

    def nodes(self, *args, **kwargs) -> Any:
        """
        Get nodes from each EdgesAccessor in the iterator
        """
        ...

    def table(self, *args, **kwargs) -> Any:
        """
        Apply table() to each EdgesAccessor in the iterator
        """
        ...


class EdgesTable:
    """
    Python wrapper for EdgesTable
    """
    @property
    def viz(self) -> Any:
        """
        Get viz accessor for visualization operations (no graph tab)
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __iter__(self) -> Iterator:
        """
        Implement iter(self).
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def as_tuples(self, *args, **kwargs) -> Any:
        """
        Get edges as tuples (edge_id, source, target)
        """
        ...

    def auto_assign_edge_ids(self, *args, **kwargs) -> Any:
        """
        Auto-assign edge IDs for null values (useful for meta nodes)
        """
        ...

    def base_table(self, *args, **kwargs) -> Any:
        """
        Get reference to underlying BaseTable
        """
        ...

    def drop_columns(self, *args, **kwargs) -> Any:
        """
        Drop columns from the table (cannot drop edge_id, source, or target)
        
        Args:
            columns: List of column names to drop
        
        Returns:
            PyEdgesTable: A new table without the specified columns
        """
        ...

    def edge_ids(self, *args, **kwargs) -> Any:
        """
        Get edge IDs
        """
        ...

    def filter(self, *args, **kwargs) -> Any:
        """
        Filter rows using a query expression or Python function
        
        Args:
            predicate: Either a string query expression (e.g. "weight > 0.5") or a Python function
        
        Returns:
            PyEdgesTable: A new table with filtered rows
        """
        ...

    def filter_by_attr(self, *args, **kwargs) -> Any:
        """
        Filter edges by attribute value
        """
        ...

    def filter_by_sources(self, *args, **kwargs) -> Any:
        """
        Filter edges by source nodes
        """
        ...

    def filter_by_targets(self, *args, **kwargs) -> Any:
        """
        Filter edges by target nodes
        """
        ...

    def from_csv(self, *args, **kwargs) -> Any:
        """
        Import EdgesTable from CSV file (must contain edge_id, source, target columns)
        """
        ...

    def from_dict(self, *args, **kwargs) -> Any:
        """
        Create EdgesTable from a Python dictionary (must contain 'edge_id', 'source', 'target' columns)
        """
        ...

    def from_json(self, *args, **kwargs) -> Any:
        """
        Import EdgesTable from JSON file (must contain edge_id, source, target columns)
        """
        ...

    def from_parquet(self, *args, **kwargs) -> Any:
        """
        Import EdgesTable from Parquet file (must contain edge_id, source, target columns)
        """
        ...

    def group_by(self, *args, **kwargs) -> Any:
        """
        Group by columns and return grouped tables
        
        Args:
            columns: List of column names to group by
        
        Returns:
            PyEdgesTableArray: Array-like container holding the grouped edge tables
        """
        ...

    def head(self, *args, **kwargs) -> Any:
        """
        Get first n rows (default 5)
        """
        ...

    def interactive(self, *args, **kwargs) -> Any:
        """
        Launch interactive streaming table view in browser
        
        Returns the URL where the interactive table can be viewed.
        The table will be available for real-time exploration with virtual scrolling,
        filtering, and other interactive features.
        
        Returns:
            str: URL of the interactive table interface
        """
        ...

    def interactive_embed(self, *args, **kwargs) -> Any:
        """
        Generate embedded iframe HTML for Jupyter notebooks
        
        Creates an interactive streaming edges table that can be embedded directly
        in a Jupyter notebook cell, eliminating the need for a separate browser tab.
        
        Returns:
            str: HTML iframe code for embedding in Jupyter
        """
        ...

    def interactive_viz(self, *args, **kwargs) -> Any:
        """
        Launch interactive visualization for this EdgesTable (new visualization system)
        
        # Arguments
        * `port` - Optional port number (0 for auto-assign)
        * `layout` - Layout algorithm: \"force-directed\", \"circular\", \"grid\", \"hierarchical\"
        * `theme` - Visual theme: \"light\", \"dark\", \"publication\", \"minimal\"
        * `width` - Canvas width in pixels
        * `height` - Canvas height in pixels
        
        # Returns
        VizAccessor for launching interactive visualization
        """
        ...

    def into_base_table(self, *args, **kwargs) -> Any:
        """
        Convert to BaseTable (loses edge-specific typing)
        """
        ...

    def iter(self, *args, **kwargs) -> Any:
        """
        Explicit row iterator matching the Python iteration protocol.
        """
        ...

    def ncols(self, *args, **kwargs) -> Any:
        """
        Get number of columns
        """
        ...

    def nrows(self, *args, **kwargs) -> Any:
        """
        Get number of rows
        """
        ...

    def rich_display(self, *args, **kwargs) -> Any:
        """
        Get rich display representation with EdgesTable type
        """
        ...

    def select(self, *args, **kwargs) -> Any:
        """
        Select specific columns to create a new table
        
        Args:
            columns: List of column names to select
        
        Returns:
            PyEdgesTable: A new table with only the selected columns
        """
        ...

    def shape(self, *args, **kwargs) -> Any:
        """
        Get shape as (rows, cols)
        """
        ...

    def slice(self, *args, **kwargs) -> Any:
        """
        Get a slice of rows [start, end)
        
        Args:
            start: Starting row index (inclusive)
            end: Ending row index (exclusive)
        
        Returns:
            PyEdgesTable: A new table with the specified row slice
        """
        ...

    def sort_by(self, *args, **kwargs) -> Any:
        """
        Sort table by column
        
        Args:
            column: Name of the column to sort by
            ascending: If True, sort in ascending order; if False, descending
        
        Returns:
            PyEdgesTable: A new sorted table
        """
        ...

    def sort_values(self, *args, **kwargs) -> Any:
        """
        Sort table by multiple columns with mixed ascending/descending order
        Pandas-style multi-column sorting with priority order
        
        Args:
            columns: List of column names to sort by (in priority order)
            ascending: List of booleans for sort direction per column.
                      If single bool, applies to all columns.
                      If list, must match length of columns.
        
        Returns:
            PyEdgesTable: A new sorted table
        """
        ...

    def sources(self, *args, **kwargs) -> Any:
        """
        Get source node IDs
        """
        ...

    def tail(self, *args, **kwargs) -> Any:
        """
        Get last n rows (default 5)
        """
        ...

    def targets(self, *args, **kwargs) -> Any:
        """
        Get target node IDs  
        """
        ...

    def to_csv(self, *args, **kwargs) -> Any:
        """
        Export EdgesTable to CSV file
        """
        ...

    def to_json(self, *args, **kwargs) -> Any:
        """
        Export EdgesTable to JSON file
        """
        ...

    def to_pandas(self, *args, **kwargs) -> Any:
        """
        Convert to pandas DataFrame
        """
        ...

    def to_parquet(self, *args, **kwargs) -> Any:
        """
        Export EdgesTable to Parquet file
        """
        ...

    def unique_attr_values(self, *args, **kwargs) -> Any:
        """
        Get unique values for an attribute
        """
        ...


class Graph:
    """
    Python wrapper for the main Graph
    """
    @property
    def edge_ids(self) -> NumArray:
        """
        Get all active edge IDs as IntArray  
        """
        ...

    @property
    def edges(self) -> EdgesAccessor:
        """
        Get edges accessor for fluent API (g.edges property)
        """
        ...

    @property
    def is_directed(self) -> Any:
        """
        Check if this graph is directed
        """
        ...

    @property
    def is_undirected(self) -> Any:
        """
        Check if this graph is undirected
        """
        ...

    @property
    def node_ids(self) -> NumArray:
        """
        Get all active node IDs as IntArray
        """
        ...

    @property
    def nodes(self) -> NodesAccessor:
        """
        Get nodes accessor for fluent API (g.nodes property)
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def add_edge(self, *args, **kwargs) -> Any:
        """
        Add a single edge to the graph with support for string IDs and attributes
        """
        ...

    def add_edges(self, *args, **kwargs) -> Any:
        """
        Add multiple edges at once
        """
        ...

    def add_graph(self, *args, **kwargs) -> Any:
        """
        Add another graph to this graph (merge nodes and edges)
        
        All nodes and edges from the other graph will be added to this graph.
        Node and edge IDs may be remapped to avoid conflicts.
        Attributes are preserved during the merge.
        """
        ...

    def add_node(self, *args, **kwargs) -> Any:
        ...

    def add_nodes(self, *args, **kwargs) -> Any:
        ...

    def adjacency_list(self, *args, **kwargs) -> Any:
        """
        Get adjacency list (not yet implemented).
        """
        ...

    def aggregate(self, *args, **kwargs) -> Any:
        """
        Aggregate attribute values across nodes or edges
        """
        ...

    def all_edge_attribute_names(self, *args, **kwargs) -> Any:
        """
        Get all unique edge attribute names across the entire graph
        """
        ...

    def all_node_attribute_names(self, *args, **kwargs) -> Any:
        """
        Get all unique node attribute names across the entire graph
        """
        ...

    def bfs(self, *args, **kwargs) -> Any:
        """
        BFS traversal - delegates to PyGraphAnalysis helper
        """
        ...

    def branches(self, *args, **kwargs) -> Any:
        """
        List all branches (FFI wrapper around core history system)
        """
        ...

    def calculate_similarity(self, *args, **kwargs) -> Any:
        """
        Calculate similarity - delegates via Python.
        """
        ...

    def checkout_branch(self, *args, **kwargs) -> Any:
        """
        Checkout a branch (FFI wrapper around core history system)
        """
        ...

    def child_meta_nodes(self, *args, **kwargs) -> Any:
        """
        Get child meta-nodes - delegates via Python.
        """
        ...

    def clustering_coefficient(self, *args, **kwargs) -> Any:
        """
        Calculate clustering coefficient (not yet implemented in core).
        """
        ...

    def collapse(self, *args, **kwargs) -> Any:
        """
        Collapse subgraph - delegates via Python.
        """
        ...

    def commit(self, *args, **kwargs) -> Any:
        """
        Commit current state of the graph (FFI wrapper around core history system)
        """
        ...

    def commit_history(self, *args, **kwargs) -> Any:
        """
        Get commit history (FFI wrapper around core history system)
        """
        ...

    def connected_components(self, *args, **kwargs) -> Any:
        """
        Find connected components in the graph.
        """
        ...

    def contains_edge(self, *args, **kwargs) -> Any:
        """
        Check if edge exists - DELEGATED (same as has_edge)  
        """
        ...

    def contains_node(self, *args, **kwargs) -> Any:
        """
        Check if node exists - DELEGATED (same as has_node)
        """
        ...

    def create_branch(self, *args, **kwargs) -> Any:
        """
        Create a new branch (FFI wrapper around core history system)
        """
        ...

    def degree(self, *args, **kwargs) -> Any:
        """
        Get degree for nodes - delegates via Python method call.
        """
        ...

    def density(self, *args, **kwargs) -> Any:
        """
        Calculate graph density (number of edges / number of possible edges) - PURE DELEGATION
        """
        ...

    def dfs(self, *args, **kwargs) -> Any:
        """
        DFS traversal - delegates to PyGraphAnalysis helper  
        """
        ...

    def edge_attribute_keys(self, *args, **kwargs) -> Any:
        """
        Get all attribute keys for an edge - delegates to PyGraphAttr
        """
        ...

    def edge_count(self, *args, **kwargs) -> Any:
        """
        Get the number of edges in the graph - DELEGATED
        """
        ...

    def edge_endpoints(self, *args, **kwargs) -> Any:
        ...

    def edges_table(self, *args, **kwargs) -> Any:
        """
        Get edges table - delegates via Python.
        """
        ...

    def entity_type(self, *args, **kwargs) -> Any:
        """
        Get entity type - delegates via Python.
        """
        ...

    def filter_edges(self, *args, **kwargs) -> Subgraph:
        """
        Filter edges using EdgeFilter object or string query
        
        OPTIMIZED: Direct implementation avoiding expensive view() creation overhead
        """
        ...

    def filter_nodes(self, *args, **kwargs) -> Subgraph:
        """
        Filter nodes using NodeFilter object or string query
        
        OPTIMIZED: Direct implementation avoiding expensive view() creation overhead
        """
        ...

    def get_edge_attr(self, *args, **kwargs) -> Any:
        """
        Get single edge attribute - delegates to PyGraphAttr
        """
        ...

    def get_edge_attribute(self, *args, **kwargs) -> Any:
        """
        Get edge attribute - delegates via Python.
        """
        ...

    def get_edge_attrs(self, *args, **kwargs) -> Any:
        """
        Get bulk edge attributes - delegates to PyGraphAttr
        """
        ...

    def get_node_attr(self, *args, **kwargs) -> Any:
        """
        Get single node attribute - delegates to PyGraphAttr
        """
        ...

    def get_node_attribute(self, *args, **kwargs) -> Any:
        """
        Get node attribute - delegates via Python.
        """
        ...

    def get_node_attrs(self, *args, **kwargs) -> Any:
        """
        Get bulk node attributes - delegates to PyGraphAttr
        """
        ...

    def get_node_mapping(self, *args, **kwargs) -> Any:
        """
        Get node mapping for a specific attribute (FFI wrapper around core operations)
        """
        ...

    def group_by(self, *args, **kwargs) -> Any:
        """
        Group nodes by attribute value and compute aggregates (public method for benchmarks)
        """
        ...

    def group_nodes_by_attribute(self, *args, **kwargs) -> Any:
        """
        Get analytics module for this graph
        Group nodes by attribute value and compute aggregates for each group
        """
        ...

    def has_edge(self, *args, **kwargs) -> Any:
        """
        Check if an edge exists in the graph - DELEGATED  
        """
        ...

    def has_edge_attribute(self, *args, **kwargs) -> Any:
        """
        Check if edge has specific attribute - delegates to PyGraphAttr
        """
        ...

    def has_edge_between(self, *args, **kwargs) -> Any:
        """
        Check if edge exists between nodes - delegates via Python.
        """
        ...

    def has_meta_nodes(self, *args, **kwargs) -> Any:
        """
        Check if has meta-nodes - delegates via Python.
        """
        ...

    def has_node(self, *args, **kwargs) -> Any:
        """
        Check if a node exists in the graph - DELEGATED
        """
        ...

    def has_node_attribute(self, *args, **kwargs) -> Any:
        """
        Check if node has specific attribute - delegates to PyGraphAttr
        """
        ...

    def has_path(self, *args, **kwargs) -> Any:
        """
        Check if path exists between two nodes.
        """
        ...

    def has_uncommitted_changes(self, *args, **kwargs) -> Any:
        """
        Check if there are uncommitted changes (FFI wrapper around core history system)
        """
        ...

    def hierarchy_level(self, *args, **kwargs) -> Any:
        """
        Get hierarchy level - delegates via Python.
        """
        ...

    def historical_view(self, *args, **kwargs) -> Any:
        """
        Get historical view at specific commit (FFI wrapper around core history system)
        """
        ...

    def in_degree(self, *args, **kwargs) -> Any:
        """
        Get in-degree for nodes - delegates via Python method call.
        """
        ...

    def induced_subgraph(self, *args, **kwargs) -> Any:
        """
        Create induced subgraph from list of nodes.
        """
        ...

    def intersect_with(self, *args, **kwargs) -> Any:
        """
        Intersect with another subgraph (not yet implemented).
        """
        ...

    def is_connected(self, *args, **kwargs) -> Any:
        """
        Check if the graph is connected (delegates to subgraph implementation)
        """
        ...

    def is_empty(self, *args, **kwargs) -> Any:
        """
        Check whether the graph contains any nodes or edges
        """
        ...

    def laplacian_matrix(self, *args, **kwargs) -> Any:
        """
        Get Laplacian matrix - delegates to PyGraphMatrixHelper
        """
        ...

    def merge_with(self, *args, **kwargs) -> Any:
        """
        Merge with another subgraph (not yet implemented).
        """
        ...

    def meta_nodes(self, *args, **kwargs) -> Any:
        """
        Get all meta-nodes - delegates via Python.
        """
        ...

    def neighborhood(self, *args, **kwargs) -> Any:
        """
        Get neighborhood sampling - delegates to PyGraphAnalysis helper
        """
        ...

    def neighbors(self, *args, **kwargs) -> Any:
        """
        Get neighbors of nodes - delegates to PyGraphAnalysis helper
        """
        ...

    def node_attribute_keys(self, *args, **kwargs) -> Any:
        """
        Get all attribute keys for a node - delegates to PyGraphAttr
        """
        ...

    def node_count(self, *args, **kwargs) -> Any:
        """
        Get the number of nodes in the graph - DELEGATED
        """
        ...

    def out_degree(self, *args, **kwargs) -> Any:
        """
        Get out-degree for nodes - delegates via Python method call.
        """
        ...

    def parent_meta_node(self, *args, **kwargs) -> Any:
        """
        Get parent meta-node - delegates via Python.
        """
        ...

    def remove_edge(self, *args, **kwargs) -> Any:
        """
        Remove a single edge from the graph
        """
        ...

    def remove_edges(self, *args, **kwargs) -> Any:
        """
        Remove multiple edges from the graph
        """
        ...

    def remove_node(self, *args, **kwargs) -> Any:
        """
        Remove a single node from the graph
        """
        ...

    def remove_nodes(self, *args, **kwargs) -> Any:
        """
        Remove multiple nodes from the graph
        """
        ...

    def resolve_string_id_to_node(self, *args, **kwargs) -> Any:
        """
        Helper method to resolve string ID to NodeId using uid_key attribute
        """
        ...

    def sample(self, *args, **kwargs) -> Any:
        """
        Sample k random nodes from the graph.
        """
        ...

    def set_edge_attr(self, *args, **kwargs) -> Any:
        """
        Set single edge attribute - delegates to PyGraphAttrMut
        """
        ...

    def set_edge_attrs(self, *args, **kwargs) -> Any:
        """
        Set bulk edge attributes - delegates to PyGraphAttrMut
        """
        ...

    def set_node_attr(self, *args, **kwargs) -> Any:
        """
        Set single node attribute - delegates to PyGraphAttrMut
        """
        ...

    def set_node_attrs(self, *args, **kwargs) -> Any:
        """
        Set bulk node attributes - delegates to PyGraphAttrMut
        """
        ...

    def shortest_path(self, *args, **kwargs) -> Any:
        """
        Get shortest path - delegates to PyGraphAnalysis helper
        """
        ...

    def shortest_path_subgraph(self, *args, **kwargs) -> Any:
        """
        Get shortest path as subgraph - delegates via Python.
        """
        ...

    def subgraph_from_edges(self, *args, **kwargs) -> Any:
        """
        Create subgraph from list of edges.
        """
        ...

    def subtract_from(self, *args, **kwargs) -> Any:
        """
        Subtract another subgraph (not yet implemented).
        """
        ...

    def summary(self, *args, **kwargs) -> Any:
        """
        Get summary string describing the graph.
        """
        ...

    def table(self, *args, **kwargs) -> Any:
        """
        Get a GraphTable representation of this graph
        Implements: g.table()
        """
        ...

    def to_edges(self, *args, **kwargs) -> Any:
        """
        Convert to EdgesAccessor - delegates via Python.
        """
        ...

    def to_graph(self, *args, **kwargs) -> Any:
        """
        Convert to independent Graph - delegates via Python.
        """
        ...

    def to_matrix(self, *args, **kwargs) -> Any:
        """
        Convert graph to attribute matrix - delegates to PyGraphMatrixHelper
        """
        ...

    def to_networkx(self, *args, **kwargs) -> Any:
        """
        Convert this graph to a NetworkX graph.
        """
        ...

    def to_nodes(self, *args, **kwargs) -> Any:
        """
        Convert to NodesAccessor - delegates via Python.
        """
        ...

    def transition_matrix(self, *args, **kwargs) -> Any:
        """
        Generate transition matrix - delegates to PyGraphMatrixHelper
        """
        ...

    def transitivity(self, *args, **kwargs) -> Any:
        """
        Calculate transitivity (not yet implemented in core).
        """
        ...

    def view(self, *args, **kwargs) -> Subgraph:
        """
        Return a full-view Subgraph (whole graph as a subgraph).
        Downstream code can always resolve parent graph from this object.
        """
        ...

    def viz(self, *args, **kwargs) -> Any:
        """
        Get viz accessor - delegates via Python.
        """
        ...


class GraphMatrix:
    """
    Python wrapper for GraphMatrix - general-purpose matrix for collections of GraphArrays
    """
    @property
    def columns(self) -> Any:
        """
        Get column names
        """
        ...

    @property
    def data(self) -> Any:
        """
        Get matrix data (materializes data to Python objects)
        This is the primary materialization method - use sparingly for large matrices
        """
        ...

    @property
    def dtype(self) -> Any:
        """
        Get matrix data type
        """
        ...

    @property
    def grad(self) -> Any:
        """
        Get gradient matrix (None if no gradients computed yet)
        """
        ...

    @property
    def is_numeric(self) -> Any:
        """
        Check if matrix contains only numeric data
        """
        ...

    @property
    def is_sparse(self) -> Any:
        """
        Check if matrix is sparse (has many default values)
        """
        ...

    @property
    def is_square(self) -> Any:
        """
        Check if matrix is square
        """
        ...

    @property
    def is_symmetric(self) -> Any:
        """
        Check if matrix is symmetric (for square numeric matrices)
        """
        ...

    @property
    def requires_grad(self) -> Any:
        """
        Check if gradients are enabled for this matrix
        """
        ...

    @property
    def shape(self) -> Any:
        """
        Get matrix dimensions as (rows, columns) tuple
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __iter__(self) -> Iterator:
        """
        Implement iter(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __setitem__(self, key: Any, value: Any) -> None:
        """
        Set self[key] to value.
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def abs(self, *args, **kwargs) -> Any:
        """
        Element-wise absolute value
        """
        ...

    def apply(self, *args, **kwargs) -> Any:
        """
        Apply a Python function to each element of the matrix
        Returns: New matrix with function applied element-wise
        """
        ...

    def backward(self, *args, **kwargs) -> Any:
        """
        Compute gradients via backpropagation
        """
        ...

    def cholesky_decomposition(self, *args, **kwargs) -> Any:
        """
        Cholesky decomposition: A = L * L^T
        Returns L (lower triangular) for positive definite matrices
        """
        ...

    def concatenate(self, *args, **kwargs) -> Any:
        """
        Concatenate matrices along specified axis
        """
        ...

    def dense(self, *args, **kwargs) -> Any:
        """
        Create a dense materialized version of the matrix
        """
        ...

    def dense_html_repr(self, *args, **kwargs) -> Any:
        """
        Generate dense HTML representation for small matrices
        """
        ...

    def determinant(self, *args, **kwargs) -> Any:
        """
        Determinant calculation (for square matrices)
        """
        ...

    def dropout(self, *args, **kwargs) -> Any:
        """
        Dropout operation for regularization
        """
        ...

    def eigenvalue_decomposition(self, *args, **kwargs) -> Any:
        """
        Eigenvalue decomposition: A * V = V * Λ
        Returns tuple of (eigenvalues, eigenvectors)
        """
        ...

    def elementwise_multiply(self, *args, **kwargs) -> Any:
        """
        Elementwise multiplication (Hadamard product)
        Returns: new GraphMatrix with elementwise product
        """
        ...

    def elu(self, *args, **kwargs) -> Any:
        """
        ELU (Exponential Linear Unit) activation function
        """
        ...

    def exp(self, *args, **kwargs) -> Any:
        """
        Element-wise exponential (e^x)
        """
        ...

    def filter(self, *args, **kwargs) -> Any:
        """
        Filter matrix elements based on a condition function
        Returns: Matrix with only elements where condition(element) is True, others set to 0
        """
        ...

    def flatten(self, *args, **kwargs) -> Any:
        """
        Flatten matrix to NumArray by concatenating all columns row-wise
        Returns a single NumArray containing all matrix values in row-major order
        OPTIMIZED: Pre-allocated vector with vectorized access
        """
        ...

    def from_base_array(self, *args, **kwargs) -> Any:
        """
        Create matrix from BaseArray containing numeric values
        """
        ...

    def from_data(self, *args, **kwargs) -> Any:
        """
        Create matrix from nested Python lists (API consistency)
        
        This is a classmethod wrapper around the `groggy.matrix()` function
        for API consistency with other matrix libraries.
        
        Examples:
          groggy.GraphMatrix.from_data([[1, 2], [3, 4]])  # 2×2 matrix
          groggy.GraphMatrix.from_data([[1, 2, 3]])       # 1×3 matrix
        """
        ...

    def from_flattened(self, *args, **kwargs) -> Any:
        """
        Create matrix from NumArray by reshaping to specified dimensions
        """
        ...

    def from_graph_attributes(self, *args, **kwargs) -> Any:
        """
        Create matrix from graph attributes
        """
        ...

    def gelu(self, *args, **kwargs) -> Any:
        """
        GELU activation applied to matrix
        Implements: matrix.gelu()
        """
        ...

    def get(self, *args, **kwargs) -> Any:
        """
        Get single cell value at (row, col) - public interface
        """
        ...

    def get_cell(self, *args, **kwargs) -> Any:
        """
        Get single cell value at (row, col)
        """
        ...

    def get_column(self, *args, **kwargs) -> Any:
        """
        Get column by index as BaseArray (mixed types) or NumArray (if all numerical)
        """
        ...

    def get_column_by_name(self, *args, **kwargs) -> Any:
        """
        Get column by name as BaseArray (mixed types) or NumArray (if all numerical)
        """
        ...

    def get_row(self, *args, **kwargs) -> Any:
        """
        Get entire row as BaseArray (mixed types) or NumArray (if all numerical)
        """
        ...

    def identity(self, *args, **kwargs) -> Any:
        """
        Create an identity matrix with specified size
        """
        ...

    def inverse(self, *args, **kwargs) -> Any:
        """
        Matrix inverse (Phase 5 - placeholder for now)
        """
        ...

    def is_empty(self, *args, **kwargs) -> Any:
        """
        Check whether the matrix contains any rows or columns
        """
        ...

    def iter_columns(self, *args, **kwargs) -> Any:
        """
        Iterate over columns - returns iterator of BaseArrays or NumArrays
        """
        ...

    def iter_rows(self, *args, **kwargs) -> Any:
        """
        Iterate over rows - returns iterator of BaseArrays or NumArrays
        """
        ...

    def leaky_relu(self, *args, **kwargs) -> Any:
        """
        Leaky ReLU activation function
        """
        ...

    def log(self, *args, **kwargs) -> Any:
        """
        Element-wise natural logarithm
        """
        ...

    def lu_decomposition(self, *args, **kwargs) -> Any:
        """
        LU decomposition: PA = LU
        Returns tuple of (P, L, U) where P is permutation, L is lower triangular, U is upper triangular
        """
        ...

    def map(self, *args, **kwargs) -> Any:
        """
        Map a Python function over matrix elements (alias for apply)
        Returns: New matrix with function mapped over elements
        """
        ...

    def max(self, *args, **kwargs) -> Any:
        """
        Global maximum value in the matrix
        """
        ...

    def max_axis(self, *args, **kwargs) -> Any:
        """
        Maximum along specified axis (0=rows, 1=columns)
        """
        ...

    def mean(self, *args, **kwargs) -> Any:
        """
        Global mean of all elements in the matrix  
        """
        ...

    def mean_axis(self, *args, **kwargs) -> Any:
        """
        Mean along specified axis (0=rows, 1=columns)
        """
        ...

    def min(self, *args, **kwargs) -> Any:
        """
        Global minimum value in the matrix
        """
        ...

    def min_axis(self, *args, **kwargs) -> Any:
        """
        Minimum along specified axis (0=rows, 1=columns)
        """
        ...

    def multiply(self, *args, **kwargs) -> Any:
        """
        Matrix multiplication supporting either another matrix or a scalar factor
        - When passed a GraphMatrix, performs matrix multiplication (self * other)
        - When passed a numeric scalar, performs scalar multiplication
        """
        ...

    def norm(self, *args, **kwargs) -> Any:
        """
        Calculate the Frobenius norm (Euclidean norm) of the matrix
        """
        ...

    def norm_inf(self, *args, **kwargs) -> Any:
        """
        Calculate the L∞ norm (maximum absolute value) of the matrix
        """
        ...

    def norm_l1(self, *args, **kwargs) -> Any:
        """
        Calculate the L1 norm (sum of absolute values) of the matrix
        """
        ...

    def ones(self, *args, **kwargs) -> Any:
        """
        Create a ones matrix with specified dimensions
        """
        ...

    def power(self, *args, **kwargs) -> Any:
        """
        Matrix power - raise matrix to integer power
        Returns: new GraphMatrix that is self^n
        """
        ...

    def preview(self, *args, **kwargs) -> Any:
        """
        Get preview of matrix for display (first N rows/cols by default)
        """
        ...

    def qr_decomposition(self, *args, **kwargs) -> Any:
        """
        QR decomposition: A = Q * R
        Returns tuple of (Q, R) where Q is orthogonal and R is upper triangular
        """
        ...

    def rank(self, *args, **kwargs) -> Any:
        """
        Matrix rank - number of linearly independent rows/columns
        Uses SVD with numerical tolerance for near-zero singular values
        """
        ...

    def relu(self, *args, **kwargs) -> Any:
        """
        ReLU activation applied to matrix
        Implements: matrix.relu()
        """
        ...

    def repeat(self, *args, **kwargs) -> Any:
        """
        Repeat elements of the matrix along a specified axis
        Args: repeats - number of times to repeat, axis - 0 for rows, 1 for columns
        """
        ...

    def requires_grad_(self, *args, **kwargs) -> Any:
        """
        Enable or disable gradient tracking for this matrix
        """
        ...

    def reshape(self, *args, **kwargs) -> Any:
        """
        Reshape matrix to new dimensions while preserving total element count
        Returns: new GraphMatrix with specified shape
        """
        ...

    def rich_display(self, *args, **kwargs) -> Any:
        """
        Get rich display representation using Rust formatter
        """
        ...

    def scalar_multiply(self, *args, **kwargs) -> Any:
        """
        Placeholder for scalar operations
        """
        ...

    def set(self, *args, **kwargs) -> Any:
        """
        Set single cell value at (row, col)
        """
        ...

    def sigmoid(self, *args, **kwargs) -> Any:
        """
        Sigmoid activation applied to matrix
        Implements: matrix.sigmoid()
        """
        ...

    def softmax(self, *args, **kwargs) -> Any:
        """
        Softmax activation applied to matrix
        Implements: matrix.softmax(dim=1)
        """
        ...

    def solve(self, *args, **kwargs) -> Any:
        """
        Solve linear system Ax = b
        """
        ...

    def split(self, *args, **kwargs) -> Any:
        """
        Split matrix along specified axis
        """
        ...

    def sqrt(self, *args, **kwargs) -> Any:
        """
        Element-wise square root
        """
        ...

    def stack(self, *args, **kwargs) -> Any:
        """
        Stack matrices along specified axis
        """
        ...

    def std_axis(self, *args, **kwargs) -> Any:
        """
        Standard deviation along specified axis (0=rows, 1=columns)
        """
        ...

    def sum(self, *args, **kwargs) -> Any:
        """
        Global sum of all elements in the matrix
        """
        ...

    def sum_axis(self, *args, **kwargs) -> Any:
        """
        Sum along specified axis (0=rows, 1=columns)
        """
        ...

    def summary(self, *args, **kwargs) -> Any:
        """
        Get summary information without materializing data
        """
        ...

    def svd(self, *args, **kwargs) -> Any:
        """
        SVD decomposition: A = U * Σ * V^T
        Returns tuple of (U, singular_values, V_transpose)
        """
        ...

    def tanh(self, *args, **kwargs) -> Any:
        """
        Tanh activation applied to matrix
        Implements: matrix.tanh()
        """
        ...

    def tile(self, *args, **kwargs) -> Any:
        """
        Tile (repeat) the matrix a specified number of times along each axis
        Args: reps - tuple of (rows_repeat, cols_repeat)
        """
        ...

    def to_base_array(self, *args, **kwargs) -> Any:
        """
        Convert matrix to BaseArray containing all values as AttrValues
        """
        ...

    def to_degree_matrix(self, *args, **kwargs) -> Any:
        """
        Get degree matrix from adjacency matrix
        """
        ...

    def to_dict(self, *args, **kwargs) -> Any:
        """
        Convert matrix to Python dictionary
        Returns: {"data": [[...]], "shape": [rows, cols], "dtype": "float64"}
        """
        ...

    def to_laplacian(self, *args, **kwargs) -> Any:
        """
        Get standard Laplacian matrix (D - A)
        """
        ...

    def to_list(self, *args, **kwargs) -> Any:
        """
        Convert matrix to nested Python list
        Returns: [[row1], [row2], ...] format
        """
        ...

    def to_normalized_laplacian(self, *args, **kwargs) -> Any:
        """
        Get normalized Laplacian matrix with enhanced parameterization
        
        Args:
            eps: Exponent for degree matrix (default 0.5 for standard normalization)
            k: Power to raise the result to (default 1)
        
        Formula: (D^eps @ A @ D^eps)^k
        """
        ...

    def to_numpy(self, *args, **kwargs) -> Any:
        """
        Convert to NumPy array (when numpy available)
        Uses .data property to materialize data
        """
        ...

    def to_pandas(self, *args, **kwargs) -> Any:
        """
        Convert to Pandas DataFrame (when pandas available)
        """
        ...

    def to_table_for_streaming(self, *args, **kwargs) -> Any:
        """
        Convert matrix to table format for streaming visualization
        
        Creates a BaseTable with columns representing matrix data:
        - 'row': row index
        - 'column': column index  
        - 'value': the matrix value at that position
        """
        ...

    def trace(self, *args, **kwargs) -> Any:
        """
        Calculate the trace (sum of diagonal elements) - only for square matrices
        """
        ...

    def transpose(self, *args, **kwargs) -> Any:
        """
        Transpose the matrix
        """
        ...

    def var_axis(self, *args, **kwargs) -> Any:
        """
        Variance along specified axis (0=rows, 1=columns)
        """
        ...

    def zero_grad(self, *args, **kwargs) -> Any:
        """
        Zero out all gradients in the computation graph
        """
        ...

    def zeros(self, *args, **kwargs) -> Any:
        """
        Create a zero matrix with specified dimensions and type
        """
        ...


class GraphTable:
    """
    Python wrapper for GraphTable
    """
    @property
    def edges(self) -> Any:
        """
        Get EdgesTable component  
        """
        ...

    @property
    def nodes(self) -> Any:
        """
        Get NodesTable component
        """
        ...

    @property
    def viz(self) -> Any:
        """
        Get viz accessor for visualization operations
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def auto_assign_edge_ids(self, *args, **kwargs) -> Any:
        """
        Auto-assign edge IDs for null values (useful for meta nodes and imported data)
        """
        ...

    def from_federated_bundles(self, *args, **kwargs) -> Any:
        """
        Create federated GraphTable from multiple bundle paths
        """
        ...

    def get_bundle_info(self, *args, **kwargs) -> Any:
        """
        Get bundle metadata information without loading the full bundle
        
        # Arguments
        * `bundle_path` - Directory path containing the bundle
        
        # Returns
        * `dict` - Bundle metadata information
        
        # Examples
        ```python
        # Inspect bundle metadata
        metadata = GraphTable.get_bundle_info("./graph_data_bundle")
        print(f"Bundle version: {metadata['version']}")
        print(f"Nodes: {metadata['node_count']}, Edges: {metadata['edge_count']}")
        print(f"Created: {metadata['created_at']}")
        ```
        """
        ...

    def head(self, *args, **kwargs) -> Any:
        """
        Get first n rows (primarily from nodes table, default 5)
        """
        ...

    def is_empty(self, *args, **kwargs) -> Any:
        """
        Check whether both node and edge tables are empty
        """
        ...

    def load_bundle(self, *args, **kwargs) -> Any:
        """
        Load GraphTable from a bundle directory (supports both v1.0 and v2.0 formats)
        
        # Arguments
        * `bundle_path` - Directory path containing the bundle
        
        # Returns
        * `PyGraphTable` - Loaded graph table with validation policy restored
        
        # Examples
        ```python
        # Load from v2.0 bundle (with integrity verification)
        graph_table = GraphTable.load_bundle("./graph_data_bundle")
        
        # Also supports legacy v1.0 bundles
        graph_table = GraphTable.load_bundle("./old_bundle")
        ```
        """
        ...

    def merge(self, *args, **kwargs) -> Any:
        """
        Merge multiple GraphTables into one using the specified strategy
        """
        ...

    def ncols(self, *args, **kwargs) -> Any:
        """
        Get number of columns (max of nodes and edges)
        """
        ...

    def nrows(self, *args, **kwargs) -> Any:
        """
        Get number of total rows (nodes + edges)
        """
        ...

    def save_bundle(self, *args, **kwargs) -> Any:
        """
        Save GraphTable as a v2.0 bundle with comprehensive metadata and checksums
        
        # Arguments
        * `bundle_path` - Directory path to save the bundle
        
        # Examples
        ```python
        # Save with comprehensive metadata and validation
        graph_table.save_bundle("./graph_data_bundle")
        
        # Bundle will contain:
        # - metadata.json: Comprehensive metadata with checksums
        # - MANIFEST.json: File integrity manifest
        # - validation_report.json: Structured validation results
        # - nodes.csv: Node data
        # - edges.csv: Edge data
        ```
        """
        ...

    def shape(self, *args, **kwargs) -> Any:
        """
        Get shape as (rows, cols)
        """
        ...

    def stats(self, *args, **kwargs) -> Any:
        """
        Get graph statistics  
        """
        ...

    def tail(self, *args, **kwargs) -> Any:
        """
        Get last n rows (primarily from nodes table, default 5)
        """
        ...

    def to_edges(self, *args, **kwargs) -> Any:
        """
        Convert table to EdgesAccessor by extracting edge IDs from the table
        """
        ...

    def to_graph(self, *args, **kwargs) -> Any:
        """
        Convert back to Graph
        """
        ...

    def to_nodes(self, *args, **kwargs) -> Any:
        """
        Convert table to NodesAccessor by extracting node IDs from the table
        """
        ...

    def to_subgraphs(self, *args, **kwargs) -> Any:
        """
        Convert table to SubgraphArray by creating subgraphs from table rows
        """
        ...

    def validate(self, *args, **kwargs) -> Any:
        """
        Validate the GraphTable and return report
        """
        ...

    def verify_bundle(self, *args, **kwargs) -> Any:
        """
        Verify bundle integrity without loading the full data
        
        # Arguments
        * `bundle_path` - Directory path containing the bundle
        
        # Returns
        * `dict` - Verification results with checksums and validation status
        
        # Examples
        ```python
        # Verify bundle integrity
        verification = GraphTable.verify_bundle("./graph_data_bundle")
        if verification['is_valid']:
            print("Bundle integrity verified!")
        else:
            print(f"Issues found: {verification['errors']}")
        ```
        """
        ...


class GroupedAggregationResult:
    """
    Result of a grouped aggregation operation
    """
    @property
    def attribute(self) -> Any:
        ...

    @property
    def groups(self) -> Any:
        ...

    @property
    def operation(self) -> Any:
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...


class HistoricalView:
    """
    Python wrapper for historical view
    """
    @property
    def state_id(self) -> Any:
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...


class HistoryStatistics:
    """
    History statistics for the graph
    """
    @property
    def current_state_edges(self) -> Any:
        """
        Get current state edge count
        """
        ...

    @property
    def current_state_nodes(self) -> Any:
        """
        Get current state node count
        """
        ...

    @property
    def total_branches(self) -> Any:
        """
        Get total number of branches
        """
        ...

    @property
    def total_commits(self) -> Any:
        """
        Get total number of commits
        """
        ...

    @property
    def uncommitted_changes(self) -> Any:
        """
        Check if there are uncommitted changes
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...


class MatrixArray:
    """
    MatrixArray: Collection of GraphMatrix objects with delegation to NumArray
    Provides basic array operations plus statistical operations on matrix collections
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def correlation_matrix(self, *args, **kwargs) -> Any:
        """
        Calculate correlation between matrix elements (simplified)
        """
        ...

    def dimension_stats(self, *args, **kwargs) -> Any:
        """
        Calculate statistics on matrix dimensions
        """
        ...

    def filter(self, *args, **kwargs) -> Any:
        """
        Filter matrices using a Python predicate function
        """
        ...

    def filter_by_size(self, *args, **kwargs) -> Any:
        """
        Filter matrices by minimum size
        """
        ...

    def first(self, *args, **kwargs) -> Any:
        """
        Get the first GraphMatrix
        """
        ...

    def is_empty(self, *args, **kwargs) -> Any:
        """
        Check if the array is empty
        """
        ...

    def iter(self, *args, **kwargs) -> Any:
        """
        Create an iterator for method chaining
        """
        ...

    def last(self, *args, **kwargs) -> Any:
        """
        Get the last GraphMatrix
        """
        ...

    def mean_eigenvalue(self, *args, **kwargs) -> Any:
        """
        Calculate mean eigenvalue across all matrices
        """
        ...

    def stack(self, *args, **kwargs) -> Any:
        """
        Stack matrices vertically (concatenate rows)
        """
        ...

    def stats_summary(self, *args, **kwargs) -> Any:
        """
        Get summary statistics for all matrices in the array
        """
        ...

    def subgraphs(self, *args, **kwargs) -> Any:
        """
        Extract subgraphs from matrices (placeholder implementation)
        """
        ...

    def table(self, *args, **kwargs) -> Any:
        """
        Convert matrices to tables (edge lists)
        """
        ...

    def to_list(self, *args, **kwargs) -> Any:
        """
        Convert to Python list
        """
        ...


class MatrixArrayIterator:
    """
    Iterator for MatrixArray that enables method chaining
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def collect(self, *args, **kwargs) -> Any:
        """
        Collect the iterator back into a MatrixArray
        """
        ...

    def eigen(self, *args, **kwargs) -> Any:
        """
        Extract eigenvalues from each matrix and return as StatsArray (conceptual)
        """
        ...

    def filter(self, *args, **kwargs) -> Any:
        """
        Filter matrices using a Python predicate function
        """
        ...

    def multiply(self, *args, **kwargs) -> Any:
        """
        Apply element-wise multiplication to each matrix with another iterator
        """
        ...

    def transform(self, *args, **kwargs) -> Any:
        """
        Apply a mathematical transformation to each matrix
        """
        ...


class MetaEdge:
    """
    Python wrapper for a meta-edge (aggregated edge)
    
    Meta-edges are special edges that represent aggregated or summarized relationships
    between nodes. They have all the capabilities of regular edges plus meta-specific
    operations like getting aggregation counts.
    """
    @property
    def aggregated_from(self) -> Any:
        """
        Get the IDs of original edges that were aggregated into this meta-edge
        
        This is a future enhancement - currently original edge IDs are not stored
        during the collapse process.
        
        # Returns
        Optional list of original EdgeIds, or None if not available
        
        # Raises
        * `RuntimeError` - If there's an error accessing aggregated edges
        """
        ...

    @property
    def edge_count(self) -> Any:
        """
        Get the count of original edges this meta-edge aggregates
        
        During subgraph collapse, multiple original edges may be aggregated
        into a single meta-edge. This returns how many were combined.
        
        # Returns
        Optional count of original edges, or None if not available
        """
        ...

    @property
    def entity_type(self) -> Any:
        """
        Get the entity type for this meta-edge
        
        # Returns
        The string "meta_edge"
        """
        ...

    @property
    def id(self) -> Any:
        """
        Get the meta-edge ID
        
        # Returns
        The unique EdgeId for this meta-edge
        """
        ...

    @property
    def is_active(self) -> Any:
        """
        Check if this meta-edge is currently active
        
        # Returns
        True if the meta-edge is active in the graph
        """
        ...

    @property
    def is_meta_edge(self) -> Any:
        """
        Check if this is a meta-edge
        
        Meta-edges are identified by having entity_type="meta"
        
        # Returns
        True if this is a meta-edge, False otherwise
        """
        ...

    @property
    def source(self) -> Any:
        """
        Get the meta-edge's source node ID
        
        # Returns
        The NodeId of the source node
        
        # Raises
        * `RuntimeError` - If there's an error getting the source
        """
        ...

    @property
    def target(self) -> Any:
        """
        Get the meta-edge's target node ID
        
        # Returns
        The NodeId of the target node
        
        # Raises
        * `RuntimeError` - If there's an error getting the target
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __setitem__(self, key: Any, value: Any) -> None:
        """
        Set self[key] to value.
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def expand(self, *args, **kwargs) -> Any:
        """
        Expand meta-edge back to original edges
        
        This is a future enhancement that would recreate the original edges
        that were aggregated into this meta-edge.
        
        # Returns
        Optional list of recreated EdgeIds, or None if not possible
        
        # Raises
        * `RuntimeError` - If there's an error expanding the meta-edge
        """
        ...

    def keys(self, *args, **kwargs) -> Any:
        """
        Get all attribute keys for this meta-edge
        
        # Returns
        List of attribute names
        
        # Raises
        * `RuntimeError` - If there's an error accessing attributes
        """
        ...

    def meta_properties(self, *args, **kwargs) -> Any:
        """
        Get meta-edge specific properties as a dictionary
        
        Returns a dictionary containing meta-edge specific attributes like
        edge_count, aggregation information, etc.
        
        # Arguments
        * `py` - Python interpreter instance
        
        # Returns
        Dictionary of property names to values for this meta-edge
        
        # Raises
        * `RuntimeError` - If there's an error accessing meta properties
        """
        ...

    def summary(self, *args, **kwargs) -> Any:
        """
        Get a summary of this meta-edge
        
        # Returns
        A human-readable summary string including meta-edge specific information
        """
        ...

    def values(self, *args, **kwargs) -> Any:
        """
        Get all attribute values for this meta-edge
        
        # Arguments
        * `py` - Python interpreter instance
        
        # Returns
        List of attribute values
        
        # Raises
        * `RuntimeError` - If there's an error accessing attributes
        """
        ...


class MetaNode:
    """
    Python wrapper for a meta-node (collapsed subgraph)
    
    Meta-nodes are special nodes that represent collapsed subgraphs. They have all
    the capabilities of regular nodes plus meta-specific operations like expanding
    back to the original subgraph.
    """
    @property
    def degree(self) -> Any:
        """
        Get the meta-node's degree (number of connected edges)
        
        # Returns
        The number of edges connected to this meta-node
        
        # Raises
        * `RuntimeError` - If there's an error calculating degree
        """
        ...

    @property
    def entity_type(self) -> Any:
        """
        Get the entity type for this meta-node
        
        # Returns
        The string "meta_node"
        """
        ...

    @property
    def has_subgraph(self) -> Any:
        """
        Check if this meta-node contains a subgraph
        
        # Returns
        True if this meta-node has an associated subgraph
        """
        ...

    @property
    def id(self) -> Any:
        """
        Get the meta-node ID
        
        # Returns
        The unique NodeId for this meta-node
        """
        ...

    @property
    def is_active(self) -> Any:
        """
        Check if this meta-node is currently active
        
        # Returns
        True if the meta-node is active in the graph
        """
        ...

    @property
    def meta_edges(self) -> Any:
        """
        Get all meta-edges connected to this meta-node
        
        Meta-edges are edges with entity_type="meta" that were created during
        the subgraph collapse process.
        
        # Returns
        List of EdgeIds representing meta-edges connected to this meta-node
        
        # Raises
        * `RuntimeError` - If there's an error getting meta-edges
        """
        ...

    @property
    def neighbors(self) -> Any:
        """
        Get the meta-node's neighbors
        
        # Returns
        List of NodeIds representing neighboring nodes (could be regular nodes or other meta-nodes)
        
        # Raises
        * `RuntimeError` - If there's an error getting neighbors
        """
        ...

    @property
    def subgraph(self) -> Any:
        """
        Get the contained subgraph
        
        This returns the original subgraph that was collapsed to create this meta-node.
        
        # Returns
        Optional PySubgraph representing the contained subgraph
        
        # Raises
        * `RuntimeError` - If there's an error accessing the subgraph
        """
        ...

    @property
    def subgraph_id(self) -> Any:
        """
        Get the ID of the contained subgraph
        
        # Returns
        Optional subgraph ID if this meta-node contains a subgraph
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __setitem__(self, key: Any, value: Any) -> None:
        """
        Set self[key] to value.
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def expand(self, *args, **kwargs) -> Any:
        """
        Expand the meta-node back to its original subgraph
        
        This is an alias for the subgraph property with a more intuitive name.
        
        # Returns
        Optional PySubgraph representing the expanded subgraph
        
        # Raises
        * `RuntimeError` - If there's an error expanding the meta-node
        """
        ...

    def keys(self, *args, **kwargs) -> Any:
        """
        Get all attribute keys for this meta-node
        
        # Returns
        List of attribute names
        
        # Raises
        * `RuntimeError` - If there's an error accessing attributes
        """
        ...

    def re_aggregate(self, *args, **kwargs) -> Any:
        """
        Re-aggregate meta-node attributes with new aggregation functions
        
        This allows updating the meta-node's aggregated attributes by re-running
        the aggregation process with different functions.
        
        # Arguments
        * `agg_functions` - Dictionary mapping attribute names to aggregation functions
        
        # Raises
        * `RuntimeError` - If there's an error during re-aggregation
        """
        ...

    def summary(self, *args, **kwargs) -> Any:
        """
        Get a summary of this meta-node
        
        # Returns
        A human-readable summary string including meta-node specific information
        """
        ...

    def values(self, *args, **kwargs) -> Any:
        """
        Get all attribute values for this meta-node
        
        # Arguments
        * `py` - Python interpreter instance
        
        # Returns
        List of attribute values
        
        # Raises
        * `RuntimeError` - If there's an error accessing attributes
        """
        ...


class MetaNodeArray:
    """
    Python wrapper for MetaNodeArray - specialized array for MetaNode collections
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def iter(self, *args, **kwargs) -> Any:
        """
        Enable fluent chaining with .iter() method for meta-node-specific operations
        """
        ...


class MetaNodePlan:
    """
    Simplified Python wrapper for immediate execution
    
    Since we can't store Rc<RefCell<Graph>> in a PyClass, we'll execute immediately.
    This still provides the clean API but without the plan/execute separation.
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def add_to_graph(self, *args, **kwargs) -> Any:
        """
        This is just a placeholder - actual execution happened already
        """
        ...

    def preview(self, *args, **kwargs) -> Any:
        """
        Preview what was configured  
        """
        ...


class NeighborhoodResult:
    """
    Python wrapper for NeighborhoodResult
    """
    @property
    def execution_time_ms(self) -> Any:
        ...

    @property
    def largest_neighborhood_size(self) -> Any:
        ...

    @property
    def neighborhoods(self) -> Any:
        ...

    @property
    def total_neighborhoods(self) -> Any:
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __iter__(self) -> Iterator:
        """
        Implement iter(self).
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...


class NeighborhoodStats:
    """
    Python wrapper for NeighborhoodStats
    """
    @property
    def operation_counts(self) -> Any:
        ...

    @property
    def total_neighborhoods(self) -> Any:
        ...

    @property
    def total_nodes_sampled(self) -> Any:
        ...

    @property
    def total_time_ms(self) -> Any:
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def avg_nodes_per_neighborhood(self, *args, **kwargs) -> Any:
        """
        Get average nodes per neighborhood
        """
        ...

    def avg_time_per_neighborhood_ms(self, *args, **kwargs) -> Any:
        """
        Get average time per neighborhood in milliseconds
        """
        ...


class NeighborhoodSubgraph:
    """
    Python wrapper for NeighborhoodSubgraph
    """
    @property
    def central_nodes(self) -> Any:
        ...

    @property
    def hops(self) -> Any:
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def is_central_node(self, *args, **kwargs) -> Any:
        """
        Check if a node is a central node
        """
        ...

    def subgraph(self, *args, **kwargs) -> Any:
        """
        Get the subgraph object using the same pattern as connected components
        I would rather that the NeighborhoodSubgraph object be the subgraph object itself
        """
        ...


class Node:
    """
    Python wrapper for a regular graph node
    
    Regular nodes are the basic building blocks of graphs. They provide access
    to node attributes, topology information (neighbors, degree), and graph operations.
    """
    @property
    def degree(self) -> Any:
        """
        Get the node's degree (number of connected edges)
        
        # Returns
        The number of edges connected to this node
        
        # Raises
        * `RuntimeError` - If there's an error calculating degree
        """
        ...

    @property
    def entity_type(self) -> Any:
        """
        Get the entity type for this node
        
        # Returns
        The string "node"
        """
        ...

    @property
    def id(self) -> Any:
        """
        Get the node ID
        
        # Returns
        The unique NodeId for this node
        """
        ...

    @property
    def is_active(self) -> Any:
        """
        Check if this node is currently active
        
        # Returns
        True if the node is active in the graph
        """
        ...

    @property
    def neighbors(self) -> Any:
        """
        Get the node's neighbors
        
        # Returns
        List of NodeIds representing neighboring nodes
        
        # Raises
        * `RuntimeError` - If there's an error getting neighbors
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __setitem__(self, key: Any, value: Any) -> None:
        """
        Set self[key] to value.
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def keys(self, *args, **kwargs) -> Any:
        """
        Get all attribute keys for this node
        
        # Returns
        List of attribute names
        
        # Raises
        * `RuntimeError` - If there's an error accessing attributes
        """
        ...

    def summary(self, *args, **kwargs) -> Any:
        """
        Get a summary of this node
        
        # Returns
        A human-readable summary string
        """
        ...

    def values(self, *args, **kwargs) -> Any:
        """
        Get all attribute values for this node
        
        # Arguments
        * `py` - Python interpreter instance
        
        # Returns
        List of attribute values
        
        # Raises
        * `RuntimeError` - If there's an error accessing attributes
        """
        ...


class NodeFilter:
    """
    Python wrapper for NodeFilter
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def and_filters(self, *args, **kwargs) -> Any:
        ...

    def attribute_equals(self, *args, **kwargs) -> Any:
        ...

    def attribute_filter(self, *args, **kwargs) -> Any:
        ...

    def has_attribute(self, *args, **kwargs) -> Any:
        ...

    def not_filter(self, *args, **kwargs) -> Any:
        ...

    def or_filters(self, *args, **kwargs) -> Any:
        ...


class NodesAccessor:
    """
    Wrapper for g.nodes that supports indexing syntax: g.nodes[id] -> NodeView
    """
    @property
    def attributes(self) -> Any:
        """
        Get all unique attribute names across all nodes
        """
        ...

    @property
    def base(self) -> Any:
        """
        Get filtered accessor for base (non-meta) nodes only
        
        Returns:
            PyNodesAccessor: Accessor that only shows base nodes (entity_type != 'meta')
        
        Example:
            base_nodes = g.nodes.base
            base_count = len(base_nodes)
            base_table = base_nodes.table()
        """
        ...

    @property
    def meta(self) -> Any:
        """
        Get filtered accessor for meta-nodes only
        
        Returns:
            PyNodesAccessor: Accessor that only shows meta-nodes (entity_type == 'meta')
        
        Example:
            meta_nodes = g.nodes.meta
            meta_count = len(meta_nodes)
            meta_table = meta_nodes.table()
        """
        ...

    @property
    def subgraphs(self) -> Any:
        """
        Access all subgraph-nodes (meta-nodes) in the graph
        
        Returns:
            PyNumArray: Array of node IDs that contain subgraphs
        
        Example:
            subgraph_nodes = g.nodes.subgraphs
            for meta_node in subgraph_nodes:
                print(f"Meta-node {meta_node.id} contains subgraph")
        """
        ...

    @property
    def viz(self) -> Any:
        """
        Get viz accessor for visualization operations
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __iter__(self) -> Iterator:
        """
        Implement iter(self).
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __setitem__(self, key: Any, value: Any) -> None:
        """
        Set self[key] to value.
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def all(self, *args, **kwargs) -> Subgraph:
        """
        Get all nodes as a subgraph (equivalent to g.nodes[:]) - DELEGATED to SubgraphOperations  
        Returns a subgraph containing all nodes and all induced edges
        """
        ...

    def array(self, *args, **kwargs) -> NodesArray:
        """
        Create a NodesArray containing this single accessor (for delegation chaining)
        Implements: g.nodes.array() -> enables array operations and chaining
        """
        ...

    def attribute_names(self, *args, **kwargs) -> Any:
        """
        List attribute names available within this accessor's node set
        """
        ...

    def filter(self, *args, **kwargs) -> Any:
        """
        Filter nodes using the same syntax as graph.filter_nodes and return a subgraph
        """
        ...

    def get_meta_node(self, *args, **kwargs) -> Any:
        """
        Get a MetaNode object if the specified node is a meta-node
        
        Args:
            node_id: The node ID to check
        
        Returns:
            PyMetaNode if the node is a meta-node, None otherwise
        
        Example:
            meta_node = g.nodes.get_meta_node(3)
            if meta_node:
                subgraph = meta_node.subgraph
        """
        ...

    def group_by(self, *args, **kwargs) -> Any:
        """
        Group nodes by attribute value, returning SubgraphArray
        
        Args:
            attr_name: Name of the node attribute to group by
        
        Returns:
            SubgraphArray: Array of subgraphs, one for each unique attribute value
        
        Example:
            dept_groups = g.nodes.group_by('department')
            # Returns subgraphs for each department value
        """
        ...

    def ids(self, *args, **kwargs) -> NumArray:
        """
        Get node IDs as an IntArray for integer operations
        Implements: g.nodes.ids()
        """
        ...

    def matrix(self, *args, **kwargs) -> Any:
        """
        Convert node attributes to matrix
        Implements: g.nodes.matrix()
        """
        ...

    def set_attrs(self, *args, **kwargs) -> Any:
        """
        Set attributes for multiple nodes (bulk operation)
        Supports the same formats as the main graph: node-centric, column-centric, etc.
        """
        ...

    def table(self, *args, **kwargs) -> Any:
        """
        Get a NodesTable representation of accessible nodes  
        Implements: g.nodes.table()
        """
        ...


class NodesArray:
    """
    NodesArray: Collection of NodesAccessor objects with delegation to BaseArray
    Provides basic array operations and graph-specific transformations
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def contains(self, *args, **kwargs) -> Any:
        """
        Check if the array contains a specific NodesAccessor
        """
        ...

    def filter(self, *args, **kwargs) -> NodesArray:
        """
        Filter NodesAccessor objects using a Python predicate function
        """
        ...

    def filter_by_size(self, *args, **kwargs) -> Any:
        """
        Filter NodesAccessor objects by node count threshold
        """
        ...

    def first(self, *args, **kwargs) -> Any:
        """
        Get the first NodesAccessor
        """
        ...

    def interactive(self, *args, **kwargs) -> Any:
        """
        Launch interactive visualization for this NodesArray
        
        Converts the NodesArray to a table view and launches visualization
        
        # Arguments
        * `port` - Optional port number (0 for auto-assign)
        * `layout` - Layout algorithm: \"force-directed\", \"circular\", \"grid\", \"hierarchical\"
        * `theme` - Visual theme: \"light\", \"dark\", \"publication\", \"minimal\"
        * `width` - Canvas width in pixels
        * `height` - Canvas height in pixels
        
        # Returns
        VizAccessor for launching interactive visualization
        """
        ...

    def is_empty(self, *args, **kwargs) -> Any:
        """
        Check if the array is empty
        """
        ...

    def iter(self, *args, **kwargs) -> Any:
        """
        Create an iterator for method chaining
        """
        ...

    def last(self, *args, **kwargs) -> Any:
        """
        Get the last NodesAccessor  
        """
        ...

    def stats(self, *args, **kwargs) -> Any:
        """
        Get statistics about the NodesAccessor collection
        """
        ...

    def table(self, *args, **kwargs) -> Any:
        """
        Apply table() to each NodesAccessor and return TableArray
        """
        ...

    def to_list(self, *args, **kwargs) -> Any:
        """
        Convert to Python list
        """
        ...

    def total_node_count(self, *args, **kwargs) -> Any:
        """
        Get total node count across all NodesAccessor objects
        """
        ...

    def union(self, *args, **kwargs) -> Any:
        """
        Combine all NodesAccessor objects into a single unified NodesAccessor
        """
        ...


class NodesArrayIterator:
    """
    Iterator for NodesArray that enables method chaining
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def collect(self, *args, **kwargs) -> Any:
        """
        Collect the iterator back into a NodesArray
        """
        ...

    def filter(self, *args, **kwargs) -> Any:
        """
        Filter the iterator using a Python predicate function
        """
        ...

    def table(self, *args, **kwargs) -> Any:
        """
        Apply table() to each NodesAccessor in the iterator
        """
        ...


class NodesTable:
    """
    Python wrapper for NodesTable
    """
    @property
    def viz(self) -> Any:
        """
        Get viz accessor for visualization operations (no graph tab)
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __iter__(self) -> Iterator:
        """
        Implement iter(self).
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def base_table(self, *args, **kwargs) -> Any:
        """
        Get reference to underlying BaseTable
        """
        ...

    def drop_columns(self, *args, **kwargs) -> Any:
        """
        Drop columns from the table (cannot drop node_id)
        
        Args:
            columns: List of column names to drop
        
        Returns:
            PyNodesTable: A new table without the specified columns
        """
        ...

    def filter(self, *args, **kwargs) -> Any:
        """
        Filter rows using a query expression or Python function
        
        Args:
            predicate: Either a string query expression (e.g. "age > 25") or a Python function
        
        Returns:
            PyNodesTable: A new table with filtered rows
        """
        ...

    def filter_by_attr(self, *args, **kwargs) -> Any:
        """
        Filter nodes by attribute value
        """
        ...

    def from_csv(self, *args, **kwargs) -> Any:
        """
        Import NodesTable from CSV file (must contain node_id column)
        """
        ...

    def from_dict(self, *args, **kwargs) -> Any:
        """
        Create NodesTable from a Python dictionary (must contain 'node_id' column)
        """
        ...

    def from_json(self, *args, **kwargs) -> Any:
        """
        Import NodesTable from JSON file (must contain node_id column)
        """
        ...

    def from_parquet(self, *args, **kwargs) -> Any:
        """
        Import NodesTable from Parquet file (must contain node_id column)
        """
        ...

    def group_by(self, *args, **kwargs) -> Any:
        """
        Group by columns and return grouped tables
        
        Args:
            columns: List of column names to group by
        
        Returns:
            PyNodesTableArray: Array-like container holding the grouped node tables
        """
        ...

    def head(self, *args, **kwargs) -> Any:
        """
        Get first n rows (default 5)
        """
        ...

    def interactive(self, *args, **kwargs) -> Any:
        """
        Launch interactive streaming table view in browser
        
        Returns the URL where the interactive table can be viewed.
        The table will be available for real-time exploration with virtual scrolling,
        filtering, and other interactive features.
        
        Returns:
            str: URL of the interactive table interface
        """
        ...

    def interactive_embed(self, *args, **kwargs) -> Any:
        """
        Generate embedded iframe HTML for Jupyter notebooks
        
        Creates an interactive streaming nodes table that can be embedded directly
        in a Jupyter notebook cell, eliminating the need for a separate browser tab.
        
        Returns:
            str: HTML iframe code for embedding in Jupyter
        """
        ...

    def interactive_viz(self, *args, **kwargs) -> Any:
        """
        Launch interactive visualization for this NodesTable
        
        # Arguments
        * `port` - Optional port number (0 for auto-assign)
        * `layout` - Layout algorithm: \"force-directed\", \"circular\", \"grid\", \"hierarchical\"
        * `theme` - Visual theme: \"light\", \"dark\", \"publication\", \"minimal\"
        * `width` - Canvas width in pixels
        * `height` - Canvas height in pixels
        
        # Returns
        VizAccessor for launching interactive visualization
        """
        ...

    def into_base_table(self, *args, **kwargs) -> Any:
        """
        Convert to BaseTable (loses node-specific typing)
        """
        ...

    def is_empty(self, *args, **kwargs) -> Any:
        """
        Check whether the table contains any rows
        """
        ...

    def iter(self, *args, **kwargs) -> Any:
        """
        Explicit row iterator matching the Python iteration protocol.
        """
        ...

    def ncols(self, *args, **kwargs) -> Any:
        """
        Get number of columns
        """
        ...

    def node_ids(self, *args, **kwargs) -> Any:
        """
        Get node IDs
        """
        ...

    def nrows(self, *args, **kwargs) -> Any:
        """
        Get number of rows
        """
        ...

    def rich_display(self, *args, **kwargs) -> Any:
        """
        Get rich display representation with NodesTable type
        """
        ...

    def select(self, *args, **kwargs) -> Any:
        """
        Select specific columns to create a new table
        
        Args:
            columns: List of column names to select
        
        Returns:
            PyNodesTable: A new table with only the selected columns
        """
        ...

    def shape(self, *args, **kwargs) -> Any:
        """
        Get shape as (rows, cols)
        """
        ...

    def slice(self, *args, **kwargs) -> Any:
        """
        Get a slice of rows [start, end)
        
        Args:
            start: Starting row index (inclusive)
            end: Ending row index (exclusive)
        
        Returns:
            PyNodesTable: A new table with the specified row slice
        """
        ...

    def sort_by(self, *args, **kwargs) -> Any:
        """
        Sort table by column
        
        Args:
            column: Name of the column to sort by
            ascending: If True, sort in ascending order; if False, descending
        
        Returns:
            PyNodesTable: A new sorted table
        """
        ...

    def sort_values(self, *args, **kwargs) -> Any:
        """
        Sort table by multiple columns with mixed ascending/descending order
        Pandas-style multi-column sorting with priority order
        
        Args:
            columns: List of column names to sort by (in priority order)
            ascending: List of booleans for sort direction per column.
                      If single bool, applies to all columns.
                      If list, must match length of columns.
        
        Returns:
            PyNodesTable: A new sorted table
        """
        ...

    def tail(self, *args, **kwargs) -> Any:
        """
        Get last n rows (default 5)
        """
        ...

    def to_csv(self, *args, **kwargs) -> Any:
        """
        Export NodesTable to CSV file
        """
        ...

    def to_json(self, *args, **kwargs) -> Any:
        """
        Export NodesTable to JSON file
        """
        ...

    def to_pandas(self, *args, **kwargs) -> Any:
        """
        Convert to pandas DataFrame
        """
        ...

    def to_parquet(self, *args, **kwargs) -> Any:
        """
        Export NodesTable to Parquet file
        """
        ...

    def unique_attr_values(self, *args, **kwargs) -> Any:
        """
        Get unique values for an attribute
        """
        ...

    def with_attributes(self, *args, **kwargs) -> Any:
        """
        Add node attributes - flexible input format
        
        Args:
            attr_name: Name of the attribute column to add  
            attributes: Can be:
                - Dictionary mapping node_id to value: {0: "Alice", 1: "Bob"}
                - List of {"id": node_id, "value": value} dicts: [{"id": 0, "value": "Alice"}]
                - HashMap<NodeId, PyAttrValue> (advanced usage)
        
        Returns:
            PyNodesTable: A new table with the attributes added
        """
        ...


class NumArray:
    """
    Unified statistical array supporting all numeric types internally
    """
    @property
    def dtype(self) -> Any:
        """
        Get the dtype of this array
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __iter__(self) -> Iterator:
        """
        Implement iter(self).
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def contains(self, *args, **kwargs) -> Any:
        """
        Check whether the array contains the provided value
        """
        ...

    def count(self, *args, **kwargs) -> Any:
        """
        Count non-null values (for NumArray, all values are non-null by default)
        """
        ...

    def first(self, *args, **kwargs) -> Any:
        """
        Get first element
        """
        ...

    def is_empty(self, *args, **kwargs) -> Any:
        """
        Check if empty
        """
        ...

    def last(self, *args, **kwargs) -> Any:
        """
        Get last element  
        """
        ...

    def max(self, *args, **kwargs) -> Any:
        """
        Find the maximum value
        """
        ...

    def mean(self, *args, **kwargs) -> Any:
        """
        Calculate the mean (average)
        """
        ...

    def min(self, *args, **kwargs) -> Any:
        """
        Find the minimum value
        """
        ...

    def nunique(self, *args, **kwargs) -> Any:
        """
        Count unique values
        """
        ...

    def reshape(self, *args, **kwargs) -> Any:
        """
        Matrix Integration: Reshape NumArray into a GraphMatrix
        """
        ...

    def std(self, *args, **kwargs) -> Any:
        """
        Calculate standard deviation
        """
        ...

    def sum(self, *args, **kwargs) -> Any:
        """
        Calculate the sum
        """
        ...

    def to_list(self, *args, **kwargs) -> Any:
        """
        Convert to Python list
        """
        ...

    def to_type(self, *args, **kwargs) -> Any:
        """
        Convert to different numeric type
        """
        ...

    def unique(self, *args, **kwargs) -> Any:
        """
        Get unique values as a new NumArray
        """
        ...

    def var(self, *args, **kwargs) -> Any:
        """
        Calculate variance
        """
        ...


class PyAttributeCollection:
    """
    Python wrapper for high-performance attribute collections
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def compute_stats(self, *args, **kwargs) -> Any:
        """
        Compute statistics directly in Rust
        """
        ...

    def len(self, *args, **kwargs) -> Any:
        """
        Get count of attributes without converting
        """
        ...

    def sample_values(self, *args, **kwargs) -> Any:
        """
        Get sample values without converting all
        """
        ...


class PyComponentsArrayIterator:
    """
    Iterator for ComponentsArray
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __iter__(self) -> Iterator:
        """
        Implement iter(self).
        """
        ...

    def __next__(self) -> Any:
        """
        Implement next(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...


class PyNumArrayIterator:
    """
    Iterator for PyNumArray
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __iter__(self) -> Iterator:
        """
        Implement iter(self).
        """
        ...

    def __next__(self) -> Any:
        """
        Implement next(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...


class PyResultHandle:
    """
    Native result handle that keeps data in Rust
    """
    @property
    def edges(self) -> Any:
        ...

    @property
    def nodes(self) -> Any:
        ...

    @property
    def result_type(self) -> Any:
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...


class PySubgraphArrayIterator:
    """
    Python iterator for PySubgraphArray
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __iter__(self) -> Iterator:
        """
        Implement iter(self).
        """
        ...

    def __next__(self) -> Any:
        """
        Implement next(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...


class PyTableArrayCoreIterator:
    """
    Python iterator for core TableArray
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __iter__(self) -> Iterator:
        """
        Implement iter(self).
        """
        ...

    def __next__(self) -> Any:
        """
        Implement next(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def collect(self, *args, **kwargs) -> Any:
        """
        Collect back to TableArray
        """
        ...


class PyTableArrayIterator:
    """
    Python iterator for PyTableArray
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __iter__(self) -> Iterator:
        """
        Implement iter(self).
        """
        ...

    def __next__(self) -> Any:
        """
        Implement next(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...


class StatsArray:
    """
    Unified statistical array supporting all numeric types internally
    """
    @property
    def dtype(self) -> Any:
        """
        Get the dtype of this array
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __iter__(self) -> Iterator:
        """
        Implement iter(self).
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def contains(self, *args, **kwargs) -> Any:
        """
        Check whether the array contains the provided value
        """
        ...

    def count(self, *args, **kwargs) -> Any:
        """
        Count non-null values (for NumArray, all values are non-null by default)
        """
        ...

    def first(self, *args, **kwargs) -> Any:
        """
        Get first element
        """
        ...

    def is_empty(self, *args, **kwargs) -> Any:
        """
        Check if empty
        """
        ...

    def last(self, *args, **kwargs) -> Any:
        """
        Get last element  
        """
        ...

    def max(self, *args, **kwargs) -> Any:
        """
        Find the maximum value
        """
        ...

    def mean(self, *args, **kwargs) -> Any:
        """
        Calculate the mean (average)
        """
        ...

    def min(self, *args, **kwargs) -> Any:
        """
        Find the minimum value
        """
        ...

    def nunique(self, *args, **kwargs) -> Any:
        """
        Count unique values
        """
        ...

    def reshape(self, *args, **kwargs) -> Any:
        """
        Matrix Integration: Reshape NumArray into a GraphMatrix
        """
        ...

    def std(self, *args, **kwargs) -> Any:
        """
        Calculate standard deviation
        """
        ...

    def sum(self, *args, **kwargs) -> Any:
        """
        Calculate the sum
        """
        ...

    def to_list(self, *args, **kwargs) -> Any:
        """
        Convert to Python list
        """
        ...

    def to_type(self, *args, **kwargs) -> Any:
        """
        Convert to different numeric type
        """
        ...

    def unique(self, *args, **kwargs) -> Any:
        """
        Get unique values as a new NumArray
        """
        ...

    def var(self, *args, **kwargs) -> Any:
        """
        Calculate variance
        """
        ...


class Subgraph:
    """
    Python wrapper for core Subgraph - Pure delegation to existing trait methods
    
    This completely replaces the complex dual-mode PySubgraph with simple delegation
    to the existing SubgraphOperations trait methods. Same API, much simpler implementation.
    """
    @property
    def edge_ids(self) -> NumArray:
        """
        Get edge IDs as PyIntArray
        """
        ...

    @property
    def edges(self) -> EdgesAccessor:
        """
        Get edges as a property that supports indexing and attribute access
        """
        ...

    @property
    def hierarchy_level(self) -> Any:
        """
        Get hierarchy level of this subgraph (0 = root level)
        """
        ...

    @property
    def node_ids(self) -> NumArray:
        """
        Get node IDs as PyIntArray
        """
        ...

    @property
    def nodes(self) -> NodesAccessor:
        """
        Get nodes as a property that supports indexing and attribute access
        """
        ...

    @property
    def viz(self) -> Any:
        """
        Get viz accessor for visualization operations
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def adjacency_list(self, *args, **kwargs) -> Any:
        """
        Get adjacency list representation
        Returns: Dict mapping node_id -> list of connected node_ids
        """
        ...

    def bfs(self, *args, **kwargs) -> Any:
        """
        BFS traversal - returns subgraph result
        """
        ...

    def calculate_similarity(self, *args, **kwargs) -> Any:
        """
        Calculate similarity between subgraphs using various metrics
        """
        ...

    def child_meta_nodes(self, *args, **kwargs) -> Any:
        """
        Get child meta-nodes if this subgraph contains them
        NOTE: This feature is not yet implemented - always returns empty list
        """
        ...

    def clustering_coefficient(self, *args, **kwargs) -> Any:
        """
        Calculate clustering coefficient for a node or entire subgraph
        """
        ...

    def collapse(self, *args, **kwargs) -> Any:
        """
        Modern MetaGraph Composer API - Clean interface for meta-node creation
        
        This is the new, intuitive way to create meta-nodes with flexible configuration.
        Returns a MetaNodePlan that can be previewed, modified, and executed.
        
        # Arguments
        * `node_aggs` - Node aggregation specifications (dict or list format)
        * `edge_aggs` - Edge aggregation specifications (dict format)
        * `edge_strategy` - Edge handling strategy ("aggregate", "keep_external", "drop_all", "contract_all")
        * `node_strategy` - Node handling strategy ("extract", "collapse")
        * `preset` - Optional preset name ("social_network", "org_hierarchy", "flow_network")
        * `include_edge_count` - Include edge_count attribute in meta-edges
        * `mark_entity_type` - Mark meta-nodes/edges with entity_type
        * `entity_type` - Entity type for marking
        
        # Examples
        ```python
        # Dict format for node aggregations
        plan = subgraph.collapse(
            node_aggs={"avg_salary": ("mean", "salary"), "size": "count"},
            edge_aggs={"weight": "mean"},
            edge_strategy="aggregate",
            node_strategy="extract"
        )
        meta_node = plan.add_to_graph()
        
        # With preset
        plan = subgraph.collapse(preset="social_network")
        meta_node = plan.add_to_graph()
        ```
        """
        ...

    def connected_components(self, *args, **kwargs) -> ComponentsArray:
        """
        Get connected components within this subgraph (lazy array)
        """
        ...

    def contains_edge(self, *args, **kwargs) -> Any:
        """
        Check if subgraph contains a specific edge (alias for has_edge)  
        """
        ...

    def contains_node(self, *args, **kwargs) -> Any:
        """
        Check if subgraph contains a specific node (alias for has_node)
        """
        ...

    def degree(self, *args, **kwargs) -> Any:
        """
        Get degree of nodes in subgraph as GraphArray
        
        Usage:
        - degree(node_id, full_graph=False) -> int: degree of single node (local or full graph)
        - degree(node_ids, full_graph=False) -> GraphArray: degrees for list of nodes
        - degree(full_graph=False) -> GraphArray: degrees for all nodes in subgraph
        
        Parameters:
        - nodes: Optional node ID, list of node IDs, or None for all nodes
        - full_graph: If False (default), compute degrees within subgraph only.
                      If True, compute degrees from the original full graph.
        """
        ...

    def density(self, *args, **kwargs) -> Any:
        """
        Calculate density of this subgraph
        """
        ...

    def dfs(self, *args, **kwargs) -> Any:
        """
        DFS traversal - returns subgraph result
        """
        ...

    def edge_count(self, *args, **kwargs) -> Any:
        """
        Edge count property
        """
        ...

    def edge_endpoints(self, *args, **kwargs) -> Any:
        """
        Get edge endpoints (source, target)
        """
        ...

    def edges_table(self, *args, **kwargs) -> Any:
        """
        Convert subgraph edges to a table - pure delegation to core GraphTable
        """
        ...

    def entity_type(self, *args, **kwargs) -> Any:
        """
        Return the entity type string
        """
        ...

    def filter_edges(self, *args, **kwargs) -> Subgraph:
        """
        Filter edges and return new subgraph
        """
        ...

    def filter_nodes(self, *args, **kwargs) -> Subgraph:
        """
        Filter nodes and return new subgraph  
        """
        ...

    def get_edge_attribute(self, *args, **kwargs) -> Any:
        """
        Get a single edge attribute value
        """
        ...

    def get_node_attribute(self, *args, **kwargs) -> Any:
        """
        Get a single node attribute value
        """
        ...

    def group_by(self, *args, **kwargs) -> Any:
        """
        Group subgraph by attribute value
        
        Args:
            attr_name: Name of the attribute to group by
            element_type: Either 'nodes' or 'edges' to specify what to group
        
        Returns:
            SubgraphArray: Array of subgraphs, one for each unique attribute value
        
        Example:
            dept_groups = subgraph.group_by('department', 'nodes')
            type_groups = subgraph.group_by('interaction_type', 'edges')
        """
        ...

    def has_edge(self, *args, **kwargs) -> Any:
        """
        Check if an edge exists in this subgraph
        """
        ...

    def has_edge_between(self, *args, **kwargs) -> Any:
        """
        Check if edge exists between two nodes
        """
        ...

    def has_meta_nodes(self, *args, **kwargs) -> Any:
        """
        Check if this subgraph contains nodes that are meta-nodes
        """
        ...

    def has_node(self, *args, **kwargs) -> Any:
        """
        Check if a node exists in this subgraph
        """
        ...

    def has_path(self, *args, **kwargs) -> Any:
        """
        Check if there is a path between two nodes within this subgraph
        
        This is more efficient than `shortest_path_subgraph` when you only need
        to know if a path exists, not the actual path.
        
        # Arguments
        * `node1_id` - The starting node ID
        * `node2_id` - The destination node ID
        
        # Returns
        * `True` if a path exists between the nodes within this subgraph
        * `False` if no path exists or either node is not in this subgraph
        
        # Example
        ```python
        # Check if there's a path between node 1 and node 5 in the subgraph
        path_exists = subgraph.has_path(1, 5)
        ```
        """
        ...

    def in_degree(self, *args, **kwargs) -> Any:
        """
        Get in-degree of nodes within subgraph
        """
        ...

    def induced_subgraph(self, *args, **kwargs) -> Any:
        """
        Create induced subgraph from list of nodes
        """
        ...

    def intersect_with(self, *args, **kwargs) -> Any:
        ...

    def is_connected(self, *args, **kwargs) -> Any:
        """
        Check if this subgraph is connected
        """
        ...

    def is_empty(self, *args, **kwargs) -> Any:
        """
        Check if subgraph is empty
        """
        ...

    def merge_with(self, *args, **kwargs) -> Any:
        """
        Set operations - merge, intersect, subtract (placeholders)
        """
        ...

    def meta_nodes(self, *args, **kwargs) -> Any:
        """
        Get all meta-nodes within this subgraph
        """
        ...

    def neighborhood(self, *args, **kwargs) -> Any:
        """
        Compute neighborhoods from this subgraph and return them as a SubgraphArray
        """
        ...

    def neighbors(self, *args, **kwargs) -> Any:
        """
        Get neighbors of a node within the subgraph
        """
        ...

    def node_count(self, *args, **kwargs) -> Any:
        """
        Node count property
        """
        ...

    def out_degree(self, *args, **kwargs) -> Any:
        """
        Get out-degree of nodes within subgraph
        """
        ...

    def parent_meta_node(self, *args, **kwargs) -> Any:
        """
        Enhanced collapse supporting three syntax forms for flexible aggregation
        
        # Supported Syntax Forms:
        
        ## Form 1: Simple (backward compatible)
        ```python
        subgraph.add_to_graph({"age": "mean", "salary": "sum"})
        ```
        
        ## Form 2: Tuple (custom attribute names)
        ```python
        subgraph.add_to_graph({
            "avg_age": ("mean", "age"),
            "total_salary": ("sum", "salary"),
            "person_count": ("count", None)
        })
        ```
        
        ## Form 3: Dict-of-dicts (advanced with defaults)
        ```python
        subgraph.add_to_graph({
            "avg_age": {"func": "mean", "source": "age"},
            "total_salary": {"func": "sum", "source": "salary", "default": 0}
        })
        ```
        Get parent meta-node if this subgraph is contained within one
        NOTE: This feature is not yet implemented - always returns None
        """
        ...

    def sample(self, *args, **kwargs) -> Any:
        """
        Sample k nodes from this subgraph randomly
        """
        ...

    def set_edge_attrs(self, *args, **kwargs) -> Any:
        """
        Set multiple edge attributes (bulk operation) - delegates to accessor  
        """
        ...

    def set_node_attrs(self, *args, **kwargs) -> Any:
        """
        Set multiple node attributes (bulk operation) - delegates to accessor
        """
        ...

    def shortest_path_subgraph(self, *args, **kwargs) -> Any:
        """
        Create subgraph representing shortest path between two nodes
        """
        ...

    def subgraph_from_edges(self, *args, **kwargs) -> Any:
        """
        Create subgraph from list of edges
        """
        ...

    def subtract_from(self, *args, **kwargs) -> Any:
        ...

    def summary(self, *args, **kwargs) -> Any:
        """
        Get text summary of subgraph
        """
        ...

    def table(self, *args, **kwargs) -> Any:
        """
        Convert subgraph to a GraphTable containing both nodes and edges
        Pure delegation to core GraphTable
        """
        ...

    def to_edges(self, *args, **kwargs) -> Any:
        """
        Get edges from this subgraph as an EdgesAccessor  
        Enables chaining like: subgraph.to_edges().to_nodes().connected_components()
        """
        ...

    def to_graph(self, *args, **kwargs) -> Any:
        """
        Convert to a new independent graph
        """
        ...

    def to_matrix(self, *args, **kwargs) -> Any:
        """
        Convert this subgraph to its adjacency matrix representation
        Enables chaining like: subgraph.to_matrix().eigen().stats()
        """
        ...

    def to_networkx(self, *args, **kwargs) -> Any:
        """
        Convert to NetworkX graph (if available)
        
        Returns a NetworkX Graph or DiGraph (depending on the parent graph type)
        containing only the nodes and edges from this subgraph, with all attributes preserved.
        
        # Returns
        * `PyObject` - A NetworkX graph object containing only this subgraph
        
        # Raises
        * `ImportError` - If NetworkX is not installed
        * `RuntimeError` - If conversion fails
        
        # Examples
        ```python
        import groggy
        import networkx as nx
        
        g = groggy.Graph()
        # ... add nodes and edges ...
        subgraph = g.filter_nodes("age > 25")
        nx_subgraph = subgraph.to_networkx()
        ```
        """
        ...

    def to_nodes(self, *args, **kwargs) -> Any:
        """
        Get nodes from this subgraph as a NodesAccessor
        Enables chaining like: subgraph.to_nodes().table().stats()
        """
        ...

    def transitivity(self, *args, **kwargs) -> Any:
        """
        Calculate transitivity of the subgraph
        """
        ...


class SubgraphArray:
    """
    Specialized array for PySubgraph objects
    
    Note: Uses Arc<Vec<PySubgraph>> for zero-copy sharing. PySubgraph is marked
    as `unsendable` so this won't be used across threads. Arc is used here for
    efficient cloning/sharing within a single thread.
    """
    @property
    def viz(self) -> Any:
        """
        Get viz accessor for visualization operations
        """
        ...

    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __iter__(self) -> Iterator:
        """
        Implement iter(self).
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def collapse(self, *args, **kwargs) -> Any:
        """
        Collapse each subgraph using the Subgraph.collapse API and materialize meta-nodes.
        """
        ...

    def collect(self, *args, **kwargs) -> Any:
        """
        Collect all subgraphs into a Python list (for compatibility with iterator patterns)
        """
        ...

    def edges_table(self, *args, **kwargs) -> Any:
        """
        Get edges tables from all subgraphs as TableArray
        
        Returns a TableArray where each table contains the edges from one subgraph
        with all their attributes
        
        Example:
            components = g.connected_components()
            edge_tables = components.edges_table()
            # Returns TableArray with one table per component
        """
        ...

    def extract_node_attribute(self, *args, **kwargs) -> Any:
        """
        Extract a node attribute from all subgraphs and return as ArrayArray
        """
        ...

    def group_by(self, *args, **kwargs) -> Any:
        """
        Apply group_by to all subgraphs and flatten results
        
        Args:
            attr_name: Name of the attribute to group by
            element_type: Either 'nodes' or 'edges' to specify what to group
        
        Returns:
            SubgraphArray: Flattened array of all grouped subgraphs
        
        Example:
            nested_groups = subgraph_array.group_by('department', 'nodes')
            # Returns all department groups from all input subgraphs
        """
        ...

    def is_empty(self, *args, **kwargs) -> Any:
        """
        Check if the array is empty
        """
        ...

    def map(self, *args, **kwargs) -> Any:
        """
        Map a function over all subgraphs and return a BaseArray
        
        Args:
            func: Python callable that takes a Subgraph and returns a numeric value
        
        Returns:
            BaseArray containing the results
        
        Example:
        ```python
        # Get node count for each subgraph
        node_counts = subgraph_array.map(lambda sg: sg.node_count())
        
        # Get average degree
        avg_degrees = subgraph_array.map(lambda sg: sum(sg.degrees()) / sg.node_count())
        ```
        """
        ...

    def merge(self, *args, **kwargs) -> Any:
        """
        Merge all subgraphs into a single Graph
        
        Combines all nodes and edges from all subgraphs into one unified graph.
        Node and edge IDs are preserved from the original graph.
        Duplicate nodes/edges are handled by taking the first occurrence.
        
        Returns:
            PyGraph containing all merged subgraphs
        
        Example:
        ```python
        # Group by department, then merge back
        dept_groups = g.nodes.group_by('department')
        merged_graph = dept_groups.merge()
        ```
        """
        ...

    def nodes_table(self, *args, **kwargs) -> Any:
        """
        Get nodes tables from all subgraphs as TableArray
        
        Returns a TableArray where each table contains the nodes from one subgraph
        with all their attributes
        
        Example:
            components = g.connected_components()
            node_tables = components.nodes_table()
            # Returns TableArray with one table per component
        """
        ...

    def sample(self, *args, **kwargs) -> Any:
        """
        Apply sample(k) to all subgraphs
        """
        ...

    def summary(self, *args, **kwargs) -> Any:
        """
        Get summary statistics for all subgraphs as a BaseTable
        
        Returns a table with one row per subgraph containing:
        - subgraph_id: Index of the subgraph
        - node_count: Number of nodes in the subgraph
        - edge_count: Number of edges in the subgraph
        - density: Edge density of the subgraph
        
        Example:
            components = g.connected_components()
            summary = components.summary()
            print(summary)
        """
        ...

    def table(self, *args, **kwargs) -> Any:
        """
        Apply table() to all subgraphs and return PyTableArray
        """
        ...

    def to_list(self, *args, **kwargs) -> Any:
        """
        Convert to Python list
        """
        ...


class TableArray:
    """
    Python wrapper for core TableArray
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __getitem__(self, key: Any) -> Any:
        """
        Return self[key].
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __iter__(self) -> Iterator:
        """
        Implement iter(self).
        """
        ...

    def __len__(self) -> int:
        """
        Return len(self).
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def agg(self, *args, **kwargs) -> Any:
        """
        Generic aggregation with function specifications
        """
        ...

    def apply(self, *args, **kwargs) -> Any:
        """
        Apply function to each table (returns TableArray)
        """
        ...

    def apply_reduce(self, *args, **kwargs) -> Any:
        """
        Apply function to each table and reduce to single value
        """
        ...

    def apply_to_array(self, *args, **kwargs) -> Any:
        """
        Apply function to each table and return BaseArray of results
        """
        ...

    def apply_to_list(self, *args, **kwargs) -> Any:
        """
        Apply function to each table and return list of results
        """
        ...

    def concat(self, *args, **kwargs) -> Any:
        """
        Concatenate all tables into one
        """
        ...

    def count(self, *args, **kwargs) -> Any:
        """
        Count aggregation across all tables
        """
        ...

    def describe(self, *args, **kwargs) -> Any:
        """
        Describe statistics for each table
        """
        ...

    def drop_columns(self, *args, **kwargs) -> Any:
        """
        Drop columns from each table
        """
        ...

    def filter(self, *args, **kwargs) -> Any:
        """
        Filter tables with a Python predicate function
        """
        ...

    def head(self, *args, **kwargs) -> Any:
        """
        Get first n rows from each table
        """
        ...

    def is_empty(self, *args, **kwargs) -> Any:
        """
        Check if empty
        """
        ...

    def iter(self, *args, **kwargs) -> Any:
        """
        Convenience method for fluent chaining
        """
        ...

    def map(self, *args, **kwargs) -> Any:
        """
        Apply a function to each table
        """
        ...

    def max_column(self, *args, **kwargs) -> Any:
        """
        Maximum value in a column across all tables
        """
        ...

    def mean(self, *args, **kwargs) -> Any:
        """
        Mean aggregation across all tables
        """
        ...

    def mean_column(self, *args, **kwargs) -> Any:
        """
        Mean of values in a column across all tables
        """
        ...

    def min_column(self, *args, **kwargs) -> Any:
        """
        Minimum value in a column across all tables
        """
        ...

    def rename(self, *args, **kwargs) -> Any:
        """
        Rename columns in each table
        """
        ...

    def sample(self, *args, **kwargs) -> Any:
        """
        Sample n rows from each table
        """
        ...

    def select(self, *args, **kwargs) -> Any:
        """
        Select specific columns from each table
        """
        ...

    def shape(self, *args, **kwargs) -> Any:
        """
        Get shape (num_tables, avg_rows_per_table)
        """
        ...

    def shape_detailed(self, *args, **kwargs) -> Any:
        """
        Get detailed shape (num_tables, total_rows, num_cols)
        """
        ...

    def skip(self, *args, **kwargs) -> Any:
        """
        Skip first n tables
        """
        ...

    def sort_by(self, *args, **kwargs) -> Any:
        """
        Sort each table by column
        """
        ...

    def std_column(self, *args, **kwargs) -> Any:
        """
        Standard deviation of values in a column across all tables
        """
        ...

    def sum(self, *args, **kwargs) -> Any:
        """
        Sum aggregation across all tables
        """
        ...

    def sum_column(self, *args, **kwargs) -> Any:
        """
        Sum values in a column across all tables
        """
        ...

    def tail(self, *args, **kwargs) -> Any:
        """
        Get last n rows from each table
        """
        ...

    def take(self, *args, **kwargs) -> Any:
        """
        Take first n tables
        """
        ...

    def to_list(self, *args, **kwargs) -> Any:
        """
        Convert to list of tables
        """
        ...

    def total_count(self, *args, **kwargs) -> Any:
        """
        Get total row count across all tables
        """
        ...


class TableArrayIterator:
    """
    Chainable iterator for PyTableArray that supports method forwarding
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def agg(self, *args, **kwargs) -> Any:
        """
        Apply aggregation to each table and return list of results
        """
        ...

    def collect(self, *args, **kwargs) -> Any:
        """
        Materialize iterator back into PyTableArray
        """
        ...

    def filter(self, *args, **kwargs) -> Any:
        """
        Apply filter to each table
        """
        ...

    def group_by(self, *args, **kwargs) -> Any:
        """
        Apply group_by to each table - placeholder method
        """
        ...

    def join(self, *args, **kwargs) -> Any:
        """
        Join with another iterator of tables - simplified implementation
        """
        ...

    def skip(self, *args, **kwargs) -> Any:
        """
        Skip first n tables
        """
        ...

    def take(self, *args, **kwargs) -> Any:
        """
        Take first n tables
        """
        ...


class TableFormatter:
    """
    Python wrapper for table formatting functions
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def format_data_structure(self, *args, **kwargs) -> Any:
        """
        Format any data structure automatically
        """
        ...

    def format_table(self, *args, **kwargs) -> Any:
        """
        Format table data using Rust formatter
        """
        ...


class VizAccessor:
    """
    VizAccessor provides visualization methods for groggy objects
    """
    def __eq__(self, other: Any) -> bool:
        """
        Return self==value.
        """
        ...

    def __hash__(self) -> int:
        """
        Return hash(self).
        """
        ...

    def __init__(self, *args, **kwargs) -> None:
        """
        Initialize self.  See help(type(self)) for accurate signature.
        """
        ...

    def __repr__(self) -> str:
        """
        Return repr(self).
        """
        ...

    def __str__(self) -> str:
        """
        Return str(self).
        """
        ...

    def create_fallback_visualization(self, *args, **kwargs) -> Any:
        """
        Create a basic fallback visualization for objects that don't have direct viz support
        """
        ...

    def server(self, *args, **kwargs) -> Any:
        """
        Show visualization in standalone server mode using realtime backend
        """
        ...

    def show(self, *args, **kwargs) -> Any:
        """
        Show visualization with Realtime backend using proper DataSource integration
        Now supports server reuse - updates existing servers instead of creating new ones
        """
        ...

    def update(self, *args, **kwargs) -> Any:
        """
        Update visualization parameters - sends control message to existing server
        """
        ...

