define(["@jupyter-widgets/base"],e=>(()=>{"use strict";var t={55:t=>{t.exports=e},384:(e,t,i)=>{i.r(t),i.d(t,{load_ipython_extension:()=>c});var s=i(55);class n{constructor(e={}){this.config={charge:-300,distance:50,damping:.9,iterations:100,threshold:.01,timeStep:.016,...e},this.isRunning=!1,this.iteration=0,this.totalEnergy=0,console.log("⚡ PhysicsEngine initialized:",this.config)}updatePositions(e,t,i,s,n=.016){if(!this.isRunning||0===e.length)return;const o=new Map;e.forEach(e=>{o.set(e.id,{x:0,y:0})}),this.calculateRepulsionForces(e,i,o),this.calculateAttractionForces(t,i,o),this.integrateForces(e,i,s,o,n),this.iteration++,this.totalEnergy=this.calculateTotalEnergy(s),this.totalEnergy<this.config.threshold&&this.pause()}calculateRepulsionForces(e,t,i){for(let s=0;s<e.length;s++)for(let n=s+1;n<e.length;n++){const o=e[s],r=e[n],a=t.get(o.id),h=t.get(r.id);if(!a||!h)continue;const d=h.x-a.x,l=h.y-a.y,g=Math.sqrt(d*d+l*l)||1,c=this.config.charge/(g*g),u=c*d/g,p=c*l/g,m=i.get(o.id),f=i.get(r.id);m.x-=u,m.y-=p,f.x+=u,f.y+=p}}calculateAttractionForces(e,t,i){e.forEach(e=>{const s=t.get(e.source),n=t.get(e.target),o=i.get(e.source),r=i.get(e.target);if(!(s&&n&&o&&r))return;const a=n.x-s.x,h=n.y-s.y,d=Math.sqrt(a*a+h*h)||1,l=.1*(d-this.config.distance),g=l*a/d,c=l*h/d;o.x+=g,o.y+=c,r.x-=g,r.y-=c})}integrateForces(e,t,i,s,n){e.forEach(e=>{const o=t.get(e.id),r=i.get(e.id),a=s.get(e.id);o&&r&&a&&(r.x+=a.x*n,r.y+=a.y*n,r.x*=this.config.damping,r.y*=this.config.damping,o.x+=r.x*n,o.y+=r.y*n,o.x=Math.max(50,Math.min(750,o.x)),o.y=Math.max(50,Math.min(550,o.y)))})}calculateTotalEnergy(e){let t=0;for(const i of e.values())t+=i.x*i.x+i.y*i.y;return t}start(){this.isRunning=!0,this.iteration=0,console.log("▶️ PhysicsEngine started")}stop(){this.isRunning=!1,console.log("⏹️ PhysicsEngine stopped")}pause(){this.isRunning=!1,console.log("⏸️ PhysicsEngine paused (converged)")}updateConfig(e){this.config={...this.config,...e},console.log("⚙️ PhysicsEngine config updated:",this.config)}getState(){return{isRunning:this.isRunning,iteration:this.iteration,totalEnergy:this.totalEnergy,config:this.config}}reset(){this.iteration=0,this.totalEnergy=0,console.log("🔄 PhysicsEngine reset")}}class o{constructor(e={}){this.config={width:800,height:600,nodeRadius:8,edgeWidth:1,nodeColor:"#007bff",edgeColor:"#999",backgroundColor:"#ffffff",enableLOD:!0,lodThreshold:1e3,enableLabels:!0,labelThreshold:100,...e},this.element=null,this.svg=null,this.nodesGroup=null,this.edgesGroup=null,this.labelsGroup=null,this.frameCount=0,this.lastRenderTime=0,this.renderTimes=[],console.log("🎨 SVGRenderer initialized:",this.config)}attachToElement(e){this.element=e,this.createSVGStructure(),console.log("🔗 SVGRenderer attached to element")}createSVGStructure(){this.element&&(this.element.innerHTML="",this.svg=document.createElementNS("http://www.w3.org/2000/svg","svg"),this.svg.setAttribute("width",this.config.width),this.svg.setAttribute("height",this.config.height),this.svg.style.backgroundColor=this.config.backgroundColor,this.svg.style.border="1px solid #ddd",this.edgesGroup=document.createElementNS("http://www.w3.org/2000/svg","g"),this.edgesGroup.setAttribute("class","edges"),this.nodesGroup=document.createElementNS("http://www.w3.org/2000/svg","g"),this.nodesGroup.setAttribute("class","nodes"),this.labelsGroup=document.createElementNS("http://www.w3.org/2000/svg","g"),this.labelsGroup.setAttribute("class","labels"),this.svg.appendChild(this.edgesGroup),this.svg.appendChild(this.nodesGroup),this.svg.appendChild(this.labelsGroup),this.element.appendChild(this.svg))}render(e){if(!this.svg)return;const t=performance.now(),{nodes:i,edges:s,positions:n,frameCount:o}=e,r=this.config.enableLOD&&i.length>this.config.lodThreshold,a=this.config.enableLabels&&i.length<=this.config.labelThreshold;r?this.renderLOD(i,s,n):this.renderFull(i,s,n,a);const h=performance.now()-t;this.recordRenderTime(h),this.frameCount=o||this.frameCount+1}renderFull(e,t,i,s=!0){this.renderEdges(t,i),this.renderNodes(e,i),s?this.renderLabels(e,i):this.labelsGroup.innerHTML=""}renderLOD(e,t,i){this.renderEdgesLOD(t,i),this.renderNodesLOD(e,i),this.labelsGroup.innerHTML=""}renderEdges(e,t){this.edgesGroup.innerHTML="",e.forEach(e=>{const i=t.get?t.get(e.source):t[e.source],s=t.get?t.get(e.target):t[e.target];if(!i||!s)return;const n=document.createElementNS("http://www.w3.org/2000/svg","line");n.setAttribute("x1",i.x),n.setAttribute("y1",i.y),n.setAttribute("x2",s.x),n.setAttribute("y2",s.y),n.setAttribute("stroke",e.color||this.config.edgeColor),n.setAttribute("stroke-width",e.width||this.config.edgeWidth),n.setAttribute("opacity","0.8"),n.setAttribute("data-edge-id",e.id),this.edgesGroup.appendChild(n)})}renderEdgesLOD(e,t){this.edgesGroup.innerHTML="",e.forEach(e=>{const i=t.get?t.get(e.source):t[e.source],s=t.get?t.get(e.target):t[e.target];if(!i||!s)return;const n=document.createElementNS("http://www.w3.org/2000/svg","line");n.setAttribute("x1",i.x),n.setAttribute("y1",i.y),n.setAttribute("x2",s.x),n.setAttribute("y2",s.y),n.setAttribute("stroke",this.config.edgeColor),n.setAttribute("stroke-width","0.5"),n.setAttribute("opacity","0.6"),this.edgesGroup.appendChild(n)})}renderNodes(e,t){this.nodesGroup.innerHTML="",e.forEach(e=>{const i=t.get?t.get(e.id):t[e.id];if(!i)return;const s=document.createElementNS("http://www.w3.org/2000/svg","circle");s.setAttribute("cx",i.x),s.setAttribute("cy",i.y),s.setAttribute("r",e.size||this.config.nodeRadius),s.setAttribute("fill",e.color||this.config.nodeColor),s.setAttribute("stroke","#ffffff"),s.setAttribute("stroke-width","2"),s.setAttribute("opacity","0.9"),s.setAttribute("data-node-id",e.id),s.style.cursor="pointer",this.nodesGroup.appendChild(s)})}renderNodesLOD(e,t){this.nodesGroup.innerHTML="",e.forEach(e=>{const i=t.get?t.get(e.id):t[e.id];if(!i)return;const s=document.createElementNS("http://www.w3.org/2000/svg","circle");s.setAttribute("cx",i.x),s.setAttribute("cy",i.y),s.setAttribute("r","3"),s.setAttribute("fill",this.config.nodeColor),s.setAttribute("stroke","none"),s.setAttribute("opacity","0.8"),this.nodesGroup.appendChild(s)})}renderLabels(e,t){this.labelsGroup.innerHTML="",e.forEach(e=>{if(!e.label)return;const i=t.get?t.get(e.id):t[e.id];if(!i)return;const s=document.createElementNS("http://www.w3.org/2000/svg","text");s.setAttribute("x",i.x),s.setAttribute("y",i.y-(e.size||this.config.nodeRadius)-5),s.setAttribute("text-anchor","middle"),s.setAttribute("font-family","Arial, sans-serif"),s.setAttribute("font-size","12"),s.setAttribute("fill","#333"),s.textContent=e.label,this.labelsGroup.appendChild(s)})}recordRenderTime(e){this.renderTimes.push(e),this.renderTimes.length>60&&this.renderTimes.shift(),this.lastRenderTime=e}getPerformanceStats(){if(0===this.renderTimes.length)return null;const e=this.renderTimes.reduce((e,t)=>e+t,0)/this.renderTimes.length,t=Math.max(...this.renderTimes),i=Math.min(...this.renderTimes);return{averageRenderTime:e.toFixed(2),maxRenderTime:t.toFixed(2),minRenderTime:i.toFixed(2),frameCount:this.frameCount,fps:(1e3/e).toFixed(1)}}updateConfig(e){this.config={...this.config,...e},this.svg&&(e.width||e.height)&&(this.svg.setAttribute("width",this.config.width),this.svg.setAttribute("height",this.config.height)),console.log("⚙️ SVGRenderer config updated:",this.config)}clear(){this.nodesGroup&&(this.nodesGroup.innerHTML=""),this.edgesGroup&&(this.edgesGroup.innerHTML=""),this.labelsGroup&&(this.labelsGroup.innerHTML="")}exportSVG(){return this.svg?(new XMLSerializer).serializeToString(this.svg):null}}class r{constructor(e={}){this.config={enableDrag:!0,enableZoom:!0,enablePan:!0,enableMultiTouch:!0,dragThreshold:5,zoomSensitivity:.1,panSensitivity:1,...e},this.element=null,this.callbacks=new Map,this.state={isDragging:!1,isPanning:!1,draggedNode:null,lastMousePos:{x:0,y:0},dragStartPos:{x:0,y:0},zoom:1,pan:{x:0,y:0}},this.listeners=new Map,console.log("🖱️ InteractionEngine initialized:",this.config)}attachToElement(e,t={}){this.element=e,this.callbacks=new Map(Object.entries(t)),this.setupEventListeners(),console.log("🔗 InteractionEngine attached to element")}setupEventListeners(){this.element&&(this.addListener("mousedown",this.handleMouseDown.bind(this)),this.addListener("mousemove",this.handleMouseMove.bind(this)),this.addListener("mouseup",this.handleMouseUp.bind(this)),this.addListener("wheel",this.handleWheel.bind(this)),this.config.enableMultiTouch&&(this.addListener("touchstart",this.handleTouchStart.bind(this)),this.addListener("touchmove",this.handleTouchMove.bind(this)),this.addListener("touchend",this.handleTouchEnd.bind(this))),this.addListener("keydown",this.handleKeyDown.bind(this)),this.addListener("contextmenu",e=>e.preventDefault()))}addListener(e,t){this.element.addEventListener(e,t),this.listeners.has(e)||this.listeners.set(e,[]),this.listeners.get(e).push(t)}handleMouseDown(e){e.preventDefault();const t=this.element.getBoundingClientRect(),i={x:e.clientX-t.left,y:e.clientY-t.top};this.state.lastMousePos=i,this.state.dragStartPos={...i};const s=e.target,n=s.getAttribute("data-node-id"),o=s.getAttribute("data-edge-id");n&&this.config.enableDrag?(this.state.draggedNode=n,this.state.isDragging=!1,this.emit("node_mousedown",{nodeId:n,position:i,event:e})):o?this.emit("edge_click",{edgeId:o,position:i,event:e}):this.config.enablePan&&(this.state.isPanning=!0)}handleMouseMove(e){e.preventDefault();const t=this.element.getBoundingClientRect(),i={x:e.clientX-t.left,y:e.clientY-t.top},s=i.x-this.state.lastMousePos.x,n=i.y-this.state.lastMousePos.y;if(this.state.draggedNode){const e=Math.sqrt(Math.pow(i.x-this.state.dragStartPos.x,2)+Math.pow(i.y-this.state.dragStartPos.y,2));!this.state.isDragging&&e>this.config.dragThreshold&&(this.state.isDragging=!0,this.emit("drag_start",{nodeId:this.state.draggedNode,position:i})),this.state.isDragging&&this.emit("node_drag",{nodeId:this.state.draggedNode,position:i,delta:{x:s,y:n}})}else this.state.isPanning&&this.config.enablePan&&(this.state.pan.x+=s*this.config.panSensitivity,this.state.pan.y+=n*this.config.panSensitivity,this.emit("pan",{pan:{...this.state.pan},delta:{x:s,y:n}}));this.state.lastMousePos=i}handleMouseUp(e){e.preventDefault();const t=this.element.getBoundingClientRect(),i={x:e.clientX-t.left,y:e.clientY-t.top};this.state.draggedNode&&(this.state.isDragging?this.emit("drag_end",{nodeId:this.state.draggedNode,position:i}):this.emit("node_click",{nodeId:this.state.draggedNode,position:i,event:e}),this.state.draggedNode=null,this.state.isDragging=!1),this.state.isPanning&&(this.state.isPanning=!1,this.emit("pan_end",{pan:{...this.state.pan}}))}handleWheel(e){if(!this.config.enableZoom)return;e.preventDefault();const t=this.element.getBoundingClientRect(),i={x:e.clientX-t.left,y:e.clientY-t.top},s=-e.deltaY*this.config.zoomSensitivity*.01,n=Math.max(.1,Math.min(5,this.state.zoom+s));n!==this.state.zoom&&(this.state.zoom=n,this.emit("zoom",{zoom:this.state.zoom,center:i,delta:s}))}handleTouchStart(e){if(e.preventDefault(),1===e.touches.length){const t=e.touches[0],i={clientX:t.clientX,clientY:t.clientY,target:t.target,preventDefault:()=>{}};this.handleMouseDown(i)}}handleTouchMove(e){if(e.preventDefault(),1===e.touches.length){const t=e.touches[0],i={clientX:t.clientX,clientY:t.clientY,preventDefault:()=>{}};this.handleMouseMove(i)}}handleTouchEnd(e){e.preventDefault();const t={clientX:this.state.lastMousePos.x,clientY:this.state.lastMousePos.y,preventDefault:()=>{}};this.handleMouseUp(t)}handleKeyDown(e){if("Space"===e.code&&(e.preventDefault(),this.resetView()),this.config.enablePan){const t=20;let i=0,s=0;switch(e.code){case"ArrowLeft":i=-t;break;case"ArrowRight":i=t;break;case"ArrowUp":s=-t;break;case"ArrowDown":s=t}(i||s)&&(e.preventDefault(),this.state.pan.x+=i,this.state.pan.y+=s,this.emit("pan",{pan:{...this.state.pan},delta:{x:i,y:s}}))}}resetView(){this.state.zoom=1,this.state.pan={x:0,y:0},this.emit("view_reset",{zoom:this.state.zoom,pan:{...this.state.pan}})}processFrame(){}emit(e,t){const i=this.callbacks.get(e);if(i)try{i(t)}catch(t){console.error(`Error in interaction callback for ${e}:`,t)}}updateConfig(e){this.config={...this.config,...e},console.log("⚙️ InteractionEngine config updated:",this.config)}getState(){return{...this.state}}setState(e){this.state={...this.state,...e}}cleanup(){if(this.element){for(const[e,t]of this.listeners)t.forEach(t=>{this.element.removeEventListener(e,t)});this.listeners.clear(),console.log("🧹 InteractionEngine cleaned up")}}}class a{constructor(e=[],t=[],i={}){this.nodes=e,this.edges=t,this.config={width:800,height:600,...i,physics:{enabled:!0,charge:-300,distance:50,damping:.9,iterations:100,...i.physics},rendering:{width:i.width||800,height:i.height||600,nodeRadius:8,edgeWidth:1,...i.rendering},interaction:{enableDrag:!0,enableZoom:!0,enablePan:!0,...i.interaction}},this.physics=new n(this.config.physics),this.renderer=new o(this.config.rendering),this.interactions=new r(this.config.interaction),this.positions=new Map,this.velocities=new Map,this.isRunning=!1,this.frameCount=0,this.selectedNodes=new Set,this.nodePositions=this.positions,this.eventCallbacks=new Map,console.log("🎨 GroggyVizCore initialized:",{nodes:this.nodes.length,edges:this.edges.length,config:this.config})}update(e=null){return e?this.applyFrameData(e):this.physics.updatePositions(this.nodes,this.edges,this.positions,this.velocities,1/60),this.renderer.render({nodes:this.nodes,edges:this.edges,positions:this.positions,frameCount:this.frameCount++}),this.interactions.processFrame(),this.emit("frame",{nodes:this.nodes,edges:this.edges,positions:this.positions,frameCount:this.frameCount}),this.getFrameData()}applyFrameData(e){if(e.positions)for(const[t,i]of Object.entries(e.positions))this.positions.set(t,i);e.nodes&&(this.nodes=e.nodes),e.edges&&(this.edges=e.edges)}getFrameData(){return{nodes:this.nodes,edges:this.edges,positions:Object.fromEntries(this.positions),velocities:Object.fromEntries(this.velocities),frameCount:this.frameCount,timestamp:Date.now()}}attachToDOM(e,t={}){this.element=e,this.eventCallbacks=new Map(Object.entries(t)),this.renderer.attachToElement(e),this.interactions.attachToElement(e,{onNodeDrag:(e,t)=>{this.positions.set(e,t),this.emit("node_drag",{nodeId:e,position:t})},onNodeClick:e=>{this.emit("node_click",{nodeId:e})},onEdgeClick:e=>{this.emit("edge_click",{edgeId:e})}}),console.log("🔗 GroggyVizCore attached to DOM element:",e)}start(){this.isRunning=!0,this.physics.start(),this.animationLoop(),console.log("▶️ GroggyVizCore simulation started")}stop(){this.isRunning=!1,this.physics.stop(),console.log("⏹️ GroggyVizCore simulation stopped")}animationLoop(){this.isRunning&&(this.update(),requestAnimationFrame(()=>this.animationLoop()))}on(e,t){this.eventCallbacks.has(e)||this.eventCallbacks.set(e,[]),this.eventCallbacks.get(e).push(t)}emit(e,t){this.eventCallbacks.has(e)&&this.eventCallbacks.get(e).forEach(i=>{try{i(t)}catch(t){console.error(`Error in event callback for ${e}:`,t)}})}setData(e,t){this.nodes=e,this.edges=t,this.positions.clear(),this.velocities.clear(),this.frameCount=0,this.nodes.forEach((e,t)=>{if(!this.positions.has(e.id)){const i=2*t*Math.PI/this.nodes.length,s=Math.min(this.config.rendering.width,this.config.rendering.height)/4;this.positions.set(e.id,{x:this.config.rendering.width/2+s*Math.cos(i),y:this.config.rendering.height/2+s*Math.sin(i)})}this.velocities.has(e.id)||this.velocities.set(e.id,{x:0,y:0})}),this.emit("data_updated",{nodes:e,edges:t}),console.log("📊 GroggyVizCore data updated:",{nodes:e.length,edges:t.length})}getConfig(){return{...this.config}}updateConfig(e){this.config={...this.config,...e,physics:{...this.config.physics,...e.physics},rendering:{...this.config.rendering,...e.rendering},interaction:{...this.config.interaction,...e.interaction}},this.physics.updateConfig(this.config.physics),this.renderer.updateConfig(this.config.rendering),this.interactions.updateConfig(this.config.interaction),this.emit("config_updated",this.config),console.log("⚙️ GroggyVizCore config updated:",this.config)}exportState(){return{nodes:this.nodes,edges:this.edges,positions:Object.fromEntries(this.positions),velocities:Object.fromEntries(this.velocities),selectedNodes:Array.from(this.selectedNodes),config:this.config,frameCount:this.frameCount,timestamp:Date.now()}}destroy(){this.stop(),this.interactions&&"function"==typeof this.interactions.cleanup&&this.interactions.cleanup(),this.renderer&&"function"==typeof this.renderer.clear&&this.renderer.clear(),this.positions.clear(),this.velocities.clear(),this.selectedNodes.clear(),this.eventCallbacks.clear(),this.element=null,this.nodes=[],this.edges=[],console.log("🧹 GroggyVizCore destroyed")}}const h="groggy-widgets",d="0.1.0";class l extends s.DOMWidgetModel{defaults(){return Object.assign(Object.assign({},super.defaults()),{_model_name:"GroggyGraphModel",_model_module:h,_model_module_version:d,_view_name:"GroggyGraphView",_view_module:h,_view_module_version:d,nodes:[],edges:[],title:"Graph Visualization",width:800,height:600,layout_algorithm:"force-directed",theme:"light",physics_enabled:!0,force_strength:30,link_distance:50,link_strength:.1,charge_strength:-300,center_strength:.1,enable_drag:!0,enable_zoom:!0,enable_pan:!0,enable_selection:!0,enable_hover:!0,selected_nodes:[],hovered_node:"",camera_position:{scale:1,translate:{x:0,y:0}},is_dragging:!1,node_color_scheme:"default",background_color:"#ffffff",enable_shadows:!0,enable_animations:!0})}}l.model_name="GroggyGraphModel",l.model_module=h,l.model_module_version=d;class g extends s.DOMWidgetView{constructor(){super(...arguments),this.vizCore=null,this.container=null}render(){console.log("🧠 Initializing Groggy Jupyter widget with unified core"),this.el.style.cssText="\n      border: 2px solid #4CAF50;\n      padding: 10px;\n      margin: 10px;\n      border-radius: 8px;\n      background: #f9f9f9;\n      font-family: Arial, sans-serif;\n      min-height: 400px;\n      position: relative;\n      user-select: none;\n    ";const e=document.createElement("div");e.style.cssText="\n      font-weight: bold;\n      margin-bottom: 10px;\n      color: #333;\n      display: flex;\n      justify-content: space-between;\n      align-items: center;\n    ";const t=document.createElement("span");t.textContent=this.model.get("title")||"Graph Visualization",e.appendChild(t);const i=document.createElement("span");i.style.cssText="\n      font-size: 12px;\n      color: #666;\n      background: rgba(255,255,255,0.8);\n      padding: 2px 6px;\n      border-radius: 3px;\n    ",i.textContent="Powered by GroggyVizCore",e.appendChild(i),this.el.appendChild(e),this.container=document.createElement("div"),this.container.style.cssText=`\n      width: 100%;\n      height: ${this.model.get("height")||600}px;\n      border: 1px solid #ddd;\n      background: ${this.model.get("background_color")||"#ffffff"};\n      position: relative;\n      overflow: hidden;\n      border-radius: 4px;\n    `,this.el.appendChild(this.container),this.initializeVizCore(),this.setupModelListeners(),this.updateData()}initializeVizCore(){const e={width:this.model.get("width")||800,height:this.model.get("height")||600,physics:{enabled:!1!==this.model.get("physics_enabled"),forceStrength:this.model.get("force_strength")||30,linkDistance:this.model.get("link_distance")||50,linkStrength:this.model.get("link_strength")||.1,chargeStrength:this.model.get("charge_strength")||-300,centerStrength:this.model.get("center_strength")||.1},rendering:{backgroundColor:this.model.get("background_color")||"#ffffff",nodeColorScheme:this.model.get("node_color_scheme")||"default",enableShadows:!1!==this.model.get("enable_shadows"),enableAnimations:!1!==this.model.get("enable_animations")},interaction:{enableDrag:!1!==this.model.get("enable_drag"),enableZoom:!1!==this.model.get("enable_zoom"),enablePan:!1!==this.model.get("enable_pan"),enableSelection:!1!==this.model.get("enable_selection"),enableHover:!1!==this.model.get("enable_hover")}};this.vizCore=new a([],[],e),this.setupCoreEventHandlers(),this.container&&this.vizCore.attachToDOM(this.container),console.log("🧠 GroggyVizCore initialized for Jupyter widget")}setupCoreEventHandlers(){this.vizCore&&(this.vizCore.on("nodeClick",e=>{var t,i,s;this.model.send({type:"node_click",node_id:e.nodeId,event:{ctrlKey:(null===(t=e.event)||void 0===t?void 0:t.ctrlKey)||!1,metaKey:(null===(i=e.event)||void 0===i?void 0:i.metaKey)||!1,shiftKey:(null===(s=e.event)||void 0===s?void 0:s.shiftKey)||!1}})}),this.vizCore.on("nodeHover",e=>{this.model.set("hovered_node",e.nodeId||""),this.model.save_changes()}),this.vizCore.on("selectionChanged",e=>{this.model.set("selected_nodes",e.selectedNodes||[]),this.model.save_changes()}),this.vizCore.on("simulationStarted",()=>{this.updateStatus("Physics simulation running...")}),this.vizCore.on("simulationStopped",()=>{this.updateStatus("Physics simulation stopped")}),this.vizCore.on("zoom",e=>{const t=this.model.get("camera_position");t.scale=e.scale,this.model.set("camera_position",t),this.model.save_changes()}),this.vizCore.on("pan",e=>{const t=this.model.get("camera_position");t.translate.x+=e.delta.x,t.translate.y+=e.delta.y,this.model.set("camera_position",t),this.model.save_changes()}),this.vizCore.on("nodeDrag",e=>{e.isDragging&&(this.model.set("is_dragging",!0),this.model.save_changes())}),this.vizCore.on("nodeDragEnd",()=>{this.model.set("is_dragging",!1),this.model.save_changes()}),this.vizCore.on("update",e=>{e.metadata.frameCount%60==0&&this.updateStatus(`FPS: ${Math.round(e.metadata.fps)} | Nodes: ${e.nodes.length}`)}))}setupModelListeners(){this.model.on("change:nodes change:edges",()=>{this.updateData()}),this.model.on("change:width change:height",()=>{this.updateDimensions()}),this.model.on("change:physics_enabled change:force_strength change:link_distance change:link_strength change:charge_strength change:center_strength",()=>{this.updatePhysicsConfig()}),this.model.on("change:background_color change:node_color_scheme change:enable_shadows change:enable_animations",()=>{this.updateRenderingConfig()}),this.model.on("change:enable_drag change:enable_zoom change:enable_pan change:enable_selection change:enable_hover",()=>{this.updateInteractionConfig()}),this.model.on("change:selected_nodes",()=>{if(this.vizCore){const e=this.model.get("selected_nodes")||[];this.vizCore.selectedNodes.clear(),e.forEach(e=>{this.vizCore.selectedNodes.add(e)}),this.vizCore.update()}}),this.model.on("change:title",()=>{const e=this.el.querySelector("span");e&&(e.textContent=this.model.get("title")||"Graph Visualization")})}updateData(){if(!this.vizCore)return;const e=this.model.get("nodes")||[],t=this.model.get("edges")||[];this.vizCore.setData(e,t),console.log(`🧠 Updated data: ${e.length} nodes, ${t.length} edges`)}updateDimensions(){if(!this.vizCore||!this.container)return;const e=this.model.get("width")||800,t=this.model.get("height")||600;this.container.style.height=`${t}px`,this.vizCore.updateConfig({width:e,height:t}),console.log(`🧠 Updated dimensions: ${e}x${t}`)}updatePhysicsConfig(){if(!this.vizCore)return;const e={enabled:!1!==this.model.get("physics_enabled"),forceStrength:this.model.get("force_strength")||30,linkDistance:this.model.get("link_distance")||50,linkStrength:this.model.get("link_strength")||.1,chargeStrength:this.model.get("charge_strength")||-300,centerStrength:this.model.get("center_strength")||.1};this.vizCore.updateConfig({physics:e}),console.log("🧠 Updated physics configuration")}updateRenderingConfig(){if(!this.vizCore||!this.container)return;const e={backgroundColor:this.model.get("background_color")||"#ffffff",nodeColorScheme:this.model.get("node_color_scheme")||"default",enableShadows:!1!==this.model.get("enable_shadows"),enableAnimations:!1!==this.model.get("enable_animations")};this.vizCore.updateConfig({rendering:e}),this.container.style.background=e.backgroundColor,console.log("🧠 Updated rendering configuration")}updateInteractionConfig(){if(!this.vizCore)return;const e={enableDrag:!1!==this.model.get("enable_drag"),enableZoom:!1!==this.model.get("enable_zoom"),enablePan:!1!==this.model.get("enable_pan"),enableSelection:!1!==this.model.get("enable_selection"),enableHover:!1!==this.model.get("enable_hover")};this.vizCore.updateConfig({interaction:e}),console.log("🧠 Updated interaction configuration")}updateStatus(e){const t=this.el.querySelector("span:last-child");t&&(t.textContent=e)}handleCustomMessage(e){const{type:t}=e;switch(t){case"set_layout":this.updatePhysicsConfig();break;case"focus_node":if(this.vizCore&&e.node_id){const t=this.vizCore.nodePositions.get(e.node_id);if(t){const i=e.zoom||2,s=this.vizCore.config.width/2,n=this.vizCore.config.height/2,o=s-t.x*i,r=n-t.y*i;this.vizCore.updateConfig({camera:{scale:i,translate:{x:o,y:r}}})}}break;case"reset_camera":this.vizCore&&this.vizCore.updateConfig({camera:{scale:1,translate:{x:0,y:0}}});break;case"export_state":if(this.vizCore){const e=this.vizCore.exportState();this.model.send({type:"state_exported",state:e})}break;default:console.warn(`🧠 Unknown message type: ${t}`)}}remove(){this.vizCore&&(this.vizCore.destroy(),this.vizCore=null),super.remove(),console.log("🧠 Unified Jupyter widget destroyed")}}function c(){i(55).registerWidget({model_name:"GroggyGraphModel",model_module:"groggy-widget",model_module_version:"0.1.0",view_name:"GroggyGraphView",view_module:"groggy-widget",view_module_version:"0.1.0",model:l,view:g}),console.log("✨ Elegant Groggy widget extension loaded for Jupyter Notebook")}var u,p;g.view_name="GroggyGraphView",g.view_module=h,g.view_module_version=d,e=i.hmd(e),u="undefined"!=typeof self?self:void 0,p=function(e){return{load_ipython_extension:c,GroggyGraphModel:l,GroggyGraphView:g}},"function"==typeof define&&i.amdO?define(["@jupyter-widgets/base"],p):e.exports?e.exports=p(i(55)):u.groggyWidget=p(u.widgets)}},i={};function s(e){var n=i[e];if(void 0!==n)return n.exports;var o=i[e]={id:e,loaded:!1,exports:{}};return t[e](o,o.exports,s),o.loaded=!0,o.exports}return s.amdO={},s.d=(e,t)=>{for(var i in t)s.o(t,i)&&!s.o(e,i)&&Object.defineProperty(e,i,{enumerable:!0,get:t[i]})},s.hmd=e=>((e=Object.create(e)).children||(e.children=[]),Object.defineProperty(e,"exports",{enumerable:!0,set:()=>{throw new Error("ES Modules may not assign module.exports or exports.*, Use ESM export syntax, instead: "+e.id)}}),e),s.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),s.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},s(384)})());
//# sourceMappingURL=index.js.map