define("groggy-widget",["@jupyter-widgets/base"],e=>(()=>{var t={55:t=>{"use strict";t.exports=e},548:e=>{e.exports&&(e.exports=class{constructor(e,t={}){this.container=e,this.config={width:800,height:600,layout:"force-directed",theme:"light",enableDrag:!0,enablePan:!0,enableZoom:!0,animationDuration:300,...t},this.nodes=[],this.edges=[],this.positions=[],this.selectedNodes=[],this.hoveredNode=null,this.camera={x:0,y:0,zoom:1},this.isDragging=!1,this.dragNode=null,this.isPanning=!1,this.lastMouse={x:0,y:0},this.callbacks={nodeClick:[],nodeHover:[],nodeDoubleClick:[],layoutChange:[],cameraChange:[],selectionChange:[]},this.init()}init(){this.canvas=document.createElement("canvas"),this.canvas.width=this.config.width,this.canvas.height=this.config.height,this.canvas.style.border="1px solid #ddd",this.canvas.style.cursor="default",this.canvas.style.display="block",this.ctx=this.canvas.getContext("2d"),this.container.appendChild(this.canvas),this.createControls(),this.setupEventListeners(),console.log("GroggyGraphView initialized")}createControls(){const e=document.createElement("div");e.style.cssText="\n            margin: 10px 0;\n            text-align: center;\n        ";const t=document.createElement("button");t.textContent="Toggle Layout",t.style.cssText="\n            background: #007bff;\n            color: white;\n            border: none;\n            padding: 8px 16px;\n            margin: 4px;\n            border-radius: 4px;\n            cursor: pointer;\n        ",t.onclick=()=>this.toggleLayout();const i=document.createElement("button");i.textContent="Reset View",i.style.cssText=t.style.cssText.replace("#007bff","#28a745"),i.onclick=()=>this.resetCamera();const s=document.createElement("button");s.textContent="Toggle Theme",s.style.cssText=t.style.cssText.replace("#007bff","#6c757d"),s.onclick=()=>this.toggleTheme(),e.appendChild(t),e.appendChild(i),e.appendChild(s),this.container.insertBefore(e,this.canvas),this.infoPanel=document.createElement("div"),this.infoPanel.style.cssText="\n            position: absolute;\n            top: 10px;\n            right: 10px;\n            background: rgba(0,0,0,0.8);\n            color: white;\n            padding: 8px;\n            border-radius: 4px;\n            font-size: 12px;\n            display: none;\n        ",this.container.style.position="relative",this.container.appendChild(this.infoPanel)}setupEventListeners(){this.canvas.addEventListener("mousedown",this.onMouseDown.bind(this)),this.canvas.addEventListener("mousemove",this.onMouseMove.bind(this)),this.canvas.addEventListener("mouseup",this.onMouseUp.bind(this)),this.canvas.addEventListener("click",this.onClick.bind(this)),this.canvas.addEventListener("dblclick",this.onDoubleClick.bind(this)),this.canvas.addEventListener("wheel",this.onWheel.bind(this)),this.canvas.addEventListener("mouseleave",this.onMouseLeave.bind(this))}setData(e,t){this.nodes=e||[],this.edges=t||[],this.calculateLayout(),this.render(),console.log(`Data updated: ${this.nodes.length} nodes, ${this.edges.length} edges`)}setLayout(e,t=!0){const i=this.config.layout;this.config.layout=e,t?this.animateLayoutChange():(this.calculateLayout(),this.render()),this.trigger("layoutChange",{from:i,to:e}),console.log(`Layout changed to: ${e}`)}setTheme(e){this.config.theme=e,this.render(),console.log(`Theme changed to: ${e}`)}selectNodes(e,t=!0){this.selectedNodes=t?[...e]:[...new Set([...this.selectedNodes,...e])],this.render(),this.trigger("selectionChange",this.selectedNodes)}focusOnNode(e,t=2){const i=this.nodes.find(t=>t.id===e),s=this.positions.find(t=>t.id===e);i&&s&&(this.camera.x=this.config.width/2-s.x*this.camera.zoom,this.camera.y=this.config.height/2-s.y*this.camera.zoom,this.camera.zoom=t,this.render(),this.trigger("cameraChange",this.camera))}resetCamera(){this.camera={x:0,y:0,zoom:1},this.calculateLayout(),this.render(),this.trigger("cameraChange",this.camera)}onMouseDown(e){const t=this.canvas.getBoundingClientRect(),i=(e.clientX-t.left-this.camera.x)/this.camera.zoom,s=(e.clientY-t.top-this.camera.y)/this.camera.zoom,o=this.findNodeAt(i,s);o&&this.config.enableDrag?(this.isDragging=!0,this.dragNode=o,this.canvas.style.cursor="grabbing"):this.config.enablePan&&(this.isPanning=!0,this.lastMouse={x:e.clientX,y:e.clientY},this.canvas.style.cursor="grabbing")}onMouseMove(e){const t=this.canvas.getBoundingClientRect(),i=(e.clientX-t.left-this.camera.x)/this.camera.zoom,s=(e.clientY-t.top-this.camera.y)/this.camera.zoom;if(this.isDragging&&this.dragNode){const e=this.positions.find(e=>e.id===this.dragNode.id);e&&(e.x=i,e.y=s,this.render())}else if(this.isPanning)this.camera.x+=e.clientX-this.lastMouse.x,this.camera.y+=e.clientY-this.lastMouse.y,this.lastMouse={x:e.clientX,y:e.clientY},this.render();else{const e=this.findNodeAt(i,s);e!==this.hoveredNode&&(this.hoveredNode=e,this.canvas.style.cursor=e?"pointer":"default",e?(this.infoPanel.textContent=`${e.label||e.id} (${e.id})`,this.infoPanel.style.display="block"):this.infoPanel.style.display="none",this.render(),this.trigger("nodeHover",e?e.id:null))}}onMouseUp(){this.isDragging=!1,this.isPanning=!1,this.dragNode=null,this.canvas.style.cursor="default"}onClick(e){if(!this.isDragging){const t=this.canvas.getBoundingClientRect(),i=(e.clientX-t.left-this.camera.x)/this.camera.zoom,s=(e.clientY-t.top-this.camera.y)/this.camera.zoom,o=this.findNodeAt(i,s);o?(e.ctrlKey||e.metaKey?this.selectedNodes.includes(o.id)?this.selectedNodes=this.selectedNodes.filter(e=>e!==o.id):this.selectedNodes.push(o.id):this.selectedNodes=[o.id],this.render(),this.trigger("nodeClick",{nodeId:o.id,nodeData:o}),this.trigger("selectionChange",this.selectedNodes)):e.ctrlKey||e.metaKey||(this.selectedNodes=[],this.render(),this.trigger("selectionChange",this.selectedNodes))}}onDoubleClick(e){const t=this.canvas.getBoundingClientRect(),i=(e.clientX-t.left-this.camera.x)/this.camera.zoom,s=(e.clientY-t.top-this.camera.y)/this.camera.zoom,o=this.findNodeAt(i,s);o&&(this.trigger("nodeDoubleClick",{nodeId:o.id,nodeData:o}),this.focusOnNode(o.id,2))}onWheel(e){if(this.config.enableZoom){e.preventDefault();const t=this.canvas.getBoundingClientRect(),i=e.clientX-t.left,s=e.clientY-t.top,o=e.deltaY>0?.9:1.1,n=Math.max(.1,Math.min(5,this.camera.zoom*o));this.camera.x=i-(i-this.camera.x)*(n/this.camera.zoom),this.camera.y=s-(s-this.camera.y)*(n/this.camera.zoom),this.camera.zoom=n,this.render(),this.trigger("cameraChange",this.camera)}}onMouseLeave(){this.hoveredNode=null,this.infoPanel.style.display="none",this.render()}findNodeAt(e,t){return this.nodes.find(i=>{const s=this.positions.find(e=>e.id===i.id);if(s){const o=i.size||8,n=e-s.x,a=t-s.y;return n*n+a*a<=o*o}return!1})}toggleLayout(){const e=["circular","grid","force-directed"],t=e.indexOf(this.config.layout),i=e[(t+1)%e.length];this.setLayout(i,!0)}toggleTheme(){const e=["light","dark"],t=e.indexOf(this.config.theme),i=e[(t+1)%e.length];this.setTheme(i)}calculateLayout(){const{width:e,height:t,layout:i}=this.config,s=50;if(this.positions=[],"circular"===i&&this.nodes.length>0){const i=e/2,o=t/2,n=Math.min(e,t)/2-s;this.nodes.forEach((e,t)=>{const s=2*t*Math.PI/this.nodes.length;this.positions.push({id:e.id,x:i+n*Math.cos(s),y:o+n*Math.sin(s)})})}else if("force-directed"===i){this.positions=this.nodes.map(i=>({id:i.id,x:s+Math.random()*(e-100),y:s+Math.random()*(t-100)}));for(let i=0;i<50;i++){for(let e=0;e<this.positions.length;e++)for(let t=e+1;t<this.positions.length;t++){const i=this.positions[t].x-this.positions[e].x,s=this.positions[t].y-this.positions[e].y,o=Math.sqrt(i*i+s*s)||1,n=500/(o*o);this.positions[e].x-=n*i/o,this.positions[e].y-=n*s/o,this.positions[t].x+=n*i/o,this.positions[t].y+=n*s/o}this.edges.forEach(e=>{const t=this.positions.find(t=>t.id===e.source),i=this.positions.find(t=>t.id===e.target);if(t&&i){const e=i.x-t.x,s=i.y-t.y,o=Math.sqrt(e*e+s*s)||1,n=.01*o;t.x+=n*e/o,t.y+=n*s/o,i.x-=n*e/o,i.y-=n*s/o}}),this.positions.forEach(i=>{i.x=Math.max(s,Math.min(e-s,i.x)),i.y=Math.max(s,Math.min(t-s,i.y))})}}else{const i=Math.ceil(Math.sqrt(this.nodes.length)),o=(e-100)/i,n=(t-100)/Math.ceil(this.nodes.length/i);this.nodes.forEach((e,t)=>{this.positions.push({id:e.id,x:s+t%i*o+o/2,y:s+Math.floor(t/i)*n+n/2})})}}animateLayoutChange(){const e=[...this.positions];this.calculateLayout();const t=[...this.positions],i=Date.now(),s=this.config.animationDuration,o=()=>{const n=Math.min(1,(Date.now()-i)/s);this.positions=e.map((e,i)=>{const s=t[i];return{id:e.id,x:e.x+(s.x-e.x)*n,y:e.y+(s.y-e.y)*n}}),this.render(),n<1&&requestAnimationFrame(o)};o()}render(){this.ctx.clearRect(0,0,this.canvas.width,this.canvas.height),this.ctx.save(),this.ctx.translate(this.camera.x,this.camera.y),this.ctx.scale(this.camera.zoom,this.camera.zoom),this.drawEdges(),this.drawNodes(),this.ctx.restore(),this.drawStats()}drawEdges(){const{theme:e}=this.config;this.edges.forEach(t=>{const i=this.positions.find(e=>e.id===t.source),s=this.positions.find(e=>e.id===t.target);i&&s&&(this.ctx.strokeStyle="dark"===e?"#666":"#999",this.ctx.lineWidth=1,this.ctx.beginPath(),this.ctx.moveTo(i.x,i.y),this.ctx.lineTo(s.x,s.y),this.ctx.stroke())})}drawNodes(){const{theme:e}=this.config;this.nodes.forEach(t=>{const i=this.positions.find(e=>e.id===t.id);if(i){const s=this.selectedNodes.includes(t.id),o=this.hoveredNode&&this.hoveredNode.id===t.id,n=(t.size||8)*(o?1.3:1);o&&(this.ctx.shadowColor="rgba(0,0,0,0.3)",this.ctx.shadowBlur=10,this.ctx.shadowOffsetX=2,this.ctx.shadowOffsetY=2),this.ctx.fillStyle=t.color||("dark"===e?"#4CAF50":"#007bff"),this.ctx.beginPath(),this.ctx.arc(i.x,i.y,n,0,2*Math.PI),this.ctx.fill(),this.ctx.shadowColor="transparent",this.ctx.shadowBlur=0,(s||o)&&(this.ctx.strokeStyle=s?"#ff0000":"#ffa500",this.ctx.lineWidth=3,this.ctx.stroke()),this.ctx.fillStyle="dark"===e?"#fff":"#000",this.ctx.font="12px Arial",this.ctx.textAlign="center",this.ctx.fillText(t.label||t.id,i.x,i.y-n-5)}})}drawStats(){const e=`${this.nodes.length} nodes | ${this.edges.length} edges | ${this.config.layout} | zoom: ${this.camera.zoom.toFixed(1)}x`;this.ctx.fillStyle="dark"===this.config.theme?"#fff":"#666",this.ctx.font="12px Arial",this.ctx.textAlign="left",this.ctx.fillText(e,10,this.canvas.height-10)}on(e,t){this.callbacks[e]||(this.callbacks[e]=[]),this.callbacks[e].push(t)}trigger(e,t){this.callbacks[e]&&this.callbacks[e].forEach(i=>{try{i(t)}catch(t){console.error(`Error in ${e} callback:`,t)}})}})}},i={};function s(e){var o=i[e];if(void 0!==o)return o.exports;var n=i[e]={exports:{}};return t[e](n,n.exports,s),n.exports}s.d=(e,t)=>{for(var i in t)s.o(t,i)&&!s.o(e,i)&&Object.defineProperty(e,i,{enumerable:!0,get:t[i]})},s.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),s.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var o={};return(()=>{"use strict";s.r(o),s.d(o,{GroggyGraphModel:()=>h,GroggyGraphView:()=>d,MODULE_NAME:()=>n,MODULE_VERSION:()=>a,version:()=>r});var e=s(55);const t=s(548).GroggyGraphView;class i{constructor(e,i){this.syncCallbacks=new Map,this.element=e,this.model=i,this.coreView=new t(e,this.extractCoreConfig()),this.setupElegantSync()}extractCoreConfig(){return{width:this.model.get("width")||800,height:this.model.get("height")||600,layout:this.model.get("layout_algorithm")||"force-directed",theme:this.model.get("theme")||"light",enableDrag:!1!==this.model.get("enable_drag"),enablePan:!1!==this.model.get("enable_pan"),enableZoom:!1!==this.model.get("enable_zoom"),animationDuration:this.model.get("animation_duration")||300}}setupElegantSync(){this.syncFromCore(),this.syncFromJupyter()}syncFromCore(){this.coreView.on("nodeClick",e=>{this.model.send({type:"node_click",node_id:e.nodeId,node_data:e.nodeData,position:e.position})}),this.coreView.on("nodeDoubleClick",e=>{this.model.send({type:"node_double_click",node_id:e.nodeId,node_data:e.nodeData})}),this.coreView.on("nodeHover",e=>{this.model.set("hovered_node",e||""),this.model.save_changes()}),this.coreView.on("selectionChange",e=>{this.model.set("selected_nodes",e),this.model.save_changes()}),this.coreView.on("layoutChange",e=>{this.model.set("layout_algorithm",e.to),this.model.save_changes()});let e=null;this.coreView.on("cameraChange",t=>{e&&clearTimeout(e),e=setTimeout(()=>{this.model.set("camera_position",t),this.model.save_changes()},100)}),this.coreView.on("dragStart",()=>{this.model.set("is_dragging",!0),this.model.save_changes()}),this.coreView.on("dragEnd",()=>{this.model.set("is_dragging",!1),this.model.save_changes()})}syncFromJupyter(){this.model.on("change:nodes change:edges",()=>{const e=this.model.get("nodes")||[],t=this.model.get("edges")||[];this.coreView.setData(e,t)}),this.model.on("change:layout_algorithm",()=>{const e=this.model.get("layout_algorithm");this.coreView.setLayout(e,!0)}),this.model.on("change:theme",()=>{const e=this.model.get("theme");this.coreView.setTheme(e)}),this.model.on("change:selected_nodes",()=>{const e=this.model.get("selected_nodes")||[];this.coreView.selectNodes(e,!0)}),this.model.on("change:node_positions",()=>{const e=this.model.get("node_positions")||{};this.updateCorePositions(e)}),this.model.on("change:width change:height",()=>{this.updateCoreSize()})}handleCustomMessage(e){const{type:t}=e;switch(t){case"set_layout":this.coreView.setLayout(e.algorithm,!1!==e.animate);break;case"focus_node":this.coreView.focusOnNode(e.node_id,e.zoom||2);break;case"reset_camera":this.coreView.resetCamera();break;case"update_positions":this.updateCorePositions(e.positions);break;default:console.warn(`Unknown command type: ${t}`)}}updateCorePositions(e){Object.entries(e).forEach(([e,t])=>{var i,s;(null===(s=(i=this.coreView).findNodeElement)||void 0===s?void 0:s.call(i,e))&&t&&this.animateNodePosition(e,t)})}animateNodePosition(e,t){this.coreView.animateNodeTo&&this.coreView.animateNodeTo(e,t.x,t.y)}updateCoreSize(){const e=this.model.get("width"),t=this.model.get("height");this.coreView.resize&&this.coreView.resize(e,t)}initialize(){const e=this.model.get("nodes")||[],t=this.model.get("edges")||[],i=this.model.get("node_positions")||{};this.coreView.setData(e,t),Object.keys(i).length>0&&this.updateCorePositions(i),console.log("🎨 Elegant Jupyter-Groggy bridge initialized")}destroy(){this.coreView.destroy&&this.coreView.destroy()}}const n="groggy-widget",a="0.1.0";class h extends e.DOMWidgetModel{defaults(){return Object.assign(Object.assign({},super.defaults()),{_model_name:h.model_name,_model_module:h.model_module,_model_module_version:h.model_module_version,_view_name:h.view_name,_view_module:h.view_module,_view_module_version:h.view_module_version,nodes:[],edges:[],node_positions:{},layout_algorithm:"force-directed",theme:"light",width:800,height:600,title:"Graph Visualization",selected_nodes:[],hovered_node:"",camera_position:{x:0,y:0,zoom:1},is_dragging:!1,enable_drag:!0,enable_pan:!0,enable_zoom:!0,enable_animations:!0,animation_duration:300,style_config:{}})}}h.serializers=Object.assign({},e.DOMWidgetModel.serializers),h.model_name="GroggyGraphModel",h.model_module=n,h.model_module_version=a,h.view_name="GroggyGraphView",h.view_module=n,h.view_module_version=a;class d extends e.DOMWidgetView{constructor(){super(...arguments),this.groggyView=null}render(){this.el.classList.add("groggy-widget-container"),this.el.style.cssText="\n            border: 1px solid #ddd;\n            border-radius: 4px;\n            background: #fafafa;\n            position: relative;\n            overflow: hidden;\n        ",this.groggyView=new i(this.el,this.model),this.model.on("msg:custom",this.handleCustomMessage,this),this.groggyView.initialize(),console.log("✨ Elegant Groggy widget rendered")}handleCustomMessage(e){this.groggyView&&this.groggyView.handleCustomMessage(e)}remove(){this.groggyView&&(this.groggyView.destroy(),this.groggyView=null),super.remove()}onResize(){if(this.groggyView){const e=this.el.clientWidth,t=this.el.clientHeight;e>0&&t>0&&(this.model.set("width",e),this.model.set("height",t),this.model.save_changes())}}}const r="0.1.0"})(),o})());
//# sourceMappingURL=index.js.map