# Copyright 2025 The EasyDeL/eFormer Author @erfanzar (Erfan Zare Chavoshi).
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from . import _serialization as serialization
from ._pytree import FrozenPyTree, PyTree, auto_pytree
from ._serialization import (
    compress_bytes,
    current_path,
    decompress_bytes,
    from_bytes,
    from_compressed_bytes,
    from_state_dict,
    get_serialization_info,
    is_serializable,
    load_from_file,
    msgpack_restore,
    msgpack_serialize,
    register_serialization_state,
    save_to_file,
    to_bytes,
    to_compressed_bytes,
    to_state_dict,
    validate_serializable,
)
from ._tree_util import (
    deepcopy_tree,
    flatten_dict,
    flatten_mapping,
    flatten_to_sequence,
    flatten_tree,
    int_key_to_string,
    is_array,
    is_array_like,
    is_flatten,
    is_iterable,
    key_path_to_str,
    merge,
    named_tree_map,
    pack_pytree,
    recursive_merge,
    specs_to_name_sharding,
    split,
    string_key_to_int,
    tree_abs,
    tree_add,
    tree_all,
    tree_any,
    tree_apply,
    tree_bytes,
    tree_cast,
    tree_clip,
    tree_concatenate,
    tree_divide,
    tree_dot,
    tree_equal,
    tree_exp,
    tree_expand_dims,
    tree_filter,
    tree_flatten_one_level_with_keys,
    tree_flatten_with_paths,
    tree_isfinite,
    tree_isinf,
    tree_isnan,
    tree_leaves_with_paths,
    tree_log,
    tree_map_with_path,
    tree_max,
    tree_mean,
    tree_min,
    tree_multiply,
    tree_norm,
    tree_ones_like,
    tree_path_to_string,
    tree_random_like,
    tree_reciprocal,
    tree_reduce,
    tree_replace_infs,
    tree_replace_nans,
    tree_reshape,
    tree_round,
    tree_sign,
    tree_size,
    tree_sqrt,
    tree_squeeze,
    tree_stack,
    tree_structure_equal,
    tree_subtract,
    tree_sum,
    tree_transpose,
    tree_where,
    tree_zeros_like,
    unflatten_dict,
    unflatten_mapping,
    unpack_pytree,
)
from ._xtree import dataclass, field, xTree

__all__ = (
    "FrozenPyTree",
    "PyTree",
    "auto_pytree",
    "compress_bytes",
    "current_path",
    "dataclass",
    "decompress_bytes",
    "deepcopy_tree",
    "field",
    "flatten_dict",
    "flatten_mapping",
    "flatten_to_sequence",
    "flatten_tree",
    "from_bytes",
    "from_compressed_bytes",
    "from_state_dict",
    "get_serialization_info",
    "int_key_to_string",
    "is_array",
    "is_array_like",
    "is_flatten",
    "is_iterable",
    "is_serializable",
    "key_path_to_str",
    "load_from_file",
    "merge",
    "msgpack_restore",
    "msgpack_serialize",
    "named_tree_map",
    "pack_pytree",
    "recursive_merge",
    "register_serialization_state",
    "save_to_file",
    "serialization",
    "specs_to_name_sharding",
    "split",
    "string_key_to_int",
    "to_bytes",
    "to_compressed_bytes",
    "to_state_dict",
    "tree_abs",
    "tree_add",
    "tree_all",
    "tree_any",
    "tree_apply",
    "tree_bytes",
    "tree_cast",
    "tree_clip",
    "tree_concatenate",
    "tree_divide",
    "tree_dot",
    "tree_equal",
    "tree_exp",
    "tree_expand_dims",
    "tree_filter",
    "tree_flatten_one_level_with_keys",
    "tree_flatten_with_paths",
    "tree_isfinite",
    "tree_isinf",
    "tree_isnan",
    "tree_leaves_with_paths",
    "tree_log",
    "tree_map_with_path",
    "tree_max",
    "tree_mean",
    "tree_min",
    "tree_multiply",
    "tree_norm",
    "tree_ones_like",
    "tree_path_to_string",
    "tree_random_like",
    "tree_reciprocal",
    "tree_reduce",
    "tree_replace_infs",
    "tree_replace_nans",
    "tree_reshape",
    "tree_round",
    "tree_sign",
    "tree_size",
    "tree_sqrt",
    "tree_squeeze",
    "tree_stack",
    "tree_structure_equal",
    "tree_subtract",
    "tree_sum",
    "tree_transpose",
    "tree_where",
    "tree_zeros_like",
    "unflatten_dict",
    "unflatten_mapping",
    "unpack_pytree",
    "validate_serializable",
    "xTree",
)
