# References


(References)=
## References

The equations and many of the unit tests underlying this work are drawn from the following sources:

(Vallado)=
- **"Fundamentals of Astrodynamics and Applications, Fourth Edition"**, D. Vallado, Microcosm Press and Springer, 2013.<br>
  [https://celestrak.org/software/vallado-sw.php](https://celestrak.org/software/vallado-sw.php)
(Montenbruck-Gill)=
- **"Satellite Orbits: Models, Methods, Applications"**, O. Montenbruck and E. Gill, Springer, 2000.<br>
  [https://doi.org/10.1007/978-3-642-58351-3](https://doi.org/10.1007/978-3-642-58351-3)

## Models

This code makes reference to and relies on models generated by the following:

- **SGP4 Orbit Propagator** - <https://celestrak.org/software/tskelso-sw.php><br/>
  NORAD / SGP4 orbit propagator used to generate position and velocity states from orbital ephemerides described by Two-Line Element Sets (TLEs). This code base includes a pure-rust translation of the SGP4 orbit propagator
- **NRL MSISE-00 Density Model** - <https://ccmc.gsfc.nasa.gov/models/NRLMSIS~00/><br/>
  NRL model of air density, including density at high altitudes, used in to compute satellite drag
- **Gravity Models** - <http://icgem.gfz-potsdam.de/home><br/>
  International Center for Global Earth Models (ICEGM), collection and archive in a common format of all existing global gravity field models
- **Space Weather** - <https://celestrak.org/SpaceData/><br/>
  Space weather used to modulate the air density used in drag calculations
- **Earth Orientation Parameters** - <https://celestrak.org/SpaceData/><br/>
  Time-varying Earth orientation parameters used for time epoch conversions and high-precision rotations between the inertial and Earth-fixed coordinate frames
- **IERS Conventions** - <https://www.iers.org/IERS/EN/Publications/TechnicalNotes/tn36.html><br/>
  International Earth Rotation and Reference Systems Service Technical Note 36 for rotation between inertial and Earth-fixed coordinate systems.

### Verification

The code includes rust test modules and python test modules for verification of nearly calculations, including but not limited to:

- **JPL Ephemeris** - Via JPL-provided test vectors for Chebychev polynomial calculation
- **SGP4** - Via SGP4 test vectors provided with original C<sup>++</sup> distribution