# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr, validator 
from lusid.models.model_property import ModelProperty

class AccountHolderIdentifier(BaseModel):
    """
    AccountHolderIdentifier
    """
    key:  StrictStr = Field(...,alias="key", description="A client-defined key used to identify the Account Holder, unique within the Investment Account") 
    identifiers: Dict[str, ModelProperty] = Field(..., description="Single Account Holder identifier that should target the desired Investor Record.")
    __properties = ["key", "identifiers"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountHolderIdentifier:
        """Create an instance of AccountHolderIdentifier from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in identifiers (dict)
        _field_dict = {}
        if self.identifiers:
            for _key in self.identifiers:
                if self.identifiers[_key]:
                    _field_dict[_key] = self.identifiers[_key].to_dict()
            _dict['identifiers'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccountHolderIdentifier:
        """Create an instance of AccountHolderIdentifier from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AccountHolderIdentifier.parse_obj(obj)

        _obj = AccountHolderIdentifier.parse_obj({
            "key": obj.get("key"),
            "identifiers": dict(
                (_k, ModelProperty.from_dict(_v))
                for _k, _v in obj.get("identifiers").items()
            )
            if obj.get("identifiers") is not None
            else None
        })
        return _obj
