# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictInt, conlist, constr 
from lusid.models.resource_id import ResourceId

class DataModelSummary(BaseModel):
    """
    DataModelSummary
    """
    id: ResourceId = Field(...)
    display_name:  StrictStr = Field(...,alias="displayName", description="The name of the Custom Data Model.") 
    description:  StrictStr = Field(...,alias="description", description="A description for the Custom Data Model.") 
    entity_type:  StrictStr = Field(...,alias="entityType", description="The entity type that the Custom Data Model binds to.") 
    type:  StrictStr = Field(...,alias="type", description="Either Root or Leaf or Intermediate.") 
    precedence: StrictInt = Field(..., description="Where in the hierarchy this model sits.")
    children: conlist(DataModelSummary) = Field(..., description="Child Custom Data Models that will inherit from this data model.")
    __properties = ["id", "displayName", "description", "entityType", "type", "precedence", "children"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DataModelSummary:
        """Create an instance of DataModelSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in children (list)
        _items = []
        if self.children:
            for _item in self.children:
                if _item:
                    _items.append(_item.to_dict())
            _dict['children'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DataModelSummary:
        """Create an instance of DataModelSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DataModelSummary.parse_obj(obj)

        _obj = DataModelSummary.parse_obj({
            "id": ResourceId.from_dict(obj.get("id")) if obj.get("id") is not None else None,
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "entity_type": obj.get("entityType"),
            "type": obj.get("type"),
            "precedence": obj.get("precedence"),
            "children": [DataModelSummary.from_dict(_item) for _item in obj.get("children")] if obj.get("children") is not None else None
        })
        return _obj
