# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional, Union
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictFloat, StrictInt 
from lusid.models.fee_accrual import FeeAccrual
from lusid.models.previous_share_class_breakdown import PreviousShareClassBreakdown
from lusid.models.share_class_amount import ShareClassAmount
from lusid.models.share_class_dealing_breakdown import ShareClassDealingBreakdown
from lusid.models.share_class_pnl_breakdown import ShareClassPnlBreakdown
from lusid.models.unitisation_data import UnitisationData

class ShareClassBreakdown(BaseModel):
    """
    The Valuation Point Data for a Share Class on a specified date.  # noqa: E501
    """
    back_out: Dict[str, ShareClassAmount] = Field(..., alias="backOut", description="Bucket of detail for the Valuation Point where data points have been 'backed out'.")
    dealing: ShareClassDealingBreakdown = Field(...)
    pn_l: ShareClassPnlBreakdown = Field(..., alias="pnL")
    gav: ShareClassAmount = Field(...)
    fees: Dict[str, FeeAccrual] = Field(..., description="Bucket of detail for any 'Fees' that have been charged in the selected period.")
    nav: ShareClassAmount = Field(...)
    unitisation: Optional[UnitisationData] = None
    miscellaneous: Optional[Dict[str, ShareClassAmount]] = Field(None, description="Not used directly by the LUSID engines but serves as a holding area for any custom derived data points that may be useful in, for example, fee calculations).")
    share_class_to_fund_fx_rate: Union[StrictFloat, StrictInt] = Field(..., alias="shareClassToFundFxRate", description="The fx rate from the Share Class currency to the fund currency at this valuation point.")
    capital_ratio: Union[StrictFloat, StrictInt] = Field(..., alias="capitalRatio", description="The proportion of the fund's adjusted beginning equity (ie: the sum of the previous NAV and the net dealing) that is invested in the share class.")
    previous_share_class_breakdown: PreviousShareClassBreakdown = Field(..., alias="previousShareClassBreakdown")
    __properties = ["backOut", "dealing", "pnL", "gav", "fees", "nav", "unitisation", "miscellaneous", "shareClassToFundFxRate", "capitalRatio", "previousShareClassBreakdown"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ShareClassBreakdown:
        """Create an instance of ShareClassBreakdown from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in back_out (dict)
        _field_dict = {}
        if self.back_out:
            for _key in self.back_out:
                if self.back_out[_key]:
                    _field_dict[_key] = self.back_out[_key].to_dict()
            _dict['backOut'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of dealing
        if self.dealing:
            _dict['dealing'] = self.dealing.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pn_l
        if self.pn_l:
            _dict['pnL'] = self.pn_l.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gav
        if self.gav:
            _dict['gav'] = self.gav.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in fees (dict)
        _field_dict = {}
        if self.fees:
            for _key in self.fees:
                if self.fees[_key]:
                    _field_dict[_key] = self.fees[_key].to_dict()
            _dict['fees'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of nav
        if self.nav:
            _dict['nav'] = self.nav.to_dict()
        # override the default output from pydantic by calling `to_dict()` of unitisation
        if self.unitisation:
            _dict['unitisation'] = self.unitisation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in miscellaneous (dict)
        _field_dict = {}
        if self.miscellaneous:
            for _key in self.miscellaneous:
                if self.miscellaneous[_key]:
                    _field_dict[_key] = self.miscellaneous[_key].to_dict()
            _dict['miscellaneous'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of previous_share_class_breakdown
        if self.previous_share_class_breakdown:
            _dict['previousShareClassBreakdown'] = self.previous_share_class_breakdown.to_dict()
        # set to None if miscellaneous (nullable) is None
        # and __fields_set__ contains the field
        if self.miscellaneous is None and "miscellaneous" in self.__fields_set__:
            _dict['miscellaneous'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ShareClassBreakdown:
        """Create an instance of ShareClassBreakdown from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ShareClassBreakdown.parse_obj(obj)

        _obj = ShareClassBreakdown.parse_obj({
            "back_out": dict(
                (_k, ShareClassAmount.from_dict(_v))
                for _k, _v in obj.get("backOut").items()
            )
            if obj.get("backOut") is not None
            else None,
            "dealing": ShareClassDealingBreakdown.from_dict(obj.get("dealing")) if obj.get("dealing") is not None else None,
            "pn_l": ShareClassPnlBreakdown.from_dict(obj.get("pnL")) if obj.get("pnL") is not None else None,
            "gav": ShareClassAmount.from_dict(obj.get("gav")) if obj.get("gav") is not None else None,
            "fees": dict(
                (_k, FeeAccrual.from_dict(_v))
                for _k, _v in obj.get("fees").items()
            )
            if obj.get("fees") is not None
            else None,
            "nav": ShareClassAmount.from_dict(obj.get("nav")) if obj.get("nav") is not None else None,
            "unitisation": UnitisationData.from_dict(obj.get("unitisation")) if obj.get("unitisation") is not None else None,
            "miscellaneous": dict(
                (_k, ShareClassAmount.from_dict(_v))
                for _k, _v in obj.get("miscellaneous").items()
            )
            if obj.get("miscellaneous") is not None
            else None,
            "share_class_to_fund_fx_rate": obj.get("shareClassToFundFxRate"),
            "capital_ratio": obj.get("capitalRatio"),
            "previous_share_class_breakdown": PreviousShareClassBreakdown.from_dict(obj.get("previousShareClassBreakdown")) if obj.get("previousShareClassBreakdown") is not None else None
        })
        return _obj
