# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr, validator 
from lusid.models.investor_identifier import InvestorIdentifier
from lusid.models.model_property import ModelProperty

class UpsertInvestorRecordRequest(BaseModel):
    """
    Request to create or update an investor record  # noqa: E501
    """
    identifiers: Dict[str, ModelProperty] = Field(..., description="Unique client-defined identifiers of the Investor Record.")
    properties: Optional[Dict[str, ModelProperty]] = Field(None, description="A set of properties associated to the Investor Record.")
    display_name:  StrictStr = Field(...,alias="displayName", description="The display name of the Investor Record") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="The description of the Investor Record") 
    investor: Optional[InvestorIdentifier] = None
    __properties = ["identifiers", "properties", "displayName", "description", "investor"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpsertInvestorRecordRequest:
        """Create an instance of UpsertInvestorRecordRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in identifiers (dict)
        _field_dict = {}
        if self.identifiers:
            for _key in self.identifiers:
                if self.identifiers[_key]:
                    _field_dict[_key] = self.identifiers[_key].to_dict()
            _dict['identifiers'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in properties (dict)
        _field_dict = {}
        if self.properties:
            for _key in self.properties:
                if self.properties[_key]:
                    _field_dict[_key] = self.properties[_key].to_dict()
            _dict['properties'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of investor
        if self.investor:
            _dict['investor'] = self.investor.to_dict()
        # set to None if properties (nullable) is None
        # and __fields_set__ contains the field
        if self.properties is None and "properties" in self.__fields_set__:
            _dict['properties'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpsertInvestorRecordRequest:
        """Create an instance of UpsertInvestorRecordRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpsertInvestorRecordRequest.parse_obj(obj)

        _obj = UpsertInvestorRecordRequest.parse_obj({
            "identifiers": dict(
                (_k, ModelProperty.from_dict(_v))
                for _k, _v in obj.get("identifiers").items()
            )
            if obj.get("identifiers") is not None
            else None,
            "properties": dict(
                (_k, ModelProperty.from_dict(_v))
                for _k, _v in obj.get("properties").items()
            )
            if obj.get("properties") is not None
            else None,
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "investor": InvestorIdentifier.from_dict(obj.get("investor")) if obj.get("investor") is not None else None
        })
        return _obj
