# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_config.ipynb.

# %% auto 0
__all__ = ['REF_COLOR', 'FEMALE_COLOR', 'MALE_COLOR', 'ALL_COLOR', 'GLUC_COLOR', 'FOOD_COLOR', 'generate_synthetic_data']

# %% ../nbs/00_config.ipynb 3
import numpy as np
import pandas as pd

# %% ../nbs/00_config.ipynb 4
REF_COLOR = "k"
FEMALE_COLOR = "C1"
MALE_COLOR = "C0"
ALL_COLOR = "C5"

GLUC_COLOR = "C0"
FOOD_COLOR = "C1"

# %% ../nbs/00_config.ipynb 5
def generate_synthetic_data(n: int = 1000) -> pd.DataFrame:
    """
    Generates a sample DataFrame containing age, gender, and value data.

    Args:
        n: The number of rows in the generated DataFrame.

    Returns:
        A pandas DataFrame with columns 'age', 'gender', and 'val'.
    """
    pids = np.arange(n)
    # Set start and end dates
    start_date = pd.Timestamp('2020-01-01')
    end_date = pd.Timestamp('now')
    dates = pd.to_datetime(pd.to_datetime(np.random.uniform(start_date.value, end_date.value, n).astype(np.int64)).date)  
    ages = np.random.uniform(35, 73, size=n)
    genders = np.random.choice([0, 1], size=n)
    vals = np.random.normal(30 + 1 * ages + 40 * genders, 20, size=n)
    
    data = pd.DataFrame(data={"participant_id":pids,"date_of_research_stage": dates,"age_at_research_stage": ages, "sex": genders, "val1": vals}).set_index("participant_id")
    data["val2"] = data["val1"]*0.3 + 0.5*np.random.normal(0,50) + 0.2*10*data["sex"]
    return data
