"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Handler = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _action = require("./_action");
/**
 * Defines a specific action that should be taken.
 */
class Handler {
    constructor(tcpSocketOptions, commandOptions, httpGetOptions) {
        this.tcpSocketOptions = tcpSocketOptions;
        this.commandOptions = commandOptions;
        this.httpGetOptions = httpGetOptions;
    }
    /**
     * Defines a handler based on an HTTP GET request to the IP address of the container.
     *
     * @param path The URL path to hit
     * @param options Options
     */
    static fromHttpGet(path, options = {}) {
        return new Handler(undefined, undefined, { path, ...options });
    }
    /**
     * Defines a handler based on a command which is executed within the container.
     *
     * @param command The command to execute
     */
    static fromCommand(command) {
        return new Handler(undefined, { command }, undefined);
    }
    /**
     * Defines a handler based opening a connection to a TCP socket on the container.
     *
     * @param options Options
     */
    static fromTcpSocket(options = {}) {
        return new Handler(options, undefined, undefined);
    }
    /**
     * @internal
     */
    _toKube(cont) {
        const exec = this.commandOptions ? _action.Action.fromCommand(this.commandOptions.command) : undefined;
        const httpGet = this.httpGetOptions ? _action.Action.fromHttpGet(cont, this.httpGetOptions.path, this.httpGetOptions) : undefined;
        const tcpSocket = this.tcpSocketOptions ? _action.Action.fromTcpSocket(cont, this.tcpSocketOptions) : undefined;
        return { exec, httpGet, tcpSocket };
    }
}
exports.Handler = Handler;
_a = JSII_RTTI_SYMBOL_1;
Handler[_a] = { fqn: "cdk8s-plus-23.Handler", version: "2.0.0-rc.71" };
//# sourceMappingURL=data:application/json;base64,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