import * as cdk from '@aws-cdk/core';
/**
 * slack event notify interface.
 */
export interface ISlackEventNotify {
    /**
     * slack Webhook Url for Lambda send message to slack.
     */
    readonly slackWebhookUrl: string;
    /**
     * slack Channel Name for Lambda send message to slack.
     */
    readonly slackChannelName: string;
}
/**
 * event notify interface.
 */
export interface EventNotifyProps {
    /**
     * Line Notify Token for Lambda send notify permisson.
     *
     * @default - none
     */
    readonly lineNotifyToken?: string | undefined;
    /**
     * Notify target to Slack channel.
     *
     * @default - none
     */
    readonly slack?: ISlackEventNotify;
}
/**
 * Event Notfiy Construct Class.
 */
export declare class EventNotify extends cdk.Construct {
    constructor(scope: cdk.Construct, id: string, props?: EventNotifyProps);
}
