"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const _1 = require("./");
const app = new cdk.App();
const env = {
    region: process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
const stack = new cdk.Stack(app, 'integ-stack', { env });
new _1.EventNotify(stack, 'LineslackEventNotify', {
    lineNotifyToken: process.env.LINE_NOTIFY_TOKEN,
    slack: {
        slackChannelName: `${process.env.SLACK_CHANNEL_NAME}`,
        slackWebhookUrl: `${process.env.SLACK_WEBHOOK_URL}`,
    },
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEscUNBQXFDO0FBQ3JDLHlCQUFpQztBQUdqQyxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUUxQixNQUFNLEdBQUcsR0FBRztJQUNWLE1BQU0sRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLGtCQUFrQjtJQUN0QyxPQUFPLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxtQkFBbUI7Q0FDekMsQ0FBQztBQUVGLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsYUFBYSxFQUFFLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztBQUV6RCxJQUFJLGNBQVcsQ0FBQyxLQUFLLEVBQUUsc0JBQXNCLEVBQUU7SUFDN0MsZUFBZSxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCO0lBQzlDLEtBQUssRUFBRTtRQUNMLGdCQUFnQixFQUFFLEdBQUcsT0FBTyxDQUFDLEdBQUcsQ0FBQyxrQkFBa0IsRUFBRTtRQUNyRCxlQUFlLEVBQUUsR0FBRyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixFQUFFO0tBQ3BEO0NBQ0YsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgRXZlbnROb3RpZnkgfSBmcm9tICcuLyc7XG5cblxuY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcblxuY29uc3QgZW52ID0ge1xuICByZWdpb246IHByb2Nlc3MuZW52LkNES19ERUZBVUxUX1JFR0lPTixcbiAgYWNjb3VudDogcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfQUNDT1VOVCxcbn07XG5cbmNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjayhhcHAsICdpbnRlZy1zdGFjaycsIHsgZW52IH0pO1xuXG5uZXcgRXZlbnROb3RpZnkoc3RhY2ssICdMaW5lc2xhY2tFdmVudE5vdGlmeScsIHtcbiAgbGluZU5vdGlmeVRva2VuOiBwcm9jZXNzLmVudi5MSU5FX05PVElGWV9UT0tFTixcbiAgc2xhY2s6IHtcbiAgICBzbGFja0NoYW5uZWxOYW1lOiBgJHtwcm9jZXNzLmVudi5TTEFDS19DSEFOTkVMX05BTUV9YCxcbiAgICBzbGFja1dlYmhvb2tVcmw6IGAke3Byb2Nlc3MuZW52LlNMQUNLX1dFQkhPT0tfVVJMfWAsXG4gIH0sXG59KTsiXX0=