from typing import Optional
from urllib.parse import urlparse, parse_qs, quote
from base64 import b64encode
from datetime import datetime, timedelta

from buptmw.constants import UCLOUD as UCLOUDE
from buptmw.plates.cas import CAS
from buptmw.plates.template import Module_Require_CAS


class Ucloud(Module_Require_CAS):
    def __init__(self, cas: Optional[CAS] = None):
        super().__init__(cas)

    def check(self):
        resp = self.get(
            UCLOUDE.CHECK,
            headers={"blade-auth": self.access_token}
        )
        if resp.status_code == 200:
            return True
        return False

    def _get_cookies(self):
        info = self.cas.get(
            UCLOUDE.INFO,
            headers={
                "Authorization": self.authorization,
                "Blade-Auth": self.access_token
            }
        ).json()["data"]
        current = self.cas.get(
            UCLOUDE.CURRENT,
            headers={
                "Authorization": self.authorization,
                "Blade-Auth": self.access_token
            }
        ).json()["data"]
        user = self.cas.get(
            UCLOUDE.USER,
            headers={
                "Authorization": self.authorization,
                "Blade-Auth": self.access_token
            }
        ).json()["data"]

        cookies = {}
        cookies["iClass-uuid"] = self.user_id
        cookies["iClass-token"] = self.access_token
        cookies["iClass-refresh_token"] = self.refresh_token
        cookies["iClass-login-meth"] = "icloud"
        cookies["iClass-expert-account"] = self.user_name
        cookies["iClass-real_name"] = quote(self.real_name)
        cookies["iClass-role_name"] = self.role_name
        cookies["iClass-avatar"] = self.avatar
        cookies["iClass-loginId"] = self.loginId
        cookies["iClass-user-info"] = quote(str(info))
        cookies["iClass-current-term"] = quote(str(current))
        cookies["iClass-identity"] = self.identity
        cookies["iClass-user-role"] = quote(str(user[0]))
        cookies["iClass-login-roles"] = quote(str(user))

        for cookie in cookies:
            self.cas.session.cookies.set(
                name=cookie,
                value=cookies[cookie],
                domain="ucloud.bupt.edu.cn",
                expires=(datetime.now() + timedelta(hours=1)).timestamp()
            )
        pass

    def _login(self):
        self.authorization = "Basic " + b64encode("portal:portal_secret".encode()).decode()
        resp = self.cas.get(UCLOUDE.LOGIN)
        self.ticket = parse_qs(urlparse(resp.url).query)["ticket"][0]
        resp = self.cas.post(
            UCLOUDE.TOKEN,
            headers={
                "Authorization": self.authorization,
            },
            data={
                "ticket": self.ticket,
                "grant_type": "third"
            }
        )
        data = resp.json()
        self.user_id = data["user_id"]
        self.access_token = data["access_token"]
        self.refresh_token = data["refresh_token"]
        self.role_name = data["role_name"]
        self.loginId = data["loginId"]
        self.user_name = data["user_name"]
        self.real_name = data["real_name"]
        self.avatar = data["avatar"]
        self.dept_id = data["dept_id"]
        self.identity = f"{self.role_name}:{self.dept_id}"
        self._get_cookies()
