# Guide Architectural et Feuille de Route

Ce document est la source de vérité pour l'architecture et le développement futur de la bibliothèque `mp-neural-network`. Son objectif est de guider les décisions pour aboutir à une bibliothèque performante, modulaire et intuitive, inspirée des meilleures pratiques des frameworks modernes comme Keras.

---

## Principes d'Architecture

1.  **Modularité** : Chaque composant (couche, optimiseur, fonction de perte) doit être indépendant et interchangeable. Le modèle orchestre ces composants mais ne contient pas leur logique interne.
2.  **Performance par Vectorisation** : Les opérations doivent être effectuées sur des lots (`batches`) de données en utilisant les capacités de calcul matriciel de NumPy. Les boucles `for` sur les échantillons sont à proscrire dans le cœur du réseau.
3.  **API Inspirée de Keras** : L'interface utilisateur doit être simple et déclarative, en séparant clairement la définition de l'architecture, la configuration de l'entraînement et l'exécution.
4.  **Tests Rigoureux** : La fiabilité de la bibliothèque repose sur une suite de tests complète, incluant des tests unitaires, des tests de forme (shape) et des vérifications de gradient.

---

## État Actuel du Projet

Voici un résumé de l'état d'avancement actuel :

*   [x] **Structure de Base Modulaire**
    *   [x] Couches (`layers`), optimiseurs (`optimizers`), et fonctions de perte (`losses`) sont dans des modules séparés.
    *   [x] La logique de mise à jour des poids est gérée par les objets `Optimizer`, et non plus par les couches.
*   [x] **Vectorisation (Partielle)**
    *   [x] La boucle d'entraînement principale opère sur des lots (`batches`).
    *   [x] Les couches `Dense`, `Reshape`, les activations et les fonctions de perte sont vectorisées.
    *   [ ] La couche `Convolutional` **n'est pas vectorisée** et reste le principal goulot d'étranglement.
*   [ ] **API du Modèle**
    *   [ ] Le `Model` utilise toujours une API d'entraînement impérative (`model.train(...)`). L'API Keras-like (`compile`/`fit`) **n'est pas implémentée**.
*   [x] **Convention sur la Forme des Données**
    *   [x] La convention `(batch_size, ...features)` est adoptée et respectée dans les composants vectorisés.
*   [x] **Optimisation `Softmax` + `CCE`**
    *   [x] La fonction de perte `CategoricalCrossentropy` est optimisée pour prendre les **logits** en entrée (elle applique la `Softmax` en interne).
    *   [ ] Le **garde-fou** pour empêcher d'utiliser cette `loss` avec une couche `Softmax` finale est manquant.
*   [ ] **Suite de Tests**
    *   [x] `pytest` est configuré.
    *   [ ] La couverture des tests est faible. Les tests de forme et la vérification de gradient sont absents.

---

## Feuille de Route Stratégique

Voici les prochaines étapes prioritaires pour faire évoluer la bibliothèque.

### 1. Finaliser l'API Keras-like du `Model`

**Priorité : Haute** - *Amélioration majeure de l'utilisabilité et de la clarté.*

-   **Quoi ?** Remplacer la méthode `train()` actuelle par un duo `compile()` et `fit()`.
    1.  **`compile(self, optimizer, loss, metrics=None)`** : Cette méthode configure le modèle. Elle stocke les instances de l'optimiseur, de la fonction de perte et des métriques. C'est ici que la logique de validation (comme la vérification `Softmax` + `CCE`) sera placée.
    2.  **`fit(self, X_train, y_train, epochs, batch_size)`** : Cette méthode exécute la boucle d'entraînement vectorisée (qui existe déjà en partie) en utilisant la configuration définie par `compile()`. Elle gère aussi l'affichage de la progression (par époque, perte, etc.).

-   **Pourquoi ?** Pour offrir une expérience utilisateur standard, réduire le nombre de paramètres passés à chaque appel d'entraînement et rendre le code plus lisible et moins sujet aux erreurs.

### 2. Optimiser la Couche `Convolutional`

**Priorité : Haute** - *Nécessaire pour rendre les modèles de type CNN réellement utilisables.*

-   **Quoi ?** Vectoriser les passes `forward` et `backward` de la couche `Convolutional` en remplaçant les boucles `for` par des opérations matricielles. La technique standard pour cela est l'algorithme `im2col` (image-to-column), qui transforme les régions de l'image en colonnes d'une matrice pour permettre une unique multiplication matricielle (GEMM).

-   **Pourquoi ?** Les boucles Python actuelles annulent tous les gains de performance de la vectorisation du reste de la bibliothèque, rendant les modèles convolutifs extrêmement lents.

### 3. Étendre et Renforcer la Suite de Tests

**Priorité : Haute** - *Essentiel pour la fiabilité et la maintenance à long terme.*

-   **Quoi ?**
    1.  **Tests de Forme (Shape Tests)** : Pour chaque couche, vérifier que les dimensions du tenseur de sortie sont correctes pour une entrée donnée. Cela garantit que les données circulent correctement dans le réseau.
    2.  **Vérification de Gradient (Gradient Checking)** : C'est le test le plus critique. Il compare le gradient calculé par la passe `backward` (analytique) avec une approximation numérique. S'ils correspondent, cela valide mathématiquement l'implémentation de la backpropagation.

-   **Pourquoi ?** Pour refactoriser et ajouter de nouvelles fonctionnalités en toute confiance, en s'assurant de ne pas introduire de régressions ou d'erreurs de calcul silencieuses.

### 4. Implémenter le Garde-fou pour `Softmax` + `CCE`

**Priorité : Moyenne** - *Amélioration de la robustesse de l'API et prévention des erreurs.*

-   **Quoi ?** Ajouter une vérification dans `model.compile()` qui lève une `ValueError` si l'utilisateur tente de combiner une couche `Softmax` finale avec la fonction de perte `CategoricalCrossentropy`. Cette dernière étant déjà optimisée pour les logits, une `Softmax` supplémentaire corromprait le calcul du gradient et les prédictions.

-   **Pourquoi ?** Pour guider l'utilisateur vers une utilisation correcte, éviter des erreurs de modélisation silencieuses et garantir la stabilité numérique des entraînements.

### 5. Ajouter des Optimiseurs Avancés

**Priorité : Basse** - *Enrichissement des fonctionnalités.*

-   **Quoi ?** Implémenter des optimiseurs populaires comme `Adam`, `RMSprop`, et `Adagrad` en héritant de la classe de base `Optimizer`. L'architecture actuelle rend cet ajout simple. Seul `SGD` est disponible pour le moment.

-   **Pourquoi ?** Pour offrir plus d'options aux utilisateurs afin d'améliorer la vitesse et la qualité de la convergence de leurs modèles.