"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import frogml._proto.qwak.administration.account.v1.account_pb2
import frogml._proto.qwak.administration.cluster.v2.cluster_pb2
import frogml._proto.qwak.administration.v0.environments.configuration_pb2
import frogml._proto.qwak.administration.v0.environments.personalization_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _QwakEnvironmentStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _QwakEnvironmentStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_QwakEnvironmentStatus.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ENVIRONMENT_STATUS_INVALID: _QwakEnvironmentStatus.ValueType  # 0
    """Default invalid State"""
    ENVIRONMENT_STATUS_ACTIVE: _QwakEnvironmentStatus.ValueType  # 1
    """Marks the environment is currently active for the linked tenant"""
    ENVIRONMENT_STATUS_DISABLED: _QwakEnvironmentStatus.ValueType  # 2
    """Marks that the environment is no longer valid"""

class QwakEnvironmentStatus(_QwakEnvironmentStatus, metaclass=_QwakEnvironmentStatusEnumTypeWrapper): ...

ENVIRONMENT_STATUS_INVALID: QwakEnvironmentStatus.ValueType  # 0
"""Default invalid State"""
ENVIRONMENT_STATUS_ACTIVE: QwakEnvironmentStatus.ValueType  # 1
"""Marks the environment is currently active for the linked tenant"""
ENVIRONMENT_STATUS_DISABLED: QwakEnvironmentStatus.ValueType  # 2
"""Marks that the environment is no longer valid"""
global___QwakEnvironmentStatus = QwakEnvironmentStatus

class _AccountTier:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AccountTierEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AccountTier.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ACCOUNT_TIER_INVALID: _AccountTier.ValueType  # 0
    """Default invalid account tier"""
    FREE: _AccountTier.ValueType  # 1
    """Free account tier"""
    VALIDATED: _AccountTier.ValueType  # 2
    """Validated account tier"""
    PAYING: _AccountTier.ValueType  # 3
    """Paying account tier"""

class AccountTier(_AccountTier, metaclass=_AccountTierEnumTypeWrapper): ...

ACCOUNT_TIER_INVALID: AccountTier.ValueType  # 0
"""Default invalid account tier"""
FREE: AccountTier.ValueType  # 1
"""Free account tier"""
VALIDATED: AccountTier.ValueType  # 2
"""Validated account tier"""
PAYING: AccountTier.ValueType  # 3
"""Paying account tier"""
global___AccountTier = AccountTier

class QwakEnvironment(google.protobuf.message.Message):
    """An environment configuration for a Qwak Tenant.
    Provides a layer of isolation / access control to for a single tenant. Can be used for modeling different lifecycle
    stages, such as - Prod, Dev, and Staging. But can also be used for separating projects and models between teams or
    organizational unit, in a way that every team / OU has its own environment.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TENANT_ID_FIELD_NUMBER: builtins.int
    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    CLUSTER_ID_FIELD_NUMBER: builtins.int
    ACCOUNT_TIER_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CONFIGURATION_FIELD_NUMBER: builtins.int
    PERSONALIZATION_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    LAST_MODIFIED_AT_FIELD_NUMBER: builtins.int
    JFROG_TENANT_ID_FIELD_NUMBER: builtins.int
    ACCOUNT_FIELD_NUMBER: builtins.int
    CLUSTER_BRIEF_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Assigned environment ID"""
    name: builtins.str
    """Given environment name"""
    tenant_id: builtins.str
    """Tenant ID which the environment is set up for (migrated to account id)"""
    account_id: builtins.str
    """Account ID which the environment is set up for (migrated to account id)"""
    cluster_id: builtins.str
    """Cluster ID which the environment is located in"""
    account_tier: global___AccountTier.ValueType
    """The account tier of the environment"""
    status: global___QwakEnvironmentStatus.ValueType
    """Current environment status"""
    @property
    def configuration(self) -> frogml._proto.qwak.administration.v0.environments.configuration_pb2.QwakEnvironmentConfiguration:
        """Environment configuration"""
    @property
    def personalization(self) -> frogml._proto.qwak.administration.v0.environments.personalization_pb2.EnvironmentPersonalization:
        """Environment personalization"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation date"""
    @property
    def last_modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Last modification date"""
    jfrog_tenant_id: builtins.str
    """The Environment's JFrog Tenant ID"""
    @property
    def account(self) -> frogml._proto.qwak.administration.account.v1.account_pb2.Account:
        """The environment's account"""
    @property
    def cluster_brief(self) -> frogml._proto.qwak.administration.cluster.v2.cluster_pb2.ClusterBrief:
        """The environment's hosting cluster brief"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        tenant_id: builtins.str = ...,
        account_id: builtins.str = ...,
        cluster_id: builtins.str = ...,
        account_tier: global___AccountTier.ValueType = ...,
        status: global___QwakEnvironmentStatus.ValueType = ...,
        configuration: frogml._proto.qwak.administration.v0.environments.configuration_pb2.QwakEnvironmentConfiguration | None = ...,
        personalization: frogml._proto.qwak.administration.v0.environments.personalization_pb2.EnvironmentPersonalization | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        jfrog_tenant_id: builtins.str = ...,
        account: frogml._proto.qwak.administration.account.v1.account_pb2.Account | None = ...,
        cluster_brief: frogml._proto.qwak.administration.cluster.v2.cluster_pb2.ClusterBrief | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["account", b"account", "cluster_brief", b"cluster_brief", "configuration", b"configuration", "created_at", b"created_at", "jfrog_tenant_id", b"jfrog_tenant_id", "last_modified_at", b"last_modified_at", "optional_jfrog_tenant_id", b"optional_jfrog_tenant_id", "personalization", b"personalization"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "account_id", b"account_id", "account_tier", b"account_tier", "cluster_brief", b"cluster_brief", "cluster_id", b"cluster_id", "configuration", b"configuration", "created_at", b"created_at", "id", b"id", "jfrog_tenant_id", b"jfrog_tenant_id", "last_modified_at", b"last_modified_at", "name", b"name", "optional_jfrog_tenant_id", b"optional_jfrog_tenant_id", "personalization", b"personalization", "status", b"status", "tenant_id", b"tenant_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["optional_jfrog_tenant_id", b"optional_jfrog_tenant_id"]) -> typing_extensions.Literal["jfrog_tenant_id"] | None: ...

global___QwakEnvironment = QwakEnvironment

class EnvironmentApplicationUserCredentials(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_KEY_FIELD_NUMBER: builtins.int
    api_key: builtins.str
    """The API key which authenticate as environment application user"""
    def __init__(
        self,
        *,
        api_key: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["api_key", b"api_key"]) -> None: ...

global___EnvironmentApplicationUserCredentials = EnvironmentApplicationUserCredentials
