# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.6.4
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from authentik_client.models.auth_mode_enum import AuthModeEnum
from authentik_client.models.protocol_enum import ProtocolEnum
from typing import Optional, Set
from typing_extensions import Self

class EndpointRequest(BaseModel):
    """
    Endpoint Serializer
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True)]
    provider: StrictInt
    protocol: ProtocolEnum
    host: Annotated[str, Field(min_length=1, strict=True)]
    settings: Optional[Dict[str, Any]] = None
    property_mappings: Optional[List[StrictStr]] = None
    auth_mode: AuthModeEnum
    maximum_connections: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=-2147483648)]] = None
    __properties: ClassVar[List[str]] = ["name", "provider", "protocol", "host", "settings", "property_mappings", "auth_mode", "maximum_connections"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EndpointRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EndpointRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "provider": obj.get("provider"),
            "protocol": obj.get("protocol"),
            "host": obj.get("host"),
            "settings": obj.get("settings"),
            "property_mappings": obj.get("property_mappings"),
            "auth_mode": obj.get("auth_mode"),
            "maximum_connections": obj.get("maximum_connections")
        })
        return _obj


