# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.6.4
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from authentik_client.models.notification_transport_mode_enum import NotificationTransportModeEnum
from typing import Optional, Set
from typing_extensions import Self

class NotificationTransportRequest(BaseModel):
    """
    NotificationTransport Serializer
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True)]
    mode: Optional[NotificationTransportModeEnum] = None
    webhook_url: Optional[StrictStr] = None
    webhook_mapping_body: Optional[StrictStr] = Field(default=None, description="Customize the body of the request. Mapping should return data that is JSON-serializable.")
    webhook_mapping_headers: Optional[StrictStr] = Field(default=None, description="Configure additional headers to be sent. Mapping should return a dictionary of key-value pairs")
    send_once: Optional[StrictBool] = Field(default=None, description="Only send notification once, for example when sending a webhook into a chat channel.")
    __properties: ClassVar[List[str]] = ["name", "mode", "webhook_url", "webhook_mapping_body", "webhook_mapping_headers", "send_once"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NotificationTransportRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if webhook_mapping_body (nullable) is None
        # and model_fields_set contains the field
        if self.webhook_mapping_body is None and "webhook_mapping_body" in self.model_fields_set:
            _dict['webhook_mapping_body'] = None

        # set to None if webhook_mapping_headers (nullable) is None
        # and model_fields_set contains the field
        if self.webhook_mapping_headers is None and "webhook_mapping_headers" in self.model_fields_set:
            _dict['webhook_mapping_headers'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NotificationTransportRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "mode": obj.get("mode"),
            "webhook_url": obj.get("webhook_url"),
            "webhook_mapping_body": obj.get("webhook_mapping_body"),
            "webhook_mapping_headers": obj.get("webhook_mapping_headers"),
            "send_once": obj.get("send_once")
        })
        return _obj


