# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.6.4
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List
from authentik_client.models.system_info_runtime import SystemInfoRuntime
from typing import Optional, Set
from typing_extensions import Self

class SystemInfo(BaseModel):
    """
    Get system information.
    """ # noqa: E501
    http_headers: Dict[str, StrictStr] = Field(description="Get HTTP Request headers")
    http_host: StrictStr = Field(description="Get HTTP host")
    http_is_secure: StrictBool = Field(description="Get HTTP Secure flag")
    runtime: SystemInfoRuntime
    brand: StrictStr = Field(description="Currently active brand")
    server_time: datetime = Field(description="Current server time")
    embedded_outpost_disabled: StrictBool = Field(description="Whether the embedded outpost is disabled")
    embedded_outpost_host: StrictStr = Field(description="Get the FQDN configured on the embedded outpost")
    __properties: ClassVar[List[str]] = ["http_headers", "http_host", "http_is_secure", "runtime", "brand", "server_time", "embedded_outpost_disabled", "embedded_outpost_host"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SystemInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "http_headers",
            "http_host",
            "http_is_secure",
            "brand",
            "server_time",
            "embedded_outpost_disabled",
            "embedded_outpost_host",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of runtime
        if self.runtime:
            _dict['runtime'] = self.runtime.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SystemInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "http_headers": obj.get("http_headers"),
            "http_host": obj.get("http_host"),
            "http_is_secure": obj.get("http_is_secure"),
            "runtime": SystemInfoRuntime.from_dict(obj["runtime"]) if obj.get("runtime") is not None else None,
            "brand": obj.get("brand"),
            "server_time": obj.get("server_time"),
            "embedded_outpost_disabled": obj.get("embedded_outpost_disabled"),
            "embedded_outpost_host": obj.get("embedded_outpost_host")
        })
        return _obj


