"""Add dumps to ApplyWorkflow

Revision ID: 84bf0fffde30
Revises: 99ea79d9e5d2
Create Date: 2023-10-26 16:11:44.061971

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "84bf0fffde30"
down_revision = "99ea79d9e5d2"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("applyworkflow", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "user_email",
                sa.String(),
                server_default="__UNDEFINED__",
                nullable=False,
            )
        )
        batch_op.add_column(
            sa.Column(
                "input_dataset_dump",
                sa.JSON(),
                server_default="{}",
                nullable=False,
            )
        )
        batch_op.add_column(
            sa.Column(
                "output_dataset_dump",
                sa.JSON(),
                server_default="{}",
                nullable=False,
            )
        )

        batch_op.alter_column(
            "project_id", existing_type=sa.INTEGER(), nullable=True
        )
        batch_op.alter_column(
            "workflow_id", existing_type=sa.INTEGER(), nullable=True
        )
        batch_op.alter_column(
            "input_dataset_id", existing_type=sa.INTEGER(), nullable=True
        )
        batch_op.alter_column(
            "output_dataset_id", existing_type=sa.INTEGER(), nullable=True
        )

    with op.batch_alter_table("applyworkflow", schema=None) as batch_op:
        batch_op.alter_column("user_email", server_default=None)
        batch_op.alter_column("input_dataset_dump", server_default=None)
        batch_op.alter_column("output_dataset_dump", server_default=None)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("applyworkflow", schema=None) as batch_op:
        batch_op.alter_column(
            "output_dataset_id", existing_type=sa.INTEGER(), nullable=False
        )
        batch_op.alter_column(
            "input_dataset_id", existing_type=sa.INTEGER(), nullable=False
        )
        batch_op.alter_column(
            "workflow_id", existing_type=sa.INTEGER(), nullable=False
        )
        batch_op.alter_column(
            "project_id", existing_type=sa.INTEGER(), nullable=False
        )
        batch_op.drop_column("output_dataset_dump")
        batch_op.drop_column("input_dataset_dump")
        batch_op.drop_column("user_email")

    # ### end Alembic commands ###
