"""remove cache_dir slurm_user and slurm_accounts from user

Revision ID: 94a47ea2d3ff
Revises: 9c5ae74c9b98
Create Date: 2024-09-25 09:33:18.014831

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "94a47ea2d3ff"
down_revision = "9c5ae74c9b98"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("user_oauth", schema=None) as batch_op:
        batch_op.drop_column("slurm_user")
        batch_op.drop_column("slurm_accounts")
        batch_op.drop_column("cache_dir")

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("user_oauth", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "cache_dir", sa.VARCHAR(), autoincrement=False, nullable=True
            )
        )
        batch_op.add_column(
            sa.Column(
                "slurm_accounts",
                postgresql.JSON(astext_type=sa.Text()),
                server_default=sa.text("'[]'::json"),
                autoincrement=False,
                nullable=False,
            )
        )
        batch_op.add_column(
            sa.Column(
                "slurm_user", sa.VARCHAR(), autoincrement=False, nullable=True
            )
        )

    # ### end Alembic commands ###
