"""Set ondelete

Revision ID: 9db60297b8b2
Revises: e81103413827
Create Date: 2025-04-07 13:13:14.596394

"""
from alembic import op


# revision identifiers, used by Alembic.
revision = "9db60297b8b2"
down_revision = "e81103413827"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("datasetv2", schema=None) as batch_op:
        batch_op.drop_constraint(
            "fk_datasetv2_project_id_projectv2", type_="foreignkey"
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_datasetv2_project_id_projectv2"),
            "projectv2",
            ["project_id"],
            ["id"],
            ondelete="CASCADE",
        )

    with op.batch_alter_table("jobv2", schema=None) as batch_op:
        batch_op.drop_constraint(
            "fk_jobv2_dataset_id_datasetv2", type_="foreignkey"
        )
        batch_op.drop_constraint(
            "fk_jobv2_project_id_projectv2", type_="foreignkey"
        )
        batch_op.drop_constraint(
            "fk_jobv2_workflow_id_workflowv2", type_="foreignkey"
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_jobv2_workflow_id_workflowv2"),
            "workflowv2",
            ["workflow_id"],
            ["id"],
            ondelete="SET NULL",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_jobv2_dataset_id_datasetv2"),
            "datasetv2",
            ["dataset_id"],
            ["id"],
            ondelete="SET NULL",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_jobv2_project_id_projectv2"),
            "projectv2",
            ["project_id"],
            ["id"],
            ondelete="SET NULL",
        )

    with op.batch_alter_table("linkusergroup", schema=None) as batch_op:
        batch_op.drop_constraint(
            "fk_linkusergroup_user_id_user_oauth", type_="foreignkey"
        )
        batch_op.drop_constraint(
            "fk_linkusergroup_group_id_usergroup", type_="foreignkey"
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_linkusergroup_group_id_usergroup"),
            "usergroup",
            ["group_id"],
            ["id"],
            ondelete="CASCADE",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_linkusergroup_user_id_user_oauth"),
            "user_oauth",
            ["user_id"],
            ["id"],
            ondelete="CASCADE",
        )

    with op.batch_alter_table("taskgroupactivityv2", schema=None) as batch_op:
        batch_op.drop_constraint(
            "fk_taskgroupactivityv2_taskgroupv2_id_taskgroupv2",
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_taskgroupactivityv2_taskgroupv2_id_taskgroupv2"),
            "taskgroupv2",
            ["taskgroupv2_id"],
            ["id"],
            ondelete="SET NULL",
        )

    with op.batch_alter_table("taskgroupv2", schema=None) as batch_op:
        batch_op.drop_constraint(
            "fk_taskgroupv2_user_group_id_usergroup", type_="foreignkey"
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_taskgroupv2_user_group_id_usergroup"),
            "usergroup",
            ["user_group_id"],
            ["id"],
            ondelete="SET NULL",
        )

    with op.batch_alter_table("workflowtaskv2", schema=None) as batch_op:
        batch_op.drop_constraint(
            "fk_workflowtaskv2_workflow_id_workflowv2", type_="foreignkey"
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_workflowtaskv2_workflow_id_workflowv2"),
            "workflowv2",
            ["workflow_id"],
            ["id"],
            ondelete="CASCADE",
        )

    with op.batch_alter_table("workflowv2", schema=None) as batch_op:
        batch_op.drop_constraint(
            "fk_workflowv2_project_id_projectv2", type_="foreignkey"
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_workflowv2_project_id_projectv2"),
            "projectv2",
            ["project_id"],
            ["id"],
            ondelete="CASCADE",
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("workflowv2", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_workflowv2_project_id_projectv2"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            "fk_workflowv2_project_id_projectv2",
            "projectv2",
            ["project_id"],
            ["id"],
        )

    with op.batch_alter_table("workflowtaskv2", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_workflowtaskv2_workflow_id_workflowv2"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            "fk_workflowtaskv2_workflow_id_workflowv2",
            "workflowv2",
            ["workflow_id"],
            ["id"],
        )

    with op.batch_alter_table("taskgroupv2", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_taskgroupv2_user_group_id_usergroup"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            "fk_taskgroupv2_user_group_id_usergroup",
            "usergroup",
            ["user_group_id"],
            ["id"],
        )

    with op.batch_alter_table("taskgroupactivityv2", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_taskgroupactivityv2_taskgroupv2_id_taskgroupv2"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            "fk_taskgroupactivityv2_taskgroupv2_id_taskgroupv2",
            "taskgroupv2",
            ["taskgroupv2_id"],
            ["id"],
        )

    with op.batch_alter_table("linkusergroup", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_linkusergroup_user_id_user_oauth"),
            type_="foreignkey",
        )
        batch_op.drop_constraint(
            batch_op.f("fk_linkusergroup_group_id_usergroup"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            "fk_linkusergroup_group_id_usergroup",
            "usergroup",
            ["group_id"],
            ["id"],
        )
        batch_op.create_foreign_key(
            "fk_linkusergroup_user_id_user_oauth",
            "user_oauth",
            ["user_id"],
            ["id"],
        )

    with op.batch_alter_table("jobv2", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_jobv2_project_id_projectv2"), type_="foreignkey"
        )
        batch_op.drop_constraint(
            batch_op.f("fk_jobv2_dataset_id_datasetv2"), type_="foreignkey"
        )
        batch_op.drop_constraint(
            batch_op.f("fk_jobv2_workflow_id_workflowv2"), type_="foreignkey"
        )
        batch_op.create_foreign_key(
            "fk_jobv2_workflow_id_workflowv2",
            "workflowv2",
            ["workflow_id"],
            ["id"],
        )
        batch_op.create_foreign_key(
            "fk_jobv2_project_id_projectv2",
            "projectv2",
            ["project_id"],
            ["id"],
        )
        batch_op.create_foreign_key(
            "fk_jobv2_dataset_id_datasetv2",
            "datasetv2",
            ["dataset_id"],
            ["id"],
        )

    with op.batch_alter_table("datasetv2", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_datasetv2_project_id_projectv2"), type_="foreignkey"
        )
        batch_op.create_foreign_key(
            "fk_datasetv2_project_id_projectv2",
            "projectv2",
            ["project_id"],
            ["id"],
        )

    # ### end Alembic commands ###
